/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.screen.eq.drive;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.nativetransport.TransportCloseListener;
import com.wovoe.nativetransport.TransportUtil;
import com.wovoe.screen.eq.drive.sdk.EQ2008LibraryFactory;
import com.wovoe.screen.eq.drive.sdk.User_FontSet;
import com.wovoe.screen.eq.drive.sdk.User_MoveSet;
import com.wovoe.screen.eq.drive.sdk.User_PartInfo;
import com.wovoe.screen.eq.drive.sdk.User_SingleText;
import com.wovoe.screen.eq.drive.sdk.User_Text;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class EQAction
implements ServiceAction,
TransportCloseListener {
    public static final String ACTION_NAME = "/EQAction";
    private static Map<String, Method> methodsMap;
    private volatile List<String> iniPop;
    private static Pointer defaultFontName;
    private static Object lock;
    private final LinkedBlockingQueue<Object> queue;
    private Thread runThread;
    private volatile boolean closed;
    private ConcurrentHashMap<String, EQWrap> eqWrapsMap = new ConcurrentHashMap();

    static {
        byte[] daa;
        methodsMap = new HashMap<String, Method>();
        defaultFontName = null;
        lock = new Object();
        String fontNa = "\u5b8b\u4f53\u0000";
        try {
            daa = fontNa.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            daa = fontNa.getBytes();
        }
        Memory fm = new Memory((long)daa.length);
        fm.write(0L, daa, 0, daa.length);
        defaultFontName = fm;
        Method[] mehtods = EQAction.class.getMethods();
        String service = "service";
        Method[] methodArray = mehtods;
        int n = mehtods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            String name = m.getName();
            Class<?>[] cls = m.getParameterTypes();
            if (cls != null && cls.length == 1 && Receiver.class.equals(cls[0]) && !service.equals(name)) {
                methodsMap.put(name, m);
            }
            ++n2;
        }
    }

    public EQAction() {
        this.queue = new LinkedBlockingQueue();
        this.runThread = new Thread(new Runnable(){

            @Override
            public void run() {
                EQAction.this.executeRun();
            }
        });
        this.runThread.start();
        TransportUtil.addTransportCloseListener((TransportCloseListener)this);
    }

    /*
     * Exception decompiling
     */
    private void executeRun() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void service(Receiver request) throws Exception {
        if (this.closed) {
            return;
        }
        String op = request.getHeaderValue("op");
        if (op == null || op.length() == 0) {
            this.responseError(request, "\u7f3a\u5c11op!", null);
            return;
        }
        try {
            Method method = methodsMap.get(op);
            if (method == null) {
                this.responseError(request, "\u65e0\u6548op: " + op, null);
                return;
            }
            this.queue.offer(request);
        }
        catch (Throwable e) {
            TransportUtil.getLog().error((Object)"\u6267\u884c\u52a8\u4f5c\u5f02\u5e38!", e);
        }
    }

    private void responseError(Receiver request, String message, Throwable e) {
        try {
            String e1;
            ResponseSender response = request.createResponse();
            response.setHeader("result", "error");
            if (message != null && message.length() > 0) {
                response.setHeader("msg", message);
            }
            if (e != null && (e1 = e.getMessage()) != null && e1.length() > 0) {
                response.setHeader("msg1", e1);
            }
            response.doResponse(null, null);
        }
        catch (IOException e1) {
            TransportUtil.getLog().error((Object)"", (Throwable)e1);
        }
    }

    public void init(Receiver request) {
        String eqIds = request.getHeaderValue("eqIds");
        if (eqIds == null || eqIds.length() == 0) {
            this.responseError(request, "\u7f3a\u5c11\u53c2\u6570eqIds!", null);
            return;
        }
        String[] _eqids = eqIds.split(",");
        LinkedList<EQWrap> eqList = new LinkedList<EQWrap>();
        int index = 0;
        TreeSet<String> idset = new TreeSet<String>();
        String[] stringArray = _eqids;
        int n = _eqids.length;
        int n2 = 0;
        while (n2 < n) {
            String _eqid = stringArray[n2];
            if ((_eqid = _eqid.trim()).length() != 0) {
                idset.add(_eqid);
            }
            ++n2;
        }
        for (String _eqid : idset) {
            String communicationMode;
            String netPort;
            String serialNum;
            String serialBaud;
            String colorStyle;
            String cardType;
            String screemHeight;
            String screemWidth;
            EQWrap wrap = new EQWrap(_eqid, String.valueOf(index++));
            String ip = request.getHeaderValue("ip_" + _eqid);
            if (ip != null && (ip = ip.trim()).length() > 0) {
                wrap.setIP(ip);
            }
            if ((screemWidth = request.getHeaderValue("screemWidth_" + _eqid)) != null && (screemWidth = screemWidth.trim()).length() > 0) {
                try {
                    Integer.parseInt(screemWidth);
                    wrap.screemWidth = screemWidth;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((screemHeight = request.getHeaderValue("screemHeight_" + _eqid)) != null && (screemHeight = screemHeight.trim()).length() > 0) {
                try {
                    Integer.parseInt(screemHeight);
                    wrap.screemHeight = screemHeight;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((cardType = request.getHeaderValue("cardType_" + _eqid)) != null && (cardType = cardType.trim()).length() > 0) {
                try {
                    Integer.parseInt(cardType);
                    wrap.cardType = cardType;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((colorStyle = request.getHeaderValue("colorStyle_" + _eqid)) != null && (colorStyle = colorStyle.trim()).length() > 0) {
                try {
                    Integer.parseInt(colorStyle);
                    wrap.colorStyle = colorStyle;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((serialBaud = request.getHeaderValue("serialBaud_" + _eqid)) != null && (serialBaud = serialBaud.trim()).length() > 0) {
                try {
                    Integer.parseInt(serialBaud);
                    wrap.serialBaud = serialBaud;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((serialNum = request.getHeaderValue("serialNum_" + _eqid)) != null && (serialNum = serialNum.trim()).length() > 0) {
                try {
                    Integer.parseInt(serialNum);
                    wrap.serialNum = serialNum;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((netPort = request.getHeaderValue("netPort_" + _eqid)) != null && (netPort = netPort.trim()).length() > 0) {
                try {
                    Integer.parseInt(netPort);
                    wrap.netPort = netPort;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((communicationMode = request.getHeaderValue("communicationMode_" + _eqid)) != null && (communicationMode = communicationMode.trim()).length() > 0) {
                try {
                    Integer.parseInt(communicationMode);
                    wrap.communicationMode = communicationMode;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            eqList.add(wrap);
        }
        String errMsg = null;
        List<String> configList = EQAction.createIni(eqList);
        if (this.iniPop == null || !configList.equals(this.iniPop)) {
            int i = 0;
            while (i < 1) {
                if (this.iniPop == null || !configList.equals(this.iniPop)) {
                    File f = EQ2008LibraryFactory.getIniFile();
                    try {
                        EQAction.writeIni(configList, f);
                    }
                    catch (Exception ex) {
                        this.eqWrapsMap.clear();
                        errMsg = "\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5931\u8d25!" + ex.getMessage();
                        break;
                    }
                    try {
                        EQ2008LibraryFactory.getSDKLibrary().User_ReloadIniFile(f.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        this.eqWrapsMap.clear();
                        errMsg = "\u8c03\u7528SDK\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25!" + ex.getMessage();
                        break;
                    }
                    this.iniPop = configList;
                    this.eqWrapsMap.clear();
                    for (EQWrap w : eqList) {
                        this.eqWrapsMap.put(w.eqId, w);
                    }
                }
                ++i;
            }
        }
        if (errMsg != null) {
            this.responseError(request, errMsg, null);
        } else {
            try {
                ResponseSender response = request.createResponse();
                response.setHeader("eqIds", eqIds);
                response.setHeader("result", "true");
                response.doResponse(null, null);
            }
            catch (IOException e) {
                TransportUtil.getLog().error((Object)"", (Throwable)e);
            }
        }
    }

    private int getIntValue(Receiver request, String key, int defautValue) {
        try {
            String v = request.getHeaderValue(key);
            if (v == null) {
                return defautValue;
            }
            return Integer.parseInt(v);
        }
        catch (Exception ex) {
            return defautValue;
        }
    }

    public void clearAllProgram(Receiver request) throws Exception {
        String eqId = request.getHeaderValue("eqId");
        if (eqId == null || eqId.length() == 0) {
            this.responseError(request, "\u7f3a\u5c11\u53c2\u6570eqId!", null);
            return;
        }
        EQWrap wrap = this.eqWrapsMap.get(eqId);
        if (wrap == null) {
            this.responseError(request, "\u8bbe\u5907\u672a\u521d\u59cb\u5316! eqId:" + eqId, null);
            return;
        }
        boolean success = false;
        try {
            int cardNum = Integer.parseInt(wrap.cardAddress) + 1;
            if (cardNum <= 0) {
                throw new Exception("\u9519\u8bef\u7684cardNum!" + cardNum);
            }
            success = EQ2008LibraryFactory.getSDKLibrary().User_DelAllProgram(cardNum);
        }
        catch (Throwable ex) {
            this.responseError(request, String.valueOf(wrap.ip) + "\u663e\u793a\u5931\u8d25!\u539f\u56e0" + ex.getMessage(), null);
            return;
        }
        try {
            ResponseSender response = request.createResponse();
            response.setHeader("eqId", eqId);
            response.setHeader("result", success ? "true" : "false");
            response.doResponse(null, null);
        }
        catch (IOException e) {
            TransportUtil.getLog().error((Object)"", (Throwable)e);
        }
    }

    public void diplayAll(Receiver request) throws Exception {
        String eqId;
        block43: {
            int displayCount;
            eqId = request.getHeaderValue("eqId");
            if (eqId == null || eqId.length() == 0) {
                this.responseError(request, "\u7f3a\u5c11\u53c2\u6570eqId!", null);
                return;
            }
            EQWrap wrap = this.eqWrapsMap.get(eqId);
            if (wrap == null) {
                this.responseError(request, "\u8bbe\u5907\u672a\u521d\u59cb\u5316! eqId:" + eqId, null);
                return;
            }
            String _displayCount = request.getHeaderValue("displayCount");
            if (_displayCount == null || _displayCount.length() == 0) {
                this.responseError(request, "\u7f3a\u5c11\u53c2\u6570displayCount", null);
                return;
            }
            try {
                displayCount = Integer.parseInt(_displayCount);
            }
            catch (Exception ex) {
                this.responseError(request, "displayCount\u9519\u8bef\uff0c\u4e0d\u662f\u6574\u6570", null);
                return;
            }
            if (displayCount <= 0) {
                this.responseError(request, "displayCount\u9519\u8bef,\u5fc5\u987b\u5927\u4e8e0", null);
                return;
            }
            String playType = request.getHeaderValue("playType");
            try {
                int iProgramIndex0;
                boolean del;
                int cardNum = Integer.parseInt(wrap.cardAddress) + 1;
                if (cardNum <= 0) {
                    throw new Exception("\u9519\u8bef\u7684cardNum!" + cardNum);
                }
                if (!wrap.opened) {
                    boolean b = EQ2008LibraryFactory.getSDKLibrary().User_OpenScreen(cardNum);
                    if (!b) {
                        throw new Exception("\u6253\u5f00\u663e\u793a\u5c4f\u5931\u8d25!");
                    }
                    wrap.opened = true;
                }
                if ("1".equals(playType)) {
                    boolean a;
                    if (wrap.needClearRealTime.booleanValue()) {
                        boolean suc = EQ2008LibraryFactory.getSDKLibrary().User_RealtimeScreenClear(cardNum);
                        if (!suc) {
                            throw new Exception("\u6e05\u5c4f\u5931\u8d25");
                        }
                        wrap.needClearRealTime = false;
                    }
                    if (!(a = EQ2008LibraryFactory.getSDKLibrary().User_RealtimeConnect(cardNum))) {
                        throw new Exception("\u65e0\u6cd5\u521b\u5efa\u8fde\u63a5!");
                    }
                    try {
                        int i = 0;
                        while (i < displayCount) {
                            String text0 = request.getHeaderValue("text" + i);
                            String fontSize = request.getHeaderValue("fontSize" + i);
                            int x = this.getIntValue(request, "x" + i, 0);
                            int y = this.getIntValue(request, "y" + i, 0);
                            int w = this.getIntValue(request, "w" + i, Integer.parseInt(wrap.screemWidth));
                            int h = this.getIntValue(request, "h" + i, Integer.parseInt(wrap.screemHeight));
                            User_FontSet FontInfo = new User_FontSet();
                            FontInfo.colorFont = 0xFFFFFF;
                            FontInfo.iAlignStyle = 1;
                            FontInfo.iVAlignerStyle = 1;
                            if (fontSize != null) {
                                FontInfo.iFontSize = Integer.parseInt(fontSize);
                            }
                            FontInfo.strFontName = defaultFontName;
                            byte[] buf = (String.valueOf(text0 == null ? "" : text0) + "\u0000").getBytes("GBK");
                            Memory menory = new Memory((long)buf.length);
                            menory.write(0L, buf, 0, buf.length);
                            a = EQ2008LibraryFactory.getSDKLibrary().User_RealtimeSendText(cardNum, x, y, w, h, (Pointer)menory, FontInfo);
                            if (!a) {
                                throw new Exception("\u53d1\u9001\u6587\u672c\u4fe1\u606f\u5931\u8d25\uff0c\u6587\u672c\uff1a" + text0);
                            }
                            ++i;
                        }
                        break block43;
                    }
                    finally {
                        a = EQ2008LibraryFactory.getSDKLibrary().User_RealtimeDisConnect(cardNum);
                        if (!a) {
                            TransportUtil.getLog().warn((Object)"\u5173\u95ed\u5b9e\u65f6\u53d1\u9001\u6570\u636e\u8fde\u63a5\u5931\u8d25\uff01");
                        }
                    }
                }
                if (!wrap.needClearRealTime.booleanValue()) {
                    EQ2008LibraryFactory.getSDKLibrary().User_RealtimeScreenClear(cardNum);
                    wrap.needClearRealTime = true;
                }
                if (!(del = EQ2008LibraryFactory.getSDKLibrary().User_DelAllProgram(cardNum))) {
                    TransportUtil.getLog().warn((Object)("\u5220\u9664\u8282\u76ee\u8fd4\u56de\u5931\u8d25\uff01" + wrap.ip));
                }
                if ((iProgramIndex0 = EQ2008LibraryFactory.getSDKLibrary().User_AddProgram(cardNum, false, 0)) < 0) {
                    throw new Exception("\u6dfb\u52a0\u8282\u76ee\u5931\u8d25!");
                }
                int i = 0;
                while (i < displayCount) {
                    int result;
                    Structure pSingleText;
                    String text0 = request.getHeaderValue("text" + i);
                    String actionType = request.getHeaderValue("actionType" + i);
                    String speed = request.getHeaderValue("speed" + i);
                    String fontSize = request.getHeaderValue("fontSize" + i);
                    int x = this.getIntValue(request, "x" + i, 0);
                    int y = this.getIntValue(request, "y" + i, 0);
                    int w = this.getIntValue(request, "w" + i, Integer.parseInt(wrap.screemWidth));
                    int h = this.getIntValue(request, "h" + i, Integer.parseInt(wrap.screemHeight));
                    String text = text0;
                    if (text == null) {
                        text = "";
                    }
                    User_MoveSet MoveSet = new User_MoveSet();
                    int iActionType = 2;
                    if (actionType != null && actionType.length() > 0) {
                        try {
                            iActionType = Integer.parseInt(actionType);
                            if (iActionType < 0) {
                                iActionType = 2;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    MoveSet.iActionType = iActionType;
                    int iActionSpeed = 1;
                    if (speed != null && speed.length() > 0) {
                        try {
                            iActionSpeed = Integer.parseInt(speed);
                            if (iActionSpeed < 0) {
                                iActionSpeed = 1;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    MoveSet.iActionSpeed = iActionSpeed;
                    MoveSet.iClearSpeed = iActionSpeed;
                    byte[] buf = (String.valueOf(text) + "\u0000").getBytes("GBK");
                    Memory menory = new Memory((long)buf.length);
                    menory.write(0L, buf, 0, buf.length);
                    User_PartInfo partInfo = new User_PartInfo();
                    partInfo.iWidth = w;
                    partInfo.iHeight = h;
                    partInfo.iX = x;
                    partInfo.iY = y;
                    User_FontSet FontInfo = new User_FontSet();
                    FontInfo.colorFont = 0xFFFFFF;
                    FontInfo.iAlignStyle = 1;
                    FontInfo.iVAlignerStyle = 1;
                    if (fontSize != null) {
                        FontInfo.iFontSize = Integer.parseInt(fontSize);
                    }
                    FontInfo.strFontName = defaultFontName;
                    if ("2".equals(playType)) {
                        pSingleText = new User_SingleText();
                        pSingleText.FontInfo = FontInfo;
                        pSingleText.PartInfo = partInfo;
                        pSingleText.MoveSet = MoveSet;
                        pSingleText.chContent = menory;
                        result = EQ2008LibraryFactory.getSDKLibrary().User_AddSingleText(cardNum, (User_SingleText)pSingleText, iProgramIndex0);
                        if (result < 0) {
                            throw new Exception("\u6dfb\u52a0\u5355\u884c\u6587\u672c\u8fd4\u56de\u9519\u8bef!" + result);
                        }
                    } else {
                        pSingleText = new User_Text();
                        pSingleText.FontInfo = FontInfo;
                        pSingleText.PartInfo = partInfo;
                        pSingleText.MoveSet = MoveSet;
                        pSingleText.chContent = menory;
                        result = EQ2008LibraryFactory.getSDKLibrary().User_AddText(cardNum, (User_Text)pSingleText, iProgramIndex0);
                        if (result < 0) {
                            throw new Exception("\u6dfb\u52a0\u6587\u672c\u8fd4\u56de\u9519\u8bef!" + result);
                        }
                    }
                    ++i;
                }
                boolean b = EQ2008LibraryFactory.getSDKLibrary().User_SendToScreen(cardNum);
                if (!b) {
                    wrap.opened = false;
                    throw new Exception("\u53d1\u9001\u6587\u672c\u6d88\u606f\u8fd4\u56de\u5931\u8d25!");
                }
            }
            catch (Throwable ex) {
                this.responseError(request, String.valueOf(wrap.ip) + "\u663e\u793a\u5931\u8d25!\u539f\u56e0" + ex.getMessage(), null);
                return;
            }
        }
        try {
            ResponseSender response = request.createResponse();
            response.setHeader("eqId", eqId);
            response.setHeader("result", "true");
            response.doResponse(null, null);
        }
        catch (IOException e) {
            TransportUtil.getLog().error((Object)"", (Throwable)e);
        }
    }

    public void diplay(Receiver request) throws Exception {
        boolean success;
        String eqId;
        block37: {
            eqId = request.getHeaderValue("eqId");
            if (eqId == null || eqId.length() == 0) {
                this.responseError(request, "\u7f3a\u5c11\u53c2\u6570eqId!", null);
                return;
            }
            EQWrap wrap = this.eqWrapsMap.get(eqId);
            if (wrap == null) {
                this.responseError(request, "\u8bbe\u5907\u672a\u521d\u59cb\u5316! eqId:" + eqId, null);
                return;
            }
            success = false;
            try {
                boolean b;
                Structure pSingleText;
                int iProgramIndex0;
                boolean del;
                String text0 = request.getHeaderValue("text");
                String actionType = request.getHeaderValue("actionType");
                String speed = request.getHeaderValue("speed");
                String playType = request.getHeaderValue("playType");
                String fontSize = request.getHeaderValue("fontSize");
                int x = this.getIntValue(request, "x", 0);
                int y = this.getIntValue(request, "y", 0);
                int w = this.getIntValue(request, "w", Integer.parseInt(wrap.screemWidth));
                int h = this.getIntValue(request, "h", Integer.parseInt(wrap.screemHeight));
                int cardNum = Integer.parseInt(wrap.cardAddress) + 1;
                if (cardNum <= 0) {
                    throw new Exception("\u9519\u8bef\u7684cardNum!" + cardNum);
                }
                if (!wrap.opened) {
                    boolean b2 = EQ2008LibraryFactory.getSDKLibrary().User_OpenScreen(cardNum);
                    if (!b2) {
                        throw new Exception("\u6253\u5f00\u663e\u793a\u5c4f\u5931\u8d25!");
                    }
                    wrap.opened = true;
                }
                if ("1".equals(playType)) {
                    boolean a;
                    if (wrap.needClearRealTime.booleanValue()) {
                        boolean suc = EQ2008LibraryFactory.getSDKLibrary().User_RealtimeScreenClear(cardNum);
                        if (!suc) {
                            throw new Exception("\u6e05\u5c4f\u5931\u8d25");
                        }
                        wrap.needClearRealTime = false;
                    }
                    if (!(a = EQ2008LibraryFactory.getSDKLibrary().User_RealtimeConnect(cardNum))) {
                        throw new Exception("\u65e0\u6cd5\u521b\u5efa\u8fde\u63a5!");
                    }
                    try {
                        User_FontSet FontInfo = new User_FontSet();
                        FontInfo.colorFont = 0xFFFFFF;
                        FontInfo.iAlignStyle = 1;
                        FontInfo.iVAlignerStyle = 1;
                        if (fontSize != null) {
                            FontInfo.iFontSize = Integer.parseInt(fontSize);
                        }
                        FontInfo.strFontName = defaultFontName;
                        byte[] buf = (String.valueOf(text0 == null ? "" : text0) + "\u0000").getBytes("GBK");
                        Memory menory = new Memory((long)buf.length);
                        menory.write(0L, buf, 0, buf.length);
                        a = EQ2008LibraryFactory.getSDKLibrary().User_RealtimeSendText(cardNum, x, y, w, h, (Pointer)menory, FontInfo);
                        if (!a) {
                            throw new Exception("\u53d1\u9001\u6587\u672c\u4fe1\u606f\u5931\u8d25\uff0c\u6587\u672c\uff1a" + text0);
                        }
                        success = a;
                        break block37;
                    }
                    finally {
                        a = EQ2008LibraryFactory.getSDKLibrary().User_RealtimeDisConnect(cardNum);
                        if (!a) {
                            TransportUtil.getLog().warn((Object)"\u5173\u95ed\u5b9e\u65f6\u53d1\u9001\u6570\u636e\u8fde\u63a5\u5931\u8d25\uff01");
                        }
                    }
                }
                if (!wrap.needClearRealTime.booleanValue()) {
                    EQ2008LibraryFactory.getSDKLibrary().User_RealtimeScreenClear(cardNum);
                    wrap.needClearRealTime = true;
                }
                if (!(del = EQ2008LibraryFactory.getSDKLibrary().User_DelAllProgram(cardNum))) {
                    TransportUtil.getLog().warn((Object)("\u5220\u9664\u8282\u76ee\u8fd4\u56de\u5931\u8d25\uff01" + wrap.ip));
                }
                if ((iProgramIndex0 = EQ2008LibraryFactory.getSDKLibrary().User_AddProgram(cardNum, false, 0)) < 0) {
                    throw new Exception("\u6dfb\u52a0\u8282\u76ee\u5931\u8d25!");
                }
                String text = text0;
                if (text == null) {
                    text = "";
                }
                User_MoveSet MoveSet = new User_MoveSet();
                int iActionType = 2;
                if (actionType != null && actionType.length() > 0) {
                    try {
                        iActionType = Integer.parseInt(actionType);
                        if (iActionType < 0) {
                            iActionType = 2;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                MoveSet.iActionType = iActionType;
                int iActionSpeed = 1;
                if (speed != null && speed.length() > 0) {
                    try {
                        iActionSpeed = Integer.parseInt(speed);
                        if (iActionSpeed < 0) {
                            iActionSpeed = 1;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                MoveSet.iActionSpeed = iActionSpeed;
                MoveSet.iClearSpeed = iActionSpeed;
                byte[] buf = (String.valueOf(text) + "\u0000").getBytes("GBK");
                Memory menory = new Memory((long)buf.length);
                menory.write(0L, buf, 0, buf.length);
                User_PartInfo partInfo = new User_PartInfo();
                partInfo.iWidth = w;
                partInfo.iHeight = h;
                partInfo.iX = x;
                partInfo.iY = y;
                User_FontSet FontInfo = new User_FontSet();
                FontInfo.colorFont = 0xFFFFFF;
                FontInfo.iAlignStyle = 1;
                FontInfo.iVAlignerStyle = 1;
                if (fontSize != null) {
                    FontInfo.iFontSize = Integer.parseInt(fontSize);
                }
                FontInfo.strFontName = defaultFontName;
                if ("2".equals(playType)) {
                    pSingleText = new User_SingleText();
                    pSingleText.FontInfo = FontInfo;
                    pSingleText.PartInfo = partInfo;
                    pSingleText.MoveSet = MoveSet;
                    pSingleText.chContent = menory;
                    int result = EQ2008LibraryFactory.getSDKLibrary().User_AddSingleText(cardNum, (User_SingleText)pSingleText, iProgramIndex0);
                    if (result < 0) {
                        throw new Exception("\u6dfb\u52a0\u5355\u884c\u6587\u672c\u8fd4\u56de\u9519\u8bef!" + result);
                    }
                } else {
                    pSingleText = new User_Text();
                    pSingleText.FontInfo = FontInfo;
                    pSingleText.PartInfo = partInfo;
                    pSingleText.MoveSet = MoveSet;
                    pSingleText.chContent = menory;
                    int result = EQ2008LibraryFactory.getSDKLibrary().User_AddText(cardNum, (User_Text)pSingleText, iProgramIndex0);
                    if (result < 0) {
                        throw new Exception("\u6dfb\u52a0\u6587\u672c\u8fd4\u56de\u9519\u8bef!" + result);
                    }
                }
                if (!(b = EQ2008LibraryFactory.getSDKLibrary().User_SendToScreen(cardNum))) {
                    wrap.opened = false;
                    throw new Exception("\u53d1\u9001\u6587\u672c\u6d88\u606f\u8fd4\u56de\u5931\u8d25!");
                }
                success = true;
            }
            catch (Throwable ex) {
                this.responseError(request, String.valueOf(wrap.ip) + "\u663e\u793a\u5931\u8d25!\u539f\u56e0" + ex.getMessage(), null);
                return;
            }
        }
        try {
            ResponseSender response = request.createResponse();
            response.setHeader("eqId", eqId);
            response.setHeader("result", success ? "true" : "false");
            response.doResponse(null, null);
        }
        catch (IOException e) {
            TransportUtil.getLog().error((Object)"", (Throwable)e);
        }
    }

    private static List<String> createIni(List<EQWrap> eqList) {
        LinkedList<String> list1 = new LinkedList<String>();
        for (EQWrap w : eqList) {
            list1.add("  [\u5730\u5740\uff1a" + w.cardAddress + "]");
            list1.add("CardType=" + w.cardType);
            list1.add("CardAddress=" + w.cardAddress);
            list1.add("CommunicationMode=" + w.communicationMode);
            list1.add("ScreemHeight=" + w.screemHeight);
            list1.add("ScreemWidth=" + w.screemWidth);
            list1.add("SerialBaud=" + w.serialBaud);
            list1.add("SerialNum=" + w.serialNum);
            list1.add("NetPort=" + w.netPort);
            list1.add("IpAddress0=" + w.ipAddress0);
            list1.add("IpAddress1=" + w.ipAddress1);
            list1.add("IpAddress2=" + w.ipAddress2);
            list1.add("IpAddress3=" + w.ipAddress3);
            list1.add("ColorStyle=" + w.colorStyle);
        }
        return list1;
    }

    private static void writeIni(List<String> configList, File f) throws Exception {
        if (!f.getParentFile().exists() || !f.getParentFile().isDirectory()) {
            f.getParentFile().mkdirs();
        }
        try (PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "GB2312"));){
            if (configList != null) {
                for (String s : configList) {
                    if (s == null) continue;
                    if (s.indexOf("[") != -1 && s.lastIndexOf("]") != -1) {
                        w.println();
                    }
                    w.println(s);
                }
            }
        }
    }

    public void onClose() throws Exception {
        this.closed = true;
        this.queue.clear();
        this.queue.offer(Boolean.TRUE);
        this.runThread.interrupt();
    }

    private static class EQWrap {
        String eqId;
        String cardAddress = "1";
        String ip;
        String screemWidth = "128";
        String screemHeight = "32";
        String cardType = "22";
        String colorStyle = "1";
        String serialBaud = "57600";
        String serialNum = "1";
        String netPort = "5005";
        String communicationMode = "1";
        String ipAddress0;
        String ipAddress1;
        String ipAddress2;
        String ipAddress3;
        boolean opened;
        Boolean needClearRealTime = true;

        EQWrap(String eqId, String cardAddress) {
            this.eqId = eqId;
            this.cardAddress = cardAddress;
            this.setIP("192.168.1." + cardAddress);
        }

        void setIP(String ip) {
            this.ip = ip;
            this.ipAddress0 = "";
            this.ipAddress1 = "";
            this.ipAddress2 = "";
            this.ipAddress3 = "";
            if (ip != null) {
                String[] sd = ip.split("\\.");
                int i = 0;
                while (i < sd.length) {
                    if (i == 0) {
                        this.ipAddress0 = sd[0].trim();
                    } else if (i == 1) {
                        this.ipAddress1 = sd[1].trim();
                    } else if (i == 2) {
                        this.ipAddress2 = sd[2].trim();
                    } else if (i == 3) {
                        this.ipAddress3 = sd[3].trim();
                    }
                    ++i;
                }
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cardAddress == null ? 0 : this.cardAddress.hashCode());
            result = 31 * result + (this.cardType == null ? 0 : this.cardType.hashCode());
            result = 31 * result + (this.colorStyle == null ? 0 : this.colorStyle.hashCode());
            result = 31 * result + (this.communicationMode == null ? 0 : this.communicationMode.hashCode());
            result = 31 * result + (this.eqId == null ? 0 : this.eqId.hashCode());
            result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
            result = 31 * result + (this.ipAddress0 == null ? 0 : this.ipAddress0.hashCode());
            result = 31 * result + (this.ipAddress1 == null ? 0 : this.ipAddress1.hashCode());
            result = 31 * result + (this.ipAddress2 == null ? 0 : this.ipAddress2.hashCode());
            result = 31 * result + (this.ipAddress3 == null ? 0 : this.ipAddress3.hashCode());
            result = 31 * result + (this.netPort == null ? 0 : this.netPort.hashCode());
            result = 31 * result + (this.screemHeight == null ? 0 : this.screemHeight.hashCode());
            result = 31 * result + (this.screemWidth == null ? 0 : this.screemWidth.hashCode());
            result = 31 * result + (this.serialBaud == null ? 0 : this.serialBaud.hashCode());
            result = 31 * result + (this.serialNum == null ? 0 : this.serialNum.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EQWrap other = (EQWrap)obj;
            if (this.cardAddress == null ? other.cardAddress != null : !this.cardAddress.equals(other.cardAddress)) {
                return false;
            }
            if (this.cardType == null ? other.cardType != null : !this.cardType.equals(other.cardType)) {
                return false;
            }
            if (this.colorStyle == null ? other.colorStyle != null : !this.colorStyle.equals(other.colorStyle)) {
                return false;
            }
            if (this.communicationMode == null ? other.communicationMode != null : !this.communicationMode.equals(other.communicationMode)) {
                return false;
            }
            if (this.eqId == null ? other.eqId != null : !this.eqId.equals(other.eqId)) {
                return false;
            }
            if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
                return false;
            }
            if (this.ipAddress0 == null ? other.ipAddress0 != null : !this.ipAddress0.equals(other.ipAddress0)) {
                return false;
            }
            if (this.ipAddress1 == null ? other.ipAddress1 != null : !this.ipAddress1.equals(other.ipAddress1)) {
                return false;
            }
            if (this.ipAddress2 == null ? other.ipAddress2 != null : !this.ipAddress2.equals(other.ipAddress2)) {
                return false;
            }
            if (this.ipAddress3 == null ? other.ipAddress3 != null : !this.ipAddress3.equals(other.ipAddress3)) {
                return false;
            }
            if (this.netPort == null ? other.netPort != null : !this.netPort.equals(other.netPort)) {
                return false;
            }
            if (this.screemHeight == null ? other.screemHeight != null : !this.screemHeight.equals(other.screemHeight)) {
                return false;
            }
            if (this.screemWidth == null ? other.screemWidth != null : !this.screemWidth.equals(other.screemWidth)) {
                return false;
            }
            if (this.serialBaud == null ? other.serialBaud != null : !this.serialBaud.equals(other.serialBaud)) {
                return false;
            }
            return !(this.serialNum == null ? other.serialNum != null : !this.serialNum.equals(other.serialNum));
        }
    }
}

