/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.screen.eq.drive.sdk;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.wovoe.nativetransport.TransportUtil;
import com.wovoe.screen.eq.drive.sdk.EQ2008Library;
import com.wovoe.screen.eq.drive.sdk.StdCallEQ2008Library;
import java.io.File;
import java.util.Locale;

public class EQ2008LibraryFactory {
    private static EQ2008Library instance;
    private static final String LIBRAY_NAME = "EQ2008_Dll";
    private static File iniFileDir;
    public static final String iniFileName = "EQ2008_Dll_Set.ini";

    private EQ2008LibraryFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EQ2008Library loadLibrary(String librayPath) {
        if (librayPath == null || librayPath.length() == 0) {
            librayPath = LIBRAY_NAME;
        }
        if (instance != null) return instance;
        Class<EQ2008LibraryFactory> clazz = EQ2008LibraryFactory.class;
        synchronized (EQ2008LibraryFactory.class) {
            if (instance != null) return instance;
            instance = EQ2008LibraryFactory.isWindows32() ? (StdCallEQ2008Library)Native.synchronizedLibrary((Library)((StdCallEQ2008Library)Native.loadLibrary((String)librayPath, StdCallEQ2008Library.class))) : (EQ2008Library)Native.synchronizedLibrary((Library)((EQ2008Library)Native.loadLibrary((String)librayPath, EQ2008Library.class)));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isWindows32() {
        boolean os32;
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        return OS_NAME.indexOf("win") != -1 && (os32 = System.getProperty("sun.arch.data.model", "32").equals("32"));
    }

    private static String getLibDirName(boolean os32) {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "win" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "linux" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nix") != -1) {
            return "unix" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("mac") != -1) {
            return "mac" + (os32 ? "32" : "64");
        }
        return os32 ? "32" : "64";
    }

    private static String getLibFileName() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "EQ2008_Dll.dll";
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "EQ2008_Dll.so";
        }
        return "EQ2008_Dll.dll";
    }

    public static File getBasicDir() {
        File xf = TransportUtil.findHomeDir();
        File nativeDir = "native".equals(xf.getName()) ? xf : new File(xf, "native");
        File EQ_LEDSdkDir = new File(nativeDir, "EQ_LEDSdk");
        return EQ_LEDSdkDir;
    }

    public static EQ2008Library getSDKLibrary() {
        if (instance == null) {
            File file;
            boolean os32;
            File libDir;
            File EQ_LEDSdkDir = EQ2008LibraryFactory.getBasicDir();
            String libPath = null;
            if (EQ_LEDSdkDir.exists() && EQ_LEDSdkDir.isDirectory() && (libDir = new File(EQ_LEDSdkDir, EQ2008LibraryFactory.getLibDirName(os32 = System.getProperty("sun.arch.data.model", "32").equals("32")))).exists() && libDir.isDirectory() && (file = new File(libDir, EQ2008LibraryFactory.getLibFileName())).exists() && file.isFile()) {
                libPath = file.getAbsolutePath();
            }
            EQ2008LibraryFactory.loadLibrary(libPath);
        }
        return instance;
    }

    public static File getIniFileDir() {
        if (iniFileDir == null) {
            File EQ_LEDSdkDir = EQ2008LibraryFactory.getBasicDir();
            File configFile = new File(EQ_LEDSdkDir, "conf");
            if (!configFile.exists() || !configFile.isDirectory()) {
                configFile.mkdirs();
            }
            iniFileDir = configFile;
        }
        return iniFileDir;
    }

    public static File getIniFile() {
        return new File(EQ2008LibraryFactory.getIniFileDir(), iniFileName);
    }
}

