/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.browser;

import java.nio.ByteBuffer;

public class BytesTool {
    private static final char[] encodingURi = "0123456789_abcdefghijklmnopqrstuvwxyz-ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    private static byte long7(long x) {
        return (byte)(x >> 56);
    }

    private static byte long6(long x) {
        return (byte)(x >> 48);
    }

    private static byte long5(long x) {
        return (byte)(x >> 40);
    }

    private static byte long4(long x) {
        return (byte)(x >> 32);
    }

    private static byte long3(long x) {
        return (byte)(x >> 24);
    }

    private static byte long2(long x) {
        return (byte)(x >> 16);
    }

    private static byte long1(long x) {
        return (byte)(x >> 8);
    }

    private static byte long0(long x) {
        return (byte)(x >> 0);
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)(x >> 0);
    }

    public static byte[] LongToBytes(long x) {
        byte[] b = new byte[]{BytesTool.long7(x), BytesTool.long6(x), BytesTool.long5(x), BytesTool.long4(x), BytesTool.long3(x), BytesTool.long2(x), BytesTool.long1(x), BytesTool.long0(x)};
        return b;
    }

    public static void LongToBytes(byte[] b, int offset, long x) {
        b[offset + 0] = BytesTool.long7(x);
        b[offset + 1] = BytesTool.long6(x);
        b[offset + 2] = BytesTool.long5(x);
        b[offset + 3] = BytesTool.long4(x);
        b[offset + 4] = BytesTool.long3(x);
        b[offset + 5] = BytesTool.long2(x);
        b[offset + 6] = BytesTool.long1(x);
        b[offset + 7] = BytesTool.long0(x);
    }

    public static long BytesToLong(byte[] b) {
        return BytesTool.makeLong(b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7]);
    }

    public static long BytesToLong(byte[] b, int offset) {
        return BytesTool.makeLong(b[offset + 0], b[offset + 1], b[offset + 2], b[offset + 3], b[offset + 4], b[offset + 5], b[offset + 6], b[offset + 7]);
    }

    public static long byteToLong(byte[] b, int offset) {
        return BytesTool.makeLong(b[offset + 0], b[offset + 1], b[offset + 2], b[offset + 3], b[offset + 4], b[offset + 5], b[offset + 6], b[offset + 7]);
    }

    public static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return ((long)b7 & 0xFFL) << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | ((long)b0 & 0xFFL) << 0;
    }

    public static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    public static byte[] intToBytes(int x) {
        byte[] b = new byte[]{BytesTool.int3(x), BytesTool.int2(x), BytesTool.int1(x), BytesTool.int0(x)};
        return b;
    }

    public static byte[] intToBytesL(int x) {
        byte[] b = new byte[4];
        b[3] = BytesTool.int3(x);
        b[2] = BytesTool.int2(x);
        b[1] = BytesTool.int1(x);
        b[0] = BytesTool.int0(x);
        return b;
    }

    public static int bytesToIntL(byte[] b) {
        return BytesTool.makeInt(b[3], b[2], b[1], b[0]);
    }

    public static int bytesToIntL(byte[] b, int offset) {
        return BytesTool.makeInt(b[offset + 3], b[offset + 2], b[offset + 1], b[offset + 0]);
    }

    public static int bytesToInt(byte[] b) {
        return BytesTool.makeInt(b[0], b[1], b[2], b[3]);
    }

    public static int bytesToInt(byte[] b, int offset) {
        return BytesTool.makeInt(b[offset], b[offset + 1], b[offset + 2], b[offset + 3]);
    }

    public static int getUnsignedByteValue(byte value) {
        return value & 0xFF;
    }

    public static int getUnsignedShortValue(short value) {
        return value << 16 >>> 16;
    }

    public static String byteBufferToHexString(ByteBuffer data) {
        int pos = data.position();
        StringBuffer strbuf = new StringBuffer(data.remaining() << 1);
        while (data.hasRemaining()) {
            byte b = data.get();
            if ((b & 0xFF) < 16) {
                strbuf.append('0');
            }
            strbuf.append(Integer.toString(b & 0xFF, 16));
        }
        data.position(pos);
        return strbuf.toString();
    }

    public static String byteArrayToHexString(byte[] buf) {
        return BytesTool.byteArrayToHexString(buf, 0, buf.length);
    }

    public static String byteArrayToHexString(byte[] buf, int offset, int length) {
        StringBuffer strbuf = new StringBuffer(length << 1);
        int end = length + offset;
        int i = offset;
        while (i < end) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append('0');
            }
            strbuf.append(Integer.toString(buf[i] & 0xFF, 16));
            ++i;
        }
        return strbuf.toString();
    }

    public static byte[] hexStringToByteArray(String hex) {
        if (hex == null) {
            return null;
        }
        int length = hex.length();
        int byteLength = length >> 1;
        byte[] result = new byte[byteLength];
        char[] buffer = new char[2];
        int i = 0;
        int pos = 0;
        while (pos < length) {
            buffer[0] = hex.charAt(pos);
            buffer[1] = hex.charAt(pos + 1);
            result[i] = (byte)BytesTool.parseInt(buffer, 16);
            pos += 2;
            ++i;
        }
        return result;
    }

    public static String compressBytes(byte[] data) {
        return BytesTool.compressBytes(data, 0, data.length);
    }

    public static String compressBytes(byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        int end = offset + length;
        int mod1 = length % 3;
        int charLen = mod1 == 1 ? (length / 3 << 2) + 2 : (mod1 == 2 ? (length / 3 << 2) + 3 : length / 3 << 2);
        char[] charBuf = new char[charLen];
        int bufIndex = 0;
        int XFF = 255;
        int X30 = 48;
        int X3C = 60;
        int X3F = 63;
        int r = 0;
        int i = offset;
        while (i < end) {
            if (r == 0) {
                charBuf[bufIndex++] = encodingURi[(data[i] & XFF) >> 2];
                r = 2;
            } else if (r == 2) {
                charBuf[bufIndex++] = encodingURi[data[i - 1] << 4 & X30 | (data[i] & XFF) >> 4];
                r = 4;
            } else if (r == 4) {
                charBuf[bufIndex++] = encodingURi[data[i - 1] << 2 & X3C | (data[i] & XFF) >> 6];
                charBuf[bufIndex++] = encodingURi[data[i] & X3F];
                r = 0;
            }
            ++i;
        }
        if (r > 0) {
            if (r == 2) {
                charBuf[bufIndex++] = encodingURi[data[end - 1] & 3];
            } else if (r == 4) {
                charBuf[bufIndex++] = encodingURi[data[end - 1] & 0xF];
            }
        }
        return new String(charBuf);
    }

    public static byte[] unCompress(String compresStr) {
        int len;
        if (compresStr == null) {
            return null;
        }
        if (compresStr.length() == 0) {
            return new byte[0];
        }
        int mod1 = compresStr.length() % 4;
        if (mod1 == 0) {
            len = compresStr.length() / 4 * 3;
        } else if (mod1 == 2) {
            len = compresStr.length() / 4 * 3 + 1;
        } else if (mod1 == 3) {
            len = compresStr.length() / 4 * 3 + 2;
        } else {
            throw new IllegalArgumentException("ivalid compres string length:" + compresStr);
        }
        byte[] data = new byte[len];
        int r = 0;
        int dataIndex = 0;
        int i = 0;
        while (i < compresStr.length()) {
            int v = BytesTool.getChar64Value(compresStr.charAt(i));
            if (r == 0) {
                data[dataIndex++] = (byte)(v << 2);
                r = 2;
            } else if (r == 2) {
                if (dataIndex < len) {
                    data[dataIndex - 1] = (byte)(data[dataIndex - 1] | v >> 4);
                    data[dataIndex++] = (byte)(v << 4);
                    r = 4;
                } else {
                    data[dataIndex - 1] = (byte)(data[dataIndex - 1] | v);
                }
            } else if (r == 4) {
                if (dataIndex < len) {
                    data[dataIndex - 1] = (byte)(data[dataIndex - 1] | v >> 2);
                    data[dataIndex++] = (byte)(v << 6);
                    r = 6;
                } else {
                    data[dataIndex - 1] = (byte)(data[dataIndex - 1] | v);
                }
            } else if (r == 6) {
                data[dataIndex - 1] = (byte)(data[dataIndex - 1] | v);
                r = 0;
            }
            ++i;
        }
        return data;
    }

    private static int getChar64Value(char v) {
        char z = v;
        if (z == '_') {
            return 10;
        }
        if (z == '-') {
            return 37;
        }
        if (z >= '0' && z <= '9') {
            return z - 48;
        }
        if (z >= 'A' && z <= 'Z') {
            return z - 27;
        }
        if (z >= 'a' && z <= 'z') {
            return z - 86;
        }
        throw new IllegalArgumentException("ivalid char :" + v);
    }

    public static int parseInt(char[] ch, int radix) throws NumberFormatException {
        if (ch == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = ch.length;
        if (max > 0) {
            int digit;
            int limit;
            if (ch[0] == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit(ch[i++], radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(ch[i++], radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
        }
        return -result;
    }
}

