/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.browser;

import com.wovoe.browser.MainBrowerWindow;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;

public class MainApplication
extends Application
implements Runnable {
    private static final String CMDPREFIX = "wovoejavaxfbrowser";
    private static final long CPURUNTIME = System.nanoTime();
    private static final long RUNTIMENANOS = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    private static final String CMD_OPENURL = "openUrl:";
    private static final String CMD_EXITSYSTEM = "existSystem";
    private static final String CMD_HEARTBEAT = "heartbeat";
    private static final String SPLIT_CLOSEURL = " closeUrl:";
    private Thread readThread;
    private MainBrowerWindow brower;
    private long lastRecevTimeMills;

    public static long currentTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(MainApplication.currentTimeNanos());
    }

    public static long currentTimeNanos() {
        return RUNTIMENANOS + (System.nanoTime() - CPURUNTIME);
    }

    public static void main(String[] args) throws Exception {
        Platform.setImplicitExit((boolean)false);
        MainApplication.launch((String[])args);
    }

    @Override
    public void run() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(CMDPREFIX)) continue;
                String cmdLine = line.substring(CMDPREFIX.length());
                if (CMD_EXITSYSTEM.equals(cmdLine)) {
                    Platform.exit();
                    System.exit(0);
                    continue;
                }
                if (CMD_HEARTBEAT.equals(cmdLine)) {
                    this.lastRecevTimeMills = MainApplication.currentTimeMillis();
                    continue;
                }
                this.handleCmd(cmdLine);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleCmd(final String cmdLine) {
        try {
            if (cmdLine.length() == 0) {
                return;
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        MainApplication.this.javafxRun(cmdLine);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void javafxRun(String cmdLine) throws Exception {
        if (cmdLine.startsWith(CMD_OPENURL)) {
            String closeUrl;
            String openUrl;
            String urls = cmdLine.substring(CMD_OPENURL.length());
            if (urls.indexOf(SPLIT_CLOSEURL) != -1) {
                String[] sa = urls.split(SPLIT_CLOSEURL);
                openUrl = sa[0].trim();
                closeUrl = sa[1].trim();
            } else {
                openUrl = urls.trim();
                closeUrl = null;
            }
            this.brower.loadUrl(openUrl, closeUrl);
        }
    }

    public void start(Stage primaryStage) throws Exception {
        if (this.readThread == null) {
            this.lastRecevTimeMills = MainApplication.currentTimeMillis();
            this.readThread = new Thread(this);
            this.readThread.setDaemon(true);
            this.readThread.start();
            Thread t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        long h1;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if ((h1 = MainApplication.currentTimeMillis()) - MainApplication.this.lastRecevTimeMills < 10000L) continue;
                        Platform.exit();
                        System.exit(0);
                    }
                }
            });
            t1.setDaemon(true);
            t1.start();
        }
        if (this.brower == null) {
            this.brower = new MainBrowerWindow();
        }
        System.out.println("The application has been started");
    }
}

