/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.browser;

import com.wovoe.browser.MainBrowerWindow;
import com.wovoe.browser.Tvx;
import java.awt.Desktop;
import java.net.URI;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class MainBrowerStage {
    private Stage stage = new Stage();
    private static Image logo;
    private String url;
    private WebView browser;
    private WebEngine webEngine;
    private String closeUrl;

    public void setAlwaysOnTopAWhile() {
        this.stage.setAlwaysOnTop(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MainBrowerStage.this.getStage().setAlwaysOnTop(false);
                    }
                });
            }
        }).start();
    }

    public MainBrowerStage() {
        this.setAlwaysOnTopAWhile();
        this.stage.toFront();
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        this.stage.setX(primaryScreenBounds.getMinX());
        this.stage.setY(primaryScreenBounds.getMinY());
        this.stage.setWidth(primaryScreenBounds.getWidth());
        this.stage.setHeight(primaryScreenBounds.getHeight());
        this.browser = new WebView();
        this.webEngine = this.browser.getEngine();
        Scene scene = new Scene((Parent)this.browser);
        if (logo == null) {
            Image p = null;
            try {
                p = new Image(MainBrowerWindow.class.getResourceAsStream("world.png"));
            }
            catch (Exception e) {
                p = null;
            }
            logo = p;
        }
        if (logo != null) {
            this.stage.getIcons().add((Object)logo);
        }
        this.stage.setScene(scene);
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    MainBrowerStage.this.stage.setTitle(MainBrowerStage.this.webEngine.getTitle());
                } else if (newState == Worker.State.SCHEDULED) {
                    String url = MainBrowerStage.this.webEngine.getLocation();
                    if (url != null && url.length() > 0 && (url.indexOf(".action?op=export") != -1 || url.indexOf("/manage/downloadImportPlateTemplate.action") != -1)) {
                        url = url.indexOf(63) == -1 ? String.valueOf(url) + "?" : String.valueOf(url) + "&";
                        MainBrowerStage.openSystemBrowser(String.valueOf(url) + "carparkBrowse=" + Tvx.getExportToken());
                    }
                } else if (newState == Worker.State.FAILED) {
                    MainBrowerStage.this.webEngine.load(MainBrowerStage.class.getResource("pageLostHost.html").toString());
                }
            }
        });
        this.webEngine.setOnResized((EventHandler)new EventHandler<WebEvent<Rectangle2D>>(){

            public void handle(WebEvent<Rectangle2D> ev) {
                Rectangle2D r = (Rectangle2D)ev.getData();
                MainBrowerStage.this.stage.setWidth(r.getWidth());
                MainBrowerStage.this.stage.setHeight(r.getHeight());
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (MainBrowerStage.this.closeUrl != null && MainBrowerStage.this.closeUrl.length() > 0) {
                    MainBrowerStage.this.webEngine.load(MainBrowerStage.this.closeUrl);
                }
            }
        });
    }

    private static void openSystemBrowser(String url) {
        boolean ok = false;
        if (Desktop.isDesktopSupported()) {
            try {
                URI uri = URI.create(url);
                Desktop dp = Desktop.getDesktop();
                if (dp.isSupported(Desktop.Action.BROWSE)) {
                    dp.browse(uri);
                    ok = true;
                }
            }
            catch (Exception uri) {
                // empty catch block
            }
        }
        if (!ok) {
            try {
                boolean windows;
                String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
                boolean bl = windows = OS_NAME.indexOf("win") != -1;
                if (windows) {
                    Runtime.getRuntime().exec("cmd   /c   start   " + url);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getCloseUrl() {
        return this.closeUrl;
    }

    public void setCloseUrl(String closeUrl) {
        this.closeUrl = closeUrl;
    }

    public Stage getStage() {
        return this.stage;
    }

    public String getUrl() {
        return this.url;
    }

    public WebView getBrowser() {
        return this.browser;
    }

    public WebEngine getWebEngine() {
        return this.webEngine;
    }

    public boolean isShowing() {
        return this.stage.isShowing();
    }

    public void loadUrl(String url) {
        this.url = url;
        if (!this.stage.isShowing()) {
            this.stage.show();
        }
        this.webEngine.load(url);
    }
}

