/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.camera.drive.zs;

import com.sun.jna.Pointer;
import com.wovoe.camera.drive.zs.sdk.VZ_LPRC_OSD_Param;
import com.wovoe.camera.drive.zs.sdk.VzLPRSDKLibraryFactory;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.nativetransport.TransportCloseListener;
import com.wovoe.nativetransport.TransportUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ZSCameraAction
implements ServiceAction {
    public static final String ACTION_NAME = "/ZSCameraAction";
    private static Map<String, Method> methodsMap = new HashMap<String, Method>();
    private static ConcurrentHashMap<String, CameraWrap> camerasMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> connectingMap = new ConcurrentHashMap();
    private static final Object carmeraManagerLock = new Object();
    private static volatile long restartSdkTimeMills;
    private static final ReadWriteLock rwLock;
    private static final Lock readLock;
    private static final Lock wirteLock;
    private static volatile boolean closed;
    private final Object closeAllCameraLock = new Object();

    static {
        rwLock = new ReentrantReadWriteLock();
        readLock = rwLock.readLock();
        wirteLock = rwLock.writeLock();
        try {
            Method[] mehtods = ZSCameraAction.class.getMethods();
            String service = "service";
            Method[] methodArray = mehtods;
            int n = mehtods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                String name = m.getName();
                Class<?>[] cls = m.getParameterTypes();
                if (cls != null && cls.length == 1 && Receiver.class.equals(cls[0]) && !service.equals(name)) {
                    methodsMap.put(name, m);
                }
                ++n2;
            }
            TransportUtil.addTransportCloseListener((TransportCloseListener)new TransportCloseListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClose() throws Exception {
                    try {
                        wirteLock.lock();
                        try {
                            closed = true;
                            Object object = carmeraManagerLock;
                            synchronized (object) {
                                Iterator it = camerasMap.entrySet().iterator();
                                while (it.hasNext()) {
                                    try {
                                        try {
                                            CameraWrap rm;
                                            CameraWrap cameraWrap = rm = (CameraWrap)it.next().getValue();
                                            synchronized (cameraWrap) {
                                                if (!rm.released) {
                                                    rm.released = true;
                                                    ZSCameraAction.closeConnect(rm);
                                                }
                                            }
                                        }
                                        catch (Exception exception) {
                                            it.remove();
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        it.remove();
                                        throw throwable;
                                    }
                                    it.remove();
                                }
                            }
                        }
                        finally {
                            wirteLock.unlock();
                        }
                    }
                    catch (Exception ex) {
                        TransportUtil.getLog().error((Object)("\u5173\u95ed\u5931\u8d25!" + ex.getMessage()));
                    }
                }
            });
        }
        catch (Exception ex) {
            TransportUtil.getLog().error((Object)"\u52a0\u8f7d\u9a71\u52a8\u5f02\u5e38", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartSdk() {
        wirteLock.lock();
        try {
            if (closed) {
                return;
            }
            long currentMills = TransportUtil.currentTimeMillis();
            if (restartSdkTimeMills > 0L && currentMills - restartSdkTimeMills < 10000L) {
                return;
            }
            restartSdkTimeMills = currentMills;
            Object object = carmeraManagerLock;
            synchronized (object) {
                Iterator<Map.Entry<String, CameraWrap>> it = camerasMap.entrySet().iterator();
                while (it.hasNext()) {
                    try {
                        try {
                            CameraWrap rm;
                            CameraWrap cameraWrap = rm = it.next().getValue();
                            synchronized (cameraWrap) {
                                if (!rm.released) {
                                    rm.released = true;
                                    ZSCameraAction.closeConnect(rm);
                                }
                            }
                        }
                        catch (Exception exception) {
                            it.remove();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        it.remove();
                        throw throwable;
                    }
                    it.remove();
                }
            }
            if (VzLPRSDKLibraryFactory.isInited()) {
                VzLPRSDKLibraryFactory.releaseSdk();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            VzLPRSDKLibraryFactory.getSDKLibrary();
        }
        finally {
            wirteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean stopPlay(CameraWrap wrap) {
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            block4: {
                if (wrap.nPayHandle == -1) break block4;
                int result = VzLPRSDKLibraryFactory.getSDKLibrary().VzLPRClient_StopRealPlay(wrap.nPayHandle);
                wrap.componentId = null;
                wrap.nPayHandle = -1;
                if (result == 0) break block4;
                TransportUtil.getLog().error((Object)("\u505c\u6b62\u64ad\u653e\u76f8\u673a" + wrap.ip + "\u5931\u8d25! \u9519\u8bef\u4ee3\u7801\uff1a" + result));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSameComponentID(String cameraId, Long componentID0) {
        if (cameraId == null || cameraId.length() == 0 || componentID0 == null || componentID0 == 0L) {
            return;
        }
        Object object = this.closeAllCameraLock;
        synchronized (object) {
            for (CameraWrap w : camerasMap.values()) {
                if (cameraId.equals(w.cameraId)) continue;
                CameraWrap cameraWrap = w;
                synchronized (cameraWrap) {
                    if (!w.released && w.nPayHandle != -1 && w.componentId != null && w.componentId.longValue() == componentID0.longValue()) {
                        ZSCameraAction.stopPlay(w);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean play0(CameraWrap wrap, Long componentID0) {
        if (wrap == null) return false;
        if (componentID0 == null) {
            return false;
        }
        this.closeSameComponentID(wrap.cameraId, componentID0);
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            if (wrap.released) {
                return false;
            }
            if (wrap.nPayHandle != -1) {
                if (wrap.componentId != null && wrap.componentId.longValue() == componentID0.longValue()) {
                    return true;
                }
                ZSCameraAction.stopPlay(wrap);
            }
            Pointer hWnd = new Pointer(componentID0.longValue());
            int result = VzLPRSDKLibraryFactory.getSDKLibrary().VzLPRClient_StartRealPlay(wrap.handle, hWnd);
            if (result == -1) {
                TransportUtil.getLog().error((Object)("\u64ad\u653e\u76f8\u673a" + wrap.ip + "\u89c6\u9891\u5931\u8d25\uff01 " + result));
                return false;
            }
            wrap.componentId = componentID0;
            wrap.nPayHandle = result;
            return true;
        }
    }

    private boolean play(CameraWrap wrap, Long componentID0) {
        boolean success = this.play0(wrap, componentID0);
        if (!success) {
            TransportUtil.getWorkThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    ZSCameraAction.this.restartSdk();
                }
            });
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean closeConnect(CameraWrap wrap) {
        ZSCameraAction.stopPlay(wrap);
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            int result = VzLPRSDKLibraryFactory.getSDKLibrary().VzLPRClient_Close(wrap.handle);
            return result == 0;
        }
    }

    public void service(final Receiver request) throws Exception {
        if (closed) {
            ZSCameraAction.responseError(request, "SDK\u5df2\u5173\u95ed", null);
            return;
        }
        String op = request.getHeaderValue("op");
        if (op == null || op.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11op!", null);
            return;
        }
        try {
            final Method method = methodsMap.get(op);
            if (method == null) {
                ZSCameraAction.responseError(request, "\u65e0\u6548op: " + op, null);
                return;
            }
            final ZSCameraAction invokeObj = this;
            TransportUtil.getWorkThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    readLock.lock();
                    if (closed) {
                        ZSCameraAction.responseError(request, "SDK\u5df2\u5173\u95ed", null);
                    } else {
                        try {
                            try {
                                method.invoke(invokeObj, request);
                            }
                            catch (Exception ex) {
                                TransportUtil.getLog().error((Object)"\u6267\u884c\u52a8\u4f5c\u5f02\u5e38!", (Throwable)ex);
                                readLock.unlock();
                            }
                        }
                        finally {
                            readLock.unlock();
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            TransportUtil.getLog().error((Object)"\u6267\u884c\u52a8\u4f5c\u5f02\u5e38!", e);
        }
    }

    public void playVisible(Receiver request) throws Exception {
        long componentID0;
        String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        String ip = request.getHeaderValue("ip");
        if (ip == null || ip.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:ip", null);
            return;
        }
        String userName = request.getHeaderValue("userName");
        if (userName == null || userName.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:userName", null);
            return;
        }
        String userPwd = request.getHeaderValue("userPwd");
        if (userPwd == null || userPwd.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:userPwd", null);
            return;
        }
        String _port = request.getHeaderValue("port");
        if (_port == null || _port.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:port", null);
            return;
        }
        int port = 0;
        try {
            if (_port != null && _port.length() > 0) {
                port = Integer.parseInt(_port);
            }
            if (port > 65535 || port <= 0) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception e) {
            ZSCameraAction.responseError(request, "\u53c2\u6570:port\u9519\u8bef" + port, null);
            return;
        }
        String componentID = request.getHeaderValue("componentID");
        if (componentID == null || componentID.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:componentID", null);
            return;
        }
        try {
            componentID0 = Long.parseLong(componentID);
        }
        catch (Exception ex) {
            ZSCameraAction.responseError(request, "componentID\u4e0d\u662f\u6574\u6570:" + componentID, null);
            return;
        }
        StringBuilder tipMsg = new StringBuilder();
        if (!ZSCameraAction.connect(request)) {
            ZSCameraAction.responseError(request, "\u64ad\u653e\u5931\u8d25!" + ip, tipMsg.toString(), null);
            return;
        }
        CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null) {
            ZSCameraAction.responseError(request, "\u672a\u8fde\u63a5", null);
            return;
        }
        boolean rsult = this.play(wrap, componentID0);
        if (!rsult) {
            ZSCameraAction.responseError(request, "\u64ad\u653e\u5931\u8d25!" + ip, null);
            return;
        }
        try {
            ResponseSender response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", String.valueOf(rsult));
            response.doResponse(null, null);
        }
        catch (IOException e) {
            TransportUtil.getLog().error((Object)"", (Throwable)e);
        }
    }

    private static void responseError(Receiver request, String message, Throwable e) {
        ZSCameraAction.responseError(request, message, null, e);
    }

    private static void responseError(Receiver request, String message, String tipMsg, Throwable e) {
        try {
            String e1;
            String cameraId = request.getHeaderValue("cameraId");
            ResponseSender response = request.createResponse();
            response.setHeader("result", "error");
            if (cameraId != null && cameraId.length() > 0) {
                response.setHeader("cameraId", cameraId);
            }
            if (message != null && message.length() > 0) {
                response.setHeader("msg", message);
            }
            if (e != null && (e1 = e.getMessage()) != null && e1.length() > 0) {
                response.setHeader("msg1", e1);
            }
            if (tipMsg != null && tipMsg.length() > 0) {
                response.setHeader("tipMsg", tipMsg);
            }
            response.doResponse(null, null);
        }
        catch (IOException e1) {
            TransportUtil.getLog().error((Object)"", (Throwable)e1);
        }
    }

    public void stopPlay(Receiver request) throws Exception {
        String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null) {
            ResponseSender response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", "true");
            response.doResponse(null, null);
            return;
        }
        CameraWrap w0 = wrap;
        try {
            ZSCameraAction.stopPlay(w0);
            ResponseSender response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", "true");
            try {
                response.doResponse(null, null);
            }
            catch (IOException e) {
                TransportUtil.getLog().error((Object)"", (Throwable)e);
            }
        }
        catch (Exception ex) {
            ZSCameraAction.responseError(request, "\u5173\u95ed\u6444\u50cf\u673a\u5931\u8d25:" + w0.ip, ex);
        }
    }

    public void connectIfNotConnect(Receiver request) throws Exception {
        boolean c;
        ResponseSender response;
        String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        String ip = request.getHeaderValue("ip");
        if (ip == null || ip.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:ip", null);
            return;
        }
        String userName = request.getHeaderValue("userName");
        if (userName == null || userName.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:userName", null);
            return;
        }
        String userPwd = request.getHeaderValue("userPwd");
        if (userPwd == null || userPwd.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:userPwd", null);
            return;
        }
        String _port = request.getHeaderValue("port");
        if (_port == null || _port.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:port", null);
            return;
        }
        int port = 0;
        try {
            if (_port != null && _port.length() > 0) {
                port = Integer.parseInt(_port);
            }
            if (port > 65535 || port <= 0) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception e) {
            ZSCameraAction.responseError(request, "\u53c2\u6570:port\u9519\u8bef" + port, null);
            return;
        }
        String componentID = request.getHeaderValue("componentID");
        String osdText = request.getHeaderValue("osdText");
        CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap != null) {
            boolean changed = false;
            if (!(ip.equals(wrap.ip) && port == wrap.port && userName.equals(wrap.userName) && userPwd.equals(wrap.userPwd))) {
                changed = true;
            }
            if (!changed) {
                Long x1 = wrap.componentId;
                if (!(componentID == null && x1 == null || componentID != null && x1 != null && componentID.equals(x1.toString()))) {
                    changed = true;
                }
            }
            if (!changed) {
                String s1;
                if (osdText == null) {
                    osdText = "";
                }
                if ((s1 = wrap.osdText) == null) {
                    s1 = "";
                }
                if (!osdText.equals(s1)) {
                    changed = true;
                }
            }
            if (!changed) {
                response = request.createResponse();
                response.setHeader("cameraId", cameraId);
                response.setHeader("result", "true");
                try {
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        }
        try {
            c = ZSCameraAction.connect(request);
            response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", String.valueOf(c));
            try {
                response.doResponse(null, null);
            }
            catch (IOException e) {
                TransportUtil.getLog().error((Object)"", (Throwable)e);
            }
        }
        catch (Exception ex) {
            ZSCameraAction.responseError(request, "\u64cd\u4f5c\u5931\u8d25!" + request.getHeaderValue("ip"), ex);
            return;
        }
        if (c && componentID != null && componentID.length() > 0) {
            try {
                long componentID0 = Long.parseLong(componentID);
                wrap = camerasMap.get(cameraId);
                if (wrap != null) {
                    this.play(wrap, componentID0);
                }
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    public void disConnect(Receiver request) throws Exception {
        String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            ZSCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null) {
            ResponseSender response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", "true");
            response.doResponse(null, null);
            return;
        }
        ZSCameraAction.release(cameraId);
        try {
            ResponseSender response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", "true");
            response.doResponse(null, null);
        }
        catch (IOException e) {
            TransportUtil.getLog().error((Object)"", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void release(String cameraId) {
        CameraWrap wrap;
        if (cameraId == null) {
            return;
        }
        Object object = carmeraManagerLock;
        synchronized (object) {
            wrap = camerasMap.get(cameraId);
            if (wrap == null) {
                return;
            }
            CameraWrap cameraWrap = wrap;
            synchronized (cameraWrap) {
                if (wrap.released) {
                    return;
                }
                wrap.released = true;
            }
        }
        ZSCameraAction.closeConnect(wrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean connect(Receiver request) {
        int port;
        String osdText;
        String userPwd;
        String userName;
        String ip;
        String cameraId;
        CameraWrap wrap;
        block20: {
            wrap = null;
            cameraId = request.getHeaderValue("cameraId");
            ip = request.getHeaderValue("ip");
            String _port = request.getHeaderValue("port");
            userName = request.getHeaderValue("userName");
            userPwd = request.getHeaderValue("userPwd");
            osdText = request.getHeaderValue("osdText");
            port = 0;
            try {
                if (_port != null && _port.length() > 0) {
                    port = Integer.parseInt(_port);
                }
                if (port > 65535 || port <= 0) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Exception e) {
                return false;
            }
            if (cameraId == null || cameraId.length() == 0 || ip == null || ip.length() == 0 || userName == null || userName.length() == 0 || userPwd == null || userPwd.length() == 0) {
                return false;
            }
            Object e = carmeraManagerLock;
            synchronized (e) {
                block19: {
                    wrap = camerasMap.get(cameraId);
                    if (!(wrap == null || ip.equals(wrap.ip) && port == wrap.port && userName.equals(wrap.userName) && userPwd.equals(wrap.userPwd))) {
                        camerasMap.remove(wrap.cameraId);
                        CameraWrap cameraWrap = wrap;
                        synchronized (cameraWrap) {
                            wrap.released = true;
                        }
                        ZSCameraAction.closeConnect(wrap);
                        wrap = null;
                    }
                    if (wrap != null) break block20;
                    if (connectingMap.get(cameraId) == null) break block19;
                    return false;
                }
                connectingMap.put(cameraId, Boolean.TRUE);
            }
        }
        if (wrap == null) {
            String ip1 = String.valueOf(ip) + "\u0000";
            String userName1 = String.valueOf(userName) + "\u0000";
            String userPwd1 = String.valueOf(userPwd) + "\u0000";
            int tHandle = VzLPRSDKLibraryFactory.getSDKLibrary().VzLPRClient_Open(ByteBuffer.wrap(ip1.getBytes()), (short)port, ByteBuffer.wrap(userName1.getBytes()), ByteBuffer.wrap(userPwd1.getBytes()));
            if (tHandle == 0) {
                TransportUtil.getLog().warn((Object)("\u52a0\u8f7d\u76f8\u673a\uff1a" + ip + " \u5931\u8d25\uff01"));
                return false;
            }
            Object object = carmeraManagerLock;
            synchronized (object) {
                CameraWrap newWrap = new CameraWrap();
                newWrap.ip = ip;
                newWrap.cameraId = cameraId;
                newWrap.port = port;
                newWrap.userName = userName;
                newWrap.userPwd = userPwd;
                newWrap.handle = tHandle;
                camerasMap.put(cameraId, newWrap);
                connectingMap.remove(cameraId);
                wrap = newWrap;
            }
        }
        if (osdText != null && osdText.length() > 0) {
            ZSCameraAction.setOsdText(osdText, wrap);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setOsdText(String osdText, CameraWrap wrap) {
        if (wrap == null || osdText == null || osdText.length() == 0) {
            return false;
        }
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            block14: {
                VZ_LPRC_OSD_Param.ByReference pParam;
                block13: {
                    block12: {
                        if (!wrap.released) break block12;
                        return false;
                    }
                    if (wrap.osdParam != null) break block13;
                    pParam = new VZ_LPRC_OSD_Param.ByReference();
                    int osdResult = VzLPRSDKLibraryFactory.getSDKLibrary().VzLPRClient_GetOsdParam(wrap.handle, pParam);
                    if (osdResult == 0) {
                        wrap.osdParam = pParam;
                        wrap.osdText = pParam.nTextEnable != 1 ? "" : ZSCameraAction.getString(pParam.overlaytext);
                        break block13;
                    }
                    TransportUtil.getLog().error((Object)("\u83b7\u53d6osd\u914d\u7f6e\u64cd\u4f5c\u5931\u8d25!" + wrap.ip + ", result:" + osdResult));
                    return false;
                }
                if (wrap.osdParam == null || osdText.equals(wrap.osdText)) break block14;
                pParam = new VZ_LPRC_OSD_Param.ByReference();
                pParam.dstampenable = wrap.osdParam.dstampenable;
                pParam.dateFormat = 0;
                pParam.datePosX = wrap.osdParam.datePosX;
                pParam.datePosY = wrap.osdParam.datePosY;
                pParam.tstampenable = wrap.osdParam.tstampenable;
                pParam.timeFormat = 1;
                pParam.timePosX = wrap.osdParam.timePosX;
                pParam.timePosY = wrap.osdParam.timePosY;
                pParam.nLogoEnable = 0;
                pParam.timePosX = wrap.osdParam.nLogoPositionX;
                pParam.timePosY = wrap.osdParam.nLogoPositionY;
                pParam.nTextEnable = 1;
                pParam.nTextPositionX = wrap.osdParam.nTextPositionX;
                pParam.nTextPositionY = wrap.osdParam.nTextPositionY;
                String chaset = "GB2312";
                try {
                    String sx = String.valueOf(ZSCameraAction.getString(osdText, 60, chaset)) + "\u0000";
                    byte[] sd = sx.getBytes(chaset);
                    System.arraycopy(sd, 0, pParam.overlaytext, 0, sd.length);
                }
                catch (Exception ex) {
                    TransportUtil.getLog().error((Object)("\u8bbe\u7f6eosd\u6587\u672c\u5931\u8d25! \u4e0d\u652f\u6301\u7b80\u4f53\u4e2d\u6587" + wrap.ip + ", result:"));
                    return false;
                }
                int osdResult = VzLPRSDKLibraryFactory.getSDKLibrary().VzLPRClient_SetOsdParam(wrap.handle, pParam);
                if (osdResult == 0) {
                    wrap.osdParam = pParam;
                    wrap.osdText = osdText;
                    break block14;
                }
                TransportUtil.getLog().error((Object)("\u8bbe\u7f6eosd\u914d\u7f6e\u64cd\u4f5c\u5931\u8d25!" + wrap.ip + ", result:" + osdResult));
                return false;
            }
        }
        return true;
    }

    public static String getString(String a, int len, String charset) {
        byte[] a1;
        if (a == null) {
            return null;
        }
        if (a.length() == 0) {
            return a;
        }
        if (len <= 0) {
            return "";
        }
        if (charset == null || charset.length() == 0) {
            charset = "GB2312";
        }
        try {
            a1 = a.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (a1.length <= len) {
            return a;
        }
        String n = a;
        int leng = n.length();
        int i = leng - 1;
        while (i > 0) {
            n = n.substring(0, i);
            try {
                a1 = n.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (a1.length <= len) {
                return n;
            }
            --i;
        }
        return "";
    }

    private static String getString(byte[] xb) {
        if (xb == null) {
            return null;
        }
        if (xb.length == 0) {
            return "";
        }
        int i = 0;
        byte end = 0;
        int z = 0;
        while (z < xb.length) {
            if (xb[z] == end) {
                i = z;
                break;
            }
            ++z;
        }
        if (i == 0) {
            return "";
        }
        try {
            return new String(xb, 0, i, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            return new String(xb, 0, i);
        }
    }

    private static class CameraWrap {
        String cameraId;
        String ip;
        int port;
        String userName;
        String userPwd;
        int handle;
        volatile int nPayHandle = -1;
        volatile Long componentId;
        volatile VZ_LPRC_OSD_Param osdParam;
        volatile String osdText;
        volatile boolean released;

        private CameraWrap() {
        }
    }
}

