/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.camera.drive.zs.sdk;

import com.sun.jna.Native;
import com.wovoe.camera.drive.zs.sdk.StdCallVzLPRSDKLibrary;
import com.wovoe.camera.drive.zs.sdk.VzLPRSDKLibrary;
import com.wovoe.nativetransport.TransportCloseListener;
import com.wovoe.nativetransport.TransportUtil;
import java.io.File;
import java.util.Locale;

public class VzLPRSDKLibraryFactory
implements TransportCloseListener {
    private static VzLPRSDKLibrary instance;
    private static final String LIBRAY_NAME = "VzLPRSDK";
    private static boolean initedSdk;
    private static TransportCloseListener l;

    private VzLPRSDKLibraryFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerTransportCloseListener() {
        if (l != null) return;
        Class<VzLPRSDKLibraryFactory> clazz = VzLPRSDKLibraryFactory.class;
        synchronized (VzLPRSDKLibraryFactory.class) {
            if (l != null) return;
            l = new VzLPRSDKLibraryFactory();
            TransportUtil.addTransportCloseListener((TransportCloseListener)l);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static VzLPRSDKLibrary loadLibrary(String librayPath) {
        if (librayPath == null || librayPath.length() == 0) {
            librayPath = LIBRAY_NAME;
        }
        if (instance != null) return instance;
        Class<VzLPRSDKLibrary> clazz = VzLPRSDKLibrary.class;
        synchronized (VzLPRSDKLibrary.class) {
            if (instance != null) return instance;
            instance = VzLPRSDKLibraryFactory.isWindows() ? (StdCallVzLPRSDKLibrary)Native.loadLibrary((String)librayPath, StdCallVzLPRSDKLibrary.class) : (VzLPRSDKLibrary)Native.loadLibrary((String)librayPath, VzLPRSDKLibrary.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isWindows() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        return OS_NAME != null && OS_NAME.indexOf("win") != -1;
    }

    public static boolean isWindows32() {
        boolean os32;
        return VzLPRSDKLibraryFactory.isWindows() && (os32 = System.getProperty("sun.arch.data.model", "32").equals("32"));
    }

    private static String getLibDirName(boolean os32) {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "win" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "linux" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nix") != -1) {
            return "unix" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("mac") != -1) {
            return "mac" + (os32 ? "32" : "64");
        }
        return os32 ? "32" : "64";
    }

    private static String getLibFileName() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "VzLPRSDK.dll";
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "VzLPRSDK.so";
        }
        return "VzLPRSDK.dll";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VzLPRSDKLibrary getSDKLibrary() {
        if (instance == null) {
            File xf = TransportUtil.findHomeDir();
            File nativeDir = "native".equals(xf.getName()) ? xf : new File(xf, "native");
            File sdkDir = new File(nativeDir, LIBRAY_NAME);
            String libPath = null;
            if (sdkDir.exists() && sdkDir.isDirectory()) {
                boolean os32 = System.getProperty("sun.arch.data.model", "32").equals("32");
                File libDir = new File(sdkDir, VzLPRSDKLibraryFactory.getLibDirName(os32));
                if (!libDir.exists() || !libDir.isDirectory()) {
                    TransportUtil.getLog().warn((Object)("Directory does not exist, lib path cannot be found: " + libDir));
                } else {
                    File file = new File(libDir, VzLPRSDKLibraryFactory.getLibFileName());
                    if (file.exists() && file.isFile()) {
                        libPath = file.getAbsolutePath();
                    } else {
                        TransportUtil.getLog().warn((Object)("Unable to find dynamic library file :" + file.getAbsolutePath()));
                    }
                }
            }
            VzLPRSDKLibraryFactory.loadLibrary(libPath);
        }
        if (initedSdk) return instance;
        Class<VzLPRSDKLibrary> clazz = VzLPRSDKLibrary.class;
        synchronized (VzLPRSDKLibrary.class) {
            if (initedSdk) return instance;
            instance.VzLPRClient_Setup();
            initedSdk = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isInited() {
        return instance != null && initedSdk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseSdk() {
        Class<VzLPRSDKLibrary> clazz = VzLPRSDKLibrary.class;
        synchronized (VzLPRSDKLibrary.class) {
            if (instance != null && initedSdk) {
                initedSdk = false;
                instance.VzLPRClient_Cleanup();
                instance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void onClose() throws Exception {
        VzLPRSDKLibraryFactory.releaseSdk();
    }
}

