/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JavaBeanUtil;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.KeyValue;
import com.wovoe.framework.rpc.impl.ClassSerialize;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CommonParamSerializeTool {
    public static final String NODENAME_FILED = "field";
    public static final String NODENAME_KV = "kv";
    public static final String NODENAME_V = "v";
    public static final String NODENAME_VALUE = "value";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_TYPE_NULL = "NULL";
    private static Map<String, Class<?>> classMap = new ConcurrentHashMap();
    private static ClassLoader classLoader;
    private static final String emptryStr = "";

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static void setClassLoader(ClassLoader classLoader0) {
        classLoader = classLoader0;
    }

    public static String toXml(Collection<CommonParam> params) throws Exception {
        StringBuilder returnStr = new StringBuilder(1024);
        for (CommonParam p : params) {
            returnStr.append(CommonParamSerializeTool.toXml(p));
        }
        return returnStr.toString();
    }

    public static String toXml(CommonParam param) throws Exception {
        StringBuilder returnStr = new StringBuilder(1024);
        returnStr.append("<commonParam>");
        Object[] invokeParam = new Object[]{};
        Map methodsMap = JavaBeanUtil.getGetSetMethods(param.getClass());
        for (Map.Entry entry : methodsMap.entrySet()) {
            Object obj;
            if (((JavaBeanUtil.GetSetMethod)entry.getValue()).getGetMethod() == null || (obj = ((JavaBeanUtil.GetSetMethod)entry.getValue()).getGetMethod().invoke((Object)param, invokeParam)) == null) continue;
            returnStr.append("<field name=\"").append((String)entry.getKey()).append('\"').append(" type=\"").append(obj.getClass().getName()).append("\">");
            if (obj instanceof Collection) {
                Collection list = (Collection)obj;
                for (Object lisv : list) {
                    if (lisv instanceof KeyValue) {
                        KeyValue kv = (KeyValue)lisv;
                        returnStr.append("<kv name=\"").append(kv.getKey()).append('\"');
                        if (kv.getValue() == null) {
                            returnStr.append(" type=\"NULL\"/>");
                            continue;
                        }
                        returnStr.append(" type=\"").append(kv.getValue().getClass().getName()).append("\">");
                        if (kv.getValue() instanceof Collection) {
                            Collection vlist = (Collection)kv.getValue();
                            for (Object v1 : vlist) {
                                if (v1 == null) {
                                    returnStr.append("<value type=\"NULL\"/>");
                                    continue;
                                }
                                returnStr.append("<value type=\"").append(v1.getClass().getName()).append("\">");
                                if (v1 instanceof String && ((String)v1).length() > 0 || v1 instanceof java.util.Date) {
                                    returnStr.append("<![CDATA[").append(CommonParamSerializeTool.toStringObject(v1)).append("]]>");
                                } else {
                                    returnStr.append(CommonParamSerializeTool.toStringObject(v1));
                                }
                                returnStr.append("</value>");
                            }
                        } else if (kv.getValue() instanceof String && ((String)kv.getValue()).length() > 0 || kv.getValue() instanceof java.util.Date) {
                            returnStr.append("<![CDATA[").append(CommonParamSerializeTool.toStringObject(kv.getValue())).append("]]>");
                        } else {
                            returnStr.append(CommonParamSerializeTool.toStringObject(kv.getValue()));
                        }
                        returnStr.append("</kv>");
                        continue;
                    }
                    if (lisv == null) {
                        returnStr.append("<v type=\"NULL\"/>");
                        continue;
                    }
                    returnStr.append("<v type=\"").append(lisv.getClass().getName()).append("\">");
                    if (lisv instanceof String && ((String)lisv).length() > 0 || lisv instanceof java.util.Date) {
                        returnStr.append("<![CDATA[").append(CommonParamSerializeTool.toStringObject(lisv)).append("]]>");
                    } else {
                        returnStr.append(CommonParamSerializeTool.toStringObject(lisv));
                    }
                    returnStr.append("</v>");
                }
            } else {
                returnStr.append("<![CDATA[").append(CommonParamSerializeTool.toStringObject(obj)).append("]]>");
            }
            returnStr.append("</field>");
        }
        returnStr.append("</commonParam>");
        return returnStr.toString();
    }

    public static String serialize(CommonParam param) throws Exception {
        StringBuilder returnStr = new StringBuilder(1024);
        returnStr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        returnStr.append("<xml>");
        returnStr.append(CommonParamSerializeTool.toXml(param));
        returnStr.append("</xml>");
        return returnStr.toString();
    }

    public static String serialize(Collection<CommonParam> params) throws Exception {
        StringBuilder returnStr = new StringBuilder(1024);
        returnStr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        returnStr.append("<xml>");
        returnStr.append(CommonParamSerializeTool.toXml(params));
        returnStr.append("</xml>");
        return returnStr.toString();
    }

    private static Class<?> getClassType(String classTypeName) throws ClassNotFoundException {
        Class<?> cl = classMap.get(classTypeName);
        if (cl == null) {
            cl = classLoader == null ? Class.forName(classTypeName) : Class.forName(classTypeName, true, classLoader);
            classMap.put(classTypeName, cl);
        }
        return cl;
    }

    public static List<CommonParam> deserialize(Reader reader) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(reader));
        Map methodsMap = JavaBeanUtil.getGetSetMethods(CommonParam.class);
        NodeList commonParamNodeList = document.getFirstChild().getChildNodes();
        if (commonParamNodeList == null || commonParamNodeList.getLength() == 0) {
            return new ArrayList<CommonParam>(0);
        }
        int slzise = commonParamNodeList.getLength();
        ArrayList<CommonParam> returnList = new ArrayList<CommonParam>(slzise);
        int kj = 0;
        while (kj < slzise) {
            Node commonParamNode = commonParamNodeList.item(kj);
            CommonParam commonParam = new CommonParam();
            returnList.add(commonParam);
            NodeList fieldNodes = commonParamNode.getChildNodes();
            int len0 = fieldNodes.getLength();
            int i0 = 0;
            while (i0 < len0) {
                NamedNodeMap attrMap0;
                Node fieldNode = fieldNodes.item(i0);
                if (NODENAME_FILED.equals(fieldNode.getNodeName()) && (attrMap0 = fieldNode.getAttributes()) != null) {
                    String fieldName = null;
                    String fieldType = null;
                    int i = 0;
                    while (i < attrMap0.getLength()) {
                        Node attribute = attrMap0.item(i);
                        String attrName = attribute.getNodeName();
                        if (ATTR_NAME.equals(attrName)) {
                            fieldName = attribute.getNodeValue();
                        } else if (ATTR_TYPE.equals(attrName)) {
                            fieldType = attribute.getNodeValue();
                        }
                        ++i;
                    }
                    if (fieldName == null || fieldName.length() == 0) {
                        throw new Exception("field attr name value is null or emptry!");
                    }
                    if (fieldType == null || fieldType.length() == 0) {
                        throw new Exception("field attr type value is null or emptry!");
                    }
                    JavaBeanUtil.GetSetMethod m = (JavaBeanUtil.GetSetMethod)methodsMap.get(fieldName);
                    if (m != null && m.getSetMethod() != null && !ATTR_TYPE_NULL.equals(fieldType)) {
                        Class<?> cl = CommonParamSerializeTool.getClassType(fieldType);
                        if (Collection.class.isAssignableFrom(cl)) {
                            List list1 = cl.isInterface() ? new ArrayList() : (List)cl.newInstance();
                            m.getSetMethod().invoke((Object)commonParam, list1);
                            NodeList kvVNodesList = fieldNode.getChildNodes();
                            if (kvVNodesList == null || kvVNodesList.getLength() == 0) {
                                throw new Exception("field is List node, but kv or v node not found!");
                            }
                            int len1 = kvVNodesList.getLength();
                            int i1 = 0;
                            while (i1 < len1) {
                                Node kvVNode = kvVNodesList.item(i1);
                                String kvVNodeName = kvVNode.getNodeName();
                                if (NODENAME_KV.equals(kvVNodeName)) {
                                    String kvName = null;
                                    String kvType = null;
                                    NamedNodeMap attrMapkv = kvVNode.getAttributes();
                                    int i2 = 0;
                                    while (i2 < attrMapkv.getLength()) {
                                        Node attribute = attrMapkv.item(i2);
                                        String attrName = attribute.getNodeName();
                                        if (ATTR_NAME.equals(attrName)) {
                                            kvName = attribute.getNodeValue();
                                        } else if (ATTR_TYPE.equals(attrName)) {
                                            kvType = attribute.getNodeValue();
                                        }
                                        ++i2;
                                    }
                                    if (kvName == null || kvName.length() == 0) {
                                        throw new Exception("field/kv attr name value is null or emptry!");
                                    }
                                    if (kvType == null || kvType.length() == 0) {
                                        throw new Exception("field/kv attr type value is null or emptry!");
                                    }
                                    KeyValue keyValue = new KeyValue();
                                    keyValue.setKey((Object)kvName);
                                    if (ATTR_TYPE_NULL.equals(kvType)) {
                                        keyValue.setValue(null);
                                    } else {
                                        Class<?> kvClass = CommonParamSerializeTool.getClassType(kvType);
                                        if (Collection.class.isAssignableFrom(kvClass)) {
                                            List list2 = kvClass.isInterface() ? new ArrayList() : (List)kvClass.newInstance();
                                            keyValue.setValue(list2);
                                            NodeList valueNodesList = kvVNode.getChildNodes();
                                            if (valueNodesList == null || valueNodesList.getLength() == 0) {
                                                throw new Exception("field/kv is List node, but value node not found!");
                                            }
                                            int len2 = valueNodesList.getLength();
                                            int i22 = 0;
                                            while (i22 < len2) {
                                                Node valueNode = valueNodesList.item(i22);
                                                if (NODENAME_VALUE.equals(valueNode.getNodeName())) {
                                                    String vType = null;
                                                    NamedNodeMap attrMapv = valueNode.getAttributes();
                                                    int i3 = 0;
                                                    while (i3 < attrMapv.getLength()) {
                                                        Node attribute = attrMapv.item(i3);
                                                        String attrName = attribute.getNodeName();
                                                        if (ATTR_TYPE.equals(attrName)) {
                                                            vType = attribute.getNodeValue();
                                                            break;
                                                        }
                                                        ++i3;
                                                    }
                                                    if (vType == null || vType.length() == 0) {
                                                        throw new Exception("field/kv/value attr type value is null or emptry!");
                                                    }
                                                    if (ATTR_TYPE_NULL.equals(vType)) {
                                                        list2.add(null);
                                                    } else {
                                                        String value = valueNode.getTextContent();
                                                        Class<?> vClass = CommonParamSerializeTool.getClassType(vType);
                                                        if (String.class.equals(vClass)) {
                                                            if (value == null) {
                                                                value = emptryStr;
                                                            }
                                                        } else if (value == null || value.length() == 0) {
                                                            throw new Exception("field/kv/value node text is null or emptry!");
                                                        }
                                                        list2.add(CommonParamSerializeTool.toObject(value, vClass));
                                                    }
                                                } else {
                                                    throw new Exception("unkonwn node :" + valueNode.getNodeName() + ", parent: kv/" + fieldNode.getNodeName());
                                                }
                                                ++i22;
                                            }
                                        } else {
                                            String value = kvVNode.getTextContent();
                                            if (String.class.equals(kvClass)) {
                                                if (value == null) {
                                                    value = emptryStr;
                                                }
                                            } else if (value == null || value.length() == 0) {
                                                throw new Exception("field/kv node text is null or emptry!");
                                            }
                                            keyValue.setValue(CommonParamSerializeTool.toObject(value, kvClass));
                                        }
                                    }
                                    list1.add(keyValue);
                                } else if (NODENAME_V.equals(kvVNodeName)) {
                                    String vType = null;
                                    NamedNodeMap attrMapv = kvVNode.getAttributes();
                                    int i4 = 0;
                                    while (i4 < attrMapv.getLength()) {
                                        Node attribute = attrMapv.item(i4);
                                        String attrName = attribute.getNodeName();
                                        if (ATTR_TYPE.equals(attrName)) {
                                            vType = attribute.getNodeValue();
                                            break;
                                        }
                                        ++i4;
                                    }
                                    if (vType == null || vType.length() == 0) {
                                        throw new Exception("field/v attr type value is null or emptry!");
                                    }
                                    if (ATTR_TYPE_NULL.equals(vType)) {
                                        list1.add(null);
                                    } else {
                                        Class<?> vClass = CommonParamSerializeTool.getClassType(vType);
                                        String value = kvVNode.getTextContent();
                                        if (String.class.equals(vClass)) {
                                            if (value == null) {
                                                value = emptryStr;
                                            }
                                        } else if (value == null || value.length() == 0) {
                                            throw new Exception("field/v node text is null or emptry!");
                                        }
                                        list1.add(CommonParamSerializeTool.toObject(value, vClass));
                                    }
                                } else {
                                    throw new Exception("unkonwn node :" + kvVNodeName + ", parent: " + fieldNode.getNodeName());
                                }
                                ++i1;
                            }
                        } else {
                            String value = fieldNode.getTextContent();
                            if (String.class.equals(cl)) {
                                if (value == null) {
                                    value = emptryStr;
                                }
                            } else if (value == null || value.length() == 0) {
                                throw new Exception("field node text is null or emptry!");
                            }
                            m.getSetMethod().invoke((Object)commonParam, CommonParamSerializeTool.toObject(value, cl));
                        }
                    }
                }
                ++i0;
            }
            ++kj;
        }
        return returnList;
    }

    public static List<CommonParam> deserialize(String paramXml) throws Exception {
        return CommonParamSerializeTool.deserialize(new StringReader(paramXml));
    }

    public static String serializeQueryResultList(List<Map<String, Object>> resultList, Long recordsCount) {
        StringBuilder returnStr = new StringBuilder(1024);
        returnStr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        returnStr.append("<xml>");
        if (recordsCount != null) {
            returnStr.append("<recordsCount>").append(recordsCount).append("</recordsCount>");
        }
        if (resultList != null && !resultList.isEmpty()) {
            returnStr.append("<records size=\"").append(resultList == null ? 0 : resultList.size()).append('\"').append('>');
            for (Map<String, Object> m : resultList) {
                returnStr.append("<record>");
                for (Map.Entry<String, Object> entry : m.entrySet()) {
                    if (entry.getKey() == null || entry.getKey().length() <= 0) continue;
                    if (entry.getValue() != null) {
                        returnStr.append('<').append(entry.getKey()).append(' ').append(ATTR_TYPE).append('=').append('\"').append(entry.getValue().getClass().getName()).append('\"').append('>');
                        if (entry.getValue() instanceof String && ((String)entry.getValue()).length() > 0 || entry.getValue() instanceof java.util.Date) {
                            returnStr.append("<![CDATA[").append(CommonParamSerializeTool.toStringObject(entry.getValue())).append("]]>");
                        } else {
                            returnStr.append(CommonParamSerializeTool.toStringObject(entry.getValue()));
                        }
                        returnStr.append('<').append('/').append(entry.getKey()).append('>');
                        continue;
                    }
                    returnStr.append('<').append(entry.getKey()).append(' ').append(ATTR_TYPE).append('=').append('\"').append(ATTR_TYPE_NULL).append('\"').append('/').append('>');
                }
                returnStr.append("</record>");
            }
            returnStr.append("</records>");
        } else {
            returnStr.append("<records size=\"0\"/>");
        }
        returnStr.append("</xml>");
        return returnStr.toString();
    }

    public static KeyValue<List<Map<String, Object>>, Long> deserializeQueryResult(String resultXml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(resultXml)));
        NodeList allNodes = document.getFirstChild().getChildNodes();
        if (allNodes == null || allNodes.getLength() == 0) {
            throw new Exception("<recordsCount> or <records> not Found!");
        }
        String nodeNamerecordsCount = "recordsCount";
        String nodeNamerecords = "records";
        KeyValue entry = new KeyValue();
        int i = 0;
        while (i < allNodes.getLength()) {
            NodeList recordNodeList;
            Node node = allNodes.item(i);
            if (nodeNamerecordsCount.equals(node.getNodeName())) {
                String value = node.getTextContent();
                if (value == null || value.length() == 0) {
                    throw new Exception("recordsCount node text is null or emptry!");
                }
                entry.setValue((Object)Long.valueOf(value));
            } else if (nodeNamerecords.equals(node.getNodeName()) && (recordNodeList = node.getChildNodes()) != null && recordNodeList.getLength() > 0) {
                int size = recordNodeList.getLength();
                ArrayList resultList = new ArrayList(size);
                entry.setKey(resultList);
                int y = 0;
                while (y < size) {
                    Node recordNode = recordNodeList.item(y);
                    LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
                    resultList.add(dataMap);
                    NodeList dataNodeList = recordNode.getChildNodes();
                    int dataLen = dataNodeList.getLength();
                    int z = 0;
                    while (z < dataLen) {
                        Node dataNode = dataNodeList.item(z);
                        String vType = null;
                        NamedNodeMap attrMapv = dataNode.getAttributes();
                        int x = 0;
                        while (x < attrMapv.getLength()) {
                            Node attribute = attrMapv.item(x);
                            String attrName = attribute.getNodeName();
                            if (ATTR_TYPE.equals(attrName)) {
                                vType = attribute.getNodeValue();
                                break;
                            }
                            ++x;
                        }
                        if (vType == null || vType.length() == 0) {
                            throw new Exception("records/record/" + dataNode.getNodeName() + " attr " + ATTR_TYPE + " value is null or emptry!");
                        }
                        if (ATTR_TYPE_NULL.equals(vType)) {
                            dataMap.put(dataNode.getNodeName(), null);
                        } else {
                            String value = dataNode.getTextContent();
                            Class<?> vClass = CommonParamSerializeTool.getClassType(vType);
                            if (String.class.equals(vClass)) {
                                if (value == null) {
                                    value = emptryStr;
                                }
                            } else if (value == null || value.length() == 0) {
                                throw new Exception("records/record/" + dataNode.getNodeName() + " node text is null or emptry!");
                            }
                            dataMap.put(dataNode.getNodeName(), CommonParamSerializeTool.toObject(value, vClass));
                        }
                        ++z;
                    }
                    ++y;
                }
            }
            ++i;
        }
        if (entry.getKey() == null) {
            entry.setKey(new ArrayList(0));
        }
        return entry;
    }

    public static String toStringObject(Object value) {
        if (value == null) {
            return null;
        }
        SimpleDateFormat df = null;
        if (value instanceof Date) {
            df = new SimpleDateFormat("yyyy-MM-dd");
        } else if (value instanceof Time) {
            df = new SimpleDateFormat("HH:mm:ss");
        } else if (value instanceof java.util.Date) {
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return CommonParamSerializeTool.toStringObject(value, df);
    }

    public static String toStringObject(Object value, SimpleDateFormat df) {
        String v;
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date) {
            v = df.format((java.util.Date)value);
        } else if (value instanceof String || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof Boolean) {
            v = value.toString();
        } else {
            try {
                byte[] data = ClassSerialize.getInstance().toBytes(value);
                v = BytesTool.compressBytes((byte[])data);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return v;
    }

    public static Object toObject(String value, Class<?> classType) {
        if (classType == null) {
            throw new NullPointerException("classType  can not be null");
        }
        if (Integer.TYPE.equals(classType) || Integer.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                if (Integer.TYPE.equals(classType)) {
                    return 0;
                }
                return null;
            }
            return Integer.valueOf(value);
        }
        if (Long.TYPE.equals(classType) || Long.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                if (Long.TYPE.equals(classType)) {
                    return 0L;
                }
                return null;
            }
            return Long.valueOf(value);
        }
        if (Byte.TYPE.equals(classType) || Byte.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                if (Byte.TYPE.equals(classType)) {
                    return (byte)0;
                }
                return null;
            }
            return Byte.valueOf(value);
        }
        if (Short.TYPE.equals(classType) || Short.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                if (Short.TYPE.equals(classType)) {
                    return (short)0;
                }
                return null;
            }
            return Short.valueOf(value);
        }
        if (Float.TYPE.equals(classType) || Float.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                if (Float.TYPE.equals(classType)) {
                    return Float.valueOf(0.0f);
                }
                return null;
            }
            return Float.valueOf(value);
        }
        if (Double.TYPE.equals(classType) || Double.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                if (Double.TYPE.equals(classType)) {
                    return 0.0;
                }
                return null;
            }
            return Double.valueOf(value);
        }
        if (Boolean.TYPE.equals(classType) || Boolean.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                if (Boolean.TYPE.equals(classType)) {
                    return false;
                }
                return null;
            }
            return Boolean.valueOf(value);
        }
        if (String.class.equals(classType)) {
            return value;
        }
        if (BigDecimal.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                return null;
            }
            return new BigDecimal(value);
        }
        if (Date.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                return null;
            }
            try {
                long c = new SimpleDateFormat("yyyy-MM-dd").parse(value).getTime();
                return new Date(c);
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (Time.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                return null;
            }
            try {
                long c = new SimpleDateFormat("HH:mm:ss").parse(value).getTime();
                return new Time(c);
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (Timestamp.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                return null;
            }
            try {
                long c = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value).getTime();
                return new Timestamp(c);
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (java.util.Date.class.equals(classType)) {
            if (value == null || value.length() == 0) {
                return null;
            }
            try {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        byte[] data = BytesTool.unCompress((String)value);
        try {
            return ClassSerialize.getInstance().readObject((InputStream)new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

