/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.MutiSpaceCarAlgorithm;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultMutiSpaceCarAlgorithm
implements MutiSpaceCarAlgorithm {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyValueEntry<CarparkPassportType, CarparkPassport> getPassportAndTypeByMutiCar(CarparkPassport passport, CarparkPassportType passportType, int exitOrEnter, CarparkArea passArea, AtomicReference<CarparkPresenceRecord> takeRecordInfo, List<CarparkPresenceRecord> existMutiCarEnterRecords) {
        block216: {
            try {
                if (passport == null || passportType == null || passArea == null) {
                    return null;
                }
                if (passport.getMedium_type() != 6 || passport.getCar_owner_no() == null || passport.getCar_owner_no().length() == 0 || passport.getRegister_plate() == null || passport.getRegister_plate().length() == 0) {
                    return null;
                }
                List passportList = null;
                Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                if (passportType.getPass_type() == 1) {
                    if (!"1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE"))) {
                        return null;
                    }
                    if (!"1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT"))) {
                        return null;
                    }
                    if (!"1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "STOREAGE_MUIT_SPACE_CAR"))) {
                        return null;
                    }
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    Integer project_id = ServiceUtil.getServiceContext().getProjectId();
                    Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
                    passportList = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("car_owner_no", (Object)passport.getCar_owner_no()), CarparkPassport.class, null);
                    if (passportList == null || passportList.size() <= 1) {
                        return null;
                    }
                    LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>> templist = new LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>>();
                    LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>> storelist = new LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>>();
                    boolean existNotStoreType = false;
                    boolean findCurrent = false;
                    for (CarparkPassport carOwnerPassport : passportList) {
                        CarparkPassportType type;
                        if (carOwnerPassport.getRegister_plate() == null || carOwnerPassport.getRegister_plate().length() == 0 || (type = passportTypeMap.get(carOwnerPassport.getPassport_type_no())) == null) continue;
                        if (type.getPass_type() == 1) {
                            if (!"1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(type.getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT")) || !"1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(type.getPassport_type_no(), "STOREAGE_MUIT_SPACE_CAR"))) continue;
                            storelist.add((KeyValueEntry<CarparkPassportType, CarparkPassport>)new KeyValueEntry((Object)type, (Object)carOwnerPassport));
                            if (findCurrent || !carOwnerPassport.getRegister_plate().equals(passport.getRegister_plate())) continue;
                            findCurrent = true;
                            continue;
                        }
                        if (type.getPass_type() == 0) {
                            if (type.getUse_muti_car() == null || type.getUse_muti_car() != 1) continue;
                            templist.add((KeyValueEntry<CarparkPassportType, CarparkPassport>)new KeyValueEntry((Object)type, (Object)carOwnerPassport));
                            continue;
                        }
                        if (type.getUse_muti_car() == null || type.getUse_muti_car() != 1) continue;
                        existNotStoreType = true;
                        break;
                    }
                    if (existNotStoreType) {
                        return null;
                    }
                    if (!findCurrent) {
                        return null;
                    }
                    if (templist.isEmpty() || storelist.isEmpty()) {
                        return null;
                    }
                    return this.getPassportAndTypeByStorageMutiCar(passport, passportType, exitOrEnter, passArea, takeRecordInfo, existMutiCarEnterRecords, templist, storelist, commonDaoService);
                }
                if (passportType.getPass_type() == 0 && passportType.getUse_muti_car() != null && passportType.getUse_muti_car() == 1 && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE"))) {
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    Integer project_id = ServiceUtil.getServiceContext().getProjectId();
                    Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
                    passportList = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("car_owner_no", (Object)passport.getCar_owner_no()), CarparkPassport.class, null);
                    if (passportList == null || passportList.size() <= 1) {
                        return null;
                    }
                    LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>> templist = new LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>>();
                    LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>> storelist = new LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>>();
                    boolean existNotStoreType = false;
                    boolean findCurrent = false;
                    for (CarparkPassport carOwnerPassport : passportList) {
                        CarparkPassportType type;
                        if (carOwnerPassport.getRegister_plate() == null || carOwnerPassport.getRegister_plate().length() == 0 || (type = passportTypeMap.get(carOwnerPassport.getPassport_type_no())) == null) continue;
                        if (type.getPass_type() == 1) {
                            if (!"1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(type.getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT")) || !"1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(type.getPassport_type_no(), "STOREAGE_MUIT_SPACE_CAR"))) continue;
                            storelist.add((KeyValueEntry<CarparkPassportType, CarparkPassport>)new KeyValueEntry((Object)type, (Object)carOwnerPassport));
                            continue;
                        }
                        if (type.getPass_type() == 0) {
                            if (type.getUse_muti_car() == null || type.getUse_muti_car() != 1) continue;
                            templist.add((KeyValueEntry<CarparkPassportType, CarparkPassport>)new KeyValueEntry((Object)type, (Object)carOwnerPassport));
                            if (findCurrent || !carOwnerPassport.getRegister_plate().equals(passport.getRegister_plate())) continue;
                            findCurrent = true;
                            continue;
                        }
                        if (type.getUse_muti_car() == null || type.getUse_muti_car() != 1) continue;
                        existNotStoreType = true;
                        break;
                    }
                    if (!existNotStoreType && findCurrent && !templist.isEmpty() && !storelist.isEmpty()) {
                        return this.getPassportAndTypeByStorageMutiCar(passport, passportType, exitOrEnter, passArea, takeRecordInfo, existMutiCarEnterRecords, templist, storelist, commonDaoService);
                    }
                }
                if (passportType.getUse_muti_car() == null || passportType.getUse_muti_car() != 1) break block216;
                String ONESPACE_MUTICARS_VALUE = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("ONESPACE_MUTICARS");
                if (ONESPACE_MUTICARS_VALUE == null || ONESPACE_MUTICARS_VALUE.length() == 0) {
                    ONESPACE_MUTICARS_VALUE = "1";
                }
                if (!"1".equals(ONESPACE_MUTICARS_VALUE) && !"2".equals(ONESPACE_MUTICARS_VALUE)) break block216;
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                Integer project_id = ServiceUtil.getServiceContext().getProjectId();
                Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
                if (passportList == null) {
                    passportList = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("car_owner_no", (Object)passport.getCar_owner_no()), CarparkPassport.class, null);
                }
                if (passportList == null || passportList.size() <= 1) break block216;
                LinkedList<KeyValueEntry> templist = new LinkedList<KeyValueEntry>();
                LinkedList<KeyValueEntry> fixedlist = new LinkedList<KeyValueEntry>();
                LinkedList<KeyValueEntry> fixedlist1 = new LinkedList<KeyValueEntry>();
                final HashMap<String, String> passportTypeAreaMap = new HashMap<String, String>();
                boolean hasAreaSpace = false;
                boolean isTempFinded = false;
                boolean isFixtFinded = false;
                HashMap<String, String> platesMap = new HashMap<String, String>();
                Date now = new Date();
                for (CarparkPassport p : passportList) {
                    CarparkPassportType pt;
                    if (p.getRegister_plate() == null || p.getRegister_plate().length() == 0 || p.getMedium_type() != 6 || (pt = passportTypeMap.get(p.getPassport_type_no())) == null) continue;
                    if (p.getPassport_state() == 2) {
                        boolean isStop;
                        boolean bl = isStop = p.getStop_date() != null && p.getStop_date().before(now);
                        if (isStop) {
                            continue;
                        }
                    } else if (p.getPassport_state() != 0) continue;
                    if (pt.getUse_muti_car() == null || pt.getUse_muti_car() != 1) continue;
                    if (pt.getPass_type() == 2) {
                        boolean isNotStart;
                        boolean bl = isNotStart = p.getStart_date() != null && p.getStart_date().after(now);
                        if (isNotStart) continue;
                    }
                    Boolean temp = null;
                    if (pt.getPass_type() == 0) {
                        temp = Boolean.TRUE;
                    } else if (pt.getPass_type() == 2 || pt.getPass_type() == 4) {
                        temp = Boolean.FALSE;
                    }
                    if (temp == null) continue;
                    platesMap.put(p.getRegister_plate(), p.getPassport_no());
                    KeyValueEntry e = new KeyValueEntry((Object)pt, (Object)p);
                    passportTypeAreaMap.put(pt.getPassport_type_no(), Constants.NO_STR);
                    if (temp.booleanValue()) {
                        templist.add(e);
                        if (isTempFinded || !p.getRegister_plate().equals(passport.getRegister_plate())) continue;
                        isTempFinded = true;
                        continue;
                    }
                    String _num = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(((CarparkPassportType)e.getKey()).getPassport_type_no(), "PASSPORTTYPE_SPACE_NUM");
                    int num = 1;
                    if (_num != null && _num.length() > 0) {
                        try {
                            num = Integer.parseInt(_num);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (num < 1) {
                        num = 1;
                    } else if (num > 1000) {
                        num = 1000;
                    }
                    int i = 0;
                    while (i < num) {
                        fixedlist.add(e);
                        fixedlist1.add(e);
                        ++i;
                    }
                    if (isFixtFinded || !p.getRegister_plate().equals(passport.getRegister_plate())) continue;
                    isFixtFinded = true;
                }
                if (!fixedlist.isEmpty() && (isFixtFinded || isTempFinded)) {
                    LinkedList passoprtTypeNos = new LinkedList();
                    passoprtTypeNos.addAll(passportTypeAreaMap.keySet());
                    boolean hasDefineAreaNo = false;
                    Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
                    for (String x : passoprtTypeNos) {
                        String configAreaNo = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(x, "PASSPORTTYPE_BELONG_AREA");
                        if (configAreaNo == null || configAreaNo.length() <= 0 || Constants.NO_STR.equals(configAreaNo) || !areaMap.containsKey(configAreaNo)) continue;
                        passportTypeAreaMap.put(x, configAreaNo);
                        if (hasDefineAreaNo) continue;
                        hasDefineAreaNo = true;
                    }
                    for (KeyValueEntry en : fixedlist) {
                        String areNo = (String)passportTypeAreaMap.get(((CarparkPassportType)en.getKey()).getPassport_type_no());
                        if (Constants.NO_STR.equals(areNo)) {
                            hasAreaSpace = true;
                            break;
                        }
                        if (!passArea.getArea_no().equals(areNo)) continue;
                        hasAreaSpace = true;
                        break;
                    }
                    if (!hasAreaSpace) {
                        return null;
                    }
                    if (templist.isEmpty() && !hasDefineAreaNo) {
                        return null;
                    }
                    final String passAreaNo = passArea.getArea_no();
                    Comparator<KeyValueEntry<CarparkPassportType, CarparkPassport>> spaceOrder = new Comparator<KeyValueEntry<CarparkPassportType, CarparkPassport>>(){
                        Date now = new Date();

                        @Override
                        public int compare(KeyValueEntry<CarparkPassportType, CarparkPassport> o1, KeyValueEntry<CarparkPassportType, CarparkPassport> o2) {
                            String area1 = (String)passportTypeAreaMap.get(((CarparkPassportType)o1.getKey()).getPassport_type_no());
                            String area2 = (String)passportTypeAreaMap.get(((CarparkPassportType)o2.getKey()).getPassport_type_no());
                            if (area1 == null || area1.length() == 0) {
                                area1 = Constants.NO_STR;
                            }
                            if (area2 == null || area2.length() == 0) {
                                area2 = Constants.NO_STR;
                            }
                            if (area1.equals(passAreaNo) && !area2.equals(passAreaNo)) {
                                return -1;
                            }
                            if (!area1.equals(passAreaNo) && area2.equals(passAreaNo)) {
                                return 1;
                            }
                            if (area1.equals(Constants.NO_STR) && !area2.equals(Constants.NO_STR)) {
                                return -1;
                            }
                            if (!area1.equals(Constants.NO_STR) && area2.equals(Constants.NO_STR)) {
                                return 1;
                            }
                            if (((CarparkPassportType)o1.getKey()).getPass_type() == 4 && ((CarparkPassportType)o2.getKey()).getPass_type() == 4) {
                                return ((CarparkPassportType)o1.getKey()).getPassport_type_no().compareTo(((CarparkPassportType)o2.getKey()).getPassport_type_no());
                            }
                            if (((CarparkPassportType)o1.getKey()).getPass_type() == 4 && ((CarparkPassportType)o2.getKey()).getPass_type() != 4) {
                                return -1;
                            }
                            if (((CarparkPassportType)o1.getKey()).getPass_type() != 4 && ((CarparkPassportType)o2.getKey()).getPass_type() == 4) {
                                return 1;
                            }
                            if (((CarparkPassport)o1.getValue()).getStart_date() != null && ((CarparkPassport)o1.getValue()).getStart_date().after(this.now)) {
                                return 1;
                            }
                            if (((CarparkPassport)o2.getValue()).getStart_date() != null && ((CarparkPassport)o2.getValue()).getStart_date().after(this.now)) {
                                return -1;
                            }
                            if (((CarparkPassport)o1.getValue()).getDeadline() == null && ((CarparkPassport)o2.getValue()).getDeadline() == null) {
                                return ((CarparkPassport)o1.getValue()).getPassport_no().compareTo(((CarparkPassport)o2.getValue()).getPassport_no());
                            }
                            if (((CarparkPassport)o1.getValue()).getDeadline() != null && ((CarparkPassport)o2.getValue()).getDeadline() == null) {
                                return 1;
                            }
                            if (((CarparkPassport)o1.getValue()).getDeadline() == null && ((CarparkPassport)o2.getValue()).getDeadline() != null) {
                                return -1;
                            }
                            if (((CarparkPassport)o1.getValue()).getDeadline().after(((CarparkPassport)o2.getValue()).getDeadline())) {
                                return -1;
                            }
                            if (((CarparkPassport)o1.getValue()).getDeadline().before(((CarparkPassport)o2.getValue()).getDeadline())) {
                                return 1;
                            }
                            return ((CarparkPassportType)o1.getKey()).getPassport_type_no().compareTo(((CarparkPassportType)o2.getKey()).getPassport_type_no());
                        }
                    };
                    Collections.sort(fixedlist, spaceOrder);
                    LinkedList<CarparkPresenceRecord> passAreaPresenceRecords = new LinkedList<CarparkPresenceRecord>();
                    LinkedHashMap<String, CarparkPresenceRecord> parentAreaPresenceRecordsMap = null;
                    LinkedHashMap<String, CarparkPresenceRecord> subAreaPresenceRecordsMap = null;
                    SearchParam searchParam = new SearchParam();
                    searchParam.addEQ("car_owner_no", (Object)passport.getCar_owner_no());
                    if (platesMap.size() <= 1000) {
                        searchParam.addINList("passport_number", platesMap.keySet());
                    }
                    searchParam.addEQ("medium_type", (Object)6);
                    if (exitOrEnter == 0) {
                        List<String> subAreaList = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(passArea.getArea_no());
                        if (passArea.getArea_level() > 1) {
                            List<String> parentAreaList = ServiceUtil.getServiceContext().getDBConfigCache().getAllParentArea(passArea.getArea_no());
                            if (parentAreaList != null && !parentAreaList.isEmpty()) {
                                for (String string : parentAreaList) {
                                    searchParam.addIN("area_no", (Object)string);
                                }
                            }
                            searchParam.addIN("area_no", (Object)passArea.getArea_no());
                            if (subAreaList != null && !subAreaList.isEmpty()) {
                                for (String string : subAreaList) {
                                    searchParam.addIN("area_no", (Object)string);
                                }
                            }
                        } else if (subAreaList == null || subAreaList.isEmpty()) {
                            searchParam.addEQ("area_no", (Object)passArea.getArea_no());
                        } else {
                            searchParam.addIN("area_no", (Object)passArea.getArea_no());
                            for (String s : subAreaList) {
                                searchParam.addIN("area_no", (Object)s);
                            }
                        }
                    } else {
                        searchParam.addEQ("area_no", (Object)passArea.getArea_no());
                    }
                    searchParam.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                    searchParam.setOrerbySql("enter_time");
                    List prenseCarRecords0 = commonDaoService.selectList(searchParam, CarparkPresenceRecord.class, null);
                    if (prenseCarRecords0 != null && !prenseCarRecords0.isEmpty()) {
                        for (CarparkPresenceRecord r : prenseCarRecords0) {
                            if (r.getPassport_type_no() == null || r.getPassport_type_no().length() == 0 || r.getEnter_plate() == null || r.getArea_no() == null || r.getArea_level() == null || !passportTypeAreaMap.containsKey(r.getPassport_type_no()) || r.getEnter_time() == null || r.getExit_time() != null || !platesMap.containsKey(r.getEnter_plate())) continue;
                            if (r.getArea_level().intValue() == passArea.getArea_level().intValue()) {
                                passAreaPresenceRecords.add(r);
                                continue;
                            }
                            if (r.getArea_level() > passArea.getArea_level()) {
                                if (subAreaPresenceRecordsMap == null) {
                                    subAreaPresenceRecordsMap = new LinkedHashMap<String, CarparkPresenceRecord>();
                                }
                                subAreaPresenceRecordsMap.put(r.getEnter_plate(), r);
                                continue;
                            }
                            if (r.getArea_level() != 1) continue;
                            if (parentAreaPresenceRecordsMap == null) {
                                parentAreaPresenceRecordsMap = new LinkedHashMap<String, CarparkPresenceRecord>();
                            }
                            parentAreaPresenceRecordsMap.put(r.getEnter_plate(), r);
                        }
                    }
                    if (existMutiCarEnterRecords != null && !passAreaPresenceRecords.isEmpty()) {
                        existMutiCarEnterRecords.addAll(passAreaPresenceRecords);
                    }
                    if (exitOrEnter == 0) {
                        CarparkPassport newPassporrt;
                        String areaNo;
                        KeyValueEntry returnEn;
                        KeyValueEntry samePlateEn;
                        KeyValueEntry e;
                        Iterator it;
                        CarparkPassportType pt;
                        CarparkPresenceRecord r;
                        String areaNo2;
                        Object takeFixedRecord = null;
                        if (subAreaPresenceRecordsMap != null && !subAreaPresenceRecordsMap.isEmpty()) {
                            CarparkPresenceRecord r1;
                            Iterator itlist;
                            String areaNo3;
                            KeyValueEntry space;
                            Iterator it1;
                            CarparkPassportType pt2;
                            CarparkPresenceRecord r2;
                            KeyValueEntry en;
                            subAreaPresenceRecordsMap.remove(passport.getRegister_plate());
                            if (!subAreaPresenceRecordsMap.isEmpty()) {
                                Iterator iterator = subAreaPresenceRecordsMap.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    en = iterator.next();
                                    r2 = (CarparkPresenceRecord)en.getValue();
                                    pt2 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(r2.getPassport_type_no());
                                    if (pt2 != null && pt2.getPass_type() != 0 && r2.getOccupy_space_reg_no() != null && r2.getOccupy_space_reg_no().length() > 0) {
                                        it1 = fixedlist.iterator();
                                        while (it1.hasNext()) {
                                            space = (KeyValueEntry)it1.next();
                                            if (!((CarparkPassport)space.getValue()).getRegister_plate().equals(r2.getOccupy_space_reg_no()) || (areaNo3 = (String)passportTypeAreaMap.get(((CarparkPassportType)space.getKey()).getPassport_type_no())) == null || !areaNo3.equals(Constants.NO_STR) && !areaNo3.equals(r2.getArea_no())) continue;
                                            it1.remove();
                                            iterator.remove();
                                            itlist = passAreaPresenceRecords.iterator();
                                            while (itlist.hasNext()) {
                                                r1 = (CarparkPresenceRecord)itlist.next();
                                                if (!r1.getEnter_plate().equals(r2.getEnter_plate())) continue;
                                                itlist.remove();
                                                if (takeFixedRecord != null) break;
                                                takeFixedRecord = r1;
                                                break;
                                            }
                                            if (parentAreaPresenceRecordsMap == null) break;
                                            parentAreaPresenceRecordsMap.remove(r2.getEnter_plate());
                                            break;
                                        }
                                    }
                                    if (fixedlist.isEmpty()) break;
                                }
                            }
                            if (!subAreaPresenceRecordsMap.isEmpty() && !fixedlist.isEmpty()) {
                                Iterator iterator = subAreaPresenceRecordsMap.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    en = iterator.next();
                                    r2 = (CarparkPresenceRecord)en.getValue();
                                    pt2 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(r2.getPassport_type_no());
                                    if (pt2 != null && pt2.getPass_type() != 0) {
                                        it1 = fixedlist.iterator();
                                        while (it1.hasNext()) {
                                            space = (KeyValueEntry)it1.next();
                                            if (!((CarparkPassport)space.getValue()).getRegister_plate().equals(r2.getEnter_plate()) || !((CarparkPassportType)space.getKey()).getPassport_type_no().equals(r2.getPassport_type_no()) || (areaNo3 = (String)passportTypeAreaMap.get(((CarparkPassportType)space.getKey()).getPassport_type_no())) == null || !areaNo3.equals(Constants.NO_STR) && !areaNo3.equals(r2.getArea_no())) continue;
                                            it1.remove();
                                            iterator.remove();
                                            itlist = passAreaPresenceRecords.iterator();
                                            while (itlist.hasNext()) {
                                                r1 = (CarparkPresenceRecord)itlist.next();
                                                if (!r1.getEnter_plate().equals(r2.getEnter_plate())) continue;
                                                itlist.remove();
                                                if (takeFixedRecord != null) break;
                                                takeFixedRecord = r1;
                                                break;
                                            }
                                            if (parentAreaPresenceRecordsMap == null) break;
                                            parentAreaPresenceRecordsMap.remove(r2.getEnter_plate());
                                            break;
                                        }
                                    }
                                    if (fixedlist.isEmpty()) break;
                                }
                            }
                            if (!subAreaPresenceRecordsMap.isEmpty() && !fixedlist.isEmpty()) {
                                Iterator iterator = subAreaPresenceRecordsMap.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    en = iterator.next();
                                    r2 = (CarparkPresenceRecord)en.getValue();
                                    pt2 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(r2.getPassport_type_no());
                                    if (pt2 != null && pt2.getPass_type() != 0) {
                                        it1 = fixedlist.iterator();
                                        while (it1.hasNext()) {
                                            space = (KeyValueEntry)it1.next();
                                            if (!((CarparkPassportType)space.getKey()).getPassport_type_no().equals(r2.getPassport_type_no()) || (areaNo3 = (String)passportTypeAreaMap.get(((CarparkPassportType)space.getKey()).getPassport_type_no())) == null || !areaNo3.equals(Constants.NO_STR) && !areaNo3.equals(r2.getArea_no())) continue;
                                            it1.remove();
                                            iterator.remove();
                                            itlist = passAreaPresenceRecords.iterator();
                                            while (itlist.hasNext()) {
                                                r1 = (CarparkPresenceRecord)itlist.next();
                                                if (!r1.getEnter_plate().equals(r2.getEnter_plate())) continue;
                                                itlist.remove();
                                                if (takeFixedRecord != null) break;
                                                takeFixedRecord = r1;
                                                break;
                                            }
                                            if (parentAreaPresenceRecordsMap == null) break;
                                            parentAreaPresenceRecordsMap.remove(r2.getEnter_plate());
                                            break;
                                        }
                                    }
                                    if (fixedlist.isEmpty()) break;
                                }
                            }
                            if (!subAreaPresenceRecordsMap.isEmpty() && !fixedlist.isEmpty()) {
                                Iterator iterator = subAreaPresenceRecordsMap.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    en = iterator.next();
                                    r2 = (CarparkPresenceRecord)en.getValue();
                                    Iterator it12 = fixedlist.iterator();
                                    while (it12.hasNext()) {
                                        KeyValueEntry space2 = (KeyValueEntry)it12.next();
                                        areaNo2 = (String)passportTypeAreaMap.get(((CarparkPassportType)space2.getKey()).getPassport_type_no());
                                        if (areaNo2 == null || !areaNo2.equals(Constants.NO_STR) && !areaNo2.equals(r2.getArea_no())) continue;
                                        it12.remove();
                                        iterator.remove();
                                        Iterator itlist2 = passAreaPresenceRecords.iterator();
                                        while (itlist2.hasNext()) {
                                            CarparkPresenceRecord r12 = (CarparkPresenceRecord)itlist2.next();
                                            if (!r12.getEnter_plate().equals(r2.getEnter_plate())) continue;
                                            itlist2.remove();
                                            if (takeFixedRecord != null) break;
                                            takeFixedRecord = r12;
                                            break;
                                        }
                                        if (parentAreaPresenceRecordsMap == null) break;
                                        parentAreaPresenceRecordsMap.remove(r2.getEnter_plate());
                                        break;
                                    }
                                    if (fixedlist.isEmpty()) break;
                                }
                            }
                        }
                        if (passArea.getArea_level() == 1) {
                            if (!passAreaPresenceRecords.isEmpty()) {
                                Iterator iterator = passAreaPresenceRecords.iterator();
                                block26: while (iterator.hasNext()) {
                                    CarparkPresenceRecord r1;
                                    r = (CarparkPresenceRecord)iterator.next();
                                    if (r.getEnter_plate().equals(passport.getRegister_plate())) {
                                        iterator.remove();
                                        continue;
                                    }
                                    if (subAreaPresenceRecordsMap != null && (r1 = (CarparkPresenceRecord)subAreaPresenceRecordsMap.get(r.getEnter_plate())) != null) {
                                        r.setPassport_type_no(r1.getPassport_type_no());
                                        r.setPassport_type_name(r1.getPassport_type_name());
                                        r.setPass_type(r1.getPass_type());
                                        r.setOccupy_space_reg_no(r1.getOccupy_space_reg_no());
                                    }
                                    if (r.getOccupy_space_reg_no() == null || r.getOccupy_space_reg_no().length() <= 0 || (pt = passportTypeMap.get(r.getPassport_type_no())) == null || pt.getPass_type() == 0) continue;
                                    it = fixedlist.iterator();
                                    while (it.hasNext()) {
                                        e = (KeyValueEntry)it.next();
                                        if (!((CarparkPassport)e.getValue()).getRegister_plate().equals(r.getOccupy_space_reg_no())) continue;
                                        it.remove();
                                        iterator.remove();
                                        if (takeFixedRecord != null) continue block26;
                                        takeFixedRecord = r;
                                        continue block26;
                                    }
                                }
                            }
                            if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                                Iterator iterator = passAreaPresenceRecords.iterator();
                                while (iterator.hasNext()) {
                                    r = (CarparkPresenceRecord)iterator.next();
                                    Iterator it2 = fixedlist.iterator();
                                    while (it2.hasNext()) {
                                        KeyValueEntry e2 = (KeyValueEntry)it2.next();
                                        if (!((CarparkPassport)e2.getValue()).getRegister_plate().equals(r.getEnter_plate()) || !((CarparkPassportType)e2.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                                        it2.remove();
                                        iterator.remove();
                                        if (takeFixedRecord != null) break;
                                        takeFixedRecord = r;
                                        break;
                                    }
                                    if (fixedlist.isEmpty()) break;
                                }
                            }
                            if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                                Iterator iterator = passAreaPresenceRecords.iterator();
                                while (iterator.hasNext()) {
                                    r = (CarparkPresenceRecord)iterator.next();
                                    pt = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(r.getPassport_type_no());
                                    if (pt != null && pt.getPass_type() != 0) {
                                        it = fixedlist.iterator();
                                        while (it.hasNext()) {
                                            e = (KeyValueEntry)it.next();
                                            if (!((CarparkPassportType)e.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                                            it.remove();
                                            iterator.remove();
                                            if (takeFixedRecord != null) break;
                                            takeFixedRecord = r;
                                            break;
                                        }
                                    }
                                    if (fixedlist.isEmpty()) break;
                                }
                            }
                            if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                                Iterator iterator = passAreaPresenceRecords.iterator();
                                while (iterator.hasNext()) {
                                    r = (CarparkPresenceRecord)iterator.next();
                                    if ("2".equals(ONESPACE_MUTICARS_VALUE)) {
                                        pt = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(r.getPassport_type_no());
                                        if (pt.getPass_type() != 0) {
                                            fixedlist.poll();
                                            iterator.remove();
                                        }
                                    } else {
                                        fixedlist.poll();
                                        iterator.remove();
                                    }
                                    if (fixedlist.isEmpty()) break;
                                }
                            }
                            if (!fixedlist.isEmpty()) {
                                KeyValueEntry keyValueEntry = (KeyValueEntry)fixedlist.peek();
                                samePlateEn = null;
                                for (KeyValueEntry e3 : fixedlist) {
                                    if (!((CarparkPassport)e3.getValue()).getRegister_plate().equals(passport.getRegister_plate())) continue;
                                    samePlateEn = e3;
                                    break;
                                }
                                returnEn = keyValueEntry;
                                if (samePlateEn != null && samePlateEn != keyValueEntry) {
                                    areaNo = (String)passportTypeAreaMap.get(((CarparkPassportType)samePlateEn.getKey()).getPassport_type_no());
                                    if (areaNo != null && (areaNo.equals(passArea.getArea_no()) || Constants.NO_STR.equals(areaNo))) {
                                        returnEn = samePlateEn;
                                    } else {
                                        areaNo = (String)passportTypeAreaMap.get(((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no());
                                        if (areaNo == null || !areaNo.equals(passArea.getArea_no()) && !Constants.NO_STR.equals(areaNo)) {
                                            returnEn = samePlateEn;
                                        }
                                    }
                                }
                                KeyValueEntry en = returnEn;
                                CarparkPassport newPassporrt2 = passport.clone();
                                newPassporrt2.setStart_date(((CarparkPassport)en.getValue()).getStart_date());
                                newPassporrt2.setStop_date(((CarparkPassport)en.getValue()).getStop_date());
                                newPassporrt2.setValid_date(((CarparkPassport)en.getValue()).getValid_date());
                                newPassporrt2.setDeadline(((CarparkPassport)en.getValue()).getDeadline());
                                newPassporrt2.setPassport_type_no(((CarparkPassportType)en.getKey()).getPassport_type_no());
                                newPassporrt2.setSpace_reg_no(((CarparkPassport)en.getValue()).getRegister_plate());
                                return new KeyValueEntry((Object)((CarparkPassportType)en.getKey()), (Object)newPassporrt2);
                            }
                            if (templist.isEmpty()) {
                                return null;
                            }
                            for (KeyValueEntry keyValueEntry : templist) {
                                if (!((CarparkPassport)keyValueEntry.getValue()).getRegister_plate().equals(passport.getRegister_plate())) continue;
                                ((CarparkPassport)keyValueEntry.getValue()).setSpace_reg_no(((CarparkPassport)keyValueEntry.getValue()).getRegister_plate());
                                return keyValueEntry;
                            }
                            KeyValueEntry keyValueEntry = (KeyValueEntry)templist.poll();
                            newPassporrt = passport.clone();
                            newPassporrt.setStart_date(((CarparkPassport)keyValueEntry.getValue()).getStart_date());
                            newPassporrt.setStop_date(((CarparkPassport)keyValueEntry.getValue()).getStop_date());
                            newPassporrt.setValid_date(((CarparkPassport)keyValueEntry.getValue()).getValid_date());
                            newPassporrt.setDeadline(((CarparkPassport)keyValueEntry.getValue()).getDeadline());
                            newPassporrt.setPassport_type_no(((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no());
                            newPassporrt.setSpace_reg_no(((CarparkPassport)keyValueEntry.getValue()).getRegister_plate());
                            if (takeRecordInfo != null && takeFixedRecord != null) {
                                takeRecordInfo.set((CarparkPresenceRecord)takeFixedRecord);
                            }
                            return new KeyValueEntry((Object)((CarparkPassportType)keyValueEntry.getKey()), (Object)newPassporrt);
                        }
                        if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                            Iterator iterator = passAreaPresenceRecords.iterator();
                            block35: while (iterator.hasNext()) {
                                r = (CarparkPresenceRecord)iterator.next();
                                if (r.getEnter_plate().equals(passport.getRegister_plate())) {
                                    iterator.remove();
                                    continue;
                                }
                                if (r.getOccupy_space_reg_no() == null || r.getOccupy_space_reg_no().length() <= 0 || (pt = passportTypeMap.get(r.getPassport_type_no())) == null || pt.getPass_type() == 0) continue;
                                it = fixedlist.iterator();
                                while (it.hasNext()) {
                                    e = (KeyValueEntry)it.next();
                                    if (!((CarparkPassport)e.getValue()).getRegister_plate().equals(r.getOccupy_space_reg_no()) || (areaNo2 = (String)passportTypeAreaMap.get(((CarparkPassportType)e.getKey()).getPassport_type_no())) == null || !areaNo2.equals(Constants.NO_STR) && !areaNo2.equals(r.getArea_no())) continue;
                                    it.remove();
                                    iterator.remove();
                                    if (parentAreaPresenceRecordsMap != null) {
                                        parentAreaPresenceRecordsMap.remove(r.getEnter_plate());
                                    }
                                    if (takeFixedRecord != null) continue block35;
                                    takeFixedRecord = r;
                                    continue block35;
                                }
                            }
                        }
                        if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                            Iterator iterator = passAreaPresenceRecords.iterator();
                            while (iterator.hasNext()) {
                                r = (CarparkPresenceRecord)iterator.next();
                                pt = passportTypeMap.get(r.getPassport_type_no());
                                if (pt != null && pt.getPass_type() != 0) {
                                    it = fixedlist.iterator();
                                    while (it.hasNext()) {
                                        e = (KeyValueEntry)it.next();
                                        if (!((CarparkPassport)e.getValue()).getRegister_plate().equals(r.getEnter_plate()) || !((CarparkPassportType)e.getKey()).getPassport_type_no().equals(r.getPassport_type_no()) || (areaNo2 = (String)passportTypeAreaMap.get(((CarparkPassportType)e.getKey()).getPassport_type_no())) == null || !areaNo2.equals(Constants.NO_STR) && !areaNo2.equals(r.getArea_no())) continue;
                                        it.remove();
                                        iterator.remove();
                                        if (parentAreaPresenceRecordsMap != null) {
                                            parentAreaPresenceRecordsMap.remove(r.getEnter_plate());
                                        }
                                        if (takeFixedRecord != null) break;
                                        takeFixedRecord = r;
                                        break;
                                    }
                                }
                                if (fixedlist.isEmpty()) break;
                            }
                        }
                        if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                            Iterator iterator = passAreaPresenceRecords.iterator();
                            while (iterator.hasNext()) {
                                r = (CarparkPresenceRecord)iterator.next();
                                pt = passportTypeMap.get(r.getPassport_type_no());
                                if (pt != null && pt.getPass_type() != 0) {
                                    it = fixedlist.iterator();
                                    while (it.hasNext()) {
                                        e = (KeyValueEntry)it.next();
                                        if (!((CarparkPassportType)e.getKey()).getPassport_type_no().equals(r.getPassport_type_no()) || (areaNo2 = (String)passportTypeAreaMap.get(((CarparkPassportType)e.getKey()).getPassport_type_no())) == null || !areaNo2.equals(Constants.NO_STR) && !areaNo2.equals(r.getArea_no())) continue;
                                        it.remove();
                                        iterator.remove();
                                        if (parentAreaPresenceRecordsMap != null) {
                                            parentAreaPresenceRecordsMap.remove(r.getEnter_plate());
                                        }
                                        if (takeFixedRecord != null) break;
                                        takeFixedRecord = r;
                                        break;
                                    }
                                }
                                if (fixedlist.isEmpty()) break;
                            }
                        }
                        if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                            Iterator iterator = passAreaPresenceRecords.iterator();
                            while (iterator.hasNext()) {
                                r = (CarparkPresenceRecord)iterator.next();
                                Iterator it1 = fixedlist.iterator();
                                while (it1.hasNext()) {
                                    KeyValueEntry space = (KeyValueEntry)it1.next();
                                    String areaNo4 = (String)passportTypeAreaMap.get(((CarparkPassportType)space.getKey()).getPassport_type_no());
                                    if (areaNo4 == null || !areaNo4.equals(Constants.NO_STR) && !areaNo4.equals(r.getArea_no())) continue;
                                    it1.remove();
                                    iterator.remove();
                                    if (takeFixedRecord == null) {
                                        takeFixedRecord = r;
                                    }
                                    if (parentAreaPresenceRecordsMap == null) break;
                                    parentAreaPresenceRecordsMap.remove(r.getEnter_plate());
                                    break;
                                }
                                if (fixedlist.isEmpty()) break;
                            }
                        }
                        if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                            Iterator iterator = passAreaPresenceRecords.iterator();
                            while (iterator.hasNext()) {
                                r = (CarparkPresenceRecord)iterator.next();
                                if (r.getOccupy_space_reg_no() != null && r.getOccupy_space_reg_no().length() > 0 && (pt = passportTypeMap.get(r.getPassport_type_no())) != null && pt.getPass_type() != 0) {
                                    it = fixedlist.iterator();
                                    while (it.hasNext()) {
                                        e = (KeyValueEntry)it.next();
                                        if (!((CarparkPassport)e.getValue()).getRegister_plate().equals(r.getOccupy_space_reg_no())) continue;
                                        it.remove();
                                        iterator.remove();
                                        if (parentAreaPresenceRecordsMap != null) {
                                            parentAreaPresenceRecordsMap.remove(r.getEnter_plate());
                                        }
                                        if (takeFixedRecord != null) break;
                                        takeFixedRecord = r;
                                        break;
                                    }
                                }
                                if (fixedlist.isEmpty()) break;
                            }
                        }
                        if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                            Iterator iterator = passAreaPresenceRecords.iterator();
                            while (iterator.hasNext()) {
                                r = (CarparkPresenceRecord)iterator.next();
                                pt = passportTypeMap.get(r.getPassport_type_no());
                                if (pt != null && pt.getPass_type() != 0) {
                                    it = fixedlist.iterator();
                                    while (it.hasNext()) {
                                        e = (KeyValueEntry)it.next();
                                        if (!((CarparkPassport)e.getValue()).getRegister_plate().equals(r.getEnter_plate()) || !((CarparkPassportType)e.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                                        it.remove();
                                        iterator.remove();
                                        if (takeFixedRecord == null) {
                                            takeFixedRecord = r;
                                        }
                                        if (parentAreaPresenceRecordsMap == null) break;
                                        parentAreaPresenceRecordsMap.remove(r.getEnter_plate());
                                        break;
                                    }
                                }
                                if (fixedlist.isEmpty()) break;
                            }
                        }
                        if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                            Iterator iterator = passAreaPresenceRecords.iterator();
                            while (iterator.hasNext()) {
                                r = (CarparkPresenceRecord)iterator.next();
                                pt = passportTypeMap.get(r.getPassport_type_no());
                                if (pt != null && pt.getPass_type() != 0) {
                                    it = fixedlist.iterator();
                                    while (it.hasNext()) {
                                        e = (KeyValueEntry)it.next();
                                        if (!((CarparkPassportType)e.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                                        it.remove();
                                        iterator.remove();
                                        if (takeFixedRecord == null) {
                                            takeFixedRecord = r;
                                        }
                                        if (parentAreaPresenceRecordsMap == null) break;
                                        parentAreaPresenceRecordsMap.remove(r.getEnter_plate());
                                        break;
                                    }
                                }
                                if (fixedlist.isEmpty()) break;
                            }
                        }
                        if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                            Iterator iterator = passAreaPresenceRecords.iterator();
                            while (iterator.hasNext()) {
                                r = (CarparkPresenceRecord)iterator.next();
                                iterator.remove();
                                fixedlist.poll();
                                if (takeFixedRecord == null) {
                                    takeFixedRecord = r;
                                }
                                if (parentAreaPresenceRecordsMap != null) {
                                    parentAreaPresenceRecordsMap.remove(r.getEnter_plate());
                                }
                                if (fixedlist.isEmpty()) break;
                            }
                        }
                        if (!fixedlist.isEmpty()) {
                            CarparkPresenceRecord r3;
                            CarparkPresenceRecord r4;
                            KeyValueEntry keyValueEntry = (KeyValueEntry)fixedlist.peek();
                            samePlateEn = null;
                            for (KeyValueEntry e3 : fixedlist) {
                                if (!((CarparkPassport)e3.getValue()).getRegister_plate().equals(passport.getRegister_plate())) continue;
                                samePlateEn = e3;
                                break;
                            }
                            returnEn = keyValueEntry;
                            if (samePlateEn != null && samePlateEn != keyValueEntry) {
                                areaNo = (String)passportTypeAreaMap.get(((CarparkPassportType)samePlateEn.getKey()).getPassport_type_no());
                                if (areaNo != null && (areaNo.equals(passArea.getArea_no()) || Constants.NO_STR.equals(areaNo))) {
                                    returnEn = samePlateEn;
                                } else {
                                    areaNo = (String)passportTypeAreaMap.get(((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no());
                                    if (areaNo == null || !areaNo.equals(passArea.getArea_no()) && !Constants.NO_STR.equals(areaNo)) {
                                        returnEn = samePlateEn;
                                    }
                                }
                            }
                            if (parentAreaPresenceRecordsMap != null && (r4 = (CarparkPresenceRecord)parentAreaPresenceRecordsMap.get(passport.getRegister_plate())) != null && r4.getPass_type() != null && r4.getPass_type() != 0) {
                                String areaNo5;
                                KeyValueEntry fixSpace0 = null;
                                KeyValueEntry fixSpace1 = null;
                                for (KeyValueEntry e4 : fixedlist) {
                                    if (r4.getOccupy_space_reg_no() != null && r4.getOccupy_space_reg_no().length() > 0 && r4.getOccupy_space_reg_no().equals(((CarparkPassport)e4.getValue()).getRegister_plate())) {
                                        fixSpace0 = e4;
                                    }
                                    if (!((CarparkPassportType)e4.getKey()).getPassport_type_no().equals(r4.getPassport_type_no())) continue;
                                    fixSpace1 = e4;
                                }
                                boolean find = false;
                                if (fixSpace0 != null && fixSpace0 != returnEn && ((areaNo5 = (String)passportTypeAreaMap.get(((CarparkPassportType)fixSpace0.getKey()).getPassport_type_no())) != null && areaNo5.equals(passArea.getArea_no()) || Constants.NO_STR.equals(areaNo5))) {
                                    returnEn = fixSpace0;
                                    find = true;
                                }
                                if (!find && fixSpace1 != null && fixSpace1 != returnEn && fixSpace1 != fixSpace0 && !((CarparkPassportType)fixSpace1.getKey()).getPassport_type_no().equals(((CarparkPassportType)returnEn.getKey()).getPassport_type_no()) && ((areaNo5 = (String)passportTypeAreaMap.get(((CarparkPassportType)fixSpace1.getKey()).getPassport_type_no())) != null && areaNo5.equals(passArea.getArea_no()) || Constants.NO_STR.equals(areaNo5))) {
                                    returnEn = fixSpace1;
                                }
                            }
                            CarparkPassport newPassport = passport.clone();
                            newPassport.setStart_date(((CarparkPassport)returnEn.getValue()).getStart_date());
                            newPassport.setStop_date(((CarparkPassport)returnEn.getValue()).getStop_date());
                            newPassport.setValid_date(((CarparkPassport)returnEn.getValue()).getValid_date());
                            newPassport.setDeadline(((CarparkPassport)returnEn.getValue()).getDeadline());
                            newPassport.setPassport_type_no(((CarparkPassportType)returnEn.getKey()).getPassport_type_no());
                            newPassport.setSpace_reg_no(((CarparkPassport)returnEn.getValue()).getRegister_plate());
                            if (parentAreaPresenceRecordsMap != null && (r3 = (CarparkPresenceRecord)parentAreaPresenceRecordsMap.get(passport.getRegister_plate())) != null && !r3.getPassport_type_no().equals(((CarparkPassportType)returnEn.getKey()).getPassport_type_no())) {
                                boolean check = false;
                                CarparkPassportType pt3 = passportTypeMap.get(r3.getPassport_type_no());
                                if (pt3 != null && pt3.getPass_type() != 0) {
                                    check = true;
                                }
                                if (check) {
                                    CarparkPresenceRecord rzx1 = null;
                                    CarparkPresenceRecord rzx2 = null;
                                    for (CarparkPresenceRecord r1 : parentAreaPresenceRecordsMap.values()) {
                                        if (r1.getEnter_plate().equals(passport.getRegister_plate())) continue;
                                        if (r1.getOccupy_space_reg_no() != null && r1.getOccupy_space_reg_no().equals(((CarparkPassport)returnEn.getValue()).getRegister_plate())) {
                                            rzx1 = r1;
                                        } else if (rzx2 == null && r1.getPassport_type_no().equals(((CarparkPassportType)returnEn.getKey()).getPassport_type_no())) {
                                            rzx2 = r1;
                                        }
                                        if (rzx1 != null && rzx2 != null) break;
                                    }
                                    if (rzx1 != null) {
                                        takeRecordInfo.set(rzx1);
                                    } else if (rzx2 != null) {
                                        takeRecordInfo.set(rzx2);
                                    }
                                }
                            }
                            return new KeyValueEntry((Object)((CarparkPassportType)returnEn.getKey()), (Object)newPassport);
                        }
                        if (templist.isEmpty()) {
                            return null;
                        }
                        for (KeyValueEntry keyValueEntry : templist) {
                            if (!((CarparkPassport)keyValueEntry.getValue()).getRegister_plate().equals(passport.getRegister_plate())) continue;
                            ((CarparkPassport)keyValueEntry.getValue()).setSpace_reg_no(((CarparkPassport)keyValueEntry.getValue()).getRegister_plate());
                            return keyValueEntry;
                        }
                        KeyValueEntry keyValueEntry = (KeyValueEntry)templist.poll();
                        newPassporrt = passport.clone();
                        newPassporrt.setStart_date(((CarparkPassport)keyValueEntry.getValue()).getStart_date());
                        newPassporrt.setStop_date(((CarparkPassport)keyValueEntry.getValue()).getStop_date());
                        newPassporrt.setValid_date(((CarparkPassport)keyValueEntry.getValue()).getValid_date());
                        newPassporrt.setDeadline(((CarparkPassport)keyValueEntry.getValue()).getDeadline());
                        newPassporrt.setPassport_type_no(((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no());
                        if (takeRecordInfo != null && takeFixedRecord != null) {
                            takeRecordInfo.set((CarparkPresenceRecord)takeFixedRecord);
                        }
                        return new KeyValueEntry((Object)((CarparkPassportType)keyValueEntry.getKey()), (Object)newPassporrt);
                    }
                    if ("2".equals(ONESPACE_MUTICARS_VALUE) || passArea.getArea_level() != 1) {
                        if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                            Iterator it1 = passAreaPresenceRecords.iterator();
                            block54: while (it1.hasNext()) {
                                CarparkPassportType pt;
                                CarparkPresenceRecord carparkPresenceRecord = (CarparkPresenceRecord)it1.next();
                                if (carparkPresenceRecord.getEnter_plate().equals(passport.getRegister_plate())) {
                                    if (carparkPresenceRecord.getOccupy_space_reg_no() != null && carparkPresenceRecord.getOccupy_space_reg_no().length() > 0 && (pt = passportTypeMap.get(carparkPresenceRecord.getPassport_type_no())) != null && pt.getPass_type() != 0) {
                                        for (KeyValueEntry e : fixedlist) {
                                            if (!((CarparkPassport)e.getValue()).getRegister_plate().equals(carparkPresenceRecord.getOccupy_space_reg_no())) continue;
                                            CarparkPassport newPassporrt = passport.clone();
                                            newPassporrt.setStart_date(((CarparkPassport)e.getValue()).getStart_date());
                                            newPassporrt.setStop_date(((CarparkPassport)e.getValue()).getStop_date());
                                            newPassporrt.setValid_date(((CarparkPassport)e.getValue()).getValid_date());
                                            newPassporrt.setDeadline(((CarparkPassport)e.getValue()).getDeadline());
                                            newPassporrt.setPassport_type_no(((CarparkPassportType)e.getKey()).getPassport_type_no());
                                            newPassporrt.setSpace_reg_no(((CarparkPassport)e.getValue()).getRegister_plate());
                                            return new KeyValueEntry((Object)((CarparkPassportType)e.getKey()), (Object)newPassporrt);
                                        }
                                    }
                                    if (!carparkPresenceRecord.getPassport_type_no().equals(passportType.getPassport_type_no())) continue;
                                    return null;
                                }
                                if (carparkPresenceRecord.getOccupy_space_reg_no() == null || carparkPresenceRecord.getOccupy_space_reg_no().length() <= 0 || (pt = passportTypeMap.get(carparkPresenceRecord.getPassport_type_no())) == null || pt.getPass_type() == 0) continue;
                                Iterator it = fixedlist.iterator();
                                while (it.hasNext()) {
                                    KeyValueEntry e;
                                    e = (KeyValueEntry)it.next();
                                    if (!((CarparkPassport)e.getValue()).getRegister_plate().equals(carparkPresenceRecord.getOccupy_space_reg_no())) continue;
                                    it.remove();
                                    it1.remove();
                                    continue block54;
                                }
                            }
                            if (!passAreaPresenceRecords.isEmpty() && !fixedlist.isEmpty()) {
                                it1 = passAreaPresenceRecords.iterator();
                                while (it1.hasNext()) {
                                    CarparkPresenceRecord carparkPresenceRecord = (CarparkPresenceRecord)it1.next();
                                    if (!carparkPresenceRecord.getEnter_plate().equals(passport.getRegister_plate())) {
                                        Iterator it = fixedlist.iterator();
                                        while (it.hasNext()) {
                                            KeyValueEntry e = (KeyValueEntry)it.next();
                                            if (!((CarparkPassport)e.getValue()).getRegister_plate().equals(carparkPresenceRecord.getEnter_plate()) || !((CarparkPassportType)e.getKey()).getPassport_type_no().equals(carparkPresenceRecord.getPassport_type_no())) continue;
                                            it.remove();
                                            it1.remove();
                                            break;
                                        }
                                    }
                                    if (fixedlist.isEmpty()) break;
                                }
                            }
                            for (CarparkPresenceRecord r : passAreaPresenceRecords) {
                                if (!r.getEnter_plate().equals(passport.getRegister_plate())) continue;
                                if (r.getPassport_type_no() != null && !r.getPassport_type_no().equals(passportType.getPassport_type_no())) {
                                    CarparkPassport newPassporrt;
                                    for (KeyValueEntry en : fixedlist) {
                                        if (!((CarparkPassportType)en.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                                        newPassporrt = passport.clone();
                                        newPassporrt.setStart_date(((CarparkPassport)en.getValue()).getStart_date());
                                        newPassporrt.setStop_date(((CarparkPassport)en.getValue()).getStop_date());
                                        newPassporrt.setValid_date(((CarparkPassport)en.getValue()).getValid_date());
                                        newPassporrt.setDeadline(((CarparkPassport)en.getValue()).getDeadline());
                                        newPassporrt.setPassport_type_no(((CarparkPassportType)en.getKey()).getPassport_type_no());
                                        newPassporrt.setSpace_reg_no(((CarparkPassport)en.getValue()).getRegister_plate());
                                        return new KeyValueEntry((Object)((CarparkPassportType)en.getKey()), (Object)newPassporrt);
                                    }
                                    for (KeyValueEntry en : templist) {
                                        if (!((CarparkPassportType)en.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                                        newPassporrt = passport.clone();
                                        newPassporrt.setStart_date(((CarparkPassport)en.getValue()).getStart_date());
                                        newPassporrt.setStop_date(((CarparkPassport)en.getValue()).getStop_date());
                                        newPassporrt.setValid_date(((CarparkPassport)en.getValue()).getValid_date());
                                        newPassporrt.setDeadline(((CarparkPassport)en.getValue()).getDeadline());
                                        newPassporrt.setPassport_type_no(((CarparkPassportType)en.getKey()).getPassport_type_no());
                                        newPassporrt.setSpace_reg_no(((CarparkPassport)en.getValue()).getRegister_plate());
                                        return new KeyValueEntry((Object)((CarparkPassportType)en.getKey()), (Object)newPassporrt);
                                    }
                                    for (KeyValueEntry en : fixedlist1) {
                                        if (!((CarparkPassportType)en.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                                        newPassporrt = passport.clone();
                                        newPassporrt.setStart_date(((CarparkPassport)en.getValue()).getStart_date());
                                        newPassporrt.setStop_date(((CarparkPassport)en.getValue()).getStop_date());
                                        newPassporrt.setValid_date(((CarparkPassport)en.getValue()).getValid_date());
                                        newPassporrt.setDeadline(((CarparkPassport)en.getValue()).getDeadline());
                                        newPassporrt.setPassport_type_no(((CarparkPassportType)en.getKey()).getPassport_type_no());
                                        newPassporrt.setSpace_reg_no(((CarparkPassport)en.getValue()).getRegister_plate());
                                        return new KeyValueEntry((Object)((CarparkPassportType)en.getKey()), (Object)newPassporrt);
                                    }
                                }
                                break;
                            }
                        }
                    } else if (!passAreaPresenceRecords.isEmpty()) {
                        boolean asFixedExit;
                        CarparkPresenceRecord r5;
                        CarparkPassRecord enterRecord = null;
                        LinkedList<CarparkPresenceRecord> linkedList = new LinkedList<CarparkPresenceRecord>();
                        int i = 0;
                        while (i < fixedlist.size()) {
                            r5 = (CarparkPresenceRecord)passAreaPresenceRecords.poll();
                            if (r5 != null) {
                                linkedList.add(r5);
                                if (r5.getEnter_plate().equals(passport.getRegister_plate())) {
                                    enterRecord = r5;
                                }
                            }
                            if (r5 == null || passAreaPresenceRecords.isEmpty()) break;
                            ++i;
                        }
                        boolean bl = asFixedExit = enterRecord != null;
                        if (!asFixedExit) {
                            for (CarparkPresenceRecord r5 : passAreaPresenceRecords) {
                                if (!r5.getEnter_plate().equals(passport.getRegister_plate())) continue;
                                enterRecord = r5;
                                break;
                            }
                        }
                        if (enterRecord != null) {
                            if (asFixedExit) {
                                KeyValueEntry e;
                                Iterator it;
                                CarparkPassportType pt1;
                                CarparkPresenceRecord r62;
                                Iterator it1;
                                CarparkPassportType enterPt;
                                if (!passAreaPresenceRecords.isEmpty()) {
                                    r5 = (CarparkPresenceRecord)passAreaPresenceRecords.peek();
                                    CarparkPassportType enterpt = passportTypeMap.get(r5.getPassport_type_no());
                                    if (enterpt == null || enterpt.getPass_type() != 0) {
                                        if (!templist.isEmpty()) {
                                            KeyValueEntry en = (KeyValueEntry)templist.poll();
                                            r5.setPassport_type_no(((CarparkPassportType)en.getKey()).getPassport_type_no());
                                            r5.setPassport_type_name(((CarparkPassportType)en.getKey()).getPassport_type_name());
                                            r5.setPass_type(((CarparkPassportType)en.getKey()).getPass_type());
                                            r5.setOccupy_space_reg_no(((CarparkPassport)en.getValue()).getRegister_plate());
                                            takeRecordInfo.set(r5);
                                        }
                                    } else {
                                        takeRecordInfo.set(r5);
                                    }
                                }
                                if ((enterPt = passportTypeMap.get(enterRecord.getPassport_type_no())) != null && enterPt.getPass_type() != 0) {
                                    if (enterRecord.getOccupy_space_reg_no() != null && enterRecord.getOccupy_space_reg_no().length() > 0) {
                                        for (KeyValueEntry e5 : fixedlist) {
                                            if (!((CarparkPassport)e5.getValue()).getRegister_plate().equals(enterRecord.getOccupy_space_reg_no())) continue;
                                            CarparkPassport newPassporrt = passport.clone();
                                            newPassporrt.setStart_date(((CarparkPassport)e5.getValue()).getStart_date());
                                            newPassporrt.setStop_date(((CarparkPassport)e5.getValue()).getStop_date());
                                            newPassporrt.setValid_date(((CarparkPassport)e5.getValue()).getValid_date());
                                            newPassporrt.setDeadline(((CarparkPassport)e5.getValue()).getDeadline());
                                            newPassporrt.setPassport_type_no(((CarparkPassportType)e5.getKey()).getPassport_type_no());
                                            newPassporrt.setSpace_reg_no(((CarparkPassport)e5.getValue()).getRegister_plate());
                                            return new KeyValueEntry((Object)((CarparkPassportType)e5.getKey()), (Object)newPassporrt);
                                        }
                                    }
                                    for (KeyValueEntry e5 : fixedlist) {
                                        if (!((CarparkPassport)e5.getValue()).getRegister_plate().equals(enterRecord.getEnter_plate()) || !((CarparkPassportType)e5.getKey()).getPassport_type_no().equals(enterRecord.getPassport_type_no())) continue;
                                        CarparkPassport newPassporrt = passport.clone();
                                        newPassporrt.setStart_date(((CarparkPassport)e5.getValue()).getStart_date());
                                        newPassporrt.setStop_date(((CarparkPassport)e5.getValue()).getStop_date());
                                        newPassporrt.setValid_date(((CarparkPassport)e5.getValue()).getValid_date());
                                        newPassporrt.setDeadline(((CarparkPassport)e5.getValue()).getDeadline());
                                        newPassporrt.setPassport_type_no(((CarparkPassportType)e5.getKey()).getPassport_type_no());
                                        newPassporrt.setSpace_reg_no(((CarparkPassport)e5.getValue()).getRegister_plate());
                                        return new KeyValueEntry((Object)((CarparkPassportType)e5.getKey()), (Object)newPassporrt);
                                    }
                                }
                                if (linkedList.size() > 1) {
                                    it1 = linkedList.iterator();
                                    block67: while (it1.hasNext()) {
                                        r62 = (CarparkPresenceRecord)it1.next();
                                        if (r62.getEnter_plate().equals(passport.getRegister_plate()) || r62.getOccupy_space_reg_no() == null || r62.getOccupy_space_reg_no().length() <= 0 || (pt1 = passportTypeMap.get(r62.getPassport_type_no())) == null || pt1.getPass_type() == 0) continue;
                                        it = fixedlist.iterator();
                                        while (it.hasNext()) {
                                            e = (KeyValueEntry)it.next();
                                            if (!r62.getOccupy_space_reg_no().equals(((CarparkPassport)e.getValue()).getRegister_plate())) continue;
                                            it1.remove();
                                            it.remove();
                                            continue block67;
                                        }
                                    }
                                }
                                if (linkedList.size() > 1) {
                                    it1 = linkedList.iterator();
                                    block69: while (it1.hasNext()) {
                                        r62 = (CarparkPresenceRecord)it1.next();
                                        if (r62.getEnter_plate().equals(passport.getRegister_plate()) || (pt1 = passportTypeMap.get(r62.getPassport_type_no())) == null || pt1.getPass_type() == 0) continue;
                                        it = fixedlist.iterator();
                                        while (it.hasNext()) {
                                            e = (KeyValueEntry)it.next();
                                            if (!((CarparkPassport)e.getValue()).getRegister_plate().equals(r62.getEnter_plate()) || !((CarparkPassportType)e.getKey()).getPassport_type_no().equals(r62.getPassport_type_no())) continue;
                                            it1.remove();
                                            it.remove();
                                            continue block69;
                                        }
                                    }
                                }
                                for (CarparkPresenceRecord r62 : linkedList) {
                                    KeyValueEntry en = (KeyValueEntry)fixedlist.poll();
                                    if (!r62.getEnter_plate().equals(enterRecord.getEnter_plate())) continue;
                                    CarparkPassport newPassporrt = passport.clone();
                                    newPassporrt.setStart_date(((CarparkPassport)en.getValue()).getStart_date());
                                    newPassporrt.setStop_date(((CarparkPassport)en.getValue()).getStop_date());
                                    newPassporrt.setValid_date(((CarparkPassport)en.getValue()).getValid_date());
                                    newPassporrt.setDeadline(((CarparkPassport)en.getValue()).getDeadline());
                                    newPassporrt.setPassport_type_no(((CarparkPassportType)en.getKey()).getPassport_type_no());
                                    newPassporrt.setSpace_reg_no(((CarparkPassport)en.getValue()).getRegister_plate());
                                    return new KeyValueEntry((Object)((CarparkPassportType)en.getKey()), (Object)newPassporrt);
                                }
                            } else if (isFixtFinded && !templist.isEmpty()) {
                                KeyValueEntry en = (KeyValueEntry)templist.poll();
                                CarparkPassport newPassporrt = passport.clone();
                                newPassporrt.setStart_date(((CarparkPassport)en.getValue()).getStart_date());
                                newPassporrt.setStop_date(((CarparkPassport)en.getValue()).getStop_date());
                                newPassporrt.setValid_date(((CarparkPassport)en.getValue()).getValid_date());
                                newPassporrt.setDeadline(((CarparkPassport)en.getValue()).getDeadline());
                                newPassporrt.setPassport_type_no(((CarparkPassportType)en.getKey()).getPassport_type_no());
                                newPassporrt.setSpace_reg_no(((CarparkPassport)en.getValue()).getRegister_plate());
                                return new KeyValueEntry((Object)((CarparkPassportType)en.getKey()), (Object)newPassporrt);
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u5904\u7406\u5b50\u6bcd\u8f66\u7b97\u6cd5\u5f02\u5e38", (Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected KeyValueEntry<CarparkPassportType, CarparkPassport> getPassportAndTypeByStorageMutiCar(CarparkPassport passport, CarparkPassportType passportType, int exitOrEnter, CarparkArea passArea, AtomicReference<CarparkPresenceRecord> takeRecordInfo, List<CarparkPresenceRecord> existMutiCarEnterRecords, LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>> templist0, LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>> storelist0, CommonDaoService commonDaoService) {
        LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>> templist = templist0;
        LinkedList<KeyValueEntry<CarparkPassportType, CarparkPassport>> fixedlist = storelist0;
        LinkedList<KeyValueEntry> fixedlist1 = new LinkedList<KeyValueEntry>();
        HashMap<String, String> platesMap = new HashMap<String, String>();
        HashMap<String, Boolean> validPassportTypes = new HashMap<String, Boolean>();
        for (KeyValueEntry keyValueEntry : templist0) {
            platesMap.put(((CarparkPassport)keyValueEntry.getValue()).getRegister_plate(), ((CarparkPassport)keyValueEntry.getValue()).getPassport_no());
            validPassportTypes.put(((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no(), Boolean.TRUE);
        }
        for (KeyValueEntry keyValueEntry : storelist0) {
            platesMap.put(((CarparkPassport)keyValueEntry.getValue()).getRegister_plate(), ((CarparkPassport)keyValueEntry.getValue()).getPassport_no());
            fixedlist1.add(keyValueEntry);
            validPassportTypes.put(((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no(), Boolean.FALSE);
        }
        Collections.sort(fixedlist, new Comparator<KeyValueEntry<CarparkPassportType, CarparkPassport>>(){

            @Override
            public int compare(KeyValueEntry<CarparkPassportType, CarparkPassport> o1, KeyValueEntry<CarparkPassportType, CarparkPassport> o2) {
                return ((CarparkPassport)o1.getValue()).getPassport_no().compareTo(((CarparkPassport)o2.getValue()).getPassport_no());
            }
        });
        SearchParam searchParam = new SearchParam();
        searchParam.addEQ("car_owner_no", (Object)passport.getCar_owner_no());
        searchParam.addINList("enter_plate", platesMap.keySet());
        searchParam.addEQ("medium_type", (Object)6);
        searchParam.addEQ("area_no", (Object)passArea.getArea_no());
        searchParam.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
        searchParam.setWhereString("AND enter_time IS NOT NULL AND exit_time IS NULL");
        searchParam.setOrerbySql("enter_time");
        List prenseCarRecords = commonDaoService.selectList(searchParam, CarparkPresenceRecord.class, null);
        if (prenseCarRecords != null && !prenseCarRecords.isEmpty() && existMutiCarEnterRecords != null) {
            existMutiCarEnterRecords.addAll(prenseCarRecords);
        }
        if (exitOrEnter == 0) {
            Object newPassporrt;
            if (prenseCarRecords != null && !prenseCarRecords.isEmpty()) {
                Iterator itlist = prenseCarRecords.iterator();
                while (itlist.hasNext()) {
                    CarparkPresenceRecord r = (CarparkPresenceRecord)itlist.next();
                    if (r.getEnter_plate() == null) {
                        itlist.remove();
                        continue;
                    }
                    if (r.getEnter_time() == null) {
                        itlist.remove();
                        continue;
                    }
                    if (r.getExit_time() != null) {
                        itlist.remove();
                        continue;
                    }
                    if (r.getPassport_type_no() == null || r.getPassport_type_no().length() == 0) {
                        itlist.remove();
                        continue;
                    }
                    if (!validPassportTypes.containsKey(r.getPassport_type_no())) {
                        itlist.remove();
                        continue;
                    }
                    if (!r.getEnter_plate().equals(passport.getRegister_plate())) continue;
                    itlist.remove();
                }
            }
            int fixtedSpcase = 0;
            CarparkPresenceRecord takeFixedRecord = null;
            if (prenseCarRecords != null && !prenseCarRecords.isEmpty()) {
                Iterator iterator = prenseCarRecords.iterator();
                block3: while (iterator.hasNext()) {
                    CarparkPresenceRecord r = (CarparkPresenceRecord)iterator.next();
                    Iterator it = fixedlist.iterator();
                    while (it.hasNext()) {
                        KeyValueEntry e = (KeyValueEntry)it.next();
                        if (!((CarparkPassport)e.getValue()).getRegister_plate().equals(r.getEnter_plate()) || !((CarparkPassportType)e.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                        it.remove();
                        iterator.remove();
                        if (takeFixedRecord != null) continue block3;
                        takeFixedRecord = r;
                        continue block3;
                    }
                }
                for (CarparkPresenceRecord carparkPresenceRecord : prenseCarRecords) {
                    CarparkPassportType pt = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(carparkPresenceRecord.getPassport_type_no());
                    if (pt == null || pt.getPass_type() == 0) continue;
                    boolean fi = false;
                    Iterator it = fixedlist.iterator();
                    while (it.hasNext()) {
                        KeyValueEntry e = (KeyValueEntry)it.next();
                        if (!((CarparkPassportType)e.getKey()).getPassport_type_no().equals(carparkPresenceRecord.getPassport_type_no())) continue;
                        it.remove();
                        fi = true;
                        if (takeFixedRecord != null) break;
                        takeFixedRecord = carparkPresenceRecord;
                        break;
                    }
                    if (fi) continue;
                    ++fixtedSpcase;
                }
            }
            if (fixedlist.size() > fixtedSpcase) {
                void var19_31;
                for (KeyValueEntry keyValueEntry : fixedlist) {
                    if (!((CarparkPassport)keyValueEntry.getValue()).getRegister_plate().equals(passport.getRegister_plate())) continue;
                    return keyValueEntry;
                }
                boolean bl = false;
                while (var19_31 < fixtedSpcase) {
                    fixedlist.poll();
                    ++var19_31;
                }
                KeyValueEntry<CarparkPassportType, CarparkPassport> keyValueEntry = fixedlist.poll();
                newPassporrt = passport.clone();
                ((CarparkPassport)newPassporrt).setStart_date(((CarparkPassport)keyValueEntry.getValue()).getStart_date());
                ((CarparkPassport)newPassporrt).setStop_date(((CarparkPassport)keyValueEntry.getValue()).getStop_date());
                ((CarparkPassport)newPassporrt).setValid_date(((CarparkPassport)keyValueEntry.getValue()).getValid_date());
                ((CarparkPassport)newPassporrt).setDeadline(((CarparkPassport)keyValueEntry.getValue()).getDeadline());
                ((CarparkPassport)newPassporrt).setPassport_type_no(((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no());
                ((CarparkPassport)newPassporrt).setBalance(((CarparkPassport)keyValueEntry.getValue()).getBalance());
                return new KeyValueEntry((Object)((CarparkPassportType)keyValueEntry.getKey()), newPassporrt);
            }
            for (KeyValueEntry keyValueEntry : templist) {
                if (!((CarparkPassport)keyValueEntry.getValue()).getRegister_plate().equals(passport.getRegister_plate())) continue;
                return keyValueEntry;
            }
            KeyValueEntry<CarparkPassportType, CarparkPassport> keyValueEntry = templist.poll();
            newPassporrt = passport.clone();
            ((CarparkPassport)newPassporrt).setStart_date(((CarparkPassport)keyValueEntry.getValue()).getStart_date());
            ((CarparkPassport)newPassporrt).setStop_date(((CarparkPassport)keyValueEntry.getValue()).getStop_date());
            ((CarparkPassport)newPassporrt).setValid_date(((CarparkPassport)keyValueEntry.getValue()).getValid_date());
            ((CarparkPassport)newPassporrt).setDeadline(((CarparkPassport)keyValueEntry.getValue()).getDeadline());
            ((CarparkPassport)newPassporrt).setPassport_type_no(((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no());
            ((CarparkPassport)newPassporrt).setBalance(((CarparkPassport)keyValueEntry.getValue()).getBalance());
            if (takeRecordInfo != null && takeFixedRecord != null) {
                takeRecordInfo.set(takeFixedRecord);
            }
            return new KeyValueEntry((Object)((CarparkPassportType)keyValueEntry.getKey()), newPassporrt);
        }
        if (prenseCarRecords != null && !prenseCarRecords.isEmpty()) {
            Iterator it1 = prenseCarRecords.iterator();
            block10: while (it1.hasNext()) {
                CarparkPresenceRecord r = (CarparkPresenceRecord)it1.next();
                if (r.getEnter_plate() == null) {
                    it1.remove();
                    continue;
                }
                if (r.getEnter_time() == null) {
                    it1.remove();
                    continue;
                }
                if (r.getExit_time() != null) {
                    it1.remove();
                    continue;
                }
                if (r.getPassport_type_no() == null || r.getPassport_type_no().length() == 0) {
                    it1.remove();
                    continue;
                }
                if (!validPassportTypes.containsKey(r.getPassport_type_no())) {
                    it1.remove();
                    continue;
                }
                if (r.getEnter_plate().equals(passport.getRegister_plate())) {
                    if (!r.getPassport_type_no().equals(passportType.getPassport_type_no())) continue;
                    return null;
                }
                Iterator iterator = fixedlist.iterator();
                while (iterator.hasNext()) {
                    KeyValueEntry e = (KeyValueEntry)iterator.next();
                    if (!((CarparkPassport)e.getValue()).getRegister_plate().equals(r.getEnter_plate()) || !((CarparkPassportType)e.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                    iterator.remove();
                    it1.remove();
                    continue block10;
                }
            }
            for (CarparkPresenceRecord r : prenseCarRecords) {
                if (!r.getEnter_plate().equals(passport.getRegister_plate())) continue;
                if (r.getPassport_type_no() == null || r.getPassport_type_no().equals(passportType.getPassport_type_no())) break;
                for (KeyValueEntry keyValueEntry : fixedlist) {
                    if (!((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                    CarparkPassport newPassporrt = passport.clone();
                    newPassporrt.setStart_date(((CarparkPassport)keyValueEntry.getValue()).getStart_date());
                    newPassporrt.setStop_date(((CarparkPassport)keyValueEntry.getValue()).getStop_date());
                    newPassporrt.setValid_date(((CarparkPassport)keyValueEntry.getValue()).getValid_date());
                    newPassporrt.setDeadline(((CarparkPassport)keyValueEntry.getValue()).getDeadline());
                    newPassporrt.setPassport_type_no(((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no());
                    newPassporrt.setBalance(((CarparkPassport)keyValueEntry.getValue()).getBalance());
                    return new KeyValueEntry((Object)((CarparkPassportType)keyValueEntry.getKey()), (Object)newPassporrt);
                }
                for (KeyValueEntry keyValueEntry : templist) {
                    if (!((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                    CarparkPassport newPassporrt = passport.clone();
                    newPassporrt.setStart_date(((CarparkPassport)keyValueEntry.getValue()).getStart_date());
                    newPassporrt.setStop_date(((CarparkPassport)keyValueEntry.getValue()).getStop_date());
                    newPassporrt.setValid_date(((CarparkPassport)keyValueEntry.getValue()).getValid_date());
                    newPassporrt.setDeadline(((CarparkPassport)keyValueEntry.getValue()).getDeadline());
                    newPassporrt.setPassport_type_no(((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no());
                    newPassporrt.setBalance(((CarparkPassport)keyValueEntry.getValue()).getBalance());
                    return new KeyValueEntry((Object)((CarparkPassportType)keyValueEntry.getKey()), (Object)newPassporrt);
                }
                for (KeyValueEntry keyValueEntry : fixedlist1) {
                    if (!((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no().equals(r.getPassport_type_no())) continue;
                    CarparkPassport newPassporrt = passport.clone();
                    newPassporrt.setStart_date(((CarparkPassport)keyValueEntry.getValue()).getStart_date());
                    newPassporrt.setStop_date(((CarparkPassport)keyValueEntry.getValue()).getStop_date());
                    newPassporrt.setValid_date(((CarparkPassport)keyValueEntry.getValue()).getValid_date());
                    newPassporrt.setDeadline(((CarparkPassport)keyValueEntry.getValue()).getDeadline());
                    newPassporrt.setPassport_type_no(((CarparkPassportType)keyValueEntry.getKey()).getPassport_type_no());
                    newPassporrt.setBalance(((CarparkPassport)keyValueEntry.getValue()).getBalance());
                    return new KeyValueEntry((Object)((CarparkPassportType)keyValueEntry.getKey()), (Object)newPassporrt);
                }
            }
        }
        return null;
    }
}

