/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.LogUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.glassfish.grizzly.Buffer;

public class DiskCacheBuffer {
    private byte[] cache;
    private volatile int readOffset;
    private volatile int writeOffset;
    private volatile int memoryCahceSize;
    private final int maxMemeroyCacheSize;
    private volatile long fileReadOffset;
    private volatile long fileWriteOffset;
    private volatile long fileCacheSize;
    private volatile long fileMaxCacheSize;
    private File cacheFile;
    private RandomAccessFile rwFile;
    private DataCacheCallback callback;
    private volatile boolean closed;

    public DiskCacheBuffer() {
        this(0x100000);
    }

    public DiskCacheBuffer(int maxMemeroyCacheSize) {
        this(maxMemeroyCacheSize, 0x6400000L);
    }

    public DiskCacheBuffer(int maxMemeroyCacheSize, long fileMaxCacheSize) {
        this(maxMemeroyCacheSize, null, fileMaxCacheSize);
    }

    public DiskCacheBuffer(int maxMemeroyCacheSize, String cacheFilePath) {
        this(maxMemeroyCacheSize, cacheFilePath, 0x6400000L);
    }

    public DiskCacheBuffer(int maxMemeroyCacheSize, String cacheFilePath, long fileMaxCacheSize) {
        if (maxMemeroyCacheSize < 0) {
            maxMemeroyCacheSize = 0;
        }
        this.maxMemeroyCacheSize = maxMemeroyCacheSize;
        if (fileMaxCacheSize <= 0L) {
            fileMaxCacheSize = 0L;
        }
        this.fileMaxCacheSize = fileMaxCacheSize;
        if (fileMaxCacheSize > 0L) {
            File file = cacheFilePath == null || cacheFilePath.length() == 0 ? new File(PathFinder.findRuntimeTempDayDir(), "cahce/" + System.currentTimeMillis() + "_" + ServiceUtil.getServiceContext().createLongSeq() + ".cache") : new File(cacheFilePath);
            this.cacheFile = file;
        }
    }

    public synchronized long availableSize() {
        return (long)this.memoryCahceSize + this.fileCacheSize;
    }

    public boolean write(ByteBuffer buf) {
        byte[] array;
        int length;
        int offset;
        if (buf == null || !buf.hasRemaining()) {
            return true;
        }
        if (buf.hasArray()) {
            offset = buf.position() + buf.arrayOffset();
            length = buf.remaining();
            array = buf.array();
        } else {
            offset = 0;
            length = buf.remaining();
            array = new byte[length];
            buf.get(array);
        }
        return this.write(array, offset, length);
    }

    public boolean write(Buffer buf) {
        byte[] array;
        int length;
        int offset;
        if (buf == null || !buf.hasRemaining()) {
            return true;
        }
        if (buf.hasArray()) {
            offset = buf.position() + buf.arrayOffset();
            length = buf.remaining();
            array = buf.array();
        } else {
            offset = 0;
            length = buf.remaining();
            array = new byte[length];
            buf.get(array);
        }
        return this.write(array, offset, length);
    }

    public synchronized void setDataCacheCallback(DataCacheCallback callback) {
        this.callback = callback;
    }

    public boolean write(byte[] data) {
        if (data == null || data.length == 0) {
            return true;
        }
        return this.write(data, 0, data.length);
    }

    private void writeToMemoryCache(byte[] data, int offset, int length) {
        int rightRmain = this.cache.length - this.writeOffset;
        if (rightRmain >= length) {
            System.arraycopy(data, offset, this.cache, this.writeOffset, length);
            this.writeOffset += length;
            this.memoryCahceSize += length;
        } else {
            if (rightRmain > 0) {
                System.arraycopy(data, offset, this.cache, this.writeOffset, rightRmain);
                offset += rightRmain;
                length -= rightRmain;
                this.writeOffset += rightRmain;
                this.memoryCahceSize += rightRmain;
            }
            this.writeOffset = 0;
            System.arraycopy(data, offset, this.cache, this.writeOffset, length);
            this.writeOffset += length;
            this.memoryCahceSize += length;
        }
    }

    public synchronized boolean write(byte[] data, int offset, int length) {
        if (this.closed) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        if (this.cache == null && this.maxMemeroyCacheSize > 0) {
            this.cache = new byte[this.maxMemeroyCacheSize];
        }
        if (this.cache != null && this.cache.length > 0 && this.memoryCahceSize < this.cache.length) {
            int memoryRemain = this.cache.length - this.memoryCahceSize;
            if (length <= memoryRemain) {
                this.writeToMemoryCache(data, offset, length);
                if (this.callback != null) {
                    this.callback.onNewDataCached(this, (long)this.memoryCahceSize + this.fileCacheSize);
                }
                return true;
            }
            this.writeToMemoryCache(data, offset, memoryRemain);
            if (this.writeToFile(data, offset + memoryRemain, length - memoryRemain)) {
                if (this.callback != null) {
                    this.callback.onNewDataCached(this, (long)this.memoryCahceSize + this.fileCacheSize);
                }
                return true;
            }
            return false;
        }
        if (this.writeToFile(data, offset, length)) {
            if (this.callback != null) {
                this.callback.onNewDataCached(this, (long)this.memoryCahceSize + this.fileCacheSize);
            }
            return true;
        }
        return false;
    }

    private boolean writeToFile(byte[] data, int offset, int length) {
        if (this.cacheFile == null || this.fileMaxCacheSize <= 0L) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        if (this.fileCacheSize + (long)length > this.fileMaxCacheSize) {
            LogUtil.getLog().warn((Object)("\u6587\u4ef6\u7f13\u5b58\u5df2\u6ee1\uff01\u6216\u4e0d\u8db3\u5199\u5165" + length + "\u4e2a\u5b57\u8282"));
            return false;
        }
        if (this.rwFile == null) {
            boolean x;
            if (!this.cacheFile.getParentFile().exists() && !(x = this.cacheFile.mkdirs())) {
                LogUtil.getLog().warn((Object)("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff01" + this.cacheFile.getParentFile()));
                return false;
            }
            try {
                this.rwFile = new RandomAccessFile(this.cacheFile, "rw");
            }
            catch (IOException ex) {
                LogUtil.getLog().warn((Object)("\u521b\u5efa\u6587\u4ef6" + this.cacheFile.getAbsolutePath() + "\u7f13\u5b58\u5931\u8d25\uff01" + ex));
                return false;
            }
        }
        try {
            long rightRmain = this.fileMaxCacheSize - this.fileWriteOffset;
            if (rightRmain >= (long)length) {
                this.rwFile.seek(this.fileWriteOffset);
                this.rwFile.write(data, offset, length);
                this.fileWriteOffset += (long)length;
                this.fileCacheSize += (long)length;
            } else {
                if (rightRmain > 0L) {
                    this.rwFile.seek(this.fileWriteOffset);
                    int r = (int)rightRmain;
                    this.rwFile.write(data, offset, r);
                    offset += r;
                    length -= r;
                    this.fileWriteOffset += (long)r;
                    this.fileCacheSize += (long)r;
                }
                this.fileWriteOffset = 0L;
                this.rwFile.seek(this.fileWriteOffset);
                this.rwFile.write(data, offset, length);
                this.fileWriteOffset += (long)length;
                this.fileCacheSize += (long)length;
            }
            return true;
        }
        catch (Exception ex) {
            LogUtil.getLog().warn((Object)("\u5199\u5165\u6587\u4ef6\u7f13\u5b58\u5931\u8d25\uff01" + ex));
            return false;
        }
    }

    public int read(byte[] readCache) {
        if (readCache == null || readCache.length == 0) {
            return 0;
        }
        return this.read(readCache, 0, readCache.length);
    }

    public synchronized int read(byte[] readCache, int readCacheOffset, int maxReadLength) {
        if (this.closed) {
            return -1;
        }
        if (maxReadLength <= 0) {
            return 0;
        }
        if (readCache == null || readCache.length == 0) {
            return 0;
        }
        if (readCacheOffset >= readCache.length) {
            return 0;
        }
        if (readCacheOffset + maxReadLength > readCache.length) {
            maxReadLength = readCache.length - readCacheOffset;
        }
        if (maxReadLength <= 0) {
            return 0;
        }
        if (this.memoryCahceSize == 0 && this.fileCacheSize == 0L) {
            return 0;
        }
        if (this.memoryCahceSize > 0) {
            if (maxReadLength <= this.memoryCahceSize) {
                int readCount = this.readFromMemoryCache(readCache, readCacheOffset, maxReadLength);
                this.readFileDataToMemory();
                return readCount;
            }
            if (this.fileCacheSize <= 0L) {
                int readCount = this.readFromMemoryCache(readCache, readCacheOffset, this.memoryCahceSize);
                return readCount;
            }
            int readCount = this.readFromMemoryCache(readCache, readCacheOffset, this.memoryCahceSize);
            int count1 = this.readFromFileCache(readCache, readCacheOffset + readCount, maxReadLength - readCount);
            this.readFileDataToMemory();
            return readCount + count1;
        }
        if (this.fileCacheSize > 0L) {
            int count1 = this.readFromFileCache(readCache, readCacheOffset, maxReadLength);
            this.readFileDataToMemory();
            return count1;
        }
        return 0;
    }

    private void readFileDataToMemory() {
        if (this.fileCacheSize <= 0L) {
            return;
        }
        if (this.cache == null || this.cache.length == 0) {
            return;
        }
        int memoryRemain = this.cache.length - this.memoryCahceSize;
        if (memoryRemain <= 0) {
            return;
        }
        int rightRmain = this.cache.length - this.writeOffset;
        int length = this.fileCacheSize <= (long)memoryRemain ? (int)this.fileCacheSize : memoryRemain;
        if (rightRmain >= length) {
            int r = this.readFromFileCache(this.cache, this.writeOffset, length);
            this.writeOffset += r;
            this.memoryCahceSize += r;
        } else {
            int r;
            if (rightRmain > 0) {
                r = this.readFromFileCache(this.cache, this.writeOffset, rightRmain);
                this.writeOffset += r;
                length -= r;
                this.memoryCahceSize += r;
            }
            this.writeOffset = 0;
            r = this.readFromFileCache(this.cache, this.writeOffset, length);
            this.writeOffset += r;
            this.memoryCahceSize += r;
        }
    }

    private int readFromFileCache(byte[] readCache, int readCacheOffset, int maxReadLength) {
        block10: {
            block9: {
                try {
                    if ((long)maxReadLength > this.fileCacheSize) {
                        maxReadLength = (int)this.fileCacheSize;
                    }
                    if (this.fileCacheSize > 0L) break block9;
                    return 0;
                }
                catch (Exception ex) {
                    LogUtil.getLog().warn((Object)("\u8bfb\u53d6\u6587\u4ef6\u7f13\u5b58\u5931\u8d25\uff01" + ex));
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            if (this.rwFile != null) break block10;
            return 0;
        }
        long rightRmain = this.fileMaxCacheSize - this.fileReadOffset;
        int readSize = maxReadLength;
        if (rightRmain >= (long)maxReadLength) {
            this.rwFile.seek(this.fileReadOffset);
            this.rwFile.read(readCache, readCacheOffset, maxReadLength);
            this.fileReadOffset += (long)maxReadLength;
            this.fileCacheSize -= (long)maxReadLength;
        } else {
            if (rightRmain > 0L) {
                this.rwFile.seek(this.fileReadOffset);
                int r = (int)rightRmain;
                this.rwFile.read(readCache, readCacheOffset, r);
                readCacheOffset += r;
                maxReadLength -= r;
                this.fileReadOffset += (long)r;
                this.fileCacheSize -= (long)r;
            }
            this.fileReadOffset = 0L;
            this.rwFile.seek(this.fileReadOffset);
            this.rwFile.read(readCache, readCacheOffset, maxReadLength);
            this.fileReadOffset += (long)maxReadLength;
            this.fileCacheSize -= (long)maxReadLength;
        }
        return readSize;
    }

    private int readFromMemoryCache(byte[] readCache, int readCacheOffset, int maxReadLength) {
        if (maxReadLength > this.memoryCahceSize) {
            maxReadLength = this.memoryCahceSize;
        }
        if (maxReadLength == 0) {
            return 0;
        }
        int rightRmain = this.cache.length - this.readOffset;
        int size = maxReadLength;
        if (rightRmain >= maxReadLength) {
            System.arraycopy(this.cache, this.readOffset, readCache, readCacheOffset, maxReadLength);
            this.readOffset += maxReadLength;
            this.memoryCahceSize -= maxReadLength;
        } else {
            if (rightRmain > 0) {
                System.arraycopy(this.cache, this.readOffset, readCache, readCacheOffset, rightRmain);
                readCacheOffset += rightRmain;
                maxReadLength -= rightRmain;
                this.readOffset += rightRmain;
                this.memoryCahceSize -= rightRmain;
            }
            this.readOffset = 0;
            System.arraycopy(this.cache, this.readOffset, readCache, readCacheOffset, maxReadLength);
            this.readOffset += maxReadLength;
            this.memoryCahceSize -= maxReadLength;
        }
        return size;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.cache = null;
        this.readOffset = 0;
        this.writeOffset = 0;
        this.memoryCahceSize = 0;
        this.fileReadOffset = 0L;
        this.fileWriteOffset = 0L;
        this.fileCacheSize = 0L;
        if (this.rwFile != null) {
            try {
                this.rwFile.close();
            }
            catch (Throwable ex) {
                LogUtil.getLog().warn((Object)("\u5173\u95ed\u6587\u4ef6\u5931\u8d25\uff01" + ex));
            }
        }
        if (this.cacheFile != null && this.cacheFile.exists() && this.cacheFile.isFile()) {
            try {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            boolean ok;
                            if (DiskCacheBuffer.this.cacheFile != null && DiskCacheBuffer.this.cacheFile.exists() && DiskCacheBuffer.this.cacheFile.isFile() && !(ok = DiskCacheBuffer.this.cacheFile.delete())) {
                                LogUtil.getLog().warn((Object)("\u5220\u9664\u6587\u4ef6" + DiskCacheBuffer.this.cacheFile.getAbsolutePath() + "\u5931\u8d25\uff01"));
                            }
                        }
                        catch (Throwable ex) {
                            LogUtil.getLog().warn((Object)("\u5220\u9664\u6587\u4ef6" + DiskCacheBuffer.this.cacheFile.getAbsolutePath() + "\u5931\u8d25\uff01" + ex));
                        }
                    }
                });
            }
            catch (Exception ex) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            boolean ok;
                            if (DiskCacheBuffer.this.cacheFile != null && DiskCacheBuffer.this.cacheFile.exists() && DiskCacheBuffer.this.cacheFile.isFile() && !(ok = DiskCacheBuffer.this.cacheFile.delete())) {
                                LogUtil.getLog().warn((Object)("\u5220\u9664\u6587\u4ef6" + DiskCacheBuffer.this.cacheFile.getAbsolutePath() + "\u5931\u8d25\uff01"));
                            }
                        }
                        catch (Throwable ex) {
                            LogUtil.getLog().warn((Object)("\u5220\u9664\u6587\u4ef6" + DiskCacheBuffer.this.cacheFile.getAbsolutePath() + "\u5931\u8d25\uff01" + ex));
                        }
                    }
                }).start();
            }
        }
    }

    public static interface DataCacheCallback {
        public void onNewDataCached(DiskCacheBuffer var1, long var2);
    }
}

