/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.dao.CommonDaoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DispatchDataTaskUtil {
    public static final String DT_ALL_HOSTS = "ALL_HOSTS";
    public static final String DT_ALL_HOSTS_PC = "ALL_HOSTS_PC";
    public static final String DT_CARPARK_SERVER_ONLY = "CARPARK_SERVER";

    public static List<CarparkDispatchTask> createDispatchRecordByIdTaskList(String tableName, Object id, String dispathType) {
        if (tableName == null || tableName.length() == 0) {
            return new ArrayList<CarparkDispatchTask>(0);
        }
        if (id == null) {
            return new ArrayList<CarparkDispatchTask>(0);
        }
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("tableName", tableName);
        pMap.put("id", id.toString());
        String json_data = GsonBuilder.create().toJson(pMap);
        String serviceName = "transferDataService.sendDbRecordById";
        List<CarparkDispatchTask> list = DispatchDataTaskUtil.createDispatchTaskList(serviceName, json_data, dispathType);
        if (list == null) {
            list = new ArrayList<CarparkDispatchTask>(0);
        }
        return list;
    }

    public static List<CarparkDispatchTask> createDispatchLocalPicTaskList(String picPath, String dispathType) {
        if (picPath == null || picPath.length() == 0) {
            return new ArrayList<CarparkDispatchTask>(0);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("path", picPath);
        String json_data = GsonBuilder.create().toJson(paramMap);
        String serviceName = "transferDataService.sendLocalPic";
        List<CarparkDispatchTask> list = DispatchDataTaskUtil.createDispatchTaskList(serviceName, json_data, dispathType);
        if (list == null) {
            list = new ArrayList<CarparkDispatchTask>(0);
        }
        return list;
    }

    public static List<CarparkDispatchTask> createDispatchTaskList(String serviceName, String json_data, String dispathType) {
        if (serviceName == null || serviceName.length() == 0) {
            return new ArrayList<CarparkDispatchTask>(0);
        }
        if (json_data == null || json_data.length() == 0) {
            return new ArrayList<CarparkDispatchTask>(0);
        }
        if (dispathType == null || dispathType.length() == 0) {
            return new ArrayList<CarparkDispatchTask>(0);
        }
        String localHostNo = ServiceUtil.getServiceContext().getLocalHostNo();
        Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkLocalConfig localConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (localConfig.getCarpark_deploy_type() == 1) {
            if (DT_ALL_HOSTS.equals(dispathType) || DT_ALL_HOSTS_PC.equals(dispathType)) {
                boolean onlyPc = DT_ALL_HOSTS_PC.equals(dispathType);
                if (localConfig.getHost_use() != 1) {
                    ServiceLog.getLog().warn((Object)"\u672c\u673a\u914d\u7f6e\u9519\u8bef\uff01\u53ea\u80fd\u662f\u5c97\u4ead\u5ba2\u6237\u7aef\uff0c\u4f46\u662f\u90e8\u7f72\u7c7b\u578b\u4e3a\u670d\u52a1\u5668\uff0c\u4e0d\u5e94\u8be5\u5b58\u5728\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u6d4b\uff0c\u65e0\u6cd5\u8f6c\u53d1\u5904\u7406.....");
                    return new ArrayList<CarparkDispatchTask>(0);
                }
                LinkedList<CarparkDispatchTask> taskList = new LinkedList<CarparkDispatchTask>();
                if (localConfig.getHost_type() == 1) {
                    CarparkHost serverHost = null;
                    for (CarparkHost host : hostMap.values()) {
                        CarparkDispatchTask task;
                        if (localHostNo.equals(host.getHost_no())) continue;
                        if (host.getHost_use() == 2 || host.getHost_use() == 3) {
                            serverHost = host;
                            if (host.getHost_type() == 2) {
                                task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, serviceName, host.getHost_no(), json_data);
                                taskList.add(task);
                                continue;
                            }
                            ServiceLog.getLog().warn((Object)"\u672c\u673a\u914d\u7f6e\u9519\u8bef\uff01\u8f6f\u4ef6\u4e0d\u652f\u6301\u975e\u4e91\u7aef\u670d\u52a1\u5668\u7684\u6570\u636e\u8f6c\u53d1\uff0c\u65e0\u6cd5\u8f6c\u53d1\u6570\u636e\u5230\u670d\u52a1\u5668.....");
                            continue;
                        }
                        if (onlyPc && host.getHost_type() != null && host.getHost_type() != 1) continue;
                        task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, serviceName, host.getHost_no(), json_data);
                        taskList.add(task);
                    }
                    if (serverHost == null) {
                        ServiceLog.getLog().warn((Object)"\u672c\u673a\u914d\u7f6e\u9519\u8bef\uff01\u4e3b\u673a\u7ba1\u7406\u4e2d\u7f3a\u5c11\u4e3b\u673a\u90e8\u7f72\u7c7b\u578b\u4e3a\u505c\u8f66\u573a\u670d\u52a1\u5668\u7684\u4e3b\u673a\uff0c\u8fd9\u4f1a\u5bfc\u81f4\u6570\u636e\u65e0\u6cd5\u53d1\u9001\u7ed9\u670d\u52a1\u5668");
                    }
                } else {
                    ServiceLog.getLog().warn((Object)"\u672c\u673a\u914d\u7f6e\u9519\u8bef\uff01\u672c\u673a\u662f\u7535\u8111\uff0c\u4f46\u662f\u914d\u7f6e\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u6d4b\u4e91\u7aef\u914d\u7f6e\uff0c\u4e0d\u5e94\u8be5\u5b58\u5728\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u6d4b\uff0c\u65e0\u6cd5\u8f6c\u53d1\u5904\u7406.....");
                }
                return taskList;
            }
            if (DT_CARPARK_SERVER_ONLY.equals(dispathType)) {
                if (localConfig.getHost_use() != 1) {
                    ServiceLog.getLog().warn((Object)"\u672c\u673a\u914d\u7f6e\u9519\u8bef\uff01\u672c\u673a\u53ea\u80fd\u662f\u5c97\u4ead\u5ba2\u6237\u7aef\uff0c\u4f46\u662f\u90e8\u7f72\u7c7b\u578b\u4e3a\u670d\u52a1\u5668\uff0c\u4e0d\u5e94\u8be5\u5b58\u5728\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u6d4b");
                    return new ArrayList<CarparkDispatchTask>(0);
                }
                CarparkHost serverHost = null;
                for (CarparkHost host : hostMap.values()) {
                    if (host.getHost_use() != 2 && host.getHost_use() != 3) continue;
                    serverHost = host;
                    break;
                }
                if (serverHost == null) {
                    ServiceLog.getLog().warn((Object)"\u672c\u673a\u914d\u7f6e\u9519\u8bef\uff01\u4e3b\u673a\u7ba1\u7406\u4e2d\u7f3a\u5c11\u4e3b\u673a\u90e8\u7f72\u7c7b\u578b\u4e3a\u505c\u8f66\u573a\u670d\u52a1\u5668\u7684\u4e3b\u673a\uff0c\u8fd9\u4f1a\u5bfc\u81f4\u6570\u636e\u65e0\u6cd5\u53d1\u9001\u7ed9\u670d\u52a1\u5668");
                    return new ArrayList<CarparkDispatchTask>(0);
                }
                if (localHostNo.equals(serverHost.getHost_no())) {
                    return new ArrayList<CarparkDispatchTask>(0);
                }
                LinkedList<CarparkDispatchTask> taskList = new LinkedList<CarparkDispatchTask>();
                CarparkDispatchTask task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, serviceName, serverHost.getHost_no(), json_data);
                taskList.add(task);
                return taskList;
            }
            if (localHostNo.equals(dispathType)) {
                return new ArrayList<CarparkDispatchTask>(0);
            }
            CarparkHost destHost = hostMap.get(dispathType);
            if (destHost == null) {
                return new ArrayList<CarparkDispatchTask>(0);
            }
            LinkedList<CarparkDispatchTask> taskList = new LinkedList<CarparkDispatchTask>();
            CarparkDispatchTask task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, serviceName, destHost.getHost_no(), json_data);
            taskList.add(task);
            return taskList;
        }
        if (DT_ALL_HOSTS.equals(dispathType) || DT_ALL_HOSTS_PC.equals(dispathType)) {
            boolean onlyPc = DT_ALL_HOSTS_PC.equals(dispathType);
            if (localConfig.getHost_use() != 1) {
                LinkedList<CarparkDispatchTask> taskList = new LinkedList<CarparkDispatchTask>();
                for (CarparkHost host : hostMap.values()) {
                    if (localHostNo.equals(host.getHost_no()) || host.getHost_use() != 1 || onlyPc && host.getHost_type() != null && host.getHost_type() != 1) continue;
                    CarparkDispatchTask task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, serviceName, host.getHost_no(), json_data);
                    taskList.add(task);
                }
                return taskList;
            }
            if (localConfig.getNet_mode() == 2) {
                CarparkHost serverHost = null;
                StringBuilder dispathHostNos = new StringBuilder(128);
                for (CarparkHost host : hostMap.values()) {
                    if (localHostNo.equals(host.getHost_no())) continue;
                    if (host.getHost_use() == 2 || host.getHost_use() == 3) {
                        serverHost = host;
                        continue;
                    }
                    if (onlyPc && host.getHost_type() != null && host.getHost_type() != 1) continue;
                    if (dispathHostNos.length() > 0) {
                        dispathHostNos.append(',');
                    }
                    dispathHostNos.append(host.getHost_no());
                }
                if (serverHost == null) {
                    return new ArrayList<CarparkDispatchTask>(0);
                }
                LinkedList<CarparkDispatchTask> taskList = new LinkedList<CarparkDispatchTask>();
                if (dispathHostNos.length() == 0) {
                    CarparkDispatchTask task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, serviceName, serverHost.getHost_no(), json_data);
                    taskList.add(task);
                } else {
                    HashMap<String, String> proxMap = new HashMap<String, String>();
                    proxMap.put("serviceName", serviceName);
                    proxMap.put("json_data", json_data);
                    proxMap.put("dispathHosts", dispathHostNos.toString());
                    String proxyJson = GsonBuilder.create().toJson(proxMap);
                    String proxyServiceName = "transferDataService.proxyDispath";
                    CarparkDispatchTask task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, proxyServiceName, serverHost.getHost_no(), proxyJson);
                    taskList.add(task);
                }
                return taskList;
            }
            LinkedList<CarparkDispatchTask> taskList = new LinkedList<CarparkDispatchTask>();
            StringBuilder dispathHostNos = new StringBuilder(128);
            CarparkHost serverHost = null;
            for (CarparkHost host : hostMap.values()) {
                if (localHostNo.equals(host.getHost_no())) continue;
                if (host.getHost_use() == 2 || host.getHost_use() == 3) {
                    serverHost = host;
                    continue;
                }
                if (onlyPc && host.getHost_type() != null && host.getHost_type() != 1) continue;
                if (host.getNet_mode() == 2) {
                    if (dispathHostNos.length() > 0) {
                        dispathHostNos.append(',');
                    }
                    dispathHostNos.append(host.getHost_no());
                    continue;
                }
                CarparkDispatchTask task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, serviceName, host.getHost_no(), json_data);
                taskList.add(task);
            }
            if (serverHost != null) {
                if (dispathHostNos.length() > 0) {
                    HashMap<String, String> proxMap = new HashMap<String, String>();
                    proxMap.put("serviceName", serviceName);
                    proxMap.put("json_data", json_data);
                    proxMap.put("dispathHosts", dispathHostNos.toString());
                    String proxyJson = GsonBuilder.create().toJson(proxMap);
                    String proxyServiceName = "transferDataService.proxyDispath";
                    CarparkDispatchTask task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, proxyServiceName, serverHost.getHost_no(), proxyJson);
                    taskList.addFirst(task);
                } else {
                    CarparkDispatchTask task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, serviceName, serverHost.getHost_no(), json_data);
                    taskList.addFirst(task);
                }
            }
            return taskList;
        }
        if (DT_CARPARK_SERVER_ONLY.equals(dispathType)) {
            if (localConfig.getHost_use() != 1) {
                return new ArrayList<CarparkDispatchTask>(0);
            }
            CarparkHost serverHost = null;
            for (CarparkHost host : hostMap.values()) {
                if (host.getHost_use() != 2 && host.getHost_use() != 3) continue;
                serverHost = host;
                break;
            }
            if (serverHost == null) {
                return new ArrayList<CarparkDispatchTask>(0);
            }
            if (localHostNo.equals(serverHost.getHost_no())) {
                return new ArrayList<CarparkDispatchTask>(0);
            }
            LinkedList<CarparkDispatchTask> taskList = new LinkedList<CarparkDispatchTask>();
            CarparkDispatchTask task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, serviceName, serverHost.getHost_no(), json_data);
            taskList.add(task);
            return taskList;
        }
        if (localHostNo.equals(dispathType)) {
            return new ArrayList<CarparkDispatchTask>(0);
        }
        CarparkHost destHost = hostMap.get(dispathType);
        if (destHost == null) {
            return new ArrayList<CarparkDispatchTask>(0);
        }
        LinkedList<CarparkDispatchTask> taskList = new LinkedList<CarparkDispatchTask>();
        CarparkDispatchTask task = DispatchDataTaskUtil.createCarparkDispatchTask(commonDaoService, serviceName, destHost.getHost_no(), json_data);
        taskList.add(task);
        return taskList;
    }

    public static CarparkDispatchTask createCarparkDispatchTask(CommonDaoService commonDaoService, String serviceName, String hostNo, String json_data) {
        CarparkDispatchTask task = new CarparkDispatchTask();
        task.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
        task.setCreated_time(new Date());
        task.setHost_no(hostNo);
        task.setId(commonDaoService.getSequece("ck_carpark_dispatch_task_seq"));
        task.setJson_data(json_data);
        task.setProject_id(ServiceUtil.getServiceContext().getProjectId());
        task.setService_name(serviceName);
        return task;
    }
}

