/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.dao.ApplicationDao;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentDriverManager;
import com.wovoe.carpark.equipment.EquipmentManager;
import com.wovoe.carpark.equipment.driver.NT371QRCodeScanDriver;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.dao.CommonDaoService;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.SqlSession;

public class EquipmentLoader {
    public static void loadEquipment(final String hostNo, final String hostName, final boolean loadComputerEquipment, boolean asyn, final int[] equipmentTypes) {
        if (asyn) {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        EquipmentLoader.load(hostNo, hostName, loadComputerEquipment, equipmentTypes);
                    }
                    catch (Exception ex) {
                        LogUtil.getLog().error((Object)"\u52a0\u8f7d\u8bbe\u5907\u5f02\u5e38!", (Throwable)ex);
                    }
                }
            });
        } else {
            EquipmentLoader.load(hostNo, hostName, loadComputerEquipment, equipmentTypes);
        }
    }

    public static void unRegisterServerAllCamrea() {
        CarparkHost localhost = ServiceUtil.getServiceContext().getLocalHost();
        if (localhost != null && (localhost.getHost_use() == 2 || localhost.getHost_use() == 3)) {
            EquipmentLoader.unRegisterServerAllCamrea0(localhost.getHost_no());
        }
    }

    private static synchronized void unRegisterServerAllCamrea0(String localhostNo) {
        Enumeration<Equipment> eneq = ServiceUtil.getServiceContext().getEquipmentManager().getAllEquipments();
        if (eneq != null) {
            while (eneq.hasMoreElements()) {
                String mhost;
                Equipment existEq = eneq.nextElement();
                if (existEq.getType() != 33 || localhostNo.equals(mhost = (String)existEq.getAttribute("EQ_OWNER_HOST_NO")) || existEq.getChannelNos() == null || existEq.getChannelNos().isEmpty()) continue;
                boolean needRemove = true;
                for (String channelNo : existEq.getChannelNos()) {
                    if (ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo) == null) continue;
                    needRemove = false;
                    break;
                }
                if (!needRemove) continue;
                try {
                    existEq.getDriver().stopEquipment(existEq);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u505c\u6b62\u8bbe\u5907\u5f02\u5e38\uff1a" + existEq.getParentEquipmentNo() + "," + existEq.getName()), (Throwable)ex);
                }
            }
        }
    }

    public static void loadServerAllCamreaIfParkingServer(boolean asyn) {
        Map<String, CarparkHost> hostMap;
        CarparkHost localhost = ServiceUtil.getServiceContext().getLocalHost();
        if (localhost != null && (localhost.getHost_use() == 2 || localhost.getHost_use() == 3) && (hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap()) != null) {
            for (CarparkHost h : hostMap.values()) {
                if (localhost.getHost_no().equals(h.getHost_no()) || h.getHost_use() != 1 || h.getNet_mode() != 1) continue;
                EquipmentLoader.loadEquipment(h.getHost_no(), h.getHost_name(), false, asyn, new int[]{33});
            }
        }
    }

    public static synchronized void destoryNotExsitHostEq() {
        Enumeration<Equipment> eneq = ServiceUtil.getServiceContext().getEquipmentManager().getAllEquipments();
        if (eneq != null) {
            while (eneq.hasMoreElements()) {
                Equipment existEq = eneq.nextElement();
                String mhost = (String)existEq.getAttribute("EQ_OWNER_HOST_NO");
                if (ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(mhost) != null) continue;
                try {
                    existEq.getDriver().stopEquipment(existEq);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u505c\u6b62\u8bbe\u5907\u5f02\u5e38\uff1a" + existEq.getParentEquipmentNo() + "," + existEq.getName()), (Throwable)ex);
                }
            }
        }
    }

    private static synchronized void load(final String hostNo, String hostName, boolean loadComputerEquipment, int[] equipmentTypes) {
        final EquipmentManager equipmentManager = ServiceUtil.getServiceContext().getEquipmentManager();
        final EquipmentDriverManager driverManager = ServiceUtil.getServiceContext().getEquipmentDriverManager();
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession sqlSession = daoService.openSqlSession();){
            CarparkLocalConfig localConfig;
            ApplicationDao applicationDao = (ApplicationDao)sqlSession.getMapper(ApplicationDao.class);
            final boolean localQq = hostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo());
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("hostNo", hostNo);
            param.put("carparkId", ServiceUtil.getServiceContext().getCarparkId());
            param.put("projectId", ServiceUtil.getServiceContext().getProjectId());
            if (equipmentTypes != null && equipmentTypes.length > 0) {
                if (equipmentTypes.length == 1) {
                    param.put("equipment_type", equipmentTypes[0]);
                } else {
                    param.put("equipmentTypes", equipmentTypes);
                }
            }
            if (localQq && (localConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig()).getHost_use() == 1 && localConfig.getNet_mode() == 2 && localConfig.getCarpark_deploy_type() == 1) {
                param.put("use_slave", "1");
            }
            final LinkedList controller = new LinkedList();
            final LinkedList boxIcSerial = new LinkedList();
            final LinkedList localEquipments = new LinkedList();
            final Equipment[] last = new Equipment[1];
            final HashMap<String, Equipment> existEquipmentMap = new HashMap<String, Equipment>();
            Enumeration<Equipment> eneq = equipmentManager.getAllEquipments();
            if (eneq != null) {
                block5: while (eneq.hasMoreElements()) {
                    Equipment existEq = eneq.nextElement();
                    String mhost = (String)existEq.getAttribute("EQ_OWNER_HOST_NO");
                    if (!hostNo.equals(mhost)) continue;
                    if (equipmentTypes == null || equipmentTypes.length == 0) {
                        if (loadComputerEquipment) {
                            existEquipmentMap.put(existEq.getEquipmentNo(), existEq);
                            continue;
                        }
                        if (existEq.getChannelNos() == null || existEq.getChannelNos().isEmpty()) continue;
                        existEquipmentMap.put(existEq.getEquipmentNo(), existEq);
                        continue;
                    }
                    int[] nArray = equipmentTypes;
                    int n = equipmentTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int h = nArray[n2];
                        if (h == existEq.getType()) {
                            if (loadComputerEquipment) {
                                existEquipmentMap.put(existEq.getEquipmentNo(), existEq);
                                continue block5;
                            }
                            if (existEq.getChannelNos() == null || existEq.getChannelNos().isEmpty()) continue block5;
                            existEquipmentMap.put(existEq.getEquipmentNo(), existEq);
                            continue block5;
                        }
                        ++n2;
                    }
                }
            }
            applicationDao.queryEquipmentUseLoad(param, new ResultHandler<Map<String, Object>>(){
                String _eNo = null;
                Equipment e = null;

                public void handleResult(ResultContext<? extends Map<String, Object>> resultContext) {
                    Map row = (Map)resultContext.getResultObject();
                    if (row == null) {
                        return;
                    }
                    String eqNo = (String)row.get("equipment_no");
                    if (eqNo == null) {
                        return;
                    }
                    if (this._eNo == null || !this._eNo.equals(eqNo)) {
                        CarparkHost host;
                        String slaveHostNo;
                        PassChannel passChannel;
                        CarparkLocalConfig config;
                        String channel_no;
                        if (this.e != null && this.e.getType() != 31 && this.e.getType() != 36 && this.e.getType() != 35) {
                            EquipmentLoader.loadEquipment(hostNo, existEquipmentMap, this.e, equipmentManager);
                        }
                        this._eNo = eqNo;
                        this.e = null;
                        String driverName = (String)row.get("equipment_driver");
                        if (driverName == null) {
                            return;
                        }
                        EquipmentDriver dr = driverManager.getByDrivrName(driverName);
                        if (dr == null) {
                            return;
                        }
                        if (dr.getEquipmentType() == 39 && dr instanceof NT371QRCodeScanDriver && (channel_no = (String)row.get("channel_no")) != null && channel_no.length() > 0 && (config = ServiceUtil.getServiceContext().getCarparkLocalConfig()) != null && config.getCarpark_deploy_type() == 1 && config.getNet_mode() == 2 && config.getHost_use() == 1 && (passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channel_no)) != null && (slaveHostNo = passChannel.getChannel().getSlave_managed_host_no()) != null && slaveHostNo.length() > 0 && !slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) && (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) != null && host.getHost_use() == 1 && host.getNet_mode() == 2) {
                            return;
                        }
                        this.e = dr.createEquipment(eqNo);
                        this.e.setName((String)row.get("equipment_name"));
                        this.e.setManufacturer((String)row.get("equipment_manufacturer"));
                        this.e.setModel((String)row.get("equipment_model"));
                        this.e.setSerialNo((String)row.get("equipment_serial_number"));
                        this.e.setUse((Integer)row.get("equipment_use"));
                        this.e.setChannelNos(new CopyOnWriteArrayList<String>());
                        this.e.setAttribute("localManageEquipment", localQq);
                        this.e.setAttribute("config", new LinkedHashMap());
                        this.e.setParentEquipmentNo((String)row.get("parent_equipment_no"));
                        this.e.setAttribute("EQ_OWNER_HOST_NO", hostNo);
                        last[0] = this.e;
                        if (this.e.getType() == 16) {
                            controller.add(this.e);
                        } else if (this.e.getType() == 31) {
                            boxIcSerial.add(this.e);
                        } else if (this.e.getType() == 35 || this.e.getType() == 36) {
                            localEquipments.add(this.e);
                        }
                    }
                    if (this.e != null) {
                        Map config;
                        List<String> channelNos;
                        String channel_no = (String)row.get("channel_no");
                        if (channel_no != null && channel_no.length() > 0 && (channelNos = this.e.getChannelNos()) != null && !channelNos.contains(channel_no)) {
                            channelNos.add(channel_no);
                        }
                        if ((config = (Map)this.e.getAttribute("config")) != null) {
                            String config_key = (String)row.get("config_key");
                            String config_value = (String)row.get("config_value");
                            if (config_key != null && config_value != null) {
                                config.put(config_key, config_value);
                            }
                        }
                    }
                }
            });
            if (last[0] != null && last[0].getType() != 31 && last[0].getType() != 36 && last[0].getType() != 35) {
                EquipmentLoader.loadEquipment(hostNo, existEquipmentMap, last[0], equipmentManager);
            }
            if (!controller.isEmpty()) {
                for (Equipment e : controller) {
                    e.setAttribute("can_check", "true");
                    e.setAttribute("loadAllFinish", "true");
                }
            }
            if (!localEquipments.isEmpty() && hostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo())) {
                for (Equipment e : localEquipments) {
                    EquipmentLoader.loadEquipment(hostNo, existEquipmentMap, e, equipmentManager);
                }
            }
            if (!boxIcSerial.isEmpty() && hostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo())) {
                for (Equipment e : boxIcSerial) {
                    EquipmentLoader.loadEquipment(hostNo, existEquipmentMap, e, equipmentManager);
                }
            }
            LogUtil.getLog().info((Object)"\u52a0\u8f7d\u901a\u9053\u4e0b\u8bbe\u5907\u5b8c\u6bd5!");
            if (!existEquipmentMap.isEmpty()) {
                for (Equipment e : existEquipmentMap.values()) {
                    try {
                        e.getDriver().stopEquipment(e);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u505c\u6b62\u8bbe\u5907\u5f02\u5e38\uff1a" + e.getParentEquipmentNo() + "," + e.getName()), (Throwable)ex);
                    }
                }
            }
        }
        ServiceUtil.getServiceContext().getEQScreenActionTool().setAllEqLoaded(true);
        ServiceUtil.getServiceContext().getEQScreenActionTool().start();
    }

    private static void loadEquipment(String hostNo, Map<String, Equipment> existEquipmentMap, Equipment e, EquipmentManager equipmentManager) {
        try {
            if (e != null) {
                Equipment exist = equipmentManager.getByEquipmentNo(e.getEquipmentNo());
                if (exist == null) {
                    e.getDriver().startEquipment(e, (Map)e.getAttribute("config"));
                    LogUtil.getLog().info((Object)("\u52a0\u8f7d\u8bbe\u5907:" + e.getName() + " \u6210\u529f\uff01"));
                    if (existEquipmentMap.containsKey(e.getEquipmentNo())) {
                        existEquipmentMap.remove(e.getEquipmentNo());
                    }
                } else {
                    HashMap<String, String> config;
                    Object l;
                    String ehostNo = (String)e.getAttribute("EQ_OWNER_HOST_NO");
                    if (!hostNo.equals(ehostNo)) {
                        e.setAttribute("EQ_OWNER_HOST_NO", hostNo);
                    }
                    if (existEquipmentMap.containsKey(e.getEquipmentNo())) {
                        existEquipmentMap.remove(e.getEquipmentNo());
                    }
                    if (e.getChannelNos() != null) {
                        exist.setChannelNos(e.getChannelNos());
                    }
                    if ((l = e.getAttribute("localManageEquipment")) != null) {
                        exist.setAttribute("localManageEquipment", l);
                    }
                    if (e.getUse() != exist.getUse()) {
                        exist.setUse(e.getUse());
                    }
                    if ((config = (HashMap<String, String>)e.getAttribute("config")) == null) {
                        config = new HashMap<String, String>();
                    }
                    exist.setEquipmentConfig(e.getDriver().createEquipmentConfig(config));
                    exist.setAttribute("config", config);
                }
            }
        }
        catch (Exception ex) {
            LogUtil.getLog().error((Object)"\u52a0\u8f7d\u8bbe\u5907\u5f02\u5e38!", (Throwable)ex);
        }
    }
}

