/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.action.AlwaysOpenAction;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.DisplayVoiceService;
import com.wovoe.carpark.service.remote.CommonRemoteService;
import com.wovoe.framework.JobTask;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FirefightingJob
extends JobTask {
    private volatile boolean firefighting;
    private volatile long firefightingMills;
    private volatile String firefightingEqNo;
    private volatile String firefightingEqName;
    private volatile long lastTipMills;
    private volatile long lastDisplayMills;
    private volatile long lastNotityHostMills;

    protected boolean isFirefightingEnable() {
        return ServiceUtil.getServiceContext().getAttribute("enableFirefighting") != null;
    }

    public void run() {
        if (!this.isFirefightingEnable()) {
            return;
        }
        if (!this.firefighting) {
            return;
        }
        long x = ServiceUtil.getServiceContext().currentTimeMillis();
        if (x - this.firefightingMills < 8000L) {
            return;
        }
        super.run();
    }

    protected void doRun() throws Exception {
        this.checkFirefighting();
    }

    public boolean isFireFighting() {
        return this.firefighting;
    }

    public String getFirefightingEqNo() {
        return this.firefightingEqNo;
    }

    public String getFirefightingEqName() {
        return this.firefightingEqName;
    }

    public synchronized void checkFirefighting() {
        if (!this.firefighting) {
            return;
        }
        long x = ServiceUtil.getServiceContext().currentTimeMillis();
        if (x - this.firefightingMills < 8000L) {
            return;
        }
        this.firefighting = false;
        this.firefightingMills = 0L;
        this.lastTipMills = 0L;
        this.lastDisplayMills = 0L;
        this.lastNotityHostMills = 0L;
        Enumeration<PassChannel> ens = ServiceUtil.getServiceContext().getPassChannelManager().getChannels();
        if (ens != null) {
            DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
            while (ens.hasMoreElements()) {
                PassChannel ch = ens.nextElement();
                List<Equipment> list = ch.getEquipmentList(9);
                if (list != null && !list.isEmpty()) {
                    for (Equipment eq : list) {
                        AlwaysOpenAction action;
                        if (!(eq.getEquipmentAction() instanceof AlwaysOpenAction) || !(action = (AlwaysOpenAction)eq.getEquipmentAction()).isAlwaysOpen()) continue;
                        action.setAlwaysOpen(false);
                    }
                }
                try {
                    displayVoiceService.displayMsg(ch, "\u706b\u8b66\u72b6\u6001\u5df2\u89e3\u9664", "\u8bf7\u6ce8\u610f", true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ServiceLog.getLog().info((Object)"\u706b\u8b66\u72b6\u6001\u5df2\u89e3\u9664! \u9053\u95f8\u5e38\u5f00\u5df2\u53d6\u6d88\u3002");
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent((Object)this, "\u6ce8\u610f\uff1a\u706b\u8b66\u72b6\u6001\u5df2\u89e3\u9664! \u9053\u95f8\u5e38\u5f00\u5df2\u53d6\u6d88\u3002", 2, 10000));
    }

    public synchronized void firefighting(String eqNo, String eqName, boolean local) {
        Enumeration<PassChannel> ens;
        boolean insertLog;
        long mills;
        if (!this.isFirefightingEnable()) {
            return;
        }
        this.firefightingMills = mills = ServiceUtil.getServiceContext().currentTimeMillis();
        this.firefightingEqNo = eqNo;
        this.firefightingEqName = eqName;
        boolean bl = insertLog = !this.firefighting;
        if (!this.firefighting) {
            this.firefighting = true;
            ServiceLog.getLog().info((Object)("\u6536\u5230\u8bbe\u5907\uff1a" + eqNo + ": " + eqName + " \u706b\u8b66\u4fe1\u53f7\uff01\u672c\u673a\u9053\u95f8\u5c06\u5168\u90e8\u8fdb\u884c\u5e38\u5f00\u72b6\u6001! "));
        }
        if ((ens = ServiceUtil.getServiceContext().getPassChannelManager().getChannels()) != null) {
            DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
            long x = mills - this.lastDisplayMills;
            if (x > 10000L) {
                this.lastDisplayMills = mills;
            }
            while (ens.hasMoreElements()) {
                PassChannel ch = ens.nextElement();
                List<Equipment> list = ch.getEquipmentList(9);
                if (list != null && !list.isEmpty()) {
                    for (Equipment eq : list) {
                        AlwaysOpenAction action;
                        if (!(eq.getEquipmentAction() instanceof AlwaysOpenAction) || (action = (AlwaysOpenAction)eq.getEquipmentAction()).isAlwaysOpen()) continue;
                        action.setAlwaysOpen(true);
                    }
                }
                try {
                    if (x <= 10000L) continue;
                    displayVoiceService.displayMsg(ch, "\u706b\u8b66\u72b6\u6001\u751f\u6548\u4e2d", "\u8bf7\u6ce8\u610f", true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1 && local && mills - this.lastNotityHostMills >= 3000L) {
            this.lastNotityHostMills = mills;
            Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            String localHostNo = ServiceUtil.getServiceContext().getLocalHostNo();
            if (hostMap != null && !hostMap.isEmpty()) {
                final HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("eqNo", eqNo);
                paramMap.put("eqName", eqName);
                paramMap.put("eqHostNo", localHostNo);
                final HashMap contextMap = new HashMap();
                for (CarparkHost host : hostMap.values()) {
                    if (host.getHost_no().equals(localHostNo)) continue;
                    final String remoteHostNo = host.getHost_no();
                    if (!ServiceUtil.getServiceContext().isConected(remoteHostNo)) continue;
                    ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(remoteHostNo, true);
                                CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
                                Map<String, Object> resultMap = rpcService.firefighting(paramMap, contextMap);
                                if (!"0".equals(resultMap.get("responseCode"))) {
                                    ServiceLog.getLog().error((Object)("\u5411\u8fdc\u7a0b\u4e3b\u673a: " + remoteHostNo + "\u63a8\u9001\u706b\u8b66\u4fe1\u53f7\u5931\u8d25\uff01" + resultMap));
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().error((Object)("\u5411\u8fdc\u7a0b\u4e3b\u673a: " + remoteHostNo + "\u63a8\u9001\u706b\u8b66\u4fe1\u53f7\u5931\u8d25\uff01" + ex));
                            }
                        }
                    });
                }
            }
        }
        if (mills - this.lastTipMills >= 15000L) {
            this.lastTipMills = mills;
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent((Object)this, "\u8bf7\u6ce8\u610f\uff01\u706b\u8b66\u72b6\u6001\u751f\u6548\u4e2d\uff0c\u9053\u95f8\u5df2\u5168\u90e8\u5e38\u5f00!", 3, 10000));
        }
    }
}

