/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.HardWareInfo;
import com.wovoe.framework.HardWareUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class HardwareIdentifierReader {
    public static Hardware read() {
        File hx;
        String javaExe;
        block6: {
            block5: {
                boolean os32 = System.getProperty("sun.arch.data.model", "32").equals("32");
                javaExe = String.valueOf(new File(new File(new File(PathFinder.findHomeDir(), "bin"), "jre" + (os32 ? "32" : "64")), "bin").getAbsolutePath()) + File.separator;
                File javaFile = new File(javaExe);
                if (javaFile.exists() && javaFile.isDirectory()) break block5;
                ServiceLog.getLog().error((Object)("Directory not exist! path:" + javaFile));
                return null;
            }
            javaExe = ServiceUtil.getBlankExePath(javaExe);
            hx = new File(HardwareIdentifierReader.findNaiveJarDir(), "HardwareInfo.jar");
            if (hx.exists() && hx.isFile()) break block6;
            ServiceLog.getLog().error((Object)("HardwareInfo.jar not found! path:" + hx.getAbsolutePath()));
            return null;
        }
        try {
            String s;
            String jarPath = ServiceUtil.getBlankExePath(hx.getAbsolutePath());
            StringBuilder _command = new StringBuilder(128).append(javaExe);
            _command.append("java");
            _command.append(" -jar ").append(jarPath);
            _command.append(' ').append("hardwareIdentifier");
            String command = _command.toString();
            final Process process = ServiceUtil.exec(command);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            process.waitFor(8L, TimeUnit.SECONDS);
                        }
                        catch (Exception exception) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (process.isAlive()) {
                                process.destroy();
                            }
                        }
                    }
                    finally {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (process.isAlive()) {
                            process.destroy();
                        }
                    }
                }
            }).start();
            InputStream input = process.getInputStream();
            String result = null;
            BufferedReader r = new BufferedReader(new InputStreamReader(input));
            String kx = "hardwareIdentifier=";
            while ((s = r.readLine()) != null) {
                if (!s.startsWith(kx)) continue;
                result = s.substring(kx.length());
                result = new String(BytesTool.unCompress((String)result), "UTF-8");
            }
            input.close();
            return HardwareIdentifierReader.readFromXml(result);
        }
        catch (Throwable ex) {
            ServiceLog.getLog().error((Object)"Read hardware identifier error!", ex);
            return null;
        }
    }

    private static Hardware readFromXml(String xml) throws Exception {
        if (xml == null || xml.length() == 0) {
            return null;
        }
        Hardware hardware = null;
        String hardwareIdentifierStr = "hardwareIdentifier";
        String boardStr = "board";
        String cpuStr = "cpu";
        String diskStr = "disk";
        Field[] fields = Identifier.class.getFields();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            fieldMap.put(f.getName(), f);
            ++n2;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        NodeList hardwareIdentifierNodeList = document.getChildNodes();
        int hardwareIdentifierNodeListLength = hardwareIdentifierNodeList.getLength();
        Identifier identifier = null;
        int i1 = 0;
        while (i1 < hardwareIdentifierNodeListLength) {
            Node hardwareIdentifierNode = hardwareIdentifierNodeList.item(i1);
            if (hardwareIdentifierStr.equals(hardwareIdentifierNode.getNodeName())) {
                hardware = new Hardware();
                NodeList sub1NodeList = hardwareIdentifierNode.getChildNodes();
                int sub1NodeListLength = sub1NodeList.getLength();
                int i2 = 0;
                while (i2 < sub1NodeListLength) {
                    Node sub1Node = sub1NodeList.item(i2);
                    String sub1NodeName = sub1Node.getNodeName();
                    identifier = null;
                    if (boardStr.equals(sub1NodeName)) {
                        hardware.board = identifier = new Identifier();
                    } else if (cpuStr.equals(sub1NodeName)) {
                        hardware.cpu = identifier = new Identifier();
                    } else if (diskStr.equals(sub1NodeName)) {
                        identifier = new Identifier();
                        if (hardware.disk == null) {
                            hardware.disk = new ArrayList<Identifier>();
                        }
                        hardware.disk.add(identifier);
                    }
                    if (identifier != null) {
                        NodeList sub2NodeList = sub1Node.getChildNodes();
                        int sub2NodeListLength = sub2NodeList.getLength();
                        int i3 = 0;
                        while (i3 < sub2NodeListLength) {
                            Node sub2Node = sub2NodeList.item(i3);
                            String sub2NodeName = sub2Node.getNodeName();
                            Field field = (Field)fieldMap.get(sub2NodeName);
                            if (field != null) {
                                String sub2NodeValue = sub2Node.getTextContent();
                                sub2NodeValue = sub2NodeValue == null ? "" : sub2NodeValue.trim();
                                field.set(identifier, sub2NodeValue);
                            }
                            ++i3;
                        }
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        return hardware;
    }

    private static File findNaiveJarDir() {
        return new File(new File(PathFinder.findHomeDir(), "native"), "hardware");
    }

    public static HardWareInfo toHardWareInfo(Hardware hardware) {
        if (hardware == null) {
            return null;
        }
        String motherboardSn = hardware.board == null ? null : hardware.board.serial;
        String cpuSn = hardware.cpu == null ? null : hardware.cpu.serial;
        String hardDiskSn = null;
        if (hardware.disk != null && !hardware.disk.isEmpty()) {
            StringBuilder sbr = new StringBuilder();
            for (Identifier i : hardware.disk) {
                if (i == null || i.serial == null || i.serial.length() <= 0) continue;
                if (sbr.length() > 0) {
                    sbr.append(',');
                }
                sbr.append(i.serial);
            }
            hardDiskSn = sbr.toString();
        }
        String mac = HardWareUtils.getMac();
        return new HardWareInfo(motherboardSn == null ? "" : motherboardSn, cpuSn == null ? "" : cpuSn, hardDiskSn == null ? "" : hardDiskSn, mac);
    }

    public static void setHardWareUtils_HardWareInfo(HardWareInfo info) {
        try {
            Field field = HardWareUtils.class.getDeclaredField("info");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(HardWareUtils.class, info);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class Hardware {
        public Identifier board;
        public Identifier cpu;
        public List<Identifier> disk;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Hardware [board=");
            builder.append(this.board);
            builder.append(", cpu=");
            builder.append(this.cpu);
            builder.append(", disk=");
            builder.append(this.disk);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class Identifier {
        public String name;
        public String model;
        public String serial;
        public String manufacturer;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Identifier [name=");
            builder.append(this.name);
            builder.append(", model=");
            builder.append(this.model);
            builder.append(", serial=");
            builder.append(this.serial);
            builder.append(", manufacturer=");
            builder.append(this.manufacturer);
            builder.append("]");
            return builder.toString();
        }
    }
}

