/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.dto.CarparkAttribute;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.web.WebUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class HideSensitiveInfo {
    private static final char MASK = '*';
    private HideSensitiveFiledService hideSensitiveFiledService;
    private ApplicationService applicationService;
    public static final String WEB_IgnoreHideSensitive_Permission = "/manage/ignoreHideSensitivePermission.action";
    public static final String GUI_IgnoreHideSensitive_Permission = "GUI_IgnoreHideSensitive_Permission";
    private Map<String, String> basicFileds = new LinkedHashMap<String, String>();

    public HideSensitiveFiledService getHideSensitiveFiledService() {
        return this.hideSensitiveFiledService;
    }

    public void setHideSensitiveFiledService(HideSensitiveFiledService hideSensitiveFiledService) {
        this.hideSensitiveFiledService = hideSensitiveFiledService;
    }

    public void addDefaultHideSensitivePermission() {
        ServiceUtil.getServiceContext().getPermissionManager().addPermission(GUI_IgnoreHideSensitive_Permission, "\u663e\u793a\u654f\u611f\u5b57\u6bb5\u6743\u9650", 0);
        ServiceUtil.getServiceContext().getPermissionManager().addPermission(WEB_IgnoreHideSensitive_Permission, "\u663e\u793a\u654f\u611f\u5b57\u6bb5\u6743\u9650", 1);
    }

    public HideSensitiveInfo() {
        this.basicFileds.put("car_owner_name", "\u8f66\u4e3b\u59d3\u540d");
        this.basicFileds.put("address", "\u8f66\u4e3b\u4f4f\u5740");
        this.basicFileds.put("phone_number", "\u624b\u673a\u53f7\u7801");
        this.basicFileds.put("id_number", "\u8eab\u4efd\u8bc1\u53f7");
        this.basicFileds.put("email", "\u8f66\u4e3b\u90ae\u7bb1");
        this.basicFileds.put("driver_number", "\u9a7e\u9a76\u8bc1\u53f7");
    }

    public Map<String, String> getSurportUserFileds() {
        LinkedHashMap<String, String> sensitiveFiedsMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> e : this.basicFileds.entrySet()) {
            sensitiveFiedsMap.put(e.getKey(), e.getValue());
        }
        Map<String, CarparkAttribute> carOwnerAttrMap = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(8);
        if (carOwnerAttrMap != null && !carOwnerAttrMap.isEmpty()) {
            for (CarparkAttribute t : carOwnerAttrMap.values()) {
                if (t.getAttribute_value() == null || t.getAttribute_value().length() <= 0) continue;
                sensitiveFiedsMap.put(t.getAttribute_key(), t.getAttribute_value());
            }
        }
        return sensitiveFiedsMap;
    }

    public boolean isSupportUserFiled(String field) {
        CarparkAttribute t;
        if (field == null || field.length() == 0) {
            return false;
        }
        if (this.basicFileds.containsKey(field)) {
            return true;
        }
        Map<String, CarparkAttribute> carOwnerAttrMap = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(8);
        return carOwnerAttrMap != null && (t = carOwnerAttrMap.get(field)) != null && t.getAttribute_value() != null && t.getAttribute_value().length() > 0;
    }

    public boolean isConfigHideSensitive(String field) {
        CarparkAttribute av;
        Map<String, CarparkAttribute> aMap;
        return this.isSupportUserFiled(field) && (aMap = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(11)) != null && (av = aMap.get(field)) != null && Constants.YES_STR.equals(av.getAttribute_value());
    }

    public String getGuiSensitiveValue(String field, String value) {
        UserSession usersession;
        if (value == null || value.length() == 0) {
            return value;
        }
        if (this.applicationService == null) {
            this.applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        }
        return this.getSensitiveValue(field, value, false, (usersession = this.applicationService.getUserSession()) == null ? null : usersession.getUser(), usersession == null ? null : usersession.getPermissions());
    }

    public String getWebSensitiveValue(String field, String value, HttpServletRequest request) {
        if (value == null || value.length() == 0) {
            return value;
        }
        CarparkUser user = WebUtil.getLoginManageUser(request);
        Set<String> permissions = WebUtil.getLoginUserPermissions(request);
        return this.getSensitiveValue(field, value, true, user, permissions);
    }

    public boolean isNeedSensitiveValue(String field, boolean manageWeb, CarparkUser user, Set<String> permissions) {
        HideSensitiveFiledService hideSensitive = this.hideSensitiveFiledService;
        if (hideSensitive != null && hideSensitive.isEnableHideSensitive() && this.isConfigHideSensitive(field)) {
            return !hideSensitive.hasIgnoreHideSensitivePermission(manageWeb, user, permissions);
        }
        return false;
    }

    public String getSensitiveValue(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        int length = value.length();
        StringBuilder sbr = new StringBuilder(value.length());
        int i = 0;
        while (i < length) {
            sbr.append('*');
            ++i;
        }
        return sbr.toString();
    }

    public String getSensitiveValue(String field, String value, boolean manageWeb, CarparkUser user, Set<String> permissions) {
        if (value != null && value.length() > 0 && this.isNeedSensitiveValue(field, manageWeb, user, permissions)) {
            return this.getSensitiveValue(value);
        }
        return value;
    }

    public static class DefaultHideSensitiveFiledService
    implements HideSensitiveFiledService {
        @Override
        public boolean isEnableHideSensitive() {
            return true;
        }

        @Override
        public boolean hasIgnoreHideSensitivePermission(boolean manageWeb, CarparkUser user, Set<String> permissions) {
            if (user != null) {
                if ("1".equals(user.getRole_no())) {
                    return true;
                }
                if (permissions != null && (manageWeb ? permissions.contains(HideSensitiveInfo.WEB_IgnoreHideSensitive_Permission) : permissions.contains(HideSensitiveInfo.GUI_IgnoreHideSensitive_Permission))) {
                    return true;
                }
            }
            return false;
        }
    }

    public static interface HideSensitiveFiledService {
        public boolean isEnableHideSensitive();

        public boolean hasIgnoreHideSensitivePermission(boolean var1, CarparkUser var2, Set<String> var3);
    }
}

