/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import java.util.Locale;

public class OSUtil {
    private static boolean windows;
    private static boolean linux;
    private static boolean unix;
    private static boolean freebsd;
    private static boolean mac;
    private static boolean android;
    private static boolean os32;

    static {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        windows = OS_NAME.indexOf("win") != -1;
        linux = OS_NAME.indexOf("nux") != -1;
        unix = OS_NAME.indexOf("nix") != -1;
        freebsd = OS_NAME.indexOf("freebsd") != -1;
        mac = OS_NAME.indexOf("mac") != -1;
        os32 = System.getProperty("sun.arch.data.model", "32").equals("32");
        try {
            Class.forName("android.app.Application", false, ClassLoader.getSystemClassLoader());
            android = true;
        }
        catch (Exception e) {
            android = false;
        }
    }

    public static boolean isWindows() {
        return windows;
    }

    public static boolean isNix() {
        return linux || unix || freebsd;
    }

    public static boolean isLinux() {
        return linux;
    }

    public static boolean isUnix() {
        return unix;
    }

    public static boolean isFreeBSD() {
        return freebsd;
    }

    public static boolean isMAC() {
        return mac;
    }

    public static boolean isAndroid() {
        return android;
    }

    public static boolean isOS32() {
        return os32;
    }
}

