/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import java.util.ArrayList;
import java.util.List;

public class OffsetLength {
    private int offset;
    private int length;

    public OffsetLength() {
    }

    public OffsetLength(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public static List<OffsetLength> getPaginationList(int totalSize, int pageSize) {
        if (pageSize <= 0 || totalSize <= 0) {
            return new ArrayList<OffsetLength>(0);
        }
        int totalPages = totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
        ArrayList<OffsetLength> list = new ArrayList<OffsetLength>(totalPages);
        int offset = 0;
        int i = 0;
        while (i < totalPages) {
            offset = pageSize * i;
            int endIndex = offset + pageSize;
            int limitCount = endIndex > totalSize ? totalSize - offset : pageSize;
            list.add(new OffsetLength(offset, limitCount));
            ++i;
        }
        return list;
    }
}

