/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OrderNo {
    private final Date day;
    private final int orderType;
    private final int dbid;
    private final long sequence;
    private final String orderNo;

    private OrderNo(Date day, int orderType, int dbid, long sequence, String orderNo) {
        this.day = day;
        this.orderType = orderType;
        this.dbid = dbid;
        this.sequence = sequence;
        this.orderNo = orderNo;
    }

    public Date getDay() {
        return this.day;
    }

    public int getOrderType() {
        return this.orderType;
    }

    public int getDbid() {
        return this.dbid;
    }

    public long getSequence() {
        return this.sequence;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public String toString() {
        return this.orderNo;
    }

    public static OrderNo parse(String orderNo) {
        try {
            Date date;
            int orderType = Integer.parseInt(orderNo.substring(0, 2));
            SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
            try {
                date = df.parse(orderNo.substring(2, 8));
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            int dbid = Integer.parseInt(orderNo.substring(8, 13));
            long sequence = Long.parseLong(orderNo.substring(13));
            return new OrderNo(date, orderType, dbid, sequence, orderNo);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

