/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.DBConfigCache;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkSpaceTypeDefine;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.driver.EQScreenAction;
import com.wovoe.carpark.event.app.ParkingFullReStartSessionEvent;
import com.wovoe.carpark.event.app.ParkingSpaceRefreshEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassParkingFullFilter;
import com.wovoe.carpark.service.DisplayVoiceService;
import com.wovoe.carpark.vo.ParingSpaceVo;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ParkingSpace
extends JobTask {
    private static ParkingSpace instance = new ParkingSpace();
    private Map<String, Integer> spaceCache = new HashMap<String, Integer>();

    public static ParkingSpace getInstance() {
        return instance;
    }

    public void refresh() {
        this.run();
    }

    protected void doRefresh() {
        HashMap<String, Integer> spaceCache0 = new HashMap<String, Integer>();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        DBConfigCache dbConfigCache = ServiceUtil.getServiceContext().getDBConfigCache();
        SearchParam searchParam = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
        searchParam.setQueryFields(new String[]{"count(id) AS count", "area_no", "passport_type_no", "enter_car_type_no"});
        searchParam.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
        searchParam.addEQ("project_id", (Object)ServiceUtil.getServiceContext().getProjectId());
        searchParam.setWhereString(" AND enter_time IS NOT NULL AND exit_time IS NULL");
        searchParam.setGroup_by("area_no, passport_type_no, enter_car_type_no");
        List list = commonDaoService.selectList(searchParam, null);
        String value = dbConfigCache.getCarparkStrategyValue("TEMP_SPACE_TAKE_DAYS");
        if (value == null || value.length() == 0) {
            value = "0";
        }
        int takeTime = 0;
        try {
            takeTime = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String tempPassportTypeNo = null;
        for (Map.Entry<String, CarparkPassportType> e : dbConfigCache.getPassportTypeMap().entrySet()) {
            if (e.getValue().getPassport_type_number() != 0) continue;
            tempPassportTypeNo = e.getKey();
            break;
        }
        List list0 = null;
        if (takeTime > 0 && tempPassportTypeNo != null && list != null && !list.isEmpty()) {
            Calendar cl = Calendar.getInstance();
            cl.add(5, 0 - takeTime);
            searchParam = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
            searchParam.setQueryFields(new String[]{"count(id) AS count", "area_no", "enter_car_type_no"});
            searchParam.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
            searchParam.addEQ("project_id", (Object)ServiceUtil.getServiceContext().getProjectId());
            searchParam.addEQ("passport_type_no", (Object)tempPassportTypeNo);
            searchParam.addLT("enter_time", (Object)new Timestamp(cl.getTimeInMillis()));
            searchParam.setWhereString(" AND exit_time IS NULL");
            searchParam.setGroup_by("area_no, enter_car_type_no");
            list0 = commonDaoService.selectList(searchParam, null);
        }
        if (list != null && !list.isEmpty()) {
            for (Map vmap : list) {
                Integer a;
                if (list0 != null && !list0.isEmpty() && tempPassportTypeNo != null && tempPassportTypeNo.equals(vmap.get("passport_type_no"))) {
                    Long count;
                    Long count0 = null;
                    for (Map xmap : list0) {
                        if (xmap.get("area_no") == null || !xmap.get("area_no").equals(vmap.get("area_no")) || xmap.get("enter_car_type_no") == null || !xmap.get("enter_car_type_no").equals(vmap.get("enter_car_type_no"))) continue;
                        count0 = (Long)xmap.get("count");
                        break;
                    }
                    if (count0 != null && (count = (Long)vmap.get("count")) != null) {
                        long x = count - count0;
                        if (x < 0L) {
                            x = 0L;
                        }
                        vmap.put("count", x);
                    }
                }
                String keyArea = "a_" + vmap.get("area_no");
                String keyPassportType = String.valueOf(keyArea) + "-b_" + vmap.get("passport_type_no");
                String keyCarType = String.valueOf(keyArea) + "-c_" + vmap.get("enter_car_type_no");
                String keyPassportTypeCarType = String.valueOf(keyPassportType) + "-c_" + vmap.get("enter_car_type_no");
                Long count = (Long)vmap.get("count");
                if (count == null) continue;
                if (count < 0L) {
                    count = 0L;
                }
                a = (a = (Integer)spaceCache0.get(keyArea)) == null ? Integer.valueOf(count.intValue()) : Integer.valueOf(a + count.intValue());
                spaceCache0.put(keyArea, a);
                a = (Integer)spaceCache0.get(keyPassportType);
                a = a == null ? Integer.valueOf(count.intValue()) : Integer.valueOf(a + count.intValue());
                spaceCache0.put(keyPassportType, a);
                a = (Integer)spaceCache0.get(keyCarType);
                a = a == null ? Integer.valueOf(count.intValue()) : Integer.valueOf(a + count.intValue());
                spaceCache0.put(keyCarType, a);
                spaceCache0.put(keyPassportTypeCarType, count.intValue());
            }
        }
        this.spaceCache = spaceCache0;
    }

    public Map<String, Integer> getLocalSpaceTookCache() {
        return this.spaceCache;
    }

    public Map<String, Integer> getSpaceTookCache() {
        return this.getLocalSpaceTookCache();
    }

    public int getToatalSpace(String areaNo) {
        CarparkArea area;
        Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
        if (areaMap != null && (area = areaMap.get(areaNo)) != null) {
            List<CarparkArea> cls = area.getChildren();
            if (cls == null || cls.isEmpty()) {
                return area.getSpace_quantities();
            }
            int[] count = new int[1];
            this.addAreaSpaceCount(area, count);
            return count[0];
        }
        return 0;
    }

    private void addAreaSpaceCount(CarparkArea area, int[] count) {
        List<CarparkArea> cls;
        if (area == null) {
            return;
        }
        if (area.getSpace_quantities() != null && area.getSpace_quantities() > 0) {
            count[0] = count[0] + area.getSpace_quantities();
        }
        if ((cls = area.getChildren()) != null && !cls.isEmpty()) {
            for (CarparkArea c : cls) {
                this.addAreaSpaceCount(c, count);
            }
        }
    }

    public int getTookSpace(String areaNo) {
        Integer a = this.spaceCache.get("a_" + areaNo);
        int c = 0;
        if (a != null && (c = a.intValue()) < 0) {
            c = 0;
        }
        return c;
    }

    private void addSubAreaNo(List<CarparkArea> children, Collection<String> areaNoList) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (CarparkArea area : children) {
            areaNoList.add(area.getArea_no());
            this.addSubAreaNo(area.getChildren(), areaNoList);
        }
    }

    public KeyValueEntry<String, Integer> getSpaceTypeAndCount(String areaNo, String passportTypeNo, String carTypeNo, boolean needAddSubArea) {
        CarparkArea area;
        Map<String, CarparkArea> areaMap;
        if (areaNo == null || areaNo.length() == 0) {
            return null;
        }
        if (!(passportTypeNo != null && passportTypeNo.length() != 0 || carTypeNo != null && carTypeNo.length() != 0)) {
            return null;
        }
        List<CarparkSpaceTypeDefine> defineList = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceTypeDefineList();
        if (defineList == null || defineList.isEmpty()) {
            return null;
        }
        if (passportTypeNo == null) {
            passportTypeNo = "";
        }
        if (carTypeNo == null) {
            carTypeNo = "";
        }
        LinkedList<String> areaList = new LinkedList<String>();
        areaList.add(areaNo);
        if (needAddSubArea && (areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap()) != null && (area = areaMap.get(areaNo)) != null) {
            this.addSubAreaNo(area.getChildren(), areaList);
        }
        KeyValueEntry entry1 = new KeyValueEntry();
        KeyValueEntry entry2 = new KeyValueEntry();
        KeyValueEntry entry3 = new KeyValueEntry();
        for (CarparkSpaceTypeDefine d : defineList) {
            if ((passportTypeNo.length() <= 0 || !passportTypeNo.equals(d.getPassport_type_no())) && (carTypeNo.length() <= 0 || !carTypeNo.equals(d.getCar_type_no()))) continue;
            int count = 0;
            for (String aNo : areaList) {
                int count0 = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceQuantity(d.getSpace_type_no(), aNo);
                if (count0 <= 0) continue;
                count += count0;
            }
            if (count <= 0) continue;
            if (passportTypeNo.length() > 0 && passportTypeNo.equals(d.getPassport_type_no()) && carTypeNo.length() > 0 && carTypeNo.equals(d.getCar_type_no())) {
                if (entry1.getKey() == null) {
                    entry1.setKey((Object)d);
                    entry1.setValue((Object)count);
                } else if ((Integer)entry1.getValue() > count) {
                    entry1.setKey((Object)d);
                    entry1.setValue((Object)count);
                }
            }
            if (passportTypeNo.length() > 0 && passportTypeNo.equals(d.getPassport_type_no()) && (d.getCar_type_no() == null || d.getCar_type_no().length() == 0)) {
                if (entry2.getKey() == null) {
                    entry2.setKey((Object)d);
                    entry2.setValue((Object)count);
                } else if ((Integer)entry2.getValue() > count) {
                    entry2.setKey((Object)d);
                    entry2.setValue((Object)count);
                }
            }
            if (carTypeNo.length() <= 0 || !carTypeNo.equals(d.getCar_type_no()) || d.getPassport_type_no() != null && d.getPassport_type_no().length() != 0) continue;
            if (entry3.getKey() == null) {
                entry3.setKey((Object)d);
                entry3.setValue((Object)count);
                continue;
            }
            if ((Integer)entry3.getValue() <= count) continue;
            entry3.setKey((Object)d);
            entry3.setValue((Object)count);
        }
        KeyValueEntry entry = null;
        if (entry1.getKey() != null) {
            entry = entry1;
        }
        if (entry2.getKey() != null) {
            if (entry == null) {
                entry = entry2;
            } else if ((Integer)entry.getValue() > (Integer)entry2.getValue()) {
                entry = entry2;
            }
        }
        if (entry3.getKey() != null) {
            if (entry == null) {
                entry = entry3;
            } else if ((Integer)entry.getValue() > (Integer)entry3.getValue()) {
                entry = entry3;
            }
        }
        if (entry != null && entry.getKey() != null && entry.getValue() != null) {
            return new KeyValueEntry((Object)((CarparkSpaceTypeDefine)entry.getKey()).getSpace_type_no(), (Object)((Integer)entry.getValue()));
        }
        return null;
    }

    public int getTookSpaceCount(String key) {
        if (key == null || !key.startsWith("t-")) {
            return 0;
        }
        String v = key.substring(2);
        String[] vs = v.split("-");
        if (vs.length == 2) {
            if (vs[0].startsWith("a_")) {
                String areaNo = vs[0].substring(2);
                if (vs[1].startsWith("d_")) {
                    Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
                    CarparkArea area = areaMap.get(areaNo);
                    int count1 = 0;
                    int count2 = 0;
                    if (area != null) {
                        String spaceTypeNo = vs[1].substring(2);
                        List<CarparkSpaceTypeDefine> dfilei = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceTypeDefineList();
                        if (dfilei != null && !dfilei.isEmpty()) {
                            for (CarparkSpaceTypeDefine d : dfilei) {
                                if (!spaceTypeNo.equals(d.getSpace_type_no())) continue;
                                if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && d.getCar_type_no() != null && d.getCar_type_no().length() > 0) {
                                    count1 += this.getTookSpace(area.getArea_no(), d.getPassport_type_no(), d.getCar_type_no());
                                } else if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && (d.getCar_type_no() == null || d.getCar_type_no().length() == 0)) {
                                    count1 += this.getTookSpaceByPassportType(area.getArea_no(), d.getPassport_type_no());
                                } else if ((d.getPassport_type_no() == null || d.getPassport_type_no().length() == 0) && d.getCar_type_no() != null && d.getCar_type_no().length() > 0) {
                                    count1 += this.getTookSpaceByCarType(area.getArea_no(), d.getCar_type_no());
                                }
                                if (area.getChildren() == null) continue;
                                for (CarparkArea s : area.getChildren()) {
                                    if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && d.getCar_type_no() != null && d.getCar_type_no().length() > 0) {
                                        count2 += this.getTookSpace(s.getArea_no(), d.getPassport_type_no(), d.getCar_type_no());
                                        continue;
                                    }
                                    if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && (d.getCar_type_no() == null || d.getCar_type_no().length() == 0)) {
                                        count2 += this.getTookSpaceByPassportType(s.getArea_no(), d.getPassport_type_no());
                                        continue;
                                    }
                                    if (d.getPassport_type_no() != null && d.getPassport_type_no().length() != 0 || d.getCar_type_no() == null || d.getCar_type_no().length() <= 0) continue;
                                    count2 += this.getTookSpaceByCarType(s.getArea_no(), d.getCar_type_no());
                                }
                            }
                        }
                    }
                    if (count1 > count2) {
                        return count1 - count2;
                    }
                    return 0;
                }
                if (vs[1].startsWith("b_")) {
                    if ("0".equals(areaNo)) {
                        String passportTypeNo = vs[1].substring(2);
                        int count = 0;
                        Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
                        if (areaMap != null) {
                            for (CarparkArea area : areaMap.values()) {
                                if (area.getArea_level() != 1) continue;
                                count += this.getTookSpaceByPassportType(area.getArea_no(), passportTypeNo);
                            }
                        }
                        return count;
                    }
                    String passportTypeNo = vs[1].substring(2);
                    Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
                    CarparkArea area = areaMap.get(areaNo);
                    int count1 = 0;
                    int count2 = 0;
                    if (area != null) {
                        count1 = this.getTookSpaceByPassportType(area.getArea_no(), passportTypeNo);
                        if (area.getChildren() != null) {
                            for (CarparkArea s : area.getChildren()) {
                                count2 += this.getTookSpaceByPassportType(s.getArea_no(), passportTypeNo);
                            }
                        }
                    }
                    if (count1 > count2) {
                        return count1 - count2;
                    }
                    return 0;
                }
                if (vs[1].startsWith("c_")) {
                    String carTypeNo = vs[1].substring(2);
                    Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
                    if ("0".equals(areaNo)) {
                        int count = 0;
                        if (areaMap != null) {
                            for (CarparkArea area : areaMap.values()) {
                                if (area.getArea_level() != 1) continue;
                                count += this.getTookSpaceByCarType(area.getArea_no(), carTypeNo);
                            }
                        }
                        return count;
                    }
                    CarparkArea area = areaMap.get(areaNo);
                    int count1 = 0;
                    int count2 = 0;
                    if (area != null) {
                        count1 = this.getTookSpaceByCarType(area.getArea_no(), carTypeNo);
                        if (area.getChildren() != null) {
                            for (CarparkArea s : area.getChildren()) {
                                count2 += this.getTookSpaceByCarType(s.getArea_no(), carTypeNo);
                            }
                        }
                    }
                    if (count1 > count2) {
                        return count1 - count2;
                    }
                    return 0;
                }
            }
        } else if (vs.length == 1) {
            if (vs[0].startsWith("a_")) {
                String areaNo = vs[0].substring(2);
                if ("0".equals(areaNo)) {
                    Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
                    int tookCount = 0;
                    if (areaMap != null) {
                        for (CarparkArea area : areaMap.values()) {
                            if (area.getArea_level() != 1) continue;
                            tookCount += this.getTookSpace(area.getArea_no());
                        }
                    }
                    return tookCount;
                }
                return this.getTookSpace(areaNo);
            }
            if (vs[0].startsWith("as_")) {
                String areaNo = vs[0].substring(3);
                Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
                CarparkArea area = areaMap == null ? null : areaMap.get(areaNo);
                int tookCount = 0;
                if (area != null) {
                    tookCount = this.getTookSpace(areaNo);
                    if (area.getChildren() != null && !area.getChildren().isEmpty()) {
                        for (CarparkArea subArea : area.getChildren()) {
                            tookCount -= this.getTookSpace(subArea.getArea_no());
                        }
                    }
                    if (tookCount < 0) {
                        tookCount = 0;
                    }
                }
                return tookCount;
            }
        }
        return 0;
    }

    public int getSpaceTypeTotalSpaceCount(String areaNo, String spaceTypeNo) {
        if (areaNo == null || areaNo.length() == 0 || spaceTypeNo == null || spaceTypeNo.length() == 0) {
            return 0;
        }
        List<String> subAreaList = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(areaNo);
        int totalCount = 0;
        int k = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceQuantity(spaceTypeNo, areaNo);
        if (k > 0) {
            totalCount += k;
        }
        if (subAreaList != null && !subAreaList.isEmpty()) {
            for (String s : subAreaList) {
                k = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceQuantity(spaceTypeNo, s);
                if (k <= 0) continue;
                totalCount += k;
            }
        }
        return totalCount;
    }

    public int getRemainSpace(String areaNo) {
        String key1 = "r-a_" + areaNo;
        return this.getRemainSpaceInfo(key1).getRemain();
    }

    public int getRemainSpaceWithoutSub(String areaNo) {
        String key1 = "r-as_" + areaNo;
        return this.getRemainSpaceInfo(key1).getRemain();
    }

    public Integer getRemainSpace(String areaNo, String passportTypeNo, String carTypeNo) {
        KeyValueEntry<String, Integer> entry = this.getSpaceTypeAndCount(areaNo, passportTypeNo, carTypeNo, true);
        if (entry == null || entry.getKey() == null || entry.getValue() == null) {
            return null;
        }
        String key1 = "r-a_" + areaNo + "-" + "d_" + (String)entry.getKey();
        return this.getRemainSpaceInfo(key1).getRemain();
    }

    public ParingSpaceVo getRemainSpaceInfo(String key) {
        if (key == null || !key.startsWith("r-")) {
            return new ParingSpaceVo();
        }
        ParingSpaceVo vo = new ParingSpaceVo();
        String v = key.substring(2);
        String[] vs = v.split("-");
        if (vs.length == 1) {
            if (vs[0].startsWith("a_")) {
                if ("a_0".equals(vs[0])) {
                    Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
                    int totalCount = 0;
                    int remainCount = 0;
                    if (areaMap != null) {
                        for (CarparkArea area : areaMap.values()) {
                            if (area.getArea_level() != 1 || "0".equals(area.getArea_no())) continue;
                            String key1 = "r-a_" + area.getArea_no();
                            ParingSpaceVo vo1 = this.getRemainSpaceInfo(key1);
                            totalCount += vo1.getTotal();
                            remainCount += vo1.getRemain();
                        }
                    }
                    if (remainCount > totalCount) {
                        remainCount = totalCount;
                    }
                    vo.setRemain(remainCount);
                    vo.setTook(totalCount - remainCount);
                    vo.setTotal(totalCount);
                } else {
                    String areaNo = vs[0].substring(2);
                    int totalCount = 0;
                    int remainCount = 0;
                    String key1 = "r-as_" + areaNo;
                    ParingSpaceVo vo1 = this.getRemainSpaceInfo(key1);
                    totalCount += vo1.getTotal();
                    remainCount += vo1.getRemain();
                    List<String> subAreaList = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(areaNo);
                    if (subAreaList != null && !subAreaList.isEmpty()) {
                        for (String areaN : subAreaList) {
                            if (areaN.equals(areaNo)) continue;
                            key1 = "r-a_" + areaN;
                            vo1 = this.getRemainSpaceInfo(key1);
                            totalCount += vo1.getTotal();
                            remainCount += vo1.getRemain();
                        }
                    }
                    if (remainCount > totalCount) {
                        remainCount = totalCount;
                    }
                    vo.setRemain(remainCount);
                    vo.setTook(totalCount - remainCount);
                    vo.setTotal(totalCount);
                }
            } else if (vs[0].startsWith("as_")) {
                int h;
                int remainCount;
                String areaNo = vs[0].substring(3);
                Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
                CarparkArea area = areaMap == null ? null : areaMap.get(areaNo);
                int totalCount = 0;
                int tookCount = 0;
                if (area != null) {
                    if (area.getSpace_quantities() != null && area.getSpace_quantities() > 0) {
                        totalCount = area.getSpace_quantities();
                    }
                    if (totalCount > 0) {
                        tookCount = this.getTookSpace(areaNo);
                        if (area.getChildren() != null && !area.getChildren().isEmpty()) {
                            for (CarparkArea subArea : area.getChildren()) {
                                tookCount -= this.getTookSpace(subArea.getArea_no());
                            }
                        }
                        if (tookCount < 0) {
                            tookCount = 0;
                        }
                    }
                }
                if ((remainCount = totalCount - (tookCount += (h = ServiceUtil.getServiceContext().getDBConfigCache().getAdjustTakeSpaces(areaNo, "")))) < 0) {
                    remainCount = 0;
                }
                vo.setRemain(remainCount);
                vo.setTook(tookCount);
                vo.setTotal(totalCount);
            }
        } else if (vs.length == 2 && vs[0].startsWith("a_")) {
            if (vs[1].startsWith("d_")) {
                List<CarparkSpaceTypeDefine> dfilei;
                String areaNo = vs[0].substring(2);
                String spaceTypeNo = vs[1].substring(2);
                List<String> subAreaList = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(areaNo);
                int totalCount = 0;
                int remainCount = 0;
                int tookCount = 0;
                int k = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceQuantity(spaceTypeNo, areaNo);
                if (k > 0) {
                    totalCount += k;
                }
                if (subAreaList != null && !subAreaList.isEmpty()) {
                    for (String s : subAreaList) {
                        k = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceQuantity(spaceTypeNo, s);
                        if (k <= 0) continue;
                        totalCount += k;
                    }
                }
                if ((dfilei = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceTypeDefineList()) != null && !dfilei.isEmpty()) {
                    for (CarparkSpaceTypeDefine d : dfilei) {
                        if (!spaceTypeNo.equals(d.getSpace_type_no())) continue;
                        if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && d.getCar_type_no() != null && d.getCar_type_no().length() > 0) {
                            tookCount += this.getTookSpace(areaNo, d.getPassport_type_no(), d.getCar_type_no());
                            continue;
                        }
                        if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && (d.getCar_type_no() == null || d.getCar_type_no().length() == 0)) {
                            tookCount += this.getTookSpaceByPassportType(areaNo, d.getPassport_type_no());
                            continue;
                        }
                        if (d.getPassport_type_no() != null && d.getPassport_type_no().length() != 0 || d.getCar_type_no() == null || d.getCar_type_no().length() <= 0) continue;
                        tookCount += this.getTookSpaceByCarType(areaNo, d.getCar_type_no());
                    }
                }
                if ((remainCount = totalCount - tookCount) < 0) {
                    remainCount = 0;
                }
                vo.setRemain(remainCount);
                vo.setTook(tookCount);
                vo.setTotal(totalCount);
            } else if (vs[1].startsWith("s_")) {
                int remainCount;
                String areaNo = vs[0].substring(2);
                String spaceTypeNo = vs[1].substring(2);
                int totalCount = 0;
                int tookCount = 0;
                int k = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceQuantity(spaceTypeNo, areaNo);
                if (k > 0) {
                    totalCount += k;
                }
                if ((remainCount = totalCount - (tookCount = this.getTookSpaceCount("t-a_" + areaNo + "-d_" + spaceTypeNo))) < 0) {
                    remainCount = 0;
                }
                vo.setRemain(remainCount);
                vo.setTook(tookCount);
                vo.setTotal(totalCount);
            }
        }
        return vo;
    }

    public int getTookSpaceBySpaceType(String areaNo, String spaceTypeNo) {
        if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
            return 0;
        }
        List<CarparkSpaceTypeDefine> list = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceTypeDefineList();
        if (list == null || list.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (CarparkSpaceTypeDefine d : list) {
            if (!spaceTypeNo.equals(d.getSpace_type_no())) continue;
            if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && d.getCar_type_no() != null && d.getCar_type_no().length() > 0) {
                count += this.getTookSpace(areaNo, d.getPassport_type_no(), d.getCar_type_no());
                continue;
            }
            if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && (d.getCar_type_no() == null || d.getCar_type_no().length() == 0)) {
                count += this.getTookSpaceByPassportType(areaNo, d.getPassport_type_no());
                continue;
            }
            if (d.getPassport_type_no() != null && d.getPassport_type_no().length() != 0 || d.getCar_type_no() == null || d.getCar_type_no().length() <= 0) continue;
            count += this.getTookSpaceByCarType(areaNo, d.getCar_type_no());
        }
        return count;
    }

    public int getTookSpaceByPassportType(String areaNo, String passportTypeNo) {
        String key = "a_" + areaNo + "-b_" + passportTypeNo;
        Integer a = this.spaceCache.get(key);
        int c = 0;
        if (a != null && (c = a.intValue()) < 0) {
            c = 0;
        }
        return c;
    }

    public int getTookSpaceByCarType(String areaNo, String carTypeNo) {
        String key = "a_" + areaNo + "-c_" + carTypeNo;
        Integer a = this.spaceCache.get(key);
        int c = 0;
        if (a != null && (c = a.intValue()) < 0) {
            c = 0;
        }
        return c;
    }

    public int getTookSpace(String areaNo, String passportTypeNo, String carTypeNo) {
        String key = "a_" + areaNo + "-b_" + passportTypeNo + "-c_" + carTypeNo;
        Integer a = this.spaceCache.get(key);
        int c = 0;
        if (a != null && (c = a.intValue()) < 0) {
            c = 0;
        }
        return c;
    }

    protected void doRun() throws Exception {
        this.doRefresh();
        try {
            DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
            displayVoiceService.displayRemainSpaceIfNeed();
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
        }
        this.doParkingFullQueue();
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new ParkingSpaceRefreshEvent(this));
        Collection<Equipment> screenList = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(10);
        if (screenList != null && !screenList.isEmpty()) {
            for (Equipment eq : screenList) {
                if (!(eq.getEquipmentAction() instanceof EQScreenAction)) continue;
                ((EQScreenAction)eq.getEquipmentAction()).displayAd();
            }
        }
    }

    protected void doParkingFullQueue() {
        try {
            Enumeration<PassChannel> enums = ServiceUtil.getServiceContext().getPassChannelManager().getChannels();
            if (enums != null) {
                Map<String, ChannelArea> channelAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
                HashMap<String, PassSession> passSessionQueueMap = new HashMap<String, PassSession>();
                while (enums.hasMoreElements()) {
                    int rm;
                    PassChannel passChannel = enums.nextElement();
                    ChannelArea channelArea = channelAreaMap.get(passChannel.getChannelNo());
                    if (channelArea == null || channelArea.getEnterAreas() == null || channelArea.getEnterAreas().isEmpty()) continue;
                    String enterAreaNo = channelArea.getEnterAreas().get(0).getArea_no();
                    PassSession session = passChannel.getLastSession();
                    if (session == null || !session.isValid() || session.getSessionState() != PassSession.SessionState.CANCELED || session.getAttribute("PARKING_FULL_QUEUE_FLAG") == null || session.getPassportType() == null || (rm = PassParkingFullFilter.getRemainSpace(enterAreaNo, session.getPassportType().getPassport_type_no(), session.getCarType() == null ? null : session.getCarType().getCar_type_no(), session.getReadPassportNumberEvent() == null ? null : session.getReadPassportNumberEvent().getPassportNumber())) <= 0) continue;
                    PassSession o = (PassSession)passSessionQueueMap.get(enterAreaNo);
                    if (o == null) {
                        passSessionQueueMap.put(enterAreaNo, session);
                        continue;
                    }
                    if (session.getCreatedTimeMills() >= o.getCreatedTimeMills()) continue;
                    passSessionQueueMap.put(enterAreaNo, session);
                }
                if (!passSessionQueueMap.isEmpty()) {
                    for (PassSession enL : passSessionQueueMap.values()) {
                        ParkingFullReStartSessionEvent event = new ParkingFullReStartSessionEvent(enL, enL.getPassChannel().getChannelNo());
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
                    }
                }
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
        }
    }
}

