/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.ConfirmPassDialogCallback;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.PassEventHandler;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.PlateRecognizedEventListener;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.cloud.client.HostSate;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkAttribute;
import com.wovoe.carpark.dto.CarparkCarOwner;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPlateCarType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.action.AlwaysOpenAction;
import com.wovoe.carpark.equipment.action.CameraAction;
import com.wovoe.carpark.equipment.action.CarChannelDisplayAction;
import com.wovoe.carpark.equipment.action.PlateRegCameraAction;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.event.app.CaptureEvent;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.PlateRecognizedEvent;
import com.wovoe.carpark.event.equipment.DetectedPassEvent;
import com.wovoe.carpark.event.equipment.VehicleTypeEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.pass.filter.PassSuccessFilter;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.DisplayVoiceService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.service.impl.remote.CommonRemoteServiceImpl;
import com.wovoe.carpark.vo.PassVo;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.JavaBeanTool;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.ObjectCreateCallback;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ibatis.session.SqlSession;

public class PassChannel {
    private CarparkChannel channel;
    private volatile long notHandleRegPlateTimeMills;
    private final CopyOnWriteArraySet<PlateRecognizedEventListener> plateRecognizedEventListeners;
    private final ConcurrentLinkedQueue<PassSession> sessinQueue;
    private final Collection<PassSession> unModifySessionList;
    private volatile DetectedPassEvent detectedObuEvent;
    private volatile long lasetSaveUploadRegPlateMills;
    private volatile String lasetSaveUploadRegPlate;
    private ConcurrentLinkedDeque<VehicleTypeEvent> vehicleTypeEventDeque;
    private PassEventHandler passEventHandler;

    public PassChannel(CarparkChannel channel) {
        this.channel = channel;
        this.plateRecognizedEventListeners = new CopyOnWriteArraySet();
        this.sessinQueue = new ConcurrentLinkedQueue();
        this.unModifySessionList = Collections.unmodifiableCollection(this.sessinQueue);
        this.vehicleTypeEventDeque = new ConcurrentLinkedDeque();
        this.passEventHandler = new PassEventHandler(this);
    }

    public PassEventHandler getPassEventHandler() {
        return this.passEventHandler;
    }

    public void addVehicleTypeEvent(VehicleTypeEvent event) {
        if (event == null) {
            return;
        }
        this.checkVehicleTypeEvent();
        this.vehicleTypeEventDeque.addFirst(event);
    }

    private void checkVehicleTypeEvent() {
        long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
        Iterator<VehicleTypeEvent> it = this.vehicleTypeEventDeque.iterator();
        while (it.hasNext()) {
            VehicleTypeEvent e = it.next();
            if (currentMills - e.getNonTimeMills() < 60000L) continue;
            it.remove();
        }
    }

    public VehicleTypeEvent findVehicleTypeEvent(String plateNumber) {
        if (plateNumber == null || plateNumber.length() == 0) {
            return null;
        }
        if ("\u65e0\u724c\u8f66".equals(plateNumber) || "\u65e0\u724c\u8f66".equals(plateNumber)) {
            plateNumber = "\u65e0\u724c\u8f66";
        }
        for (VehicleTypeEvent event : this.vehicleTypeEventDeque) {
            if (!plateNumber.equals(event.getPlateNumber())) continue;
            return event;
        }
        return null;
    }

    public long getLasetSaveUploadRegPlateMills() {
        return this.lasetSaveUploadRegPlateMills;
    }

    public void setLasetSaveUploadRegPlateMills(long lasetSaveUploadRegPlateMills) {
        this.lasetSaveUploadRegPlateMills = lasetSaveUploadRegPlateMills;
    }

    public String getLasetSaveUploadRegPlate() {
        return this.lasetSaveUploadRegPlate;
    }

    public void setLasetSaveUploadRegPlate(String lasetSaveUploadRegPlate) {
        this.lasetSaveUploadRegPlate = lasetSaveUploadRegPlate;
    }

    public PassSession getPassSession(long sessionId) {
        for (PassSession session : this.sessinQueue) {
            if (session.getSessionId() != sessionId) continue;
            return session;
        }
        return null;
    }

    public Collection<PassSession> getSessions() {
        this.checkSession();
        return this.unModifySessionList;
    }

    public PassSession getFirstSession() {
        this.checkSession();
        return this.sessinQueue.peek();
    }

    public PassSession getConfirmDialogSession() {
        for (PassSession s : this.sessinQueue) {
            if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG) continue;
            return s;
        }
        return null;
    }

    public PassSession getLastConfirmDialogSession() {
        PassSession a = null;
        for (PassSession s : this.sessinQueue) {
            if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG) continue;
            a = s;
        }
        return a;
    }

    public DetectedPassEvent getDetectedObuEvent() {
        return this.detectedObuEvent;
    }

    public void setDetectedObuEvent(DetectedPassEvent detectedObuEvent) {
        this.detectedObuEvent = detectedObuEvent;
    }

    public PassSession getLastSession() {
        this.checkSession();
        PassSession s = null;
        Iterator<PassSession> iterator = this.sessinQueue.iterator();
        while (iterator.hasNext()) {
            PassSession s1;
            s = s1 = iterator.next();
        }
        return s;
    }

    public PassSession getCurrentHandleSession() {
        PassSession handleSession = null;
        for (PassSession session : this.sessinQueue) {
            if (session.getSessionState() != PassSession.SessionState.OPEN_DIALOG && session.getSessionState() != PassSession.SessionState.WAIT_PAY || session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(session.getReadPassportNumberEvent().getPassportNumber())) continue;
            Long x = (Long)session.getAttribute("PLAY_HANDLE_SESSION_MILLS");
            if (x == null) {
                x = 0L;
            }
            if (handleSession == null) {
                handleSession = session;
                continue;
            }
            Long x1 = (Long)handleSession.getAttribute("PLAY_HANDLE_SESSION_MILLS");
            if (x1 == null) {
                x1 = 0L;
            }
            if (x < x1) continue;
            handleSession = session;
        }
        return handleSession;
    }

    public void setCarparkChannel(CarparkChannel channel) {
        if (channel != null) {
            this.channel = channel;
        }
    }

    public String getChannelNo() {
        return this.channel.getChannel_no();
    }

    public CarparkChannel getChannel() {
        return this.channel;
    }

    public boolean isOtherHostChannel() {
        String manageHostNo = this.getManagerHostNo();
        return manageHostNo == null || !manageHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo());
    }

    public boolean isLocalHostChannel() {
        return !this.isOtherHostChannel();
    }

    public CarparkHost getManagerHost() {
        Map<String, CarparkHost> map = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        String hostNo = this.getChannel().getManaged_host_no();
        if (map != null && hostNo != null) {
            return map.get(hostNo);
        }
        return null;
    }

    public String getManagerHostNo() {
        CarparkHost host = this.getManagerHost();
        if (host != null) {
            return host.getHost_no();
        }
        return null;
    }

    public long getNotHandleRegPlateTimeMills() {
        return this.notHandleRegPlateTimeMills;
    }

    public void setNotHandleRegPlateTimeMills(long notHandleRegPlateTimeMills) {
        this.notHandleRegPlateTimeMills = notHandleRegPlateTimeMills;
    }

    public Collection<PlateRecognizedEventListener> getPlateRecognizedEventListeners() {
        return this.plateRecognizedEventListeners;
    }

    public void removePlateRecognizedEventListener(PlateRecognizedEventListener l) {
        if (l != null) {
            this.plateRecognizedEventListeners.remove(l);
        }
    }

    public void addPlateRecognizedEventListener(PlateRecognizedEventListener l) {
        if (l != null) {
            this.plateRecognizedEventListeners.add(l);
        }
    }

    public PassSession openSession() {
        String[] keys = new String[]{"DisplayVoiceServiceImpl.clearDisplayMessageSessionStateChangeListener"};
        Collection<PassSession> cls = this.getSessions();
        for (PassSession p : cls) {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                PassSession.SessionStateChangeListener l1 = (PassSession.SessionStateChangeListener)p.removeAttribute(key);
                if (l1 != null) {
                    p.removeSessionStateChangeListener(l1);
                }
                ++n2;
            }
        }
        return this.openSessionBefore(null);
    }

    private PassSession createSession() {
        return new PassSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PassSession openSessionBefore(PassSession s) {
        PassSession session = this.createSession();
        ConcurrentLinkedQueue<PassSession> concurrentLinkedQueue = this.sessinQueue;
        synchronized (concurrentLinkedQueue) {
            if (s == null) {
                this.sessinQueue.offer(session);
            } else {
                LinkedList<PassSession> slist = new LinkedList<PassSession>();
                Iterator<PassSession> its = this.sessinQueue.iterator();
                while (its.hasNext()) {
                    PassSession s1 = its.next();
                    if (s1 == s) {
                        slist.offer(s1);
                        its.remove();
                        continue;
                    }
                    if (slist.isEmpty()) continue;
                    slist.offer(s1);
                    its.remove();
                }
                this.sessinQueue.offer(session);
                if (!slist.isEmpty()) {
                    PassSession s1;
                    while ((s1 = (PassSession)slist.poll()) != null) {
                        this.sessinQueue.offer(s1);
                    }
                }
            }
        }
        return session;
    }

    public boolean getTimeoutAutoPassOk() {
        ChannelArea ca;
        Map<String, ChannelArea> chananleAreamap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
        boolean isExit = false;
        if (chananleAreamap != null && (ca = chananleAreamap.get(this.getChannelNo())) != null && (ca.getEnterAreas() == null || ca.getEnterAreas().isEmpty())) {
            isExit = true;
        }
        if (isExit && Constants.NO_STR.equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CARPARK_DIALOG_EXIT_CANCEL_STRATEGY"))) {
            return true;
        }
        return Constants.YES_STR.equals(ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(this.getChannelNo(), "CHANEL_CONFIRM_DIALOG_TIMEOUT_HANDLE"));
    }

    public void checkSessionAndConfirmTimout() {
        int minus = 10;
        try {
            int ax;
            String va = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(this.getChannelNo(), "CHANEL_CONFIRM_DIALOGTIMEOUT");
            if (va != null && va.length() > 0 && (ax = Integer.parseInt(va)) > 0 && ax <= 15) {
                minus = ax;
            }
        }
        catch (Exception va) {
            // empty catch block
        }
        long confiremMills = minus * 60 * 1000;
        LinkedList<PassSession> noDialogInValidSessions = null;
        LinkedList<PassSession> dialogInValidSessions = null;
        long currentTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
        for (PassSession s : this.sessinQueue) {
            long gbaMills = currentTimeMills - s.getCreatedTimeMills();
            if (s.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
                if (gbaMills < confiremMills || s.getReadPassportNumberEvent() == null) continue;
                if (dialogInValidSessions == null) {
                    dialogInValidSessions = new LinkedList<PassSession>();
                }
                dialogInValidSessions.add(s);
                continue;
            }
            if (gbaMills < (long)s.getSessionTimeoutMills()) continue;
            if (noDialogInValidSessions == null) {
                noDialogInValidSessions = new LinkedList<PassSession>();
            }
            noDialogInValidSessions.add(s);
        }
        if (noDialogInValidSessions != null && !noDialogInValidSessions.isEmpty()) {
            Iterator it = noDialogInValidSessions.iterator();
            while (it.hasNext()) {
                PassSession s = (PassSession)it.next();
                if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG) {
                    this.invalidateSession(s);
                }
                it.remove();
            }
        }
        if (dialogInValidSessions != null && !dialogInValidSessions.isEmpty()) {
            PassSession lastSaveSession = null;
            int count = 0;
            boolean handleOk = this.getTimeoutAutoPassOk();
            try {
                PassFilter saveFilter = ServiceUtil.getServiceContext().getPassFilterChain().getSavePassDataFilter();
                for (PassSession s : dialogInValidSessions) {
                    try {
                        if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG) continue;
                        ++count;
                        try {
                            if (handleOk && s.getReadPassportNumberEvent() != null && !s.getReadPassportNumberEvent().isManualTrigger()) {
                                block43: {
                                    s.setAttribute("TIMEOUT_AUTO_PASS", Boolean.TRUE);
                                    try {
                                        try {
                                            if (saveFilter != null) {
                                                saveFilter.doFilter(s);
                                            }
                                        }
                                        catch (Exception ex) {
                                            ServiceLog.getLog().warn((Object)"\u4fdd\u5b58\u6570\u636e\u5f02\u5e38", (Throwable)ex);
                                            s.setSessionState(PassSession.SessionState.CAR_LEFT);
                                            break block43;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        s.setSessionState(PassSession.SessionState.CAR_LEFT);
                                        throw throwable;
                                    }
                                    s.setSessionState(PassSession.SessionState.CAR_LEFT);
                                }
                                lastSaveSession = s;
                                continue;
                            }
                            try {
                                try {
                                    if (s.getPassChannel().getLanConnectManageHostState() == null || s.getAttribute("CONFIRM_SESSION_DATA_FROM_BOX") == null) {
                                        if (s.getOpenDialogCacnelRecord() != null) {
                                            s.doSaveCancelPassRecrodIfExist(false, false);
                                        }
                                    } else {
                                        s.removeCancelPassRecord();
                                    }
                                }
                                catch (Exception ex) {
                                    ServiceLog.getLog().warn((Object)"\u4fdd\u5b58\u53d6\u6d88\u653e\u884c\u6570\u636e\u5f02\u5e38", (Throwable)ex);
                                    s.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                    s.setSessionState(PassSession.SessionState.CANCELED);
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                s.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                s.setSessionState(PassSession.SessionState.CANCELED);
                                throw throwable;
                            }
                            s.setAttribute("GUI_CANCEL", Boolean.TRUE);
                            s.setSessionState(PassSession.SessionState.CANCELED);
                        }
                        finally {
                            try {
                                ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                if (callback != null) {
                                    callback.doClosePassDialog(s);
                                }
                            }
                            finally {
                                this.invalidateSession(s);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            catch (Throwable throwable) {
                if (count > 0) {
                    String v = handleOk ? "\u653e\u884c\u6210\u529f" : "\u53d6\u6d88\u653e\u884c";
                    String msg = "\u68c0\u6d4b\u5230\u6709\u8d85\u65f6\u672a\u5904\u7406\u653e\u884c\u7a97\u4f53\uff0c\u5df2\u5f53\u6210" + v + "\u5904\u7406\uff0c\u5e76\u5173\u95ed\u7a97\u4f53\uff0c\u672c\u6b21\u5173\u95ed\u7a97\u4f53\u6570\uff1a" + count;
                    ServiceLog.getLog().warn((Object)msg);
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 3));
                }
                if (lastSaveSession != null) {
                    PassSuccessFilter.throwUpdateRecrodUI(lastSaveSession, lastSaveSession);
                }
                throw throwable;
            }
            if (count > 0) {
                String v = handleOk ? "\u653e\u884c\u6210\u529f" : "\u53d6\u6d88\u653e\u884c";
                String msg = "\u68c0\u6d4b\u5230\u6709\u8d85\u65f6\u672a\u5904\u7406\u653e\u884c\u7a97\u4f53\uff0c\u5df2\u5f53\u6210" + v + "\u5904\u7406\uff0c\u5e76\u5173\u95ed\u7a97\u4f53\uff0c\u672c\u6b21\u5173\u95ed\u7a97\u4f53\u6570\uff1a" + count;
                ServiceLog.getLog().warn((Object)msg);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 3));
            }
            if (lastSaveSession != null) {
                PassSuccessFilter.throwUpdateRecrodUI(lastSaveSession, lastSaveSession);
            }
        }
    }

    public void checkSession() {
        long currentTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
        LinkedList<PassSession> noDialogInValidSessions = null;
        for (PassSession s : this.sessinQueue) {
            long gbaMills;
            if (s.getSessionState() == PassSession.SessionState.OPEN_DIALOG || (gbaMills = currentTimeMills - s.getCreatedTimeMills()) < (long)s.getSessionTimeoutMills()) continue;
            if (noDialogInValidSessions == null) {
                noDialogInValidSessions = new LinkedList<PassSession>();
            }
            noDialogInValidSessions.add(s);
        }
        if (noDialogInValidSessions != null && !noDialogInValidSessions.isEmpty()) {
            for (PassSession s : noDialogInValidSessions) {
                if (s.getSessionState() == PassSession.SessionState.OPEN_DIALOG) continue;
                this.invalidateSession(s);
            }
        }
    }

    public void invalidateAllSessionDelayBefore(int timeMills, PassSession session) {
        if (timeMills < 0) {
            timeMills = 0;
        }
        long currentTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
        for (PassSession s : this.sessinQueue) {
            if (session != null && s == session) break;
            if (s.getSessionState() == PassSession.SessionState.OPEN_DIALOG) continue;
            int sessionTimeoutMills = (int)(currentTimeMills - s.getCreatedTimeMills()) + timeMills;
            if (s.getSessionTimeoutMills() <= sessionTimeoutMills) continue;
            s.resetSessionTimeoutMills(sessionTimeoutMills);
        }
    }

    public void invalidateSession(PassSession session) {
        Iterator<PassSession> it = this.sessinQueue.iterator();
        while (it.hasNext()) {
            PassSession se = it.next();
            if (se != session) continue;
            if (session.getSessionState() == PassSession.SessionState.PROCESSING) {
                session.setSessionState(PassSession.SessionState.CANCELED);
            }
            it.remove();
            break;
        }
    }

    public List<OperationFuture<Integer>> openPole() {
        return this.openPole(null);
    }

    public List<OperationFuture<Integer>> openPole(PassSession passSession) {
        return this.openPole(false, passSession);
    }

    public void lightGreen() {
        try {
            List<Equipment> clist = this.getEquipmentList(10);
            if (clist != null && !clist.isEmpty()) {
                for (Equipment eq : clist) {
                    CarChannelDisplayAction c;
                    Object action = eq.getEquipmentAction();
                    if (action == null || !(action instanceof CarChannelDisplayAction) || !(c = (CarChannelDisplayAction)action).isSupportTrafficLights()) continue;
                    c.lightGreen(10);
                }
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage());
        }
    }

    public List<OperationFuture<Integer>> downPole() {
        return this.downPole(false);
    }

    public List<OperationFuture<Integer>> downPole(final boolean thowOpenSuccesMsg) {
        List<Equipment> roadGateList = this.getEquipmentList(9);
        if (roadGateList == null || roadGateList.isEmpty()) {
            if (thowOpenSuccesMsg) {
                String msg = String.valueOf(this.getChannel().getChannel_name()) + ", \u672a\u914d\u7f6e\u9053\u95f8, \u5173\u95f8\u5931\u8d25!";
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4));
            }
            return null;
        }
        boolean logCancelAlwaysOpenLog = false;
        ArrayList<OperationFuture<Integer>> list = new ArrayList<OperationFuture<Integer>>(roadGateList.size());
        for (final Equipment eq : roadGateList) {
            try {
                RoadBarrierAction action = (RoadBarrierAction)eq.getEquipmentAction();
                if (action instanceof AlwaysOpenAction && ((AlwaysOpenAction)((Object)action)).isAlwaysOpen()) {
                    logCancelAlwaysOpenLog = true;
                }
                OperationFuture<Integer> op1 = action.doDownPoleAction();
                op1.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void operationComplete(OperationFuture<Integer> x) {
                        if (x.getException() == null && x.getResult() != null && (Integer)x.getResult() == 0) {
                            if (thowOpenSuccesMsg) {
                                String msg = String.valueOf(PassChannel.this.getChannel().getChannel_name()) + "," + eq.getName() + ",\u5173\u95f8\u6210\u529f!";
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 1));
                            }
                        } else {
                            this.doErr();
                        }
                    }

                    public void waitCompleteTimeout() {
                        this.doErr();
                    }

                    private void doErr() {
                        String msg = String.valueOf(PassChannel.this.getChannel().getChannel_name()) + "," + eq.getName() + ",\u5173\u95f8\u5931\u8d25!";
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4));
                    }
                });
                list.add(op1);
            }
            catch (Exception ex) {
                OperationFutureHandler x1 = ServiceUtil.getServiceContext().createOperationFuture();
                x1.setException((Throwable)ex);
                list.add((OperationFuture<Integer>)x1);
                ServiceLog.getLog().warn((Object)"", (Throwable)ex);
            }
        }
        if (logCancelAlwaysOpenLog) {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        RecordSaveService recordService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                        recordService.saveIllegalPassRecord(0, "0", "\u5173\u95ed\u9053\u95f8\u5e38\u5f00", null, PassChannel.this.getChannelNo(), PassChannel.this.captureOne(8), null, null);
                    }
                    catch (Throwable ex) {
                        String msg = String.valueOf(PassChannel.this.getChannel().getChannel_name()) + ":\u4fdd\u5b58\u5173\u95ed\u9053\u95f8\u5e38\u5f00\u6570\u636e\u9519\u8bef!";
                        ServiceLog.getLog().warn((Object)msg, ex);
                    }
                }
            });
        }
        return list;
    }

    public List<OperationFuture<Integer>> openPole(final boolean thowOpenSuccesMsg, PassSession passSession) {
        try {
            String ax;
            List<Equipment> roadGateList = this.getEquipmentList(9);
            if (roadGateList == null || roadGateList.isEmpty()) {
                return null;
            }
            boolean io2 = false;
            if (passSession != null && (ax = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(this.getChannelNo(), "YELLOW_PLATE_OPEN_IO2")) != null && ax.length() > 0 && !Constants.NO_STR.equals(ax)) {
                String[] carTyps = ax.split(",");
                CarparkCarType carType = passSession.getCarType();
                if (carType != null) {
                    String[] stringArray = carTyps;
                    int n = carTyps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String a = stringArray[n2];
                        if (a != null && (a = a.trim()).length() > 0 && a.equals(carType.getCar_type_name())) {
                            io2 = true;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            ArrayList<OperationFuture<Integer>> list = new ArrayList<OperationFuture<Integer>>(roadGateList.size());
            for (final Equipment eq : roadGateList) {
                try {
                    RoadBarrierAction action = (RoadBarrierAction)eq.getEquipmentAction();
                    OperationFuture<Integer> op1 = action.doRaisePoleAction();
                    op1.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                        public void operationComplete(OperationFuture<Integer> x) {
                            if (x.getException() == null && x.getResult() != null && (Integer)x.getResult() == 0) {
                                if (thowOpenSuccesMsg) {
                                    String msg = String.valueOf(PassChannel.this.getChannel().getChannel_name()) + "," + eq.getName() + ",\u5f00\u95f8\u6210\u529f!";
                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 1));
                                }
                            } else {
                                this.doErr();
                            }
                        }

                        public void waitCompleteTimeout() {
                            this.doErr();
                        }

                        private void doErr() {
                            String msg = String.valueOf(PassChannel.this.getChannel().getChannel_name()) + "," + eq.getName() + ",\u5f00\u95f8\u5931\u8d25!";
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4));
                        }
                    });
                    list.add(op1);
                    if (!io2) continue;
                    action.doDownPoleAction();
                }
                catch (Exception ex) {
                    OperationFutureHandler x1 = ServiceUtil.getServiceContext().createOperationFuture();
                    x1.setException((Throwable)ex);
                    list.add((OperationFuture<Integer>)x1);
                    ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                }
            }
            ArrayList<OperationFuture<Integer>> arrayList = list;
            return arrayList;
        }
        finally {
            this.lightGreen();
        }
    }

    public void invalidateSessionBefore(PassSession session) {
        Iterator<PassSession> it = this.sessinQueue.iterator();
        while (it.hasNext()) {
            PassSession s = it.next();
            if (s.getCreatedTimeMills() >= session.getCreatedTimeMills() || s == session || s.getSessionState() == PassSession.SessionState.OPEN_DIALOG) continue;
            if (s.getSessionState() == PassSession.SessionState.PENDING || s.getSessionState() == PassSession.SessionState.PROCESSING || s.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                s.setSessionState(PassSession.SessionState.CANCELED);
            }
            it.remove();
        }
    }

    void startSession(PassSession session) {
        if (session.getSessionState() != PassSession.SessionState.PROCESSING) {
            throw new IllegalStateException("session \u72b6\u6001\u9519\u8bef\uff01");
        }
        try {
            if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isUserScan() && session.getReadPassportNumberEvent().getRemoteExeHandler() != null) {
                session.addSessionStateChangeListener(new PassSession.SessionStateChangeListener(){

                    @Override
                    public void sessionStateChanged(PassSession session, PassSession.SessionState oldState, PassSession.SessionState newState) {
                        if (newState == PassSession.SessionState.CANCELED) {
                            session.removeAttribute("PRE_ENTRY_RECORD_ID");
                            if (!session.getReadPassportNumberEvent().getRemoteExeHandler().isDone()) {
                                if (session.getForbidPassExceptions() != null) {
                                    for (Integer a : session.getForbidPassExceptions()) {
                                        if (a == 1) {
                                            session.getReadPassportNumberEvent().triggerPassError("\u65e0\u6743\u9650\uff0c\u7981\u6b62\u901a\u884c");
                                            continue;
                                        }
                                        if (a == 2) {
                                            session.getReadPassportNumberEvent().triggerPassError("\u8f66/\u5361\u91cd\u590d\u5165\u573a");
                                            continue;
                                        }
                                        if (a == 3) {
                                            session.getReadPassportNumberEvent().triggerPassError("\u8f66/\u5361\u672a\u5165\u573a");
                                            continue;
                                        }
                                        if (a == 4) {
                                            session.getReadPassportNumberEvent().triggerPassError("\u6708\u5361\u5df2\u8fc7\u671f");
                                            continue;
                                        }
                                        if (a == 5) {
                                            session.getReadPassportNumberEvent().triggerPassError("\u505c\u8f66\u4f4d\u5df2\u6ee1\uff0c\u7981\u6b62\u5165\u573a");
                                            continue;
                                        }
                                        if (a != 6) continue;
                                        session.getReadPassportNumberEvent().triggerPassError("\u9ed1\u540d\u5355\u8f66\uff0c\u7981\u6b62\u901a\u884c");
                                    }
                                }
                                if (!session.getReadPassportNumberEvent().getRemoteExeHandler().isDone()) {
                                    session.getReadPassportNumberEvent().triggerPassError("\u653e\u884c\u5df2\u53d6\u6d88");
                                }
                            }
                        } else if (newState == PassSession.SessionState.OPEN_DIALOG) {
                            ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
                            Cost cost = (Cost)session.getAttribute("pass_cost");
                            if (channelArea != null && channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty() || cost != null && cost.getActualCharge().doubleValue() > 0.0) {
                                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                                result.put("responseCode", "0");
                                result.put("responseMsg", "success");
                                CommonRemoteServiceImpl.setQueryPassSessionResult(session, result);
                                if (!session.getReadPassportNumberEvent().getRemoteExeHandler().isDone()) {
                                    session.getReadPassportNumberEvent().getRemoteExeHandler().setResult(result);
                                }
                            } else if (!session.getReadPassportNumberEvent().getRemoteExeHandler().isDone()) {
                                session.getReadPassportNumberEvent().triggerPassErrorAndCode("\u503c\u73ed\u5458\u6b63\u5728\u786e\u8ba4\u60a8\u7684\u4fe1\u606f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019...", "1");
                            }
                        } else if (newState == PassSession.SessionState.WAIT_PAY) {
                            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                            result.put("responseCode", "0");
                            result.put("responseMsg", "success");
                            CommonRemoteServiceImpl.setQueryPassSessionResult(session, result);
                            if (!session.getReadPassportNumberEvent().getRemoteExeHandler().isDone()) {
                                session.getReadPassportNumberEvent().getRemoteExeHandler().setResult(result);
                            }
                        } else if (!(newState != PassSession.SessionState.WAIT_CAR_LEAVE && newState != PassSession.SessionState.CAR_LEAVING || session.getReadPassportNumberEvent().getRemoteExeHandler().isDone())) {
                            ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
                            if (channelArea != null && channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                                List passRecordList;
                                HashMap<String, String> result = new HashMap<String, String>();
                                result.put("responseCode", "0");
                                result.put("responseMsg", "\u6b22\u8fce\u5149\u4e34\uff0c\u8bf7\u5165\u573a");
                                Date passTime = (Date)session.getAttribute("passTime");
                                if (passTime != null) {
                                    result.put("enterMills1", String.valueOf(passTime.getTime()));
                                }
                                if (channelArea.getEnterAreas().get(0).getArea_level() == 1) {
                                    result.put("areaOut1", "1");
                                }
                                if ((passRecordList = (List)session.getAttribute("SAVED_PASSRECORD_LIST")) != null && !passRecordList.isEmpty()) {
                                    CarparkPassRecord r = (CarparkPassRecord)passRecordList.get(0);
                                    if (passRecordList.size() > 1) {
                                        String outAreaNo = channelArea.getEnterAreas().get(0).getArea_no();
                                        for (CarparkPassRecord r1 : passRecordList) {
                                            if (r1.getEnter_time() == null || r.getExit_time() != null || !outAreaNo.equals(r1.getArea_no())) continue;
                                            r = r1;
                                            break;
                                        }
                                    }
                                    result.put("enter_record_no", r.getEnter_record_no());
                                    result.put("pass_enter_time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(r.getEnter_time() == null ? new Date() : r.getEnter_time()));
                                }
                                session.getReadPassportNumberEvent().getRemoteExeHandler().setResult(result);
                            } else {
                                HashMap<String, Object> result = new HashMap<String, Object>();
                                result.put("responseCode", "0");
                                result.put("responseMsg", "\u4e00\u8def\u987a\u98ce\uff0c\u8bf7\u79bb\u573a");
                                CommonRemoteServiceImpl.setExitCostPassSessionResult(session, result);
                                Date passTime = (Date)session.getAttribute("passTime");
                                if (passTime != null) {
                                    result.put("exitMills1", String.valueOf(passTime.getTime()));
                                }
                                session.getReadPassportNumberEvent().getRemoteExeHandler().setResult(result);
                            }
                        }
                    }
                });
            }
            this.doStartSession(session);
        }
        catch (Throwable ex) {
            try {
                String msg = session.getReadPassportNumberEvent() != null ? String.valueOf(Constants.getMediumTypeDes(session.getReadPassportNumberEvent().getPassportMediumType())) + "\uff1a" + session.getReadPassportNumberEvent().getPassportNumber() : "";
                String message = String.valueOf(this.channel.getChannel_name()) + "\uff1a\u653e\u884c\u5f02\u5e38\uff01\u5185\u90e8\u9519\u8bef\uff01" + msg;
                LogUtil.getLog().error((Object)message, ex);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 4));
                DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                try {
                    if (this.getLanConnectManageHostState() == null) {
                        displayVoiceService.playPassError(session);
                    }
                }
                catch (Exception ex1) {
                    ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex1);
                }
                session.setSessionState(PassSession.SessionState.CANCELED);
            }
            finally {
                session.setSessionState(PassSession.SessionState.CANCELED);
            }
        }
    }

    public static Object getScriptDefineType(String plate, PlateRecognizedEvent event) {
        block20: {
            String exeResult;
            block19: {
                if (plate == null || plate.length() == 0) {
                    return null;
                }
                String cartype_script = ServiceUtil.getServiceContext().getCarpark().getCartype_script();
                if (cartype_script == null || cartype_script.length() == 0) {
                    return null;
                }
                HashMap<String, String> eMap = new HashMap<String, String>();
                eMap.put("plateNumber", plate);
                String cameraType = "";
                String plateColor = "";
                String plateTypeDes = "";
                String carTypeDes = "";
                if (event != null) {
                    Equipment eq;
                    if (event.getSource() instanceof Equipment && (eq = (Equipment)event.getSource()).getDriver() != null && eq.getDriver() != null) {
                        if ("wovoe_ice_ip_camera_driver".equals(eq.getDriver().getName())) {
                            cameraType = "HX";
                        } else if ("wovoe_qy_ip_camera_driver".equals(eq.getDriver().getName())) {
                            cameraType = "QY";
                        } else if ("wovoe_zhenshi_ip_camera_driver".equals(eq.getDriver().getName())) {
                            cameraType = "ZS";
                        }
                    }
                    if (event.getPlateColor() != null && event.getPlateColor().length() > 0) {
                        plateColor = event.getPlateColor();
                    }
                    if (event.getPlateTypeDes() != null && event.getPlateTypeDes().length() > 0) {
                        plateTypeDes = event.getPlateTypeDes();
                    }
                    if (event.getCarTypeDes() != null && event.getCarTypeDes().length() > 0) {
                        carTypeDes = event.getCarTypeDes();
                    }
                }
                eMap.put("cameraType", cameraType);
                eMap.put("plateColor", plateColor);
                eMap.put("plateTypeDes", plateTypeDes);
                eMap.put("carTypeDes", carTypeDes);
                String plateTypePX = "plateType:";
                String carTypePX = "carType:";
                exeResult = ServiceUtil.getServiceContext().getDynStringTemplate().createOneLineString(cartype_script, eMap).toString();
                if (exeResult != null && exeResult.length() != 0) break block19;
                return null;
            }
            try {
                if (exeResult.startsWith("plateType:")) {
                    exeResult = exeResult.substring("plateType:".length()).trim();
                    Map<String, CarparkPassportType> typeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                    for (CarparkPassportType c : typeMap.values()) {
                        if (!exeResult.equals(c.getPassport_type_name())) continue;
                        return c;
                    }
                    break block20;
                }
                if (exeResult.startsWith("carType:")) {
                    exeResult = exeResult.substring("carType:".length()).trim();
                    Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
                    for (CarparkCarType c : carTypeMap.values()) {
                        if (!exeResult.equals(c.getCar_type_name())) continue;
                        return c;
                    }
                    break block20;
                }
                return null;
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u7c7b\u578b\u811a\u672c\u5224\u65ad\u9519\u8bef: " + ex.getMessage()));
            }
        }
        return null;
    }

    public static Object getCarTypeOrPlateType(String bindName) {
        if (bindName == null || bindName.length() == 0) {
            return null;
        }
        Map<String, CarparkAttribute> bindMap = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(2);
        if (bindMap != null) {
            CarparkAttribute attr = bindMap.get(bindName);
            if (attr == null) {
                return null;
            }
            if (attr.getAttribute_value() == null || attr.getAttribute_value().length() == 0) {
                return null;
            }
            int h = attr.getAttribute_value().indexOf(44);
            if (h == -1) {
                return null;
            }
            String[] ax = attr.getAttribute_value().split(",");
            if (ax.length != 2) {
                return null;
            }
            if ("1".equals(ax[0])) {
                return ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(ax[1]);
            }
            if ("2".equals(ax[0])) {
                return ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().get(ax[1]);
            }
        }
        return null;
    }

    public static Object getCarTypeOrPlateType(String plate, PlateRecognizedEvent event) {
        Object carType;
        if (plate == null || plate.length() < 3) {
            return null;
        }
        if (plate.startsWith("WJ") || plate.indexOf("\u6b66\u8b66") != -1 ? (carType = PassChannel.getCarTypeOrPlateType("\u6b66\u8b66\u8f66")) != null : (plate.startsWith("\u4eacV") || plate.indexOf("\u519b") != -1 || plate.startsWith("\u5317") || plate.startsWith("\u5357") || plate.startsWith("\u5e7f") || plate.startsWith("\u6d4e") || plate.startsWith("\u6c88") || plate.startsWith("\u5170") || plate.startsWith("\u6210") || plate.startsWith("\u6d77") || plate.startsWith("\u7a7a") || plate.startsWith("V") || plate.startsWith("K") || plate.startsWith("H") || plate.startsWith("B") || plate.startsWith("S") || plate.startsWith("L") || plate.startsWith("J") || plate.startsWith("N") || plate.startsWith("G") || plate.startsWith("C") ? (carType = PassChannel.getCarTypeOrPlateType("\u519b\u8f66")) != null : (plate.indexOf("\u8b66") != -1 ? (carType = PassChannel.getCarTypeOrPlateType("\u8b66\u8f66")) != null : (plate.indexOf("\u5b66") != -1 ? (carType = PassChannel.getCarTypeOrPlateType("\u6559\u7ec3\u8f66")) != null : (plate.indexOf(20351) != -1 ? (carType = PassChannel.getCarTypeOrPlateType("\u5927\u4f7f\u9986\u8f66")) != null : (plate.indexOf(39046) != -1 ? (carType = PassChannel.getCarTypeOrPlateType("\u9886\u4e8b\u9986\u8f66")) != null : (plate.charAt(1) == 'O' ? (carType = PassChannel.getCarTypeOrPlateType("O\u724c\u8f66")) != null : (plate.indexOf(28207) != -1 ? (carType = PassChannel.getCarTypeOrPlateType("\u9999\u6e2f\u724c\u8f66")) != null : plate.indexOf(28595) != -1 && (carType = PassChannel.getCarTypeOrPlateType("\u6fb3\u95e8\u724c\u8f66")) != null)))))))) {
            return carType;
        }
        if (plate.length() == 8) {
            Object carType2;
            String p23 = plate.substring(2, 3);
            if (p23.equals("D") || p23.equals("A") || p23.equals("B") || p23.equals("C") || p23.equals("E") ? (carType2 = PassChannel.getCarTypeOrPlateType("\u7eaf\u7535\u52a8\u5c0f\u8f66")) != null : (p23.equals("F") || p23.equals("G") || p23.equals("H") || p23.equals("J") || p23.equals("K") ? (carType2 = PassChannel.getCarTypeOrPlateType("\u6df7\u52a8\u5c0f\u8f66")) != null : (plate.endsWith("D") || plate.endsWith("A") || plate.endsWith("B") || plate.endsWith("C") || plate.endsWith("E") ? (carType2 = PassChannel.getCarTypeOrPlateType("\u7eaf\u7535\u52a8\u5927\u8f66")) != null : (plate.endsWith("F") || plate.endsWith("G") || plate.endsWith("H") || plate.endsWith("J") || plate.endsWith("K")) && (carType2 = PassChannel.getCarTypeOrPlateType("\u6df7\u52a8\u5927\u8f66")) != null))) {
                return carType2;
            }
            carType2 = PassChannel.getCarTypeOrPlateType("8\u4f4d\u6570\u8f66\u724c");
            if (carType2 != null) {
                return carType2;
            }
        }
        if (event != null) {
            Object carType3;
            String plateColor = "";
            String plateTypeDes = "";
            if (event.getPlateColor() != null && event.getPlateColor().length() > 0) {
                plateColor = event.getPlateColor();
            }
            if (event.getPlateTypeDes() != null && event.getPlateTypeDes().length() > 0) {
                plateTypeDes = event.getPlateTypeDes();
            }
            if (plateTypeDes != null && plateTypeDes.length() > 0 && (plateTypeDes.indexOf("\u519b\u8f66") != -1 ? (carType3 = PassChannel.getCarTypeOrPlateType("\u519b\u8f66")) != null : (plateTypeDes.indexOf("\u6b66\u8b66") != -1 ? (carType3 = PassChannel.getCarTypeOrPlateType("\u6b66\u8b66\u8f66")) != null : (plateTypeDes.indexOf("\u8b66\u8f66") != -1 ? (carType3 = PassChannel.getCarTypeOrPlateType("\u8b66\u8f66")) != null : plateTypeDes.indexOf("\u6559\u7ec3") != -1 && (carType3 = PassChannel.getCarTypeOrPlateType("\u6559\u7ec3\u8f66")) != null)))) {
                return carType3;
            }
            if (plateColor != null && plateColor.length() > 0 && (plateColor.indexOf("\u767d") != -1 ? (carType3 = PassChannel.getCarTypeOrPlateType("\u767d\u724c\u8f66")) != null : (plateColor.indexOf("\u9ec4") != -1 ? (carType3 = PassChannel.getCarTypeOrPlateType("\u9ec4\u724c\u8f66")) != null : (plateColor.indexOf("\u9ed1") != -1 ? (carType3 = PassChannel.getCarTypeOrPlateType("\u9ed1\u724c\u8f66")) != null : plateColor.indexOf("\u7eff") != -1 && (carType3 = PassChannel.getCarTypeOrPlateType("\u7eff\u724c\u8f66")) != null)))) {
                return carType3;
            }
        }
        return null;
    }

    public static String getCarTypeString(String plate, PlateRecognizedEvent event) {
        if (plate == null || plate.length() < 3) {
            return null;
        }
        if (plate.startsWith("WJ") || plate.indexOf("\u6b66\u8b66") != -1) {
            return "\u6b66\u8b66\u8f66";
        }
        if (plate.startsWith("\u4eacV") || plate.indexOf("\u519b") != -1 || plate.startsWith("\u5317") || plate.startsWith("\u5357") || plate.startsWith("\u5e7f") || plate.startsWith("\u6d4e") || plate.startsWith("\u6c88") || plate.startsWith("\u5170") || plate.startsWith("\u6210") || plate.startsWith("\u6d77") || plate.startsWith("\u7a7a") || plate.startsWith("V") || plate.startsWith("K") || plate.startsWith("H") || plate.startsWith("B") || plate.startsWith("S") || plate.startsWith("L") || plate.startsWith("J") || plate.startsWith("N") || plate.startsWith("G") || plate.startsWith("C")) {
            return "\u519b\u8f66";
        }
        if (plate.indexOf("\u8b66") != -1) {
            return "\u8b66\u8f66";
        }
        if (plate.indexOf("\u5b66") != -1) {
            return "\u6559\u7ec3\u8f66";
        }
        if (plate.indexOf(20351) != -1) {
            return "\u5927\u4f7f\u9986\u8f66";
        }
        if (plate.indexOf(39046) != -1) {
            return "\u9886\u4e8b\u9986\u8f66";
        }
        if (plate.charAt(1) == 'O') {
            return "O\u724c\u8f66";
        }
        if (plate.indexOf(28207) != -1) {
            return "\u9999\u6e2f\u724c\u8f66";
        }
        if (plate.indexOf(28595) != -1) {
            return "\u6fb3\u95e8\u724c\u8f66";
        }
        if (plate.length() == 8) {
            String p23 = plate.substring(2, 3);
            if (p23.equals("D") || p23.equals("A") || p23.equals("B") || p23.equals("C") || p23.equals("E")) {
                return "\u7eaf\u7535\u52a8\u5c0f\u8f66";
            }
            if (p23.equals("F") || p23.equals("G") || p23.equals("H") || p23.equals("J") || p23.equals("K")) {
                return "\u6df7\u52a8\u5c0f\u8f66";
            }
            if (plate.endsWith("D") || plate.endsWith("A") || plate.endsWith("B") || plate.endsWith("C") || plate.endsWith("E")) {
                return "\u7eaf\u7535\u52a8\u5927\u8f66";
            }
            if (plate.endsWith("F") || plate.endsWith("G") || plate.endsWith("H") || plate.endsWith("J") || plate.endsWith("K")) {
                return "\u6df7\u52a8\u5927\u8f66";
            }
            return "8\u4f4d\u6570\u8f66\u724c";
        }
        if (event != null) {
            String plateColor = "";
            String plateTypeDes = "";
            if (event.getPlateColor() != null && event.getPlateColor().length() > 0) {
                plateColor = event.getPlateColor();
            }
            if (event.getPlateTypeDes() != null && event.getPlateTypeDes().length() > 0) {
                plateTypeDes = event.getPlateTypeDes();
            }
            if (plateTypeDes != null && plateTypeDes.length() > 0) {
                if (plateTypeDes.indexOf("\u519b\u8f66") != -1) {
                    return "\u519b\u8f66";
                }
                if (plateTypeDes.indexOf("\u6b66\u8b66") != -1) {
                    return "\u6b66\u8b66\u8f66";
                }
                if (plateTypeDes.indexOf("\u8b66\u8f66") != -1) {
                    return "\u8b66\u8f66";
                }
                if (plateTypeDes.indexOf("\u6559\u7ec3") != -1) {
                    return "\u6559\u7ec3\u8f66";
                }
            }
            if (plateColor != null && plateColor.length() > 0) {
                if (plateColor.indexOf("\u767d") != -1) {
                    return "\u767d\u724c\u8f66";
                }
                if (plateColor.indexOf("\u9ec4") != -1) {
                    return "\u9ec4\u724c\u8f66";
                }
                if (plateColor.indexOf("\u9ed1") != -1) {
                    return "\u9ed1\u724c\u8f66";
                }
                if (plateColor.indexOf("\u7eff") != -1) {
                    return "\u7eff\u724c\u8f66";
                }
            }
        }
        return null;
    }

    public static CarparkPassport createTempDynCarparkPassport(String plate, boolean needqueryDefaultCarType, SqlSession session) {
        int arc;
        String vrese;
        CarparkPassport passport = new CarparkPassport();
        passport.setId(0L);
        passport.setPassport_no("0");
        passport.setCar_owner_no(null);
        passport.setPassport_number(plate);
        passport.setMedium_type(6);
        passport.setRegister_plate(plate);
        passport.setSurface_number(null);
        passport.setParking_space_no(null);
        passport.setIc_key(null);
        passport.setIc_sector(null);
        passport.setIc_as_id(0);
        passport.setPassport_state(0);
        passport.setDeadline(null);
        passport.setRemain_hours(0);
        passport.setNumber_times(0);
        passport.setBalance(new BigDecimal(0));
        passport.setCash_pledge(new BigDecimal(0));
        passport.setRemark(null);
        passport.setStart_date(null);
        passport.setStop_date(null);
        passport.setValid_date(null);
        passport.setForbid_online_pay(0);
        passport.setReg_source(0);
        passport.setVehicle_number(null);
        passport.setCreated_time(ServiceUtil.getNow());
        passport.setLast_updated_time(passport.getCreated_time());
        passport.setReg_time(passport.getCreated_time());
        passport.setProject_id(ServiceUtil.getServiceContext().getProjectId());
        Map<String, CarparkPassportType> vmap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        for (Map.Entry<String, CarparkPassportType> e : vmap.entrySet()) {
            if (e.getValue().getPassport_type_number() != 0) continue;
            passport.setPassport_type_no(e.getKey());
            break;
        }
        Map<String, CarparkCarType> cartypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        for (Map.Entry<String, CarparkCarType> e : cartypeMap.entrySet()) {
            if (e.getValue().getCar_type_number() != 0) continue;
            passport.setCar_type_no(e.getKey());
            break;
        }
        Object oTtype = PassChannel.getScriptDefineType(plate, null);
        if (oTtype == null) {
            oTtype = PassChannel.getCarTypeOrPlateType(plate, null);
        }
        if (oTtype != null) {
            if (oTtype instanceof CarparkPassportType) {
                CarparkPassportType t = (CarparkPassportType)oTtype;
                if (t.getPass_type() == 2 || t.getPass_type() == 1 || t.getPass_type() == 5 || t.getPass_type() == 0 && t.getUse_muti_car() == 1) {
                    t = null;
                }
                if (t != null) {
                    passport.setPassport_type_no(t.getPassport_type_no());
                }
            } else if (oTtype instanceof CarparkCarType) {
                passport.setCar_type_no(((CarparkCarType)oTtype).getCar_type_no());
            }
        }
        if ((vrese = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("MEND_CAR_TYPE_MERMERY_DAYS")) == null || vrese.length() == 0) {
            vrese = "180";
        }
        try {
            arc = Integer.parseInt(vrese);
            if (arc < 0) {
                arc = 0;
            } else if (arc > 365) {
                arc = 365;
            }
        }
        catch (Exception ex) {
            arc = 0;
        }
        if (needqueryDefaultCarType && arc > 0 && passport.getRegister_plate() != null && passport.getRegister_plate().length() > 0) {
            CarparkCarType t;
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Pagination p = new Pagination();
            p.setNeedQueryCount(false);
            p.setRecordsCount(1L);
            p.setPageSize(1);
            p.setGotoPage(1);
            Calendar cl1 = Calendar.getInstance();
            cl1.set(14, 0);
            cl1.add(6, 0 - arc);
            SearchParam sp = new SearchParam().setQueryFields(new String[]{"car_type_no", "id"}).addEQ("plate_number", (Object)passport.getRegister_plate()).addGT("last_updated_time", (Object)cl1.getTime()).setOrerbySql("id DESC");
            CarparkPlateCarType type = session == null ? (CarparkPlateCarType)commonDaoService.selectOne(sp, CarparkPlateCarType.class, p) : (CarparkPlateCarType)commonDaoService.selectOne(session, sp, CarparkPlateCarType.class, p);
            if (type != null && type.getCar_type_no() != null && type.getCar_type_no().length() > 0 && (t = cartypeMap.get(type.getCar_type_no())) != null) {
                passport.setCar_type_no(type.getCar_type_no());
            }
        }
        return passport;
    }

    private CarparkPassport createTempDynCarparkPassport(PassSession session) {
        CarparkCarType t;
        String xfv;
        int arc;
        String vrese;
        String plate;
        CarparkPassport passport = new CarparkPassport();
        passport.setId(0L);
        passport.setPassport_no("0");
        passport.setCar_owner_no(null);
        passport.setPassport_number(session.getReadPassportNumberEvent().getPassportNumber());
        passport.setMedium_type(session.getReadPassportNumberEvent().getPassportMediumType());
        if (session.getReadPassportNumberEvent().getPassportMediumType() == 6) {
            passport.setRegister_plate(session.getReadPassportNumberEvent().getPassportNumber());
        } else if (session.getPlateRecognizedEvent() != null) {
            passport.setRegister_plate(session.getPlateRecognizedEvent().getPlateNumber());
        } else if (session.getReadPassportNumberEvent().getPlateNumber() != null && session.getReadPassportNumberEvent().getPlateNumber().length() > 0) {
            passport.setRegister_plate(session.getReadPassportNumberEvent().getPlateNumber());
        }
        passport.setSurface_number(null);
        passport.setParking_space_no(null);
        passport.setIc_key(null);
        passport.setIc_sector(null);
        passport.setIc_as_id(0);
        passport.setPassport_state(0);
        passport.setDeadline(null);
        passport.setRemain_hours(0);
        passport.setNumber_times(0);
        passport.setBalance(new BigDecimal(0));
        passport.setCash_pledge(new BigDecimal(0));
        passport.setRemark(null);
        passport.setStart_date(null);
        passport.setStop_date(null);
        passport.setValid_date(null);
        passport.setForbid_online_pay(0);
        if (session.getPlateRecognizedEvent() != null) {
            if (session.getPlateRecognizedEvent().getVehicleColor() != null) {
                passport.setCar_color(session.getPlateRecognizedEvent().getVehicleColor());
            }
            if (session.getPlateRecognizedEvent().getCarLogo() != null) {
                passport.setCar_logo(session.getPlateRecognizedEvent().getCarLogo());
            }
        }
        passport.setReg_source(0);
        passport.setVehicle_number(null);
        passport.setCreated_time(ServiceUtil.getNow());
        passport.setLast_updated_time(passport.getCreated_time());
        passport.setReg_time(passport.getCreated_time());
        passport.setProject_id(ServiceUtil.getServiceContext().getProjectId());
        passport.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
        CarparkPassportType carparkPassportType = PassChannel.getTempPassportType(this.getChannelNo(), passport.getPassport_number(), passport.getMedium_type());
        if (carparkPassportType != null) {
            passport.setPassport_type_no(carparkPassportType.getPassport_type_no());
        }
        Map<String, CarparkCarType> cartypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        for (Map.Entry<String, CarparkCarType> e : cartypeMap.entrySet()) {
            if (e.getValue().getCar_type_number() != 0) continue;
            passport.setCar_type_no(e.getKey());
            break;
        }
        Object oTtype = null;
        if (session.getReadPassportNumberEvent() != null && !session.getReadPassportNumberEvent().isUserScan() && (oTtype = PassChannel.getScriptDefineType(plate = session.getPassPlate(), null)) == null) {
            oTtype = PassChannel.getCarTypeOrPlateType(plate, session.getPlateRecognizedEvent());
        }
        if (oTtype != null) {
            if (oTtype instanceof CarparkPassportType) {
                CarparkPassportType t2 = (CarparkPassportType)oTtype;
                if (t2.getPass_type() == 2 || t2.getPass_type() == 1 || t2.getPass_type() == 5 || t2.getPass_type() == 0 && t2.getUse_muti_car() == 1) {
                    t2 = null;
                }
                if (t2 != null) {
                    passport.setPassport_type_no(t2.getPassport_type_no());
                }
            } else if (oTtype instanceof CarparkCarType) {
                passport.setCar_type_no(((CarparkCarType)oTtype).getCar_type_no());
            }
        }
        if ((vrese = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("MEND_CAR_TYPE_MERMERY_DAYS")) == null || vrese.length() == 0) {
            vrese = "180";
        }
        try {
            arc = Integer.parseInt(vrese);
            if (arc < 0) {
                arc = 0;
            } else if (arc > 365) {
                arc = 365;
            }
        }
        catch (Exception ex) {
            arc = 0;
        }
        boolean findSeted = false;
        if (arc > 0 && passport.getRegister_plate() != null && passport.getRegister_plate().length() > 0) {
            CarparkCarType t3;
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Pagination p = new Pagination();
            p.setNeedQueryCount(false);
            p.setRecordsCount(1L);
            p.setPageSize(1);
            p.setGotoPage(1);
            Calendar cl1 = Calendar.getInstance();
            cl1.set(14, 0);
            cl1.add(6, 0 - arc);
            CarparkPlateCarType type = (CarparkPlateCarType)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"car_type_no", "id"}).addEQ("plate_number", (Object)passport.getRegister_plate()).addGT("last_updated_time", (Object)cl1.getTime()).setOrerbySql("id DESC"), CarparkPlateCarType.class, p);
            if (type != null && type.getCar_type_no() != null && type.getCar_type_no().length() > 0 && (t3 = cartypeMap.get(type.getCar_type_no())) != null) {
                passport.setCar_type_no(type.getCar_type_no());
                findSeted = true;
            }
        }
        if (!(findSeted || session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(session.getReadPassportNumberEvent().getPassportNumber()) || session.getPlateRecognizedEvent() == null || session.getPlateRecognizedEvent().getPlateColor() == null || session.getPlateRecognizedEvent().getPlateColor().length() <= 0 || session.getPlateRecognizedEvent().getPlateColor().indexOf(40644) == -1 || (xfv = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("YELLOW_PLATE_CAR_TYPE")) == null || xfv.length() <= 0 || (t = cartypeMap.get(xfv)) == null)) {
            passport.setCar_type_no(t.getCar_type_no());
        }
        if (passport.getCar_type_no() != null) {
            session.setAttribute("DEFAULT_SYSTEM_TEMP_CARTYPE_NO", passport.getCar_type_no());
        }
        return passport;
    }

    public static CarparkCarType getTimepDynCarType() {
        Map<String, CarparkCarType> cartypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        for (Map.Entry<String, CarparkCarType> e : cartypeMap.entrySet()) {
            if (e.getValue().getCar_type_number() != 0) continue;
            return e.getValue();
        }
        return null;
    }

    public static CarparkPassportType getTempPassportType(String channelNo, String passportNumber, Integer mediaType) {
        if (mediaType != null && mediaType == 1 && passportNumber != null && passportNumber.length() > 0 && channelNo != null && channelNo.length() > 0) {
            CarparkPassportType p;
            String sv;
            boolean isScan;
            boolean bl = isScan = passportNumber.startsWith("wx-") || passportNumber.startsWith("WX_") || passportNumber.startsWith("AL_") || passportNumber.startsWith("al-");
            if (isScan && (sv = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_SCAN_PASSPORT_TEMP_TYPE_NO")) != null && sv.length() > 0 && (p = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(sv)) != null && p.getPass_type() == 0 && p.getUse_muti_car() == 0) {
                return p;
            }
        }
        return PassChannel.getTempDynPassportType();
    }

    public static CarparkPassportType getTempDynPassportType() {
        Map<String, CarparkPassportType> vmap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        for (Map.Entry<String, CarparkPassportType> e : vmap.entrySet()) {
            if (e.getValue().getPassport_type_number() != 0) continue;
            return e.getValue();
        }
        return null;
    }

    public static PassVo getPassVo(String plateNumber, SqlSession sqlSession, Date passTime) {
        CarparkPassportType passportType;
        if (plateNumber == null || plateNumber.length() == 0) {
            return null;
        }
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam sp = new SearchParam().addEQ("project_id", (Object)ServiceUtil.getServiceContext().getProjectId()).addEQ("passport_number", (Object)plateNumber).addEQ("medium_type", (Object)6).setOrerbySql("created_time DESC");
        CarparkPassport passport = sqlSession == null ? (CarparkPassport)daoService.selectOne(sp, CarparkPassport.class) : (CarparkPassport)daoService.selectOne(sqlSession, sp, CarparkPassport.class);
        if (passport == null) {
            passport = PassChannel.createTempDynCarparkPassport(plateNumber, true, sqlSession);
        } else {
            passportType = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(passport.getPassport_type_no());
            if (passportType == null) {
                ServiceLog.getLog().warn((Object)("\u6ce8\u518c\u8f66\u724c\u7684\u8f66\u724c/\u5361\u7c7b\u578b\u65e0\u6cd5\u627e\u5230! \u7f16\u53f7:" + passport.getPassport_type_no() + ",\u6ce8\u518c\u8f66\u724c\uff1a" + passport.getRegister_plate()));
                passport = PassChannel.createTempDynCarparkPassport(plateNumber, true, sqlSession);
            }
        }
        passportType = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(passport.getPassport_type_no());
        CarparkCarType carType = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().get(passport.getCar_type_no());
        if (carType == null) {
            carType = PassChannel.getTimepDynCarType();
        }
        CarparkCarOwner carOwner = null;
        if (passport.getCar_owner_no() != null && passport.getCar_owner_no().length() > 0) {
            sp = new SearchParam().addEQ("project_id", (Object)ServiceUtil.getServiceContext().getProjectId()).addEQ("car_owner_no", (Object)passport.getCar_owner_no());
            carOwner = sqlSession == null ? (CarparkCarOwner)daoService.selectOne(sp, CarparkCarOwner.class) : (CarparkCarOwner)daoService.selectOne(sqlSession, sp, CarparkCarOwner.class);
        }
        if (passportType != null && passTime != null) {
            boolean isNotStart = false;
            boolean isStop = false;
            if (passportType.getPass_type() == 2) {
                CarparkPassportType passportType1;
                isNotStart = passport.getStart_date() != null && passport.getStart_date().after(passTime);
                boolean bl = isStop = passport.getPassport_state() == 2 && passport.getStop_date() != null && passport.getStop_date().before(passTime);
                if ((isNotStart || isStop) && (passportType1 = PassChannel.getTempDynPassportType()) != null) {
                    passport.setPassport_type_no(passportType1.getPassport_type_no());
                    passportType = passportType1;
                }
            }
        }
        PassVo vo = new PassVo();
        vo.setCarOwner(carOwner);
        vo.setCarType(carType);
        vo.setPassport(passport);
        vo.setPassportType(passportType);
        return vo;
    }

    public boolean isSwipeCard(PassSession session) {
        return session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().getDetectedPassEvent() != null && (session.getReadPassportNumberEvent().getDetectedPassEvent().getMediaType() == DetectedPassEvent.MediaType.IC || session.getReadPassportNumberEvent().getDetectedPassEvent().getMediaType() == DetectedPassEvent.MediaType.ID);
    }

    /*
     * WARNING - void declaration
     */
    public void doStartSession(PassSession session) throws Throwable {
        CarparkPresenceRecord occupyChargeRecord;
        CarparkPresenceRecord changePassTypeRecord;
        AbstractList existMutiCarEnterRecords;
        ArrayList<CarparkArea> exitAreaList;
        CarparkArea exitArea;
        LinkedHashMap<String, CarparkPresenceRecord> areaPresenceRecordMap;
        ChannelArea channelArea;
        CarparkCarOwner carOwner;
        boolean isBlackList;
        boolean isStop;
        boolean isNotStart;
        Date passTime;
        CarparkPassportType passportType;
        CarparkPassport passport;
        block187: {
            block188: {
                VehicleTypeEvent vehicleTypeEvent;
                block189: {
                    String string;
                    void var25_76;
                    CarparkCarType carparkCarType;
                    CarparkCarType carparkCarType2;
                    session.setDsiplay1MsgWhenMoney(null);
                    ScheduledFuture<?> sss = session.getReDisplayPayMsg1Task();
                    if (sss != null) {
                        try {
                            sss.cancel(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        session.setReDisplayPayMsg1Task(null);
                    }
                    session.removeAttribute("NO_ENTRY_MARCH_RECORD");
                    session.setAllowPassExcetpions(new CopyOnWriteArraySet<Integer>());
                    session.setForbidPassExceptions(new CopyOnWriteArraySet<Integer>());
                    session.setConfirmPassExceptions(new CopyOnWriteArraySet<Integer>());
                    Integer project_id = ServiceUtil.getServiceContext().getProjectId();
                    Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    boolean isInputPlate = false;
                    if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(session.getReadPassportNumberEvent().getPassportNumber())) {
                        isInputPlate = true;
                    }
                    if (session.getAttribute("DEFAULT_SYSTEM_TEMP_CARTYPE_NO") != null) {
                        session.removeAttribute("DEFAULT_SYSTEM_TEMP_CARTYPE_NO");
                    }
                    boolean userScan = false;
                    boolean forceTemp = false;
                    boolean isSwipeCard = this.isSwipeCard(session);
                    if (session.getReadPassportNumberEvent() != null) {
                        userScan = session.getReadPassportNumberEvent().isUserScan();
                        forceTemp = session.getReadPassportNumberEvent().isForceTemp();
                    }
                    if (isInputPlate) {
                        passport = null;
                    } else if (isSwipeCard) {
                        passport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("passport_number", (Object)session.getReadPassportNumberEvent().getPassportNumber()).addEQ("medium_type", (Object)session.getReadPassportNumberEvent().getPassportMediumType()).setOrerbySql("created_time DESC"), CarparkPassport.class);
                        if (passport == null) {
                            session.getForbidPassExceptions().add(1);
                            DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                            try {
                                if (this.getLanConnectManageHostState() == null) {
                                    displayVoiceService.unRegisterCard(session);
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                            }
                            session.setSessionState(PassSession.SessionState.CANCELED);
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(this.channel.getChannel_name()) + "\uff1a\u5361\u53f7\u3010" + session.getReadPassportNumberEvent().getPassportNumber() + "\u3011\u672a\u6ce8\u518c", 4));
                            return;
                        }
                    } else if (userScan) {
                        if (session.getReadPassportNumberEvent().getPlateNumber() != null && session.getReadPassportNumberEvent().getPlateNumber().length() > 0) {
                            if (forceTemp) {
                                passport = null;
                            } else {
                                passport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("passport_number", (Object)session.getReadPassportNumberEvent().getPlateNumber()).addEQ("medium_type", (Object)6).setOrerbySql("created_time DESC"), CarparkPassport.class);
                                if (passport != null) {
                                    passport.setPassport_number(session.getReadPassportNumberEvent().getPassportNumber());
                                    passport.setMedium_type(session.getReadPassportNumberEvent().getPassportMediumType());
                                }
                            }
                        } else {
                            passport = null;
                        }
                    } else {
                        passport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("passport_number", (Object)session.getReadPassportNumberEvent().getPassportNumber()).addEQ("medium_type", (Object)session.getReadPassportNumberEvent().getPassportMediumType()).setOrerbySql("created_time DESC"), CarparkPassport.class);
                        if (passport == null && session.getReadPassportNumberEvent().getPassportMediumType() == 6) {
                            passport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("register_plate", (Object)session.getReadPassportNumberEvent().getPassportNumber()).setOrerbySql("created_time DESC"), CarparkPassport.class);
                        }
                        if (passport == null) {
                            try {
                                String strv;
                                if (!session.getReadPassportNumberEvent().isManualTrigger() && session.getReadPassportNumberEvent().getPlateNumber() != null && session.getReadPassportNumberEvent().getPassportMediumType() == 6 && session.getPlateRecognizedEvent() != null && session.getReadPassportNumberEvent().getPlateNumber().equals(session.getPlateRecognizedEvent().getPlateNumber()) && (strv = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(session.getPassChannel().getChannelNo(), "CHANNEL_PLATE_LIKE")) != null && strv.length() > 0) {
                                    KeyValueEntry<CarparkPassport, Integer> en;
                                    String regPlate;
                                    if ("1".equals(strv)) {
                                        List plist;
                                        regPlate = session.getPlateRecognizedEvent().getPlateNumber();
                                        String first = regPlate.substring(0, 1);
                                        String last = regPlate.substring(1);
                                        if (first.getBytes("GBK").length == 2 && (plist = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addLeftLike("passport_number", last).addEQ("medium_type", (Object)6), CarparkPassport.class, null)) != null && !plist.isEmpty()) {
                                            PriorityQueue<KeyValueEntry<CarparkPassport, Integer>> pq = new PriorityQueue<KeyValueEntry<CarparkPassport, Integer>>(10, new Comparator<KeyValueEntry<CarparkPassport, Integer>>(){

                                                @Override
                                                public int compare(KeyValueEntry<CarparkPassport, Integer> o1, KeyValueEntry<CarparkPassport, Integer> o2) {
                                                    int ax = ((Integer)o1.getValue()).compareTo((Integer)o2.getValue());
                                                    if (ax == 0) {
                                                        return ((CarparkPassport)o1.getKey()).getId().compareTo(((CarparkPassport)o2.getKey()).getId());
                                                    }
                                                    return ax;
                                                }
                                            });
                                            for (CarparkPassport ax : plist) {
                                                if (ax.getPassport_number().length() == regPlate.length()) {
                                                    pq.offer((KeyValueEntry<CarparkPassport, Integer>)new KeyValueEntry((Object)ax, (Object)0));
                                                    continue;
                                                }
                                                if (!last.equals(ax.getPassport_number())) continue;
                                                pq.offer((KeyValueEntry<CarparkPassport, Integer>)new KeyValueEntry((Object)ax, (Object)1));
                                            }
                                            if (!pq.isEmpty() && (en = pq.poll()) != null && (passport = (CarparkPassport)en.getKey()) != null) {
                                                session.getReadPassportNumberEvent().setPassportNumber(passport.getPassport_number());
                                                session.getReadPassportNumberEvent().setPassportMediumType(passport.getMedium_type());
                                                session.getReadPassportNumberEvent().setPlateNumber(passport.getRegister_plate());
                                            }
                                        }
                                    } else if ("2".equals(strv)) {
                                        regPlate = session.getPlateRecognizedEvent().getPlateNumber();
                                        List plist = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("medium_type", (Object)6).setQueryFields(new String[]{"id", "passport_number"}), CarparkPassport.class, null);
                                        if (plist != null && !plist.isEmpty()) {
                                            PriorityQueue<KeyValueEntry<CarparkPassport, Integer>> pq = new PriorityQueue<KeyValueEntry<CarparkPassport, Integer>>(10, new Comparator<KeyValueEntry<CarparkPassport, Integer>>(){

                                                @Override
                                                public int compare(KeyValueEntry<CarparkPassport, Integer> o1, KeyValueEntry<CarparkPassport, Integer> o2) {
                                                    int ax = ((Integer)o1.getValue()).compareTo((Integer)o2.getValue());
                                                    if (ax == 0) {
                                                        return ((CarparkPassport)o1.getKey()).getId().compareTo(((CarparkPassport)o2.getKey()).getId());
                                                    }
                                                    return ax;
                                                }
                                            });
                                            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                                            String first = regPlate.substring(0, 1);
                                            for (CarparkPassport p : plist) {
                                                if (!applicationService.plateEquals(regPlate, p.getPassport_number(), 1)) continue;
                                                if (!p.getPassport_number().substring(0, 1).equals(first)) {
                                                    pq.add((KeyValueEntry<CarparkPassport, Integer>)new KeyValueEntry((Object)p, (Object)0));
                                                    continue;
                                                }
                                                pq.add((KeyValueEntry<CarparkPassport, Integer>)new KeyValueEntry((Object)p, (Object)1));
                                            }
                                            if (!pq.isEmpty() && (en = pq.poll()) != null && (passport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)((CarparkPassport)en.getKey()).getId()), CarparkPassport.class)) != null) {
                                                session.getReadPassportNumberEvent().setPassportNumber(passport.getPassport_number());
                                                session.getReadPassportNumberEvent().setPassportMediumType(passport.getMedium_type());
                                                session.getReadPassportNumberEvent().setPlateNumber(passport.getRegister_plate());
                                            }
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)("\u6a21\u7cca\u5339\u914d\u7b97\u6cd5\u5f02\u5e38\uff01" + ex));
                            }
                        }
                    }
                    if (passport == null) {
                        passport = this.createTempDynCarparkPassport(session);
                        session.setDatabasePassport(null);
                    } else {
                        passportType = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(passport.getPassport_type_no());
                        if (passportType == null) {
                            ServiceLog.getLog().warn((Object)("\u6ce8\u518c\u8f66\u724c\u7684\u8f66\u724c/\u5361\u7c7b\u578b\u65e0\u6cd5\u627e\u5230! \u7f16\u53f7:" + passport.getPassport_type_no() + ",\u6ce8\u518c\u8f66\u724c\uff1a" + passport.getRegister_plate()));
                            passport = this.createTempDynCarparkPassport(session);
                            session.setDatabasePassport(null);
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(new InformationEvent(this, "\u6ce8\u518c\u8f66\u724c\u7684\u8f66\u724c/\u5361\u7c7b\u578b\u65e0\u6cd5\u627e\u5230\uff01\u8fd9\u5c06\u4f7f\u7528\u4e34\u505c\u8f66\u653e\u884c\uff01\u6ce8\u518c\u8f66\u724c\uff1a" + passport.getRegister_plate(), 3));
                        } else {
                            session.setDatabasePassport(passport.clone());
                        }
                    }
                    session.setPassport(passport);
                    passportType = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(passport.getPassport_type_no());
                    if (passportType == null) {
                        throw new IllegalStateException("\u65e0\u6cd5\u627e\u5230\u901a\u884c\u8bc1\u7c7b\u578b\uff0c\u7f16\u53f7:" + passport.getPassport_type_no());
                    }
                    if (session.getDatabasePassport() != null) {
                        session.setDatabasePassportType(passportType);
                    } else {
                        session.setDatabasePassportType(null);
                    }
                    passTime = null;
                    if (session.getAttribute("GUI_CONFIRM") != null || session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null) {
                        passTime = (Date)session.getAttribute("passTime");
                    }
                    if (passTime == null) {
                        Calendar cl = Calendar.getInstance();
                        cl.set(14, 0);
                        passTime = cl.getTime();
                    }
                    isNotStart = false;
                    isStop = false;
                    if (passportType.getPass_type() == 2) {
                        isNotStart = passport.getStart_date() != null && passport.getStart_date().after(passTime);
                        boolean bl = isStop = passport.getPassport_state() == 2 && passport.getStop_date() != null && passport.getStop_date().before(passTime);
                        if (isNotStart || isStop) {
                            if (isSwipeCard) {
                                session.getForbidPassExceptions().add(isNotStart ? 7 : 8);
                                DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                                try {
                                    if (this.getLanConnectManageHostState() == null) {
                                        if (isNotStart) {
                                            displayVoiceService.monthCardNotStarted(session);
                                        } else {
                                            displayVoiceService.monthCardStopped(session);
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                                }
                                session.setSessionState(PassSession.SessionState.CANCELED);
                                String txt = isNotStart ? "\u6708\u5361\u672a\u542f\u7528\u3010" + passport.getPassport_number() + "\u3011" : "\u6708\u5361\u5df2\u505c\u7528\u3010" + passport.getPassport_number() + "\u3011";
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(this.channel.getChannel_name()) + "\uff1a" + txt + "\u7981\u6b62\u901a\u884c\uff01", 4));
                                return;
                            }
                            passportType = PassChannel.getTempPassportType(this.getChannelNo(), passport.getPassport_number(), passport.getMedium_type());
                            if (passportType == null) {
                                throw new IllegalStateException("\u65e0\u6cd5\u627e\u5230\u4e34\u65f6\u901a\u884c\u8bc1\u7c7b\u578b\uff0c\u6570\u636e\u5b58\u5728\u4e22\u5931\uff1f\u8bf7\u68c0\u67e5!");
                            }
                            passport.setPassport_type_no(passportType.getPassport_type_no());
                        }
                    }
                    session.setPassportType(passportType);
                    isBlackList = false;
                    if (passport.getPassport_state() != null && passport.getPassport_state() == 1) {
                        if (session.getReadPassportNumberEvent().isManualTrigger() || session.getAttribute("GUI_CONFIRM") != null || session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null) {
                            isBlackList = true;
                        } else {
                            session.getForbidPassExceptions().add(6);
                            DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                            try {
                                if (this.getLanConnectManageHostState() == null) {
                                    displayVoiceService.blacklistCar(session);
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                            }
                            session.setSessionState(PassSession.SessionState.CANCELED);
                            String txt = isSwipeCard ? "\u9ed1\u540d\u5355\u5361\uff0c\u6216\u5df2\u6302\u5931\u3010" + passport.getPassport_number() + "\u3011" : "\u9ed1\u540d\u5355\u8f66\u3010" + passport.getRegister_plate() + "\u3011";
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(this.channel.getChannel_name()) + "\uff1a" + txt + "\u7981\u6b62\u901a\u884c\uff01", 4));
                            return;
                        }
                    }
                    carOwner = null;
                    if (passport.getCar_owner_no() != null && passport.getCar_owner_no().length() > 0) {
                        carOwner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().addEQ("project_id", (Object)project_id).addEQ("car_owner_no", (Object)passport.getCar_owner_no()), CarparkCarOwner.class);
                    }
                    if ((channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(this.getChannelNo())) == null) {
                        throw new IllegalStateException("\u6ca1\u6709\u627e\u5230\u901a\u9053\uff0c\u7f16\u53f7:" + this.getChannelNo() + "," + this.getChannel().getChannel_name() + " \u6240\u5c5e\u533a\u57df\u3002\u3002\u3002");
                    }
                    areaPresenceRecordMap = new LinkedHashMap<String, CarparkPresenceRecord>();
                    if (!isInputPlate) {
                        SearchParam preseceRecordParam = new SearchParam().addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).addEQ("medium_type", (Object)passport.getMedium_type());
                        if (session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber() != null && session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber().length() > 0) {
                            preseceRecordParam.addEQ("passport_number", (Object)session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber());
                        } else {
                            preseceRecordParam.addEQ("passport_number", (Object)passport.getPassport_number());
                        }
                        preseceRecordParam.setOrerbySql("enter_time,area_level");
                        LinkedList presenceRecordList = commonDaoService.selectList(preseceRecordParam, CarparkPresenceRecord.class, null);
                        if (presenceRecordList == null) {
                            presenceRecordList = new LinkedList();
                        }
                        if (!presenceRecordList.isEmpty()) {
                            for (CarparkPresenceRecord r : presenceRecordList) {
                                if (r.getEnter_time() == null || r.getExit_time() != null) continue;
                                areaPresenceRecordMap.put(r.getArea_no(), r);
                            }
                        }
                    }
                    exitArea = null;
                    if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                        List<CarparkArea> areaList = channelArea.getExitAreas();
                        boolean hasExitRcord = false;
                        if (!areaPresenceRecordMap.isEmpty()) {
                            for (CarparkArea area : areaList) {
                                if (!areaPresenceRecordMap.containsKey(area.getArea_no())) continue;
                                hasExitRcord = true;
                                break;
                            }
                        }
                        if (!hasExitRcord && !isInputPlate) {
                            SearchParam preseceRecordParam;
                            if (passport.getMedium_type() == 6) {
                                preseceRecordParam = new SearchParam().addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id);
                                if (session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber() != null && session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber().length() > 0) {
                                    preseceRecordParam.addEQ("enter_plate", (Object)session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber());
                                } else {
                                    preseceRecordParam.addEQ("enter_plate", (Object)passport.getPassport_number());
                                }
                                preseceRecordParam.addEQ("medium_type", (Object)1);
                                preseceRecordParam.setOrerbySql("enter_time,area_level");
                                List presenceRecordList = commonDaoService.selectList(preseceRecordParam, CarparkPresenceRecord.class, null);
                                if (presenceRecordList != null && !presenceRecordList.isEmpty()) {
                                    HashMap<String, LinkedList<CarparkPresenceRecord>> zlistMap = new HashMap<String, LinkedList<CarparkPresenceRecord>>();
                                    for (CarparkPresenceRecord carparkPresenceRecord : presenceRecordList) {
                                        if (carparkPresenceRecord.getPassport_number() == null || carparkPresenceRecord.getPassport_number().length() <= 0 || carparkPresenceRecord.getEnter_time() == null || carparkPresenceRecord.getExit_time() != null) continue;
                                        LinkedList<CarparkPresenceRecord> l = (LinkedList<CarparkPresenceRecord>)zlistMap.get(carparkPresenceRecord.getPassport_number());
                                        if (l == null) {
                                            l = new LinkedList<CarparkPresenceRecord>();
                                            zlistMap.put(carparkPresenceRecord.getPassport_number(), l);
                                        }
                                        l.add(carparkPresenceRecord);
                                    }
                                    if (!zlistMap.isEmpty()) {
                                        for (Map.Entry entry : zlistMap.entrySet()) {
                                            boolean foundExitArea = false;
                                            for (CarparkPresenceRecord r : (List)entry.getValue()) {
                                                for (CarparkArea carparkArea : areaList) {
                                                    if (!carparkArea.getArea_no().equals(r.getArea_no())) continue;
                                                    foundExitArea = true;
                                                    break;
                                                }
                                                if (foundExitArea) break;
                                            }
                                            if (!foundExitArea) continue;
                                            passport.setMedium_type(1);
                                            passport.setPassport_number((String)entry.getKey());
                                            areaPresenceRecordMap.clear();
                                            for (CarparkPresenceRecord r : (List)entry.getValue()) {
                                                areaPresenceRecordMap.put(r.getArea_no(), r);
                                            }
                                            break;
                                        }
                                    }
                                }
                            } else if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isUserScan() && session.getReadPassportNumberEvent().getPlateNumber() != null && session.getReadPassportNumberEvent().getPlateNumber().length() > 0) {
                                String queryPlate;
                                preseceRecordParam = new SearchParam().addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id);
                                if (session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber() != null && session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber().length() > 0) {
                                    queryPlate = session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber();
                                    preseceRecordParam.addEQ("enter_plate", (Object)queryPlate);
                                } else {
                                    queryPlate = session.getReadPassportNumberEvent().getPlateNumber();
                                    preseceRecordParam.addEQ("enter_plate", (Object)queryPlate);
                                }
                                preseceRecordParam.setOrerbySql("enter_time,area_level");
                                List presenceRecordList = commonDaoService.selectList(preseceRecordParam, CarparkPresenceRecord.class, null);
                                if (presenceRecordList != null && !presenceRecordList.isEmpty()) {
                                    HashMap<String, LinkedList<CarparkPresenceRecord>> hashMap = new HashMap<String, LinkedList<CarparkPresenceRecord>>();
                                    for (CarparkPresenceRecord carparkPresenceRecord : presenceRecordList) {
                                        if (carparkPresenceRecord.getPassport_number() == null || carparkPresenceRecord.getPassport_number().length() <= 0 || carparkPresenceRecord.getEnter_time() == null || carparkPresenceRecord.getExit_time() != null) continue;
                                        LinkedList<CarparkPresenceRecord> l = (LinkedList<CarparkPresenceRecord>)hashMap.get(carparkPresenceRecord.getPassport_number());
                                        if (l == null) {
                                            l = new LinkedList<CarparkPresenceRecord>();
                                            hashMap.put(carparkPresenceRecord.getPassport_number(), l);
                                        }
                                        l.add(carparkPresenceRecord);
                                    }
                                    if (!hashMap.isEmpty()) {
                                        for (String string2 : hashMap.keySet()) {
                                            String v1;
                                            if (string2.equals(queryPlate) || (v1 = Constants.getScanName(string2)) == null || v1.length() <= 0) continue;
                                            String v2 = Constants.getScanName(session.getReadPassportNumberEvent().getPassportNumber());
                                            if (!v1.equals(v2)) {
                                                session.getReadPassportNumberEvent().triggerPassError("\u8f66\u724c\u53f7 " + session.getReadPassportNumberEvent().getPlateNumber() + " \u5165\u573a\u65f6\u4f7f\u7528" + v1 + "\u626b\u4e00\u626b\uff01\u79bb\u573a\u4e5f\u8bf7\u4f7f\u7528 " + v1 + "\u626b\u4e00\u626b");
                                                session.setSessionState(PassSession.SessionState.CANCELED);
                                                return;
                                            }
                                            session.getReadPassportNumberEvent().triggerPassError("\u8f66\u724c\u53f7 " + session.getReadPassportNumberEvent().getPlateNumber() + " \u7ed1\u5b9a\u7684" + v2 + "\u53f7\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u60a8\u5165\u573a\u65f6\u767b\u5f55\u5fae\u4fe1\u53f7\u91cd\u65b0\u626b\u4e00\u626b\uff01");
                                            session.setSessionState(PassSession.SessionState.CANCELED);
                                            return;
                                        }
                                        for (Map.Entry entry : hashMap.entrySet()) {
                                            boolean foundExitArea = false;
                                            for (CarparkPresenceRecord r : (List)entry.getValue()) {
                                                for (CarparkArea area : areaList) {
                                                    if (!area.getArea_no().equals(r.getArea_no())) continue;
                                                    foundExitArea = true;
                                                    break;
                                                }
                                                if (foundExitArea) break;
                                            }
                                            if (!foundExitArea) continue;
                                            areaPresenceRecordMap.clear();
                                            for (CarparkPresenceRecord r : (List)entry.getValue()) {
                                                passport.setMedium_type(r.getMedium_type());
                                                passport.setPassport_number(r.getPassport_number());
                                                areaPresenceRecordMap.put(r.getArea_no(), r);
                                            }
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        if (!isInputPlate) {
                            boolean hasOutExitRcord = false;
                            LinkedList<String> outAreaNoList = null;
                            for (CarparkArea area : areaList) {
                                if (area.getArea_level() != 1) continue;
                                if (outAreaNoList == null) {
                                    outAreaNoList = new LinkedList<String>();
                                }
                                outAreaNoList.add(area.getArea_no());
                                if (!areaPresenceRecordMap.containsKey(area.getArea_no())) continue;
                                hasOutExitRcord = true;
                            }
                            if (outAreaNoList != null && !outAreaNoList.isEmpty() && passportType != null && !hasOutExitRcord) {
                                int n;
                                int filterPassRecordHours = 0;
                                boolean bl = false;
                                String string3 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "PASSTYPE_NOENTRY_FILTER_HOUS");
                                String va2 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "PASSTYPE_NOENTRY_MATCH_MINS");
                                if (string3 != null && string3.length() > 0 && va2 != null && va2.length() > 0) {
                                    try {
                                        filterPassRecordHours = Integer.parseInt(string3);
                                        n = Integer.parseInt(va2);
                                    }
                                    catch (Exception foundExitArea) {
                                        // empty catch block
                                    }
                                }
                                if (filterPassRecordHours > 0 && n > 0) {
                                    long x;
                                    if (filterPassRecordHours > 8760) {
                                        filterPassRecordHours = 8760;
                                    }
                                    Calendar cl = Calendar.getInstance();
                                    cl.setTime(passTime);
                                    cl.add(11, 0 - filterPassRecordHours);
                                    Date beginTime = cl.getTime();
                                    SearchParam searchParam = new SearchParam().addGTE("pass_time", (Object)beginTime).addLT("pass_time", (Object)passTime).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).addEQ("medium_type", (Object)passport.getMedium_type());
                                    if (outAreaNoList.size() == 1) {
                                        searchParam.addEQ("area_no", outAreaNoList.get(0));
                                    } else {
                                        searchParam.addINList("area_no", outAreaNoList);
                                    }
                                    if (session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber() != null && session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber().length() > 0) {
                                        searchParam.addEQ("passport_number", (Object)session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber());
                                    } else {
                                        searchParam.addEQ("passport_number", (Object)passport.getPassport_number());
                                    }
                                    searchParam.setOrerbySql("pass_time DESC");
                                    Pagination pagination = new Pagination();
                                    pagination.setNeedQueryCount(false);
                                    pagination.setRecordsCount(1L);
                                    pagination.setGotoPage(1);
                                    pagination.setPageSize(1);
                                    CarparkPassRecord passRecord = (CarparkPassRecord)commonDaoService.selectOne(searchParam, CarparkPassRecord.class, pagination);
                                    if (passRecord != null && passRecord.getExit_time() != null && passRecord.getEnter_time() != null && (passRecord.getExit_reg_plate() != null && passRecord.getExit_reg_plate().length() > 0 || passRecord.getExit_obu_plate() != null && passRecord.getExit_obu_plate().length() > 0 || passRecord.getExit_plate_source() != null && passRecord.getExit_plate_source() == 5) && (x = passRecord.getExit_time().getTime() - passRecord.getEnter_time().getTime()) > 0L && x <= TimeUnit.MINUTES.toMillis(n)) {
                                        session.setAttribute("NO_ENTRY_MARCH_RECORD", passRecord);
                                        session.getAllowPassExcetpions().add(9);
                                        CarparkPresenceRecord precord = new CarparkPresenceRecord();
                                        JavaBeanTool.copyTo((Object)passRecord, (Object)precord);
                                        JavaBeanMap pMap = new JavaBeanMap((Object)precord);
                                        for (String key : pMap.keySet()) {
                                            if (!key.startsWith("exit_")) continue;
                                            pMap.put(key, null);
                                        }
                                        precord.setPass_car_type_no(precord.getEnter_car_type_no());
                                        precord.setPass_channel_no(precord.getEnter_channel_no());
                                        precord.setPass_duty_user_code(precord.getEnter_duty_no());
                                        precord.setPass_host_no(precord.getEnter_host_no());
                                        precord.setPass_plate(precord.getEnter_plate());
                                        precord.setPass_time(precord.getEnter_time());
                                        try {
                                            precord.setId(Long.valueOf(precord.getEnter_record_no().substring(1)));
                                        }
                                        catch (Exception ex) {
                                            precord.setId(0L);
                                        }
                                        areaPresenceRecordMap.put(precord.getArea_no(), precord);
                                    }
                                }
                            }
                        }
                        exitArea = areaList.get(areaList.size() - 1);
                        if (areaList.size() > 1) {
                            HashMap<String, CarparkArea> vset = new HashMap<String, CarparkArea>();
                            for (CarparkArea a : areaList) {
                                if (a.getArea_level().intValue() != exitArea.getArea_level().intValue()) continue;
                                vset.put(a.getArea_no(), a);
                            }
                            if (vset.size() > 1) {
                                CarparkArea carparkArea;
                                LinkedList<CarparkPresenceRecord> recList = new LinkedList<CarparkPresenceRecord>();
                                for (CarparkPresenceRecord r : areaPresenceRecordMap.values()) {
                                    if (!vset.containsKey(r.getArea_no())) continue;
                                    recList.add(r);
                                }
                                CarparkPresenceRecord x = (CarparkPresenceRecord)recList.peekLast();
                                if (x != null && !exitArea.getArea_no().equals(x.getArea_no()) && (carparkArea = (CarparkArea)vset.get(x.getArea_no())) != null) {
                                    exitArea = carparkArea;
                                }
                            }
                        }
                    }
                    exitAreaList = null;
                    if (exitArea != null) {
                        List<String> subList;
                        List<CarparkArea> list = channelArea.getExitAreas();
                        exitAreaList = new ArrayList<CarparkArea>(list.size());
                        if (list.size() > 1 && (subList = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(exitArea.getArea_no())) != null && !subList.isEmpty()) {
                            for (CarparkArea ar : list) {
                                if (!subList.contains(ar.getArea_no())) continue;
                                exitAreaList.add(ar);
                            }
                        }
                        exitAreaList.add(exitArea);
                    }
                    existMutiCarEnterRecords = new LinkedList<CarparkPresenceRecord>();
                    CarparkPresenceRecord takeSpaceRecord = null;
                    changePassTypeRecord = null;
                    occupyChargeRecord = null;
                    if (carOwner != null) {
                        session.setCarOwner(carOwner);
                        if (session.getAttribute("NO_ENTRY_MARCH_RECORD") == null) {
                            if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                                AtomicReference<CarparkPresenceRecord> atomicReference = new AtomicReference<CarparkPresenceRecord>();
                                KeyValueEntry<CarparkPassportType, CarparkPassport> keyValueEntry = ServiceUtil.getServiceContext().getMutiSpaceCarAlgorithm().getPassportAndTypeByMutiCar(passport, passportType, 1, exitArea, atomicReference, existMutiCarEnterRecords);
                                if (keyValueEntry != null && keyValueEntry.getKey() != null && keyValueEntry.getValue() != null) {
                                    passport = (CarparkPassport)keyValueEntry.getValue();
                                    passportType = (CarparkPassportType)keyValueEntry.getKey();
                                    session.setPassport(passport);
                                    session.setPassportType(passportType);
                                }
                                CarparkPresenceRecord takeChargeRecord0 = atomicReference.get();
                                if (passport.getSpace_reg_no() == null || passport.getSpace_reg_no().length() == 0) {
                                    passport.setSpace_reg_no(passport.getRegister_plate());
                                }
                                if (takeChargeRecord0 != null && takeChargeRecord0.getPass_type() == 0 && passportType.getPass_type() != 0 && exitArea.getArea_level() == 1) {
                                    occupyChargeRecord = takeChargeRecord0;
                                }
                            } else if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                                void var25_73;
                                String string4;
                                CarparkArea carparkArea = channelArea.getEnterAreas().get(0);
                                if (channelArea.getEnterAreas().size() > 1 && (string4 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(this.getChannelNo(), "CHANNEL_ENTER_MUTI_CAR_AREA")) != null && string4.length() > 0) {
                                    for (CarparkArea c : channelArea.getEnterAreas()) {
                                        if (!string4.equals(c.getArea_no())) continue;
                                        CarparkArea carparkArea2 = c;
                                        break;
                                    }
                                }
                                AtomicReference<CarparkPresenceRecord> atomicReference = new AtomicReference<CarparkPresenceRecord>();
                                KeyValueEntry<CarparkPassportType, CarparkPassport> newPassport = ServiceUtil.getServiceContext().getMutiSpaceCarAlgorithm().getPassportAndTypeByMutiCar(passport, passportType, 0, (CarparkArea)var25_73, atomicReference, existMutiCarEnterRecords);
                                if (newPassport != null && newPassport.getKey() != null && newPassport.getValue() != null) {
                                    passport = (CarparkPassport)newPassport.getValue();
                                    passportType = (CarparkPassportType)newPassport.getKey();
                                    session.setPassport(passport);
                                    session.setPassportType(passportType);
                                }
                                takeSpaceRecord = atomicReference.get();
                                if (passport.getSpace_reg_no() == null || passport.getSpace_reg_no().length() == 0) {
                                    passport.setSpace_reg_no(passport.getRegister_plate());
                                }
                                if (takeSpaceRecord != null && passportType.getPass_type() != 0) {
                                    CarparkPresenceRecord takeSpaceRecord0 = takeSpaceRecord;
                                    takeSpaceRecord = null;
                                    if (channelArea.getEnterAreas().get(0).getArea_level() > 1 && takeSpaceRecord0.getArea_level() < channelArea.getEnterAreas().get(0).getArea_level()) {
                                        changePassTypeRecord = takeSpaceRecord0;
                                    }
                                }
                            }
                        }
                    } else {
                        session.setCarOwner(null);
                    }
                    if ((carparkCarType2 = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().get(passport.getCar_type_no())) == null && (carparkCarType = PassChannel.getTimepDynCarType()) == null) {
                        throw new IllegalStateException("\u65e0\u6cd5\u627e\u5230\u9ed8\u8ba4\u5c0f\u8f66\u8f86\u7c7b\u578b\uff0c\u6570\u636e\u5b58\u5728\u4e22\u5931\uff1f\u8bf7\u68c0\u67e5");
                    }
                    session.setCarType((CarparkCarType)var25_76);
                    if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                        CarparkCarType channelCarType;
                        String bindCarTypeNo;
                        CarparkCarType carType0;
                        CarparkPresenceRecord carparkPresenceRecord = (CarparkPresenceRecord)areaPresenceRecordMap.get(exitArea.getArea_no());
                        if (carparkPresenceRecord != null && carparkPresenceRecord.getEnter_car_type_no() != null && !carparkPresenceRecord.getEnter_car_type_no().equals(var25_76.getCar_type_no()) && (carType0 = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().get(carparkPresenceRecord.getEnter_car_type_no())) != null) {
                            CarparkCarType carparkCarType3 = carType0;
                            session.setCarType(carparkCarType3);
                        }
                        if (!(session.getPassport().getId() != null && session.getPassport().getId() != 0L || channelArea.getExitAreas().get(channelArea.getExitAreas().size() - 1).getArea_level() != 1 || (bindCarTypeNo = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(this.getChannelNo(), "CHANNEL_EXIT_BIND_CARTYPE")) == null || Constants.NO_STR.equals(bindCarTypeNo) || (channelCarType = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().get(bindCarTypeNo)) == null)) {
                            session.getPassport().setCar_type_no(channelCarType.getCar_type_no());
                            session.setCarType(channelCarType);
                        }
                    } else if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                        CarparkCarType channelCarType;
                        String bindCarTypeNo;
                        CarparkArea carparkArea = channelArea.getEnterAreas().get(0);
                        if (carparkArea.getArea_level() > 1) {
                            CarparkCarType carType0;
                            CarparkPresenceRecord r = (CarparkPresenceRecord)areaPresenceRecordMap.get(carparkArea.getParent_area_no());
                            if (r != null && r.getEnter_car_type_no() != null && !r.getEnter_car_type_no().equals(var25_76.getCar_type_no()) && (carType0 = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().get(r.getEnter_car_type_no())) != null) {
                                CarparkCarType carparkCarType4 = carType0;
                                session.setCarType(carparkCarType4);
                            }
                        } else if (!(session.getPassport().getId() != null && session.getPassport().getId() != 0L || (bindCarTypeNo = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(this.getChannelNo(), "CHANNEL_ENTER_BIND_CARTYPE")) == null || Constants.NO_STR.equals(bindCarTypeNo) || (channelCarType = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().get(bindCarTypeNo)) == null)) {
                            session.getPassport().setCar_type_no(channelCarType.getCar_type_no());
                            session.setCarType(channelCarType);
                        }
                    }
                    if ((string = session.getPassPlate()) == null || string.length() <= 0 || (vehicleTypeEvent = this.findVehicleTypeEvent(string)) == null || vehicleTypeEvent.getVehicleType() == null || vehicleTypeEvent.getVehicleType().length() <= 0) break block188;
                    CarparkCarType bindType = null;
                    Object otType = PassChannel.getCarTypeOrPlateType(vehicleTypeEvent.getVehicleType());
                    if (otType != null && otType instanceof CarparkCarType) {
                        bindType = (CarparkCarType)otType;
                    }
                    if (bindType == null) break block189;
                    CarparkCarType carparkCarType5 = bindType;
                    session.setCarType(carparkCarType5);
                    if (passport.getId() != null && passport.getId() != 0L) break block188;
                    passport.setCar_type_no(carparkCarType5.getCar_type_no());
                    break block188;
                }
                Map<String, CarparkCarType> map = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
                for (CarparkCarType carType1 : map.values()) {
                    if (carType1.getCar_type_name() == null || carType1.getCar_type_name().indexOf(vehicleTypeEvent.getVehicleType()) == -1) continue;
                    CarparkCarType carparkCarType = carType1;
                    session.setCarType(carparkCarType);
                    if (passport.getId() != null && passport.getId() != 0L) break;
                    passport.setCar_type_no(carparkCarType.getCar_type_no());
                    break;
                }
            }
            try {
                String v;
                if (passport.getId() != null && passport.getId() != 0L || passport.getRegister_plate() == null || passport.getRegister_plate().length() <= 0 || (v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("PARKING_PLATE_PREFIX_TYPE_BIND")) == null || (v = v.trim()).length() <= 0 || "0".equals(v)) break block187;
                String[] ax = v.split(";");
                String[] stringArray = ax;
                int n = ax.length;
                int n2 = 0;
                while (n2 < n) {
                    int h;
                    String x = stringArray[n2];
                    if ((x = x.trim()).length() != 0 && (h = x.lastIndexOf(58)) != -1) {
                        String plate_prefix = x.substring(0, h);
                        String bandPlateTypeName = x.substring(h + 1).trim();
                        if (bandPlateTypeName.length() != 0) {
                            CarparkPassportType bindPassportType = null;
                            for (CarparkPassportType t : ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().values()) {
                                if (!bandPlateTypeName.equals(t.getPassport_type_name()) || t.getPass_type() != 0 || t.getUse_muti_car() != 0) continue;
                                bindPassportType = t;
                                break;
                            }
                            if (bindPassportType != null) {
                                String[] prefixs;
                                boolean bl = false;
                                String[] stringArray2 = prefixs = plate_prefix.split(",");
                                int n3 = prefixs.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String px = stringArray2[n4];
                                    if ((px = px.trim()).length() != 0 && passport.getRegister_plate().startsWith(px)) {
                                        passportType = bindPassportType;
                                        session.setPassportType(passportType);
                                        passport.setPassport_type_no(bindPassportType.getPassport_type_no());
                                        bl = true;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (bl) break;
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (session.getAttribute("takeChargeRecord") != null) {
            session.removeAttribute("takeChargeRecord");
        }
        if (changePassTypeRecord != null) {
            session.setAttribute("changePassTypeRecord", changePassTypeRecord);
        } else {
            session.removeAttribute("changePassTypeRecord");
        }
        if (occupyChargeRecord != null) {
            session.setAttribute("occupyChargeRecord", occupyChargeRecord);
        } else {
            session.removeAttribute("occupyChargeRecord");
        }
        int mutiCarPresenceCount = 0;
        if (existMutiCarEnterRecords != null && !existMutiCarEnterRecords.isEmpty()) {
            CarparkPresenceRecord precord = null;
            for (CarparkPresenceRecord r : existMutiCarEnterRecords) {
                if (r.getEnter_plate() == null || r.getEnter_plate().length() <= 0 || r.getExit_time() != null || r.getEnter_time() == null || r.getEnter_plate().equals(session.getPassport().getRegister_plate())) continue;
                if (precord == null) {
                    precord = r;
                }
                ++mutiCarPresenceCount;
            }
            if (precord == null) {
                existMutiCarEnterRecords = null;
            } else {
                existMutiCarEnterRecords = new ArrayList(1);
                existMutiCarEnterRecords.add(precord);
            }
        }
        if (existMutiCarEnterRecords != null && !existMutiCarEnterRecords.isEmpty()) {
            session.setAttribute("existMutiCarEnterRecords", existMutiCarEnterRecords);
        } else {
            session.removeAttribute("existMutiCarEnterRecords");
        }
        if (exitArea == null) {
            session.removeAttribute("PASS_EXIT_AREA");
        } else {
            session.setAttribute("PASS_EXIT_AREA", exitArea);
        }
        if (exitAreaList == null) {
            session.removeAttribute("PASS_EXIT_AREA_LIST");
        } else {
            session.setAttribute("PASS_EXIT_AREA_LIST", exitAreaList);
        }
        session.setAttribute("EXIST_MUTI_CAR_COUNT", mutiCarPresenceCount);
        session.setAttribute("passTime", passTime);
        session.setAttribute("channelArea", channelArea);
        session.setAttribute("areaPresenceRecordMap", areaPresenceRecordMap);
        session.setAttribute("DEFAULT_CARTYPE_NO", session.getCarType().getCar_type_no());
        if (isBlackList) {
            session.getConfirmPassExceptions().add(6);
        }
        if (isNotStart) {
            session.getAllowPassExcetpions().add(7);
        }
        if (isStop) {
            session.getAllowPassExcetpions().add(8);
        }
        if (carOwner != null && passportType.getPass_type() == 1 && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE")) && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT"))) {
            if (carOwner.getAccount_balance() == null) {
                passport.setBalance(Constants.MONEY_ZERO);
            } else {
                passport.setBalance(carOwner.getAccount_balance());
            }
        }
        ServiceUtil.getServiceContext().getPassFilterChain().execute(session);
    }

    public List<Equipment> getEquipmentList(Class<?> ... actionClass) {
        return ServiceUtil.getServiceContext().getEquipmentManager().getEquipmentsByActionClasses(this.getChannelNo(), actionClass);
    }

    public List<Equipment> getEquipmentList() {
        Enumeration<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getAllEquipments();
        if (eqs == null) {
            return null;
        }
        LinkedList<Equipment> eqsList = new LinkedList<Equipment>();
        String chanelNo = this.getChannelNo();
        while (eqs.hasMoreElements()) {
            Equipment eq = eqs.nextElement();
            if (eq.getChannelNos() == null || !eq.getChannelNos().contains(chanelNo)) continue;
            eqsList.add(eq);
        }
        return eqsList;
    }

    public Equipment getCamera(boolean onlyConnected) {
        Collection<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(33);
        if (eqs == null || eqs.isEmpty()) {
            return null;
        }
        PriorityQueue<Equipment> q = new PriorityQueue<Equipment>(10, new Comparator<Equipment>(){

            @Override
            public int compare(Equipment o1, Equipment o2) {
                boolean o1Connected = o1.getEquipmentAction().isWorkingProperly();
                boolean o2Connected = o2.getEquipmentAction().isWorkingProperly();
                if (o1Connected && !o2Connected) {
                    return -1;
                }
                if (!o1Connected && o2Connected) {
                    return 1;
                }
                boolean o1PlateReg = o1.getEquipmentAction() instanceof PlateRegCameraAction;
                boolean o2PlateReg = o2.getEquipmentAction() instanceof PlateRegCameraAction;
                if (o1PlateReg && !o2PlateReg) {
                    return -1;
                }
                if (!o1PlateReg && o2PlateReg) {
                    return 1;
                }
                return o1.getEquipmentNo().compareTo(o2.getEquipmentNo());
            }
        });
        String chanelNo = this.getChannelNo();
        for (Equipment eq : eqs) {
            if (eq.getChannelNos() == null || !eq.getChannelNos().contains(chanelNo) || eq.getEquipmentAction() == null || !(eq.getEquipmentAction() instanceof CameraAction)) continue;
            if (onlyConnected) {
                if (!eq.getEquipmentAction().isWorkingProperly()) continue;
                q.offer(eq);
                continue;
            }
            q.offer(eq);
        }
        if (q != null && !q.isEmpty()) {
            return q.poll();
        }
        return null;
    }

    public List<Equipment> getEquipmentList(int equipmentType) {
        Collection<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(equipmentType);
        if (eqs == null || eqs.isEmpty()) {
            return null;
        }
        LinkedList<Equipment> eqsList = new LinkedList<Equipment>();
        String chanelNo = this.getChannelNo();
        for (Equipment eq : eqs) {
            if (eq.getChannelNos() == null || !eq.getChannelNos().contains(chanelNo)) continue;
            eqsList.add(eq);
        }
        return eqsList;
    }

    public List<Equipment> getPlateRegCameras() {
        Collection<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(33);
        if (eqs == null || eqs.isEmpty()) {
            return null;
        }
        LinkedList<Equipment> eqsList = new LinkedList<Equipment>();
        String chanelNo = this.getChannelNo();
        for (Equipment eq : eqs) {
            Object ac;
            if (eq.getChannelNos() == null || !eq.getChannelNos().contains(chanelNo) || (ac = eq.getEquipmentAction()) == null || !(ac instanceof PlateRegCameraAction) || eq.getUse() != 1) continue;
            eqsList.add(eq);
        }
        return eqsList;
    }

    public Map<Integer, List<Equipment>> getCaptureCamerasByUseType(boolean containsRegPlate) {
        Collection<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(33);
        HashMap<Integer, List<Equipment>> cMap = new HashMap<Integer, List<Equipment>>();
        String chanelNo = this.getChannelNo();
        for (Equipment eq : eqs) {
            Object ac;
            if (eq.getChannelNos() == null || !eq.getChannelNos().contains(chanelNo) || (ac = eq.getEquipmentAction()) == null || !(ac instanceof CameraAction)) continue;
            Integer useType = null;
            if (ac instanceof PlateRegCameraAction && eq.getUse() == 1) {
                if (!containsRegPlate) continue;
                useType = 1;
            }
            if (useType == null) {
                EquipmentConfig config = eq.getEquipmentConfig();
                if (config == null) continue;
                useType = config.getConfigIntValue("capture_use_type");
            }
            if (useType == null || useType != 1 && useType != 2 && useType != 16) continue;
            LinkedList<Equipment> list = (LinkedList<Equipment>)cMap.get(useType);
            if (list == null) {
                list = new LinkedList<Equipment>();
                cMap.put(useType, list);
            }
            list.add(eq);
        }
        return cMap;
    }

    public List<Equipment> getCaptureCameras() {
        Collection<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(33);
        if (eqs == null || eqs.isEmpty()) {
            return null;
        }
        LinkedList<Equipment> eqsList = new LinkedList<Equipment>();
        String chanelNo = this.getChannelNo();
        for (Equipment eq : eqs) {
            EquipmentConfig config;
            Object ac;
            if (eq.getChannelNos() == null || !eq.getChannelNos().contains(chanelNo) || (ac = eq.getEquipmentAction()) == null) continue;
            if (ac instanceof PlateRegCameraAction) {
                if (eq.getUse() != 2) continue;
                eqsList.add(eq);
                continue;
            }
            if (!(ac instanceof CameraAction) || (config = eq.getEquipmentConfig()) == null || config.getConfigIntValue("capture_use_type") == null) continue;
            eqsList.add(eq);
        }
        return eqsList;
    }

    public List<Equipment> getWorkNormalPlateRegCameras() {
        Collection<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(33);
        if (eqs == null || eqs.isEmpty()) {
            return null;
        }
        LinkedList<Equipment> eqsList = new LinkedList<Equipment>();
        String chanelNo = this.getChannelNo();
        for (Equipment eq : eqs) {
            Object ac;
            if (eq.getChannelNos() == null || !eq.getChannelNos().contains(chanelNo) || (ac = eq.getEquipmentAction()) == null || !(ac instanceof PlateRegCameraAction) || !ac.isWorkingProperly() || eq.getUse() != 1) continue;
            eqsList.add(eq);
        }
        return eqsList;
    }

    public List<Equipment> getWorkNomalEquipmentList(int equipmentType) {
        Collection<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(equipmentType);
        if (eqs == null || eqs.isEmpty()) {
            return null;
        }
        LinkedList<Equipment> eqsList = new LinkedList<Equipment>();
        String chanelNo = this.getChannelNo();
        for (Equipment eq : eqs) {
            Object ac;
            if (eq.getChannelNos() == null || !eq.getChannelNos().contains(chanelNo) || (ac = eq.getEquipmentAction()) == null || !ac.isWorkingProperly()) continue;
            eqsList.add(eq);
        }
        return eqsList;
    }

    public CaptureEvent captureOne(int triggerMethod) {
        int[] ax;
        Map<Integer, List<Equipment>> vmap = this.getCaptureCamerasByUseType(true);
        if (vmap == null || vmap.isEmpty()) {
            return null;
        }
        int[] nArray = ax = new int[]{1, 2, 16};
        int n = ax.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            List<Equipment> camearas = vmap.remove(a);
            if (camearas != null) {
                for (Equipment e : camearas) {
                    CaptureEvent ce = this.capture(a, triggerMethod, e.getEquipmentNo());
                    if (ce == null) continue;
                    return ce;
                }
            }
            ++n2;
        }
        if (!vmap.isEmpty()) {
            for (Map.Entry<Integer, List<Equipment>> entry : vmap.entrySet()) {
                List<Equipment> camearas = entry.getValue();
                if (camearas == null) continue;
                for (Equipment e : camearas) {
                    CaptureEvent ce = this.capture(entry.getKey(), triggerMethod, e.getEquipmentNo());
                    if (ce == null) continue;
                    return ce;
                }
            }
        }
        return null;
    }

    public List<CaptureEvent> captureByUseType(boolean usePlateReg, int triggerMethod, int ... useTypes) {
        if (useTypes == null || useTypes.length == 0) {
            return null;
        }
        Map<Integer, List<Equipment>> vmap = this.getCaptureCamerasByUseType(usePlateReg);
        if (vmap == null || vmap.isEmpty()) {
            return null;
        }
        LinkedList<CaptureEvent> capList = new LinkedList<CaptureEvent>();
        int[] nArray = useTypes;
        int n = useTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            List<Equipment> camearas = vmap.get(a);
            if (camearas != null) {
                for (Equipment e : camearas) {
                    CaptureEvent ce = this.capture(a, triggerMethod, e.getEquipmentNo());
                    if (ce == null) continue;
                    capList.add(ce);
                    break;
                }
            }
            ++n2;
        }
        return capList;
    }

    @Deprecated
    public CaptureEvent capture() {
        return this.captureOne(8);
    }

    public CaptureEvent capture(int picture_use, int trigger_method, String camreaNo) {
        try {
            Object ac;
            Equipment eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(camreaNo);
            if (eq != null && (ac = eq.getEquipmentAction()).isWorkingProperly() && ac instanceof CameraAction) {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                File dateFile = new File(PathFinder.findLocalPicDir(), df.format(new Date()));
                File xfile = new File(dateFile, camreaNo);
                if (!xfile.exists()) {
                    xfile.mkdirs();
                }
                String fileName = "snapshot_" + System.currentTimeMillis() + "_" + RandomStringGenerator.getDefaultInstance().getNewString(6) + ".jpg";
                File picFile = new File(xfile, fileName);
                String savePath = picFile.getAbsolutePath();
                CameraAction action = (CameraAction)ac;
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("savePath", savePath);
                OperationFuture<Integer> captureHandle = action.capture(paramMap);
                if (captureHandle != null) {
                    CaptureEvent event = new CaptureEvent(eq, savePath, trigger_method, picture_use, captureHandle, System.currentTimeMillis(), this.getChannelNo());
                    return event;
                }
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
        }
        return null;
    }

    public void exceptionPass(boolean openPole, int record_type, String reason_code, String des, String plateNumber) {
        this.exceptionPass(openPole, record_type, reason_code, des, plateNumber, null, null);
    }

    public void exceptionPass(boolean openPole, int record_type, String reason_code, String des, String plateNumber, String userCode, String userName) {
        String msg;
        List<OperationFuture<Integer>> list;
        if (openPole && ((list = this.openPole(true, null)) == null || list.isEmpty())) {
            msg = String.valueOf(this.getChannel().getChannel_name()) + ":\u672a\u914d\u7f6e\u9053\u95f8\uff0c\u5f00\u95f8\u5931\u8d25!";
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4));
        }
        try {
            RecordSaveService recordService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            recordService.saveIllegalPassRecord(record_type, reason_code, des, plateNumber, this.getChannelNo(), this.captureOne(8), userCode, userName);
        }
        catch (Throwable ex) {
            ServiceLog.getLog().warn((Object)"", ex);
            msg = String.valueOf(this.getChannel().getChannel_name()) + ":\u4fdd\u5b58\u5f00\u95f8\u6570\u636e\u9519\u8bef!";
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4));
        }
    }

    public HostSate getLanConnectManageHostState() {
        CarparkHost host = this.getLanManageHost();
        if (host != null) {
            return this.getLanConnectManageHostState(host.getHost_no());
        }
        return null;
    }

    public HostSate getLanConnectManageHostState(String hostNo) {
        HostSate state;
        if (hostNo != null && hostNo.length() > 0 && (state = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(hostNo)) != null) {
            if (state.getHostNo() == null || state.getHostNo().length() == 0) {
                state.setHostNo(hostNo);
            }
            return state;
        }
        return null;
    }

    public CarparkHost getLanManageHost() {
        CarparkHost host;
        String slaveHostNo;
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1 && (slaveHostNo = this.getChannel().getSlave_managed_host_no()) != null && slaveHostNo.length() > 0 && !slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) && (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) != null && host.getHost_use() == 1 && host.getNet_mode() == 2) {
            return host;
        }
        return null;
    }

    public void triggerRegPlate() {
        List<Equipment> cameraList = this.getPlateRegCameras();
        if (cameraList == null || cameraList.isEmpty()) {
            String msg = String.valueOf(this.getChannel().getChannel_name()) + ":\u672a\u914d\u7f6e\u8f66\u724c\u8bc6\u522b\u76f8\u673a,\u64cd\u4f5c\u5931\u8d25!";
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4));
        } else {
            String msg;
            Equipment ac;
            ListIterator<Equipment> its = cameraList.listIterator();
            while (its.hasNext()) {
                ac = (Equipment)its.next();
                if (ac.getEquipmentAction() instanceof PlateRegCameraAction) continue;
                its.remove();
            }
            if (cameraList.isEmpty()) {
                msg = String.valueOf(this.getChannel().getChannel_name()) + ":\u672a\u914d\u7f6e\u8f66\u724c\u8bc6\u522b\u76f8\u673a,\u64cd\u4f5c\u5931\u8d25!";
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4));
                return;
            }
            its = cameraList.listIterator();
            while (its.hasNext()) {
                ac = (Equipment)its.next();
                PlateRegCameraAction regPlate = (PlateRegCameraAction)ac.getEquipmentAction();
                if (regPlate.isWorkingProperly()) continue;
                its.remove();
            }
            if (cameraList.isEmpty()) {
                msg = String.valueOf(this.getChannel().getChannel_name()) + ":\u76f8\u673a\u672a\u8fde\u63a5,\u64cd\u4f5c\u5931\u8d25!";
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4));
                return;
            }
            for (final Equipment eq : cameraList) {
                try {
                    final String key = String.valueOf(this.getChannelNo()) + "_" + eq.getEquipmentNo() + "_triggerRegPlate";
                    if (ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)key) != null) continue;
                    ObjectCreateCallback<String> regPlateCallback = new ObjectCreateCallback<String>(){

                        public void createSuccess(String plateNo) {
                            eq.removeAttribute("waitTriggerRegPlate");
                            if ("\u65e0\u724c\u8f66".equals(plateNo) || "\u65e0\u8f66\u724c".equals(plateNo)) {
                                String msg = String.valueOf(PassChannel.this.getChannel().getChannel_name()) + "," + eq.getName() + ",\u672a\u80fd\u68c0\u6d4b\u5230\u8f66\u724c!";
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2));
                            } else {
                                String msg = String.valueOf(PassChannel.this.getChannel().getChannel_name()) + "," + eq.getName() + ",\u6210\u529f\u8bc6\u522b\u8f66\u724c:" + plateNo;
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 1));
                            }
                        }

                        public void onException(Throwable arg0) {
                            eq.removeAttribute("waitTriggerRegPlate");
                        }
                    };
                    PlateRegCameraAction action = (PlateRegCameraAction)eq.getEquipmentAction();
                    ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)key, (Object)regPlateCallback, new TimeoutObjectPool.TimeoutCallback(){

                        public void onTimeout(Object arg0, Object arg1) throws Exception {
                            String msg = String.valueOf(PassChannel.this.getChannel().getChannel_name()) + "," + eq.getName() + ",\u672a\u80fd\u68c0\u6d4b\u5230\u8f66\u724c!";
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2));
                            eq.removeAttribute("waitTriggerRegPlate");
                        }
                    }, 4000L, TimeUnit.MILLISECONDS);
                    eq.setAttribute("waitTriggerRegPlate", ServiceUtil.getServiceContext().currentTimeMillis());
                    OperationFuture<Integer> op1 = action.triggerRegPlate();
                    op1.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                        public void operationComplete(OperationFuture<Integer> x) {
                            if (x.getException() != null || x.getResult() == null || (Integer)x.getResult() != 0) {
                                this.doErr();
                            }
                        }

                        public void waitCompleteTimeout() {
                            this.doErr();
                        }

                        private void doErr() {
                            eq.removeAttribute("waitTriggerRegPlate");
                            Object obj = ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)key);
                            if (obj != null) {
                                String msg = String.valueOf(PassChannel.this.getChannel().getChannel_name()) + "," + eq.getName() + ",\u89e6\u53d1\u8f6f\u8bc6\u522b\u5931\u8d25!";
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4));
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                }
            }
        }
    }
}

