/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.ConfirmPassDialogCallback;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.DispatchDataTaskUtil;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCancelPassRecord;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentAction;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.AlwaysOpenAction;
import com.wovoe.carpark.equipment.action.InputIoDetectedAction;
import com.wovoe.carpark.equipment.action.PlateRegCameraAction;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.action.RoadBarrierStateSupport;
import com.wovoe.carpark.equipment.action.VehiclePassDetectedAction;
import com.wovoe.carpark.event.app.CarLeftEvent;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.PassRecordEvent;
import com.wovoe.carpark.event.app.PlateRecognizedEvent;
import com.wovoe.carpark.event.app.ReadPassportNumberEvent;
import com.wovoe.carpark.event.equipment.VehicleDetectorEvent;
import com.wovoe.carpark.event.equipment.VehiclePassEvent;
import com.wovoe.carpark.event.listener.CarChannelPassProcessEventListener;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.SavePassDataFilterInterceptor;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.DisplayVoiceService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.vo.SavePassData;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JavaBeanTool;
import com.wovoe.framework.JavaBeanUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.session.SqlSession;

public class PassEventHandler {
    public static final String UN_REG = "\u672a\u8bc6\u522b";
    private final Map<String, List<VehiclePassEventEntry>> eqPassEventMap;
    private final PassChannel passChannel;
    private volatile PlateRecognizedEvent waitingNewCarEvent = null;
    private volatile VehiclePassEventEntry currentNewCarEntry = null;

    public PassEventHandler(PassChannel passChannel) {
        this.passChannel = passChannel;
        this.eqPassEventMap = new HashMap<String, List<VehiclePassEventEntry>>();
    }

    public InputIoDetectedAction getWorkNormalGrandAction() {
        List<Equipment> eqList = ServiceUtil.getServiceContext().getEquipmentManager().getEquipmentsByActionClass(InputIoDetectedAction.class);
        if (eqList != null && !eqList.isEmpty()) {
            for (Equipment eq : eqList) {
                if (!(eq.getEquipmentAction() instanceof InputIoDetectedAction) || eq.getEquipmentAction() instanceof VehiclePassDetectedAction || !((InputIoDetectedAction)eq.getEquipmentAction()).isConnGround(this.passChannel.getChannelNo()) || !eq.getEquipmentAction().isWorkingProperly() || !(eq.getEquipmentAction() instanceof PlateRegCameraAction)) continue;
                return (InputIoDetectedAction)eq.getEquipmentAction();
            }
        }
        return null;
    }

    private void bindSession(VehiclePassEventEntry entry, List<VehiclePassEventEntry> list) {
        if (entry.bindSession != null) {
            return;
        }
        String alarmPlate = this.getPlate(entry.latestDetectedEvent.getPlateNumber());
        if ("\u65e0\u724c\u8f66".equals(alarmPlate)) {
            PlateRecognizedEvent regPlateEvent = this.waitingNewCarEvent;
            if (regPlateEvent != null) {
                PassSession session;
                long timeout = "\u65e0\u724c\u8f66".equals(this.getPlate(regPlateEvent.getPlateNumber())) ? 10000L : 7000L;
                if (entry.latestDetectedEvent.getRevNonTimeMills() - regPlateEvent.getRegTimeMills() < timeout && (session = this.findPlateRecognizedEventSession(regPlateEvent.getPlateNumber())) != null && session.getEventPassId() == null) {
                    session.setEventPassId(entry.eventPassId);
                    entry.bindSession = session;
                }
            }
        } else {
            PassSession passSession = this.findSamePlatePassSession(alarmPlate, false);
            if (passSession != null) {
                Long oldId = passSession.getEventPassId();
                if (oldId != null && list != null) {
                    VehiclePassEventEntry e = null;
                    for (VehiclePassEventEntry eventEntry : list) {
                        if (eventEntry.eventPassId != oldId) continue;
                        e = eventEntry;
                    }
                    if (e != null && e.bindSession != null) {
                        e.bindSession.setEventPassId(null);
                        e.bindSession = null;
                    }
                }
                passSession.setEventPassId(entry.eventPassId);
                entry.bindSession = passSession;
            } else {
                PlateRecognizedEvent regPlateEvent = this.waitingNewCarEvent;
                if (regPlateEvent != null) {
                    PassSession session;
                    long timeout = alarmPlate.equals(this.getPlate(regPlateEvent.getPlateNumber())) ? 10000L : 7000L;
                    if (entry.latestDetectedEvent.getRevNonTimeMills() - regPlateEvent.getRegTimeMills() < timeout && (session = this.findPlateRecognizedEventSession(regPlateEvent.getPlateNumber())) != null && session.getEventPassId() == null) {
                        session.setEventPassId(entry.eventPassId);
                        entry.bindSession = session;
                    }
                }
            }
        }
    }

    private PassSession findPlateRecognizedEventSession(String plate) {
        String regPlate = this.getPlate(plate);
        Collection<PassSession> cls = this.passChannel.getSessions();
        PassSession passSession = null;
        if ("\u65e0\u724c\u8f66".equals(regPlate)) {
            PassSession p1 = null;
            for (PassSession passSession1 : cls) {
                if (passSession1.getPlateRecognizedEvent() == null) continue;
                p1 = passSession1;
            }
            if (p1 != null && "\u65e0\u724c\u8f66".equals(this.getPlate(p1.getPlateRecognizedEvent().getPlateNumber()))) {
                passSession = p1;
            }
        } else {
            for (PassSession passSession1 : cls) {
                if (passSession1.getPlateRecognizedEvent() == null || !regPlate.equals(passSession1.getPlateRecognizedEvent().getPlateNumber())) continue;
                passSession = passSession1;
            }
        }
        return passSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleVehiclePassEvent(VehiclePassEvent event, CarChannelPassProcessEventListener l) {
        VehiclePassEventEntry entry;
        if (event == null) {
            return;
        }
        if (event.getChannelNo() == null || !event.getChannelNo().equals(this.passChannel.getChannelNo())) {
            return;
        }
        this.checkPassEventMap();
        Equipment eq = (Equipment)event.getSource();
        if (eq == null) {
            return;
        }
        List<VehiclePassEventEntry> listQueue = this.getList(eq.getEquipmentNo());
        if (listQueue == null) {
            return;
        }
        VehiclePassEventEntry newCarEntry = null;
        List<VehiclePassEventEntry> list = listQueue;
        synchronized (list) {
            entry = this.findVehiclePassEventEntry(event.getEventPassId(), listQueue, event.getEventType());
        }
        boolean throwNewPlate = false;
        if (event.getEventType() == 0) {
            Object oldSessionId;
            Object applicationService;
            PlateRecognizedEvent plateRecognizedEvent0;
            VehiclePassEvent latestDetectedEvent;
            boolean isStrictlyMatchRegPlate = this.isStrictlyMatchRegPlate((Equipment)event.getSource());
            ServiceLog.getLog().info((Object)(String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u6536\u5230\u8f66\u8f86\u6ede\u7559\u4e8b\u4ef6: \u901a\u884cid: " + event.getEventPassId() + ", \u8f66\u724c\u53f7: " + event.getPlateNumber()));
            if (event.getPlateNumber() != null && event.getPlateNumber().length() > 0 && UN_REG.equals(event.getPlateNumber())) {
                event.setPlateNumber("\u65e0\u724c\u8f66");
            }
            this.currentNewCarEntry = null;
            if (entry == null) {
                List<VehiclePassEventEntry> list2 = listQueue;
                synchronized (list2) {
                    entry = new VehiclePassEventEntry();
                    entry.eventPassId = event.getEventPassId();
                    entry.beginDetectedEvent = event;
                    entry.latestDetectedEvent = event;
                    entry.detectedTimes = 1;
                    entry.validMills = event.getRevNonTimeMills() + TimeUnit.MINUTES.toMillis(60L);
                    LinkedList<VehiclePassEventEntry> dx = null;
                    for (VehiclePassEventEntry x : listQueue) {
                        if (x.isFinish()) continue;
                        if (dx == null) {
                            dx = new LinkedList<VehiclePassEventEntry>();
                        }
                        dx.offer(x);
                    }
                    if (dx != null && dx.size() > 3) {
                        VehiclePassEventEntry rm;
                        while ((rm = (VehiclePassEventEntry)dx.poll()) != null) {
                            listQueue.remove(rm);
                            if (dx.size() <= 3) break;
                        }
                    }
                    VehiclePassEventEntry lastEntry = null;
                    if (!listQueue.isEmpty()) {
                        lastEntry = listQueue instanceof LinkedList ? (VehiclePassEventEntry)((LinkedList)listQueue).peekLast() : listQueue.get(listQueue.size() - 1);
                    }
                    listQueue.add(entry);
                    if (lastEntry != null && !lastEntry.isFinish() && lastEntry.bindSession == null && event.getRevNonTimeMills() - lastEntry.latestDetectedEvent.getRevNonTimeMills() <= 7000L) {
                        newCarEntry = lastEntry;
                        entry.detectedTimes = 0;
                    } else {
                        newCarEntry = entry;
                    }
                    if (!isStrictlyMatchRegPlate) {
                        this.bindSession(newCarEntry, listQueue);
                        this.removeWaitNewCarEvent();
                        if (newCarEntry.bindSession != null) {
                            newCarEntry = null;
                        }
                    }
                }
            }
            long validMills = ServiceUtil.getServiceContext().currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L);
            if (entry.validMills < validMills) {
                entry.validMills = validMills;
            }
            if (entry.maybeLeave) {
                entry.maybeLeave = false;
            }
            if ((latestDetectedEvent = entry.latestDetectedEvent) == event) {
                return;
            }
            InputIoDetectedAction onlineIoAction = this.getWorkNormalGrandAction();
            List<VehiclePassEventEntry> list3 = listQueue;
            synchronized (list3) {
                VehiclePassEventEntry lastEntry = listQueue instanceof LinkedList ? (VehiclePassEventEntry)((LinkedList)listQueue).peekLast() : (!listQueue.isEmpty() ? listQueue.get(listQueue.size() - 1) : null);
                if (lastEntry != null && lastEntry != entry) {
                    if (lastEntry.isFinish()) {
                        listQueue.remove(lastEntry);
                    } else if (lastEntry.bindSession == null) {
                        lastEntry.detectedTimes = 0;
                        ServiceLog.getLog().error((Object)("\u6682\u4e0d\u5904\u7406\u6ede\u7559\u8f66\u724c: " + lastEntry.latestDetectedEvent.getPlateNumber() + ", \u539f\u56e0\u68c0\u6d4b\u5230\u524d\u8f66: " + entry.latestDetectedEvent.getPlateNumber() + "\u672a\u79bb\u5f00\uff0c\u6392\u961f\u4e2d"));
                    }
                }
            }
            VehiclePassEventEntry vehiclePassEventEntry = entry;
            vehiclePassEventEntry.detectedTimes = vehiclePassEventEntry.detectedTimes + 1;
            entry.latestDetectedEvent = event;
            if (entry.bindSession != null) {
                if (!entry.bindSession.isValid()) {
                    entry.bindSession.setEventPassId(null);
                    entry.bindSession = null;
                } else if (!this.passChannel.getSessions().contains(entry.bindSession)) {
                    entry.bindSession.setEventPassId(null);
                    entry.bindSession = null;
                }
            }
            if (entry.bindSession != null && entry.bindSession.getSessionState() == PassSession.SessionState.PENDING && entry.bindSession.getPlateRecognizedEvent() != null && ((Equipment)event.getSource()).getEquipmentNo().equals(entry.bindSession.getPlateRecognizedEvent().getCameraEquipmentNo()) && event.getPlateNumber() != null && event.getPlateNumber().length() > 0 && !"\u65e0\u724c\u8f66".equals(this.getPlate(event.getPlateNumber()))) {
                entry.bindSession.setEventPassId(null);
                this.passChannel.invalidateSession(entry.bindSession);
                entry.bindSession = null;
            }
            if ((plateRecognizedEvent0 = this.waitingNewCarEvent) != null) {
                String rPlate = this.getPlate(plateRecognizedEvent0.getPlateNumber());
                applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                if (event.getPlateNumber() != null && event.getPlateNumber().length() > 0 && !"\u65e0\u724c\u8f66".equals(rPlate) && applicationService.plateEquals(event.getPlateNumber(), rPlate, 1)) {
                    entry.bindRegPlateEvent = true;
                    this.removeWaitNewCarEvent();
                    PassSession passSession = this.findSamePlatePassSession(plateRecognizedEvent0.getPlateNumber(), false);
                    if (passSession != null) {
                        if (entry.bindSession == null || entry.bindSession != passSession) {
                            oldSessionId = passSession.getEventPassId();
                            if (oldSessionId != null) {
                                VehiclePassEventEntry entry0 = null;
                                List<VehiclePassEventEntry> list4 = listQueue;
                                synchronized (list4) {
                                    for (VehiclePassEventEntry eventEntry : listQueue) {
                                        if (eventEntry.eventPassId != (Long)oldSessionId) continue;
                                        entry0 = eventEntry;
                                    }
                                }
                                if (entry0 != null && entry0 != entry && entry0.bindSession == passSession) {
                                    entry0.bindSession = null;
                                }
                            }
                            passSession.setEventPassId(event.getEventPassId());
                            entry.bindSession = passSession;
                        }
                    } else if (isStrictlyMatchRegPlate) {
                        plateRecognizedEvent0.setEventPassId(entry.eventPassId);
                        l.handlePlateRecognizedEvent(plateRecognizedEvent0);
                        event.setPicData(null);
                        event.setPlateSmallPicData(null);
                        return;
                    }
                }
            }
            if (!isStrictlyMatchRegPlate && entry.bindSession == null) {
                VehiclePassEventEntry firstWaitRegEntry = null;
                applicationService = listQueue;
                synchronized (applicationService) {
                    for (VehiclePassEventEntry eventEntry : listQueue) {
                        if (eventEntry.isFinish() || eventEntry.maybeLeave || event.getRevNonTimeMills() - eventEntry.latestDetectedEvent.getRevNonTimeMills() > 7000L || eventEntry.bindSession != null || firstWaitRegEntry != null) continue;
                        firstWaitRegEntry = eventEntry;
                    }
                }
                if (firstWaitRegEntry != null) {
                    this.bindSession(firstWaitRegEntry, listQueue);
                    this.removeWaitNewCarEvent();
                }
            }
            if (entry.bindSession == null) {
                boolean run = false;
                if (entry.bindRegPlateEvent) {
                    if (entry.detectedTimes > 1) {
                        run = true;
                    }
                } else {
                    VehiclePassEventEntry first = null;
                    VehiclePassEventEntry firstWaitRegEntry = null;
                    oldSessionId = listQueue;
                    synchronized (oldSessionId) {
                        for (VehiclePassEventEntry eventEntry : listQueue) {
                            PassSession xSession;
                            if (!eventEntry.isFinish()) {
                                xSession = eventEntry.bindSession;
                                if (xSession != null) {
                                    if (xSession.getSessionState() == PassSession.SessionState.OPEN_DIALOG || xSession.getSessionState() == PassSession.SessionState.WAIT_PAY || xSession.getSessionState() == PassSession.SessionState.PENDING) {
                                        first = eventEntry;
                                    } else if (xSession.getCarLeftEvent() == null && first == null) {
                                        first = eventEntry;
                                    }
                                }
                                if (eventEntry.maybeLeave || event.getRevNonTimeMills() - eventEntry.latestDetectedEvent.getRevNonTimeMills() > 7000L) continue;
                                if (first == null) {
                                    first = eventEntry;
                                }
                                if (eventEntry.bindSession != null || firstWaitRegEntry != null) continue;
                                firstWaitRegEntry = eventEntry;
                                continue;
                            }
                            xSession = eventEntry.bindSession;
                            if (xSession == null || xSession.getSessionState() != PassSession.SessionState.OPEN_DIALOG && xSession.getSessionState() != PassSession.SessionState.WAIT_PAY) continue;
                            first = eventEntry;
                        }
                    }
                    if (first == null) {
                        first = entry;
                    }
                    if (first != entry) {
                        if (firstWaitRegEntry == null) {
                            firstWaitRegEntry = entry;
                        }
                        newCarEntry = firstWaitRegEntry;
                        if (firstWaitRegEntry != entry) {
                            entry.detectedTimes = 0;
                        }
                    } else if (onlineIoAction != null) {
                        entry.bindIo = false;
                        newCarEntry = entry;
                        entry.detectedTimes = 1;
                    } else {
                        if (entry.bindIo) {
                            entry.bindIo = false;
                        }
                        String lastPlate = this.getPlate(latestDetectedEvent.getPlateNumber());
                        String cPlate = this.getPlate(event.getPlateNumber());
                        if (cPlate != null && cPlate.length() > 0 && cPlate.equals(lastPlate) && cPlate.equals("\u65e0\u724c\u8f66")) {
                            run = true;
                        } else {
                            newCarEntry = entry;
                        }
                    }
                }
                if (run) {
                    String lastPlate = this.getPlate(latestDetectedEvent.getPlateNumber());
                    String cPlate = this.getPlate(event.getPlateNumber());
                    if (cPlate != null && cPlate.length() > 0) {
                        if (lastPlate == null || lastPlate.length() == 0) {
                            lastPlate = "\u65e0\u724c\u8f66";
                        }
                        boolean lastNoPlate = "\u65e0\u724c\u8f66".equals(lastPlate);
                        boolean cNoPlate = "\u65e0\u724c\u8f66".equals(cPlate);
                        if (cNoPlate) {
                            if (lastNoPlate) {
                                throwNewPlate = true;
                            }
                        } else if ("\u65e0\u724c\u8f66".equals(lastPlate)) {
                            throwNewPlate = true;
                        } else if (cPlate.equals(lastPlate)) {
                            throwNewPlate = true;
                        }
                    }
                }
            } else {
                entry.bindSession.contineWhenless(30, 30);
                String cPlate = this.getPlate(event.getPlateNumber());
                if (cPlate != null && cPlate.length() > 0) {
                    PassSession.SessionState bindSessionSate;
                    boolean cNoPlate = "\u65e0\u724c\u8f66".equals(cPlate);
                    if (cNoPlate) {
                        bindSessionSate = entry.bindSession.getSessionState();
                        if (bindSessionSate == PassSession.SessionState.PENDING) {
                            if (entry.bindSession != this.passChannel.getLastSession()) {
                                entry.bindSession.setEventPassId(null);
                                entry.bindSession = null;
                                throwNewPlate = true;
                            } else if (this.isLocalHandle()) {
                                long c = ServiceUtil.getServiceContext().currentTimeMillis();
                                Long x = (Long)entry.bindSession.getAttribute("PLAY_NOPLATE_VOICE_MILLS");
                                if (x == null || c - x >= 60000L) {
                                    DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                                    try {
                                        displayVoiceService.playWhenNoplate(this.passChannel);
                                        entry.bindSession.setAttribute("PLAY_NOPLATE_VOICE_MILLS", ServiceUtil.getServiceContext().currentTimeMillis());
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                                    }
                                }
                            }
                        }
                    } else {
                        bindSessionSate = entry.bindSession.getSessionState();
                        if (bindSessionSate == PassSession.SessionState.PENDING) {
                            entry.bindSession.setEventPassId(null);
                            entry.bindSession = null;
                            throwNewPlate = true;
                        } else if (bindSessionSate != PassSession.SessionState.PROCESSING) {
                            if (bindSessionSate == PassSession.SessionState.CANCELED) {
                                if (entry.bindSession.getReadPassportNumberEvent() == null) {
                                    entry.bindSession.setEventPassId(null);
                                    entry.bindSession = null;
                                    throwNewPlate = true;
                                } else if (cPlate.equals(entry.bindSession.getReadPassportNumberEvent().getPassportNumber()) && entry.bindSession.getReadPassportNumberEvent().getPassportMediumType() == 6) {
                                    if (entry.bindSession.getAttribute("GUI_CANCEL") == null && entry.bindSession.getCancelMills() != null && ServiceUtil.getServiceContext().currentTimeMillis() - entry.bindSession.getCancelMills() >= 30000L) {
                                        entry.bindSession.setEventPassId(null);
                                        entry.bindSession = null;
                                        throwNewPlate = true;
                                    }
                                } else {
                                    entry.bindSession.setEventPassId(null);
                                    entry.bindSession = null;
                                    throwNewPlate = true;
                                }
                            } else if (bindSessionSate == PassSession.SessionState.OPEN_DIALOG || bindSessionSate == PassSession.SessionState.WAIT_PAY) {
                                ChannelArea channelArea;
                                if (entry.bindSession.getReadPassportNumberEvent() != null && cPlate.equals(entry.bindSession.getReadPassportNumberEvent().getPassportNumber()) && entry.bindSession.getReadPassportNumberEvent().getPassportMediumType() == 6) {
                                    channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(this.passChannel.getChannelNo());
                                    if (channelArea != null && channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty() && event.getRevNonTimeMills() - entry.bindSession.getReadPassportNumberEvent().getReadTimeMills() >= TimeUnit.MINUTES.toMillis(5L)) {
                                        entry.bindSession.removeCancelPassRecord();
                                        entry.bindSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                        entry.bindSession.setSessionState(PassSession.SessionState.CANCELED);
                                        ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                        if (callback != null) {
                                            callback.doClosePassDialog(entry.bindSession);
                                        }
                                        this.passChannel.invalidateSession(entry.bindSession);
                                        entry.bindSession.setEventPassId(null);
                                        entry.bindSession = null;
                                        throwNewPlate = true;
                                    }
                                } else {
                                    channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(this.passChannel.getChannelNo());
                                    if (channelArea != null && channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                                        Map areaPresenceRecordMap;
                                        CarparkArea exitArea = (CarparkArea)entry.bindSession.getAttribute("PASS_EXIT_AREA");
                                        CarparkPresenceRecord pR = null;
                                        if (exitArea != null && (areaPresenceRecordMap = (Map)entry.bindSession.getAttribute("areaPresenceRecordMap")) != null) {
                                            pR = (CarparkPresenceRecord)areaPresenceRecordMap.get(exitArea.getArea_no());
                                        }
                                        if (pR != null) {
                                            ServiceLog.getLog().info((Object)(String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u4e22\u5f03\u73af\u5883\u76f8\u673a\u8f66\u724c:" + cPlate + ", \u4f7f\u7528\u5f53\u524d\u653e\u884c\u8f66\u724c: " + entry.bindSession.getReadPassportNumberEvent().getPassportNumber() + ", \u5f53\u524d\u653e\u884c\u8f66\u724c\u6709\u5339\u914d\u5165\u573a\u8bb0\u5f55"));
                                        } else {
                                            boolean restart;
                                            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                                            SearchParam preseceRecordParam = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class)).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                                            preseceRecordParam.addEQ("passport_number", (Object)cPlate).addEQ("medium_type", (Object)6).addEQ("area_no", (Object)exitArea.getArea_no());
                                            preseceRecordParam.setQueryFields(new String[]{"id", "enter_record_no", "passport_number", "medium_type", "enter_time", "area_no", "enter_plate"});
                                            CarparkPresenceRecord rr = (CarparkPresenceRecord)commonDaoService.selectOne(preseceRecordParam, CarparkPresenceRecord.class);
                                            boolean bl = restart = rr != null;
                                            if (!restart) {
                                                SearchParam sp;
                                                List passportList;
                                                boolean register;
                                                boolean bl2 = register = entry.bindSession.getCarOwner() != null || entry.bindSession.getPassport() != null && !Constants.NO_STR.equals(entry.bindSession.getPassport().getPassport_no());
                                                if (!register && (passportList = commonDaoService.selectList(sp = new SearchParam().setQueryFields(new String[]{"id", "passport_number"}).addEQ("passport_number", (Object)cPlate).addEQ("medium_type", (Object)6).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()), CarparkPassport.class, null)) != null && !passportList.isEmpty()) {
                                                    restart = true;
                                                }
                                            }
                                            if (restart) {
                                                entry.bindSession.removeCancelPassRecord();
                                                entry.bindSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                                entry.bindSession.setSessionState(PassSession.SessionState.CANCELED);
                                                ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                                if (callback != null) {
                                                    callback.doClosePassDialog(entry.bindSession);
                                                }
                                                this.passChannel.invalidateSession(entry.bindSession);
                                                entry.bindSession.setEventPassId(null);
                                                entry.bindSession = null;
                                                throwNewPlate = true;
                                            }
                                        }
                                    }
                                }
                            } else if (bindSessionSate == PassSession.SessionState.WAIT_CAR_LEAVE || bindSessionSate == PassSession.SessionState.CAR_LEAVING || bindSessionSate == PassSession.SessionState.CAR_LEFT) {
                                if (entry.bindSession.getReadPassportNumberEvent() != null && cPlate.equals(entry.bindSession.getReadPassportNumberEvent().getPassportNumber()) && entry.bindSession.getReadPassportNumberEvent().getPassportMediumType() == 6) {
                                    String plate8;
                                    String CARSTARY_RESTART_PASS_SUCCESS;
                                    List passRecordList;
                                    boolean chekReopen = false;
                                    if (entry.bindSession == this.passChannel.getLastSession()) {
                                        passRecordList = (List)entry.bindSession.getAttribute("SAVED_PASSRECORD_LIST");
                                        if (passRecordList != null && !passRecordList.isEmpty()) {
                                            chekReopen = true;
                                        } else {
                                            CARSTARY_RESTART_PASS_SUCCESS = "CARSTARY_RESTART_PASS_SUCCESS";
                                            plate8 = (String)entry.bindSession.getAttribute(CARSTARY_RESTART_PASS_SUCCESS);
                                            if (plate8 != null && plate8.length() > 0 && plate8.equals(cPlate)) {
                                                this.passChannel.invalidateSession(entry.bindSession);
                                                entry.bindSession.setEventPassId(null);
                                                entry.bindSession = null;
                                                throwNewPlate = true;
                                            } else {
                                                entry.bindSession.setAttribute(CARSTARY_RESTART_PASS_SUCCESS, cPlate);
                                            }
                                        }
                                    } else {
                                        passRecordList = (List)entry.bindSession.getAttribute("SAVED_PASSRECORD_LIST");
                                        if (passRecordList == null || passRecordList.isEmpty()) {
                                            CARSTARY_RESTART_PASS_SUCCESS = "CARSTARY_RESTART_PASS_SUCCESS";
                                            plate8 = (String)entry.bindSession.getAttribute(CARSTARY_RESTART_PASS_SUCCESS);
                                            if (plate8 != null && plate8.length() > 0 && plate8.equals(cPlate)) {
                                                this.passChannel.invalidateSession(entry.bindSession);
                                                entry.bindSession.setEventPassId(null);
                                                entry.bindSession = null;
                                                throwNewPlate = true;
                                            } else {
                                                entry.bindSession.setAttribute(CARSTARY_RESTART_PASS_SUCCESS, cPlate);
                                            }
                                        } else {
                                            CARSTARY_RESTART_PASS_SUCCESS = "CARSTARY_RESTART_PASS_SUCCESS";
                                            plate8 = (String)entry.bindSession.getAttribute(CARSTARY_RESTART_PASS_SUCCESS);
                                            if (plate8 != null && plate8.length() > 0 && plate8.equals(cPlate)) {
                                                entry.bindSession.removeAttribute(CARSTARY_RESTART_PASS_SUCCESS);
                                                Collection<PassSession> cl = this.passChannel.getSessions();
                                                for (PassSession s : cl) {
                                                    if (s == entry.bindSession) {
                                                        chekReopen = true;
                                                        continue;
                                                    }
                                                    if (!chekReopen || s.getReadPassportNumberEvent() == null || s.getReadPassportNumberEvent().isManualTrigger() || s.getReadPassportNumberEvent().isUserScan() || s.getSessionState() == PassSession.SessionState.PENDING || this.passChannel.isSwipeCard(s) || s.getPlateRecognizedEvent() == null || s.getPlateRecognizedEvent().getPlateNumber() == null || s.getPlateRecognizedEvent().getPlateNumber().length() == 0 || "\u65e0\u724c\u8f66".equals(this.getPlate(s.getPlateRecognizedEvent().getPlateNumber()))) continue;
                                                    chekReopen = false;
                                                    break;
                                                }
                                            } else {
                                                entry.bindSession.setAttribute(CARSTARY_RESTART_PASS_SUCCESS, cPlate);
                                            }
                                        }
                                    }
                                    if (chekReopen && entry.bindSession != null) {
                                        Long firstOpenGateMills = entry.bindSession.getCarLeavingMills();
                                        if (firstOpenGateMills == null) {
                                            firstOpenGateMills = (Long)entry.bindSession.getAttribute("SAVED_PASSRECORD_MILLS");
                                        }
                                        if (firstOpenGateMills == null) {
                                            String passRecheckOpenFirstTimeMills = "passRecheckOpenFirstTimeMills";
                                            firstOpenGateMills = (Long)entry.bindSession.getAttribute(passRecheckOpenFirstTimeMills);
                                            if (firstOpenGateMills == null) {
                                                firstOpenGateMills = ServiceUtil.getServiceContext().currentTimeMillis();
                                                entry.bindSession.setAttribute(passRecheckOpenFirstTimeMills, firstOpenGateMills);
                                            }
                                        }
                                        List<Equipment> roadGateList = this.passChannel.getEquipmentList(9);
                                        LinkedList<Equipment> supportStateClosedList = null;
                                        LinkedList<Equipment> supportStateOpenedList = null;
                                        LinkedList<Equipment> notSupportStateList = null;
                                        if (roadGateList != null && !roadGateList.isEmpty()) {
                                            for (Equipment equipment : roadGateList) {
                                                RoadBarrierAction roadGateAction0;
                                                Object roadGateAction = equipment.getEquipmentAction();
                                                if (!(roadGateAction instanceof RoadBarrierAction) || !roadGateAction.isWorkingProperly() || !(roadGateAction0 = (RoadBarrierAction)roadGateAction).isSupportDownPole() || roadGateAction instanceof AlwaysOpenAction && ((AlwaysOpenAction)roadGateAction).isAlwaysOpen()) continue;
                                                if (((RoadBarrierStateSupport)roadGateAction).isSupportBarrierStateDetected()) {
                                                    if (roadGateAction.getEquipmentState() == EquipmentState.BARRIER_RAISED_IN_PLACE || roadGateAction.getEquipmentState() == EquipmentState.BARRIER_RAISING) {
                                                        if (supportStateOpenedList == null) {
                                                            supportStateOpenedList = new LinkedList<Equipment>();
                                                        }
                                                        supportStateOpenedList.add(equipment);
                                                        continue;
                                                    }
                                                    if (supportStateClosedList == null) {
                                                        supportStateClosedList = new LinkedList<Equipment>();
                                                    }
                                                    supportStateClosedList.add(equipment);
                                                    continue;
                                                }
                                                if (notSupportStateList == null) {
                                                    notSupportStateList = new LinkedList<Equipment>();
                                                }
                                                notSupportStateList.add(equipment);
                                            }
                                            if (this.isLocalHandle()) {
                                                Integer u;
                                                String reOpenGateNextMills;
                                                String reOpenGateTimes;
                                                if (supportStateClosedList != null && !supportStateClosedList.isEmpty()) {
                                                    int maxReopenTimes = 3;
                                                    reOpenGateTimes = "carStayReOpenGateTimes";
                                                    reOpenGateNextMills = "carStayReOpenGateNextMills";
                                                    u = (Integer)entry.bindSession.getAttribute(reOpenGateTimes);
                                                    Long m = (Long)entry.bindSession.getAttribute(reOpenGateNextMills);
                                                    if (u == null || u < maxReopenTimes) {
                                                        if (m != null) {
                                                            if (ServiceUtil.getServiceContext().currentTimeMillis() <= m) {
                                                                this.passChannel.openPole(entry.bindSession);
                                                                entry.bindSession.setAttribute(reOpenGateTimes, u == null ? 2 : u + 1);
                                                                entry.bindSession.setAttribute(reOpenGateNextMills, ServiceUtil.getServiceContext().currentTimeMillis() + 30000L);
                                                                ServiceLog.getLog().info((Object)(String.valueOf(event.getPlateNumber()) + "\u653e\u884c\u6210\u529f\uff0c\u4f46\u662f\u8fde\u7eed\u6ede\u7559\uff0c\u68c0\u6d4b\u5230\u9053\u95f8\u672a\u5f00\u95f8\uff0c\u90a3\u4e48\u5c1d\u8bd5\u91cd\u65b0\u5f00\u95f8"));
                                                            }
                                                        } else if (ServiceUtil.getServiceContext().currentTimeMillis() - firstOpenGateMills >= 10000L) {
                                                            this.passChannel.openPole(entry.bindSession);
                                                            entry.bindSession.setAttribute(reOpenGateTimes, 1);
                                                            entry.bindSession.setAttribute(reOpenGateNextMills, ServiceUtil.getServiceContext().currentTimeMillis() + 20000L);
                                                            ServiceLog.getLog().info((Object)(String.valueOf(event.getPlateNumber()) + "\u653e\u884c\u6210\u529f\uff0c\u4f46\u662f\u8fde\u7eed\u6ede\u7559\uff0c\u68c0\u6d4b\u5230\u9053\u95f8\u672a\u5f00\u95f8\uff0c\u90a3\u4e48\u5c1d\u8bd5\u91cd\u65b0\u5f00\u95f8"));
                                                        }
                                                    }
                                                } else if (notSupportStateList != null && !notSupportStateList.isEmpty()) {
                                                    int maxReopenTimes = 3;
                                                    reOpenGateTimes = "carStayReOpenGateTimes";
                                                    reOpenGateNextMills = "carStayReOpenGateNextMills";
                                                    u = (Integer)entry.bindSession.getAttribute(reOpenGateTimes);
                                                    Long m = (Long)entry.bindSession.getAttribute(reOpenGateNextMills);
                                                    if (u == null || u < maxReopenTimes) {
                                                        if (m != null) {
                                                            if (ServiceUtil.getServiceContext().currentTimeMillis() <= m) {
                                                                this.passChannel.openPole(entry.bindSession);
                                                                entry.bindSession.setAttribute(reOpenGateTimes, u == null ? 2 : u + 1);
                                                                entry.bindSession.setAttribute(reOpenGateNextMills, ServiceUtil.getServiceContext().currentTimeMillis() + 40000L);
                                                                ServiceLog.getLog().info((Object)(String.valueOf(event.getPlateNumber()) + "\u653e\u884c\u6210\u529f\uff0c\u4f46\u662f\u8fde\u7eed\u6ede\u7559\uff0c \u7531\u4e8e\u4e0d\u652f\u6301\u9053\u95f8\u72b6\u6001\u68c0\u6d4b\uff0c\u8d85\u65f630-40\u79d2\u540e\uff0c \u90a3\u4e48\u5c1d\u8bd5\u91cd\u65b0\u5f00\u95f8"));
                                                            }
                                                        } else if (ServiceUtil.getServiceContext().currentTimeMillis() - firstOpenGateMills >= 20000L) {
                                                            this.passChannel.openPole(entry.bindSession);
                                                            entry.bindSession.setAttribute(reOpenGateTimes, 1);
                                                            entry.bindSession.setAttribute(reOpenGateNextMills, ServiceUtil.getServiceContext().currentTimeMillis() + 30000L);
                                                            ServiceLog.getLog().info((Object)(String.valueOf(event.getPlateNumber()) + "\u653e\u884c\u6210\u529f\uff0c\u4f46\u662f\u8fde\u7eed\u6ede\u7559\uff0c \u7531\u4e8e\u4e0d\u652f\u6301\u9053\u95f8\u72b6\u6001\u68c0\u6d4b\uff0c\u8d85\u65f620\u79d2\u540e\uff0c \u90a3\u4e48\u5c1d\u8bd5\u91cd\u65b0\u5f00\u95f8"));
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } else if (entry.bindSession.getReadPassportNumberEvent() == null) {
                                    String CARSTARY_RESTART_PASS_SUCCESS = "CARSTARY_RESTART_PASS_SUCCESS";
                                    String plate8 = (String)entry.bindSession.getAttribute(CARSTARY_RESTART_PASS_SUCCESS);
                                    if (plate8 != null && plate8.length() > 0 && plate8.equals(cPlate)) {
                                        this.passChannel.invalidateSession(entry.bindSession);
                                        entry.bindSession.setEventPassId(null);
                                        entry.bindSession = null;
                                        throwNewPlate = true;
                                    } else {
                                        entry.bindSession.setAttribute(CARSTARY_RESTART_PASS_SUCCESS, cPlate);
                                    }
                                } else {
                                    ServiceLog.getLog().warn((Object)("\u68c0\u6d4b\u5230\u653e\u884c\u6210\u529f\u8f66\u8f86\u8f66\u724c: " + entry.bindSession.getPassPlate() + ", \u4e0e\u6ede\u7559\u8f66\u724c: " + cPlate + "\u4e0d\u4e00\u81f4\uff0c\u8fd9\u91cc\u4e0d\u505a\u4efb\u4f55\u5904\u7406\uff0c\u5982\u679c\u8f66\u8f86\u901a\u8fc7\u518d\u5224\u5b9a"));
                                }
                            }
                        }
                    }
                }
            }
            if (newCarEntry != null && newCarEntry.latestDetectedEvent != null) {
                PlateRecognizedEvent regPlateEvent = this.waitingNewCarEvent;
                this.removeWaitNewCarEvent();
                if (regPlateEvent != null) {
                    String alarmPlate;
                    String regPlate = this.getPlate(regPlateEvent.getPlateNumber());
                    if (regPlate.equals(alarmPlate = this.getPlate(newCarEntry.latestDetectedEvent.getPlateNumber()))) {
                        if ("\u65e0\u724c\u8f66".equals(regPlate)) {
                            if (newCarEntry.latestDetectedEvent.getRevNonTimeMills() - regPlateEvent.getRegTimeMills() < 7000L) {
                                this.onRegPlateAndDetected(regPlateEvent, newCarEntry, l);
                            } else {
                                this.currentNewCarEntry = newCarEntry;
                            }
                        } else if (newCarEntry.latestDetectedEvent.getRevNonTimeMills() - regPlateEvent.getRegTimeMills() < 10000L) {
                            this.onRegPlateAndDetected(regPlateEvent, newCarEntry, l);
                        } else {
                            this.currentNewCarEntry = newCarEntry;
                        }
                    } else if (newCarEntry.latestDetectedEvent.getRevNonTimeMills() - regPlateEvent.getRegTimeMills() < 7000L) {
                        this.onRegPlateAndDetected(regPlateEvent, newCarEntry, l);
                    } else {
                        this.currentNewCarEntry = newCarEntry;
                    }
                } else {
                    this.currentNewCarEntry = newCarEntry;
                }
            } else if (throwNewPlate) {
                this.removeWaitNewCarEvent();
                this.thorwNewRegPlateEvent(event, l);
            }
        } else if (event.getEventType() == 1) {
            long x;
            List<VehiclePassEventEntry> isStrictlyMatchRegPlate = listQueue;
            synchronized (isStrictlyMatchRegPlate) {
                if (!listQueue.isEmpty()) {
                    if (entry == null) {
                        for (VehiclePassEventEntry xE : listQueue) {
                            if (xE.isFinish() || xE.eventPassId >= event.getEventPassId() || xE.latestDetectedEvent == null || event.getRevNonTimeMills() - xE.latestDetectedEvent.getRevNonTimeMills() <= 7000L) continue;
                            x = ServiceUtil.getServiceContext().currentTimeMillis() + 15000L;
                            if (xE.validMills > x) {
                                xE.validMills = x;
                            }
                            xE.maybeLeave = true;
                        }
                    } else {
                        for (VehiclePassEventEntry xE : listQueue) {
                            if (xE != entry) {
                                if (xE.isFinish() || xE.eventPassId >= event.getEventPassId()) continue;
                                x = ServiceUtil.getServiceContext().currentTimeMillis() + 15000L;
                                if (xE.validMills > x) {
                                    xE.validMills = x;
                                }
                                xE.maybeLeave = true;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (entry != null) {
                if (entry.thoughEvent == null) {
                    entry.thoughEvent = event;
                    if (entry.bindSession != null && (entry.bindSession.getSessionState() == PassSession.SessionState.OPEN_DIALOG || entry.bindSession.getSessionState() == PassSession.SessionState.WAIT_PAY)) {
                        ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(this.passChannel.getChannelNo());
                        boolean exit = false;
                        if (channelArea != null) {
                            boolean bl = exit = channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty();
                        }
                        if (exit) {
                            String passPlate = this.getPlate(event.getPlateNumber());
                            if (passPlate != null && passPlate.length() > 0 && !UN_REG.equals(passPlate)) {
                                x = ServiceUtil.getServiceContext().currentTimeMillis() + TimeUnit.MINUTES.toMillis(15L);
                                if (entry.validMills > x) {
                                    entry.validMills = x;
                                }
                                String bigPicPath = null;
                                String smallPicPath = null;
                                try {
                                    if (event.getPicData() != null && event.getPicData().length > 0) {
                                        bigPicPath = this.savePic(((Equipment)event.getSource()).getEquipmentNo(), event.getPicFormatType(), event.getPicData(), false, event.getPlateNumber());
                                    }
                                    if (event.getPlateSmallPicData() != null && event.getPlateSmallPicData().length > 0) {
                                        smallPicPath = this.savePic(((Equipment)event.getSource()).getEquipmentNo(), event.getPlateSmallPicFormatType(), event.getPlateSmallPicData(), true, event.getPlateNumber());
                                    }
                                }
                                catch (Exception cNoPlate) {
                                    // empty catch block
                                }
                                PlateRecognizedEvent plateEvent = new PlateRecognizedEvent(this, event.getChannelNo(), event.getPlateNumber(), bigPicPath, event.getRevNonTimeMills(), event.getRevSysTimeMills());
                                plateEvent.setCarmeraRegTimeMills(event.getRevDeviceMills());
                                plateEvent.setPlateSmallPath(smallPicPath);
                                plateEvent.setPlateColor(event.getPlateColor());
                                plateEvent.setPlateConfidence(event.getPlateConfidence());
                                plateEvent.setPlateType(event.getPlateType());
                                plateEvent.setPlateTypeDes(event.getPlateTypeDes());
                                plateEvent.setCameraEquipmentNo(((Equipment)event.getSource()).getEquipmentNo());
                                plateEvent.setDir(2);
                                plateEvent.setDirDes("\u901a\u8fc7\u95f8\u673a");
                                try {
                                    RecordSaveService recrodserive = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                                    recrodserive.savePlateRecognizedEvent(plateEvent, true);
                                }
                                catch (Exception ex) {
                                    ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u8bc6\u522b\u901a\u8fc7\u65e5\u5fd7\u5931\u8d25!", (Throwable)ex);
                                }
                                ServiceLog.getLog().warn((Object)("\u79bb\u573a\u5f39\u6846\u4e2d\u6536\u5230\u8f66\u8f86" + passPlate + "\u901a\u8fc7\u4e8b\u4ef6\uff0c\u4fdd\u7559\u5f39\u6846\u4e0d\u5904\u7406"));
                            }
                        } else {
                            this.handPassThroughEntry(entry, event);
                        }
                    } else {
                        this.handPassThroughEntry(entry, event);
                    }
                }
            } else {
                this.handPassThroughEntry(null, event);
            }
        } else if (event.getEventType() == 3) {
            if (entry != null) {
                long x = ServiceUtil.getServiceContext().currentTimeMillis() + 15000L;
                if (entry.bindSession != null && (entry.bindSession.getSessionState() == PassSession.SessionState.OPEN_DIALOG || entry.bindSession.getSessionState() == PassSession.SessionState.WAIT_PAY)) {
                    ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(this.passChannel.getChannelNo());
                    boolean exit = false;
                    if (channelArea != null) {
                        boolean bl = exit = channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty();
                    }
                    if (exit) {
                        x = ServiceUtil.getServiceContext().currentTimeMillis() + TimeUnit.MINUTES.toMillis(15L);
                    }
                }
                entry.carLeaveEvent = event;
                if (entry.validMills > x) {
                    entry.validMills = x;
                }
            }
        } else if (event.getEventType() == 2) {
            String backPlate;
            if (entry != null) {
                long x = ServiceUtil.getServiceContext().currentTimeMillis() + 15000L;
                entry.carLeaveEvent = event;
                if (entry.validMills > x) {
                    entry.validMills = x;
                }
            }
            if ((backPlate = this.getPlate(event.getPlateNumber())) != null && backPlate.length() > 0) {
                boolean hasPlate = false;
                if (!"\u65e0\u724c\u8f66".equals(backPlate)) {
                    hasPlate = true;
                }
                String bigPicPath = null;
                String smallPicPath = null;
                try {
                    if (event.getPicData() != null && event.getPicData().length > 0) {
                        bigPicPath = this.savePic(((Equipment)event.getSource()).getEquipmentNo(), event.getPicFormatType(), event.getPicData(), false, event.getPlateNumber());
                    }
                    if (event.getPlateSmallPicData() != null && event.getPlateSmallPicData().length > 0) {
                        smallPicPath = this.savePic(((Equipment)event.getSource()).getEquipmentNo(), event.getPlateSmallPicFormatType(), event.getPlateSmallPicData(), true, event.getPlateNumber());
                    }
                }
                catch (Exception onlineIoAction) {
                    // empty catch block
                }
                PlateRecognizedEvent plateEvent = new PlateRecognizedEvent(this, event.getChannelNo(), event.getPlateNumber(), bigPicPath, event.getRevNonTimeMills(), event.getRevSysTimeMills());
                plateEvent.setCarmeraRegTimeMills(event.getRevDeviceMills());
                plateEvent.setPlateSmallPath(smallPicPath);
                plateEvent.setPlateColor(event.getPlateColor());
                plateEvent.setPlateConfidence(event.getPlateConfidence());
                plateEvent.setPlateType(event.getPlateType());
                plateEvent.setPlateTypeDes(event.getPlateTypeDes());
                plateEvent.setCameraEquipmentNo(((Equipment)event.getSource()).getEquipmentNo());
                plateEvent.setDir(1);
                plateEvent.setDirDes("\u5012\u8f66\u6298\u8fd4");
                try {
                    RecordSaveService recrodserive = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                    recrodserive.savePlateRecognizedEvent(plateEvent, true);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u8bc6\u522b\u901a\u8fc7\u65e5\u5fd7\u5931\u8d25!", (Throwable)ex);
                }
                if (entry != null && entry.bindSession != null) {
                    PassSession.SessionState bindSessionSate = entry.bindSession.getSessionState();
                    if (bindSessionSate == PassSession.SessionState.PENDING) {
                        if (entry.bindSession.getCarArrivedEvent() == null) {
                            VehicleDetectorEvent deEvent = new VehicleDetectorEvent((Equipment)event.getSource(), 0, 0, event.getChannelNo());
                            CarLeftEvent e = new CarLeftEvent(this, CarLeftEvent.OriginalSourceType.PLATE_RECOGNIZED, event.getChannelNo(), deEvent);
                            entry.bindSession.setCarLeftEvent(e);
                        }
                        entry.bindSession.setSessionState(PassSession.SessionState.CANCELED);
                        if (hasPlate) {
                            this.findSessionAndHanleCarBack(entry, event, plateEvent, true);
                        } else {
                            String msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u65e0\u724c\u8f66\u5df2\u6298\u8fd4, \u4f46\u662f\u8be5\u8f66\u5e76\u6ca1\u6709\u653e\u884c\u6210\u529f, \u4e0d\u7528\u505a\u4efb\u4f55\u5904\u7406";
                            ServiceLog.getLog().info((Object)msg);
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                        }
                    } else if (bindSessionSate != PassSession.SessionState.PROCESSING) {
                        if (bindSessionSate == PassSession.SessionState.CANCELED) {
                            String msg;
                            if (entry.bindSession.getCarArrivedEvent() == null) {
                                VehicleDetectorEvent deEvent = new VehicleDetectorEvent((Equipment)event.getSource(), 0, 0, event.getChannelNo());
                                CarLeftEvent e = new CarLeftEvent(this, CarLeftEvent.OriginalSourceType.PLATE_RECOGNIZED, event.getChannelNo(), deEvent);
                                entry.bindSession.setCarLeftEvent(e);
                            }
                            if (hasPlate) {
                                if (entry.bindSession.getReadPassportNumberEvent() != null && backPlate.equals(entry.bindSession.getReadPassportNumberEvent().getPassportNumber())) {
                                    msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230" + backPlate + "\u5df2\u6298\u8fd4, \u4f46\u662f\u8be5\u8f66\u5e76\u6ca1\u6709\u653e\u884c\u6210\u529f(\u5df2\u53d6\u6d88), \u4e0d\u7528\u505a\u4efb\u4f55\u5904\u7406";
                                    ServiceLog.getLog().info((Object)msg);
                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                                    this.findSessionAndHanleCarBack(entry, event, plateEvent, false);
                                } else {
                                    this.findSessionAndHanleCarBack(entry, event, plateEvent, true);
                                }
                            } else {
                                msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u65e0\u724c\u8f66\u5df2\u6298\u8fd4, \u4f46\u662f\u8be5\u8f66\u5e76\u6ca1\u6709\u653e\u884c\u6210\u529f(\u5df2\u53d6\u6d88), \u4e0d\u7528\u505a\u4efb\u4f55\u5904\u7406";
                                ServiceLog.getLog().info((Object)msg);
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                            }
                        } else if (bindSessionSate == PassSession.SessionState.WAIT_PAY || bindSessionSate == PassSession.SessionState.OPEN_DIALOG) {
                            if (entry.bindSession.getCarArrivedEvent() == null) {
                                VehicleDetectorEvent deEvent = new VehicleDetectorEvent((Equipment)event.getSource(), 0, 0, event.getChannelNo());
                                CarLeftEvent e = new CarLeftEvent(this, CarLeftEvent.OriginalSourceType.PLATE_RECOGNIZED, event.getChannelNo(), deEvent);
                                entry.bindSession.setCarLeftEvent(e);
                            }
                            if (hasPlate) {
                                if (entry.bindSession.getReadPassportNumberEvent() == null) {
                                    entry.bindSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                    entry.bindSession.setSessionState(PassSession.SessionState.CANCELED);
                                    ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                    if (callback != null && bindSessionSate == PassSession.SessionState.OPEN_DIALOG) {
                                        callback.doClosePassDialog(entry.bindSession);
                                    }
                                    this.passChannel.invalidateSession(entry.bindSession);
                                    entry.bindSession.setEventPassId(null);
                                    entry.bindSession = null;
                                    this.findSessionAndHanleCarBack(entry, event, plateEvent, true);
                                } else if (backPlate.equals(entry.bindSession.getReadPassportNumberEvent().getPassportNumber())) {
                                    this.handleBackSession(entry, plateEvent, entry.bindSession);
                                } else {
                                    String msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u6298\u8fd4\u8f66\u724c " + backPlate + "\u4e0e\u653e\u884c\u5f39\u6846" + entry.bindSession.getReadPassportNumberEvent().getPassportNumber() + "\u4e0d\u4e00\u81f4, \u4f46\u53ef\u80fd\u4e3a\u540c\u4e00\u8f86\u8f66, \u6682\u4e0d\u505a\u5904\u7406\u3002";
                                    ServiceLog.getLog().info((Object)msg);
                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                                    this.findSessionAndHanleCarBack(entry, event, plateEvent, false);
                                }
                            } else {
                                boolean closedDialog;
                                if (entry.bindSession.getReadPassportNumberEvent() == null) {
                                    closedDialog = true;
                                } else if (entry.bindSession.getReadPassportNumberEvent().isUserScan()) {
                                    closedDialog = true;
                                } else {
                                    closedDialog = false;
                                    String msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u65e0\u724c\u8f66\u5df2\u6298\u8fd4, \u4f46\u5173\u8054\u7684\u4f1a\u8bdd\u6846\u4e0d\u662f\u626b\u7801\u653e\u884c: " + entry.bindSession.getPassPlate() + ", \u6682\u4e0d\u505a\u5904\u7406";
                                    ServiceLog.getLog().info((Object)msg);
                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                                }
                                if (closedDialog) {
                                    this.handleBackSession(entry, plateEvent, entry.bindSession);
                                }
                            }
                        } else if (bindSessionSate == PassSession.SessionState.WAIT_CAR_LEAVE || bindSessionSate == PassSession.SessionState.CAR_LEAVING || bindSessionSate == PassSession.SessionState.CAR_LEFT) {
                            String msg;
                            List passRecordList;
                            if (entry.bindSession.getCarArrivedEvent() == null) {
                                VehicleDetectorEvent deEvent = new VehicleDetectorEvent((Equipment)event.getSource(), 0, 0, event.getChannelNo());
                                CarLeftEvent e = new CarLeftEvent(this, CarLeftEvent.OriginalSourceType.PLATE_RECOGNIZED, event.getChannelNo(), deEvent);
                                entry.bindSession.setCarLeftEvent(e);
                            }
                            if (hasPlate) {
                                if (entry.bindSession.getReadPassportNumberEvent() == null) {
                                    this.findSessionAndHanleCarBack(entry, event, plateEvent, true);
                                } else if (backPlate.equals(entry.bindSession.getReadPassportNumberEvent().getPassportNumber())) {
                                    passRecordList = (List)entry.bindSession.getAttribute("SAVED_PASSRECORD_LIST");
                                    if (passRecordList == null || passRecordList.isEmpty()) {
                                        this.findSessionAndHanleCarBack(entry, event, plateEvent, true);
                                    } else {
                                        this.handleBackSession(entry, plateEvent, entry.bindSession);
                                    }
                                } else {
                                    msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230" + backPlate + "\u5df2\u6298\u8fd4, \u4f46\u5173\u8054\u7684\u653e\u884c\u8f66\u8f86: " + entry.bindSession.getReadPassportNumberEvent().getPassportNumber() + " \u4e0d\u4e00\u81f4\uff0c \u6682\u4e0d\u505a\u5904\u7406";
                                    ServiceLog.getLog().info((Object)msg);
                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                                    this.findSessionAndHanleCarBack(entry, event, plateEvent, false);
                                }
                            } else if (entry.bindSession.getReadPassportNumberEvent() != null && entry.bindSession.getReadPassportNumberEvent().isUserScan()) {
                                passRecordList = (List)entry.bindSession.getAttribute("SAVED_PASSRECORD_LIST");
                                if (passRecordList == null || passRecordList.isEmpty()) {
                                    String msg2 = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u65e0\u724c\u5df2\u6298\u8fd4, \u4f46\u65e0\u5173\u8054\u7684\u653e\u884c\u8f66\u8f86\uff0c \u6682\u4e0d\u505a\u5904\u7406";
                                    ServiceLog.getLog().info((Object)msg2);
                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg2, 2, 10000));
                                } else {
                                    this.handleBackSession(entry, plateEvent, entry.bindSession);
                                }
                            } else {
                                msg = entry.bindSession.getReadPassportNumberEvent() == null ? String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u65e0\u724c\u5df2\u6298\u8fd4, \u4f46\u65e0\u5173\u8054\u7684\u653e\u884c\u8f66\u8f86\uff0c \u6682\u4e0d\u505a\u5904\u7406" : String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u65e0\u724c\u5df2\u6298\u8fd4, \u4f46\u5173\u8054\u7684\u653e\u884c\u8f66\u8f86: " + entry.bindSession.getReadPassportNumberEvent().getPassportNumber() + " \u4e0d\u4e00\u81f4\uff0c \u6682\u4e0d\u505a\u5904\u7406";
                                ServiceLog.getLog().info((Object)msg);
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                            }
                        }
                    }
                } else {
                    this.findSessionAndHanleCarBack(entry, event, plateEvent, true);
                }
            }
        }
        event.setPicData(null);
        event.setPlateSmallPicData(null);
        if (entry != null) {
            entry.detectedTimes;
        }
    }

    private boolean isLocalHandle() {
        return this.passChannel.getLanConnectManageHostState() == null;
    }

    private void handleBackSession(VehiclePassEventEntry entry7, PlateRecognizedEvent plateEvent, PassSession session) {
        if (session == null) {
            return;
        }
        String plate1 = this.getPlate(plateEvent == null ? null : plateEvent.getPlateNumber());
        boolean noplate = "\u65e0\u724c\u8f66".equals(plate1);
        PassSession.SessionState sessionSatate = session.getSessionState();
        if (sessionSatate == PassSession.SessionState.WAIT_PAY || sessionSatate == PassSession.SessionState.OPEN_DIALOG) {
            String ax;
            String msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230" + (noplate ? "\u65e0\u724c\u8f66" : plate1) + "\u5df2\u6298\u8fd4, ";
            if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isUserScan()) {
                msg = String.valueOf(msg) + "\u626b\u4e00\u626b\u653e\u884c, ";
            }
            if ((ax = session.getPassPlate()) != null && ax.length() > 0 && !ax.equals(plate1)) {
                msg = String.valueOf(msg) + "\u653e\u884c\u8f66\u724c(" + ax + "), ";
            }
            Cost cost = (Cost)session.getAttribute("pass_cost");
            msg = sessionSatate == PassSession.SessionState.OPEN_DIALOG ? (cost.getCashAndArrears().doubleValue() > 0.0 ? String.valueOf(msg) + "\u8fd9\u5c06\u5173\u95ed\u652f\u4ed8\u786e\u8ba4\u7a97\u53e3" : String.valueOf(msg) + "\u8fd9\u5c06\u5173\u95ed\u653e\u884c\u786e\u8ba4\u7a97\u53e3") : String.valueOf(msg) + "\u8fd9\u5c06\u53d6\u6d88\u652f\u4ed8\u8ba2\u5355";
            ServiceLog.getLog().info((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
            KeyValueEntry<CarparkCancelPassRecord, Collection<String>> kv = session.getOpenDialogCacnelRecord();
            if (kv != null && kv.getKey() != null) {
                if (((CarparkCancelPassRecord)kv.getKey()).getExit_time() != null) {
                    String exitRemark = ((CarparkCancelPassRecord)kv.getKey()).getExit_remark();
                    if (exitRemark == null || exitRemark.length() == 0) {
                        ((CarparkCancelPassRecord)kv.getKey()).setExit_remark("\u6298\u8fd4");
                    } else {
                        ((CarparkCancelPassRecord)kv.getKey()).setExit_remark(ServiceUtil.getString(String.valueOf(exitRemark) + "," + "\u6298\u8fd4", 100));
                    }
                    if (plateEvent.getPicDBPath() != null && plateEvent.getPicDBPath().length() > 0) {
                        ((CarparkCancelPassRecord)kv.getKey()).setExit_car_trail_pic(plateEvent.getPicDBPath());
                    }
                } else {
                    String enterRemark = ((CarparkCancelPassRecord)kv.getKey()).getEnter_remark();
                    if (enterRemark == null || enterRemark.length() == 0) {
                        ((CarparkCancelPassRecord)kv.getKey()).setEnter_remark("\u6298\u8fd4");
                    } else {
                        ((CarparkCancelPassRecord)kv.getKey()).setEnter_remark(ServiceUtil.getString(String.valueOf(enterRemark) + "," + "\u6298\u8fd4", 100));
                    }
                    if (plateEvent.getPicDBPath() != null && plateEvent.getPicDBPath().length() > 0) {
                        ((CarparkCancelPassRecord)kv.getKey()).setEnter_car_trail_pic(plateEvent.getPicDBPath());
                    }
                }
                ((CarparkCancelPassRecord)kv.getKey()).setRecord_state(32);
            }
            session.setAttribute("GUI_CANCEL", Boolean.TRUE);
            session.setSessionState(PassSession.SessionState.CANCELED);
            ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
            if (callback != null && sessionSatate == PassSession.SessionState.OPEN_DIALOG) {
                callback.doClosePassDialog(session);
            }
            this.passChannel.invalidateSession(session);
            session.setEventPassId(null);
            if (entry7 != null && entry7.bindSession == session) {
                entry7.bindSession = null;
            }
            if (!noplate && plate1 != null && plate1.length() > 0) {
                String discardResonKey = "PASS_CHANNEL_DISCARD_PLATE_" + this.passChannel.getChannelNo() + ":" + plate1;
                String discardReson = "\u68c0\u6d4b\u5230\u8be5\u8f66\u724c\u5df2\u7ecf\u5012\u8f66\u6298\u8fd4\uff0c1\u5206\u949f\u5185\u4e0d\u518d\u5904\u7406\u6b64\u8f66\u724c";
                ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)discardResonKey, (Object)discardReson, null, 60L, TimeUnit.SECONDS);
            }
        } else if (sessionSatate == PassSession.SessionState.WAIT_CAR_LEAVE || sessionSatate == PassSession.SessionState.CAR_LEAVING || sessionSatate == PassSession.SessionState.CAR_LEFT) {
            List passRecordList = (List)session.getAttribute("SAVED_PASSRECORD_LIST");
            if (passRecordList != null && !passRecordList.isEmpty()) {
                String ax;
                String msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230" + (noplate ? "\u65e0\u724c\u8f66" : plate1) + "\u5df2\u6298\u8fd4,  ";
                if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isUserScan()) {
                    msg = String.valueOf(msg) + "\u626b\u4e00\u626b\u653e\u884c, ";
                }
                if ((ax = session.getPassPlate()) != null && ax.length() > 0 && !ax.equals(plate1)) {
                    msg = String.valueOf(msg) + "\u653e\u884c\u8f66\u724c(" + ax + "), ";
                }
                msg = String.valueOf(msg) + "\u8be5\u8f66\u5df2\u653e\u884c\u6210\u529f, \u8fd9\u5c06\u56de\u6eda\u653e\u884c\u8bb0\u5f55\u3002";
                ServiceLog.getLog().info((Object)msg);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
                if (localHost == null) {
                    ServiceLog.getLog().error((Object)"\u4e3b\u673a\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5bfc\u81f4\u65e0\u6cd5\u56de\u6eda\u653e\u884c\u8bb0\u5f55");
                } else {
                    for (CarparkPassRecord r : passRecordList) {
                        if (r.getExit_time() != null && r.getExit_record_no() != null && r.getExit_record_no().length() > 0) {
                            if (localHost.getHost_no().equals(r.getExit_host_no())) {
                                PassEventHandler.rollbackPassRecord(r.getPass_time() == null ? r.getExit_time() : r.getPass_time(), 1, r.getExit_record_no(), r.getCarpark_id(), plateEvent == null ? null : plateEvent.getPicDBPath(), "\u5012\u8f66\u6298\u8fd4", 32, true);
                                continue;
                            }
                            ServiceLog.getLog().info((Object)("\u8be5\u6298\u8fd4\u56de\u6eda\u8bb0\u5f55\u5c06\u7531\u521b\u5efa\u4e3b\u673a: " + r.getExit_host_no() + " \u5904\u7406\uff0c\u672c\u673a\u4e0d\u5904\u7406\uff0c\u5982\u679c\u4e3b\u673a\u79bb\u7ebf\u6216\u672a\u6536\u5230\u6b64\u6298\u8fd4\u6d88\u606f\uff0c\u5c06\u4e22\u5f03\u672c\u6b21\u56de\u6eda\u64cd\u4f5c"));
                            continue;
                        }
                        if (r.getEnter_time() == null || r.getEnter_record_no() == null || r.getEnter_record_no().length() <= 0) continue;
                        if (localHost.getHost_no().equals(r.getEnter_host_no())) {
                            PassEventHandler.rollbackPassRecord(r.getPass_time() == null ? r.getEnter_time() : r.getPass_time(), 0, r.getEnter_record_no(), r.getCarpark_id(), plateEvent == null ? null : plateEvent.getPicDBPath(), "\u5012\u8f66\u6298\u8fd4", 32, true);
                            continue;
                        }
                        ServiceLog.getLog().info((Object)("\u8be5\u6298\u8fd4\u56de\u6eda\u8bb0\u5f55\u5c06\u7531\u521b\u5efa\u4e3b\u673a: " + r.getExit_host_no() + " \u5904\u7406\uff0c\u672c\u673a\u4e0d\u5904\u7406\uff0c\u5982\u679c\u4e3b\u673a\u79bb\u7ebf\u6216\u672a\u6536\u5230\u6b64\u6298\u8fd4\u6d88\u606f\uff0c\u5c06\u4e22\u5f03\u672c\u6b21\u56de\u6eda\u64cd\u4f5c"));
                    }
                }
                if (!noplate && plate1 != null && plate1.length() > 0) {
                    String discardResonKey = "PASS_CHANNEL_DISCARD_PLATE_" + this.passChannel.getChannelNo() + ":" + plate1;
                    String discardReson = "\u68c0\u6d4b\u5230\u8be5\u8f66\u724c\u5df2\u7ecf\u5012\u8f66\u6298\u8fd4\uff0c1\u5206\u949f\u5185\u4e0d\u518d\u5904\u7406\u6b64\u8f66\u724c";
                    ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)discardResonKey, (Object)discardReson, null, 60L, TimeUnit.SECONDS);
                }
            }
            if (entry7 != null && entry7.bindSession == session) {
                entry7.bindSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollbackPassRecord(Date passTime, int enterOrExit, String recordNo, Integer carparkId, String backDbPicPath, String reason, int causeType, boolean dispatch) {
        if (passTime == null || recordNo == null || recordNo.length() == 0) {
            return;
        }
        LinkedList<Object> insertList = new LinkedList<Object>();
        LinkedList<SearchParam> delList = new LinkedList<SearchParam>();
        LinkedList<CarparkDispatchTask> dispatchTaskList = new LinkedList<CarparkDispatchTask>();
        Object lock = ServiceUtil.getServiceContext().getKeyLockManager().getLock("PassEventHandler_rollbackPassRecord_" + recordNo);
        try {
            Object object = lock;
            synchronized (object) {
                CarparkPassRecord passRecord;
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkPassRecord.class));
                sp.addEQ("pass_time", (Object)passTime);
                if (enterOrExit == 1) {
                    sp.addEQ("exit_record_no", (Object)recordNo);
                } else {
                    sp.addEQ("enter_record_no", (Object)recordNo);
                }
                if (carparkId != null) {
                    sp.addEQ("carpark_id", (Object)carparkId);
                }
                if ((passRecord = (CarparkPassRecord)commonDaoService.selectOne(sp, CarparkPassRecord.class)) != null) {
                    CarparkCancelPassRecord cancelPassRecord;
                    long l;
                    if (passRecord.getExit_time() != null) {
                        l = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkCancelPassRecord.class)).addEQ("id", (Object)passRecord.getId()));
                        if (l == 0L) {
                            if (passRecord instanceof CarparkCancelPassRecord) {
                                cancelPassRecord = (CarparkCancelPassRecord)passRecord;
                            } else {
                                cancelPassRecord = new CarparkCancelPassRecord();
                                JavaBeanTool.copyTo((Object)passRecord, (Object)cancelPassRecord);
                                cancelPassRecord.setRecord_state(causeType);
                                cancelPassRecord.setExit_remark(reason);
                                cancelPassRecord.setExit_car_trail_pic(backDbPicPath);
                                cancelPassRecord.setCreated_time(ServiceUtil.getNow());
                            }
                            insertList.add(cancelPassRecord);
                            if (dispatch) {
                                dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkCancelPassRecord.class), cancelPassRecord.getId().toString(), "ALL_HOSTS"));
                            }
                        }
                        if (passRecord.getEnter_time() != null && passRecord.getEnter_record_no() != null && passRecord.getEnter_record_no().length() > 0) {
                            sp = new SearchParam(commonDaoService.getTableName(CarparkPassRecord.class));
                            sp.addEQ("pass_time", (Object)passRecord.getEnter_time());
                            sp.addEQ("enter_record_no", (Object)passRecord.getEnter_record_no());
                            sp.addEQ("carpark_id", (Object)passRecord.getCarpark_id());
                            CarparkPassRecord enterRecord = (CarparkPassRecord)commonDaoService.selectOne(sp, CarparkPassRecord.class);
                            if (enterRecord == null) {
                                ServiceLog.getLog().warn((Object)("\u6ca1\u8981\u627e\u5230\u79bb\u573a\u5bf9\u5e94\u7684\u5165\u573a\u8bb0\u5f55\u4fe1\u606f\uff0c\u8fd9\u5c06\u5339\u914d\u5165\u573a\u8bb0\u5f55\u4fe1\u606f\u6062\u590d\u6570\u636e, \u8fdb\u573a\u65f6\u95f4\uff1a" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(passRecord.getEnter_time()) + ", \u8fdb\u573a\u8bb0\u5f55\u7f16\u53f7\uff1a" + passRecord.getEnter_record_no() + ", " + passRecord.getPassport_number()));
                                enterRecord = new CarparkPassRecord();
                                Map methodsMap1 = JavaBeanUtil.getGetSetMethods(CarparkPassRecord.class);
                                Object[] setV = new Object[1];
                                Object[] getV = new Object[]{};
                                String ex1 = "exit_";
                                String ex2 = "discount_";
                                String ex3 = "already_";
                                String enter_balance = "enter_balance";
                                for (Map.Entry x : methodsMap1.entrySet()) {
                                    if (((JavaBeanUtil.GetSetMethod)x.getValue()).getGetMethod() == null || ((JavaBeanUtil.GetSetMethod)x.getValue()).getSetMethod() == null) continue;
                                    try {
                                        Object getValue;
                                        if (((String)x.getKey()).startsWith(ex1) || ((String)x.getKey()).startsWith(ex2) || ((String)x.getKey()).startsWith(ex3) || (getValue = ((JavaBeanUtil.GetSetMethod)x.getValue()).getGetMethod().invoke((Object)passRecord, getV)) == null) continue;
                                        if (getValue instanceof BigDecimal && !enter_balance.equals(x.getKey())) {
                                            getValue = Constants.MONEY_ZERO;
                                        }
                                        setV[0] = getValue;
                                        ((JavaBeanUtil.GetSetMethod)x.getValue()).getSetMethod().invoke((Object)enterRecord, setV);
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e.getMessage(), e);
                                    }
                                }
                                enterRecord.setEnter_time(passRecord.getEnter_time());
                                enterRecord.setEnter_record_no(passRecord.getEnter_record_no());
                                if (enterRecord.getEnter_plate() != null && enterRecord.getEnter_plate().length() > 0 && !enterRecord.getEnter_plate().equals(enterRecord.getPassport_number())) {
                                    if (enterRecord.getEnter_reg_plate() != null && enterRecord.getEnter_reg_plate().length() > 0) {
                                        if (enterRecord.getEnter_reg_plate().indexOf(26080) == -1) {
                                            enterRecord.setMedium_type(6);
                                            enterRecord.setPassport_number(enterRecord.getEnter_plate());
                                        } else if (enterRecord.getMedium_type() == null || enterRecord.getMedium_type() == 6) {
                                            enterRecord.setMedium_type(6);
                                            enterRecord.setPassport_number(enterRecord.getEnter_plate());
                                        }
                                    } else if (enterRecord.getMedium_type() == null || enterRecord.getMedium_type() == 6) {
                                        enterRecord.setMedium_type(6);
                                        enterRecord.setPassport_number(enterRecord.getEnter_plate());
                                    }
                                }
                                enterRecord.setExit_time(null);
                                enterRecord.setExit_record_no(null);
                                enterRecord.setPass_time(enterRecord.getEnter_time());
                                enterRecord.setPass_car_type_no(enterRecord.getEnter_car_type_no());
                                enterRecord.setPass_plate(enterRecord.getEnter_plate());
                                enterRecord.setPass_host_no(enterRecord.getEnter_host_no());
                                enterRecord.setPass_channel_no(enterRecord.getEnter_channel_no());
                                if (enterRecord.getRecord_no() != null) {
                                    enterRecord.setRecord_no(enterRecord.getEnter_record_no());
                                }
                                enterRecord.setCreated_time(enterRecord.getEnter_time());
                                Long newId = null;
                                try {
                                    if (enterRecord.getEnter_record_no().startsWith("C")) {
                                        newId = Long.parseLong(enterRecord.getEnter_record_no().substring(1));
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (newId == null) {
                                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                                    newId = appService.createLocalRecordSeq("ck_carpark_pass_record_seq");
                                }
                                enterRecord.setId(newId);
                            }
                            sp = new SearchParam(commonDaoService.getTableName(CarparkPassRecord.class));
                            sp.addEQ("carpark_id", (Object)enterRecord.getCarpark_id());
                            sp.addEQ("area_no", (Object)enterRecord.getArea_no());
                            sp.addEQ("passport_number", (Object)enterRecord.getPassport_number());
                            sp.addEQ("medium_type", (Object)enterRecord.getMedium_type());
                            sp.addGT("pass_time", (Object)enterRecord.getPass_time());
                            sp.addGT("enter_time", (Object)enterRecord.getEnter_time());
                            sp.addEQ("exit_time", null);
                            l = commonDaoService.selectCount(sp);
                            if (l == 0L) {
                                CarparkPresenceRecord pp;
                                sp = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
                                sp.addEQ("carpark_id", (Object)enterRecord.getCarpark_id());
                                sp.addEQ("area_no", (Object)enterRecord.getArea_no());
                                sp.addEQ("passport_number", (Object)enterRecord.getPassport_number());
                                sp.addEQ("medium_type", (Object)enterRecord.getMedium_type());
                                sp.setOrder_by("enter_time DESC");
                                CarparkPresenceRecord pr = (CarparkPresenceRecord)commonDaoService.selectOne(sp, CarparkPresenceRecord.class);
                                if (pr != null && pr.getEnter_time() != null) {
                                    if (pr.getEnter_time().before(enterRecord.getEnter_time())) {
                                        delList.add(new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class)).addEQ("id", (Object)pr.getId()));
                                        l = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class)).addEQ("id", (Object)enterRecord.getId()));
                                        if (l == 0L) {
                                            pp = new CarparkPresenceRecord();
                                            JavaBeanTool.copyTo((Object)enterRecord, (Object)pp);
                                            insertList.add(pp);
                                        } else {
                                            ServiceLog.getLog().info((Object)("\u65e0\u6cd5\u56de\u9000\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\uff0c\u5b58\u5728\u76f8\u540cid\u7684\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\uff01\u8ba1\u5212\u56de\u9000\u8fdb\u573a\u8bb0\u5f55: " + enterRecord.getPassport_number() + ", \u7f16\u53f7\uff1a" + enterRecord.getEnter_record_no() + ", \u8fdb\u573a\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(enterRecord.getEnter_time())));
                                        }
                                    } else {
                                        ServiceLog.getLog().info((Object)("\u65e0\u6cd5\u56de\u9000\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\uff0c\u6b64\u8f66\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\u5b58\u5728\u76f8\u7b49\u6216\u66f4\u65b0\u7684\u8fdb\u573a\u65f6\u95f4\uff01\u8ba1\u5212\u56de\u9000\u8fdb\u573a\u8bb0\u5f55: " + enterRecord.getPassport_number() + ", \u7f16\u53f7\uff1a" + enterRecord.getEnter_record_no() + ", \u8fdb\u573a\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(enterRecord.getEnter_time())));
                                    }
                                } else {
                                    l = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class)).addEQ("id", (Object)enterRecord.getId()));
                                    if (l == 0L) {
                                        pp = new CarparkPresenceRecord();
                                        JavaBeanTool.copyTo((Object)enterRecord, (Object)pp);
                                        insertList.add(pp);
                                    } else {
                                        ServiceLog.getLog().info((Object)("\u65e0\u6cd5\u56de\u9000\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\uff0c\u5b58\u5728\u76f8\u540cid\u7684\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\uff01\u8ba1\u5212\u56de\u9000\u8fdb\u573a\u8bb0\u5f55: " + enterRecord.getPassport_number() + ", \u7f16\u53f7\uff1a" + enterRecord.getEnter_record_no() + ", \u8fdb\u573a\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(enterRecord.getEnter_time())));
                                    }
                                }
                            } else {
                                ServiceLog.getLog().info((Object)("\u65e0\u6cd5\u56de\u9000\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\uff0c\u8be5\u8f66\u8f86\u5b58\u5728\u66f4\u65b0\u7684\u8fdb\u573a\u8bb0\u5f55\uff01\u8ba1\u5212\u56de\u9000\u8fdb\u573a\u8bb0\u5f55: " + enterRecord.getPassport_number() + ", \u7f16\u53f7\uff1a" + enterRecord.getEnter_record_no() + ", \u8fdb\u573a\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(enterRecord.getEnter_time())));
                            }
                        }
                        delList.add(new SearchParam(commonDaoService.getTableName(CarparkPassRecord.class)).addEQ("id", (Object)passRecord.getId()));
                    } else if (passRecord.getEnter_time() != null) {
                        l = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkCancelPassRecord.class)).addEQ("id", (Object)passRecord.getId()));
                        if (l == 0L) {
                            if (passRecord instanceof CarparkCancelPassRecord) {
                                cancelPassRecord = (CarparkCancelPassRecord)passRecord;
                            } else {
                                cancelPassRecord = new CarparkCancelPassRecord();
                                JavaBeanTool.copyTo((Object)passRecord, (Object)cancelPassRecord);
                                cancelPassRecord.setRecord_state(causeType);
                                cancelPassRecord.setEnter_remark(reason);
                                cancelPassRecord.setEnter_car_trail_pic(backDbPicPath);
                                cancelPassRecord.setCreated_time(ServiceUtil.getNow());
                            }
                            insertList.add(cancelPassRecord);
                            if (dispatch) {
                                dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkCancelPassRecord.class), cancelPassRecord.getId().toString(), "ALL_HOSTS"));
                            }
                        }
                        sp = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
                        sp.addEQ("carpark_id", (Object)passRecord.getCarpark_id());
                        sp.addEQ("area_no", (Object)passRecord.getArea_no());
                        sp.addEQ("passport_number", (Object)passRecord.getPassport_number());
                        sp.addEQ("medium_type", (Object)passRecord.getMedium_type());
                        sp.addEQ("enter_time", (Object)passRecord.getEnter_time());
                        sp.addEQ("enter_record_no", (Object)passRecord.getEnter_record_no());
                        delList.add(sp);
                        delList.add(new SearchParam(commonDaoService.getTableName(CarparkPassRecord.class)).addEQ("id", (Object)passRecord.getId()));
                    }
                    if (!dispatchTaskList.isEmpty()) {
                        insertList.addAll(dispatchTaskList);
                    }
                    if (!insertList.isEmpty() || !delList.isEmpty()) {
                        try (SqlSession sqlSession = commonDaoService.openSqlSession();){
                            try {
                                if (delList != null && !delList.isEmpty()) {
                                    for (SearchParam searchParam : delList) {
                                        commonDaoService.delete(sqlSession, searchParam);
                                    }
                                }
                                if (insertList != null && !insertList.isEmpty()) {
                                    for (Object e : insertList) {
                                        commonDaoService.insert(sqlSession, e);
                                    }
                                }
                                sqlSession.commit();
                            }
                            catch (Exception exception) {
                                sqlSession.rollback();
                                if (exception instanceof RuntimeException) {
                                    throw (RuntimeException)exception;
                                }
                                throw new RuntimeException(exception.getMessage(), exception);
                            }
                        }
                    }
                    if (!insertList.isEmpty()) {
                        for (Object e : insertList) {
                            if (!(e instanceof CarparkPresenceRecord)) continue;
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new PassRecordEvent(e, (CarparkPresenceRecord)e));
                        }
                    }
                    if (!dispatchTaskList.isEmpty()) {
                        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        applicationService.asynTryRunDispatchTask(dispatchTaskList);
                    }
                }
            }
        }
        finally {
            ServiceUtil.getServiceContext().getKeyLockManager().releaseLock(lock);
        }
    }

    private void handPassThroughEntry(VehiclePassEventEntry entry, VehiclePassEvent event) {
        String passPlate = this.getPlate(event.getPlateNumber());
        if (passPlate != null && passPlate.length() > 0 && !UN_REG.equals(passPlate)) {
            ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(this.passChannel.getChannelNo());
            boolean enter = false;
            boolean exit = false;
            if (channelArea != null) {
                enter = channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty();
                exit = channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty();
            }
            String bigPicPath = null;
            String smallPicPath = null;
            try {
                if (event.getPicData() != null && event.getPicData().length > 0) {
                    bigPicPath = this.savePic(((Equipment)event.getSource()).getEquipmentNo(), event.getPicFormatType(), event.getPicData(), false, event.getPlateNumber());
                }
                if (event.getPlateSmallPicData() != null && event.getPlateSmallPicData().length > 0) {
                    smallPicPath = this.savePic(((Equipment)event.getSource()).getEquipmentNo(), event.getPlateSmallPicFormatType(), event.getPlateSmallPicData(), true, event.getPlateNumber());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            PlateRecognizedEvent plateEvent = new PlateRecognizedEvent(this, event.getChannelNo(), event.getPlateNumber(), bigPicPath, event.getRevNonTimeMills(), event.getRevSysTimeMills());
            plateEvent.setCarmeraRegTimeMills(event.getRevDeviceMills());
            plateEvent.setPlateSmallPath(smallPicPath);
            plateEvent.setPlateColor(event.getPlateColor());
            plateEvent.setPlateConfidence(event.getPlateConfidence());
            plateEvent.setPlateType(event.getPlateType());
            plateEvent.setPlateTypeDes(event.getPlateTypeDes());
            plateEvent.setCameraEquipmentNo(((Equipment)event.getSource()).getEquipmentNo());
            plateEvent.setDir(2);
            plateEvent.setDirDes("\u901a\u8fc7\u95f8\u673a");
            try {
                RecordSaveService recrodserive = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                recrodserive.savePlateRecognizedEvent(plateEvent, true);
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u8bc6\u522b\u901a\u8fc7\u65e5\u5fd7\u5931\u8d25!", (Throwable)ex);
            }
            boolean hasPlate = false;
            if (passPlate != null && passPlate.length() > 0 && !"\u65e0\u724c\u8f66".equals(passPlate)) {
                hasPlate = true;
            }
            if (entry != null) {
                long x = ServiceUtil.getServiceContext().currentTimeMillis() + 15000L;
                entry.thoughEvent = event;
                if (entry.validMills > x) {
                    entry.validMills = x;
                }
                if (enter || exit) {
                    if (entry.bindSession == null) {
                        if (hasPlate) {
                            this.findSessionAndHanleCarThrough(entry, event, passPlate, plateEvent);
                        }
                    } else {
                        PassSession.SessionState bindSessionSate = entry.bindSession.getSessionState();
                        if (bindSessionSate == PassSession.SessionState.PENDING) {
                            if (entry.bindSession.getCarArrivedEvent() == null) {
                                VehicleDetectorEvent deEvent = new VehicleDetectorEvent((Equipment)event.getSource(), 0, 0, event.getChannelNo());
                                CarLeftEvent e = new CarLeftEvent(this, CarLeftEvent.OriginalSourceType.PLATE_RECOGNIZED, event.getChannelNo(), deEvent);
                                entry.bindSession.setCarLeftEvent(e);
                            }
                            entry.bindSession.setSessionState(PassSession.SessionState.CANCELED);
                            if (hasPlate) {
                                this.findSessionAndHanleCarThrough(entry, event, passPlate, plateEvent);
                            }
                        } else if (bindSessionSate != PassSession.SessionState.PROCESSING) {
                            if (bindSessionSate == PassSession.SessionState.CANCELED) {
                                if (entry.bindSession.getCarArrivedEvent() == null) {
                                    VehicleDetectorEvent deEvent = new VehicleDetectorEvent((Equipment)event.getSource(), 0, 0, event.getChannelNo());
                                    CarLeftEvent e = new CarLeftEvent(this, CarLeftEvent.OriginalSourceType.PLATE_RECOGNIZED, event.getChannelNo(), deEvent);
                                    entry.bindSession.setCarLeftEvent(e);
                                }
                                if (hasPlate) {
                                    this.findSessionAndHanleCarThrough(entry, event, passPlate, plateEvent);
                                }
                            } else if (bindSessionSate == PassSession.SessionState.WAIT_PAY || bindSessionSate == PassSession.SessionState.OPEN_DIALOG) {
                                if (entry.bindSession.getCarArrivedEvent() == null) {
                                    VehicleDetectorEvent deEvent = new VehicleDetectorEvent((Equipment)event.getSource(), 0, 0, event.getChannelNo());
                                    CarLeftEvent e = new CarLeftEvent(this, CarLeftEvent.OriginalSourceType.PLATE_RECOGNIZED, event.getChannelNo(), deEvent);
                                    entry.bindSession.setCarLeftEvent(e);
                                }
                                if (hasPlate) {
                                    String sesssionPassPlate;
                                    if (entry.bindSession.getReadPassportNumberEvent() == null) {
                                        ConfirmPassDialogCallback callback;
                                        entry.bindSession.removeCancelPassRecord();
                                        entry.bindSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                        entry.bindSession.setSessionState(PassSession.SessionState.CANCELED);
                                        if (bindSessionSate == PassSession.SessionState.OPEN_DIALOG && (callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                                            callback.doClosePassDialog(entry.bindSession);
                                        }
                                        this.passChannel.invalidateSession(entry.bindSession);
                                        entry.bindSession.setEventPassId(null);
                                        entry.bindSession = null;
                                        this.findSessionAndHanleCarThrough(entry, event, passPlate, plateEvent);
                                    } else if (exit) {
                                        if (passPlate.equals(entry.bindSession.getReadPassportNumberEvent().getPassportNumber())) {
                                            this.handleSavePassThrough(entry, entry.bindSession);
                                        } else {
                                            sesssionPassPlate = null;
                                            if (!entry.bindSession.getReadPassportNumberEvent().isManualTrigger() && !entry.bindSession.getReadPassportNumberEvent().isUserScan() && entry.bindSession.getReadPassportNumberEvent().getPassportMediumType() == 6) {
                                                sesssionPassPlate = this.getPlate(entry.bindSession.getReadPassportNumberEvent().getPassportNumber());
                                            }
                                            String saveplate = passPlate;
                                            boolean dirSaveSession = false;
                                            if (sesssionPassPlate != null && sesssionPassPlate.length() > 0) {
                                                Map areaPresenceRecordMap;
                                                CarparkPresenceRecord pR = null;
                                                CarparkArea exitArea = (CarparkArea)entry.bindSession.getAttribute("PASS_EXIT_AREA");
                                                if (exitArea != null && (areaPresenceRecordMap = (Map)entry.bindSession.getAttribute("areaPresenceRecordMap")) != null) {
                                                    pR = (CarparkPresenceRecord)areaPresenceRecordMap.get(exitArea.getArea_no());
                                                }
                                                if (pR != null) {
                                                    dirSaveSession = true;
                                                    saveplate = sesssionPassPlate;
                                                }
                                            }
                                            String msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u786e\u8ba4\u653e\u884c\u6846\u8f66\u724c: " + entry.bindSession.getPassPlate() + "\u4e0e\u5b9e\u9645\u5df2\u79bb\u573a\u7684\u8f66\u724c: " + passPlate + "\u4e0d\u4e00\u81f4, \u4f46\u7cfb\u7edf\u5224\u5b9a\u4e3a\u540c\u4e00\u8f86\u8f66, \u8fd9\u5c06\u5173\u95ed\u5f39\u6846\uff0c\u5e76\u4ee5" + saveplate + "\u6838\u9500\u8fdb\u573a\u8bb0\u5f55";
                                            ServiceLog.getLog().info((Object)msg);
                                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                                            if (dirSaveSession) {
                                                this.handleSavePassThrough(entry, entry.bindSession);
                                            } else {
                                                ConfirmPassDialogCallback callback;
                                                entry.bindSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                                entry.bindSession.setSessionState(PassSession.SessionState.CANCELED);
                                                if (bindSessionSate == PassSession.SessionState.OPEN_DIALOG && (callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                                                    callback.doClosePassDialog(entry.bindSession);
                                                }
                                                this.passChannel.invalidateSession(entry.bindSession);
                                                entry.bindSession.setEventPassId(null);
                                                entry.bindSession = null;
                                                this.findSessionAndHanleCarThrough(entry, event, passPlate, plateEvent);
                                            }
                                        }
                                    } else if (passPlate.equals(entry.bindSession.getReadPassportNumberEvent().getPassportNumber())) {
                                        this.handleSavePassThrough(entry, entry.bindSession);
                                    } else {
                                        sesssionPassPlate = null;
                                        if (!entry.bindSession.getReadPassportNumberEvent().isManualTrigger() && !entry.bindSession.getReadPassportNumberEvent().isUserScan() && entry.bindSession.getReadPassportNumberEvent().getPassportMediumType() == 6) {
                                            sesssionPassPlate = this.getPlate(entry.bindSession.getReadPassportNumberEvent().getPassportNumber());
                                        }
                                        boolean closeSessionReOpen = false;
                                        if (sesssionPassPlate != null && sesssionPassPlate.length() > 0) {
                                            SearchParam sp = new SearchParam().setQueryFields(new String[]{"id", "passport_number"}).addINList("passport_number", new Object[]{passPlate, sesssionPassPlate}).addEQ("medium_type", (Object)6).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                                            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                                            List passportList = commonDaoService.selectList(sp, CarparkPassport.class, null);
                                            boolean passDb = false;
                                            boolean sessionDb = false;
                                            if (passportList != null && !passportList.isEmpty()) {
                                                for (CarparkPassport p : passportList) {
                                                    if (passPlate.equals(p.getPassport_number())) {
                                                        passDb = true;
                                                        continue;
                                                    }
                                                    if (!sesssionPassPlate.equals(p.getPassport_number())) continue;
                                                    sessionDb = true;
                                                }
                                            }
                                            if (!sessionDb) {
                                                if (passDb) {
                                                    ServiceLog.getLog().info((Object)(String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u5f39\u6846\u7684\u662f\u6ce8\u518c\u8f66\u724c: " + sesssionPassPlate + "(\u4e34\u505c), \u73af\u5883\u76d1\u63a7\u76f8\u673a\u901a\u8fc7\u7ed9\u7684: " + passPlate + "(\u5df2\u6ce8\u518c), \u53d6\u6d88\u5e76\u4e22\u5f03\u5f39\u6846\u8f66\u724c, \u4fdd\u5b58" + passPlate + "\u4e3a\u5728\u573a\u8f66\u8f86"));
                                                    closeSessionReOpen = true;
                                                } else {
                                                    ServiceLog.getLog().info((Object)(String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u5f39\u6846\u7684\u8f66\u724c: " + sesssionPassPlate + ", \u73af\u5883\u76d1\u63a7\u76f8\u673a\u901a\u8fc7\u7ed9\u7684: " + passPlate + ", \u90fd\u662f\u4e34\u505c, \u4f7f\u7528\u73af\u5883\u76f8\u673a\u7ed9\u7684\u8f66\u724c\u4e3a\u5728\u573a\u8f66\u8f86"));
                                                    closeSessionReOpen = true;
                                                }
                                            } else {
                                                ServiceLog.getLog().info((Object)(String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u4e22\u5f03\u73af\u5883\u76d1\u63a7\u76f8\u673a\u8bc6\u522b\u79bb\u573a\u901a\u8fc7\u8f66\u724c\uff1a" + passPlate + ", \u5f39\u6846\u7684\u8f66\u724c: " + sesssionPassPlate + ", \u76f4\u63a5\u4f7f\u7528\u5f39\u6846\u8f66\u724c\u4fdd\u5b58"));
                                                this.handleSavePassThrough(entry, entry.bindSession);
                                            }
                                        } else {
                                            closeSessionReOpen = true;
                                        }
                                        if (closeSessionReOpen) {
                                            ConfirmPassDialogCallback callback;
                                            String msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u786e\u8ba4\u653e\u884c\u6846\u8f66\u724c: " + entry.bindSession.getPassPlate() + "\u4e0e\u5b9e\u9645\u5df2\u8fdb\u573a\u7684\u8f66\u724c: " + passPlate + "\u4e0d\u4e00\u81f4, \u4f46\u7cfb\u7edf\u5224\u5b9a\u4e3a\u540c\u4e00\u8f86\u8f66, \u8fd9\u5c06\u5173\u95ed\u5f39\u6846\uff0c\u5e76\u4ee5" + passPlate + "\u751f\u6210\u8fdb\u573a\u8bb0\u5f55";
                                            ServiceLog.getLog().info((Object)msg);
                                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                                            entry.bindSession.removeCancelPassRecord();
                                            entry.bindSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                            entry.bindSession.setSessionState(PassSession.SessionState.CANCELED);
                                            if (bindSessionSate == PassSession.SessionState.OPEN_DIALOG && (callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                                                callback.doClosePassDialog(entry.bindSession);
                                            }
                                            this.passChannel.invalidateSession(entry.bindSession);
                                            entry.bindSession.setEventPassId(null);
                                            entry.bindSession = null;
                                            this.findSessionAndHanleCarThrough(entry, event, passPlate, plateEvent);
                                        }
                                    }
                                } else {
                                    boolean closedDialog;
                                    if (entry.bindSession.getReadPassportNumberEvent() == null) {
                                        closedDialog = true;
                                    } else if (entry.bindSession.getReadPassportNumberEvent().isUserScan()) {
                                        closedDialog = true;
                                        String msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u65e0\u724c\u8f66" + (enter ? "\u5df2\u8fdb\u573a" : "\u5df2\u79bb\u573a") + ", \u8fd9\u5c06\u5173\u95ed\u7528\u6237\u81ea\u52a9\u626b\u7801\u786e\u8ba4\u6846: " + entry.bindSession.getPassPlate();
                                        ServiceLog.getLog().info((Object)msg);
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                                    } else {
                                        closedDialog = false;
                                    }
                                    if (closedDialog) {
                                        entry.bindSession.removeCancelPassRecord();
                                        entry.bindSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                        entry.bindSession.setSessionState(PassSession.SessionState.CANCELED);
                                        ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                        if (callback != null) {
                                            callback.doClosePassDialog(entry.bindSession);
                                        }
                                        this.passChannel.invalidateSession(entry.bindSession);
                                        entry.bindSession.setEventPassId(null);
                                        entry.bindSession = null;
                                    }
                                }
                            } else if (bindSessionSate == PassSession.SessionState.WAIT_CAR_LEAVE || bindSessionSate == PassSession.SessionState.CAR_LEAVING || bindSessionSate == PassSession.SessionState.CAR_LEFT) {
                                if (entry.bindSession.getCarArrivedEvent() == null) {
                                    VehicleDetectorEvent deEvent = new VehicleDetectorEvent((Equipment)event.getSource(), 0, 0, event.getChannelNo());
                                    CarLeftEvent e = new CarLeftEvent(this, CarLeftEvent.OriginalSourceType.PLATE_RECOGNIZED, event.getChannelNo(), deEvent);
                                    entry.bindSession.setCarLeftEvent(e);
                                }
                                if (hasPlate) {
                                    if (entry.bindSession.getReadPassportNumberEvent() == null) {
                                        this.findSessionAndHanleCarThrough(entry, event, passPlate, plateEvent);
                                    } else {
                                        List passRecordList = (List)entry.bindSession.getAttribute("SAVED_PASSRECORD_LIST");
                                        if (passRecordList == null || passRecordList.isEmpty()) {
                                            this.findSessionAndHanleCarThrough(entry, event, passPlate, plateEvent);
                                        } else if (!passPlate.equals(entry.bindSession.getReadPassportNumberEvent().getPassportNumber())) {
                                            if (exit) {
                                                boolean hasEnter = false;
                                                CarparkArea exitArea = (CarparkArea)entry.bindSession.getAttribute("PASS_EXIT_AREA");
                                                if (exitArea != null) {
                                                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                                                    SearchParam preseceRecordParam = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class)).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                                                    preseceRecordParam.addEQ("passport_number", (Object)passPlate).addEQ("medium_type", (Object)6).addEQ("area_no", (Object)exitArea.getArea_no());
                                                    preseceRecordParam.setQueryFields(new String[]{"id", "enter_record_no", "passport_number", "medium_type", "enter_time", "area_no", "enter_plate"});
                                                    CarparkPresenceRecord rr = (CarparkPresenceRecord)commonDaoService.selectOne(preseceRecordParam, CarparkPresenceRecord.class);
                                                    if (rr == null || rr.getEnter_time() == null) {
                                                        preseceRecordParam = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class)).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                                                        preseceRecordParam.setQueryFields(new String[]{"id", "enter_record_no", "passport_number", "medium_type", "enter_time", "area_no", "enter_plate"});
                                                        preseceRecordParam.addEQ("area_no", (Object)exitArea.getArea_no());
                                                        preseceRecordParam.addEQ("enter_plate", (Object)passPlate);
                                                        preseceRecordParam.setOrder_by("enter_time DESC");
                                                        rr = (CarparkPresenceRecord)commonDaoService.selectOne(preseceRecordParam, CarparkPresenceRecord.class);
                                                    }
                                                    if (rr != null && rr.getEnter_time() != null) {
                                                        hasEnter = true;
                                                    }
                                                }
                                                if (hasEnter) {
                                                    this.findSessionAndHanleCarThrough(entry, event, passPlate, plateEvent);
                                                } else {
                                                    ServiceLog.getLog().info((Object)(String.valueOf(this.passChannel.getChannel().getChannel_name()) + "\u4e22\u5f03\u73af\u5883\u76d1\u63a7\u76f8\u673a\u8bc6\u522b\u79bb\u573a\u901a\u8fc7\u8f66\u724c\uff1a" + passPlate + ", \u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u5165\u573a\u8bb0\u5f55"));
                                                }
                                            } else {
                                                String sessionPassPlate = null;
                                                if (!entry.bindSession.getReadPassportNumberEvent().isManualTrigger() && !entry.bindSession.getReadPassportNumberEvent().isUserScan() && entry.bindSession.getReadPassportNumberEvent().getPassportMediumType() == 6) {
                                                    sessionPassPlate = this.getPlate(entry.bindSession.getReadPassportNumberEvent().getPassportNumber());
                                                }
                                                boolean sessionDb = false;
                                                if (sessionPassPlate != null && sessionPassPlate.length() > 0) {
                                                    for (CarparkPassRecord r : passRecordList) {
                                                        if (r.getEnter_time() == null || r.getExit_time() != null || r.getPass_time() == null || (r.getCar_owner_no() == null || r.getCar_owner_no().length() <= 0) && (r.getPassport_no() == null || r.getPassport_no().length() <= 0 || Constants.NO_STR.equals(r.getPassport_no()))) continue;
                                                        sessionDb = true;
                                                        break;
                                                    }
                                                    if (!sessionDb) {
                                                        ServiceLog.getLog().info((Object)(String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u4e22\u5f03\u73af\u5883\u76d1\u63a7\u76f8\u673a\u8bc6\u522b\u79bb\u573a\u901a\u8fc7\u8f66\u724c\uff1a" + passPlate + ", \u4fdd\u7559\u5df2\u7ecf\u5165\u573a\u653e\u884c(\u6ce8\u518c)\u8f66\u724c: " + entry.bindSession.getPassPlate()));
                                                    } else {
                                                        ServiceLog.getLog().info((Object)(String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u4e22\u5f03\u73af\u5883\u76d1\u63a7\u76f8\u673a\u8bc6\u522b\u79bb\u573a\u901a\u8fc7\u8f66\u724c\uff1a" + passPlate + ", \u4fdd\u7559\u5df2\u7ecf\u5165\u573a\u653e\u884c(\u6ce8\u518c)\u8f66\u724c: " + entry.bindSession.getPassPlate()));
                                                    }
                                                } else {
                                                    this.findSessionAndHanleCarThrough(entry, event, passPlate, plateEvent);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else if ((enter || exit) && hasPlate) {
                this.findSessionAndHanleCarThrough(entry, event, passPlate, plateEvent);
            }
        }
    }

    private void findSessionAndHanleCarBack(VehiclePassEventEntry entry7, VehiclePassEvent event, PlateRecognizedEvent plateEvent, boolean throwMsg) {
        String passPlate = this.getPlate(event.getPlateNumber());
        if (passPlate == null || passPlate.length() == 0) {
            return;
        }
        if ("\u65e0\u724c\u8f66".equals(passPlate)) {
            if (throwMsg) {
                String msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u65e0\u724c\u8f66\u5df2\u6298\u8fd4, \u4f46\u65e0\u5173\u8054\u7684\u653e\u884c\u8f66\u8f86\uff0c \u6682\u4e0d\u505a\u5904\u7406";
                ServiceLog.getLog().info((Object)msg);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
            }
            return;
        }
        PassSession sameSession = null;
        Collection<PassSession> cls = this.passChannel.getSessions();
        for (PassSession s : cls) {
            List passRecordList;
            if (s.getReadPassportNumberEvent() == null || !passPlate.equals(s.getReadPassportNumberEvent().getPassportNumber()) && !passPlate.equals(s.getPassPlate())) continue;
            if (s.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                if (s.getReadPassportNumberEvent().isManualTrigger() || s.getReadPassportNumberEvent().isUserScan()) {
                    s.removeCancelPassRecord();
                    s.setAttribute("GUI_CANCEL", Boolean.TRUE);
                    s.setSessionState(PassSession.SessionState.CANCELED);
                    s.setEventPassId(null);
                    continue;
                }
                if (!passPlate.equals(s.getReadPassportNumberEvent().getPassportNumber())) continue;
                this.closeSessionWhenOpenDilag(sameSession);
                sameSession = s;
                continue;
            }
            if (s.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
                if (s.getReadPassportNumberEvent().isManualTrigger() || s.getReadPassportNumberEvent().isUserScan()) {
                    s.removeCancelPassRecord();
                    s.setAttribute("GUI_CANCEL", Boolean.TRUE);
                    s.setSessionState(PassSession.SessionState.CANCELED);
                    s.setEventPassId(null);
                    ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                    if (callback == null) continue;
                    callback.doClosePassDialog(s);
                    continue;
                }
                if (!passPlate.equals(s.getReadPassportNumberEvent().getPassportNumber())) continue;
                this.closeSessionWhenOpenDilag(sameSession);
                sameSession = s;
                continue;
            }
            if (s.getSessionState() != PassSession.SessionState.WAIT_CAR_LEAVE && s.getSessionState() != PassSession.SessionState.CAR_LEAVING && s.getSessionState() != PassSession.SessionState.CAR_LEFT || !passPlate.equals(s.getReadPassportNumberEvent().getPassportNumber()) || (passRecordList = (List)s.getAttribute("SAVED_PASSRECORD_LIST")) == null || passRecordList.isEmpty()) continue;
            this.closeSessionWhenOpenDilag(sameSession);
            sameSession = s;
        }
        if (sameSession != null) {
            this.handleBackSession(entry7, plateEvent, sameSession);
        } else if (throwMsg) {
            String msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b\u5230\u8f66\u8f86" + passPlate + "\u5df2\u6298\u8fd4, \u4f46\u65e0\u5173\u8054\u7684\u653e\u884c\u8f66\u8f86\uff0c \u6682\u4e0d\u505a\u5904\u7406";
            ServiceLog.getLog().info((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
        }
    }

    private void findSessionAndHanleCarThrough(VehiclePassEventEntry entry7, VehiclePassEvent event, String passPlate, PlateRecognizedEvent plateEvent) {
        if ((passPlate = this.getPlate(passPlate)) == null || passPlate.length() == 0) {
            return;
        }
        if ("\u65e0\u724c\u8f66".equals(passPlate)) {
            return;
        }
        ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(this.passChannel.getChannelNo());
        boolean enter = false;
        boolean exit = false;
        if (channelArea != null) {
            enter = channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty();
            boolean bl = exit = channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty();
        }
        if (!enter && !exit) {
            return;
        }
        PassSession sameSession = null;
        Collection<PassSession> cls = this.passChannel.getSessions();
        for (PassSession s : cls) {
            List passRecordList;
            if (s.getReadPassportNumberEvent() == null || !passPlate.equals(s.getReadPassportNumberEvent().getPassportNumber()) && !passPlate.equals(s.getPassPlate())) continue;
            if (s.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                if (s.getReadPassportNumberEvent().isManualTrigger() || s.getReadPassportNumberEvent().isUserScan()) {
                    s.removeCancelPassRecord();
                    s.setAttribute("GUI_CANCEL", Boolean.TRUE);
                    s.setSessionState(PassSession.SessionState.CANCELED);
                    s.setEventPassId(null);
                    continue;
                }
                if (!passPlate.equals(s.getReadPassportNumberEvent().getPassportNumber())) continue;
                this.closeSessionWhenOpenDilag(sameSession);
                sameSession = s;
                continue;
            }
            if (s.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
                if (s.getReadPassportNumberEvent().isManualTrigger() || s.getReadPassportNumberEvent().isUserScan()) {
                    s.removeCancelPassRecord();
                    s.setAttribute("GUI_CANCEL", Boolean.TRUE);
                    s.setSessionState(PassSession.SessionState.CANCELED);
                    s.setEventPassId(null);
                    ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                    if (callback == null) continue;
                    callback.doClosePassDialog(s);
                    continue;
                }
                if (!passPlate.equals(s.getReadPassportNumberEvent().getPassportNumber())) continue;
                this.closeSessionWhenOpenDilag(sameSession);
                sameSession = s;
                continue;
            }
            if (s.getSessionState() != PassSession.SessionState.WAIT_CAR_LEAVE && s.getSessionState() != PassSession.SessionState.CAR_LEAVING && s.getSessionState() != PassSession.SessionState.CAR_LEFT || (passRecordList = (List)s.getAttribute("SAVED_PASSRECORD_LIST")) == null || passRecordList.isEmpty() || !passPlate.equals(s.getReadPassportNumberEvent().getPassportNumber())) continue;
            this.closeSessionWhenOpenDilag(sameSession);
            sameSession = s;
        }
        boolean discard = false;
        if (sameSession == null) {
            sameSession = this.findSamePlatePassSession(passPlate, true);
            boolean bl = discard = sameSession != null;
        }
        if (sameSession != null) {
            if (!(discard || sameSession.getSessionState() != PassSession.SessionState.WAIT_PAY && sameSession.getSessionState() != PassSession.SessionState.OPEN_DIALOG)) {
                this.handleSavePassThrough(entry7, sameSession);
            }
        } else if (this.isLocalHandle()) {
            Date passTime;
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            Date now = cl.getTime();
            if (entry7 != null && entry7.latestDetectedEvent != null) {
                cl.setTimeInMillis(entry7.latestDetectedEvent.getRevSysTimeMills());
                cl.set(14, 0);
                passTime = cl.getTime();
            } else {
                cl.setTimeInMillis(event.getRevSysTimeMills());
                if ("wlyk_zsrg_ip_camera_driver".equals(((Equipment)event.getSource()).getDriver().getName())) {
                    cl.add(13, -10);
                }
                cl.set(14, 0);
                passTime = cl.getTime();
            }
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            boolean needOpenSession = false;
            if (enter) {
                String areaNo = channelArea.getEnterAreas().get(0).getArea_no();
                SearchParam preseceRecordParam = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
                preseceRecordParam.addEQ("passport_number", (Object)passPlate).addEQ("medium_type", (Object)6).addEQ("area_no", (Object)areaNo).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                preseceRecordParam.setQueryFields(new String[]{"id", "enter_record_no", "passport_number", "medium_type", "enter_time", "area_no", "enter_plate", "enter_channel_no"});
                CarparkPresenceRecord rr = (CarparkPresenceRecord)commonDaoService.selectOne(preseceRecordParam, CarparkPresenceRecord.class);
                if (rr == null || rr.getEnter_time() == null) {
                    needOpenSession = true;
                } else if (rr.getEnter_time().getTime() < passTime.getTime()) {
                    if (this.passChannel.getChannelNo().equals(rr.getEnter_channel_no())) {
                        if (passTime.getTime() - rr.getEnter_time().getTime() > 60000L) {
                            needOpenSession = true;
                        }
                    } else {
                        needOpenSession = true;
                    }
                }
            } else {
                SearchParam preseceRecordParam = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
                preseceRecordParam.addEQ("passport_number", (Object)passPlate).addEQ("medium_type", (Object)6).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                if (channelArea.getExitAreas().size() == 1) {
                    preseceRecordParam.addEQ("area_no", (Object)channelArea.getExitAreas().get(0).getArea_no());
                } else {
                    for (CarparkArea area : channelArea.getExitAreas()) {
                        preseceRecordParam.addIN("area_no", (Object)area.getArea_no());
                    }
                }
                preseceRecordParam.setQueryFields(new String[]{"id", "enter_record_no", "passport_number", "medium_type", "enter_time", "area_no", "enter_plate", "enter_channel_no"});
                preseceRecordParam.setOrder_by("enter_time DESC");
                CarparkPresenceRecord rr = (CarparkPresenceRecord)commonDaoService.selectOne(preseceRecordParam, CarparkPresenceRecord.class);
                if (rr != null) {
                    needOpenSession = true;
                } else {
                    SearchParam searchParam = new SearchParam(commonDaoService.getTableName(CarparkPassRecord.class));
                    searchParam.addEQ("passport_number", (Object)passPlate).addEQ("medium_type", (Object)6).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                    searchParam.addEQ("pass_plate", (Object)passPlate);
                    if (channelArea.getExitAreas().size() == 1) {
                        searchParam.addEQ("area_no", (Object)channelArea.getExitAreas().get(0).getArea_no());
                    } else {
                        for (CarparkArea area : channelArea.getExitAreas()) {
                            searchParam.addIN("area_no", (Object)area.getArea_no());
                        }
                    }
                    cl.setTime(now);
                    cl.add(12, -15);
                    searchParam.addGTE("pass_time", (Object)cl.getTime());
                    cl.add(12, 16);
                    searchParam.addLTE("pass_time", (Object)cl.getTime());
                    searchParam.addNotEQ("exit_time", null);
                    searchParam.setQueryFields(new String[]{"id", "enter_record_no", "exit_record_no", "passport_number", "medium_type", "area_no", "pass_time", "pass_plate", "enter_time", "enter_channel_no", "enter_plate", "exit_time", "exit_channel_no", "exit_plate"});
                    searchParam.setOrder_by("pass_time DESC");
                    CarparkPassRecord passRecord = (CarparkPassRecord)commonDaoService.selectOne(searchParam, CarparkPassRecord.class);
                    if (passRecord != null) {
                        if (passRecord.getExit_time() != null) {
                            if (passRecord.getExit_time().getTime() < passTime.getTime()) {
                                if (this.passChannel.getChannelNo().equals(passRecord.getExit_channel_no())) {
                                    if (passTime.getTime() - passRecord.getExit_time().getTime() > 60000L) {
                                        needOpenSession = true;
                                    }
                                } else {
                                    needOpenSession = true;
                                }
                            }
                        } else {
                            needOpenSession = true;
                        }
                    } else {
                        needOpenSession = true;
                    }
                }
            }
            if (needOpenSession) {
                if (!passPlate.equals(plateEvent.getPlateNumber())) {
                    plateEvent.setPlateNumber(passPlate);
                }
                ReadPassportNumberEvent revent = new ReadPassportNumberEvent(plateEvent.getSource(), plateEvent.getPlateNumber(), 6, this.passChannel.getChannelNo());
                revent.setPlateNumber(plateEvent.getPlateNumber());
                revent.setPlateRecognizedEvent(plateEvent);
                plateEvent.setEventPassId(null);
                PassSession newSession = this.passChannel.openSessionBefore(null);
                try {
                    newSession.setReadPassportNumberEvent(revent);
                    newSession.setPlateRecognizedEvent(plateEvent);
                    newSession.setAttribute("passTime", passTime);
                    newSession.setAttribute("UNPAY_OR_UNCONFIRM_THROUGH", Boolean.TRUE);
                    newSession.setAttribute(SavePassDataFilterInterceptor.class.getName(), new SavePassDataFilterInterceptor(){

                        @Override
                        public boolean onFilterBefore(PassSession session) {
                            Cost cost;
                            boolean enter;
                            ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
                            boolean exit = channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty();
                            boolean bl = enter = channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty();
                            if (exit) {
                                String msg;
                                cost = (Cost)session.getAttribute("pass_cost");
                                if (cost != null && cost.getCash().doubleValue() > 0.0) {
                                    msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + ": \u68c0\u6d4b" + session.getPassPlate() + "\u672a\u652f\u4ed8" + cost.getCash() + "\u5143\u79bb\u573a, ";
                                    msg = String.valueOf(msg) + "\u8fd9\u5c06\u6838\u9500\u573a\u5185\u8bb0\u5f55\u5e76\u5217\u5165\u9003\u8d39\u8ba2\u5355";
                                } else {
                                    msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + ": \u68c0\u6d4b" + session.getPassPlate() + "\u672a\u5904\u7406\u76f4\u63a5\u79bb\u573a";
                                    msg = String.valueOf(msg) + "\u8fd9\u5c06\u6838\u9500\u573a\u5185\u8bb0\u5f55";
                                }
                                ServiceLog.getLog().info((Object)msg);
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 2, 10000));
                            } else {
                                String msg = String.valueOf(PassEventHandler.this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b" + session.getPassPlate() + "\u672a\u5904\u7406\u76f4\u63a5\u8fdb\u573a, ";
                                msg = String.valueOf(msg) + "\u8fd9\u5c06\u751f\u6210\u8fdb\u573a\u8bb0\u5f55";
                                ServiceLog.getLog().info((Object)msg);
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                            }
                            if (exit) {
                                cost = (Cost)session.getAttribute("pass_cost");
                                if (cost != null && cost.getCash().doubleValue() > 0.0) {
                                    KeyValueEntry<CarparkCancelPassRecord, Collection<String>> kv = session.getOpenDialogCacnelRecord();
                                    RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                                    if (kv == null) {
                                        kv = recordSaveService.createCancelPassRecrod(session);
                                    }
                                    if (kv != null && kv.getKey() != null) {
                                        CarparkCancelPassRecord r = (CarparkCancelPassRecord)kv.getKey();
                                        r.setExit_remark("\u672a\u652f\u4ed8\u76f4\u63a5\u79bb\u573a");
                                        r.setRecord_state(31);
                                        r.setCreated_time(ServiceUtil.getNow());
                                        session.doSaveCancelPassRecrodIfExist0(kv);
                                    }
                                    if (!enter) {
                                        session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                        session.setSessionState(PassSession.SessionState.CANCELED);
                                        return false;
                                    }
                                    session.setAttribute("ONLY_SAVE_ENTER_AREA_RECORD", Boolean.TRUE);
                                } else {
                                    session.removeAttribute("ESCAPE_ORDER");
                                    session.removeAttribute("IGNORE_ESCAPE_ORDER_COST");
                                }
                            }
                            if (enter) {
                                session.removeAttribute("ESCAPE_ORDER");
                                session.removeAttribute("IGNORE_ESCAPE_ORDER_COST");
                                session.setAttribute("pass_cost", new Cost());
                            }
                            return true;
                        }

                        @Override
                        public void onSetSaveDataValue(SavePassData saveData, PassSession session) {
                        }
                    });
                    newSession.start();
                }
                finally {
                    this.passChannel.invalidateSession(newSession);
                }
            }
        }
    }

    private void closeSessionWhenOpenDilag(PassSession sameSession) {
        if (sameSession != null && (sameSession.getSessionState() == PassSession.SessionState.WAIT_PAY || sameSession.getSessionState() == PassSession.SessionState.OPEN_DIALOG)) {
            ConfirmPassDialogCallback callback;
            boolean closeDilog = sameSession.getSessionState() == PassSession.SessionState.OPEN_DIALOG;
            sameSession.removeCancelPassRecord();
            sameSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
            sameSession.setSessionState(PassSession.SessionState.CANCELED);
            sameSession.setEventPassId(null);
            if (closeDilog && (callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                callback.doClosePassDialog(sameSession);
            }
        }
    }

    private void handleSavePassThrough(VehiclePassEventEntry entry, PassSession session) {
        block33: {
            try {
                ConfirmPassDialogCallback callback;
                Cost cost;
                boolean localHandle;
                ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(this.passChannel.getChannelNo());
                boolean enter = false;
                boolean exit = false;
                if (channelArea != null) {
                    enter = channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty();
                    exit = channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty();
                }
                String passPlate = session.getPassPlate();
                PassSession.SessionState bs = session.getSessionState();
                boolean onlySaveEnterIfNeed = false;
                boolean passed = false;
                boolean bl = localHandle = this.passChannel.getLanConnectManageHostState() == null || session.getAttribute("CONFIRM_SESSION_DATA_FROM_BOX") == null;
                if (exit) {
                    String msg;
                    cost = (Cost)session.getAttribute("pass_cost");
                    if (cost != null && cost.getCash().doubleValue() > 0.0) {
                        msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b" + passPlate + "\u672a\u652f\u4ed8" + cost.getCash() + "\u5143\u79bb\u573a, ";
                        msg = bs == PassSession.SessionState.OPEN_DIALOG ? String.valueOf(msg) + "\u8fd9\u5c06\u5173\u95ed\u5f85\u652f\u4ed8\u786e\u8ba4\u7a97\u53e3, \u6838\u9500\u573a\u5185\u8bb0\u5f55\u5e76\u5217\u5165\u9003\u8d39\u8ba2\u5355" : String.valueOf(msg) + "\u8fd9\u5c06\u6838\u9500\u573a\u5185\u8bb0\u5f55\u5e76\u5217\u5165\u9003\u8d39\u8ba2\u5355";
                    } else {
                        msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b" + passPlate + "\u672a\u7ecf\u786e\u8ba4\u79bb\u573a";
                        msg = bs == PassSession.SessionState.OPEN_DIALOG ? String.valueOf(msg) + "\u8fd9\u5c06\u5173\u95ed\u5f39\u6846\u5e76\u6838\u9500\u573a\u5185\u8bb0\u5f55" : String.valueOf(msg) + "\u8fd9\u5c06\u6838\u9500\u573a\u5185\u8bb0\u5f55";
                    }
                    ServiceLog.getLog().info((Object)msg);
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                } else {
                    String msg = String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u68c0\u6d4b" + passPlate;
                    msg = bs == PassSession.SessionState.OPEN_DIALOG ? String.valueOf(msg) + "\u672a\u7ecf\u786e\u8ba4\u8fdb\u573a, \u8fd9\u5c06\u5173\u95ed\u786e\u8ba4\u7a97\u53e3\u5e76\u751f\u6210\u8fdb\u573a\u8bb0\u5f55" : String.valueOf(msg) + "\u672a\u5904\u7406\u76f4\u63a5\u5165\u573a, \u8fd9\u5c06\u751f\u6210\u8fdb\u573a\u8bb0\u5f55";
                    ServiceLog.getLog().info((Object)msg);
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 10000));
                }
                if (localHandle) {
                    if (exit) {
                        cost = (Cost)session.getAttribute("pass_cost");
                        session.removeAttribute("ESCAPE_ORDER");
                        session.removeAttribute("IGNORE_ESCAPE_ORDER_COST");
                        session.setAttribute("UNPAY_OR_UNCONFIRM_THROUGH", Boolean.TRUE);
                        if (cost.getCash().doubleValue() > 0.0) {
                            KeyValueEntry<CarparkCancelPassRecord, Collection<String>> kv = session.getOpenDialogCacnelRecord();
                            RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                            if (kv == null) {
                                kv = recordSaveService.createCancelPassRecrod(session);
                            }
                            if (kv != null && kv.getKey() != null) {
                                CarparkCancelPassRecord r = (CarparkCancelPassRecord)kv.getKey();
                                r.setExit_remark("\u672a\u652f\u4ed8\u76f4\u63a5\u79bb\u573a");
                                r.setRecord_state(31);
                                r.setCreated_time(ServiceUtil.getNow());
                                session.doSaveCancelPassRecrodIfExist0(kv);
                            }
                            onlySaveEnterIfNeed = true;
                            if (!enter) {
                                ConfirmPassDialogCallback callback2;
                                session.removeCancelPassRecord();
                                session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                session.setSessionState(PassSession.SessionState.CANCELED);
                                if (bs == PassSession.SessionState.OPEN_DIALOG && (callback2 = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                                    callback2.doClosePassDialog(session);
                                }
                            }
                        } else {
                            ConfirmPassDialogCallback callback3;
                            passed = true;
                            if (bs == PassSession.SessionState.OPEN_DIALOG) {
                                session.setAttribute("UNPAY_OR_UNCONFIRM_THROUGH_REMARK", "\u672a\u786e\u8ba4\u76f4\u63a5\u79bb\u573a");
                            } else {
                                session.setAttribute("UNPAY_OR_UNCONFIRM_THROUGH_REMARK", "\u672a\u5904\u7406\u76f4\u63a5\u79bb\u573a");
                            }
                            try {
                                if (session.getConfirmPassFilter() == null) {
                                    ServiceUtil.getServiceContext().getPassFilterChain().excecutePassFilterAndBehind(session, ServiceUtil.getServiceContext().getPassFilterChain().getSavePassDataFilter());
                                } else {
                                    ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(session, session.getConfirmPassFilter());
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)"\u653e\u884c\u5f02\u5e38", (Throwable)ex);
                                session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                session.setSessionState(PassSession.SessionState.CANCELED);
                            }
                            if (bs == PassSession.SessionState.OPEN_DIALOG && (callback3 = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                                callback3.doClosePassDialog(session);
                            }
                        }
                    }
                    if (!enter || passed) break block33;
                    if (onlySaveEnterIfNeed) {
                        session.setAttribute("ONLY_SAVE_ENTER_AREA_RECORD", Boolean.TRUE);
                    }
                    session.removeAttribute("ESCAPE_ORDER");
                    session.removeAttribute("IGNORE_ESCAPE_ORDER_COST");
                    session.setAttribute("pass_cost", new Cost());
                    session.setAttribute("UNPAY_OR_UNCONFIRM_THROUGH", Boolean.TRUE);
                    if (bs == PassSession.SessionState.OPEN_DIALOG) {
                        session.setAttribute("UNPAY_OR_UNCONFIRM_THROUGH_REMARK", "\u672a\u786e\u8ba4\u76f4\u63a5\u8fdb\u573a");
                    } else {
                        session.setAttribute("UNPAY_OR_UNCONFIRM_THROUGH_REMARK", "\u672a\u5904\u7406\u76f4\u63a5\u5165\u573a");
                    }
                    try {
                        if (session.getConfirmPassFilter() == null) {
                            ServiceUtil.getServiceContext().getPassFilterChain().excecutePassFilterAndBehind(session, ServiceUtil.getServiceContext().getPassFilterChain().getSavePassDataFilter());
                        } else {
                            ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(session, session.getConfirmPassFilter());
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)"\u653e\u884c\u5f02\u5e38", (Throwable)ex);
                        session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                        session.setSessionState(PassSession.SessionState.CANCELED);
                    }
                    if (bs == PassSession.SessionState.OPEN_DIALOG && (callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                        callback.doClosePassDialog(session);
                    }
                    break block33;
                }
                session.removeCancelPassRecord();
                session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                session.setSessionState(PassSession.SessionState.CANCELED);
                if (bs == PassSession.SessionState.OPEN_DIALOG && (callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                    callback.doClosePassDialog(session);
                }
            }
            finally {
                if (entry != null && entry.bindSession != null && entry.bindSession == session) {
                    entry.bindSession = null;
                }
                session.setEventPassId(null);
                this.passChannel.invalidateSession(session);
            }
        }
    }

    private void thorwNewRegPlateEvent(VehiclePassEvent event, CarChannelPassProcessEventListener l) {
        String bigPicPath = null;
        String smallPicPath = null;
        try {
            if (event.getPicData() != null && event.getPicData().length > 0) {
                bigPicPath = this.savePic(((Equipment)event.getSource()).getEquipmentNo(), event.getPicFormatType(), event.getPicData(), false, event.getPlateNumber());
            }
            if (event.getPlateSmallPicData() != null && event.getPlateSmallPicData().length > 0) {
                smallPicPath = this.savePic(((Equipment)event.getSource()).getEquipmentNo(), event.getPlateSmallPicFormatType(), event.getPlateSmallPicData(), true, event.getPlateNumber());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlateRecognizedEvent plateEvent = new PlateRecognizedEvent(this, event.getChannelNo(), event.getPlateNumber(), bigPicPath, event.getRevNonTimeMills(), event.getRevSysTimeMills());
        plateEvent.setCarmeraRegTimeMills(event.getRevDeviceMills());
        plateEvent.setPlateSmallPath(smallPicPath);
        plateEvent.setPlateColor(event.getPlateColor());
        plateEvent.setCameraEquipmentNo(((Equipment)event.getSource()).getEquipmentNo());
        plateEvent.setPlateConfidence(event.getPlateConfidence());
        plateEvent.setPlateType(event.getPlateType());
        plateEvent.setPlateTypeDes(event.getPlateTypeDes());
        plateEvent.setEventPassId(event.getEventPassId());
        plateEvent.setDir(0);
        plateEvent.setDirDes("\u68c0\u6d4b\u5230\u8f66\u8f86(\u6765\u8f66\u6216\u6ede\u7559)");
        try {
            RecordSaveService recrodserive = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            recrodserive.savePlateRecognizedEvent(plateEvent, true);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u8bc6\u522b\u65e5\u5fd7\u5931\u8d25!", (Throwable)ex);
        }
        l.handlePlateRecognizedEvent(plateEvent);
    }

    private String savePic(String eqNo, int imgType, byte[] imgData, boolean small, String plate) {
        if (imgData == null || imgData.length == 0) {
            return null;
        }
        try {
            byte[] saveImageData;
            int height;
            int width;
            String namex;
            long xatime = System.currentTimeMillis();
            Random r = new Random();
            int ranx = Math.abs(r.nextInt());
            if (plate != null && plate.length() > 0) {
                byte[] b1;
                try {
                    b1 = plate.getBytes("GB2312");
                }
                catch (Exception ex) {
                    b1 = plate.getBytes();
                }
                String plateHex = BytesTool.byteArrayToHexString((byte[])b1);
                namex = small ? "plateSmall_" + plateHex : "plate_" + plateHex;
            } else {
                namex = "snapshot_";
            }
            if (small) {
                width = 105;
                height = 35;
            } else {
                width = 1024;
                height = 576;
            }
            StringBuilder fileNameBtr = new StringBuilder(128).append(namex).append('_').append(xatime).append('_').append(ranx);
            try {
                byte[] d = ServiceUtil.compressPic(new ByteArrayInputStream(imgData), width, height, 0.75f);
                if (d != null && d.length > 0) {
                    saveImageData = d;
                    fileNameBtr.append(".jpg");
                } else {
                    if (imgType == 0) {
                        fileNameBtr.append(".jpg");
                    } else {
                        fileNameBtr.append(".png");
                    }
                    saveImageData = imgData;
                }
            }
            catch (Exception ex) {
                if (imgType == 0) {
                    fileNameBtr.append(".jpg");
                } else {
                    fileNameBtr.append(".png");
                }
                saveImageData = imgData;
            }
            File saveF = new File(this.getPicSaveDir(eqNo), fileNameBtr.toString());
            try (FileOutputStream out = new FileOutputStream(saveF);){
                out.write(saveImageData);
            }
            return saveF.getAbsolutePath();
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u5904\u7406\u56fe\u7247\u5f02\u5e38: ", (Throwable)ex);
            return null;
        }
    }

    public File getPicSaveDir(String eqNo) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        File dateDir = new File(PathFinder.findLocalPicDir(), df.format(new Date()));
        File eqFile = new File(dateDir, eqNo);
        if (!eqFile.exists()) {
            eqFile.mkdirs();
        }
        return eqFile;
    }

    public String getPlate(String plateNumber) {
        boolean noPlate;
        if (plateNumber == null) {
            return "";
        }
        if (plateNumber.length() == 0) {
            return "";
        }
        boolean bl = noPlate = plateNumber.equals("\u65e0\u724c\u8f66") || plateNumber.equals("\u65e0\u8f66\u724c") || plateNumber.indexOf("_\u65e0_") != -1;
        if (noPlate) {
            return "\u65e0\u724c\u8f66";
        }
        return plateNumber;
    }

    public PassSession findSamePlatePassSession(String plateNumber, boolean like) {
        if (plateNumber == null || plateNumber.length() == 0) {
            return null;
        }
        if ("\u65e0\u724c\u8f66".equals(plateNumber = this.getPlate(plateNumber))) {
            return null;
        }
        PassSession samePlate = null;
        PassSession samePlate1 = null;
        PassSession likePlate = null;
        Collection<PassSession> cls = this.passChannel.getSessions();
        if (cls != null) {
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            for (PassSession s : cls) {
                if (s.getPlateRecognizedEvent() != null) {
                    String xplate = this.getPlate(s.getPlateRecognizedEvent().getPlateNumber());
                    if (plateNumber.equals(xplate)) {
                        samePlate = s;
                        continue;
                    }
                    if (!applicationService.plateEquals(plateNumber, xplate, 1)) continue;
                    likePlate = s;
                    continue;
                }
                if (!plateNumber.equals(s.getPassPlate())) continue;
                samePlate1 = s;
            }
        }
        if (samePlate != null) {
            return samePlate;
        }
        if (samePlate1 != null) {
            return samePlate1;
        }
        if (like && likePlate != null) {
            return likePlate;
        }
        return null;
    }

    private void logDiscardPlate() {
        final PlateRecognizedEvent plateRecognizedEvent0 = this.waitingNewCarEvent;
        if (plateRecognizedEvent0 != null) {
            ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)("PassEventHandler." + this.passChannel.getChannelNo() + "." + plateRecognizedEvent0.getCameraEquipmentNo() + plateRecognizedEvent0.getRegTimeMills()), (Object)plateRecognizedEvent0, new TimeoutObjectPool.TimeoutCallback(){

                public void onTimeout(Object key, Object value) throws Exception {
                    if (value == PassEventHandler.this.waitingNewCarEvent) {
                        if (PassEventHandler.this.getWorkNormalVehiclePassDetectedAction() == null) {
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(plateRecognizedEvent0);
                        } else {
                            ServiceLog.getLog().error((Object)(String.valueOf(PassEventHandler.this.passChannel.getChannel().getChannel_name()) + ": \u4e22\u5f03\u8f66\u724c\u8bc6\u522b\uff1a " + ((PlateRecognizedEvent)value).getPlateNumber() + ", \u539f\u56e05s\u5185\u6ca1\u6709\u6536\u5230\u73af\u5883\u76f8\u673a\u8f66\u8f86\u6ede\u7559\u4e8b\u4ef6"));
                        }
                    }
                }
            }, 7000L, TimeUnit.MILLISECONDS);
        }
    }

    private void removeWaitNewCarEvent() {
        PlateRecognizedEvent plateRecognizedEvent0 = this.waitingNewCarEvent;
        if (plateRecognizedEvent0 != null) {
            this.waitingNewCarEvent = null;
            ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)("PassEventHandler." + this.passChannel.getChannelNo() + "." + plateRecognizedEvent0.getCameraEquipmentNo() + plateRecognizedEvent0.getRegTimeMills()));
        }
    }

    private boolean isStrictlyMatchRegPlate(EquipmentAction vehiclePassDetectedAction) {
        if (vehiclePassDetectedAction == null) {
            return false;
        }
        return this.isStrictlyMatchRegPlate(vehiclePassDetectedAction.getEquipment());
    }

    private boolean isStrictlyMatchRegPlate(Equipment equipment) {
        String configValue;
        return equipment != null && (configValue = equipment.getEquipmentConfig().getConfigValue("strictlyMatchRegPlate")) != null && configValue.length() > 0 && Constants.YES_STR.equals(configValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void handlePlateRecognized(PlateRecognizedEvent plateRecognizedEvent, CarChannelPassProcessEventListener l) {
        VehiclePassEventEntry newCarEntry;
        List<VehiclePassEventEntry> list;
        PassSession lastSession;
        Object rId;
        boolean noPlate;
        if (plateRecognizedEvent.getPlateNumber() == null || plateRecognizedEvent.getPlateNumber().length() == 0) {
            return;
        }
        ServiceLog.getLog().info((Object)(String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u8f66\u724c\u8bc6\u522b\u68c0\u6d4b\u5230\u8f66\u724c: " + plateRecognizedEvent.getPlateNumber()));
        this.removeWaitNewCarEvent();
        EquipmentAction vehiclePassDetectedAction = this.getWorkNormalVehiclePassDetectedAction();
        if (vehiclePassDetectedAction == null) {
            this.currentNewCarEntry = null;
            l.handlePlateRecognizedEvent(plateRecognizedEvent);
            return;
        }
        boolean bl = noPlate = plateRecognizedEvent.getPlateNumber().equals("\u65e0\u724c\u8f66") || plateRecognizedEvent.getPlateNumber().equals("\u65e0\u8f66\u724c") || plateRecognizedEvent.getPlateNumber().indexOf("_\u65e0_") != -1;
        if (noPlate) {
            PassSession lastSession2 = this.passChannel.getLastSession();
            if (lastSession2 != null) {
                Equipment eq;
                if (lastSession2.getPlateRecognizedEvent() != null && plateRecognizedEvent.getCameraEquipmentNo() != null && !plateRecognizedEvent.getCameraEquipmentNo().equals(lastSession2.getPlateRecognizedEvent().getCameraEquipmentNo()) && (eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(lastSession2.getPlateRecognizedEvent().getCameraEquipmentNo())) != null && eq.getEquipmentAction() instanceof PlateRegCameraAction && plateRecognizedEvent.getRegTimeMills() - lastSession2.getPlateRecognizedEvent().getRegTimeMills() <= 4000L) {
                    ServiceLog.getLog().info((Object)(String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u4e22\u5f03\u65e0\u724c\u8f66\u8f93\u51fa, \u539f\u56e0\u76f8\u540c\u8f66\u9053\u4e0d\u540c\u76f8\u673a4\u79d2\u5185\u5df2\u7ecf\u8f93\u51fa\u8f66\u724c:" + lastSession2.getPlateRecognizedEvent().getPlateNumber()));
                    return;
                }
                if (lastSession2.getSessionState() == PassSession.SessionState.PENDING && lastSession2.getEventPassId() != null && lastSession2.getPlateRecognizedEvent() != null) {
                    List<VehiclePassEventEntry> list2 = this.eqPassEventMap.get(lastSession2.getPlateRecognizedEvent().getCameraEquipmentNo());
                    rId = lastSession2.getEventPassId();
                    if (list2 != null && rId != null) {
                        VehiclePassEventEntry e = null;
                        List<VehiclePassEventEntry> list3 = list2;
                        synchronized (list3) {
                            for (VehiclePassEventEntry vehiclePassEventEntry : list2) {
                                if (vehiclePassEventEntry.eventPassId != (Long)rId) continue;
                                e = vehiclePassEventEntry;
                            }
                        }
                        if (e != null && e.latestDetectedEvent != null) {
                            if (plateRecognizedEvent.getRegTimeMills() - e.latestDetectedEvent.getRevNonTimeMills() >= 10000L) {
                                plateRecognizedEvent.setEventPassId(e.eventPassId);
                                l.handlePlateRecognizedEvent(plateRecognizedEvent);
                            }
                            return;
                        }
                    }
                }
            }
        } else {
            PassSession session = this.findSamePlatePassSession(plateRecognizedEvent.getPlateNumber(), false);
            if (session != null) {
                if (session.getEventPassId() != null) {
                    plateRecognizedEvent.setEventPassId(session.getEventPassId());
                    l.handlePlateRecognizedEvent(plateRecognizedEvent);
                    return;
                }
            } else {
                List<VehiclePassEventEntry> list4;
                VehiclePassEventEntry sameRegPlateEntry = null;
                rId = this.eqPassEventMap;
                synchronized (rId) {
                    ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    Iterator<List<VehiclePassEventEntry>> iterator = this.eqPassEventMap.values().iterator();
                    while (iterator.hasNext()) {
                        List<VehiclePassEventEntry> list5;
                        list4 = list5 = iterator.next();
                        synchronized (list4) {
                            for (VehiclePassEventEntry eventEntry : list5) {
                                if (eventEntry.isFinish() || eventEntry.latestDetectedEvent == null || eventEntry.latestDetectedEvent.getPlateNumber() == null || !applicationService.plateEquals(plateRecognizedEvent.getPlateNumber(), eventEntry.latestDetectedEvent.getPlateNumber(), 1)) continue;
                                if (sameRegPlateEntry == null) {
                                    sameRegPlateEntry = eventEntry;
                                    continue;
                                }
                                if (sameRegPlateEntry.latestDetectedEvent.getRevNonTimeMills() >= eventEntry.latestDetectedEvent.getRevNonTimeMills()) continue;
                                sameRegPlateEntry = eventEntry;
                            }
                        }
                    }
                }
                if (sameRegPlateEntry != null) {
                    if (this.currentNewCarEntry == sameRegPlateEntry) {
                        this.currentNewCarEntry = null;
                    }
                    sameRegPlateEntry.bindRegPlateEvent = true;
                    plateRecognizedEvent.setEventPassId(sameRegPlateEntry.eventPassId);
                    l.handlePlateRecognizedEvent(plateRecognizedEvent);
                    return;
                }
                lastSession = this.passChannel.getLastSession();
                if (lastSession != null && lastSession.getSessionState() == PassSession.SessionState.PENDING && lastSession.getEventPassId() != null && lastSession.getPlateRecognizedEvent() != null) {
                    list = this.eqPassEventMap.get(lastSession.getPlateRecognizedEvent().getCameraEquipmentNo());
                    Long rId2 = lastSession.getEventPassId();
                    if (list != null && rId2 != null) {
                        void var10_14;
                        Object var10_13 = null;
                        list4 = list;
                        synchronized (list4) {
                            for (VehiclePassEventEntry e1 : list) {
                                if (e1.eventPassId != rId2) continue;
                                VehiclePassEventEntry vehiclePassEventEntry = e1;
                            }
                        }
                        if (var10_14 != null && ((VehiclePassEventEntry)var10_14).latestDetectedEvent != null) {
                            plateRecognizedEvent.setEventPassId(((VehiclePassEventEntry)var10_14).eventPassId);
                            l.handlePlateRecognizedEvent(plateRecognizedEvent);
                            return;
                        }
                    }
                }
            }
        }
        if ((newCarEntry = this.currentNewCarEntry) != null) {
            this.currentNewCarEntry = null;
            if (newCarEntry.latestDetectedEvent == null || plateRecognizedEvent.getRegTimeMills() - newCarEntry.latestDetectedEvent.getRevNonTimeMills() > 11000L) {
                newCarEntry = null;
            }
        }
        if (newCarEntry == null) {
            VehiclePassEventEntry firstWaitRegEntry = null;
            List<VehiclePassEventEntry> listQueue = this.eqPassEventMap.get(vehiclePassDetectedAction.getEquipment().getEquipmentNo());
            if (listQueue != null) {
                list = listQueue;
                synchronized (list) {
                    for (VehiclePassEventEntry eventEntry : listQueue) {
                        if (eventEntry.isFinish() || eventEntry.maybeLeave || plateRecognizedEvent.getRegTimeMills() - eventEntry.latestDetectedEvent.getRevNonTimeMills() > 7000L) continue;
                        if (eventEntry.bindSession == null) {
                            if (firstWaitRegEntry != null) continue;
                            firstWaitRegEntry = eventEntry;
                            continue;
                        }
                        if (eventEntry.bindSession.getSessionState() != PassSession.SessionState.PENDING || eventEntry.bindSession.getPlateRecognizedEvent() == null || !((Equipment)eventEntry.latestDetectedEvent.getSource()).getEquipmentNo().equals(eventEntry.bindSession.getPlateRecognizedEvent().getCameraEquipmentNo()) || firstWaitRegEntry != null) continue;
                        firstWaitRegEntry = eventEntry;
                    }
                }
            }
            newCarEntry = firstWaitRegEntry;
        }
        if (newCarEntry == null) {
            if (noPlate) {
                PassSession pendingSession = null;
                lastSession = null;
                Collection<PassSession> cls = this.passChannel.getSessions();
                if (cls != null) {
                    for (PassSession s : cls) {
                        if (s.getSessionState() == PassSession.SessionState.PENDING) {
                            pendingSession = s;
                        }
                        lastSession = s;
                    }
                }
                if (pendingSession != null) {
                    if (lastSession != pendingSession) {
                        if (ServiceUtil.getServiceContext().currentTimeMillis() - plateRecognizedEvent.getRegTimeMills() < 10000L) {
                            this.waitingNewCarEvent = plateRecognizedEvent;
                            this.logDiscardPlate();
                        }
                    } else if (pendingSession.getPlateRecognizedEvent() == null) {
                        if (ServiceUtil.getServiceContext().currentTimeMillis() - plateRecognizedEvent.getRegTimeMills() < 10000L) {
                            this.waitingNewCarEvent = plateRecognizedEvent;
                            this.logDiscardPlate();
                        }
                    } else if (!"\u65e0\u724c\u8f66".equals(this.getPlate(pendingSession.getPlateRecognizedEvent().getPlateNumber()))) {
                        this.waitingNewCarEvent = plateRecognizedEvent;
                        this.logDiscardPlate();
                    }
                } else if (ServiceUtil.getServiceContext().currentTimeMillis() - plateRecognizedEvent.getRegTimeMills() < 10000L) {
                    this.waitingNewCarEvent = plateRecognizedEvent;
                    this.logDiscardPlate();
                }
            } else if (ServiceUtil.getServiceContext().currentTimeMillis() - plateRecognizedEvent.getRegTimeMills() < 10000L) {
                this.waitingNewCarEvent = plateRecognizedEvent;
                this.logDiscardPlate();
            }
            if (!this.isStrictlyMatchRegPlate(vehiclePassDetectedAction)) {
                l.handlePlateRecognizedEvent(plateRecognizedEvent);
            }
        } else if (!this.isStrictlyMatchRegPlate(vehiclePassDetectedAction)) {
            plateRecognizedEvent.setEventPassId(newCarEntry.eventPassId);
            l.handlePlateRecognizedEvent(plateRecognizedEvent);
        } else {
            this.onRegPlateAndDetected(plateRecognizedEvent, newCarEntry, l);
        }
    }

    private void onRegPlateAndDetected(PlateRecognizedEvent plateRecognizedEvent, VehiclePassEventEntry newCarEntry, CarChannelPassProcessEventListener l) {
        boolean noPlate = plateRecognizedEvent.getPlateNumber().equals("\u65e0\u724c\u8f66") || plateRecognizedEvent.getPlateNumber().equals("\u65e0\u8f66\u724c") || plateRecognizedEvent.getPlateNumber().indexOf("_\u65e0_") != -1;
        String waitPlate = newCarEntry.latestDetectedEvent.getPlateNumber();
        if (waitPlate == null || waitPlate.length() == 0) {
            l.handlePlateRecognizedEvent(plateRecognizedEvent);
        } else {
            boolean noPlate0;
            boolean bl = noPlate0 = waitPlate.equals("\u65e0\u724c\u8f66") || waitPlate.equals("\u65e0\u8f66\u724c") || waitPlate.indexOf("_\u65e0_") != -1;
            if (noPlate) {
                if (noPlate0) {
                    plateRecognizedEvent.setEventPassId(newCarEntry.eventPassId);
                    l.handlePlateRecognizedEvent(plateRecognizedEvent);
                } else {
                    ServiceLog.getLog().info((Object)(String.valueOf(this.passChannel.getChannel().getChannel_name()) + ": \u8f66\u724c\u8bc6\u522b\u7ed9\u51fa\u65e0\u724c\u8f66! \u4f46\u662f\u73af\u5883\u76f8\u673a\u7ed9\u51fa\u6ede\u7559\u8f66\u724c: " + waitPlate + ", \u8fd9\u5c06\u7ee7\u7eed\u7b49\u5f85, \u5982\u679c\u6ede\u7559\u7ee7\u7eed\u7ed9\u51fa\u8f66\u724c\uff0c\u76f4\u63a5\u542f\u52a8\u6d41\u7a0b\u5904\u7406"));
                    newCarEntry.bindRegPlateEvent = true;
                }
            } else if (noPlate0) {
                plateRecognizedEvent.setEventPassId(newCarEntry.eventPassId);
                l.handlePlateRecognizedEvent(plateRecognizedEvent);
            } else if (plateRecognizedEvent.getPlateNumber().equals(newCarEntry.latestDetectedEvent.getPlateNumber())) {
                newCarEntry.bindRegPlateEvent = true;
                plateRecognizedEvent.setEventPassId(newCarEntry.eventPassId);
                l.handlePlateRecognizedEvent(plateRecognizedEvent);
            } else {
                PassSession session = this.findSamePlatePassSession(plateRecognizedEvent.getPlateNumber(), false);
                if (session == null) {
                    plateRecognizedEvent.setEventPassId(newCarEntry.eventPassId);
                    l.handlePlateRecognizedEvent(plateRecognizedEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindPassSession(PassSession passSession, long eventPassId) {
        if (passSession == null) {
            return;
        }
        VehiclePassEventEntry xEntry = null;
        Map<String, List<VehiclePassEventEntry>> map = this.eqPassEventMap;
        synchronized (map) {
            for (List<VehiclePassEventEntry> list : this.eqPassEventMap.values()) {
                VehiclePassEventEntry g = null;
                List<VehiclePassEventEntry> list2 = list;
                synchronized (list2) {
                    for (VehiclePassEventEntry e : list) {
                        if (e.eventPassId != eventPassId) continue;
                        g = e;
                    }
                }
                if (g == null || g.bindSession != null || g.latestDetectedEvent == null || g.isFinish()) continue;
                if (xEntry == null) {
                    xEntry = g;
                    continue;
                }
                if (g.latestDetectedEvent.getRevNonTimeMills() <= xEntry.latestDetectedEvent.getRevNonTimeMills()) continue;
                xEntry = g;
            }
            if (xEntry != null) {
                passSession.setEventPassId(eventPassId);
                xEntry.bindSession = passSession;
            }
        }
    }

    public EquipmentAction getWorkNormalVehiclePassDetectedAction() {
        List<Equipment> eqList = ServiceUtil.getServiceContext().getEquipmentManager().getEquipmentsByActionClass(VehiclePassDetectedAction.class);
        if (eqList != null && !eqList.isEmpty()) {
            for (Equipment eq : eqList) {
                List<String> channelNos;
                if (!(eq.getEquipmentAction() instanceof VehiclePassDetectedAction) || !((VehiclePassDetectedAction)eq.getEquipmentAction()).isPassDetectedSupported() || !eq.getEquipmentAction().isWorkingProperly() || (channelNos = eq.getChannelNos()) == null || !channelNos.contains(this.passChannel.getChannelNo())) continue;
                return eq.getEquipmentAction();
            }
        }
        return null;
    }

    private VehiclePassEventEntry findVehiclePassEventEntry(long eventPassId, List<VehiclePassEventEntry> listQueue, int eventType) {
        if (listQueue.isEmpty()) {
            return null;
        }
        VehiclePassEventEntry r = null;
        long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
        Iterator<VehiclePassEventEntry> itx = listQueue.iterator();
        while (itx.hasNext()) {
            VehiclePassEventEntry entry = itx.next();
            if (entry.beginDetectedEvent == null || entry.latestDetectedEvent == null) {
                itx.remove();
                continue;
            }
            if (currentMills >= entry.validMills) {
                itx.remove();
                continue;
            }
            if (eventPassId != entry.eventPassId && entry.bindSession != null) {
                if (!entry.bindSession.isValid()) {
                    itx.remove();
                    continue;
                }
                if (!this.passChannel.getSessions().contains(entry.bindSession)) {
                    itx.remove();
                    continue;
                }
            }
            if (!entry.isFinish() && currentMills - entry.latestDetectedEvent.getRevNonTimeMills() >= 600000L) {
                itx.remove();
                continue;
            }
            if (eventPassId != entry.eventPassId) continue;
            if (eventType == 0 && entry.isFinish()) {
                entry.thoughEvent = null;
                entry.carLeaveEvent = null;
                entry.backEvent = null;
                entry.maybeLeave = false;
                entry.validMills = ServiceUtil.getServiceContext().currentTimeMillis() + TimeUnit.MINUTES.toMillis(15L);
            }
            r = entry;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VehiclePassEventEntry> getList(String eqNo) {
        List<VehiclePassEventEntry> list;
        if (eqNo == null || eqNo.length() == 0) {
            return null;
        }
        Map<String, List<VehiclePassEventEntry>> map = this.eqPassEventMap;
        synchronized (map) {
            list = this.eqPassEventMap.get(eqNo);
            if (list == null) {
                list = new LinkedList<VehiclePassEventEntry>();
                this.eqPassEventMap.put(eqNo, list);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPassEventMap() {
        Map<String, List<VehiclePassEventEntry>> map = this.eqPassEventMap;
        synchronized (map) {
            if (!this.eqPassEventMap.isEmpty()) {
                Iterator<Map.Entry<String, List<VehiclePassEventEntry>>> itx = this.eqPassEventMap.entrySet().iterator();
                while (itx.hasNext()) {
                    Map.Entry<String, List<VehiclePassEventEntry>> e = itx.next();
                    Equipment eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(e.getKey());
                    if (eq == null) {
                        itx.remove();
                        continue;
                    }
                    List<String> chanelNos = eq.getChannelNos();
                    if (chanelNos != null && !chanelNos.isEmpty() && chanelNos.contains(this.passChannel.getChannelNo())) continue;
                    itx.remove();
                }
            }
        }
    }

    private static class VehiclePassEventEntry {
        private long eventPassId;
        private VehiclePassEvent beginDetectedEvent;
        private VehiclePassEvent latestDetectedEvent;
        private int detectedTimes;
        private VehiclePassEvent thoughEvent;
        private VehiclePassEvent carLeaveEvent;
        private VehiclePassEvent backEvent;
        private PassSession bindSession;
        private long validMills;
        private boolean bindRegPlateEvent;
        private boolean bindIo;
        private boolean maybeLeave;

        private VehiclePassEventEntry() {
        }

        public boolean isFinish() {
            return this.thoughEvent != null || this.carLeaveEvent != null || this.backEvent != null;
        }
    }
}

