/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.cloud.client.HostSate;
import com.wovoe.carpark.conn.udp.net.LanPassChannelHandleAction;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCancelPassRecord;
import com.wovoe.carpark.dto.CarparkCarOwner;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkLocalPassDataCache;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkVisitAuth;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.AlwaysOpenAction;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.action.RoadBarrierStateSupport;
import com.wovoe.carpark.event.app.CaptureEvent;
import com.wovoe.carpark.event.app.CarArrivedEvent;
import com.wovoe.carpark.event.app.CarLeftEvent;
import com.wovoe.carpark.event.app.PlateRecognizedEvent;
import com.wovoe.carpark.event.app.ReadPassportNumberEvent;
import com.wovoe.carpark.event.app.SessionCreatedEvent;
import com.wovoe.carpark.event.equipment.DetectedPassEvent;
import com.wovoe.carpark.event.equipment.VehicleTypeEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.pass.filter.SavePassDataFilter;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.vo.PassSessionData;
import com.wovoe.carpark.vo.SavePassData;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;

public class PassSession {
    private static AtomicLong sessionIds = new AtomicLong(0L);
    public static final int DEFAULT_SESSION_TIMEOUT_MILLS = 600000;
    private volatile SessionState sessionState;
    private Object sessionStateSetLock = new Object();
    private long sessionId;
    private final long createdTimeMills;
    private int sessionTimeoutMills;
    private final PassChannel passChannel;
    private final Map<String, Object> attributes;
    private final ConcurrentLinkedQueue<SessionStateChangeListener> sessionStateChangeListeners;
    private volatile ReadPassportNumberEvent readPassportNumberEvent;
    private volatile CarArrivedEvent carArrivedEvent;
    private CarLeftEvent carLeftEvent;
    private volatile PlateRecognizedEvent plateRecognizedEvent;
    private CarparkPassport databasePassport;
    private CarparkPassportType databasePassportType;
    private CarparkPassport passport;
    private CarparkPassportType passportType;
    private CarparkCarType carType;
    private CarparkCarOwner carOwner;
    private CarparkVisitAuth visitCar;
    private VehicleTypeEvent vehicleTypeEvent;
    private String dsiplay1MsgWhenMoney;
    private ScheduledFuture<?> reDisplayPayMsg1Task;
    private Collection<Integer> confirmPassExceptions;
    private Collection<Integer> forbidPassExceptions;
    private Collection<Integer> allowPassExcetpions;
    private boolean tempSession = false;
    private PassFilter confirmPassFilter;
    private PassFilter chargeFilter;
    private volatile AtomicLong handlePaySuccessAdviceMills = new AtomicLong(0L);
    private final Object exeFilterLock = new Object();
    private Long saveDataCacheId;
    private KeyValueEntry<CarparkCancelPassRecord, Collection<String>> openDialogCacnelRecord = null;
    private long createSysMills;
    private Long eventPassId;
    private Long cancelMills;
    private Long carLeavingMills;
    private static SessionStateChangeListener defaultSateChageL = new SessionStateChangeListener(){

        @Override
        public void sessionStateChanged(PassSession p, SessionState oldState, SessionState newState) {
            try {
                LinkedList<CarparkDispatchTask> taskL;
                PlateRecognizedEvent evn;
                ApplicationService appSerivce;
                UserSession userSession;
                String remoteSessionId;
                HostSate hostSate;
                if (oldState != SessionState.CANCELED && newState == SessionState.CANCELED) {
                    p.cancelMills = ServiceUtil.getServiceContext().currentTimeMillis();
                } else if (oldState != SessionState.CAR_LEAVING && newState == SessionState.CAR_LEAVING) {
                    p.carLeavingMills = ServiceUtil.getServiceContext().currentTimeMillis();
                }
                if (newState == SessionState.OPEN_DIALOG) {
                    p.setAttribute("CONFIRMDIALOG", Boolean.TRUE);
                } else if (newState == SessionState.WAIT_PAY) {
                    p.setAttribute("SESSION_WAITPING", Boolean.TRUE);
                }
                try {
                    if (!(oldState != SessionState.PROCESSING || p.getReadPassportNumberEvent() == null || p.getReadPassportNumberEvent().isManualTrigger() || p.getReadPassportNumberEvent().getPlateRecognizedEvent() == null && p.getPlateRecognizedEvent() == null && !p.getReadPassportNumberEvent().isUserScan() && p.isFarDistanceReader() || newState == SessionState.CANCELED)) {
                        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        applicationService.closeConfirmDialogWithout(p.getPassChannel().getChannelNo(), p.getReadPassportNumberEvent().getPassportNumber(), p.getReadPassportNumberEvent().getPassportMediumType(), null);
                        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1 && (newState == SessionState.OPEN_DIALOG || newState == SessionState.WAIT_PAY)) {
                            applicationService.notifyOtherHostsHandling(p.getPassChannel().getChannelNo(), p.getReadPassportNumberEvent().getPassportNumber(), p.getReadPassportNumberEvent().getPassportMediumType());
                        }
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                }
                if (!(oldState != SessionState.OPEN_DIALOG || newState != SessionState.CANCELED && newState != SessionState.WAIT_CAR_LEAVE || p.getAttribute("GUI_MAN_CANCEL") == null && p.getAttribute("GUI_OK") == null || (hostSate = p.getPassChannel().getLanConnectManageHostState()) == null || (remoteSessionId = (String)p.getAttribute("SLAVE_HOST_SESSIONID_" + hostSate.getHostNo())) == null || remoteSessionId.length() <= 0 || (userSession = (appSerivce = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class)).getUserSession()) == null || userSession.getUser() == null)) {
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("channelNo", p.getPassChannel().getChannelNo());
                    paramMap.put("passSessionId", remoteSessionId);
                    paramMap.put("optionType", newState == SessionState.CANCELED ? "cancelPass" : "okPass");
                    paramMap.put("opUserCode", userSession.getUser().getUser_code());
                    paramMap.put("opUserName", userSession.getUser().getUser_name());
                    if (userSession.getDutyNumber() != null) {
                        paramMap.put("dutyNumber", userSession.getDutyNumber().getDuty_no());
                    }
                    PassSessionData passSessionData = null;
                    if (newState == SessionState.WAIT_CAR_LEAVE) {
                        long x;
                        passSessionData = new PassSessionData();
                        Long v1 = (Long)p.getAttribute("SAVED_PASSRECORD_MILLS");
                        if (v1 != null && (x = v1 - p.getCreatedTimeMills()) >= 0L) {
                            passSessionData.setSavedPassRecordMills(x);
                        }
                        List passRecordList = (List)p.getAttribute("SAVED_PASSRECORD_LIST");
                        passSessionData.setPassRecordList(passRecordList);
                        Cost cost = (Cost)p.getAttribute("pass_cost");
                        if (cost != null) {
                            passSessionData.setCost(cost);
                        }
                    }
                    OperationFuture<KeyValueEntry<String, String>> f = LanPassChannelHandleAction.doLanConfirmPassOption(hostSate.getHostNo(), hostSate.getLanSocketAddress(), paramMap, passSessionData);
                    final String channelName = p.getPassChannel().getChannel().getChannel_name();
                    final String passPlate = p.getPassPlate();
                    final String comx = newState == SessionState.CANCELED ? "\u53d6\u6d88\u653e\u884c" : "\u786e\u8ba4\u653e\u884c";
                    f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<KeyValueEntry<String, String>>(){

                        public void waitCompleteTimeout() {
                        }

                        public void operationComplete(OperationFuture<KeyValueEntry<String, String>> fcx) {
                            if (fcx.getException() != null) {
                                ServiceLog.getLog().warn((Object)("\u5411\u4e3b\u673a\uff1a" + hostSate.getHostNo() + "[" + hostSate.getLanSocketAddress() + "]: \u53d1\u9001\u901a\u9053" + channelName + "," + passPlate + comx + "\u64cd\u4f5c\u5f02\u5e38\uff01\u539f\u56e0\uff1a" + fcx.getException().getMessage()));
                            } else {
                                KeyValueEntry ex = (KeyValueEntry)fcx.getResult();
                                if (ex == null) {
                                    ServiceLog.getLog().warn((Object)("\u5411\u4e3b\u673a\uff1a" + hostSate.getHostNo() + "[" + hostSate.getLanSocketAddress() + "]: \u53d1\u9001\u901a\u9053" + channelName + "," + passPlate + comx + "\u64cd\u4f5c\u5f02\u5e38\uff01\u539f\u56e0\u8d85\u65f6"));
                                } else if (!"SUCCESS".equals(ex.getKey())) {
                                    ServiceLog.getLog().warn((Object)("\u5411\u4e3b\u673a\uff1a" + hostSate.getHostNo() + "[" + hostSate.getLanSocketAddress() + "]: \u53d1\u9001\u901a\u9053" + channelName + "," + passPlate + comx + "\u64cd\u4f5c\u5f02\u5e38\uff01\u539f\u56e0: " + (String)ex.getValue()));
                                }
                            }
                        }
                    });
                }
                if (oldState == SessionState.PROCESSING && newState != SessionState.WAIT_CAR_LEAVE && (evn = p.getPlateRecognizedEvent()) != null && (taskL = evn.getRegRecordAndPicTaskList()) != null) {
                    ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject(taskL);
                    evn.asyncExeTask();
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"", (Throwable)ex);
            }
            if (newState == SessionState.CAR_LEAVING || newState == SessionState.CAR_LEFT) {
                long sessionTimeoutMills;
                int newtimeoutMills = 60000;
                if (newState != SessionState.CAR_LEFT) {
                    try {
                        String sv = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(p.getPassChannel().getChannelNo(), "CHANNEL_PASS_SUCCESS_TIMEOUT_SEC");
                        if (sv != null && sv.length() > 0) {
                            int t = Integer.parseInt(sv);
                            if (t < 10) {
                                t = 10;
                            } else if (t > 1200) {
                                t = 1200;
                            }
                            newtimeoutMills = t * 1000;
                        }
                    }
                    catch (Exception t) {
                        // empty catch block
                    }
                    if (p.getReadPassportNumberEvent() != null && p.getReadPassportNumberEvent().isManualTrigger()) {
                        newtimeoutMills = 60000;
                    } else if (p.getCarArrivedEvent() != null && p.getCarArrivedEvent().getOriginalSourceType() == CarArrivedEvent.OriginalSourceType.GROUND_SENSE && p.getCarLeftEvent() == null && newtimeoutMills < 1200000) {
                        newtimeoutMills = 1200000;
                    }
                }
                if ((sessionTimeoutMills = (long)((int)(ServiceUtil.getServiceContext().currentTimeMillis() - p.getCreatedTimeMills()) + newtimeoutMills)) < (long)p.getSessionTimeoutMills()) {
                    p.resetSessionTimeoutMills(newtimeoutMills);
                }
            } else if (newState == SessionState.CANCELED) {
                final Long saveCacheId = p.getSaveDataCacheId();
                if (saveCacheId != null) {
                    p.setSaveDataCacheId(null);
                    if (p.getAttribute("EXIT_CANCEL") != null) {
                        try {
                            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                            commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkLocalPassDataCache.class)).addEQ("id", (Object)saveCacheId));
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)"\u53d6\u6d88\u8ba1\u8d39\u64cd\u4f5c\u5931\u8d25", (Throwable)ex);
                        }
                    } else {
                        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                                    commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkLocalPassDataCache.class)).addEQ("id", (Object)saveCacheId));
                                }
                                catch (Exception ex) {
                                    ServiceLog.getLog().warn((Object)"\u53d6\u6d88\u8ba1\u8d39\u64cd\u4f5c\u5931\u8d25", (Throwable)ex);
                                }
                            }
                        });
                    }
                }
                p.setDsiplay1MsgWhenMoney(null);
                ScheduledFuture<?> sss = p.getReDisplayPayMsg1Task();
                if (sss != null) {
                    try {
                        sss.cancel(true);
                    }
                    catch (Exception sv) {
                        // empty catch block
                    }
                    p.setReDisplayPayMsg1Task(null);
                }
                int newtimeoutMills = 300000;
                if (p.getReadPassportNumberEvent() != null && p.getReadPassportNumberEvent().isManualTrigger()) {
                    newtimeoutMills = 1000;
                } else {
                    if (p.getCarArrivedEvent() != null && p.getCarArrivedEvent().getOriginalSourceType() == CarArrivedEvent.OriginalSourceType.GROUND_SENSE) {
                        newtimeoutMills = p.getCarLeftEvent() != null ? 15000 : 1200000;
                    }
                    if (p.getAttribute("PARKING_FULL_QUEUE_FLAG") != null) {
                        newtimeoutMills = 3600000;
                    }
                }
                long sessionTimeoutMills = (int)(ServiceUtil.getServiceContext().currentTimeMillis() - p.getCreatedTimeMills()) + newtimeoutMills;
                if (sessionTimeoutMills < (long)p.getSessionTimeoutMills()) {
                    p.resetSessionTimeoutMills(newtimeoutMills);
                }
            } else if (newState == SessionState.OPEN_DIALOG) {
                List<Equipment> list;
                String v;
                Cost cost;
                Object obj;
                ChannelArea channelArea;
                block63: {
                    String passSaveDataCache = null;
                    try {
                        Cost cost2;
                        if (p.getSaveDataCacheId() == null && p.getReadPassportNumberEvent() != null && !p.getReadPassportNumberEvent().isManualTrigger() && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1 && (channelArea = (ChannelArea)p.getAttribute("channelArea")) != null && channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty() && (cost2 = (Cost)p.getAttribute("pass_cost")) != null && cost2.getCash().doubleValue() > 0.0) {
                            PassFilter saveFilter = ServiceUtil.getServiceContext().getPassFilterChain().getSavePassDataFilter();
                            if (saveFilter != null && saveFilter instanceof SavePassDataFilter) {
                                SavePassData saveData = ((SavePassDataFilter)saveFilter).createSavePassData(p);
                                saveData.setRegPlateTaskList(null);
                                saveData.setDispathServerTimeMills(0L);
                                String jon = GsonBuilder.create().toJson((Object)saveData);
                                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                                CarparkLocalPassDataCache pc = new CarparkLocalPassDataCache();
                                Date now = ServiceUtil.getNow();
                                pc.setId(commonDaoService.getSequece("ck_carpark_local_pass_data_cache_seq"));
                                pc.setPass_save_data(jon);
                                pc.setCreated_time(now);
                                pc.setLast_updated_time(now);
                                pc.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                                pc.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                                passSaveDataCache = jon;
                                commonDaoService.insert((Object)pc);
                                p.setSaveDataCacheId(pc.getId());
                            } else {
                                ServiceLog.getLog().warn((Object)("saveFilter\u4e0d\u662fSavePassDataFilter\u7684\u5b9e\u4f8b\uff01\u8bf7\u5904\u7406" + saveFilter));
                            }
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)"\u521b\u5efa\u6536\u8d39\u7f13\u5b58\u5f02\u5e38", (Throwable)ex);
                        if (passSaveDataCache == null) break block63;
                        try {
                            ServiceLog.getLog().warn((Object)("\u6570\u636e\u5b57\u8282\u957f\u5ea6:" + passSaveDataCache.getBytes("UTF-8") + ", \u6570\u636e:" + passSaveDataCache), (Throwable)ex);
                        }
                        catch (Exception cost2) {
                            // empty catch block
                        }
                    }
                }
                try {
                    if (p.getOpenDialogCacnelRecord() == null && p.getReadPassportNumberEvent() != null && !p.getReadPassportNumberEvent().isManualTrigger() && (channelArea = (ChannelArea)p.getAttribute("channelArea")) != null) {
                        KeyValueEntry<CarparkCancelPassRecord, Collection<String>> kv;
                        RecordSaveService r;
                        if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                            r = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                            kv = r.createCancelPassRecrod(p);
                            p.openDialogCacnelRecord = kv;
                        } else if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                            r = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                            kv = r.createCancelPassRecrod(p);
                            p.openDialogCacnelRecord = kv;
                        }
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"\u521b\u5efa\u53d6\u6d88\u8bb0\u5f55\u5f02\u5e38", (Throwable)ex);
                }
                if (oldState == SessionState.PROCESSING && (obj = p.getAttribute("AFTER_CONFIRM_DO_NOSENSE_PAY_FILTER")) != null && obj instanceof PassFilter) {
                    final PassFilter passFilter0 = (PassFilter)obj;
                    final PassSession passSession = p;
                    ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                passFilter0.doFilter(passSession);
                            }
                            catch (Exception exception) {
                                ServiceLog.getLog().error((Object)exception.getMessage(), (Throwable)exception);
                            }
                        }
                    });
                }
                if (p.getReadPassportNumberEvent() != null && !p.getReadPassportNumberEvent().isManualTrigger() && p.getPlateRecognizedEvent() != null && (cost = (Cost)p.getAttribute("pass_cost")) != null && cost.getCashAndArrears().doubleValue() > 0.0 && "1".equals(v = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(p.getPassChannel().getChannelNo(), "CHANNEL_DIALOG_WHEN_GATE_OPENED")) && (list = p.getPassChannel().getEquipmentList(9)) != null && !list.isEmpty()) {
                    for (Equipment equipment : list) {
                        RoadBarrierAction roadGateAction0;
                        Object roadGateAction = equipment.getEquipmentAction();
                        if (!(roadGateAction instanceof RoadBarrierAction) || !roadGateAction.isWorkingProperly() || !(roadGateAction0 = (RoadBarrierAction)roadGateAction).isSupportDownPole() || roadGateAction instanceof AlwaysOpenAction && ((AlwaysOpenAction)roadGateAction).isAlwaysOpen() || !(roadGateAction instanceof RoadBarrierStateSupport) || !((RoadBarrierStateSupport)roadGateAction).isSupportBarrierStateDetected() || roadGateAction.getEquipmentState() != EquipmentState.BARRIER_RAISED_IN_PLACE || p.getPassChannel().getLanConnectManageHostState() != null) continue;
                        ServiceLog.getLog().info((Object)("\u8bc6\u522b\u5230\u8f66\u8f86: " + p.getPlateRecognizedEvent().getPlateNumber() + "\u4ea7\u751f\u4e86\u8d39\u7528\uff0c\u8fd9\u4e2a\u65f6\u5019\u68c0\u6d4b\u5230\u9053\u95f8\u6746\u662f\u5f00\u7740\u7684\uff0c\u8fd9\u5c06\u53d1\u9001\u9053\u95f8\u843d\u6746\u4fe1\u53f7"));
                        roadGateAction0.doDownPoleAction();
                    }
                }
            }
        }
    };

    protected PassSession(PassChannel passChannel) {
        this.passChannel = passChannel;
        this.createdTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
        this.sessionId = sessionIds.incrementAndGet();
        this.attributes = new ConcurrentHashMap<String, Object>();
        this.sessionStateChangeListeners = new ConcurrentLinkedQueue();
        this.sessionState = SessionState.PENDING;
        this.sessionTimeoutMills = 600000;
        this.createSysMills = System.currentTimeMillis();
        try {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new SessionCreatedEvent(passChannel, this));
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"dispatch SessionCreatedEvent error!", (Throwable)ex);
        }
    }

    public long getCreateSysMills() {
        return this.createSysMills;
    }

    public Object getExeFilterLock() {
        return this.exeFilterLock;
    }

    public static PassSession createTempSession(PassChannel passChannel) {
        PassSession s = new PassSession(passChannel);
        s.tempSession = true;
        return s;
    }

    public boolean isTempSession() {
        return this.tempSession;
    }

    public PassFilter getConfirmPassFilter() {
        return this.confirmPassFilter;
    }

    public void setConfirmPassFilter(PassFilter confirmPassFilter) {
        this.confirmPassFilter = confirmPassFilter;
    }

    public KeyValueEntry<CarparkCancelPassRecord, Collection<String>> getOpenDialogCacnelRecord() {
        return this.openDialogCacnelRecord;
    }

    public void removeCancelPassRecord() {
        this.openDialogCacnelRecord = null;
    }

    private void fireSessionStateChange(SessionState oldState, SessionState newState) {
        for (SessionStateChangeListener l : this.sessionStateChangeListeners) {
            try {
                l.sessionStateChanged(this, oldState, newState);
            }
            catch (Exception ex) {
                LogUtil.getLog().error((Object)"", (Throwable)ex);
            }
        }
    }

    public void addSessionStateChangeListener(SessionStateChangeListener l) {
        if (l != null) {
            this.sessionStateChangeListeners.offer(l);
        }
    }

    public boolean containsSessionStateChangeListener(SessionStateChangeListener l) {
        if (l != null) {
            return this.sessionStateChangeListeners.contains(l);
        }
        return false;
    }

    public void removeSessionStateChangeListener(SessionStateChangeListener l) {
        this.sessionStateChangeListeners.remove(l);
    }

    public boolean isValid() {
        long currentTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
        return currentTimeMills - this.createdTimeMills < (long)this.sessionTimeoutMills;
    }

    public void contineWhenless(int lessSec, int continueSes) {
        long x = this.createdTimeMills + (long)this.sessionTimeoutMills;
        long currentTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
        if (x - currentTimeMills < (long)(lessSec * 1000)) {
            this.sessionTimeoutMills = (int)(currentTimeMills - this.createdTimeMills + (long)(continueSes * 1000));
        }
    }

    public long getCreatedTimeMills() {
        return this.createdTimeMills;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public PassChannel getPassChannel() {
        return this.passChannel;
    }

    public int getSessionTimeoutMills() {
        return this.sessionTimeoutMills;
    }

    public void resetSessionTimeoutMills(int timeoutMills) {
        if (timeoutMills < 0) {
            timeoutMills = 0;
        }
        this.sessionTimeoutMills = (int)(ServiceUtil.getServiceContext().currentTimeMillis() - this.createdTimeMills) + timeoutMills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionState(SessionState state) {
        SessionState old;
        if (state == null) {
            throw new NullPointerException("SessionState is null!");
        }
        Object object = this.sessionStateSetLock;
        synchronized (object) {
            old = this.sessionState;
            this.sessionState = state;
        }
        if (old != state) {
            this.fireSessionStateChange(old, this.sessionState);
        }
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public <T> T removeAttribute(String name) {
        return (T)this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void clearAllAttributes() {
        this.attributes.clear();
    }

    public ReadPassportNumberEvent getReadPassportNumberEvent() {
        return this.readPassportNumberEvent;
    }

    public void setReadPassportNumberEvent(ReadPassportNumberEvent readPassportNumberEvent) {
        this.readPassportNumberEvent = readPassportNumberEvent;
    }

    public CarArrivedEvent getCarArrivedEvent() {
        return this.carArrivedEvent;
    }

    public void setCarArrivedEvent(CarArrivedEvent carArrivedEvent) {
        this.carArrivedEvent = carArrivedEvent;
    }

    public CarLeftEvent getCarLeftEvent() {
        return this.carLeftEvent;
    }

    public void setCarLeftEvent(CarLeftEvent carLeftEvent) {
        this.carLeftEvent = carLeftEvent;
    }

    public PlateRecognizedEvent getPlateRecognizedEvent() {
        return this.plateRecognizedEvent;
    }

    public void setPlateRecognizedEvent(PlateRecognizedEvent plateRecognizedEvent) {
        this.plateRecognizedEvent = plateRecognizedEvent;
    }

    public CarparkPassport getDatabasePassport() {
        return this.databasePassport;
    }

    public void setDatabasePassport(CarparkPassport databasePassport) {
        this.databasePassport = databasePassport;
    }

    public CarparkPassportType getDatabasePassportType() {
        return this.databasePassportType;
    }

    public void setDatabasePassportType(CarparkPassportType databasePassportType) {
        this.databasePassportType = databasePassportType;
    }

    public CarparkPassport getPassport() {
        return this.passport;
    }

    public void setPassport(CarparkPassport passport) {
        this.passport = passport;
    }

    public CarparkPassportType getPassportType() {
        return this.passportType;
    }

    public void setPassportType(CarparkPassportType passportType) {
        this.passportType = passportType;
    }

    public CarparkCarType getCarType() {
        return this.carType;
    }

    public void setCarType(CarparkCarType carType) {
        this.carType = carType;
    }

    public CarparkCarOwner getCarOwner() {
        return this.carOwner;
    }

    public void setCarOwner(CarparkCarOwner carOwner) {
        this.carOwner = carOwner;
    }

    public boolean isFarDistanceReader() {
        return this.isRsuReader() || this.isIdFarDistanceReader();
    }

    public boolean isRsuReader() {
        ReadPassportNumberEvent e = this.readPassportNumberEvent;
        return e != null && e.getDetectedPassEvent() != null && e.getDetectedPassEvent().getMediaType() == DetectedPassEvent.MediaType.OBU;
    }

    public boolean isIdFarDistanceReader() {
        boolean farDistanceReader = false;
        ReadPassportNumberEvent e = this.readPassportNumberEvent;
        if (e != null && e.getPassportMediumType() == 1 && e.getDetectedPassEvent() != null) {
            Equipment eq = (Equipment)e.getDetectedPassEvent().getSource();
            EquipmentConfig config = eq.getEquipmentConfig();
            String v = config.getConfigValue("read_distance");
            farDistanceReader = "3".equals(v);
        }
        return farDistanceReader;
    }

    public Long getCancelMills() {
        return this.cancelMills;
    }

    public Long getCarLeavingMills() {
        return this.carLeavingMills;
    }

    public void doSaveCancelPassRecrodIfExist(boolean manualCacnel, boolean asyn) {
        String msg;
        final KeyValueEntry<CarparkCancelPassRecord, Collection<String>> kv = this.openDialogCacnelRecord;
        if (kv == null || kv.getKey() == null) {
            return;
        }
        this.openDialogCacnelRecord = null;
        CarparkCancelPassRecord r = (CarparkCancelPassRecord)kv.getKey();
        String string = msg = manualCacnel ? "\u503c\u73ed\u5458\u53d6\u6d88" : "\u503c\u73ed\u5458\u8d85\u65f6\u672a\u5904\u7406\uff0c\u7cfb\u7edf\u81ea\u52a8\u53d6\u6d88";
        if (r.getExit_time() != null) {
            String exit_remark0 = r.getExit_remark();
            if (exit_remark0 != null && exit_remark0.length() > 0) {
                r.setExit_remark(ServiceUtil.getDBString(String.valueOf(exit_remark0) + "\uff0c" + msg, 100));
            } else {
                r.setExit_remark(msg);
            }
        } else {
            String enter_remark0 = r.getEnter_remark();
            if (enter_remark0 != null && enter_remark0.length() > 0) {
                r.setEnter_remark(ServiceUtil.getString(String.valueOf(enter_remark0) + "\uff0c" + msg, 100));
            } else {
                r.setEnter_remark(msg);
            }
        }
        if (asyn) {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    PassSession.this.doSaveCancelPassRecrodIfExist0((KeyValueEntry<CarparkCancelPassRecord, Collection<String>>)kv);
                }
            });
        } else {
            this.doSaveCancelPassRecrodIfExist0(kv);
        }
    }

    public void doSaveCancelPassRecrodIfExist0(KeyValueEntry<CarparkCancelPassRecord, Collection<String>> kv) {
        try {
            RecordSaveService rservice = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            rservice.saveCancelRecord(kv);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u4fdd\u5b58\u53d6\u6d88\u5f02\u5e38! ", (Throwable)ex);
        }
    }

    public static CarparkPresenceRecord getEnterRecord(PassSession p) {
        CarparkPresenceRecord enterRecord = null;
        ChannelArea channelArea = (ChannelArea)p.getAttribute("channelArea");
        if (channelArea != null && channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
            CarparkArea exitArea = (CarparkArea)p.getAttribute("PASS_EXIT_AREA");
            Map areaPresenceRecordMap = (Map)p.getAttribute("areaPresenceRecordMap");
            if (areaPresenceRecordMap != null && !areaPresenceRecordMap.isEmpty() && exitArea != null) {
                enterRecord = (CarparkPresenceRecord)areaPresenceRecordMap.get(exitArea.getArea_no());
            }
        }
        return enterRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean ok = false;
        Object object = this.sessionStateSetLock;
        synchronized (object) {
            if (this.sessionState == SessionState.PENDING) {
                this.sessionState = SessionState.PROCESSING;
                ok = true;
            }
        }
        if (ok) {
            this.captureIfNeed();
            this.addSessionStateChangeListener(defaultSateChageL);
            this.fireSessionStateChange(SessionState.PENDING, SessionState.PROCESSING);
            this.passChannel.startSession(this);
        }
    }

    private void captureIfNeed() {
        try {
            int i;
            if (this.getReadPassportNumberEvent() == null) {
                return;
            }
            int[] ax = new int[]{1, 2, 16};
            if (this.getPlateRecognizedEvent() != null || this.getReadPassportNumberEvent().getPlateRecognizedEvent() != null) {
                ax[0] = -1;
            }
            if (this.getReadPassportNumberEvent().getCaptures() != null && !this.getReadPassportNumberEvent().getCaptures().isEmpty()) {
                block2: for (CaptureEvent event : this.getReadPassportNumberEvent().getCaptures()) {
                    i = 0;
                    while (i < ax.length) {
                        if (ax[i] != -1 && ax[i] == event.getPicture_use()) {
                            ax[i] = -1;
                            continue block2;
                        }
                        ++i;
                    }
                }
            }
            int count = 0;
            int[] nArray = ax;
            int n = ax.length;
            i = 0;
            while (i < n) {
                int a = nArray[i];
                if (a != -1) {
                    ++count;
                }
                ++i;
            }
            if (count > 0) {
                int[] useTypes = new int[count];
                int index = 0;
                int[] nArray2 = ax;
                int n2 = ax.length;
                int n3 = 0;
                while (n3 < n2) {
                    int a = nArray2[n3];
                    if (a != -1) {
                        useTypes[index++] = a;
                    }
                    ++n3;
                }
                List<CaptureEvent> list = this.getPassChannel().captureByUseType(true, this.getReadPassportNumberEvent().isManualTrigger() ? 8 : 2, useTypes);
                if (list != null && !list.isEmpty()) {
                    for (CaptureEvent c : list) {
                        if (c == null) continue;
                        this.getReadPassportNumberEvent().addCaptureEvent(c);
                    }
                }
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u6293\u62cd\u56fe\u7247\u5f02\u5e38! " + ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reStart() {
        boolean ok = false;
        Object object = this.sessionStateSetLock;
        synchronized (object) {
            if (this.sessionState == SessionState.CANCELED) {
                this.sessionState = SessionState.PROCESSING;
                ok = true;
            }
        }
        if (ok) {
            this.fireSessionStateChange(SessionState.CANCELED, SessionState.PROCESSING);
            this.passChannel.startSession(this);
        }
    }

    public Collection<Integer> getConfirmPassExceptions() {
        return this.confirmPassExceptions;
    }

    public void setConfirmPassExceptions(Collection<Integer> confirmPassExceptions) {
        this.confirmPassExceptions = confirmPassExceptions;
    }

    public Collection<Integer> getForbidPassExceptions() {
        return this.forbidPassExceptions;
    }

    public void setForbidPassExceptions(Collection<Integer> forbidPassExceptions) {
        this.forbidPassExceptions = forbidPassExceptions;
    }

    public Collection<Integer> getAllowPassExcetpions() {
        return this.allowPassExcetpions;
    }

    public void setAllowPassExcetpions(Collection<Integer> allowPassExcetpions) {
        this.allowPassExcetpions = allowPassExcetpions;
    }

    public PassFilter getChargeFilter() {
        return this.chargeFilter;
    }

    public void setChargeFilter(PassFilter chargeFilter) {
        this.chargeFilter = chargeFilter;
    }

    public String getPassPlate() {
        ReadPassportNumberEvent e = this.getReadPassportNumberEvent();
        if (e != null && e.getPlateNumber() != null && e.getPlateNumber().length() > 0) {
            return e.getPlateNumber();
        }
        CarparkPassport p = this.getPassport();
        if (p != null) {
            if (p.getRegister_plate() != null && p.getRegister_plate().length() > 0) {
                return p.getRegister_plate();
            }
            if (p.getMedium_type() != null && p.getMedium_type() == 6 && p.getPassport_number() != null && p.getPassport_number().length() > 0) {
                return p.getPassport_number();
            }
        }
        return null;
    }

    public String getDsiplay1MsgWhenMoney() {
        return this.dsiplay1MsgWhenMoney;
    }

    public void setDsiplay1MsgWhenMoney(String dsiplay1MsgWhenMoney) {
        this.dsiplay1MsgWhenMoney = dsiplay1MsgWhenMoney;
    }

    public ScheduledFuture<?> getReDisplayPayMsg1Task() {
        return this.reDisplayPayMsg1Task;
    }

    public void setReDisplayPayMsg1Task(ScheduledFuture<?> reDisplayPayMsg1Task) {
        this.reDisplayPayMsg1Task = reDisplayPayMsg1Task;
    }

    public AtomicLong getHandlePaySuccessAdviceMills() {
        return this.handlePaySuccessAdviceMills;
    }

    public CarparkVisitAuth getVisitCar() {
        return this.visitCar;
    }

    public void setVisitCar(CarparkVisitAuth visitCar) {
        this.visitCar = visitCar;
    }

    public Long getSaveDataCacheId() {
        return this.saveDataCacheId;
    }

    public void setSaveDataCacheId(Long saveDataCacheId) {
        this.saveDataCacheId = saveDataCacheId;
    }

    public VehicleTypeEvent getVehicleTypeEvent() {
        return this.vehicleTypeEvent;
    }

    public void setVehicleTypeEvent(VehicleTypeEvent vehicleTypeEvent) {
        this.vehicleTypeEvent = vehicleTypeEvent;
    }

    public boolean isReadCard() {
        return !(this.readPassportNumberEvent == null || this.readPassportNumberEvent.getDetectedPassEvent() == null || this.readPassportNumberEvent.getDetectedPassEvent().getPlateNumber() != null && this.readPassportNumberEvent.getDetectedPassEvent().getPlateNumber().length() != 0 || this.readPassportNumberEvent.getDetectedPassEvent().getMediaNumber() == null || this.readPassportNumberEvent.getDetectedPassEvent().getMediaNumber().length() <= 0 || this.readPassportNumberEvent.getDetectedPassEvent().getMediaType() != DetectedPassEvent.MediaType.ID && this.readPassportNumberEvent.getDetectedPassEvent().getMediaType() != DetectedPassEvent.MediaType.IC);
    }

    public Long getEventPassId() {
        return this.eventPassId;
    }

    public void setEventPassId(Long eventPassId) {
        this.eventPassId = eventPassId;
    }

    public static enum SessionState {
        PENDING,
        PROCESSING,
        WAIT_PAY,
        OPEN_DIALOG,
        CANCELED,
        WAIT_CAR_LEAVE,
        CAR_LEAVING,
        CAR_LEFT;

    }

    public static interface SessionStateChangeListener
    extends EventListener {
        public void sessionStateChanged(PassSession var1, SessionState var2, SessionState var3);
    }
}

