/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PathFinder {
    private static File startupDir;

    public static File findHomeDir() {
        if (startupDir == null) {
            File f1;
            String path = System.getProperty("CARPARK_HOME");
            if (path != null && (f1 = new File(path)).exists() && f1.isDirectory()) {
                startupDir = f1;
                return startupDir;
            }
            boolean isDev = Boolean.valueOf(System.getProperty("CARPARK_DEV_MODE", "true"));
            ProtectionDomain pd = PathFinder.class.getProtectionDomain();
            if (pd == null) {
                return null;
            }
            CodeSource cs = pd.getCodeSource();
            if (cs == null) {
                return null;
            }
            URL url = cs.getLocation();
            if (url == null) {
                return null;
            }
            String result = url.toString();
            if (!result.endsWith(".jar")) {
                if (result.endsWith("/")) {
                    result = result.substring(0, result.length() - 1);
                }
                if (result.endsWith("/bin")) {
                    result = result.substring(0, result.lastIndexOf(47));
                }
            }
            result = result.substring(0, result.lastIndexOf(47));
            if (!isDev) {
                result = result.substring(0, result.lastIndexOf(47));
            }
            if (result == null) {
                throw new RuntimeException("Can not find the app boot path.");
            }
            if (Character.isUpperCase(result.charAt(0))) {
                char[] chars = result.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                result = new String(chars);
            }
            try {
                startupDir = new File(new URI(result));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return startupDir;
    }

    public static File findPluginsDir() {
        return new File(PathFinder.findHomeDir(), "plugins");
    }

    public static File findLogsDir() {
        File logs = new File(PathFinder.findLocalDir(), "logs");
        if (!logs.exists() || !logs.isDirectory()) {
            logs.mkdir();
        }
        return logs;
    }

    public static File findInstallationDir() {
        File installation = new File(PathFinder.findHomeDir(), "installation");
        if (!installation.exists() || !installation.isDirectory()) {
            installation.mkdir();
        }
        return installation;
    }

    public static File findRuncacheDir() {
        File logs = new File(PathFinder.findLocalDir(), "runcache");
        if (!logs.exists() || !logs.isDirectory()) {
            logs.mkdir();
        }
        return logs;
    }

    public static File findConfDir() {
        File conf = new File(PathFinder.findHomeDir(), "conf");
        if (!conf.exists() || !conf.isDirectory()) {
            conf.mkdir();
        }
        return conf;
    }

    public static File findLocalDir() {
        File findLocalDir = new File(PathFinder.findHomeDir(), "local");
        if (!findLocalDir.exists() || !findLocalDir.isDirectory()) {
            findLocalDir.mkdir();
        }
        return findLocalDir;
    }

    public static File findLocalPicDir() {
        File picDir = new File(PathFinder.findLocalDir(), "pic");
        if (!picDir.exists() || !picDir.isDirectory()) {
            picDir.mkdir();
        }
        return picDir;
    }

    public static File findLocalRuntimeDir() {
        File f = new File(PathFinder.findLocalDir(), "runtime");
        if (!f.exists() || !f.isDirectory()) {
            f.mkdir();
        }
        return f;
    }

    public static File findRuntimeTempDir() {
        File f = new File(PathFinder.findLocalRuntimeDir(), "temp");
        if (!f.exists() || !f.isDirectory()) {
            f.mkdir();
        }
        return f;
    }

    public static File findRuntimeTempDayDir() {
        File f = new File(PathFinder.findRuntimeTempDir(), new SimpleDateFormat("yyyMMdd").format(new Date()));
        if (!f.exists() || !f.isDirectory()) {
            f.mkdir();
        }
        return f;
    }

    public static File findExpandDir() {
        File expand = new File(PathFinder.findHomeDir(), "expand");
        if (!expand.exists() || !expand.isDirectory()) {
            expand.mkdir();
        }
        return expand;
    }
}

