/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.dto.CarparkPassSelfPay;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.DisplayVoiceService;
import com.wovoe.framework.JobTask;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PayCodePayTask
extends JobTask
implements PassSession.SessionStateChangeListener {
    private volatile int sec = 0;
    private ScheduledFuture<?> sc;
    private String orderNo;
    private String token;
    private volatile String state;
    private PassSession passSession;
    private String scanCode;
    private ApplicationService applicationService;
    private long nextexequeryMill;
    private int maxTimeout = 40;
    private volatile boolean querying = false;
    private volatile boolean disposed = false;
    private volatile boolean started = false;

    public PayCodePayTask(PassSession passSession, String scanCode) {
        this.passSession = passSession;
        this.scanCode = scanCode;
        this.applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
    }

    public String getScanCode() {
        return this.scanCode;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void start(boolean currentThreadRun) {
        if (this.started) {
            return;
        }
        this.started = true;
        this.passSession.setAttribute("PASS_SCANCODE_PLAYING", ServiceUtil.getServiceContext().currentTimeMillis());
        this.passSession.setAttribute("PASS_SCANCODE_TASK", this);
        this.passSession.addSessionStateChangeListener(this);
        this.sc = ServiceUtil.getServiceContext().getScheduledExecutorService().scheduleAtFixedRate((Runnable)((Object)this), 1L, 1L, TimeUnit.SECONDS);
        if (currentThreadRun) {
            this.doStart();
        } else {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    PayCodePayTask.this.doStart();
                }
            });
        }
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.sc != null) {
            this.sc.cancel(true);
            this.sc = null;
        }
        this.passSession.removeSessionStateChangeListener(this);
        this.passSession.removeAttribute("PASS_SCANCODE_TASK");
        this.passSession.removeAttribute("PASS_SCANCODE_PLAYING");
    }

    public void onPaySeuccess(CarparkPassSelfPay sefPay) {
        this.state = "SUCCESS";
        this.dispose();
    }

    private void doStart() {
        Map<String, Object> resultMap;
        try {
            resultMap = this.applicationService.doScanCodePay(this.scanCode, this.passSession, false);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            resultMap = new HashMap<String, Object>();
            resultMap.put("RETURN_CODE", "ERROR");
            resultMap.put("RETURN_VALUE", "\u5185\u90e8\u9519\u8bef");
        }
        String RETURN_CODE = (String)resultMap.get("RETURN_CODE");
        String RETURN_VALUE = (String)resultMap.get("RETURN_VALUE");
        String returnorderNo = (String)resultMap.get("orderNo");
        this.state = RETURN_CODE;
        if ("SUCCESS".equals(RETURN_CODE)) {
            ServiceLog.getLog().info((Object)(String.valueOf(this.passSession.getPassChannel().getChannel().getChannel_name()) + ": \u4ed8\u6b3e\u7801:" + this.scanCode + "\u652f\u4ed8\u6210\u529f\uff0c\u8f66\u724c\uff1a" + this.passSession.getPassPlate() + "\u7b49\u5f85\u670d\u52a1\u5668\u901a\u77e5.."));
        } else if ("NEEDQUERY".equals(RETURN_CODE)) {
            this.nextexequeryMill = ServiceUtil.getServiceContext().currentTimeMillis() + 7500L;
            this.token = RETURN_VALUE;
            this.orderNo = returnorderNo;
            DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
            sp.displayScanPayMsg(this.passSession, "\u652f\u4ed8\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e", "\u652f\u4ed8\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e", 8);
        } else if ("USERPAYPWD".equals(RETURN_CODE)) {
            this.nextexequeryMill = ServiceUtil.getServiceContext().currentTimeMillis() + 7500L;
            this.token = RETURN_VALUE;
            this.orderNo = returnorderNo;
            this.maxTimeout = 60;
            DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
            sp.displayScanPayMsg(this.passSession, "\u8bf7\u5728\u624b\u673a\u4e2d\u8f93\u5165\u652f\u4ed8\u5bc6\u7801", "\u8bf7\u8f93\u5165\u652f\u4ed8\u5bc6\u7801", 8);
        } else {
            try {
                String errMsg = RETURN_VALUE;
                if (errMsg == null || errMsg.length() == 0) {
                    errMsg = "\u652f\u4ed8\u5931\u8d25";
                }
                ServiceLog.getLog().warn((Object)("\u4ed8\u6b3e\u7801\u652f\u4ed8\u5931\u8d25!\u539f\u56e0: " + errMsg));
                if (errMsg.indexOf("\u652f\u4ed8\u5931\u8d25") == -1) {
                    errMsg = "\u652f\u4ed8\u5931\u8d25! " + errMsg;
                }
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this.passSession, errMsg, 4));
                DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                sp.displayScanPayMsg(this.passSession, "\u652f\u4ed8\u5931\u8d25", "\u652f\u4ed8\u5931\u8d25", 8);
            }
            finally {
                this.dispose();
            }
        }
    }

    private void cancelPay() {
        if (("NEEDQUERY".equals(this.state) || "USERPAYPWD".equals(this.state)) && this.token != null && this.token.length() > 0 && this.orderNo != null && this.orderNo.length() > 0) {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    Map<String, Object> resultMap = PayCodePayTask.this.applicationService.doCancelScanPay(PayCodePayTask.this.token, PayCodePayTask.this.orderNo);
                    String RETURN_CODE = (String)resultMap.get("RETURN_CODE");
                    String RETURN_VALUE = (String)resultMap.get("RETURN_VALUE");
                    if ("SUCCESS".equals(RETURN_CODE)) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(PayCodePayTask.this.passSession, "\u8ba2\u5355" + PayCodePayTask.this.orderNo + "\u5df2\u88ab\u6210\u529f\u64a4\u9500", 2));
                    } else {
                        if (RETURN_VALUE == null || RETURN_VALUE.length() == 0) {
                            RETURN_VALUE = "\u8ba2\u5355\u64a4\u9500\u5931\u8d25!";
                        }
                        ServiceLog.getLog().warn((Object)("\u64a4\u9500\u8ba2\u5355:" + PayCodePayTask.this.orderNo + "\u5931\u8d25\uff01\u539f\u56e0\uff1a" + RETURN_VALUE));
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(PayCodePayTask.this.passSession, "\u64a4\u9500\u8ba2\u5355:" + PayCodePayTask.this.orderNo + "\u5931\u8d25\uff01\u539f\u56e0\uff1a" + RETURN_VALUE, 4));
                    }
                }
            });
        }
    }

    protected void doRun() throws Exception {
        block15: {
            long sa;
            ++this.sec;
            if (this.sec > this.maxTimeout) {
                try {
                    this.dispose();
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this.passSession, "\u652f\u4ed8\u8d85\u65f6,\u6b63\u5728\u5c1d\u8bd5\u64a4\u9500\u8ba2\u5355...", 4));
                }
                finally {
                    this.cancelPay();
                }
            }
            DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
            sp.displayScanPayMsg(this.passSession, "\u652f\u4ed8\u4e2d" + this.sec, null, 8);
            if (("NEEDQUERY".equals(this.state) || "USERPAYPWD".equals(this.state)) && this.token != null && this.token.length() > 0 && this.orderNo != null && this.orderNo.length() > 0 && this.nextexequeryMill > 0L && !this.querying && (sa = ServiceUtil.getServiceContext().currentTimeMillis()) >= this.nextexequeryMill) {
                this.querying = true;
                try {
                    Map<String, Object> resultMap = this.applicationService.doQueryScanPayState(this.token, this.orderNo);
                    String RETURN_CODE = (String)resultMap.get("RETURN_CODE");
                    String RETURN_VALUE = (String)resultMap.get("RETURN_VALUE");
                    this.state = RETURN_CODE;
                    if ("SUCCESS".equals(RETURN_CODE)) {
                        ServiceLog.getLog().info((Object)(String.valueOf(this.passSession.getPassChannel().getChannel().getChannel_name()) + ": \u4ed8\u6b3e\u7801:" + this.scanCode + "\u652f\u4ed8\u6210\u529f\uff0c\u8f66\u724c\uff1a" + this.passSession.getPassPlate() + "\u7b49\u5f85\u670d\u52a1\u5668\u901a\u77e5.."));
                        break block15;
                    }
                    if ("NEEDQUERY".equals(RETURN_CODE)) {
                        ServiceLog.getLog().info((Object)("\u6b63\u5728\u7b49\u5f85\u8ba2\u5355" + this.orderNo + "\u652f\u4ed8\u7ed3\u679c:  " + RETURN_VALUE));
                        break block15;
                    }
                    try {
                        String errMsg = RETURN_VALUE;
                        if (errMsg == null || errMsg.length() == 0) {
                            errMsg = "\u652f\u4ed8\u5931\u8d25";
                        }
                        ServiceLog.getLog().warn((Object)("\u4ed8\u6b3e\u7801\u652f\u4ed8\u5931\u8d25!\u539f\u56e0: " + errMsg));
                        if (errMsg.indexOf("\u652f\u4ed8\u5931\u8d25") == -1) {
                            errMsg = "\u652f\u4ed8\u5931\u8d25! " + errMsg;
                        }
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this.passSession, errMsg, 4));
                        sp.displayScanPayMsg(this.passSession, "\u652f\u4ed8\u5931\u8d25", "\u652f\u4ed8\u5931\u8d25", 8);
                    }
                    finally {
                        this.dispose();
                    }
                }
                finally {
                    this.nextexequeryMill = ServiceUtil.getServiceContext().currentTimeMillis() + 5000L;
                    this.querying = false;
                }
            }
        }
    }

    @Override
    public void sessionStateChanged(PassSession session, PassSession.SessionState oldState, PassSession.SessionState newState) {
        if (newState != PassSession.SessionState.WAIT_PAY && newState != PassSession.SessionState.WAIT_CAR_LEAVE && !this.disposed) {
            this.maxTimeout = this.sec;
        }
    }
}

