/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkRolePermission;
import com.wovoe.framework.KeyValueEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PermissionManager {
    public static final int PERMISSION_CLIENT = 0;
    public static final int PERMISSION_WEB_MANAGER = 1;
    public static final String CLIENT_LOGIN_PERPIFX = "long_host_client_";
    private ConcurrentHashMap<Integer, Map<String, String>> permissionMap = new ConcurrentHashMap();

    public PermissionManager() {
        this.addPermission("visit_web_manage_index_page", "\u8bbf\u95ee\u9996\u9875\u5185\u5bb9", 1);
    }

    public void addPermission(String id, String name, int type) {
        Integer permissionType = type;
        ConcurrentHashMap<String, String> m = this.permissionMap.get(permissionType);
        if (m == null) {
            ConcurrentHashMap<String, String> m1 = new ConcurrentHashMap<String, String>();
            ConcurrentHashMap<String, String> m2 = this.permissionMap.putIfAbsent(permissionType, m1);
            m = m2 != null ? m2 : m1;
        }
        m.put(id, name);
    }

    public List<KeyValueEntry<String, String>> toPermissionList(Map<String, String> permissionmap) {
        KeyValueEntry<String, String> e;
        if (permissionmap == null || permissionmap.isEmpty()) {
            return new LinkedList<KeyValueEntry<String, String>>();
        }
        PriorityQueue<KeyValueEntry<String, String>> en = new PriorityQueue<KeyValueEntry<String, String>>(permissionmap.size(), new Comparator<KeyValueEntry<String, String>>(){

            @Override
            public int compare(KeyValueEntry<String, String> o1, KeyValueEntry<String, String> o2) {
                String v1 = (String)o1.getValue();
                String v2 = (String)o2.getValue();
                if (v1 == null) {
                    v1 = "";
                }
                if (v2 == null) {
                    v2 = "";
                }
                return v1.compareTo(v2);
            }
        });
        for (Map.Entry<String, String> e2 : permissionmap.entrySet()) {
            en.offer((KeyValueEntry<String, String>)new KeyValueEntry((Object)e2.getKey(), (Object)e2.getValue()));
        }
        ArrayList<KeyValueEntry<String, String>> llist = new ArrayList<KeyValueEntry<String, String>>(permissionmap.size());
        while ((e = en.poll()) != null) {
            llist.add(e);
        }
        return llist;
    }

    public Map<String, String> getPermissionMap(int permissionType) {
        Map<String, String> m1 = this.permissionMap.get(permissionType);
        if (m1 != null) {
            return Collections.unmodifiableMap(m1);
        }
        return Collections.emptyMap();
    }

    public void checkHostLoginPermission(Map<String, CarparkHost> hostMaps) {
        LinkedHashMap<String, String> allLonginHostMap = new LinkedHashMap<String, String>();
        if (hostMaps != null && !hostMaps.isEmpty()) {
            for (CarparkHost h : hostMaps.values()) {
                allLonginHostMap.put(CLIENT_LOGIN_PERPIFX + h.getHost_no(), "\u767b\u5f55\u4e3b\u673a\u3010" + h.getHost_name() + "\u3011");
            }
        }
        Map<String, String> exitMap = this.getExitLoginHostPermission();
        for (Map.Entry ens : allLonginHostMap.entrySet()) {
            String v1 = exitMap.remove(ens.getKey());
            if (v1 == null) {
                this.addPermission((String)ens.getKey(), (String)ens.getValue(), 0);
                continue;
            }
            if (v1.equals(ens.getValue())) continue;
            this.addPermission((String)ens.getKey(), (String)ens.getValue(), 0);
        }
        if (!exitMap.isEmpty()) {
            for (String s : exitMap.keySet()) {
                Map<String, String> m1 = this.permissionMap.get(0);
                if (m1 == null) continue;
                m1.remove(s);
            }
        }
    }

    private Map<String, String> getExitLoginHostPermission() {
        LinkedHashMap<String, String> allLonginHostMap = new LinkedHashMap<String, String>();
        Map<String, String> all = this.permissionMap.get(0);
        if (all != null) {
            for (Map.Entry<String, String> entry : all.entrySet()) {
                if (!entry.getKey().startsWith(CLIENT_LOGIN_PERPIFX)) continue;
                allLonginHostMap.put(entry.getKey(), entry.getValue());
            }
        }
        return allLonginHostMap;
    }

    public Set<String> getAllPermison(int type) {
        Map<String, String> all = this.permissionMap.get(type);
        if (all != null) {
            return Collections.unmodifiableSet(all.keySet());
        }
        return Collections.EMPTY_SET;
    }

    public Set<String> getValidPermission(List<CarparkRolePermission> list, int type) {
        HashSet<String> set = new HashSet<String>();
        Map<String, String> all = this.permissionMap.get(type);
        if (all != null && list != null) {
            for (CarparkRolePermission p : list) {
                if (p.getPermission_no() == null || !all.containsKey(p.getPermission_no())) continue;
                set.add(p.getPermission_no());
            }
        }
        return set;
    }
}

