/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.framework.BytesTool;
import java.util.Calendar;

public class SenselessOrderNo {
    public static String PREFIX = "L-";
    private static long x;
    private long queryFeeId;
    private String hostNo;
    private int value;
    private String no;
    private int carparkId;

    static {
        Calendar cl = Calendar.getInstance();
        cl.set(2020, 0, 1, 0, 0, 0);
        cl.set(14, 0);
        x = cl.getTimeInMillis();
    }

    private SenselessOrderNo() {
    }

    public SenselessOrderNo(long queryFeeId, String hostNo, int carparkId) {
        this.queryFeeId = queryFeeId;
        this.hostNo = hostNo;
        this.carparkId = carparkId;
        if (carparkId == 1) {
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            this.value = (int)((cl.getTimeInMillis() - x) / 1000L);
        } else {
            this.value = carparkId;
        }
    }

    public String toString() {
        return this.toOrderNo();
    }

    public String toOrderNo() {
        if (this.no == null || this.no.length() == 0) {
            this.no = this.toOrderNo0();
        }
        return this.no;
    }

    private String toOrderNo0() {
        byte[] queryFeeIdBytes = BytesTool.LongToBytes((long)this.queryFeeId);
        byte[] valueBytes = BytesTool.intToBytes((int)this.value);
        byte[] hostBytes = null;
        try {
            String ax = this.hostNo.substring(0, 1);
            long t = Long.parseLong(this.hostNo.substring(1));
            byte a1 = ax.getBytes()[0];
            if (a1 != -1) {
                byte[] a2 = BytesTool.LongToBytes((long)t);
                hostBytes = new byte[a2.length + 1];
                hostBytes[0] = a1;
                System.arraycopy(a2, 0, hostBytes, 1, a2.length);
            }
        }
        catch (Exception ax) {
            // empty catch block
        }
        if (hostBytes == null) {
            byte[] a2 = this.hostNo.getBytes();
            hostBytes = new byte[a2.length + 1];
            hostBytes[0] = -1;
            System.arraycopy(a2, 0, hostBytes, 1, a2.length);
        }
        byte[] dest = new byte[queryFeeIdBytes.length + 1 + valueBytes.length + hostBytes.length];
        int destPos = 0;
        System.arraycopy(queryFeeIdBytes, 0, dest, destPos, queryFeeIdBytes.length);
        destPos += queryFeeIdBytes.length;
        dest[destPos++] = this.carparkId == 1 ? (byte)1 : 0;
        System.arraycopy(valueBytes, 0, dest, destPos, valueBytes.length);
        System.arraycopy(hostBytes, 0, dest, destPos += valueBytes.length, hostBytes.length);
        return String.valueOf(PREFIX) + BytesTool.compressBytes((byte[])dest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SenselessOrderNo parse(String no) {
        if (no == null || no.length() == 0) {
            return null;
        }
        if (!no.startsWith(PREFIX)) {
            return null;
        }
        try {
            String hostNo;
            int carparkId;
            byte[] src = BytesTool.unCompress((String)no.substring(PREFIX.length()));
            int srcOffset = 0;
            long queryFeeId = BytesTool.BytesToLong((byte[])src, (int)srcOffset);
            srcOffset += 8;
            byte carparkIdx = src[srcOffset++];
            int value = BytesTool.bytesToInt((byte[])src, (int)srcOffset);
            srcOffset += 4;
            if (carparkIdx == 0) {
                carparkId = value;
            } else {
                if (carparkIdx != 1) {
                    return null;
                }
                carparkId = 1;
            }
            byte hostType = src[srcOffset++];
            if (hostType == -1) {
                hostNo = new String(src, srcOffset, src.length - srcOffset);
            } else {
                if (src.length - srcOffset != 8) {
                    return null;
                }
                String ax = new String(src, srcOffset - 1, 1);
                long a2 = BytesTool.BytesToLong((byte[])src, (int)srcOffset);
                hostNo = String.valueOf(ax) + String.valueOf(a2);
            }
            SenselessOrderNo t = new SenselessOrderNo();
            t.queryFeeId = queryFeeId;
            t.hostNo = hostNo;
            t.value = value;
            t.no = no;
            t.carparkId = carparkId;
            return t;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public long getQueryFeeId() {
        return this.queryFeeId;
    }

    public void setQueryFeeId(long queryFeeId) {
        this.queryFeeId = queryFeeId;
    }

    public String getHostNo() {
        return this.hostNo;
    }

    public void setHostNo(String hostNo) {
        this.hostNo = hostNo;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getCarparkId() {
        return this.carparkId;
    }

    public void setCarparkId(int carparkId) {
        this.carparkId = carparkId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.carparkId;
        result = 31 * result + (this.hostNo == null ? 0 : this.hostNo.hashCode());
        result = 31 * result + (int)(this.queryFeeId ^ this.queryFeeId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SenselessOrderNo other = (SenselessOrderNo)obj;
        if (this.carparkId != other.carparkId) {
            return false;
        }
        if (this.hostNo == null ? other.hostNo != null : !this.hostNo.equals(other.hostNo)) {
            return false;
        }
        return this.queryFeeId == other.queryFeeId;
    }
}

