/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.framework.FrameworkContextUtil;
import com.wovoe.framework.LogUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;

public class SingleThreadRunQueue
implements Runnable {
    private final LinkedBlockingQueue<Runnable> runnableQueue;
    private volatile boolean running;

    public SingleThreadRunQueue() {
        this(Integer.MAX_VALUE);
    }

    public SingleThreadRunQueue(int queueSize) {
        this.runnableQueue = new LinkedBlockingQueue(queueSize);
        this.running = false;
    }

    public void submit(Runnable task) throws RejectedExecutionException, NullPointerException {
        this.submit(task, FrameworkContextUtil.getFrameworkContext() == null ? null : FrameworkContextUtil.getFrameworkContext().getWorkThreadPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Runnable task, Executor executor) throws RejectedExecutionException, NullPointerException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        if (task == this) {
            throw new RejectedExecutionException("\u63d0\u4ea4\u7684\u4efb\u52a1\uff0c\u4e0d\u80fd\u4e3a\u5f53\u524d\u4efb\u52a1");
        }
        SingleThreadRunQueue singleThreadRunQueue = this;
        synchronized (singleThreadRunQueue) {
            if (!this.runnableQueue.offer(task)) {
                throw new RejectedExecutionException("task queue is full");
            }
            if (!this.running) {
                try {
                    this.running = true;
                    if (executor == null) {
                        new Thread(this).start();
                    } else {
                        executor.execute(this);
                    }
                }
                catch (Throwable ex) {
                    this.running = false;
                    this.runnableQueue.remove(task);
                    if (ex instanceof NullPointerException) {
                        throw (NullPointerException)ex;
                    }
                    if (ex instanceof RejectedExecutionException) {
                        throw (RejectedExecutionException)ex;
                    }
                    throw new RejectedExecutionException(ex.getMessage(), ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: while (true) {
            try {
                Runnable runnable;
                while ((runnable = this.runnableQueue.poll()) != null) {
                    try {
                        runnable.run();
                        continue block7;
                    }
                    catch (Throwable ex) {
                        LogUtil.getLog().warn((Object)ex.getMessage(), ex);
                    }
                }
                SingleThreadRunQueue singleThreadRunQueue = this;
                synchronized (singleThreadRunQueue) {
                    if (this.runnableQueue.peek() == null) {
                        this.running = false;
                        return;
                    }
                }
            }
            catch (Throwable ex) {
                LogUtil.getLog().warn((Object)ex.getMessage(), ex);
                return;
            }
        }
    }

    public boolean containsTask(Runnable task) {
        if (task == null) {
            return false;
        }
        return this.runnableQueue.contains(task);
    }

    public void clearAllTask() {
        this.runnableQueue.clear();
    }
}

