/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.dto.CarparkDutyNumber;
import com.wovoe.carpark.dto.CarparkRole;
import com.wovoe.carpark.dto.CarparkUser;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class UserSession {
    private CarparkUser user;
    private CarparkDutyNumber dutyNumber;
    private Set<String> permissions;
    private final Map<String, Object> attributes;
    private CarparkRole role;

    public CarparkUser getUser() {
        return this.user;
    }

    public UserSession(CarparkUser user) {
        this.user = user;
        this.attributes = new ConcurrentHashMap<String, Object>();
    }

    public Object setAttribute(String name, Object value) {
        return this.attributes.put(name, value);
    }

    public CarparkRole getRole() {
        return this.role;
    }

    public void setRole(CarparkRole role) {
        this.role = role;
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public CarparkDutyNumber getDutyNumber() {
        return this.dutyNumber;
    }

    public void setDutyNumber(CarparkDutyNumber dutyNumber) {
        this.dutyNumber = dutyNumber;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public boolean hasPermission(String permissionCode) {
        if (permissionCode == null) {
            return false;
        }
        if (this.user == null) {
            return false;
        }
        if ("1".equals(this.user.getRole_no())) {
            return true;
        }
        if (this.permissions == null) {
            return false;
        }
        return this.permissions.contains(permissionCode);
    }
}

