/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidateUtil {
    private static final Set<Integer> CAP_NUMS = new HashSet<Integer>();
    private static final int[] PARITYBIT = new int[]{49, 48, 88, 57, 56, 55, 54, 53, 52, 51, 50};
    private static final int[] POWER_LIST = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};

    static {
        CAP_NUMS.add(11);
        CAP_NUMS.add(12);
        CAP_NUMS.add(13);
        CAP_NUMS.add(14);
        CAP_NUMS.add(15);
        CAP_NUMS.add(21);
        CAP_NUMS.add(22);
        CAP_NUMS.add(23);
        CAP_NUMS.add(31);
        CAP_NUMS.add(32);
        CAP_NUMS.add(33);
        CAP_NUMS.add(34);
        CAP_NUMS.add(35);
        CAP_NUMS.add(36);
        CAP_NUMS.add(37);
        CAP_NUMS.add(41);
        CAP_NUMS.add(42);
        CAP_NUMS.add(43);
        CAP_NUMS.add(44);
        CAP_NUMS.add(45);
        CAP_NUMS.add(46);
        CAP_NUMS.add(50);
        CAP_NUMS.add(51);
        CAP_NUMS.add(52);
        CAP_NUMS.add(53);
        CAP_NUMS.add(54);
        CAP_NUMS.add(61);
        CAP_NUMS.add(62);
        CAP_NUMS.add(63);
        CAP_NUMS.add(64);
        CAP_NUMS.add(71);
        CAP_NUMS.add(81);
        CAP_NUMS.add(82);
        CAP_NUMS.add(91);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isIDCard(String certNo) {
        try {
            if (certNo == null || certNo.length() != 15 && certNo.length() != 18) {
                return false;
            }
            GregorianCalendar curDay = new GregorianCalendar();
            int curYear = curDay.get(1);
            int year15 = Integer.parseInt(String.valueOf(curYear).substring(2));
            char[] cs = certNo.toUpperCase().toCharArray();
            int power = 0;
            int i = 0;
            while (i < cs.length && (i != cs.length - 1 || cs[i] != 'X')) {
                if (cs[i] < '0' || cs[i] > '9') {
                    return false;
                }
                if (i < cs.length - 1) {
                    power += (cs[i] - 48) * POWER_LIST[i];
                }
                ++i;
            }
            if (!CAP_NUMS.contains(Integer.valueOf(certNo.substring(0, 2)))) {
                return false;
            }
            String year = certNo.length() == 15 ? String.valueOf(year15) + certNo.substring(6, 8) : certNo.substring(6, 10);
            int iyear = Integer.parseInt(year);
            if (iyear < 1900 || iyear > Calendar.getInstance().get(1)) {
                return false;
            }
            String month = certNo.length() == 15 ? certNo.substring(8, 10) : certNo.substring(10, 12);
            int imonth = Integer.parseInt(month);
            if (imonth < 1 || imonth > 12) {
                return false;
            }
            String day = certNo.length() == 15 ? certNo.substring(10, 12) : certNo.substring(12, 14);
            int iday = Integer.parseInt(day);
            if (iday < 1 || iday > 31) {
                return false;
            }
            return certNo.length() == 15 || cs[cs.length - 1] == PARITYBIT[power % 11];
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isEmail(String email) {
        if (email == null || email.length() == 0) {
            return false;
        }
        String regEx1 = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        Pattern p = Pattern.compile(regEx1);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean isCellPhone(String phoneNo) {
        if (phoneNo == null || phoneNo.length() == 0) {
            return false;
        }
        String regEx1 = "^[1|9][3|4|5|6|7|8|9][0-9]{9}$";
        Pattern p = Pattern.compile(regEx1);
        Matcher m = p.matcher(phoneNo);
        return m.matches();
    }

    public static boolean isNumeric(String str) {
        int i = 0;
        while (i < str.length()) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

