/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark;

import com.wovoe.carpark.WanProxyHost;
import com.wovoe.carpark.internel.ServiceUtil;
import java.net.InetAddress;
import java.net.Proxy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WanNetHostSelector {
    public static final WanProxyHost SELF_HOST;
    private static volatile WanProxyHost currentProxyHost;

    static {
        currentProxyHost = SELF_HOST = new WanProxyHost(Proxy.NO_PROXY, "localhost", "localhost", "localhost");
    }

    public static WanProxyHost getWanProxyHost() {
        return currentProxyHost;
    }

    public static boolean isDirectMode(WanProxyHost host) {
        return host.getProxy().type() == Proxy.Type.DIRECT;
    }

    public static boolean isProxyMode(WanProxyHost host) {
        return !WanNetHostSelector.isDirectMode(host);
    }

    public static void setWanProxyHost(WanProxyHost host) {
        if (host == null) {
            host = SELF_HOST;
        }
        currentProxyHost = host;
    }

    public static boolean isIpV4(String str) {
        Pattern pattern = Pattern.compile("^(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])$");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static WanProxyHost getWanProxyHost(String remoteHostPort) {
        if (currentProxyHost == SELF_HOST) {
            return SELF_HOST;
        }
        if (remoteHostPort == null || remoteHostPort.length() == 0) {
            return WanNetHostSelector.getWanProxyHost();
        }
        if (remoteHostPort.indexOf("://") != -1 && ((remoteHostPort = WanNetHostSelector.getHost(remoteHostPort)) == null || remoteHostPort.length() == 0)) {
            return WanNetHostSelector.getWanProxyHost();
        }
        int x = remoteHostPort.indexOf(58);
        if (x != -1) {
            remoteHostPort = remoteHostPort.substring(0, x);
        }
        if ("localHost".equalsIgnoreCase(remoteHostPort)) {
            return SELF_HOST;
        }
        if ("127.0.0.1".equals(remoteHostPort)) {
            return SELF_HOST;
        }
        if (ServiceUtil.getServiceContext().getLocalIPSet().contains(remoteHostPort)) {
            return SELF_HOST;
        }
        if (WanNetHostSelector.isIpV4(remoteHostPort)) {
            try {
                InetAddress address = InetAddress.getByName(remoteHostPort);
                if (address.isLoopbackAddress()) {
                    return SELF_HOST;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return WanNetHostSelector.getWanProxyHost();
    }

    public static String getHost(String url) {
        if (url == null || url.length() == 0) {
            return null;
        }
        String vla = "://";
        int len = url.indexOf(vla);
        if (len == -1) {
            return null;
        }
        String a = url.substring(len + vla.length());
        int i = a.indexOf(47);
        String hostport = a;
        if (i != -1) {
            hostport = a.substring(0, i);
        }
        String host = hostport;
        i = hostport.indexOf(58);
        if (i != -1) {
            host = hostport.substring(0, i);
        }
        return host;
    }
}

