/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.charge;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.charge.CarparkCharge;
import com.wovoe.carpark.charge.ChargeAlgorithm;
import com.wovoe.carpark.charge.ChargeContext;
import com.wovoe.carpark.charge.ChargePassRecord;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.charge.DateTypeSelector;
import com.wovoe.carpark.charge.Discount;
import com.wovoe.carpark.charge.PeriodMultiPassCost;
import com.wovoe.carpark.dto.CarparkChargeRule;
import com.wovoe.carpark.dto.CarparkChargeSegmentRule;
import com.wovoe.framework.KeyValueEntry;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DefaultCarparkCharge
implements CarparkCharge {
    protected void setChargePassRecordMins0(ChargePassRecord chargePassRecord, ChargeContext context) {
        if (chargePassRecord != null && context != null && chargePassRecord.getEnterTime() != null && chargePassRecord.getExitTime() != null) {
            Calendar cl = Calendar.getInstance();
            cl.setTime(chargePassRecord.getExitTime());
            cl.set(14, 0);
            chargePassRecord.setExitTime(cl.getTime());
            cl.setTime(chargePassRecord.getEnterTime());
            cl.set(14, 0);
            chargePassRecord.setEnterTime(cl.getTime());
            long miss = chargePassRecord.getExitTime().getTime() - chargePassRecord.getEnterTime().getTime();
            if (miss < 0L) {
                miss = 0L;
            }
            int secs = (int)TimeUnit.MILLISECONDS.toSeconds(miss);
            int mins = (int)context.getMins(secs);
            cl.add(12, mins);
            chargePassRecord.setExitTime(cl.getTime());
        }
    }

    @Override
    public Cost exitCharge(int projectId, int carparkId, String passportTypeNo, String carTypeNo, Date expirDate, ChargePassRecord chargePassRecord, List<ChargePassRecord> subChargePassRecordList, String plateNo, List<Discount> discounts, ChargeContext context, ChargeAlgorithm chargeAlgorithm) {
        KeyValueEntry<Discount, Date> dkv;
        Calendar cl;
        if (chargePassRecord == null || chargePassRecord.getEnterTime() == null || chargePassRecord.getExitTime() == null || passportTypeNo == null || carTypeNo == null) {
            Cost cost = new Cost();
            cost.setShouldCharged(Cost.ZERO);
            cost.setChargeDetail(new LinkedHashMap<String, String>());
            return cost;
        }
        if (chargePassRecord.getEnterTime().getTime() >= chargePassRecord.getExitTime().getTime()) {
            Cost cost = new Cost();
            cost.setShouldCharged(Cost.ZERO);
            cost.setChargeDetail(new LinkedHashMap<String, String>());
            return cost;
        }
        if (expirDate != null) {
            cl = Calendar.getInstance();
            cl.setTime(expirDate);
            cl.add(13, 1);
            expirDate = cl.getTime();
        }
        this.setChargePassRecordMins0(chargePassRecord, context);
        if (TimeUnit.MILLISECONDS.toSeconds(chargePassRecord.getExitTime().getTime() - chargePassRecord.getEnterTime().getTime()) < 60L && 1 == context.getParkingLessLanOneMinsStrategy()) {
            cl = Calendar.getInstance();
            cl.setTime(chargePassRecord.getEnterTime());
            cl.add(12, 1);
            if (cl.getTime().after(chargePassRecord.getExitTime())) {
                chargePassRecord.setExitTime(cl.getTime());
            }
        }
        subChargePassRecordList = this.getSubPassRecordList(subChargePassRecordList, chargePassRecord);
        boolean haveFirst = true;
        boolean haveFreeTime = true;
        try {
            boolean findNoFreeTime = false;
            List<KeyValueEntry<Date, Date>> noFreeTimeDateList = context.getNoFreeTimeList(passportTypeNo);
            if (noFreeTimeDateList != null && !noFreeTimeDateList.isEmpty()) {
                Calendar cl2 = Calendar.getInstance();
                cl2.setTime(chargePassRecord.getEnterTime());
                cl2.set(2000, 0, 1);
                long enterMills = cl2.getTimeInMillis();
                cl2.setTime(chargePassRecord.getExitTime());
                cl2.set(2000, 0, 1);
                long exitMills = cl2.getTimeInMillis();
                for (KeyValueEntry<Date, Date> en : noFreeTimeDateList) {
                    if ((enterMills < ((Date)en.getKey()).getTime() || enterMills >= ((Date)en.getValue()).getTime()) && (exitMills < ((Date)en.getKey()).getTime() || exitMills >= ((Date)en.getValue()).getTime())) continue;
                    findNoFreeTime = true;
                    break;
                }
            }
            if (findNoFreeTime) {
                haveFreeTime = false;
            }
        }
        catch (Exception findNoFreeTime) {
            // empty catch block
        }
        if ((dkv = this.getFreeDateKv(discounts, context)) != null && dkv.getValue() != null) {
            Cost cost;
            Date d = (Date)dkv.getValue();
            if (d.getTime() >= chargePassRecord.getExitTime().getTime()) {
                cost = this.exitCharge01(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, null, context, chargeAlgorithm, haveFirst, haveFreeTime);
                if (cost.getActualCharge().doubleValue() > 0.0) {
                    cost.setDiscountMoney(cost.getActualCharge());
                    if (dkv.getKey() != null) {
                        ((Discount)dkv.getKey()).setAmount(cost.getDiscountMoney());
                    }
                }
                return cost;
            }
            if (d.getTime() <= chargePassRecord.getEnterTime().getTime()) {
                return this.exitCharge01(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, discounts, context, chargeAlgorithm, true, true);
            }
            cost = this.exitCharge01(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, null, context, chargeAlgorithm, haveFirst, haveFreeTime);
            ChargePassRecord r = chargePassRecord.clone();
            r.setEnterTime(d);
            Cost cost1 = this.exitCharge01(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, r, this.getSubPassRecordList(subChargePassRecordList, r), plateNo, discounts, context, chargeAlgorithm, haveFirst, haveFreeTime);
            BigDecimal d1 = cost.getShouldCharged().subtract(cost1.getShouldCharged());
            if (d1.doubleValue() > 0.0) {
                cost1.setShouldCharged(cost1.getShouldCharged().add(d1));
                if (cost1.getDiscountMoney() == null) {
                    cost1.setDiscountMoney(d1);
                } else {
                    cost1.setDiscountMoney(d1.add(cost1.getDiscountMoney()));
                }
                if (dkv.getKey() != null) {
                    ((Discount)dkv.getKey()).setAmount(d1);
                }
            }
            cost1.setChargeTimeMinutes(cost.getChargeTimeMinutes());
            return cost1;
        }
        return this.exitCharge01(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, discounts, context, chargeAlgorithm, haveFirst, haveFreeTime);
    }

    /*
     * WARNING - void declaration
     */
    protected Cost exitCharge01(int projectId, int carparkId, String passportTypeNo, String carTypeNo, Date expirDate, ChargePassRecord chargePassRecord, List<ChargePassRecord> subChargePassRecordList, String plateNo, List<Discount> discounts, ChargeContext context, ChargeAlgorithm chargeAlgorithm, boolean haveFirst, boolean haveFreeTime) {
        if (chargePassRecord.getFirstPassportTypeNo() != null && chargePassRecord.getFirstPassportTypeNo().length() > 0 && !chargePassRecord.getFirstPassportTypeNo().equals(passportTypeNo) && chargePassRecord.getFirtEndTime() != null && chargePassRecord.getFirtEndTime().after(chargePassRecord.getEnterTime()) && chargePassRecord.getFirtEndTime().before(chargePassRecord.getExitTime())) {
            if (expirDate != null && expirDate.before(chargePassRecord.getEnterTime())) {
                return this.exitCharge0(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, discounts, context, chargeAlgorithm, haveFirst, haveFreeTime);
            }
            ChargePassRecord chargePassRecord0 = chargePassRecord.clone();
            chargePassRecord0.setExitTime(chargePassRecord.getFirtEndTime());
            int mins = (int)TimeUnit.MICROSECONDS.toMinutes(chargePassRecord0.getExitTime().getTime() - chargePassRecord0.getEnterTime().getTime());
            LinkedList<Discount> mins1List = null;
            LinkedList<Discount> mins2List = null;
            HashMap<Discount, KeyValueEntry> discountMap = null;
            if (discounts != null && !discounts.isEmpty()) {
                for (Discount r : discounts) {
                    if (r.getDiscount_method() != 1 || r.getDiscount_value() <= 0) continue;
                    if (mins1List == null) {
                        mins1List = new LinkedList<Discount>();
                    }
                    if (r.getDiscount_value() <= mins) {
                        int min2 = r.getDiscount_value() - mins;
                        Discount discount = r.clone();
                        discount.setDiscount_value(mins);
                        mins1List.add(discount);
                        Discount d2 = r.clone();
                        d2.setDiscount_value(min2);
                        if (mins2List == null) {
                            mins2List = new LinkedList<Discount>();
                        }
                        mins2List.add(d2);
                        if (discountMap == null) {
                            discountMap = new HashMap<Discount, KeyValueEntry>();
                        }
                        discountMap.put(r, new KeyValueEntry((Object)discount, (Object)d2));
                        continue;
                    }
                    mins1List.add(r);
                }
            }
            Cost cost = this.exitCharge0(projectId, carparkId, chargePassRecord.getFirstPassportTypeNo(), carTypeNo, null, chargePassRecord0, this.getSubPassRecordList(subChargePassRecordList, chargePassRecord0), plateNo, mins1List, context, chargeAlgorithm, haveFirst, haveFreeTime);
            ChargePassRecord chargePassRecord1 = chargePassRecord.clone();
            chargePassRecord1.setEnterTime(chargePassRecord.getFirtEndTime());
            Cost cost1 = this.exitCharge0(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord1, this.getSubPassRecordList(subChargePassRecordList, chargePassRecord1), plateNo, mins1List, context, chargeAlgorithm, haveFirst, haveFreeTime);
            if (cost1.getShouldCharged().doubleValue() > 0.0) {
                if (cost.getShouldCharged().doubleValue() > 0.0) {
                    cost.setChargeTimeMinutes(cost.getChargeTimeMinutes() + cost1.getChargeTimeMinutes());
                } else {
                    cost.setCharge_start_time(cost1.getCharge_start_time());
                    cost.setChargeTimeMinutes(cost1.getChargeTimeMinutes());
                }
                cost.setShouldCharged(cost.getShouldCharged().add(cost1.getShouldCharged()));
                if (cost1.getDiscountMoney().doubleValue() > 0.0) {
                    cost.setDiscountMoney(cost.getDiscountMoney().add(cost1.getDiscountMoney()));
                }
            }
            if (discountMap != null) {
                for (Map.Entry entry : discountMap.entrySet()) {
                    BigDecimal m1 = ((Discount)((KeyValueEntry)entry.getValue()).getKey()).getAmount();
                    BigDecimal m2 = ((Discount)((KeyValueEntry)entry.getValue()).getValue()).getAmount();
                    if (m1 == null) {
                        m1 = Cost.ZERO;
                    }
                    if (m2 == null) {
                        m2 = Cost.ZERO;
                    }
                    ((Discount)entry.getKey()).setAmount(m1.add(m2));
                }
            }
            if (discounts != null && !discounts.isEmpty()) {
                void var22_27;
                BigDecimal bigDecimal = cost.getActualCharge();
                if (bigDecimal.doubleValue() > 0.0) {
                    for (Discount d : discounts) {
                        if (d.getDiscount_method() != 0 || d.getDiscount_value() <= 0) continue;
                        BigDecimal dmoney = new BigDecimal((double)d.getDiscount_value() / 100.0).setScale(2, 4);
                        if (dmoney.doubleValue() > var22_27.doubleValue()) {
                            dmoney = var22_27;
                        }
                        if (cost.getDiscountMoney() == null) {
                            cost.setDiscountMoney(dmoney);
                        } else {
                            cost.setDiscountMoney(dmoney.add(cost.getDiscountMoney()));
                        }
                        d.setAmount(dmoney);
                        BigDecimal bigDecimal2 = cost.getActualCharge();
                        if (bigDecimal2.doubleValue() <= 0.0) break;
                    }
                }
                if (var22_27.doubleValue() > 0.0) {
                    for (Discount d : discounts) {
                        void var22_29;
                        if (d.getDiscount_method() != 2 || d.getDiscount_value() <= 0 || !(var22_29.doubleValue() > 0.0)) continue;
                        int dx = d.getDiscount_value();
                        if (dx < 0) {
                            dx = 0;
                        } else if (dx > 100) {
                            dx = 100;
                        }
                        if (dx >= 100) {
                            if (cost.getDiscountMoney() == null) {
                                cost.setDiscountMoney((BigDecimal)var22_29);
                            } else {
                                cost.setDiscountMoney(var22_29.add(cost.getDiscountMoney()));
                            }
                            d.setAmount((BigDecimal)var22_29);
                            BigDecimal bigDecimal3 = cost.getActualCharge();
                            break;
                        }
                        BigDecimal m = var22_29.multiply(new BigDecimal((double)dx / 100.0)).setScale(2, 4);
                        if (cost.getDiscountMoney() == null) {
                            cost.setDiscountMoney(m);
                        } else {
                            cost.setDiscountMoney(m.add(cost.getDiscountMoney()));
                        }
                        d.setAmount(m);
                        BigDecimal bigDecimal4 = cost.getActualCharge();
                    }
                }
            }
            return cost;
        }
        return this.exitCharge0(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, discounts, context, chargeAlgorithm, haveFirst, haveFreeTime);
    }

    protected List<ChargePassRecord> getSubPassRecordList(List<ChargePassRecord> subChargePassRecordList, ChargePassRecord chargePassRecord) {
        if (subChargePassRecordList == null || subChargePassRecordList.isEmpty()) {
            return subChargePassRecordList;
        }
        LinkedList<ChargePassRecord> subList = new LinkedList<ChargePassRecord>();
        for (ChargePassRecord r : subChargePassRecordList) {
            if (r.getAreaLevel() <= chargePassRecord.getAreaLevel() || r.getEnterTime() == null) continue;
            Date ex = r.getExitTime();
            if (ex == null) {
                ex = chargePassRecord.getExitTime();
            }
            if (ex.getTime() > chargePassRecord.getExitTime().getTime()) {
                ex = chargePassRecord.getExitTime();
            }
            if (ex.getTime() <= r.getEnterTime().getTime()) continue;
            ChargePassRecord r1 = r.clone();
            if (r.getEnterTime().getTime() < chargePassRecord.getEnterTime().getTime()) {
                r1.setEnterTime(chargePassRecord.getEnterTime());
            }
            r1.setExitTime(ex);
            subList.add(r1);
        }
        return subList;
    }

    protected CarparkChargeRule findPeriodMultiChargeRule(int projectId, int carparkId, String passportTypeNo, String carTypeNo, String plateNo, Date expirDate, ChargePassRecord chargePassRecord, ChargeContext context) {
        if (chargePassRecord.getAreaNo() == null || chargePassRecord.getAreaNo().length() == 0 || passportTypeNo == null || passportTypeNo.length() == 0 || carTypeNo == null || carTypeNo.length() == 0 || plateNo == null || plateNo.length() < 4) {
            return null;
        }
        CarparkChargeRule rule1 = context.findChargeRule(projectId, carparkId, passportTypeNo, carTypeNo, chargePassRecord.getAreaNo());
        CarparkChargeRule r1 = null;
        if (expirDate != null && expirDate.getTime() < chargePassRecord.getExitTime().getTime()) {
            String expirePassportTypeNo = context.getExpiredChargePassportTypeNo(projectId, carparkId, passportTypeNo);
            if (expirePassportTypeNo == null || expirePassportTypeNo.length() == 0) {
                expirePassportTypeNo = passportTypeNo;
            }
            if (!expirePassportTypeNo.equals(passportTypeNo)) {
                r1 = context.findChargeRule(projectId, carparkId, expirePassportTypeNo, carTypeNo, chargePassRecord.getAreaNo());
            }
        }
        if (r1 != null && r1.getPeriod_multi() == 1 && r1.getPeriod_multi_hours() != null && r1.getPeriod_multi_hours() > 0 && r1.getPeriod_multi_max_money() != null && r1.getPeriod_multi_max_money().doubleValue() > 0.0) {
            return r1;
        }
        if (rule1 != null && rule1.getPeriod_multi() == 1 && rule1.getPeriod_multi_hours() != null && rule1.getPeriod_multi_hours() > 0 && rule1.getPeriod_multi_max_money() != null && rule1.getPeriod_multi_max_money().doubleValue() > 0.0) {
            return rule1;
        }
        return null;
    }

    protected int getSegementCrossStrategy(ChargeContext context) {
        return context.getSegementCrossStrategy();
    }

    protected int getSegementTimeLenStrategy(ChargeContext context) {
        return context.getSegementTimeLenStrategy();
    }

    protected Cost exitMultiChargeByEnterTime(int projectId, int carparkId, String passportTypeNo, String carTypeNo, Date expirDate, ChargePassRecord chargePassRecord, List<ChargePassRecord> subChargePassRecordList, String plateNo, List<Discount> discounts, ChargeContext context, ChargeAlgorithm chargeAlgorithm, boolean haveFirst, boolean haveFreeTime, CarparkChargeRule periodMultiChargeRule, PeriodMultiPassCost periodMultiPassCost, Date beginTime, Date endTime, int period_multi_hours, KeyValueEntry<Integer, Integer> enjoyedFreeTimeKV) {
        CarparkChargeSegmentRule resetSegmentRuleFreeTimeLenRule = null;
        Integer resetSegmentRuleFreeTimeLen = null;
        try {
            BigDecimal demail;
            if (period_multi_hours <= 0) {
                period_multi_hours = 24;
            }
            Cost cost = new Cost();
            cost.setChargeDetail(new LinkedHashMap<String, String>());
            cost.setShouldCharged(Cost.ZERO);
            Calendar cl = Calendar.getInstance();
            if (periodMultiPassCost == null) {
                periodMultiPassCost = new PeriodMultiPassCost();
            }
            if (periodMultiPassCost.getPeriodStartDate() == null || periodMultiPassCost.getPeriodStartDate().getTime() >= beginTime.getTime()) {
                periodMultiPassCost.setPeriodStartDate(beginTime);
                periodMultiPassCost.setAlreadyCost(Cost.ZERO);
            } else {
                cl.setTime(periodMultiPassCost.getPeriodStartDate());
                cl.add(11, period_multi_hours);
                if (cl.getTimeInMillis() <= beginTime.getTime()) {
                    periodMultiPassCost.setPeriodStartDate(beginTime);
                    periodMultiPassCost.setAlreadyCost(Cost.ZERO);
                }
            }
            if (periodMultiPassCost.getAlreadyCost() == null || periodMultiPassCost.getAlreadyCost().doubleValue() <= 0.0) {
                periodMultiPassCost.setPeriodStartDate(beginTime);
                periodMultiPassCost.setAlreadyCost(Cost.ZERO);
            }
            if (haveFreeTime && periodMultiChargeRule.getPeriod_multi_free_time() != null) {
                CarparkChargeSegmentRule r;
                if (1 == periodMultiChargeRule.getPeriod_multi_free_time()) {
                    if (enjoyedFreeTimeKV != null && enjoyedFreeTimeKV.getKey() != null && (Integer)enjoyedFreeTimeKV.getKey() > 0) {
                        haveFreeTime = false;
                    }
                } else if (2 == periodMultiChargeRule.getPeriod_multi_free_time() && enjoyedFreeTimeKV != null && enjoyedFreeTimeKV.getValue() != null && (Integer)enjoyedFreeTimeKV.getValue() > 0 && (r = this.getSegmentRule(periodMultiChargeRule, chargePassRecord.getEnterTime(), context)) != null && r.getFree_time_len() != null && r.getFree_time_len() > 0) {
                    int remain = r.getFree_time_len() - (Integer)enjoyedFreeTimeKV.getValue();
                    if (remain <= 0) {
                        haveFreeTime = false;
                    } else {
                        resetSegmentRuleFreeTimeLenRule = r;
                        resetSegmentRuleFreeTimeLen = r.getFree_time_len();
                        r.setFree_time_len(remain);
                    }
                }
            }
            cost.setPeriod_multi_start(periodMultiPassCost.getPeriodStartDate());
            cost.setPeriod_multi_received(periodMultiPassCost.getAlreadyCost());
            cl.setTime(periodMultiPassCost.getPeriodStartDate());
            cl.add(11, period_multi_hours);
            if (cl.getTimeInMillis() >= endTime.getTime()) {
                if (haveFirst && periodMultiChargeRule.getPeriod_multi_first_segment() != null && 1 == periodMultiChargeRule.getPeriod_multi_first_segment() && periodMultiPassCost.getAlreadyCost().doubleValue() > 0.0) {
                    haveFirst = false;
                }
                if ((demail = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, 0, context, chargeAlgorithm, haveFirst, haveFreeTime, cost.getChargeDetail()).getShouldCharged()).doubleValue() < 0.0) {
                    demail = Cost.ZERO;
                }
                cost.setShouldCharged(demail);
                cost.setNext_period_multi_start(periodMultiPassCost.getPeriodStartDate());
                if (periodMultiPassCost.getAlreadyCost().doubleValue() >= periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                    cost.setPeriod_multi_free(demail);
                    cost.setNext_period_multi_cur(Cost.ZERO);
                } else {
                    BigDecimal bmoney = periodMultiPassCost.getAlreadyCost().add(demail);
                    if (bmoney.doubleValue() > periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                        cost.setNext_period_multi_cur(periodMultiChargeRule.getPeriod_multi_max_money().subtract(periodMultiPassCost.getAlreadyCost()));
                        cost.setPeriod_multi_free(demail.subtract(cost.getNext_period_multi_cur()));
                    } else {
                        cost.setPeriod_multi_free(Cost.ZERO);
                        cost.setNext_period_multi_cur(demail);
                    }
                }
            } else {
                ChargePassRecord roc;
                demail = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, 0, context, chargeAlgorithm, haveFirst, haveFreeTime, cost.getChargeDetail()).getShouldCharged();
                if (demail.doubleValue() < 0.0) {
                    demail = Cost.ZERO;
                }
                cost.setShouldCharged(demail);
                int len = (int)TimeUnit.MILLISECONDS.toMinutes(endTime.getTime() - beginTime.getTime());
                if (periodMultiPassCost.getPeriodStartDate().getTime() < beginTime.getTime()) {
                    if (demail.doubleValue() == 0.0) {
                        cost.setPeriod_multi_free(Cost.ZERO);
                    } else if (len < period_multi_hours * 60 && periodMultiPassCost.getAlreadyCost().add(demail).doubleValue() <= periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                        cost.setPeriod_multi_free(Cost.ZERO);
                    } else {
                        int firstLenFront;
                        cl.setTime(periodMultiPassCost.getPeriodStartDate());
                        cl.add(11, period_multi_hours);
                        Date end1 = cl.getTime();
                        int fontMins = (int)TimeUnit.MILLISECONDS.toMinutes(end1.getTime() - beginTime.getTime());
                        boolean hasBackFirstTime = haveFirst ? ((firstLenFront = this.getFirstMinuts(periodMultiChargeRule, beginTime, context)) <= 0 ? false : (fontMins >= firstLenFront ? false : haveFirst)) : false;
                        roc = chargePassRecord.clone();
                        roc.setEnterTime(end1);
                        roc.setExitTime(endTime);
                        BigDecimal m2 = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, roc, this.getSubPassRecordList(subChargePassRecordList, roc), plateNo, 0, context, chargeAlgorithm, hasBackFirstTime, false, cost.getChargeDetail()).getShouldCharged();
                        if (m2.doubleValue() >= demail.doubleValue()) {
                            cost.setPeriod_multi_free(Cost.ZERO);
                        } else {
                            BigDecimal x = demail.subtract(m2);
                            if (x.doubleValue() <= 0.0) {
                                cost.setPeriod_multi_free(Cost.ZERO);
                            } else if (periodMultiPassCost.getAlreadyCost().doubleValue() >= periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                                cost.setPeriod_multi_free(x);
                            } else {
                                BigDecimal bmoney = periodMultiPassCost.getAlreadyCost().add(x);
                                if (bmoney.doubleValue() > periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                                    BigDecimal d = periodMultiChargeRule.getPeriod_multi_max_money().subtract(periodMultiPassCost.getAlreadyCost());
                                    cost.setPeriod_multi_free(x.subtract(d));
                                } else {
                                    cost.setPeriod_multi_free(Cost.ZERO);
                                }
                            }
                        }
                    }
                } else {
                    cost.setPeriod_multi_free(Cost.ZERO);
                }
                if (len < period_multi_hours * 60) {
                    cost.setNext_period_multi_start(beginTime);
                    cost.setNext_period_multi_cur(cost.getShouldCharged().subtract(cost.getPeriod_multi_free()));
                } else if (len % (period_multi_hours * 60) == 0) {
                    cost.setNext_period_multi_start(endTime);
                    cost.setNext_period_multi_cur(Constants.MONEY_ZERO);
                } else {
                    BigDecimal m1 = Cost.ZERO;
                    cl.setTime(beginTime);
                    long endMills = endTime.getTime();
                    roc = chargePassRecord.clone();
                    HashMap<String, String> map = new HashMap<String, String>();
                    BigDecimal thisCost = cost.getShouldCharged().subtract(cost.getPeriod_multi_free());
                    while (cl.getTimeInMillis() <= endMills) {
                        Date beg = cl.getTime();
                        cl.add(11, period_multi_hours);
                        if (cl.getTimeInMillis() >= endMills) {
                            cost.setNext_period_multi_start(beg);
                            if (thisCost.doubleValue() <= 0.0) {
                                cost.setNext_period_multi_cur(Constants.MONEY_ZERO);
                                break;
                            }
                            BigDecimal d1 = thisCost.subtract(m1);
                            if (d1.doubleValue() <= 0.0) {
                                cost.setNext_period_multi_cur(Constants.MONEY_ZERO);
                                break;
                            }
                            cost.setNext_period_multi_cur(d1);
                            break;
                        }
                        if (!(thisCost.doubleValue() > 0.0)) continue;
                        roc.setEnterTime(beg);
                        roc.setExitTime(cl.getTime());
                        BigDecimal mx = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, roc, this.getSubPassRecordList(subChargePassRecordList, roc), plateNo, 0, context, chargeAlgorithm, haveFirst, haveFreeTime, map).getShouldCharged();
                        if (haveFirst) {
                            haveFirst = false;
                        }
                        if (haveFreeTime) {
                            haveFreeTime = false;
                        }
                        if (mx.doubleValue() > periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                            mx = periodMultiChargeRule.getPeriod_multi_max_money();
                        }
                        m1 = m1.add(mx);
                    }
                }
            }
            Cost cost2 = cost;
            if (resetSegmentRuleFreeTimeLenRule != null) {
                resetSegmentRuleFreeTimeLenRule.setFree_time_len(resetSegmentRuleFreeTimeLen);
            }
            return cost2;
        }
        catch (Throwable throwable) {
            if (resetSegmentRuleFreeTimeLenRule != null) {
                resetSegmentRuleFreeTimeLenRule.setFree_time_len(resetSegmentRuleFreeTimeLen);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Cost exitCharge0(int projectId, int carparkId, String passportTypeNo, String carTypeNo, Date expirDate, ChargePassRecord chargePassRecord, List<ChargePassRecord> subChargePassRecordList, String plateNo, List<Discount> discounts, ChargeContext context, ChargeAlgorithm chargeAlgorithm, boolean haveFirst, boolean haveFreeTime) {
        CarparkChargeRule rule;
        Cost returnCost = new Cost();
        returnCost.setShouldCharged(Cost.ZERO);
        returnCost.setChargeDetail(new LinkedHashMap<String, String>());
        List<Discount> discountMinList = this.getDiscountMinuteList(discounts);
        CarparkChargeRule periodMultiChargeRule = this.findPeriodMultiChargeRule(projectId, carparkId, passportTypeNo, carTypeNo, plateNo, expirDate, chargePassRecord, context);
        if (periodMultiChargeRule == null) {
            int totalFreeMins = 0;
            if (discountMinList != null && !discountMinList.isEmpty()) {
                for (Discount ax : discountMinList) {
                    totalFreeMins += ax.getDiscount_value();
                }
            }
            Cost cost = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, totalFreeMins, context, chargeAlgorithm, haveFirst, haveFreeTime, returnCost.getChargeDetail());
            returnCost.setShouldCharged(cost.getShouldCharged());
            BigDecimal disocuntMinMoney = cost.getDiscountMoney();
            returnCost.setDiscountMoney(disocuntMinMoney);
            if (disocuntMinMoney != null && disocuntMinMoney.doubleValue() > 0.0 && discountMinList != null && !discountMinList.isEmpty()) {
                int totalSize = discountMinList.size();
                if (totalSize == 1) {
                    discountMinList.get(0).setAmount(disocuntMinMoney);
                } else {
                    totalFreeMins = 0;
                    int index = 0;
                    for (Discount ax : discountMinList) {
                        if (index == totalSize - 1) {
                            ax.setAmount(disocuntMinMoney);
                        } else {
                            Cost cost2 = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, totalFreeMins += ax.getDiscount_value(), context, chargeAlgorithm, haveFirst, haveFreeTime, returnCost.getChargeDetail());
                            if (cost2.getDiscountMoney() != null && cost2.getDiscountMoney().doubleValue() > 0.0) {
                                ax.setAmount(cost2.getDiscountMoney());
                            }
                        }
                        ++index;
                    }
                    BigDecimal m1 = Cost.ZERO;
                    for (Discount discount : discountMinList) {
                        if (disocuntMinMoney.doubleValue() > 0.0) {
                            if (discount.getAmount() != null && discount.getAmount().doubleValue() > 0.0) {
                                BigDecimal m2 = discount.getAmount().subtract(m1);
                                if (m2.doubleValue() < 0.0) {
                                    m2 = Cost.ZERO;
                                }
                                if (m2.doubleValue() > disocuntMinMoney.doubleValue()) {
                                    m2 = disocuntMinMoney;
                                }
                                discount.setAmount(m2);
                                m1 = m1.add(m2);
                                disocuntMinMoney = disocuntMinMoney.subtract(m1);
                                continue;
                            }
                            discount.setAmount(Cost.ZERO);
                            continue;
                        }
                        discount.setAmount(Cost.ZERO);
                    }
                }
            }
        } else {
            Cost cost;
            BigDecimal disocuntMinMoney;
            BigDecimal freeTimeLenDiscountMoney = null;
            int totalFreeMins = 0;
            if (discountMinList != null && !discountMinList.isEmpty()) {
                for (Discount ax : discountMinList) {
                    totalFreeMins += ax.getDiscount_value();
                }
            }
            if (totalFreeMins > 0 && (disocuntMinMoney = (freeTimeLenDiscountMoney = (cost = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, totalFreeMins, context, chargeAlgorithm, haveFirst, haveFreeTime, returnCost.getChargeDetail())).getDiscountMoney())) != null && disocuntMinMoney.doubleValue() > 0.0 && discountMinList != null && !discountMinList.isEmpty()) {
                int totalSize = discountMinList.size();
                if (totalSize == 1) {
                    discountMinList.get(0).setAmount(disocuntMinMoney);
                } else {
                    totalFreeMins = 0;
                    int index = 0;
                    for (Discount ax : discountMinList) {
                        if (index == totalSize - 1) {
                            ax.setAmount(disocuntMinMoney);
                        } else {
                            Cost cost1 = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, totalFreeMins += ax.getDiscount_value(), context, chargeAlgorithm, haveFirst, haveFreeTime, returnCost.getChargeDetail());
                            if (cost1.getDiscountMoney() != null && cost1.getDiscountMoney().doubleValue() > 0.0) {
                                ax.setAmount(cost1.getDiscountMoney());
                            }
                        }
                        ++index;
                    }
                    BigDecimal m1 = Cost.ZERO;
                    for (Discount ax : discountMinList) {
                        if (disocuntMinMoney.doubleValue() > 0.0) {
                            if (ax.getAmount() != null && ax.getAmount().doubleValue() > 0.0) {
                                void var24_53;
                                void var24_51;
                                BigDecimal bigDecimal = ax.getAmount().subtract(m1);
                                if (bigDecimal.doubleValue() < 0.0) {
                                    BigDecimal bigDecimal2 = Cost.ZERO;
                                }
                                if (var24_51.doubleValue() > disocuntMinMoney.doubleValue()) {
                                    BigDecimal bigDecimal3 = disocuntMinMoney;
                                }
                                ax.setAmount((BigDecimal)var24_53);
                                m1 = m1.add((BigDecimal)var24_53);
                                disocuntMinMoney = disocuntMinMoney.subtract(m1);
                                continue;
                            }
                            ax.setAmount(Cost.ZERO);
                            continue;
                        }
                        ax.setAmount(Cost.ZERO);
                    }
                }
            }
            boolean zeroClock = periodMultiChargeRule.getPeriod_multi_begin_time() != null && periodMultiChargeRule.getPeriod_multi_begin_time() == 1;
            Date beginTime = chargePassRecord.getEnterTime();
            Date endTime = chargePassRecord.getExitTime();
            Calendar cl = Calendar.getInstance();
            if (!zeroClock) {
                int period_multi_hours = periodMultiChargeRule.getPeriod_multi_hours();
                List<PeriodMultiPassCost> list = context.getPeriodMultiPassCostList(projectId, carparkId, plateNo, beginTime, period_multi_hours * 60, periodMultiChargeRule.getPeriod_multi_max_money(), chargePassRecord.getAreaNo());
                String enjoyedFreeTimeKey = "enjoyedFreeTime" + plateNo + beginTime.getTime();
                KeyValueEntry enjoyedFreeTimeKV = (KeyValueEntry)context.getContext().remove(enjoyedFreeTimeKey);
                Cost cost2 = null;
                if (list != null && !list.isEmpty()) {
                    if (list.size() == 1) {
                        cost2 = this.exitMultiChargeByEnterTime(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, discounts, context, chargeAlgorithm, haveFirst, haveFreeTime, periodMultiChargeRule, list.get(0), beginTime, endTime, period_multi_hours, (KeyValueEntry<Integer, Integer>)enjoyedFreeTimeKV);
                    } else {
                        for (PeriodMultiPassCost c : list) {
                            Cost cost1 = this.exitMultiChargeByEnterTime(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, discounts, context, chargeAlgorithm, haveFirst, haveFreeTime, periodMultiChargeRule, c, beginTime, endTime, period_multi_hours, (KeyValueEntry<Integer, Integer>)enjoyedFreeTimeKV);
                            if (cost2 == null) {
                                cost2 = cost1;
                            } else if (cost2.getActualCharge().doubleValue() > cost1.getActualCharge().doubleValue()) {
                                cost2 = cost1;
                            }
                            if (cost2.getShouldCharged().doubleValue() != 0.0 && cost2.getActualCharge().doubleValue() != 0.0) {
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    cost2 = this.exitMultiChargeByEnterTime(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, discounts, context, chargeAlgorithm, haveFirst, haveFreeTime, periodMultiChargeRule, null, beginTime, endTime, period_multi_hours, (KeyValueEntry<Integer, Integer>)enjoyedFreeTimeKV);
                }
                if (cost2.getChargeDetail() != null && !cost2.getChargeDetail().isEmpty()) {
                    returnCost.getChargeDetail().putAll(cost2.getChargeDetail());
                }
                cost2.setChargeDetail(returnCost.getChargeDetail());
                cost2.setDiscountMoney(freeTimeLenDiscountMoney);
                returnCost = cost2;
            } else {
                KeyValueEntry enjoyedFreeTimeKv;
                Cost cost3 = new Cost();
                cost3.setShouldCharged(Cost.ZERO);
                cl.setTime(beginTime);
                cl.set(11, 0);
                cl.set(12, 0);
                cl.set(13, 0);
                cl.set(14, 0);
                Date date = cl.getTime();
                PeriodMultiPassCost periodMultiPassCost = context.getPeriodMultiPassCost(projectId, carparkId, plateNo, date, beginTime);
                if (periodMultiPassCost == null) {
                    periodMultiPassCost = new PeriodMultiPassCost();
                }
                if ((enjoyedFreeTimeKv = (KeyValueEntry)context.getContext().get("enjoyedFreeTime_" + plateNo + date.getTime() + "-" + beginTime.getTime())) == null) {
                    enjoyedFreeTimeKv = new KeyValueEntry((Object)0, (Object)0);
                }
                if (periodMultiPassCost.getPeriodStartDate() == null || periodMultiPassCost.getPeriodStartDate().getTime() != cl.getTimeInMillis()) {
                    periodMultiPassCost.setPeriodStartDate(cl.getTime());
                    periodMultiPassCost.setAlreadyCost(Cost.ZERO);
                }
                if (periodMultiPassCost.getAlreadyCost() == null || periodMultiPassCost.getAlreadyCost().doubleValue() < 0.0) {
                    periodMultiPassCost.setAlreadyCost(Cost.ZERO);
                }
                cost3.setPeriod_multi_start(periodMultiPassCost.getPeriodStartDate());
                cost3.setPeriod_multi_received(periodMultiPassCost.getAlreadyCost());
                boolean hasCharged = false;
                if (haveFreeTime && periodMultiChargeRule.getPeriod_multi_free_time() != null) {
                    CarparkChargeSegmentRule r;
                    if (1 == periodMultiChargeRule.getPeriod_multi_free_time()) {
                        if ((Integer)enjoyedFreeTimeKv.getKey() > 0) {
                            haveFreeTime = false;
                        }
                    } else if (2 == periodMultiChargeRule.getPeriod_multi_free_time() && (r = this.getSegmentRule(periodMultiChargeRule, chargePassRecord.getEnterTime(), context)) != null && r.getFree_time_len() != null && r.getFree_time_len() > 0) {
                        int firstFreeLen = r.getFree_time_len();
                        if ((firstFreeLen -= ((Integer)enjoyedFreeTimeKv.getValue()).intValue()) <= 0) {
                            haveFreeTime = false;
                        } else {
                            int rst = r.getFree_time_len();
                            r.setFree_time_len(firstFreeLen);
                            try {
                                Cost cost6 = this.chargeByZero(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, 0, context, chargeAlgorithm, haveFirst, haveFreeTime, returnCost.getChargeDetail(), periodMultiPassCost, periodMultiChargeRule);
                                hasCharged = true;
                                cost3.setShouldCharged(cost6.getShouldCharged());
                                cost3.setPeriod_multi_free(cost6.getPeriod_multi_free());
                                cost3.setNext_period_multi_cur(cost6.getNext_period_multi_cur());
                                cost3.setNext_period_multi_start(cost6.getNext_period_multi_start());
                            }
                            finally {
                                r.setFree_time_len(rst);
                            }
                        }
                    }
                }
                if (!hasCharged) {
                    Cost cost6 = this.chargeByZero(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, 0, context, chargeAlgorithm, haveFirst, haveFreeTime, returnCost.getChargeDetail(), periodMultiPassCost, periodMultiChargeRule);
                    cost3.setShouldCharged(cost6.getShouldCharged());
                    cost3.setPeriod_multi_free(cost6.getPeriod_multi_free());
                    cost3.setNext_period_multi_cur(cost6.getNext_period_multi_cur());
                    cost3.setNext_period_multi_start(cost6.getNext_period_multi_start());
                }
                cost3.setChargeDetail(returnCost.getChargeDetail());
                cost3.setDiscountMoney(freeTimeLenDiscountMoney);
                returnCost = cost3;
            }
        }
        BigDecimal actualCharge = returnCost.getActualCharge();
        if (discounts != null && !discounts.isEmpty() && actualCharge.doubleValue() > 0.0) {
            if (actualCharge.doubleValue() > 0.0) {
                for (Discount d : discounts) {
                    if (d.getDiscount_method() != 0 || d.getDiscount_value() <= 0) continue;
                    BigDecimal dmoney = new BigDecimal((double)d.getDiscount_value() / 100.0).setScale(2, 4);
                    if (dmoney.doubleValue() > actualCharge.doubleValue()) {
                        dmoney = actualCharge;
                    }
                    if (returnCost.getDiscountMoney() == null) {
                        returnCost.setDiscountMoney(dmoney);
                    } else {
                        returnCost.setDiscountMoney(dmoney.add(returnCost.getDiscountMoney()));
                    }
                    d.setAmount(dmoney);
                    actualCharge = returnCost.getActualCharge();
                    if (actualCharge.doubleValue() <= 0.0) break;
                }
            }
            if (actualCharge.doubleValue() > 0.0) {
                for (Discount d : discounts) {
                    if (d.getDiscount_method() != 2 || d.getDiscount_value() <= 0 || !(actualCharge.doubleValue() > 0.0)) continue;
                    int dx = d.getDiscount_value();
                    if (dx < 0) {
                        dx = 0;
                    } else if (dx > 100) {
                        dx = 100;
                    }
                    if (dx >= 100) {
                        if (returnCost.getDiscountMoney() == null) {
                            returnCost.setDiscountMoney(actualCharge);
                        } else {
                            returnCost.setDiscountMoney(actualCharge.add(returnCost.getDiscountMoney()));
                        }
                        d.setAmount(actualCharge);
                        actualCharge = returnCost.getActualCharge();
                        break;
                    }
                    BigDecimal m = actualCharge.multiply(new BigDecimal((double)dx / 100.0)).setScale(2, 4);
                    if (returnCost.getDiscountMoney() == null) {
                        returnCost.setDiscountMoney(m);
                    } else {
                        returnCost.setDiscountMoney(m.add(returnCost.getDiscountMoney()));
                    }
                    d.setAmount(m);
                    actualCharge = returnCost.getActualCharge();
                }
            }
        }
        int chargeTimeMinus = (int)TimeUnit.MILLISECONDS.toMinutes(chargePassRecord.getExitTime().getTime() - chargePassRecord.getEnterTime().getTime());
        Date chageStartTime = chargePassRecord.getEnterTime();
        if (expirDate != null && chargePassRecord != null && expirDate.getTime() > chargePassRecord.getEnterTime().getTime() && expirDate.getTime() < chargePassRecord.getExitTime().getTime() && (rule = context.findChargeRule(projectId, carparkId, passportTypeNo, carTypeNo, chargePassRecord.getAreaNo())) == null) {
            chageStartTime = expirDate;
            chargeTimeMinus = (int)TimeUnit.MILLISECONDS.toMinutes(chargePassRecord.getExitTime().getTime() - chageStartTime.getTime());
        }
        returnCost.setCharge_start_time(chageStartTime);
        returnCost.setChargeTimeMinutes(chargeTimeMinus);
        return returnCost;
    }

    protected Cost chargeByZero(int projectId, int carparkId, String passportTypeNo, String carTypeNo, Date expirDate, ChargePassRecord chargePassRecord, List<ChargePassRecord> subChargePassRecordList, String plateNo, int freeTimeLen, ChargeContext context, ChargeAlgorithm chargeAlgorithm, boolean haveFirst, boolean haveFreeTime, Map<String, String> chargeDes, PeriodMultiPassCost periodMultiPassCost, CarparkChargeRule periodMultiChargeRule) {
        Date beginTime = chargePassRecord.getEnterTime();
        Date endTime = chargePassRecord.getExitTime();
        Calendar cl = Calendar.getInstance();
        Cost cost = new Cost();
        cost.setShouldCharged(Cost.ZERO);
        cl.setTime(beginTime);
        cl.set(11, 0);
        cl.set(12, 0);
        cl.set(13, 0);
        cl.set(14, 0);
        if (periodMultiPassCost == null) {
            periodMultiPassCost = new PeriodMultiPassCost();
        }
        if (periodMultiPassCost.getPeriodStartDate() == null || periodMultiPassCost.getPeriodStartDate().getTime() != cl.getTimeInMillis()) {
            periodMultiPassCost.setPeriodStartDate(cl.getTime());
            periodMultiPassCost.setAlreadyCost(Cost.ZERO);
        }
        if (periodMultiPassCost.getAlreadyCost() == null || periodMultiPassCost.getAlreadyCost().doubleValue() < 0.0) {
            periodMultiPassCost.setAlreadyCost(Cost.ZERO);
        }
        cost.setPeriod_multi_start(periodMultiPassCost.getPeriodStartDate());
        cost.setPeriod_multi_received(periodMultiPassCost.getAlreadyCost());
        cl.setTime(periodMultiPassCost.getPeriodStartDate());
        int period_multi_hours = 24;
        cl.add(11, period_multi_hours);
        Date nextD = cl.getTime();
        if (nextD.getTime() >= endTime.getTime()) {
            BigDecimal demail;
            if (haveFirst && periodMultiChargeRule.getPeriod_multi_first_segment() != null && 1 == periodMultiChargeRule.getPeriod_multi_first_segment() && periodMultiPassCost.getAlreadyCost().doubleValue() > 0.0) {
                haveFirst = false;
            }
            if ((demail = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, 0, context, chargeAlgorithm, haveFirst, haveFreeTime, chargeDes).getShouldCharged()).doubleValue() < 0.0) {
                demail = Cost.ZERO;
            }
            cost.setShouldCharged(demail);
            cost.setNext_period_multi_start(periodMultiPassCost.getPeriodStartDate());
            if (periodMultiPassCost.getAlreadyCost().doubleValue() >= periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                cost.setPeriod_multi_free(demail);
                cost.setNext_period_multi_cur(Cost.ZERO);
            } else {
                BigDecimal bmoney = periodMultiPassCost.getAlreadyCost().add(demail);
                if (bmoney.doubleValue() > periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                    cost.setNext_period_multi_cur(periodMultiChargeRule.getPeriod_multi_max_money().subtract(periodMultiPassCost.getAlreadyCost()));
                    cost.setPeriod_multi_free(demail.subtract(cost.getNext_period_multi_cur()));
                } else {
                    cost.setPeriod_multi_free(Cost.ZERO);
                    cost.setNext_period_multi_cur(demail);
                }
            }
        } else {
            BigDecimal demail = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNo, 0, context, chargeAlgorithm, haveFirst, haveFreeTime, chargeDes).getShouldCharged();
            if (demail.doubleValue() < 0.0) {
                demail = Cost.ZERO;
            }
            cost.setShouldCharged(demail);
            cl.setTime(endTime);
            cl.set(11, 0);
            cl.set(12, 0);
            cl.set(13, 0);
            cl.set(14, 0);
            cost.setNext_period_multi_start(cl.getTime());
            int firstTimeLen = this.getFirstMinuts(periodMultiChargeRule, beginTime, context);
            int hv1 = (int)TimeUnit.MILLISECONDS.toMinutes(endTime.getTime() - beginTime.getTime());
            if (firstTimeLen > 0 && hv1 <= firstTimeLen) {
                cost.setNext_period_multi_cur(demail);
                cost.setPeriod_multi_free(Cost.ZERO);
            } else {
                boolean f2;
                boolean f1;
                cl.setTime(beginTime);
                cl.set(11, 0);
                cl.set(12, 0);
                cl.set(13, 0);
                cl.set(14, 0);
                cl.add(5, 1);
                if (haveFirst) {
                    int l1 = (int)TimeUnit.MILLISECONDS.toMinutes(cl.getTimeInMillis() - beginTime.getTime());
                    if (l1 >= firstTimeLen) {
                        f1 = true;
                        f2 = false;
                    } else {
                        f1 = false;
                        f2 = true;
                    }
                } else {
                    f1 = false;
                    f2 = false;
                }
                ChargePassRecord roc = chargePassRecord.clone();
                roc.setEnterTime(beginTime);
                roc.setExitTime(cl.getTime());
                BigDecimal m0 = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, roc, this.getSubPassRecordList(subChargePassRecordList, roc), plateNo, 0, context, chargeAlgorithm, f1, haveFreeTime, chargeDes).getShouldCharged();
                BigDecimal m1 = Cost.ZERO;
                BigDecimal m2 = Cost.ZERO;
                long endMills = endTime.getTime();
                while (cl.getTimeInMillis() <= endMills) {
                    BigDecimal mx;
                    Date beg = cl.getTime();
                    cl.add(11, period_multi_hours);
                    if (cl.getTimeInMillis() >= endMills) {
                        roc.setEnterTime(beg);
                        roc.setExitTime(endTime);
                        mx = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, roc, this.getSubPassRecordList(subChargePassRecordList, roc), plateNo, 0, context, chargeAlgorithm, f2, false, chargeDes).getShouldCharged();
                        if (f2) {
                            f2 = false;
                        }
                        if (mx.doubleValue() > periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                            mx = periodMultiChargeRule.getPeriod_multi_max_money();
                        }
                        m2 = mx;
                        break;
                    }
                    roc.setEnterTime(beg);
                    roc.setExitTime(cl.getTime());
                    mx = this.exitCharge1(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, roc, this.getSubPassRecordList(subChargePassRecordList, roc), plateNo, 0, context, chargeAlgorithm, f2, false, chargeDes).getShouldCharged();
                    if (f2) {
                        f2 = false;
                    }
                    if (mx.doubleValue() > periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                        mx = periodMultiChargeRule.getPeriod_multi_max_money();
                    }
                    m1 = m1.add(mx);
                }
                BigDecimal mm = m0.add(m1).add(m2);
                if (mm.doubleValue() <= demail.doubleValue()) {
                    demail = mm;
                    cost.setShouldCharged(demail);
                    cost.setNext_period_multi_cur(m2);
                    if (periodMultiPassCost.getAlreadyCost().doubleValue() >= periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                        cost.setPeriod_multi_free(m0);
                    } else {
                        BigDecimal bmoney = periodMultiPassCost.getAlreadyCost().add(m0);
                        if (bmoney.doubleValue() > periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                            BigDecimal d = periodMultiChargeRule.getPeriod_multi_max_money().subtract(periodMultiPassCost.getAlreadyCost());
                            cost.setPeriod_multi_free(m0.subtract(d));
                        } else {
                            cost.setPeriod_multi_free(Cost.ZERO);
                        }
                    }
                } else if (m2.doubleValue() >= demail.doubleValue()) {
                    cost.setNext_period_multi_cur(demail);
                    cost.setPeriod_multi_free(Cost.ZERO);
                } else {
                    cost.setNext_period_multi_cur(m2);
                    BigDecimal x = demail.subtract(m2).subtract(m1);
                    if (x.doubleValue() <= 0.0) {
                        cost.setPeriod_multi_free(Cost.ZERO);
                    } else if (periodMultiPassCost.getAlreadyCost().doubleValue() >= periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                        cost.setPeriod_multi_free(x);
                    } else {
                        BigDecimal bmoney = periodMultiPassCost.getAlreadyCost().add(x);
                        if (bmoney.doubleValue() > periodMultiChargeRule.getPeriod_multi_max_money().doubleValue()) {
                            BigDecimal d = periodMultiChargeRule.getPeriod_multi_max_money().subtract(periodMultiPassCost.getAlreadyCost());
                            cost.setPeriod_multi_free(x.subtract(d));
                        } else {
                            cost.setPeriod_multi_free(Cost.ZERO);
                        }
                    }
                }
            }
        }
        cost.setChargeDetail(chargeDes);
        return cost;
    }

    protected Cost exitCharge1(int projectId, int carparkId, String passportTypeNo, String carTypeNo, Date expirDate, ChargePassRecord chargePassRecord, List<ChargePassRecord> subChargePassRecordList, String plateNo, int freeTimeLen, ChargeContext context, ChargeAlgorithm chargeAlgorithm, boolean haveFirst, boolean haveFreeTime, Map<String, String> chargeDes) {
        ChargePassRecord r1;
        Date exitT;
        Date enterT;
        Cost cost = new Cost();
        cost.setShouldCharged(Cost.ZERO);
        cost.setDiscountMoney(Cost.ZERO);
        cost.setChargeDetail(new LinkedHashMap<String, String>());
        if (chargePassRecord == null || chargePassRecord.getEnterTime() == null || chargePassRecord.getExitTime() == null) {
            return cost;
        }
        if (chargePassRecord.getEnterTime().getTime() >= chargePassRecord.getExitTime().getTime()) {
            return cost;
        }
        Calendar cl = Calendar.getInstance();
        LinkedList<ChargePassRecord> notExpireList = new LinkedList<ChargePassRecord>();
        LinkedList<ChargePassRecord> expirepassList = null;
        String expirePassportTypeNo = passportTypeNo;
        if (expirDate != null) {
            expirePassportTypeNo = context.getExpiredChargePassportTypeNo(projectId, carparkId, passportTypeNo);
            if (expirePassportTypeNo == null || expirePassportTypeNo.length() == 0) {
                expirePassportTypeNo = passportTypeNo;
            }
            if (!expirePassportTypeNo.equals(passportTypeNo)) {
                if (expirDate.getTime() > chargePassRecord.getEnterTime().getTime() && expirDate.getTime() < chargePassRecord.getExitTime().getTime()) {
                    expirepassList = new LinkedList();
                    ChargePassRecord left = chargePassRecord.clone();
                    left.setExitTime(expirDate);
                    cl.setTime(expirDate);
                    cl.add(13, 1);
                    Object right = chargePassRecord.clone();
                    Date exip1 = cl.getTime();
                    ((ChargePassRecord)right).setEnterTime(exip1);
                    expirepassList.add((ChargePassRecord)right);
                    notExpireList.add(left);
                    if (subChargePassRecordList != null && !subChargePassRecordList.isEmpty()) {
                        for (ChargePassRecord r : subChargePassRecordList) {
                            Date enterT2 = r.getEnterTime();
                            if (enterT2 == null) continue;
                            Date exitT2 = r.getExitTime();
                            if (exitT2 == null) {
                                exitT2 = chargePassRecord.getExitTime();
                            }
                            if (enterT2.getTime() >= exitT2.getTime() || enterT2.getTime() < chargePassRecord.getEnterTime().getTime() || exitT2.getTime() > chargePassRecord.getExitTime().getTime()) continue;
                            if (expirDate.getTime() > enterT2.getTime() && expirDate.getTime() < exitT2.getTime()) {
                                left = r.clone();
                                left.setExitTime(expirDate);
                                right = r.clone();
                                ((ChargePassRecord)right).setEnterTime(exip1);
                                if (((ChargePassRecord)right).getExitTime() == null) {
                                    ((ChargePassRecord)right).setExitTime(exitT2);
                                }
                                expirepassList.add((ChargePassRecord)right);
                                notExpireList.add(left);
                                continue;
                            }
                            if (expirDate.getTime() <= enterT2.getTime()) {
                                expirepassList.add(r.clone());
                                continue;
                            }
                            if (expirDate.getTime() < exitT2.getTime()) continue;
                            notExpireList.add(r.clone());
                        }
                    }
                } else if (expirDate.getTime() <= chargePassRecord.getEnterTime().getTime()) {
                    expirepassList = notExpireList;
                    notExpireList = null;
                    expirepassList.add(chargePassRecord.clone());
                    if (subChargePassRecordList != null && !subChargePassRecordList.isEmpty()) {
                        for (ChargePassRecord r : subChargePassRecordList) {
                            enterT = r.getEnterTime();
                            if (enterT == null) continue;
                            exitT = r.getExitTime();
                            if (exitT == null) {
                                exitT = chargePassRecord.getExitTime();
                            }
                            if (enterT.getTime() >= exitT.getTime() || enterT.getTime() < chargePassRecord.getEnterTime().getTime() || exitT.getTime() > chargePassRecord.getExitTime().getTime()) continue;
                            r1 = r.clone();
                            r1.setExitTime(exitT);
                            expirepassList.add(r1);
                        }
                    }
                } else if (expirDate.getTime() >= chargePassRecord.getExitTime().getTime()) {
                    notExpireList.add(chargePassRecord.clone());
                    if (subChargePassRecordList != null && !subChargePassRecordList.isEmpty()) {
                        for (ChargePassRecord r : subChargePassRecordList) {
                            enterT = r.getEnterTime();
                            if (enterT == null) continue;
                            exitT = r.getExitTime();
                            if (exitT == null) {
                                exitT = chargePassRecord.getExitTime();
                            }
                            if (enterT.getTime() >= exitT.getTime() || enterT.getTime() < chargePassRecord.getEnterTime().getTime() || exitT.getTime() > chargePassRecord.getExitTime().getTime()) continue;
                            r1 = r.clone();
                            r1.setExitTime(exitT);
                            notExpireList.add(r1);
                        }
                    }
                }
            } else {
                notExpireList.add(chargePassRecord.clone());
                if (subChargePassRecordList != null && !subChargePassRecordList.isEmpty()) {
                    for (ChargePassRecord r : subChargePassRecordList) {
                        enterT = r.getEnterTime();
                        if (enterT == null) continue;
                        exitT = r.getExitTime();
                        if (exitT == null) {
                            exitT = chargePassRecord.getExitTime();
                        }
                        if (enterT.getTime() >= exitT.getTime() || enterT.getTime() < chargePassRecord.getEnterTime().getTime() || exitT.getTime() > chargePassRecord.getExitTime().getTime()) continue;
                        r1 = r.clone();
                        r1.setExitTime(exitT);
                        notExpireList.add(r1);
                    }
                }
            }
        } else {
            notExpireList.add(chargePassRecord.clone());
            if (subChargePassRecordList != null && !subChargePassRecordList.isEmpty()) {
                for (ChargePassRecord r : subChargePassRecordList) {
                    enterT = r.getEnterTime();
                    if (enterT == null) continue;
                    exitT = r.getExitTime();
                    if (exitT == null) {
                        exitT = chargePassRecord.getExitTime();
                    }
                    if (enterT.getTime() >= exitT.getTime() || enterT.getTime() < chargePassRecord.getEnterTime().getTime() || exitT.getTime() > chargePassRecord.getExitTime().getTime()) continue;
                    r1 = r.clone();
                    r1.setExitTime(exitT);
                    notExpireList.add(r1);
                }
            }
        }
        int dicountTimeLen = freeTimeLen;
        int i = 0;
        while (i < 2) {
            String chargePassPortType;
            LinkedList<ChargePassRecord> chargeRecordList;
            if (i == 0) {
                chargeRecordList = notExpireList;
                chargePassPortType = passportTypeNo;
            } else {
                if (i != 1) break;
                chargeRecordList = expirepassList;
                chargePassPortType = expirePassportTypeNo;
            }
            if (chargeRecordList != null && !chargeRecordList.isEmpty()) {
                ChargePassRecord root = (ChargePassRecord)chargeRecordList.get(0);
                AbstractList cllist = chargeRecordList;
                if (chargeRecordList.size() > 1) {
                    if (chargeRecordList.size() > 2) {
                        HashMap<String, ChargePassRecord> areaPassMap = new HashMap<String, ChargePassRecord>();
                        for (ChargePassRecord r : chargeRecordList) {
                            if (r == root || r.getAreaNo().equals(root.getAreaNo()) || r.getAreaLevel() <= root.getAreaLevel()) continue;
                            ChargePassRecord r12 = (ChargePassRecord)areaPassMap.get(r.getAreaNo());
                            if (r12 == null) {
                                areaPassMap.put(r.getAreaNo(), r);
                                continue;
                            }
                            cl.setTime(r12.getExitTime());
                            cl.add(12, (int)TimeUnit.MILLISECONDS.toMinutes(r.getExitTime().getTime() - r.getEnterTime().getTime()));
                            r12.setExitTime(cl.getTime());
                            ChargePassRecord pr = this.findParentRecord(r.getParentAreaNo(), chargeRecordList);
                            Date xt = pr != null ? pr.getExitTime() : root.getExitTime();
                            if (r12.getExitTime().getTime() <= xt.getTime()) continue;
                            r12.setExitTime(xt);
                        }
                        areaPassMap.put(root.getAreaNo(), root);
                        cllist = new ArrayList(areaPassMap.size());
                        cllist.addAll(areaPassMap.values());
                    }
                    Collections.sort(cllist, new Comparator<ChargePassRecord>(){

                        @Override
                        public int compare(ChargePassRecord o1, ChargePassRecord o2) {
                            int oss = Integer.valueOf(o1.getAreaLevel()).compareTo(o2.getAreaLevel());
                            oss = oss == 0 ? o1.getEnterTime().compareTo(o2.getEnterTime()) : 0 - oss;
                            return oss;
                        }
                    });
                }
                int[] dicountTimeLenx = new int[]{dicountTimeLen};
                Cost c1 = this.chargev(projectId, carparkId, chargePassPortType, carTypeNo, cllist, context, chargeAlgorithm, haveFirst, haveFreeTime, chargeDes, root, dicountTimeLenx);
                dicountTimeLen = dicountTimeLenx[0];
                cost.setShouldCharged(cost.getShouldCharged().add(c1.getShouldCharged()));
                if (c1.getDiscountMoney() != null && c1.getDiscountMoney().doubleValue() > 0.0) {
                    cost.setDiscountMoney(cost.getDiscountMoney().add(c1.getDiscountMoney()));
                }
            }
            ++i;
        }
        cost.getActualCharge();
        return cost;
    }

    private ChargeAlgorithm.ChageParam createChargeAlgorithm(ChargeContext context) {
        ChargeAlgorithm.ChageParam param = new ChargeAlgorithm.ChageParam();
        param.lessTanAUnit = context.getLessLanAUnitChangeStrategy();
        return param;
    }

    /*
     * WARNING - void declaration
     */
    protected Cost chargev(int projectId, int carparkId, String chargePassPortType, String carTypeNo, List<ChargePassRecord> cllist, ChargeContext context, ChargeAlgorithm chargeAlgorithm, boolean haveFirst, boolean haveFreeTime, Map<String, String> chargeDes, ChargePassRecord root, int[] dicountTimeLenx) {
        Cost cost = new Cost();
        cost.setShouldCharged(Cost.ZERO);
        cost.setDiscountMoney(Cost.ZERO);
        cost.setChargeDetail(chargeDes);
        HashMap<String, Integer> parentFeeLenth = new HashMap<String, Integer>();
        Calendar cl = Calendar.getInstance();
        int dicountTimeLen = 0;
        if (dicountTimeLenx != null && dicountTimeLenx.length > 0) {
            dicountTimeLen = dicountTimeLenx[0];
        }
        int crossStrategy = this.getSegementCrossStrategy(context);
        int firtAndLastWhenSameRuleStrategy = this.getSegementTimeLenStrategy(context);
        int hoidayBeginMins = context.getHoidayBeginMins(chargePassPortType);
        int hoidayEndMins = context.getHoidayEndMins(chargePassPortType);
        for (ChargePassRecord r : cllist) {
            boolean add;
            BigDecimal shouldCharged;
            int l;
            CarparkChargeRule rule = context.findChargeRule(projectId, carparkId, chargePassPortType, carTypeNo, r.getAreaNo());
            if (rule == null) continue;
            Date bgTime = r.getEnterTime();
            Date egTime = r.getExitTime();
            Integer o = (Integer)parentFeeLenth.get(r.getAreaNo());
            if (o != null && o > 0) {
                cl.setTime(egTime);
                cl.add(12, 0 - o);
                egTime = cl.getTimeInMillis() < bgTime.getTime() ? bgTime : cl.getTime();
            }
            if ((l = (int)TimeUnit.MILLISECONDS.toMinutes(egTime.getTime() - bgTime.getTime())) > 0) {
                boolean haveFree = haveFreeTime;
                if (!haveFree && cost.getShouldCharged().doubleValue() > 0.0) {
                    haveFree = true;
                }
                shouldCharged = chargeAlgorithm.charge(rule, bgTime, egTime, chargeDes, context, haveFirst, haveFree, crossStrategy, hoidayBeginMins, hoidayEndMins, firtAndLastWhenSameRuleStrategy, this.createChargeAlgorithm(context));
            } else {
                shouldCharged = Cost.ZERO;
            }
            cost.setShouldCharged(cost.getShouldCharged().add(shouldCharged));
            if (l > 0 && !r.getAreaNo().equals(root.getAreaNo()) && r.getParentAreaNo() != null && r.getParentAreaNo().length() > 0 && r.getAreaLevel() > root.getAreaLevel() && (add = true)) {
                Collection<Object> pareAreaList = null;
                if (r.getParentAreaNo().equals(root.getAreaNo())) {
                    pareAreaList = new ArrayList<String>(1);
                    pareAreaList.add(root.getAreaNo());
                } else {
                    pareAreaList = this.getParentAreaList(cllist, r.getParentAreaNo(), root.getAreaNo());
                }
                if (pareAreaList != null && !pareAreaList.isEmpty()) {
                    for (String string : pareAreaList) {
                        Integer ll = (Integer)parentFeeLenth.get(string);
                        if (ll == null) {
                            parentFeeLenth.put(string, l);
                            continue;
                        }
                        parentFeeLenth.put(string, l + ll);
                    }
                }
            }
            BigDecimal discountMoney = Cost.ZERO;
            if (dicountTimeLen > 0 && shouldCharged.doubleValue() > 0.0) {
                if (l <= dicountTimeLen) {
                    discountMoney = shouldCharged;
                    dicountTimeLen -= l;
                } else {
                    if (context.getFreeTimeLenDiscountChargeStrategy() == 1) {
                        cl.setTime(r.getEnterTime());
                        cl.add(12, dicountTimeLen);
                        BigDecimal discountM = chargeAlgorithm.charge(rule, r.getEnterTime(), cl.getTime(), chargeDes, context, haveFirst, haveFreeTime, crossStrategy, hoidayBeginMins, hoidayEndMins, firtAndLastWhenSameRuleStrategy, this.createChargeAlgorithm(context));
                        if (discountM.doubleValue() > shouldCharged.doubleValue()) {
                            discountM = shouldCharged;
                        }
                        discountMoney = discountM;
                    } else {
                        void var31_36;
                        boolean haveFree = context.freeTimeLenDiscountHasFreeTime() ? haveFreeTime : false;
                        if (context.freeTimeLenDiscountHasFistTime()) {
                            boolean bl = haveFirst;
                        } else {
                            boolean bl = false;
                        }
                        cl.setTime(r.getEnterTime());
                        cl.add(12, dicountTimeLen);
                        BigDecimal shouldCharged2 = chargeAlgorithm.charge(rule, cl.getTime(), egTime, chargeDes, context, (boolean)var31_36, haveFree, crossStrategy, hoidayBeginMins, hoidayEndMins, firtAndLastWhenSameRuleStrategy, this.createChargeAlgorithm(context));
                        BigDecimal d = shouldCharged.subtract(shouldCharged2);
                        if (d.doubleValue() > 0.0) {
                            discountMoney = d;
                        }
                    }
                    dicountTimeLen = 0;
                }
            }
            cost.setDiscountMoney(cost.getDiscountMoney().add(discountMoney));
        }
        if (dicountTimeLenx != null && dicountTimeLenx.length > 0) {
            dicountTimeLenx[0] = dicountTimeLen;
        }
        return cost;
    }

    protected KeyValueEntry<Discount, Date> getFreeDateKv(List<Discount> discounts, ChargeContext context) {
        Calendar cl = null;
        long xd = 0L;
        Date dv = null;
        Discount dis1 = null;
        Date dv2 = null;
        Discount dis2 = null;
        if (discounts != null && !discounts.isEmpty()) {
            for (Discount d : discounts) {
                if (d.getDiscount_method() != 3 || d.getDiscount_value() <= 0) continue;
                if (cl == null || xd == 0L) {
                    cl = Calendar.getInstance();
                    cl.set(2018, 0, 1, 0, 0, 0);
                    cl.set(14, 0);
                    xd = cl.getTimeInMillis();
                } else {
                    cl.setTimeInMillis(xd);
                }
                cl.add(12, d.getDiscount_value());
                if (dv == null) {
                    dv = cl.getTime();
                    dis1 = d;
                } else if (dv.getTime() < cl.getTimeInMillis()) {
                    dv = cl.getTime();
                    dis1 = d;
                }
                if (dv2 == null || dis2 == null) {
                    dv2 = cl.getTime();
                    dis2 = d;
                    continue;
                }
                if (dis2.getDiscountTime() == null || d.getDiscountTime() == null) {
                    dv2 = cl.getTime();
                    dis2 = d;
                    continue;
                }
                if (d.getDiscountTime().getTime() < dis2.getDiscountTime().getTime()) continue;
                dv2 = cl.getTime();
                dis2 = d;
            }
        }
        if (dv == null || dv2 == null) {
            return null;
        }
        boolean str = "1".equals(context.getFreeTimeDiscountStrategy());
        if (str) {
            return new KeyValueEntry(dis2, dv2);
        }
        return new KeyValueEntry(dis1, dv);
    }

    @Deprecated
    protected Date getFreeDate(List<Discount> discounts, ChargeContext context) {
        Calendar cl = null;
        long xd = 0L;
        Date dv = null;
        Date dv2 = null;
        Discount dis2 = null;
        if (discounts != null && !discounts.isEmpty()) {
            for (Discount d : discounts) {
                if (d.getDiscount_method() != 3 || d.getDiscount_value() <= 0) continue;
                if (cl == null || xd == 0L) {
                    cl = Calendar.getInstance();
                    cl.set(2018, 0, 1, 0, 0, 0);
                    cl.set(14, 0);
                    xd = cl.getTimeInMillis();
                } else {
                    cl.setTimeInMillis(xd);
                }
                cl.add(12, d.getDiscount_value());
                if (dv == null) {
                    dv = cl.getTime();
                } else if (dv.getTime() < cl.getTimeInMillis()) {
                    dv = cl.getTime();
                }
                if (dv2 == null || dis2 == null) {
                    dv2 = cl.getTime();
                    dis2 = d;
                    continue;
                }
                if (dis2.getDiscountTime() == null || d.getDiscountTime() == null) {
                    dv2 = cl.getTime();
                    dis2 = d;
                    continue;
                }
                if (d.getDiscountTime().getTime() < dis2.getDiscountTime().getTime()) continue;
                dv2 = cl.getTime();
                dis2 = d;
            }
        }
        if (dv == null || dv2 == null) {
            return null;
        }
        boolean str = "1".equals(context.getFreeTimeDiscountStrategy());
        return str ? dv2 : dv;
    }

    @Deprecated
    protected BigDecimal getDiscountMoney(List<Discount> discounts) {
        int v = 0;
        if (discounts != null && !discounts.isEmpty()) {
            for (Discount d : discounts) {
                if (d.getDiscount_method() != 0 || d.getDiscount_value() <= 0) continue;
                v += d.getDiscount_value();
            }
        }
        return new BigDecimal((double)v / 100.0).setScale(2, 4);
    }

    protected Set<String> getParentAreaList(List<ChargePassRecord> chargeRecordList, String areaNo, String rootAreaNo) {
        if (areaNo == null || areaNo.length() == 0 || chargeRecordList == null || chargeRecordList.isEmpty()) {
            return null;
        }
        HashSet<String> s = new HashSet<String>();
        this.findParentAreaList0(chargeRecordList, areaNo, s);
        if (!s.contains(rootAreaNo)) {
            s.add(rootAreaNo);
        }
        return s;
    }

    protected void findParentAreaList0(List<ChargePassRecord> chargeRecordList, String areaNo, Set<String> s) {
        if (areaNo == null || areaNo.length() == 0 || chargeRecordList == null || chargeRecordList.isEmpty()) {
            return;
        }
        for (ChargePassRecord r : chargeRecordList) {
            if (!areaNo.equals(r.getAreaNo())) continue;
            s.add(r.getAreaNo());
            if (r.getAreaNo().equals(r.getParentAreaNo())) continue;
            this.findParentAreaList0(chargeRecordList, r.getParentAreaNo(), s);
        }
    }

    protected List<Discount> getDiscountMinuteList(List<Discount> discounts) {
        LinkedList<Discount> minList = null;
        if (discounts != null && !discounts.isEmpty()) {
            for (Discount r : discounts) {
                if (r.getDiscount_method() != 1 || r.getDiscount_value() <= 0) continue;
                if (minList == null) {
                    minList = new LinkedList<Discount>();
                }
                minList.add(r);
            }
        }
        return minList;
    }

    @Deprecated
    protected int getDiscountMinute(List<Discount> discounts) {
        if (discounts != null && !discounts.isEmpty()) {
            int l = 0;
            for (Discount r : discounts) {
                if (r.getDiscount_method() != 1 || r.getDiscount_value() <= 0) continue;
                l += r.getDiscount_value();
            }
            return l;
        }
        return 0;
    }

    protected ChargePassRecord findParentRecord(String parentAreaNo, List<ChargePassRecord> list) {
        if (list != null && parentAreaNo != null) {
            for (ChargePassRecord r : list) {
                if (r.getAreaNo() == null || !r.getAreaNo().equals(parentAreaNo)) continue;
                return r;
            }
        }
        return null;
    }

    protected CarparkChargeSegmentRule getSegmentRule(CarparkChargeRule chargeRule, Date startTime, DateTypeSelector selector) {
        if (chargeRule == null) {
            return null;
        }
        List<CarparkChargeSegmentRule> list = chargeRule.getSegmentRuleList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        LinkedList<CarparkChargeSegmentRule> ruleList = new LinkedList<CarparkChargeSegmentRule>();
        if (chargeRule.getWork_mode() == 0) {
            for (CarparkChargeSegmentRule r : list) {
                if (r.getWork_mode_type() != 0) continue;
                ruleList.add(r);
            }
        } else {
            int dayType = selector.getDateType(startTime);
            for (CarparkChargeSegmentRule r : list) {
                if (r.getWork_mode_type() != dayType) continue;
                ruleList.add(r);
            }
        }
        list = ruleList;
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            CarparkChargeSegmentRule r;
            r = list.get(0);
            return r;
        }
        if (startTime == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        int timeMinutes = cal.get(11) * 60 + cal.get(12);
        CarparkChargeSegmentRule r1 = null;
        boolean MIN_MINUTES = false;
        int MAX_MINUTES = 1440;
        for (CarparkChargeSegmentRule r : list) {
            int beginTime = r.getStart_time();
            int endTime = r.getEnd_time();
            if (beginTime < 0 || beginTime >= 1440 || endTime < 0 || endTime > 1440) continue;
            if (beginTime == endTime) {
                if (endTime != 0) continue;
                endTime = 1440;
            }
            if (beginTime == 0 && endTime == 1440) {
                r1 = r;
                break;
            }
            if (beginTime > endTime) {
                if ((timeMinutes < beginTime || timeMinutes >= 1440) && timeMinutes >= endTime) continue;
                r1 = r;
                break;
            }
            if (timeMinutes < beginTime || timeMinutes >= endTime) continue;
            r1 = r;
            break;
        }
        return r1;
    }

    protected int getFreeMinuts(CarparkChargeRule chargeRule, Date startTime, DateTypeSelector selector) {
        CarparkChargeSegmentRule r = this.getSegmentRule(chargeRule, startTime, selector);
        if (r != null && r.getFree_time_len() != null && r.getFree_time_len() > 0) {
            return r.getFree_time_len();
        }
        return 0;
    }

    protected int getFirstMinuts(CarparkChargeRule chargeRule, Date startTime, DateTypeSelector selector) {
        CarparkChargeSegmentRule r = this.getSegmentRule(chargeRule, startTime, selector);
        if (r != null && r.getCharge_type() != null && r.getCharge_type() == 0 && r.getFirst_time_len() != null && r.getFirst_time_len() > 0) {
            return r.getFirst_time_len();
        }
        return 0;
    }
}

