/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.charge;

import com.wovoe.carpark.charge.ChargeAlgorithm;
import com.wovoe.carpark.charge.DateTypeSelector;
import com.wovoe.carpark.dto.CarparkChargeRule;
import com.wovoe.carpark.dto.CarparkChargeSegmentRule;
import com.wovoe.carpark.dto.CarparkChargeTimeLenRange;
import com.wovoe.framework.KeyValueEntry;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DefaultChargeAlgorithm
implements ChargeAlgorithm {
    public static final int MIN_MINUTES = 0;
    public static final int MAX_MINUTES = 1440;
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    @Override
    public BigDecimal charge(CarparkChargeRule chargeRule, Date startTime, Date endTime, Map<String, String> chargeDes, DateTypeSelector dateTypeSelector, boolean haveFirstTimeLen, boolean haveFreeTimeLen, int crossStrategy, int holidayBeginMins, int holidayEndMins, int firtAndLastWhenSameRuleStrategy, ChargeAlgorithm.ChageParam param) {
        if (chargeRule == null) {
            throw new NullPointerException("\u8ba1\u8d39\u89c4\u5219\u4e3anull");
        }
        if (chargeRule.getSegmentRuleList() == null || chargeRule.getSegmentRuleList().isEmpty()) {
            throw new IllegalArgumentException("\u8ba1\u8d39\u89c4\u5219\u6570\u636e\u4e0d\u5168");
        }
        if (endTime.before(startTime)) {
            return ZERO;
        }
        if (chargeRule.getWork_mode() == 0) {
            ArrayList<CarparkChargeSegmentRule> segmentRuleList = new ArrayList<CarparkChargeSegmentRule>(chargeRule.getSegmentRuleList().size());
            for (CarparkChargeSegmentRule r : chargeRule.getSegmentRuleList()) {
                if (r.getWork_mode_type() != 0) continue;
                segmentRuleList.add(r);
            }
            if (segmentRuleList.isEmpty()) {
                throw new IllegalArgumentException("\u672a\u627e\u5230\u6309\u6bcf\u5929(\u4e0d\u533a\u5206\u8282\u5047\u65e5\u5de5\u4f5c\u65e5)\u5b9a\u4e49\u7684\u8ba1\u8d39\u89c4\u5219");
            }
            boolean mutiSegmentCharge = false;
            if (segmentRuleList.size() > 1) {
                mutiSegmentCharge = true;
            } else if (chargeRule.getMuti_segment_charge() == 1) {
                mutiSegmentCharge = true;
            }
            if (!mutiSegmentCharge) {
                int freeTimeLen;
                CarparkChargeSegmentRule segementRule = (CarparkChargeSegmentRule)segmentRuleList.get(0);
                int timeLenMin = (int)TimeUnit.MILLISECONDS.toMinutes(endTime.getTime() - startTime.getTime());
                int n = freeTimeLen = segementRule.getFree_time_len() == null ? 0 : segementRule.getFree_time_len();
                if (freeTimeLen < 0) {
                    freeTimeLen = 0;
                }
                if (timeLenMin <= freeTimeLen && haveFreeTimeLen) {
                    return ZERO;
                }
                if (segementRule.getCharge_type() == 0) {
                    return this.calSegmentIntervalMoney(segementRule, timeLenMin, null, haveFirstTimeLen, param);
                }
                if (segementRule.getCharge_type() == 1) {
                    return this.calSegmentTimeLenRangeMoney(segementRule, timeLenMin, null, null, param);
                }
                if (segementRule.getCharge_type() == 2) {
                    if (segementRule.getTimes_money() == null) {
                        throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u672a\u5b9a\u4e49!");
                    }
                    if (segementRule.getTimes_money().doubleValue() < 0.0) {
                        throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u5b9a\u4e49\u5c0f\u4e8e0! " + segementRule.getTimes_money());
                    }
                    if (segementRule.getMax_change() != null && segementRule.getMax_change() == 1) {
                        if (segementRule.getMax_hours() == null) {
                            throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u6700\u9ad8\u65f6\u957f\u672a\u5b9a\u4e49");
                        }
                        int max_mintes = segementRule.getMax_hours() * 60;
                        if (max_mintes <= 0) {
                            throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u6700\u9ad8\u65f6\u957f\u5fc5\u987b\u5927\u4e8e0!");
                        }
                        if (timeLenMin <= max_mintes) {
                            return segementRule.getTimes_money();
                        }
                        int h = timeLenMin % max_mintes;
                        int h1 = timeLenMin / max_mintes;
                        int n2 = h == 0 ? h1 : h1 + 1;
                        return segementRule.getTimes_money().multiply(new BigDecimal(n2));
                    }
                    return segementRule.getTimes_money();
                }
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u672a\u77e5\u7684\u8ba1\u8d39\u7c7b\u578b");
            }
            if (chargeRule.getMax_period() == 1) {
                if (chargeRule.getMax_period_money() == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u6700\u9ad8\u8ba1\u8d39\u91d1\u989d\u6ca1\u6709\u5b9a\u4e49!");
                }
                if (chargeRule.getMax_period_money().doubleValue() < 0.0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u6700\u9ad8\u8ba1\u8d39\u91d1\u989d\u5c0f\u4e8e0! " + chargeRule.getMax_period_money());
                }
                if (chargeRule.getMax_period_money().doubleValue() == 0.0) {
                    return ZERO;
                }
                BigDecimal maxMoney = chargeRule.getMax_period_money();
                if (chargeRule.getMax_period_len() == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u65f6\u957f\u6ca1\u6709\u5b9a\u4e49!");
                }
                if (chargeRule.getMax_period_len() <= 0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u65f6\u957f\u5fc5\u987b\u5927\u4e8e0! " + chargeRule.getMax_period_len());
                }
                int maxMutiSegmentPeriodLen = chargeRule.getMax_period_len() * 60;
                int timeLenMin = (int)TimeUnit.MILLISECONDS.toMinutes(endTime.getTime() - startTime.getTime());
                if (timeLenMin <= maxMutiSegmentPeriodLen) {
                    BigDecimal money = this.calMutiSegment(segmentRuleList, startTime, endTime, haveFirstTimeLen, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (money.doubleValue() > maxMoney.doubleValue()) {
                        money = maxMoney;
                    }
                    return money;
                }
                int intPeriod = timeLenMin / maxMutiSegmentPeriodLen;
                Calendar cal = Calendar.getInstance();
                cal.setTime(startTime);
                cal.set(14, 0);
                cal.set(13, 0);
                Date tempStartDate = cal.getTime();
                cal.setTime(endTime);
                cal.set(14, 0);
                cal.set(13, 0);
                Date tempEndDate = cal.getTime();
                cal.setTime(tempStartDate);
                cal.add(12, maxMutiSegmentPeriodLen);
                BigDecimal maxMoney1 = this.calMutiSegment(segmentRuleList, tempStartDate, cal.getTime(), haveFirstTimeLen, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                if (maxMoney1.doubleValue() > maxMoney.doubleValue()) {
                    maxMoney1 = maxMoney;
                }
                int n = intPeriod * maxMutiSegmentPeriodLen;
                BigDecimal money = maxMoney1;
                if (--intPeriod > 0) {
                    BigDecimal maxMoney2 = this.calMutiSegment(segmentRuleList, tempStartDate, cal.getTime(), false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (maxMoney2.doubleValue() > maxMoney.doubleValue()) {
                        maxMoney2 = maxMoney;
                    }
                    money = money.add(maxMoney2.multiply(new BigDecimal(intPeriod)));
                }
                if (timeLenMin - n > 0) {
                    cal.setTime(tempStartDate);
                    cal.add(12, n);
                    BigDecimal xmaxMoney = this.calMutiSegment(segmentRuleList, cal.getTime(), tempEndDate, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (xmaxMoney.doubleValue() > maxMoney.doubleValue()) {
                        xmaxMoney = maxMoney;
                    }
                    money = money.add(xmaxMoney);
                }
                return money;
            }
            return this.calMutiSegment(segmentRuleList, startTime, endTime, haveFirstTimeLen, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
        }
        if (chargeRule.getWork_mode() == 1) {
            LinkedList<CarparkChargeSegmentRule> workDaySegmentRuleList = new LinkedList<CarparkChargeSegmentRule>();
            LinkedList<CarparkChargeSegmentRule> holidayDaySegmentRuleList = new LinkedList<CarparkChargeSegmentRule>();
            for (CarparkChargeSegmentRule srule : chargeRule.getSegmentRuleList()) {
                if (srule.getWork_mode_type() == 1) {
                    workDaySegmentRuleList.add(srule);
                    continue;
                }
                if (srule.getWork_mode_type() != 2) continue;
                holidayDaySegmentRuleList.add(srule);
            }
            if (workDaySegmentRuleList.isEmpty()) {
                throw new IllegalArgumentException("\u672a\u627e\u5230\u6309\u5de5\u4f5c\u65e5\u5b9a\u4e49\u7684\u8ba1\u8d39\u89c4\u5219!");
            }
            if (holidayDaySegmentRuleList.isEmpty()) {
                throw new IllegalArgumentException("\u672a\u627e\u5230\u6309\u8282\u5047\u65e5\u5b9a\u4e49\u7684\u8ba1\u8d39\u89c4\u5219!");
            }
            int len = (int)TimeUnit.MILLISECONDS.toMinutes(endTime.getTime() - startTime.getTime());
            if (len <= 0) {
                return ZERO;
            }
            int dayTypeox = dateTypeSelector.getDateType(startTime);
            LinkedList<CarparkChargeSegmentRule> r1 = dayTypeox == 1 ? workDaySegmentRuleList : holidayDaySegmentRuleList;
            if (haveFreeTimeLen) {
                Integer freeTimeLen = null;
                if (r1.size() == 1) {
                    freeTimeLen = ((CarparkChargeSegmentRule)r1.get(0)).getFree_time_len();
                } else {
                    Calendar cal = Calendar.getInstance();
                    Date tempStartDate = this.clearSecond(startTime, cal);
                    cal.setTime(tempStartDate);
                    int timeMinutes = cal.get(11) * 60 + cal.get(12);
                    CarparkChargeSegmentRule segmentRule = this.findSegmentRule(r1, timeMinutes);
                    freeTimeLen = segmentRule.getFree_time_len();
                }
                if (freeTimeLen != null && freeTimeLen > 0 && len <= freeTimeLen) {
                    return ZERO;
                }
            }
            if (chargeRule.getMax_period() == 1) {
                if (chargeRule.getMax_period_money() == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u6700\u9ad8\u8ba1\u8d39\u91d1\u989d\u6ca1\u6709\u5b9a\u4e49!");
                }
                if (chargeRule.getMax_period_money().doubleValue() < 0.0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u6700\u9ad8\u8ba1\u8d39\u91d1\u989d\u5c0f\u4e8e0! " + chargeRule.getMax_period_money());
                }
                if (chargeRule.getMax_period_money().doubleValue() == 0.0) {
                    return ZERO;
                }
                BigDecimal maxMoney = chargeRule.getMax_period_money();
                if (chargeRule.getMax_period_len() == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u65f6\u957f\u6ca1\u6709\u5b9a\u4e49!");
                }
                if (chargeRule.getMax_period_len() <= 0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u65f6\u957f\u5fc5\u987b\u5927\u4e8e0! " + chargeRule.getMax_period_len());
                }
                int maxMutiSegmentPeriodLen = chargeRule.getMax_period_len() * 60;
                int timeLenMin = (int)TimeUnit.MILLISECONDS.toMinutes(endTime.getTime() - startTime.getTime());
                if (timeLenMin <= maxMutiSegmentPeriodLen) {
                    BigDecimal money = this.calByDayType(null, workDaySegmentRuleList, null, holidayDaySegmentRuleList, startTime, endTime, haveFirstTimeLen, dateTypeSelector, crossStrategy, holidayBeginMins, holidayEndMins, haveFreeTimeLen, firtAndLastWhenSameRuleStrategy, param);
                    if (money.doubleValue() > maxMoney.doubleValue()) {
                        money = maxMoney;
                    }
                    return money;
                }
                Calendar cal = Calendar.getInstance();
                Date tempStartDate = this.clearSecond(startTime, cal);
                Date tempEndDate = this.clearSecond(endTime, cal);
                long edn = tempEndDate.getTime();
                cal.setTime(tempStartDate);
                boolean first = haveFirstTimeLen;
                boolean hasFree = haveFreeTimeLen;
                BigDecimal money = ZERO;
                while (cal.getTimeInMillis() <= edn) {
                    BigDecimal xmoney;
                    cal.add(12, maxMutiSegmentPeriodLen);
                    if (cal.getTimeInMillis() < edn) {
                        xmoney = this.calByDayType(null, workDaySegmentRuleList, null, holidayDaySegmentRuleList, tempStartDate, cal.getTime(), first, dateTypeSelector, crossStrategy, holidayBeginMins, holidayEndMins, hasFree, firtAndLastWhenSameRuleStrategy, param);
                        if (xmoney.doubleValue() > maxMoney.doubleValue()) {
                            xmoney = maxMoney;
                        }
                    } else {
                        xmoney = this.calByDayType(null, workDaySegmentRuleList, null, holidayDaySegmentRuleList, tempStartDate, tempEndDate, first, dateTypeSelector, crossStrategy, holidayBeginMins, holidayEndMins, hasFree, firtAndLastWhenSameRuleStrategy, param);
                        if (xmoney.doubleValue() > maxMoney.doubleValue()) {
                            xmoney = maxMoney;
                        }
                        money = money.add(xmoney);
                        break;
                    }
                    money = money.add(xmoney);
                    tempStartDate = cal.getTime();
                    if (first) {
                        first = false;
                    }
                    if (!hasFree) continue;
                    hasFree = false;
                }
                return money;
            }
            BigDecimal workdayMaxMoney = null;
            if (chargeRule.getMax_work_day() != null && chargeRule.getMax_work_day() == 1) {
                workdayMaxMoney = chargeRule.getMax_work_day_money();
                if (workdayMaxMoney == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5de5\u4f5c\u65e524\u5c0f\u65f6\u6700\u9ad8\u8ba1\u8d39\u91d1\u989d\u6ca1\u6709\u5b9a\u4e49!");
                }
                if (workdayMaxMoney.doubleValue() < 0.0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5de5\u4f5c\u65e524\u5c0f\u65f6\u6700\u9ad8\u8ba1\u8d39\u91d1\u989d\u5c0f\u4e8e0! " + workdayMaxMoney);
                }
            }
            BigDecimal holidayMaxMoney = null;
            if (chargeRule.getMax_holiday() != null && chargeRule.getMax_holiday() == 1) {
                holidayMaxMoney = chargeRule.getMax_holiday_day_money();
                if (holidayMaxMoney == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u8282\u5047\u65e524\u5c0f\u65f6\u6700\u9ad8\u8ba1\u8d39\u91d1\u989d\u6ca1\u6709\u5b9a\u4e49!");
                }
                if (holidayMaxMoney.doubleValue() < 0.0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u8282\u5047\u65e524\u5c0f\u65f6\u6700\u9ad8\u8ba1\u8d39\u91d1\u989d\u5c0f\u4e8e0! " + holidayMaxMoney);
                }
            }
            return this.calByDayType(workdayMaxMoney, workDaySegmentRuleList, holidayMaxMoney, holidayDaySegmentRuleList, startTime, endTime, haveFirstTimeLen, dateTypeSelector, crossStrategy, holidayBeginMins, holidayEndMins, haveFreeTimeLen, firtAndLastWhenSameRuleStrategy, param);
        }
        throw new IllegalArgumentException("\u5e94\u7528\u6a21\u5f0f\u6682\u65f6\u53ea\u652f\u6301 \uff08\u4e0d\u533a\u5206\u5de5\u4f5c\u65e5\uff0f\u8282\u5047\u65e5\uff0c\u533a\u5206\u5de5\u4f5c\u65e5\uff0f\u8282\u5047\u65e5\uff09");
    }

    private Date clearTime(Date datetime, Calendar cal) {
        cal.setTime(datetime);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date clearSecond(Date datetime, Calendar cal) {
        cal.setTime(datetime);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    protected List<DayTypeSplitEntry> getDayTypeSplitEntry(int holidayBeginMins, int holidayEndMins, Date startTime, Date endTime, DateTypeSelector dateTypeSelector) {
        DayTypeSplitEntry entry;
        if (holidayBeginMins <= -1440) {
            holidayBeginMins = -1439;
        } else if (holidayBeginMins >= 1440) {
            holidayBeginMins = 1439;
        }
        if (holidayEndMins <= -1440) {
            holidayEndMins = -1439;
        } else if (holidayEndMins >= 1440) {
            holidayEndMins = 1439;
        }
        Calendar cal = Calendar.getInstance();
        Date tempBeginDate = this.clearSecond(startTime, cal);
        Date tempEndDate = this.clearSecond(endTime, cal);
        long endMills = tempEndDate.getTime();
        if (tempEndDate.before(tempBeginDate)) {
            return Collections.emptyList();
        }
        AbstractList byDayList = new ArrayList<DayTypeSplitEntry>((int)TimeUnit.MILLISECONDS.toDays(tempEndDate.getTime() - tempBeginDate.getTime()) + 2);
        this.clearTime(startTime, cal);
        cal.add(5, 1);
        if (endMills <= cal.getTimeInMillis()) {
            entry = new DayTypeSplitEntry(startTime, endTime, dateTypeSelector.getDateType(startTime), null, null);
            byDayList.add(entry);
        } else {
            Date tempBegin = cal.getTime();
            entry = new DayTypeSplitEntry(startTime, tempBegin, dateTypeSelector.getDateType(startTime), null, null);
            byDayList.add(entry);
            while (cal.getTimeInMillis() < endMills) {
                cal.add(5, 1);
                if (endMills <= cal.getTimeInMillis()) {
                    entry = new DayTypeSplitEntry(tempBegin, endTime, dateTypeSelector.getDateType(tempBegin), null, null);
                    byDayList.add((DayTypeSplitEntry)entry);
                    break;
                }
                entry = new DayTypeSplitEntry(tempBegin, cal.getTime(), dateTypeSelector.getDateType(tempBegin), null, null);
                tempBegin = entry.endDate;
                byDayList.add(entry);
            }
        }
        if (holidayBeginMins != 0 && holidayEndMins != 0) {
            LinkedList<DayTypeSplitEntry> newList = new LinkedList<DayTypeSplitEntry>();
            int lastIndex = byDayList.size() - 1;
            int i = 0;
            while (i < byDayList.size()) {
                Date tempDate;
                int nextDayType;
                Date nextDay;
                DayTypeSplitEntry l;
                int preDayType;
                Date preDay;
                entry = (DayTypeSplitEntry)byDayList.get(i);
                if (i == 0) {
                    this.clearTime(entry.beginDate, cal);
                    cal.add(5, -1);
                    preDay = cal.getTime();
                    preDayType = dateTypeSelector.getDateType(preDay);
                } else {
                    l = (DayTypeSplitEntry)byDayList.get(i - 1);
                    if (i == 1) {
                        this.clearTime(l.beginDate, cal);
                        preDay = cal.getTime();
                    } else {
                        preDay = l.beginDate;
                    }
                    preDayType = l.dateType;
                }
                if (i < lastIndex) {
                    l = (DayTypeSplitEntry)byDayList.get(i + 1);
                    nextDay = l.beginDate;
                    nextDayType = l.dateType;
                } else {
                    this.clearTime(entry.beginDate, cal);
                    cal.add(5, 1);
                    nextDay = cal.getTime();
                    nextDayType = dateTypeSelector.getDateType(nextDay);
                }
                if (entry.dateType == 1) {
                    if (preDayType == 2) {
                        if (holidayEndMins > 0) {
                            cal.setTime(preDay);
                            cal.add(12, holidayEndMins + 1440);
                            tempDate = cal.getTime();
                            if (entry.beginDate.getTime() >= tempDate.getTime()) {
                                l = entry;
                            } else if (entry.endDate.getTime() <= tempDate.getTime()) {
                                newList.add(new DayTypeSplitEntry(entry.beginDate, entry.endDate, 2, null, null));
                                l = null;
                            } else {
                                newList.add(new DayTypeSplitEntry(entry.beginDate, tempDate, 2, null, null));
                                l = new DayTypeSplitEntry(tempDate, entry.endDate, 1, null, null);
                            }
                        } else {
                            l = entry;
                        }
                    } else {
                        l = entry;
                    }
                    if (l != null) {
                        if (nextDayType == 1) {
                            newList.add(l);
                        } else if (holidayBeginMins < 0) {
                            cal.setTime(nextDay);
                            cal.add(12, holidayBeginMins);
                            tempDate = cal.getTime();
                            if (l.beginDate.getTime() >= tempDate.getTime()) {
                                newList.add(new DayTypeSplitEntry(l.beginDate, l.endDate, 2, null, null));
                            } else if (l.endDate.getTime() <= tempDate.getTime()) {
                                newList.add(l);
                            } else {
                                newList.add(new DayTypeSplitEntry(l.beginDate, tempDate, 1, null, null));
                                newList.add(new DayTypeSplitEntry(tempDate, l.endDate, 2, null, null));
                            }
                        } else {
                            newList.add(l);
                        }
                    }
                } else {
                    if (preDayType == 1) {
                        if (holidayBeginMins > 0) {
                            cal.setTime(preDay);
                            cal.add(12, holidayBeginMins + 1440);
                            tempDate = cal.getTime();
                            if (entry.beginDate.getTime() >= tempDate.getTime()) {
                                l = entry;
                            } else if (entry.endDate.getTime() <= tempDate.getTime()) {
                                newList.add(new DayTypeSplitEntry(entry.beginDate, entry.endDate, 1, null, null));
                                l = null;
                            } else {
                                newList.add(new DayTypeSplitEntry(entry.beginDate, tempDate, 1, null, null));
                                l = new DayTypeSplitEntry(tempDate, entry.endDate, 2, null, null);
                            }
                        } else {
                            l = entry;
                        }
                    } else {
                        l = entry;
                    }
                    if (l != null) {
                        if (nextDayType == 1) {
                            if (holidayEndMins < 0) {
                                cal.setTime(nextDay);
                                cal.add(12, holidayEndMins);
                                tempDate = cal.getTime();
                                if (l.beginDate.getTime() >= tempDate.getTime()) {
                                    newList.add(new DayTypeSplitEntry(l.beginDate, l.endDate, 1, null, null));
                                } else if (l.endDate.getTime() <= tempDate.getTime()) {
                                    newList.add(l);
                                } else {
                                    newList.add(new DayTypeSplitEntry(l.beginDate, tempDate, 2, null, null));
                                    newList.add(new DayTypeSplitEntry(tempDate, l.endDate, 1, null, null));
                                }
                            } else {
                                newList.add(l);
                            }
                        } else {
                            newList.add(l);
                        }
                    }
                }
                ++i;
            }
            byDayList = newList;
        }
        return byDayList;
    }

    protected BigDecimal calMutiSegmentByPeriod(List<CarparkChargeSegmentRule> segmentRuleList, Date startTime, Date endTime, boolean haveFirst, boolean haveFreeTime, int crossStrategy, int firtAndLastWhenSameRuleStrategy, ChargeAlgorithm.ChageParam param, int periodMins, BigDecimal periodMaxMoney) {
        if (periodMaxMoney == null || periodMaxMoney.doubleValue() < 0.0 || periodMins <= 0) {
            return this.calMutiSegment(segmentRuleList, startTime, endTime, haveFirst, haveFreeTime, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
        }
        if (periodMaxMoney.doubleValue() == 0.0) {
            return ZERO;
        }
        int toalMins = (int)TimeUnit.MILLISECONDS.toMinutes(endTime.getTime() - startTime.getTime());
        if (toalMins <= periodMins) {
            BigDecimal m = this.calMutiSegment(segmentRuleList, startTime, endTime, haveFirst, haveFreeTime, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
            if (m.doubleValue() > 0.0) {
                if (m.doubleValue() > periodMaxMoney.doubleValue()) {
                    m = periodMaxMoney;
                }
            } else {
                m = ZERO;
            }
            return m;
        }
        int a = toalMins % periodMins;
        int x = toalMins / periodMins;
        Calendar cl = Calendar.getInstance();
        cl.setTime(startTime);
        cl.add(12, periodMins);
        BigDecimal m = this.calMutiSegment(segmentRuleList, startTime, cl.getTime(), haveFirst, haveFreeTime, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
        if (m.doubleValue() > 0.0) {
            if (m.doubleValue() > periodMaxMoney.doubleValue()) {
                m = periodMaxMoney;
            }
        } else {
            m = ZERO;
        }
        BigDecimal z = m.multiply(new BigDecimal(x));
        if (a > 0) {
            cl.setTime(startTime);
            cl.add(12, periodMins * x);
            m = this.calMutiSegment(segmentRuleList, cl.getTime(), endTime, haveFirst, haveFreeTime, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
            if (m.doubleValue() > 0.0) {
                if (m.doubleValue() > periodMaxMoney.doubleValue()) {
                    m = periodMaxMoney;
                }
                z = z.add(m);
            }
        }
        return z;
    }

    protected BigDecimal calByDayType(BigDecimal workdayMaxMoney, List<CarparkChargeSegmentRule> workDaySegmentRuleList, BigDecimal holidayMaxMoney, List<CarparkChargeSegmentRule> holidayDaySegmentRuleList, Date startTime, Date endTime, boolean haveFirst, DateTypeSelector dateTypeSelector, int crossStrategy, int holidayBeginMins, int holidayEndMins, boolean haveFreeTimeLen, int firtAndLastWhenSameRuleStrategy, ChargeAlgorithm.ChageParam param) {
        List<DayTypeSplitEntry> dateList = this.getDayTypeSplitEntry(holidayBeginMins, holidayEndMins, startTime, endTime, dateTypeSelector);
        if (dateList.isEmpty()) {
            return ZERO;
        }
        int totalMins = (int)TimeUnit.MILLISECONDS.toMinutes(endTime.getTime() - startTime.getTime());
        Calendar cl = Calendar.getInstance();
        BigDecimal mMoney = ZERO;
        if (dateList.size() > 2) {
            BigDecimal m;
            int i = 0;
            int lastIndex = dateList.size() - 1;
            LinkedList<DayTypeSplitEntry> mergeList = null;
            Date workStartTime = null;
            int workDayNums = 0;
            Date holidayStartTime = null;
            int holidayNums = 0;
            Object firstEntry = null;
            DayTypeSplitEntry lastEntry = null;
            mMoney = ZERO;
            for (DayTypeSplitEntry entry : dateList) {
                if (i == 0) {
                    firstEntry = entry;
                } else if (i == lastIndex) {
                    lastEntry = entry;
                } else if ((int)TimeUnit.MILLISECONDS.toMinutes(entry.endDate.getTime() - entry.beginDate.getTime()) == 1440) {
                    if (entry.dateType == 1) {
                        if (workStartTime == null) {
                            workStartTime = entry.beginDate;
                        }
                        ++workDayNums;
                    } else {
                        if (holidayStartTime == null) {
                            holidayStartTime = entry.beginDate;
                        }
                        ++holidayNums;
                    }
                } else {
                    if (mergeList == null) {
                        mergeList = new LinkedList<DayTypeSplitEntry>();
                    }
                    mergeList.add(entry);
                }
                ++i;
            }
            if (workStartTime != null && workDayNums > 0) {
                cl.setTime(workStartTime);
                cl.add(12, 1440);
                m = this.calMutiSegmentByPeriod(workDaySegmentRuleList, workStartTime, cl.getTime(), false, false, crossStrategy, 0, param, 1440, workdayMaxMoney);
                if (m != null && m.doubleValue() > 0.0) {
                    if (workDayNums > 1) {
                        m = m.multiply(new BigDecimal(workDayNums));
                    }
                    mMoney = mMoney.add(m);
                }
            }
            if (holidayStartTime != null && holidayNums > 0) {
                cl.setTime(holidayStartTime);
                cl.add(12, 1440);
                m = this.calMutiSegmentByPeriod(holidayDaySegmentRuleList, holidayStartTime, cl.getTime(), false, false, crossStrategy, 0, param, 1440, holidayMaxMoney);
                if (m != null && m.doubleValue() > 0.0) {
                    if (holidayNums > 1) {
                        m = m.multiply(new BigDecimal(holidayNums));
                    }
                    mMoney = mMoney.add(m);
                }
            }
            LinkedList<DayTypeSplitEntry> newDateRangeList = new LinkedList<DayTypeSplitEntry>();
            newDateRangeList.add((DayTypeSplitEntry)firstEntry);
            if (mergeList != null && !mergeList.isEmpty()) {
                BigDecimal m2;
                workStartTime = null;
                workDayNums = 0;
                holidayStartTime = null;
                holidayNums = 0;
                DayTypeSplitEntry l = null;
                int addMins = 0;
                for (DayTypeSplitEntry entry : mergeList) {
                    if (l == null) {
                        l = entry;
                        addMins = (int)TimeUnit.MILLISECONDS.toMinutes(entry.endDate.getTime() - entry.beginDate.getTime());
                        continue;
                    }
                    if (entry.dateType == l.dateType) {
                        addMins += (int)TimeUnit.MILLISECONDS.toMinutes(entry.endDate.getTime() - entry.beginDate.getTime());
                        continue;
                    }
                    cl.setTime(l.beginDate);
                    cl.add(12, addMins);
                    l.endDate = cl.getTime();
                    if (addMins >= 1440) {
                        m2 = this.calMutiSegmentByPeriod(l.dateType == 1 ? workDaySegmentRuleList : holidayDaySegmentRuleList, l.beginDate, l.endDate, false, false, crossStrategy, 0, param, 1440, l.dateType == 1 ? workdayMaxMoney : holidayMaxMoney);
                        if (m2 != null && m2.doubleValue() > 0.0) {
                            mMoney = mMoney.add(m2);
                        }
                    } else {
                        newDateRangeList.add(l);
                    }
                    l = entry;
                    addMins = (int)TimeUnit.MILLISECONDS.toMinutes(entry.endDate.getTime() - entry.beginDate.getTime());
                }
                if (l != null) {
                    cl.setTime(l.beginDate);
                    cl.add(12, addMins);
                    l.endDate = cl.getTime();
                    if (addMins >= 1440) {
                        m2 = this.calMutiSegmentByPeriod(l.dateType == 1 ? workDaySegmentRuleList : holidayDaySegmentRuleList, l.beginDate, l.endDate, false, false, crossStrategy, 0, param, 1440, l.dateType == 1 ? workdayMaxMoney : holidayMaxMoney);
                        if (m2 != null && m2.doubleValue() > 0.0) {
                            mMoney = mMoney.add(m2);
                        }
                    } else {
                        newDateRangeList.add(l);
                    }
                }
            }
            newDateRangeList.add(lastEntry);
            dateList = newDateRangeList;
        }
        if (dateList.size() > 1) {
            DayTypeSplitEntry l_work = null;
            DayTypeSplitEntry l_hodilay = null;
            LinkedList<DayTypeSplitEntry> newDateList = new LinkedList<DayTypeSplitEntry>();
            boolean isWorkDayMuliSeg = workDaySegmentRuleList.size() > 1;
            boolean isHolidayMuliSeg = holidayDaySegmentRuleList.size() > 1;
            for (DayTypeSplitEntry entry : dateList) {
                if (entry.dateType == 1) {
                    if (l_work == null) {
                        l_work = entry;
                        newDateList.add(entry);
                        continue;
                    }
                    if (isWorkDayMuliSeg) {
                        cl.setTime(l_work.endDate);
                        cl.set(2000, 0, 1);
                        Date d1 = cl.getTime();
                        cl.setTime(entry.beginDate);
                        cl.set(2000, 0, 1);
                        if (d1.getTime() == cl.getTimeInMillis()) {
                            cl.setTime(l_work.endDate);
                            cl.add(12, (int)TimeUnit.MILLISECONDS.toMinutes(entry.endDate.getTime() - entry.beginDate.getTime()));
                            l_work.endDate = cl.getTime();
                            continue;
                        }
                        l_work = entry;
                        newDateList.add(entry);
                        continue;
                    }
                    cl.setTime(l_work.endDate);
                    cl.add(12, (int)TimeUnit.MILLISECONDS.toMinutes(entry.endDate.getTime() - entry.beginDate.getTime()));
                    l_work.endDate = cl.getTime();
                    continue;
                }
                if (l_hodilay == null) {
                    l_hodilay = entry;
                    newDateList.add(l_hodilay);
                    continue;
                }
                if (isHolidayMuliSeg) {
                    cl.setTime(l_hodilay.endDate);
                    cl.set(2000, 0, 1);
                    Date d1 = cl.getTime();
                    cl.setTime(entry.beginDate);
                    cl.set(2000, 0, 1);
                    if (d1.getTime() == cl.getTimeInMillis()) {
                        cl.setTime(l_hodilay.endDate);
                        cl.add(12, (int)TimeUnit.MILLISECONDS.toMinutes(entry.endDate.getTime() - entry.beginDate.getTime()));
                        l_hodilay.endDate = cl.getTime();
                        continue;
                    }
                    l_hodilay = entry;
                    newDateList.add(l_hodilay);
                    continue;
                }
                cl.setTime(l_hodilay.endDate);
                cl.add(12, (int)TimeUnit.MILLISECONDS.toMinutes(entry.endDate.getTime() - entry.beginDate.getTime()));
                l_hodilay.endDate = cl.getTime();
            }
            dateList = newDateList;
        }
        if (dateList.size() == 1) {
            DayTypeSplitEntry l = dateList.get(0);
            BigDecimal m = this.calMutiSegmentByPeriod(l.dateType == 1 ? workDaySegmentRuleList : holidayDaySegmentRuleList, l.beginDate, l.endDate, haveFirst, haveFreeTimeLen, crossStrategy, 0, param, 1440, l.dateType == 1 ? workdayMaxMoney : holidayMaxMoney);
            if (m != null && m.doubleValue() > 0.0) {
                mMoney = mMoney.add(m);
            }
        } else if (totalMins <= 1440 && dateList.size() == 2 && dateList.get((int)0).dateType != dateList.get((int)1).dateType) {
            int old_nextFreeLen;
            DayTypeSplitEntry first = dateList.get(0);
            DayTypeSplitEntry next = dateList.get(dateList.size() - 1);
            CarparkChargeSegmentRule firstRule = this.findSegmentRule(first.dateType == 1 ? workDaySegmentRuleList : holidayDaySegmentRuleList, first.beginDate);
            CarparkChargeSegmentRule nextRule = this.findSegmentRule(next.dateType == 1 ? workDaySegmentRuleList : holidayDaySegmentRuleList, next.beginDate);
            int firstDuration = (int)TimeUnit.MILLISECONDS.toMinutes(first.endDate.getTime() - first.beginDate.getTime());
            int n = old_nextFreeLen = nextRule.getFree_time_len() != null && nextRule.getFree_time_len() > 0 ? nextRule.getFree_time_len() : 0;
            int old_nextFirstTimeLen = nextRule.getCharge_type() == 0 ? (nextRule.getFirst_time_len() != null && nextRule.getFirst_time_len() > 0 ? nextRule.getFirst_time_len() : 0) : 0;
            try {
                int nextFreeLen = old_nextFreeLen;
                int nextFirstTimeLen = old_nextFirstTimeLen;
                if (haveFreeTimeLen) {
                    int firstFreeLen;
                    int n2 = firstFreeLen = firstRule.getFree_time_len() != null && firstRule.getFree_time_len() > 0 ? firstRule.getFree_time_len() : 0;
                    if (firstFreeLen > 0 && firstDuration <= firstFreeLen) {
                        dateList.remove(0);
                        if (nextFreeLen > firstDuration) {
                            nextRule.setFree_time_len(nextFreeLen -= firstDuration);
                        } else {
                            haveFreeTimeLen = false;
                            nextRule.setFree_time_len(0);
                        }
                        if (nextFirstTimeLen > 0) {
                            if ((nextFirstTimeLen -= firstDuration) < 0) {
                                nextFirstTimeLen = 0;
                            }
                            nextRule.setFirst_time_len(nextFirstTimeLen);
                        }
                    }
                }
                if (firstDuration > 0 && haveFirst && dateList.size() > 1 && firstRule.getCharge_type() == 0 && (param == null || param.lessTanAUnit == 1)) {
                    KeyValueEntry<Integer, BigDecimal> firstKv = this.getFirstTimeLenAndMoney(firstRule, true);
                    if (firstDuration <= (Integer)firstKv.getKey()) {
                        if (((BigDecimal)firstKv.getValue()).doubleValue() > 0.0) {
                            if (totalMins <= (Integer)firstKv.getKey()) {
                                dateList.clear();
                                mMoney = mMoney.add((BigDecimal)firstKv.getValue());
                            } else {
                                mMoney = mMoney.add((BigDecimal)firstKv.getValue());
                                cl.setTime(next.beginDate);
                                cl.add(12, (Integer)firstKv.getKey() - firstDuration);
                                next.beginDate = cl.getTime();
                                if (next.beginDate.getTime() >= next.endDate.getTime()) {
                                    dateList.clear();
                                } else {
                                    dateList.remove(0);
                                    haveFreeTimeLen = false;
                                    haveFirst = false;
                                }
                            }
                        }
                    } else {
                        int x;
                        KeyValueEntry<Integer, BigDecimal> unit = this.getUnitTimeLenAndMoney(firstRule);
                        if (((BigDecimal)unit.getValue()).doubleValue() > 0.0 && (Integer)unit.getKey() > 0 && (x = firstDuration - (Integer)firstKv.getKey()) % (Integer)unit.getKey() != 0) {
                            int y = (Integer)unit.getKey() - x % (Integer)unit.getKey();
                            cl.setTime(first.endDate);
                            cl.add(12, y);
                            Date endx = cl.getTime();
                            cl.setTime(next.beginDate);
                            cl.add(12, y);
                            next.beginDate = cl.getTime();
                            if (next.beginDate.getTime() >= next.endDate.getTime()) {
                                dateList.remove(1);
                            }
                            if (endx.getTime() > next.endDate.getTime()) {
                                endx = next.endDate;
                            }
                            first.endDate = endx;
                        }
                    }
                }
                int i = 0;
                boolean hasFirst = haveFirst;
                for (DayTypeSplitEntry l : dateList) {
                    BigDecimal m;
                    if (i > 0 && hasFirst && mMoney.doubleValue() > 0.0) {
                        hasFirst = false;
                    }
                    if ((m = this.calMutiSegmentByPeriod(l.dateType == 1 ? workDaySegmentRuleList : holidayDaySegmentRuleList, l.beginDate, l.endDate, hasFirst, i == 0 ? haveFreeTimeLen : false, crossStrategy, 0, param, 1440, l.dateType == 1 ? workdayMaxMoney : holidayMaxMoney)) != null && m.doubleValue() > 0.0) {
                        mMoney = mMoney.add(m);
                    }
                    ++i;
                }
            }
            finally {
                if (old_nextFreeLen > 0) {
                    nextRule.setFree_time_len(old_nextFreeLen);
                }
                if (old_nextFirstTimeLen > 0) {
                    nextRule.setFirst_time_len(old_nextFirstTimeLen);
                }
            }
        } else {
            int i = 0;
            boolean hasFirst = haveFirst;
            for (DayTypeSplitEntry l : dateList) {
                BigDecimal m;
                if (i > 0 && hasFirst && mMoney.doubleValue() > 0.0) {
                    hasFirst = false;
                }
                if ((m = this.calMutiSegmentByPeriod(l.dateType == 1 ? workDaySegmentRuleList : holidayDaySegmentRuleList, l.beginDate, l.endDate, hasFirst, i == 0 ? haveFreeTimeLen : false, crossStrategy, 0, param, 1440, l.dateType == 1 ? workdayMaxMoney : holidayMaxMoney)) != null && m.doubleValue() > 0.0) {
                    mMoney = mMoney.add(m);
                }
                ++i;
            }
        }
        return mMoney;
    }

    @Deprecated
    protected BigDecimal calByDayType1(BigDecimal workdayMaxMoney, List<CarparkChargeSegmentRule> workDaySegmentRuleList, BigDecimal holidayMaxMoney, List<CarparkChargeSegmentRule> holidayDaySegmentRuleList, Date startTime, Date endTime, boolean haveFirst, DateTypeSelector dateTypeSelector, int crossStrategy, int holidayBeginMins, int holidayEndMins, boolean haveFreeTimeLen, int firtAndLastWhenSameRuleStrategy, ChargeAlgorithm.ChageParam param) {
        BigDecimal entireMoney;
        block227: {
            boolean hasFirstLen;
            BigDecimal money;
            ArrayList<DayTypeSplitEntry> endDayList;
            ArrayList<DayTypeSplitEntry> firstDayList;
            Calendar cal;
            block228: {
                List<CarparkChargeSegmentRule> segmentRuleList;
                BigDecimal maxMoney;
                block226: {
                    DayTypeSplitEntry entry;
                    boolean crossDay;
                    Date tempEndTime;
                    if (holidayBeginMins <= -1440) {
                        holidayBeginMins = -1439;
                    } else if (holidayBeginMins >= 1440) {
                        holidayBeginMins = 1439;
                    }
                    if (holidayEndMins <= -1440) {
                        holidayEndMins = -1439;
                    } else if (holidayEndMins >= 1440) {
                        holidayEndMins = 1439;
                    }
                    cal = Calendar.getInstance();
                    Date tempBeginDate = this.clearSecond(startTime, cal);
                    Date tempEndDate = this.clearSecond(endTime, cal);
                    Date d1 = this.clearTime(startTime, cal);
                    cal.setTime(d1);
                    cal.add(5, 1);
                    Date tempDate2 = cal.getTime();
                    cal.add(5, -2);
                    Date enterPreDate = cal.getTime();
                    firstDayList = new ArrayList<DayTypeSplitEntry>(3);
                    endDayList = null;
                    entireMoney = ZERO;
                    int enterDateType = dateTypeSelector.getDateType(tempBeginDate);
                    int enterNextDateType = dateTypeSelector.getDateType(tempDate2);
                    int enterPreDateType = dateTypeSelector.getDateType(enterPreDate);
                    if (tempEndDate.getTime() <= tempDate2.getTime()) {
                        tempEndTime = tempEndDate;
                        crossDay = false;
                    } else {
                        tempEndTime = tempDate2;
                        crossDay = true;
                    }
                    if (enterDateType == 1) {
                        Date holidayBegin1 = null;
                        Date holidayEnd1 = null;
                        Date holidayBegin2 = null;
                        if (enterPreDateType == 2 && holidayEndMins > 0) {
                            cal.setTime(d1);
                            cal.add(12, holidayEndMins);
                            holidayEnd1 = cal.getTime();
                            holidayBegin1 = d1;
                        }
                        if (enterNextDateType == 2 && holidayBeginMins < 0) {
                            cal.setTime(tempDate2);
                            cal.add(12, holidayBeginMins);
                            holidayBegin2 = cal.getTime();
                        }
                        if (holidayBegin1 != null && holidayBegin2 != null) {
                            if (holidayBegin2.getTime() <= holidayEnd1.getTime()) {
                                entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                firstDayList.add(entry);
                            } else if (startTime.getTime() < holidayEnd1.getTime()) {
                                if (tempEndTime.getTime() <= holidayEnd1.getTime()) {
                                    entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                } else if (tempEndTime.getTime() <= holidayBegin2.getTime()) {
                                    entry = new DayTypeSplitEntry(startTime, holidayEnd1, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(holidayEnd1, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                } else {
                                    entry = new DayTypeSplitEntry(startTime, holidayEnd1, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(holidayEnd1, holidayBegin2, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(holidayBegin2, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                }
                            } else if (startTime.getTime() < holidayBegin2.getTime()) {
                                if (tempEndTime.getTime() <= holidayBegin2.getTime()) {
                                    entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                } else {
                                    entry = new DayTypeSplitEntry(startTime, holidayBegin2, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(holidayBegin2, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                }
                            } else {
                                entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                firstDayList.add(entry);
                            }
                        } else if (holidayBegin1 != null && holidayBegin2 == null) {
                            if (startTime.getTime() < holidayEnd1.getTime()) {
                                if (tempEndTime.getTime() <= holidayEnd1.getTime()) {
                                    entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                } else {
                                    entry = new DayTypeSplitEntry(startTime, holidayEnd1, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(holidayEnd1, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                }
                            } else {
                                entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                firstDayList.add(entry);
                            }
                        } else if (holidayBegin1 == null && holidayBegin2 != null) {
                            if (startTime.getTime() < holidayBegin2.getTime()) {
                                if (tempEndTime.getTime() <= holidayBegin2.getTime()) {
                                    entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                } else {
                                    entry = new DayTypeSplitEntry(startTime, holidayBegin2, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(holidayBegin2, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                }
                            } else {
                                entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                firstDayList.add(entry);
                            }
                        } else {
                            entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                            firstDayList.add(entry);
                        }
                    } else {
                        Date workDayBegin1 = null;
                        Date workDayEnd1 = null;
                        Date workDayBegin2 = null;
                        if (enterPreDateType == 1 && holidayBeginMins > 0) {
                            cal.setTime(d1);
                            cal.add(12, holidayBeginMins);
                            workDayBegin1 = d1;
                            workDayEnd1 = cal.getTime();
                        }
                        if (enterNextDateType == 1 && holidayEndMins < 0) {
                            cal.setTime(tempDate2);
                            cal.add(12, holidayEndMins);
                            workDayBegin2 = cal.getTime();
                        }
                        if (workDayBegin1 != null && workDayBegin2 != null) {
                            if (workDayBegin2.getTime() <= workDayEnd1.getTime()) {
                                entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                firstDayList.add(entry);
                            } else if (startTime.getTime() < workDayEnd1.getTime()) {
                                if (tempEndTime.getTime() <= workDayEnd1.getTime()) {
                                    entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                } else if (tempEndTime.getTime() <= workDayBegin2.getTime()) {
                                    entry = new DayTypeSplitEntry(startTime, workDayEnd1, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(workDayEnd1, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                } else {
                                    entry = new DayTypeSplitEntry(startTime, workDayEnd1, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(workDayEnd1, workDayBegin2, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(workDayBegin2, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                }
                            } else if (startTime.getTime() < workDayBegin2.getTime()) {
                                if (tempEndTime.getTime() <= workDayBegin2.getTime()) {
                                    entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                } else {
                                    entry = new DayTypeSplitEntry(startTime, workDayBegin2, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(workDayBegin2, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                }
                            } else {
                                entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                firstDayList.add(entry);
                            }
                        } else if (workDayBegin1 != null && workDayBegin2 == null) {
                            if (startTime.getTime() < workDayEnd1.getTime()) {
                                if (tempEndTime.getTime() <= workDayEnd1.getTime()) {
                                    entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                } else {
                                    entry = new DayTypeSplitEntry(startTime, workDayEnd1, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(workDayEnd1, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                }
                            } else {
                                entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                firstDayList.add(entry);
                            }
                        } else if (workDayBegin1 == null && workDayBegin2 != null) {
                            if (startTime.getTime() < workDayBegin2.getTime()) {
                                if (tempEndTime.getTime() <= workDayBegin2.getTime()) {
                                    entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                } else {
                                    entry = new DayTypeSplitEntry(startTime, workDayBegin2, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    firstDayList.add(entry);
                                    entry = new DayTypeSplitEntry(workDayBegin2, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    firstDayList.add(entry);
                                }
                            } else {
                                entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                firstDayList.add(entry);
                            }
                        } else {
                            entry = new DayTypeSplitEntry(startTime, crossDay ? tempEndTime : endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                            firstDayList.add(entry);
                        }
                    }
                    if (crossDay) {
                        int remianMins = (int)TimeUnit.MILLISECONDS.toMinutes(tempEndDate.getTime() - tempDate2.getTime());
                        int crossDays = remianMins / 1440;
                        int remain = remianMins % 1440;
                        if (remain > 0) {
                            DayTypeSplitEntry entry2;
                            Date endDateBegin = this.clearTime(tempEndDate, cal);
                            int endDayType = dateTypeSelector.getDateType(endDateBegin);
                            cal.setTime(tempEndDate);
                            cal.add(5, -1);
                            int endPreDayType = dateTypeSelector.getDateType(cal.getTime());
                            cal.add(5, 2);
                            Date endNextDate = cal.getTime();
                            int endNextDayType = dateTypeSelector.getDateType(endNextDate);
                            endDayList = new ArrayList<DayTypeSplitEntry>(3);
                            if (endDayType == 1) {
                                Date holidayBegin1 = null;
                                Date holidayEnd1 = null;
                                Date holidayBegin2 = null;
                                if (endPreDayType == 2 && holidayEndMins > 0) {
                                    cal.setTime(endDateBegin);
                                    cal.add(12, holidayEndMins);
                                    holidayBegin1 = endDateBegin;
                                    holidayEnd1 = cal.getTime();
                                }
                                if (endNextDayType == 2 && holidayBeginMins < 0) {
                                    cal.setTime(endNextDate);
                                    cal.add(12, holidayBeginMins);
                                    holidayBegin2 = cal.getTime();
                                }
                                if (holidayBegin1 != null && holidayBegin2 != null) {
                                    if (holidayBegin2.getTime() <= holidayEnd1.getTime()) {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                    } else if (tempEndDate.getTime() <= holidayEnd1.getTime()) {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                    } else if (tempEndDate.getTime() <= holidayBegin2.getTime()) {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, holidayEnd1, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                        entry2 = new DayTypeSplitEntry(holidayEnd1, endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                    } else {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, holidayEnd1, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                        entry2 = new DayTypeSplitEntry(holidayEnd1, holidayBegin2, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                        entry2 = new DayTypeSplitEntry(holidayBegin2, endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                    }
                                } else if (holidayBegin1 != null && holidayBegin2 == null) {
                                    if (tempEndDate.getTime() <= holidayEnd1.getTime()) {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                    } else {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, holidayEnd1, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                        entry2 = new DayTypeSplitEntry(holidayEnd1, endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                    }
                                } else if (holidayBegin1 == null && holidayBegin2 != null) {
                                    if (tempEndDate.getTime() <= holidayBegin2.getTime()) {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                    } else {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, holidayBegin2, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                        entry2 = new DayTypeSplitEntry(holidayBegin2, endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                    }
                                } else {
                                    entry2 = new DayTypeSplitEntry(endDateBegin, endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                    endDayList.add(entry2);
                                }
                            } else {
                                Date workDayBegin1 = null;
                                Date workDayEnd1 = null;
                                Date workDayBegin2 = null;
                                if (endPreDayType == 1 && holidayBeginMins > 0) {
                                    cal.setTime(endDateBegin);
                                    cal.add(12, holidayBeginMins);
                                    workDayBegin1 = endDateBegin;
                                    workDayEnd1 = cal.getTime();
                                }
                                if (endNextDayType == 1 && holidayEndMins < 0) {
                                    cal.setTime(endNextDate);
                                    cal.add(12, holidayEndMins);
                                    workDayBegin2 = cal.getTime();
                                }
                                if (workDayBegin1 != null && workDayBegin2 != null) {
                                    if (workDayBegin2.getTime() <= workDayEnd1.getTime()) {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                    } else if (tempEndDate.getTime() <= workDayEnd1.getTime()) {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                    } else if (tempEndDate.getTime() <= workDayBegin2.getTime()) {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, workDayEnd1, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                        entry2 = new DayTypeSplitEntry(workDayEnd1, endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                    } else {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, workDayEnd1, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                        entry2 = new DayTypeSplitEntry(workDayEnd1, workDayBegin2, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                        entry2 = new DayTypeSplitEntry(workDayBegin2, endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                    }
                                } else if (workDayBegin1 != null && workDayBegin2 == null) {
                                    if (tempEndDate.getTime() <= workDayEnd1.getTime()) {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                    } else {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, workDayEnd1, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                        entry2 = new DayTypeSplitEntry(workDayEnd1, endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                    }
                                } else if (workDayBegin1 == null && workDayBegin2 != null) {
                                    if (tempEndDate.getTime() <= workDayBegin2.getTime()) {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                    } else {
                                        entry2 = new DayTypeSplitEntry(endDateBegin, workDayBegin2, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                        endDayList.add(entry2);
                                        entry2 = new DayTypeSplitEntry(workDayBegin2, endTime, 1, workDaySegmentRuleList, workdayMaxMoney);
                                        endDayList.add(entry2);
                                    }
                                } else {
                                    entry2 = new DayTypeSplitEntry(endDateBegin, endTime, 2, holidayDaySegmentRuleList, holidayMaxMoney);
                                    endDayList.add(entry2);
                                }
                            }
                        }
                        if (crossDays > 0) {
                            Date currentDate = tempDate2;
                            cal.setTime(currentDate);
                            int currentDateType = dateTypeSelector.getDateType(currentDate);
                            cal.add(6, -1);
                            int preDateType = dateTypeSelector.getDateType(cal.getTime());
                            cal.add(6, 2);
                            Date nextDateTime = cal.getTime();
                            int nextDateType = dateTypeSelector.getDateType(nextDateTime);
                            int i = 0;
                            while (i < crossDays) {
                                BigDecimal money3;
                                Object money2;
                                BigDecimal money22;
                                BigDecimal money32;
                                BigDecimal money1;
                                Date chargeBeginTime1 = currentDate;
                                Date chargeEndTime1 = null;
                                Date chargeBeginTime2 = null;
                                Date chargeEndTime2 = nextDateTime;
                                if (currentDateType == 1) {
                                    if (preDateType == 2 && holidayEndMins > 0) {
                                        cal.setTime(currentDate);
                                        cal.add(12, holidayEndMins);
                                        chargeEndTime1 = cal.getTime();
                                    }
                                    if (nextDateType == 2 && holidayBeginMins < 0) {
                                        cal.setTime(nextDateTime);
                                        cal.add(12, holidayBeginMins);
                                        chargeBeginTime2 = cal.getTime();
                                    }
                                    if (chargeEndTime1 != null && chargeBeginTime2 != null) {
                                        if (chargeEndTime1.getTime() >= chargeBeginTime2.getTime()) {
                                            maxMoney = holidayMaxMoney;
                                            segmentRuleList = holidayDaySegmentRuleList;
                                            money1 = this.calMutiSegment(holidayDaySegmentRuleList, chargeBeginTime1, chargeEndTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                            if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money1.doubleValue() > maxMoney.doubleValue()) {
                                                money1 = maxMoney;
                                            }
                                            entireMoney = entireMoney.add(money1);
                                        } else {
                                            segmentRuleList = workDaySegmentRuleList;
                                            maxMoney = workdayMaxMoney;
                                            money32 = this.calMutiSegment(segmentRuleList, chargeEndTime1, chargeBeginTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                            if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money32.doubleValue() > maxMoney.doubleValue()) {
                                                money32 = maxMoney;
                                            }
                                            maxMoney = holidayMaxMoney;
                                            segmentRuleList = holidayDaySegmentRuleList;
                                            if (segmentRuleList.size() == 1) {
                                                cal.setTime(chargeEndTime1);
                                                cal.add(12, (int)TimeUnit.MILLISECONDS.toMinutes(chargeEndTime2.getTime() - chargeBeginTime2.getTime()));
                                                money22 = this.calMutiSegment(segmentRuleList, chargeBeginTime1, cal.getTime(), false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                            } else {
                                                money22 = this.calMutiSegment(segmentRuleList, chargeBeginTime1, chargeEndTime1, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                                money22 = money22.add(this.calMutiSegment(segmentRuleList, chargeBeginTime2, chargeEndTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param));
                                            }
                                            if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money22.doubleValue() > maxMoney.doubleValue()) {
                                                money22 = maxMoney;
                                            }
                                            entireMoney = entireMoney.add(money22).add(money32);
                                        }
                                    } else if (chargeEndTime1 != null && chargeBeginTime2 == null) {
                                        segmentRuleList = holidayDaySegmentRuleList;
                                        maxMoney = holidayMaxMoney;
                                        money2 = this.calMutiSegment(segmentRuleList, chargeBeginTime1, chargeEndTime1, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && ((BigDecimal)money2).doubleValue() > maxMoney.doubleValue()) {
                                            money2 = maxMoney;
                                        }
                                        segmentRuleList = workDaySegmentRuleList;
                                        maxMoney = workdayMaxMoney;
                                        money3 = this.calMutiSegment(segmentRuleList, chargeEndTime1, chargeEndTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money3.doubleValue() > maxMoney.doubleValue()) {
                                            money3 = maxMoney;
                                        }
                                        entireMoney = entireMoney.add((BigDecimal)money2).add(money3);
                                    } else if (chargeEndTime1 == null && chargeBeginTime2 != null) {
                                        segmentRuleList = workDaySegmentRuleList;
                                        maxMoney = workdayMaxMoney;
                                        money32 = this.calMutiSegment(segmentRuleList, chargeBeginTime1, chargeBeginTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money32.doubleValue() > maxMoney.doubleValue()) {
                                            money32 = maxMoney;
                                        }
                                        segmentRuleList = holidayDaySegmentRuleList;
                                        maxMoney = holidayMaxMoney;
                                        money22 = this.calMutiSegment(segmentRuleList, chargeBeginTime2, chargeEndTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money22.doubleValue() > maxMoney.doubleValue()) {
                                            money22 = maxMoney;
                                        }
                                        entireMoney = entireMoney.add(money22).add(money32);
                                    } else {
                                        maxMoney = workdayMaxMoney;
                                        segmentRuleList = workDaySegmentRuleList;
                                        money1 = this.calMutiSegment(segmentRuleList, chargeBeginTime1, chargeEndTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money1.doubleValue() > maxMoney.doubleValue()) {
                                            money1 = maxMoney;
                                        }
                                        entireMoney = entireMoney.add(money1);
                                    }
                                } else {
                                    if (preDateType == 1 && holidayBeginMins > 0) {
                                        cal.setTime(currentDate);
                                        cal.add(12, holidayBeginMins);
                                        chargeEndTime1 = cal.getTime();
                                    }
                                    if (nextDateType == 1 && holidayEndMins < 0) {
                                        cal.setTime(nextDateTime);
                                        cal.add(12, holidayEndMins);
                                        chargeBeginTime2 = cal.getTime();
                                    }
                                    if (chargeEndTime1 != null && chargeBeginTime2 != null) {
                                        if (chargeEndTime1.getTime() >= chargeBeginTime2.getTime()) {
                                            maxMoney = workdayMaxMoney;
                                            segmentRuleList = workDaySegmentRuleList;
                                            money1 = this.calMutiSegment(segmentRuleList, chargeBeginTime1, chargeEndTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                            if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money1.doubleValue() > maxMoney.doubleValue()) {
                                                money1 = maxMoney;
                                            }
                                            entireMoney = entireMoney.add(money1);
                                        } else {
                                            segmentRuleList = holidayDaySegmentRuleList;
                                            maxMoney = holidayMaxMoney;
                                            money32 = this.calMutiSegment(segmentRuleList, chargeEndTime1, chargeBeginTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                            if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money32.doubleValue() > maxMoney.doubleValue()) {
                                                money32 = maxMoney;
                                            }
                                            maxMoney = workdayMaxMoney;
                                            segmentRuleList = workDaySegmentRuleList;
                                            if (segmentRuleList.size() == 1) {
                                                cal.setTime(chargeEndTime1);
                                                cal.add(12, (int)TimeUnit.MILLISECONDS.toMinutes(chargeEndTime2.getTime() - chargeBeginTime2.getTime()));
                                                money22 = this.calMutiSegment(segmentRuleList, chargeBeginTime1, cal.getTime(), false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                            } else {
                                                money22 = this.calMutiSegment(segmentRuleList, chargeBeginTime1, chargeEndTime1, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                                money22 = money22.add(this.calMutiSegment(segmentRuleList, chargeBeginTime2, chargeEndTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param));
                                            }
                                            if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money22.doubleValue() > maxMoney.doubleValue()) {
                                                money22 = maxMoney;
                                            }
                                            entireMoney = entireMoney.add(money22).add(money32);
                                        }
                                    } else if (chargeEndTime1 != null && chargeBeginTime2 == null) {
                                        segmentRuleList = workDaySegmentRuleList;
                                        maxMoney = workdayMaxMoney;
                                        money32 = this.calMutiSegment(segmentRuleList, chargeBeginTime1, chargeEndTime1, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money32.doubleValue() > maxMoney.doubleValue()) {
                                            money32 = maxMoney;
                                        }
                                        segmentRuleList = holidayDaySegmentRuleList;
                                        maxMoney = holidayMaxMoney;
                                        money22 = this.calMutiSegment(segmentRuleList, chargeEndTime1, chargeEndTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money22.doubleValue() > maxMoney.doubleValue()) {
                                            money22 = maxMoney;
                                        }
                                        entireMoney = entireMoney.add(money22).add(money32);
                                    } else if (chargeEndTime1 == null && chargeBeginTime2 != null) {
                                        segmentRuleList = holidayDaySegmentRuleList;
                                        maxMoney = holidayMaxMoney;
                                        money2 = this.calMutiSegment(segmentRuleList, chargeBeginTime1, chargeBeginTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && ((BigDecimal)money2).doubleValue() > maxMoney.doubleValue()) {
                                            money2 = maxMoney;
                                        }
                                        segmentRuleList = workDaySegmentRuleList;
                                        maxMoney = workdayMaxMoney;
                                        money3 = this.calMutiSegment(segmentRuleList, chargeBeginTime2, chargeEndTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money3.doubleValue() > maxMoney.doubleValue()) {
                                            money3 = maxMoney;
                                        }
                                        entireMoney = entireMoney.add((BigDecimal)money2).add(money3);
                                    } else {
                                        segmentRuleList = holidayDaySegmentRuleList;
                                        maxMoney = holidayMaxMoney;
                                        money2 = this.calMutiSegment(segmentRuleList, chargeBeginTime1, chargeEndTime2, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && ((BigDecimal)money2).doubleValue() > maxMoney.doubleValue()) {
                                            money2 = maxMoney;
                                        }
                                        entireMoney = entireMoney.add((BigDecimal)money2);
                                    }
                                }
                                if (++i >= crossDays) break;
                                preDateType = currentDateType;
                                currentDateType = nextDateType;
                                currentDate = nextDateTime;
                                cal.setTime(currentDate);
                                cal.add(6, 1);
                                nextDateTime = cal.getTime();
                                nextDateType = dateTypeSelector.getDateType(nextDateTime);
                            }
                        }
                    }
                    if (endDayList != null && !endDayList.isEmpty()) break block226;
                    if (firstDayList.size() == 1) {
                        DayTypeSplitEntry first = (DayTypeSplitEntry)firstDayList.get(0);
                        maxMoney = first.maxMoney;
                        BigDecimal money1 = this.calMutiSegment(first.ruleList, first.beginDate, first.endDate, haveFirst, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money1.doubleValue() > maxMoney.doubleValue()) {
                            money1 = maxMoney;
                        }
                        entireMoney = entireMoney.add(money1);
                    } else {
                        boolean backHasFirst;
                        boolean fontHasFirst;
                        DayTypeSplitEntry first = (DayTypeSplitEntry)firstDayList.get(0);
                        if (firstDayList.size() == 3 && first.dateType == ((DayTypeSplitEntry)firstDayList.get((int)2)).dateType && first.ruleList.size() == 1) {
                            cal.setTime(first.endDate);
                            int mins = (int)TimeUnit.MILLISECONDS.toMinutes(((DayTypeSplitEntry)firstDayList.get((int)2)).endDate.getTime() - ((DayTypeSplitEntry)firstDayList.get((int)2)).beginDate.getTime());
                            cal.add(12, mins);
                            first.endDate = cal.getTime();
                            firstDayList.remove(2);
                        }
                        if (haveFirst) {
                            if (haveFreeTimeLen) {
                                Integer freeTimeLen;
                                if (first.ruleList.size() == 1) {
                                    freeTimeLen = first.ruleList.get(0).getFree_time_len();
                                } else {
                                    cal.setTime(first.beginDate);
                                    int timeMinutes = cal.get(11) * 60 + cal.get(12);
                                    CarparkChargeSegmentRule segmentRule = this.findSegmentRule(first.ruleList, timeMinutes);
                                    freeTimeLen = segmentRule.getFree_time_len();
                                }
                                if (freeTimeLen == 0 || freeTimeLen <= 0) {
                                    fontHasFirst = true;
                                    backHasFirst = false;
                                } else {
                                    int mins = (int)TimeUnit.MILLISECONDS.toMinutes(first.endDate.getTime() - first.beginDate.getTime());
                                    if (mins <= freeTimeLen) {
                                        fontHasFirst = false;
                                        backHasFirst = true;
                                    } else {
                                        fontHasFirst = true;
                                        backHasFirst = false;
                                    }
                                }
                            } else {
                                fontHasFirst = true;
                                backHasFirst = false;
                            }
                        } else {
                            fontHasFirst = false;
                            backHasFirst = false;
                        }
                        int index = 0;
                        for (DayTypeSplitEntry entry3 : firstDayList) {
                            boolean hasFirst;
                            boolean hasFreeTime;
                            if (index == 0) {
                                hasFreeTime = haveFreeTimeLen;
                                hasFirst = fontHasFirst;
                            } else {
                                hasFreeTime = false;
                                hasFirst = index == 1 ? backHasFirst : false;
                            }
                            maxMoney = entry3.maxMoney;
                            BigDecimal money1 = this.calMutiSegment(entry3.ruleList, entry3.beginDate, entry3.endDate, hasFirst, hasFreeTime, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                            if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money1.doubleValue() > maxMoney.doubleValue()) {
                                money1 = maxMoney;
                            }
                            entireMoney = entireMoney.add(money1);
                            ++index;
                        }
                    }
                    break block227;
                }
                DayTypeSplitEntry entry1 = (DayTypeSplitEntry)firstDayList.get(firstDayList.size() - 1);
                firstDayList.remove(firstDayList.size() - 1);
                if (endDayList.size() == 3 && ((DayTypeSplitEntry)endDayList.get((int)0)).dateType == ((DayTypeSplitEntry)endDayList.get((int)2)).dateType && ((DayTypeSplitEntry)endDayList.get((int)0)).ruleList.size() == 1) {
                    cal.setTime(((DayTypeSplitEntry)endDayList.get((int)0)).endDate);
                    int mins = (int)TimeUnit.MILLISECONDS.toMinutes(((DayTypeSplitEntry)endDayList.get((int)2)).endDate.getTime() - ((DayTypeSplitEntry)endDayList.get((int)2)).beginDate.getTime());
                    cal.add(12, mins);
                    ((DayTypeSplitEntry)endDayList.get((int)0)).endDate = cal.getTime();
                    endDayList.remove(2);
                }
                DayTypeSplitEntry entry2 = (DayTypeSplitEntry)endDayList.get(0);
                endDayList.remove(0);
                Date beginDate1 = entry1.beginDate;
                Date endDate1 = entry1.endDate;
                int dateType1 = entry1.dateType;
                Date beginDate2 = entry2.beginDate;
                Date endDate2 = entry2.endDate;
                int dateType2 = entry2.dateType;
                money = ZERO;
                if (!firstDayList.isEmpty() && !endDayList.isEmpty()) {
                    Iterator it = endDayList.iterator();
                    while (it.hasNext()) {
                        DayTypeSplitEntry entry = (DayTypeSplitEntry)it.next();
                        DayTypeSplitEntry same = null;
                        for (DayTypeSplitEntry e : firstDayList) {
                            if (e.dateType != entry.dateType || e.ruleList.size() != 1) continue;
                            same = e;
                            break;
                        }
                        if (same == null) continue;
                        cal.setTime(same.endDate);
                        int mins = (int)TimeUnit.MILLISECONDS.toMinutes(entry.endDate.getTime() - entry.beginDate.getTime());
                        cal.add(12, mins);
                        same.endDate = cal.getTime();
                        it.remove();
                    }
                }
                if (haveFirst) {
                    if (firstDayList.isEmpty()) {
                        hasFirstLen = haveFirst;
                    } else if (firstDayList.size() == 1) {
                        DayTypeSplitEntry first = (DayTypeSplitEntry)firstDayList.get(0);
                        if (haveFreeTimeLen) {
                            int mins;
                            Integer freeTimeLen;
                            if (first.ruleList.size() == 1) {
                                freeTimeLen = first.ruleList.get(0).getFree_time_len();
                            } else {
                                cal.setTime(first.beginDate);
                                int timeMinutes = cal.get(11) * 60 + cal.get(12);
                                CarparkChargeSegmentRule segmentRule = this.findSegmentRule(first.ruleList, timeMinutes);
                                freeTimeLen = segmentRule.getFree_time_len();
                            }
                            hasFirstLen = freeTimeLen == 0 || freeTimeLen <= 0 ? false : ((mins = (int)TimeUnit.MILLISECONDS.toMinutes(first.endDate.getTime() - first.beginDate.getTime())) <= freeTimeLen ? haveFirst : false);
                        } else {
                            hasFirstLen = false;
                        }
                    } else {
                        hasFirstLen = false;
                    }
                } else {
                    hasFirstLen = false;
                }
                if (dateType1 == dateType2) {
                    if (dateType1 == 1) {
                        segmentRuleList = workDaySegmentRuleList;
                        maxMoney = workdayMaxMoney;
                    } else {
                        segmentRuleList = holidayDaySegmentRuleList;
                        maxMoney = holidayMaxMoney;
                    }
                    int timeLen = (int)(TimeUnit.MILLISECONDS.toMinutes(endDate1.getTime() - beginDate1.getTime()) + TimeUnit.MILLISECONDS.toMinutes(endDate2.getTime() - beginDate2.getTime()));
                    if (timeLen < 0) {
                        timeLen = 0;
                    }
                    Date xtempStart = beginDate1;
                    cal.setTime(xtempStart);
                    cal.add(12, timeLen);
                    Date xtempEnd = cal.getTime();
                    int maxMutiSegmentPeriodLen = 1440;
                    int timeLenMin = timeLen;
                    if (timeLenMin <= maxMutiSegmentPeriodLen) {
                        BigDecimal m = this.calMutiSegment(segmentRuleList, xtempStart, xtempEnd, hasFirstLen, firstDayList.isEmpty() ? haveFreeTimeLen : false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        if (maxMoney != null && m.doubleValue() > maxMoney.doubleValue()) {
                            m = maxMoney;
                        }
                        money = money.add(m);
                    } else {
                        int intPeriod = timeLenMin / maxMutiSegmentPeriodLen;
                        cal.setTime(xtempStart);
                        cal.add(12, maxMutiSegmentPeriodLen);
                        BigDecimal maxMoney1 = this.calMutiSegment(segmentRuleList, xtempStart, cal.getTime(), hasFirstLen, firstDayList.isEmpty() ? haveFreeTimeLen : false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        if (maxMoney != null && maxMoney1.doubleValue() > maxMoney.doubleValue()) {
                            maxMoney1 = maxMoney;
                        }
                        int n = intPeriod * maxMutiSegmentPeriodLen;
                        BigDecimal money0 = maxMoney1;
                        if (--intPeriod > 0) {
                            BigDecimal maxMoney2 = this.calMutiSegment(segmentRuleList, xtempStart, cal.getTime(), false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                            if (maxMoney != null && maxMoney2.doubleValue() > maxMoney.doubleValue()) {
                                maxMoney2 = maxMoney;
                            }
                            money0 = money0.add(maxMoney2.multiply(new BigDecimal(intPeriod)));
                        }
                        if (timeLenMin - n > 0) {
                            cal.setTime(xtempStart);
                            cal.add(12, n);
                            BigDecimal xmaxMoney = this.calMutiSegment(segmentRuleList, cal.getTime(), xtempEnd, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                            if (maxMoney != null && xmaxMoney.doubleValue() > maxMoney.doubleValue()) {
                                xmaxMoney = maxMoney;
                            }
                            money0 = money0.add(xmaxMoney);
                        }
                        money = money.add(money0);
                    }
                } else {
                    BigDecimal maxMoney2;
                    List<CarparkChargeSegmentRule> segmentRuleList2;
                    BigDecimal maxMoney1;
                    List<CarparkChargeSegmentRule> segmentRuleList1;
                    if (dateType1 == 1) {
                        segmentRuleList1 = workDaySegmentRuleList;
                        maxMoney1 = workdayMaxMoney;
                    } else {
                        segmentRuleList1 = holidayDaySegmentRuleList;
                        maxMoney1 = holidayMaxMoney;
                    }
                    if (dateType2 == 1) {
                        segmentRuleList2 = workDaySegmentRuleList;
                        maxMoney2 = workdayMaxMoney;
                    } else {
                        segmentRuleList2 = holidayDaySegmentRuleList;
                        maxMoney2 = holidayMaxMoney;
                    }
                    SegmentEntryData data1 = this.getSegmentEntryData(segmentRuleList1, beginDate1, endDate1, firtAndLastWhenSameRuleStrategy == 0);
                    SegmentEntryData data2 = this.getSegmentEntryData(segmentRuleList2, beginDate2, endDate2, firtAndLastWhenSameRuleStrategy == 0);
                    boolean firstInFreeTime = false;
                    boolean full1 = false;
                    if (haveFreeTimeLen && firstDayList.isEmpty()) {
                        int freeTimeLen;
                        int timeLenMin = (int)TimeUnit.MILLISECONDS.toMinutes(endDate1.getTime() - beginDate1.getTime());
                        int n = freeTimeLen = data1.firstEntry.segementRule.getFree_time_len() == null ? 0 : data1.firstEntry.segementRule.getFree_time_len();
                        if (freeTimeLen < 0) {
                            freeTimeLen = 0;
                        }
                        if (timeLenMin <= freeTimeLen) {
                            firstInFreeTime = true;
                        }
                    }
                    boolean full2 = false;
                    BigDecimal money2 = this.calMutiSegementEntryMoney(data2.firstEntry, data2.intSegementEntryList, data2.lastEntry, firstInFreeTime ? hasFirstLen : false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (maxMoney2 != null && maxMoney2.doubleValue() > 0.0) {
                        boolean bl = full2 = money2.doubleValue() >= maxMoney2.doubleValue();
                        if (full2) {
                            money2 = maxMoney2;
                        }
                    }
                    if (firstInFreeTime) {
                        money = money.add(money2);
                    } else {
                        BigDecimal money1 = this.calMutiSegementEntryMoney(data1.firstEntry, data1.intSegementEntryList, data1.lastEntry, hasFirstLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        if (maxMoney1 != null && maxMoney1.doubleValue() > 0.0) {
                            boolean bl = full1 = money1.doubleValue() >= maxMoney1.doubleValue();
                            if (full1) {
                                money1 = maxMoney1;
                            }
                        }
                        if (full1 || full2) {
                            money = money.add(money1).add(money2);
                        } else if (data1.lastEntry == null) {
                            if (data2.lastEntry == null) {
                                data1.lastEntry = data2.firstEntry;
                                BigDecimal moneyx1 = this.calMutiSegementEntryMoney(data1.firstEntry, data1.intSegementEntryList, data1.lastEntry, hasFirstLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                money = money.add(moneyx1);
                                if (data2.intSegementEntryList != null && !data2.intSegementEntryList.isEmpty()) {
                                    SegementEntry entry = data2.intSegementEntryList.peekFirst();
                                    if (entry.count > 1) {
                                        SegementEntry firstEntry0 = new SegementEntry();
                                        firstEntry0.count = 1;
                                        firstEntry0.segementRule = entry.segementRule;
                                        firstEntry0.periodLen = entry.periodLen;
                                        firstEntry0.timeLenMins = entry.periodLen;
                                        --entry.count;
                                        data2.firstEntry = firstEntry0;
                                    } else {
                                        data2.firstEntry = data2.intSegementEntryList.pollFirst();
                                    }
                                    if (data2.firstEntry != null) {
                                        BigDecimal moneyx2 = this.calMutiSegementEntryMoney(data2.firstEntry, data2.intSegementEntryList, data2.lastEntry, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                        money = money.add(moneyx2);
                                    }
                                }
                            } else {
                                data1.lastEntry = data2.lastEntry;
                                BigDecimal moneyx3 = this.calMutiSegementEntryMoney(data1.firstEntry, data1.intSegementEntryList, data1.lastEntry, hasFirstLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                money = money.add(moneyx3);
                                data2.lastEntry = null;
                                if (data2.firstEntry != null) {
                                    BigDecimal moneyx4 = this.calMutiSegementEntryMoney(data2.firstEntry, data2.intSegementEntryList, data2.lastEntry, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                                    money = money.add(moneyx4);
                                }
                            }
                        } else if (data2.lastEntry == null) {
                            BigDecimal moneyx5 = this.calMutiSegementEntryMoney(data1.firstEntry, data1.intSegementEntryList, data2.firstEntry, hasFirstLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                            money = money.add(moneyx5);
                            BigDecimal moneyx6 = this.calMutiSegementEntryMoney(data1.lastEntry, data2.intSegementEntryList, data2.lastEntry, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                            money = money.add(moneyx6);
                        } else {
                            BigDecimal moneyx7 = this.calMutiSegementEntryMoney(data1.firstEntry, data1.intSegementEntryList, data2.lastEntry, hasFirstLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                            money = money.add(moneyx7);
                            BigDecimal moneyx8 = this.calMutiSegementEntryMoney(data1.lastEntry, data2.intSegementEntryList, data2.firstEntry, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                            money = money.add(moneyx8);
                        }
                    }
                }
                entireMoney = entireMoney.add(money);
                if (!firstDayList.isEmpty()) break block228;
                if (endDayList.isEmpty()) break block227;
                for (DayTypeSplitEntry entry : endDayList) {
                    maxMoney = entry.maxMoney;
                    BigDecimal money1 = this.calMutiSegment(entry.ruleList, entry.beginDate, entry.endDate, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money1.doubleValue() > maxMoney.doubleValue()) {
                        money1 = maxMoney;
                    }
                    entireMoney = entireMoney.add(money1);
                }
                break block227;
            }
            if (!endDayList.isEmpty()) {
                firstDayList.addAll(endDayList);
            }
            money = this.calDayTypeSplitEntry((DayTypeSplitEntry)firstDayList.get(0), hasFirstLen ? false : haveFirst, haveFreeTimeLen, cal, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
            entireMoney = entireMoney.add(money);
            if (firstDayList.size() > 1) {
                int i = 1;
                while (i < firstDayList.size()) {
                    money = this.calDayTypeSplitEntry((DayTypeSplitEntry)firstDayList.get(i), false, false, cal, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    entireMoney = entireMoney.add(money);
                    ++i;
                }
            }
        }
        return entireMoney;
    }

    private BigDecimal calDayTypeSplitEntry(DayTypeSplitEntry entry, boolean haveFirst, boolean haveFreeTime, Calendar cal, int crossStrategy, int firtAndLastWhenSameRuleStrategy, ChargeAlgorithm.ChageParam param) {
        int timeLen = (int)TimeUnit.MILLISECONDS.toMinutes(entry.endDate.getTime() - entry.beginDate.getTime());
        int maxMutiSegmentPeriodLen = 1440;
        Date xtempStart = entry.beginDate;
        Date xtempEnd = entry.endDate;
        int timeLenMin = timeLen;
        BigDecimal maxMoney = entry.maxMoney;
        BigDecimal money = ZERO;
        if (timeLenMin <= maxMutiSegmentPeriodLen) {
            BigDecimal m = this.calMutiSegment(entry.ruleList, xtempStart, xtempEnd, haveFirst, haveFreeTime, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
            if (maxMoney != null && m.doubleValue() > maxMoney.doubleValue()) {
                m = maxMoney;
            }
            money = money.add(m);
        } else {
            int intPeriod = timeLenMin / maxMutiSegmentPeriodLen;
            cal.setTime(xtempStart);
            cal.add(12, maxMutiSegmentPeriodLen);
            BigDecimal maxMoney1 = this.calMutiSegment(entry.ruleList, xtempStart, cal.getTime(), haveFirst, haveFreeTime, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
            if (maxMoney != null && maxMoney1.doubleValue() > maxMoney.doubleValue()) {
                maxMoney1 = maxMoney;
            }
            int n = intPeriod * maxMutiSegmentPeriodLen;
            BigDecimal money0 = maxMoney1;
            if (--intPeriod > 0) {
                BigDecimal maxMoney2 = this.calMutiSegment(entry.ruleList, xtempStart, cal.getTime(), false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                if (maxMoney != null && maxMoney2.doubleValue() > maxMoney.doubleValue()) {
                    maxMoney2 = maxMoney;
                }
                money0 = money0.add(maxMoney2.multiply(new BigDecimal(intPeriod)));
            }
            if (timeLenMin - n > 0) {
                cal.setTime(xtempStart);
                cal.add(12, n);
                BigDecimal xmaxMoney = this.calMutiSegment(entry.ruleList, cal.getTime(), xtempEnd, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                if (maxMoney != null && xmaxMoney.doubleValue() > maxMoney.doubleValue()) {
                    xmaxMoney = maxMoney;
                }
                money0 = money0.add(xmaxMoney);
            }
            money = money.add(money0);
        }
        return money;
    }

    @Deprecated
    protected BigDecimal calByDayType0(BigDecimal workdayMaxMoney, List<CarparkChargeSegmentRule> workDaySegmentRuleList, BigDecimal holidayMaxMoney, List<CarparkChargeSegmentRule> holidayDaySegmentRuleList, Date startTime, Date endTime, boolean haveFirst, DateTypeSelector dateTypeSelector, int crossStrategy, int holidayBeginMins, int holidayEndMins, boolean haveFreeTimeLen, int firtAndLastWhenSameRuleStrategy, ChargeAlgorithm.ChageParam param) {
        Calendar cal = Calendar.getInstance();
        Date tempBeginDate = this.clearSecond(startTime, cal);
        Date tempEndDate = this.clearSecond(endTime, cal);
        Date d1 = this.clearTime(startTime, cal);
        cal.setTime(d1);
        cal.add(5, 1);
        Date tempDate2 = cal.getTime();
        if (tempEndDate.getTime() <= tempDate2.getTime()) {
            BigDecimal money;
            int beginDateType = dateTypeSelector.getDateType(tempBeginDate);
            int nextDateType = dateTypeSelector.getDateType(tempDate2);
            if (holidayBeginMins == 0 && holidayEndMins == 0 || beginDateType == nextDateType) {
                BigDecimal maxMoney;
                List<CarparkChargeSegmentRule> segmentRuleList;
                if (beginDateType == 1) {
                    segmentRuleList = workDaySegmentRuleList;
                    maxMoney = workdayMaxMoney;
                } else {
                    segmentRuleList = holidayDaySegmentRuleList;
                    maxMoney = holidayMaxMoney;
                }
                money = this.calMutiSegment(segmentRuleList, startTime, endTime, haveFirst, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money.doubleValue() > maxMoney.doubleValue()) {
                    money = maxMoney;
                }
            } else if (beginDateType == 1) {
                if (holidayBeginMins >= 0) {
                    List<CarparkChargeSegmentRule> segmentRuleList = workDaySegmentRuleList;
                    BigDecimal maxMoney = workdayMaxMoney;
                    money = this.calMutiSegment(segmentRuleList, startTime, endTime, haveFirst, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money.doubleValue() > maxMoney.doubleValue()) {
                        money = maxMoney;
                    }
                } else {
                    cal.setTime(tempDate2);
                    cal.add(12, holidayBeginMins);
                    Date fenTime = cal.getTime();
                    if (tempBeginDate.getTime() < fenTime.getTime()) {
                        if (tempEndDate.getTime() <= fenTime.getTime()) {
                            List<CarparkChargeSegmentRule> segmentRuleList = workDaySegmentRuleList;
                            BigDecimal maxMoney = workdayMaxMoney;
                            money = this.calMutiSegment(segmentRuleList, startTime, endTime, haveFirst, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                            if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money.doubleValue() > maxMoney.doubleValue()) {
                                money = maxMoney;
                            }
                        } else {
                            boolean backHasFirst;
                            boolean fontHasFirst;
                            List<CarparkChargeSegmentRule> segmentRuleList = workDaySegmentRuleList;
                            BigDecimal maxMoney = workdayMaxMoney;
                            if (haveFirst) {
                                if (haveFreeTimeLen) {
                                    Integer freeTimeLen;
                                    if (segmentRuleList.size() == 1) {
                                        freeTimeLen = segmentRuleList.get(0).getFree_time_len();
                                    } else {
                                        cal.setTime(tempBeginDate);
                                        int timeMinutes = cal.get(11) * 60 + cal.get(12);
                                        CarparkChargeSegmentRule segmentRule = this.findSegmentRule(segmentRuleList, timeMinutes);
                                        freeTimeLen = segmentRule.getFree_time_len();
                                    }
                                    if (freeTimeLen == 0 || freeTimeLen <= 0) {
                                        fontHasFirst = true;
                                        backHasFirst = false;
                                    } else {
                                        int mins = (int)TimeUnit.MILLISECONDS.toMinutes(fenTime.getTime() - startTime.getTime());
                                        if (mins <= freeTimeLen) {
                                            fontHasFirst = false;
                                            backHasFirst = true;
                                        } else {
                                            fontHasFirst = true;
                                            backHasFirst = false;
                                        }
                                    }
                                } else {
                                    fontHasFirst = true;
                                    backHasFirst = false;
                                }
                            } else {
                                fontHasFirst = false;
                                backHasFirst = false;
                            }
                            BigDecimal money1 = this.calMutiSegment(segmentRuleList, startTime, fenTime, fontHasFirst, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                            if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money1.doubleValue() > maxMoney.doubleValue()) {
                                money1 = maxMoney;
                            }
                            segmentRuleList = holidayDaySegmentRuleList;
                            maxMoney = holidayMaxMoney;
                            BigDecimal money2 = this.calMutiSegment(segmentRuleList, fenTime, endTime, backHasFirst, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                            if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money2.doubleValue() > maxMoney.doubleValue()) {
                                money2 = maxMoney;
                            }
                            money = money1.add(money2);
                        }
                    } else {
                        List<CarparkChargeSegmentRule> segmentRuleList = holidayDaySegmentRuleList;
                        BigDecimal maxMoney = holidayMaxMoney;
                        money = this.calMutiSegment(segmentRuleList, startTime, endTime, haveFirst, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money.doubleValue() > maxMoney.doubleValue()) {
                            money = maxMoney;
                        }
                    }
                }
            } else if (holidayEndMins >= 0) {
                List<CarparkChargeSegmentRule> segmentRuleList = holidayDaySegmentRuleList;
                BigDecimal maxMoney = holidayMaxMoney;
                money = this.calMutiSegment(segmentRuleList, startTime, endTime, haveFirst, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money.doubleValue() > maxMoney.doubleValue()) {
                    money = maxMoney;
                }
            } else {
                cal.setTime(tempDate2);
                cal.add(12, holidayEndMins);
                Date fenTime = cal.getTime();
                if (tempBeginDate.getTime() < fenTime.getTime()) {
                    if (tempEndDate.getTime() <= fenTime.getTime()) {
                        List<CarparkChargeSegmentRule> segmentRuleList = holidayDaySegmentRuleList;
                        BigDecimal maxMoney = holidayMaxMoney;
                        money = this.calMutiSegment(segmentRuleList, startTime, endTime, haveFirst, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money.doubleValue() > maxMoney.doubleValue()) {
                            money = maxMoney;
                        }
                    } else {
                        boolean backHasFirst;
                        boolean fontHasFirst;
                        List<CarparkChargeSegmentRule> segmentRuleList = holidayDaySegmentRuleList;
                        BigDecimal maxMoney = holidayMaxMoney;
                        if (haveFirst) {
                            if (haveFreeTimeLen) {
                                Integer freeTimeLen;
                                if (segmentRuleList.size() == 1) {
                                    freeTimeLen = segmentRuleList.get(0).getFree_time_len();
                                } else {
                                    cal.setTime(tempBeginDate);
                                    int timeMinutes = cal.get(11) * 60 + cal.get(12);
                                    CarparkChargeSegmentRule segmentRule = this.findSegmentRule(segmentRuleList, timeMinutes);
                                    freeTimeLen = segmentRule.getFree_time_len();
                                }
                                if (freeTimeLen == 0 || freeTimeLen <= 0) {
                                    fontHasFirst = true;
                                    backHasFirst = false;
                                } else {
                                    int mins = (int)TimeUnit.MILLISECONDS.toMinutes(fenTime.getTime() - startTime.getTime());
                                    if (mins <= freeTimeLen) {
                                        fontHasFirst = false;
                                        backHasFirst = true;
                                    } else {
                                        fontHasFirst = true;
                                        backHasFirst = false;
                                    }
                                }
                            } else {
                                fontHasFirst = true;
                                backHasFirst = false;
                            }
                        } else {
                            fontHasFirst = false;
                            backHasFirst = false;
                        }
                        BigDecimal money1 = this.calMutiSegment(segmentRuleList, startTime, fenTime, fontHasFirst, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money1.doubleValue() > maxMoney.doubleValue()) {
                            money1 = maxMoney;
                        }
                        segmentRuleList = workDaySegmentRuleList;
                        maxMoney = workdayMaxMoney;
                        BigDecimal money2 = this.calMutiSegment(segmentRuleList, fenTime, endTime, backHasFirst, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money2.doubleValue() > maxMoney.doubleValue()) {
                            money2 = maxMoney;
                        }
                        money = money1.add(money2);
                    }
                } else {
                    List<CarparkChargeSegmentRule> segmentRuleList = workDaySegmentRuleList;
                    BigDecimal maxMoney = workdayMaxMoney;
                    money = this.calMutiSegment(segmentRuleList, startTime, endTime, haveFirst, haveFreeTimeLen, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money.doubleValue() > maxMoney.doubleValue()) {
                        money = maxMoney;
                    }
                }
            }
            return money;
        }
        int mins = (int)TimeUnit.MILLISECONDS.toMinutes(tempEndDate.getTime() - tempDate2.getTime());
        Date beginDate1 = tempBeginDate;
        Date endDate1 = tempDate2;
        Date beginDate2 = null;
        Date endDate2 = null;
        BigDecimal money = ZERO;
        if (mins > 1440) {
            Date dx1 = tempDate2;
            cal.setTime(dx1);
            long endTimills = tempEndDate.getTime();
            while (cal.getTimeInMillis() <= endTimills) {
                BigDecimal money2;
                BigDecimal money3;
                Date fenTime;
                BigDecimal money1;
                BigDecimal maxMoney;
                List<CarparkChargeSegmentRule> segmentRuleList;
                cal.add(12, 1440);
                if (cal.getTimeInMillis() >= endTimills) {
                    beginDate2 = dx1;
                    endDate2 = tempEndDate;
                    break;
                }
                Date nextDateTime = cal.getTime();
                int beginDateType = dateTypeSelector.getDateType(dx1);
                int nextDateType = dateTypeSelector.getDateType(nextDateTime);
                if (holidayBeginMins == 0 && holidayEndMins == 0 || beginDateType == nextDateType) {
                    if (beginDateType == 1) {
                        segmentRuleList = workDaySegmentRuleList;
                        maxMoney = workdayMaxMoney;
                    } else {
                        segmentRuleList = holidayDaySegmentRuleList;
                        maxMoney = holidayMaxMoney;
                    }
                    money1 = this.calMutiSegment(segmentRuleList, dx1, nextDateTime, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money1.doubleValue() > maxMoney.doubleValue()) {
                        money1 = maxMoney;
                    }
                } else if (beginDateType == 1) {
                    if (holidayBeginMins >= 0) {
                        segmentRuleList = workDaySegmentRuleList;
                        maxMoney = workdayMaxMoney;
                        money1 = this.calMutiSegment(segmentRuleList, dx1, nextDateTime, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money1.doubleValue() > maxMoney.doubleValue()) {
                            money1 = maxMoney;
                        }
                    } else {
                        cal.setTime(nextDateTime);
                        cal.add(12, holidayBeginMins);
                        fenTime = cal.getTime();
                        cal.setTime(nextDateTime);
                        segmentRuleList = workDaySegmentRuleList;
                        maxMoney = workdayMaxMoney;
                        money3 = this.calMutiSegment(segmentRuleList, dx1, fenTime, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money3.doubleValue() > maxMoney.doubleValue()) {
                            money3 = maxMoney;
                        }
                        segmentRuleList = holidayDaySegmentRuleList;
                        maxMoney = holidayMaxMoney;
                        money2 = this.calMutiSegment(segmentRuleList, fenTime, nextDateTime, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money2.doubleValue() > maxMoney.doubleValue()) {
                            money2 = maxMoney;
                        }
                        money1 = money3.add(money2);
                    }
                } else if (holidayEndMins >= 0) {
                    segmentRuleList = holidayDaySegmentRuleList;
                    maxMoney = holidayMaxMoney;
                    money1 = this.calMutiSegment(segmentRuleList, dx1, nextDateTime, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money1.doubleValue() > maxMoney.doubleValue()) {
                        money1 = maxMoney;
                    }
                } else {
                    cal.setTime(nextDateTime);
                    cal.add(12, holidayEndMins);
                    fenTime = cal.getTime();
                    cal.setTime(nextDateTime);
                    segmentRuleList = holidayDaySegmentRuleList;
                    maxMoney = holidayMaxMoney;
                    money3 = this.calMutiSegment(segmentRuleList, dx1, fenTime, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money3.doubleValue() > maxMoney.doubleValue()) {
                        money3 = maxMoney;
                    }
                    segmentRuleList = workDaySegmentRuleList;
                    maxMoney = workdayMaxMoney;
                    money2 = this.calMutiSegment(segmentRuleList, fenTime, nextDateTime, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (maxMoney != null && maxMoney.doubleValue() >= 0.0 && money2.doubleValue() > maxMoney.doubleValue()) {
                        money2 = maxMoney;
                    }
                    money1 = money3.add(money2);
                }
                money = money.add(money1);
                dx1 = cal.getTime();
            }
        } else {
            beginDate2 = tempDate2;
            endDate2 = tempEndDate;
        }
        int dateType1 = dateTypeSelector.getDateType(beginDate1);
        int dateType2 = dateTypeSelector.getDateType(beginDate2);
        if (dateType1 == dateType2) {
            BigDecimal maxMoney;
            List<CarparkChargeSegmentRule> segmentRuleList;
            if (dateType1 == 1) {
                segmentRuleList = workDaySegmentRuleList;
                maxMoney = workdayMaxMoney;
            } else {
                segmentRuleList = holidayDaySegmentRuleList;
                maxMoney = holidayMaxMoney;
            }
            int timeLen = (int)(TimeUnit.MILLISECONDS.toMinutes(endDate1.getTime() - beginDate1.getTime()) + TimeUnit.MILLISECONDS.toMinutes(endDate2.getTime() - beginDate2.getTime()));
            if (timeLen < 0) {
                timeLen = 0;
            }
            Date xtempStart = beginDate1;
            cal.setTime(xtempStart);
            cal.add(12, timeLen);
            Date xtempEnd = cal.getTime();
            int maxMutiSegmentPeriodLen = 1440;
            int timeLenMin = timeLen;
            if (timeLenMin <= maxMutiSegmentPeriodLen) {
                BigDecimal m = this.calMutiSegment(segmentRuleList, xtempStart, xtempEnd, haveFirst, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                if (maxMoney != null && m.doubleValue() > maxMoney.doubleValue()) {
                    m = maxMoney;
                }
                money = money.add(m);
            } else {
                int intPeriod = timeLenMin / maxMutiSegmentPeriodLen;
                cal.setTime(xtempStart);
                cal.add(12, maxMutiSegmentPeriodLen);
                BigDecimal maxMoney1 = this.calMutiSegment(segmentRuleList, xtempStart, cal.getTime(), haveFirst, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                if (maxMoney != null && maxMoney1.doubleValue() > maxMoney.doubleValue()) {
                    maxMoney1 = maxMoney;
                }
                int n = intPeriod * maxMutiSegmentPeriodLen;
                BigDecimal money0 = maxMoney1;
                if (--intPeriod > 0) {
                    BigDecimal maxMoney2 = this.calMutiSegment(segmentRuleList, xtempStart, cal.getTime(), false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (maxMoney != null && maxMoney2.doubleValue() > maxMoney.doubleValue()) {
                        maxMoney2 = maxMoney;
                    }
                    money0 = money0.add(maxMoney2.multiply(new BigDecimal(intPeriod)));
                }
                if (timeLenMin - n > 0) {
                    cal.setTime(xtempStart);
                    cal.add(12, n);
                    BigDecimal xmaxMoney = this.calMutiSegment(segmentRuleList, cal.getTime(), xtempEnd, false, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    if (maxMoney != null && xmaxMoney.doubleValue() > maxMoney.doubleValue()) {
                        xmaxMoney = maxMoney;
                    }
                    money0 = money0.add(xmaxMoney);
                }
                money = money.add(money0);
            }
        } else {
            BigDecimal maxMoney2;
            List<CarparkChargeSegmentRule> segmentRuleList2;
            BigDecimal maxMoney1;
            List<CarparkChargeSegmentRule> segmentRuleList1;
            if (dateType1 == 1) {
                segmentRuleList1 = workDaySegmentRuleList;
                maxMoney1 = workdayMaxMoney;
            } else {
                segmentRuleList1 = holidayDaySegmentRuleList;
                maxMoney1 = holidayMaxMoney;
            }
            if (dateType2 == 1) {
                segmentRuleList2 = workDaySegmentRuleList;
                maxMoney2 = workdayMaxMoney;
            } else {
                segmentRuleList2 = holidayDaySegmentRuleList;
                maxMoney2 = holidayMaxMoney;
            }
            SegmentEntryData data1 = this.getSegmentEntryData(segmentRuleList1, beginDate1, endDate1, firtAndLastWhenSameRuleStrategy == 0);
            SegmentEntryData data2 = this.getSegmentEntryData(segmentRuleList2, beginDate2, endDate2, firtAndLastWhenSameRuleStrategy == 0);
            boolean full2 = false;
            BigDecimal money2 = this.calMutiSegementEntryMoney(data2.firstEntry, data2.intSegementEntryList, data2.lastEntry, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
            if (maxMoney2 != null && maxMoney2.doubleValue() > 0.0) {
                boolean bl = full2 = money2.doubleValue() >= maxMoney2.doubleValue();
                if (full2) {
                    money2 = maxMoney2;
                }
            }
            boolean full1 = false;
            BigDecimal money1 = this.calMutiSegementEntryMoney(data1.firstEntry, data1.intSegementEntryList, data1.lastEntry, haveFirst, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
            if (maxMoney1 != null && maxMoney1.doubleValue() > 0.0) {
                boolean bl = full1 = money1.doubleValue() >= maxMoney1.doubleValue();
                if (full1) {
                    money1 = maxMoney1;
                }
            }
            if (full1 || full2) {
                money = money.add(money1).add(money2);
            } else if (data1.lastEntry == null) {
                if (data2.lastEntry == null) {
                    data1.lastEntry = data2.firstEntry;
                    BigDecimal moneyx1 = this.calMutiSegementEntryMoney(data1.firstEntry, data1.intSegementEntryList, data1.lastEntry, haveFirst, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    money = money.add(moneyx1);
                    if (data2.intSegementEntryList != null && !data2.intSegementEntryList.isEmpty()) {
                        SegementEntry entry = data2.intSegementEntryList.peekFirst();
                        if (entry.count > 1) {
                            SegementEntry firstEntry0 = new SegementEntry();
                            firstEntry0.count = 1;
                            firstEntry0.segementRule = entry.segementRule;
                            firstEntry0.periodLen = entry.periodLen;
                            firstEntry0.timeLenMins = entry.periodLen;
                            --entry.count;
                            data2.firstEntry = firstEntry0;
                        } else {
                            data2.firstEntry = data2.intSegementEntryList.pollFirst();
                        }
                        if (data2.firstEntry != null) {
                            BigDecimal moneyx2 = this.calMutiSegementEntryMoney(data2.firstEntry, data2.intSegementEntryList, data2.lastEntry, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                            money = money.add(moneyx2);
                        }
                    }
                } else {
                    data1.lastEntry = data2.lastEntry;
                    BigDecimal moneyx3 = this.calMutiSegementEntryMoney(data1.firstEntry, data1.intSegementEntryList, data1.lastEntry, haveFirst, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                    money = money.add(moneyx3);
                    data2.lastEntry = null;
                    if (data2.firstEntry != null) {
                        BigDecimal moneyx4 = this.calMutiSegementEntryMoney(data2.firstEntry, data2.intSegementEntryList, data2.lastEntry, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                        money = money.add(moneyx4);
                    }
                }
            } else if (data2.lastEntry == null) {
                BigDecimal moneyx5 = this.calMutiSegementEntryMoney(data1.firstEntry, data1.intSegementEntryList, data2.firstEntry, haveFirst, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                money = money.add(moneyx5);
                BigDecimal moneyx6 = this.calMutiSegementEntryMoney(data1.lastEntry, data2.intSegementEntryList, data2.lastEntry, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                money = money.add(moneyx6);
            } else {
                BigDecimal moneyx7 = this.calMutiSegementEntryMoney(data1.firstEntry, data1.intSegementEntryList, data2.lastEntry, haveFirst, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                money = money.add(moneyx7);
                BigDecimal moneyx8 = this.calMutiSegementEntryMoney(data1.lastEntry, data2.intSegementEntryList, data2.firstEntry, false, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
                money = money.add(moneyx8);
            }
        }
        return money;
    }

    protected SegmentEntryData getSegmentEntryData(List<CarparkChargeSegmentRule> segmentRuleList, Date startTime, Date endTime, boolean mergeFirtAndLastWhenSameRule) {
        SegementEntry lastEntry = null;
        LinkedList<SegementEntry> intSegementEntryList = new LinkedList<SegementEntry>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        cal.set(14, 0);
        cal.set(13, 0);
        Date tempStartDate = cal.getTime();
        cal.setTime(endTime);
        cal.set(14, 0);
        cal.set(13, 0);
        Date tempEndDate = cal.getTime();
        cal.setTime(tempStartDate);
        int timeMinutes = cal.get(11) * 60 + cal.get(12);
        CarparkChargeSegmentRule segmentRule = this.findSegmentRule(segmentRuleList, timeMinutes);
        SegementEntry firstEntry = new SegementEntry(segmentRule, timeMinutes);
        if (firstEntry.timeLenMins <= 0) {
            throw new IllegalStateException("\u4e0d\u5e94\u8be5\u51fa\u73b0\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5\u8ba1\u8d39\u89c4\u5219\u7b97\u6cd5");
        }
        cal.add(12, firstEntry.timeLenMins);
        tempStartDate = cal.getTime();
        if (tempEndDate.after(tempStartDate)) {
            while (tempEndDate.after(tempStartDate)) {
                SegementEntry exist;
                timeMinutes = cal.get(11) * 60 + cal.get(12);
                segmentRule = this.findSegmentRule(segmentRuleList, timeMinutes);
                SegementEntry entry = new SegementEntry(segmentRule, timeMinutes);
                if (entry.timeLenMins <= 0) {
                    throw new IllegalStateException("\u4e0d\u5e94\u8be5\u51fa\u73b0\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5\u8ba1\u8d39\u89c4\u5219\u7b97\u6cd5");
                }
                cal.add(12, entry.timeLenMins);
                tempStartDate = cal.getTime();
                if (tempEndDate.after(tempStartDate)) {
                    exist = null;
                    for (SegementEntry s : intSegementEntryList) {
                        if (s.segementRule != entry.segementRule) continue;
                        exist = s;
                        break;
                    }
                    if (exist == null) {
                        intSegementEntryList.add(entry);
                        continue;
                    }
                    ++exist.count;
                    continue;
                }
                lastEntry = entry;
                lastEntry.timeLenMins = lastEntry.periodLen - (int)TimeUnit.MILLISECONDS.toMinutes(tempStartDate.getTime() - tempEndDate.getTime());
                if (lastEntry.timeLenMins < 0) {
                    lastEntry.timeLenMins = 0;
                }
                if (lastEntry.periodLen == lastEntry.timeLenMins) {
                    exist = null;
                    for (SegementEntry s : intSegementEntryList) {
                        if (s.segementRule != lastEntry.segementRule) continue;
                        exist = s;
                        break;
                    }
                    if (exist == null) {
                        intSegementEntryList.add(lastEntry);
                    } else {
                        ++exist.count;
                    }
                    lastEntry = null;
                }
                break;
            }
        } else {
            firstEntry.timeLenMins = (int)TimeUnit.MILLISECONDS.toMinutes(endTime.getTime() - startTime.getTime());
            if (firstEntry.timeLenMins > firstEntry.periodLen) {
                firstEntry.timeLenMins = firstEntry.periodLen;
            }
        }
        if (lastEntry != null && mergeFirtAndLastWhenSameRule && lastEntry.segementRule == firstEntry.segementRule) {
            firstEntry.timeLenMins += lastEntry.timeLenMins;
            lastEntry = null;
        }
        SegmentEntryData data = new SegmentEntryData();
        data.firstEntry = firstEntry;
        data.intSegementEntryList = intSegementEntryList;
        data.lastEntry = lastEntry;
        return data;
    }

    protected BigDecimal calMutiSegment(List<CarparkChargeSegmentRule> segmentRuleList, Date startTime, Date endTime, boolean haveFirst, boolean haveFreeTime, int crossStrategy, int firtAndLastWhenSameRuleStrategy, ChargeAlgorithm.ChageParam param) {
        BigDecimal bigDecimal;
        int freeTimeLen;
        SegmentEntryData data = this.getSegmentEntryData(segmentRuleList, startTime, endTime, firtAndLastWhenSameRuleStrategy == 0);
        SegementEntry firstEntry = data.firstEntry;
        SegementEntry lastEntry = data.lastEntry;
        LinkedList<SegementEntry> intSegementEntryList = data.intSegementEntryList;
        int timeLenMin = (int)TimeUnit.MILLISECONDS.toMinutes(endTime.getTime() - startTime.getTime());
        int n = freeTimeLen = firstEntry.segementRule.getFree_time_len() == null ? 0 : firstEntry.segementRule.getFree_time_len();
        if (freeTimeLen < 0) {
            freeTimeLen = 0;
        }
        Integer resetFreeTimeLen = null;
        Integer resetFirstTimeLen = null;
        if (haveFreeTime) {
            int fisrtF;
            if (timeLenMin <= freeTimeLen) {
                return ZERO;
            }
            if (freeTimeLen > 0 && (lastEntry != null || intSegementEntryList != null && !intSegementEntryList.isEmpty()) && (fisrtF = firstEntry.timeLenMins) <= freeTimeLen) {
                int r;
                int remainFreeTimeLen = freeTimeLen - fisrtF;
                if (intSegementEntryList != null && !intSegementEntryList.isEmpty()) {
                    firstEntry = (SegementEntry)intSegementEntryList.get(0);
                    intSegementEntryList.remove(0);
                } else {
                    firstEntry = lastEntry;
                    lastEntry = null;
                }
                resetFreeTimeLen = firstEntry.segementRule.getFree_time_len();
                if (remainFreeTimeLen > 0) {
                    if (resetFreeTimeLen != null && resetFreeTimeLen > 0) {
                        r = resetFreeTimeLen - fisrtF;
                        firstEntry.segementRule.setFree_time_len(r < 0 ? 0 : r);
                    }
                } else {
                    haveFreeTime = false;
                    firstEntry.segementRule.setFree_time_len(0);
                }
                if (firstEntry.segementRule.getCharge_type() == 0 && haveFirst && (resetFirstTimeLen = firstEntry.segementRule.getFirst_time_len()) != null && resetFirstTimeLen > 0) {
                    r = resetFirstTimeLen - fisrtF;
                    firstEntry.segementRule.setFirst_time_len(r < 0 ? 0 : r);
                }
            }
        }
        try {
            bigDecimal = this.calMutiSegementEntryMoney(firstEntry, intSegementEntryList, lastEntry, haveFirst, crossStrategy, firtAndLastWhenSameRuleStrategy, param);
        }
        finally {
            if (resetFreeTimeLen != null) {
                firstEntry.segementRule.setFree_time_len(resetFreeTimeLen);
            }
            if (resetFirstTimeLen != null) {
                firstEntry.segementRule.setFirst_time_len(resetFirstTimeLen);
            }
        }
        return bigDecimal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected BigDecimal calMutiSegementEntryMoney(SegementEntry firstSegementEntry, List<SegementEntry> intSegementEntrys, SegementEntry lastSegementEntry, boolean haveFirst, int crossStrategy, int firtAndLastWhenSameRuleStrategy, ChargeAlgorithm.ChageParam param) {
        BigDecimal moneyx = ZERO;
        SegementEntry firstEntry = firstSegementEntry;
        SegementEntry lastEntry = lastSegementEntry;
        List<SegementEntry> intSegementEntryList = intSegementEntrys;
        if (lastEntry != null) {
            List<CarparkChargeTimeLenRange> rangeList;
            CarparkChargeTimeLenRange range;
            if (lastEntry.segementRule == firstEntry.segementRule) {
                if (firtAndLastWhenSameRuleStrategy == 0) {
                    firstEntry.timeLenMins += lastEntry.timeLenMins;
                    lastEntry = null;
                }
            } else if (lastEntry.segementRule.getCharge_type() == 0) {
                KeyValueEntry<Integer, BigDecimal> firstTimeLenAndMoneyB = this.getFirstTimeLenAndMoney(lastEntry.segementRule, haveFirst);
                KeyValueEntry<Integer, BigDecimal> unitTimeLenAndMoneyB = this.getUnitTimeLenAndMoney(lastEntry.segementRule);
                BigDecimal maxMoneyB = null;
                if (lastEntry.segementRule.getMax_change() != null && lastEntry.segementRule.getMax_change() == 1 && lastEntry.segementRule.getMax_money() != null && lastEntry.segementRule.getMax_money().doubleValue() >= 0.0) {
                    maxMoneyB = lastEntry.segementRule.getMax_money();
                }
                if (((BigDecimal)firstTimeLenAndMoneyB.getValue()).doubleValue() == 0.0 && ((BigDecimal)unitTimeLenAndMoneyB.getValue()).doubleValue() == 0.0 || maxMoneyB != null && maxMoneyB.doubleValue() == 0.0) {
                    lastEntry = null;
                }
            } else if (lastEntry.segementRule.getCharge_type() == 2) {
                if (lastEntry.segementRule.getTimes_money() == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u672a\u5b9a\u4e49!");
                }
                if (lastEntry.segementRule.getTimes_money().doubleValue() <= 0.0) {
                    lastEntry = null;
                }
            } else if (lastEntry.segementRule.getCharge_type() == 1 && (range = (rangeList = this.getChargeTimeLenRangeList(lastEntry.segementRule, lastEntry.periodLen)).get(rangeList.size() - 1)).getMoney().doubleValue() == 0.0) {
                lastEntry = null;
            }
        }
        if (lastEntry == null) {
            if (firstEntry.segementRule.getCharge_type() == 0) {
                moneyx = moneyx.add(this.calSegmentIntervalMoney(firstEntry.segementRule, firstEntry.timeLenMins, firstEntry.periodLen, haveFirst, param));
            } else if (firstEntry.segementRule.getCharge_type() == 1) {
                moneyx = moneyx.add(this.calSegmentTimeLenRangeMoney(firstEntry.segementRule, firstEntry.timeLenMins, firstEntry.periodLen, 1, param));
            } else {
                if (firstEntry.segementRule.getCharge_type() != 2) throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u672a\u77e5\u7684\u8ba1\u8d39\u7c7b\u578b");
                if (firstEntry.segementRule.getTimes_money() == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u672a\u5b9a\u4e49!");
                }
                if (firstEntry.segementRule.getTimes_money().doubleValue() < 0.0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u5b9a\u4e49\u5c0f\u4e8e0! " + firstEntry.segementRule.getTimes_money());
                }
                moneyx = moneyx.add(firstEntry.segementRule.getTimes_money());
                if (firstEntry.timeLenMins > firstEntry.periodLen) {
                    moneyx = moneyx.add(firstEntry.segementRule.getTimes_money());
                }
            }
        } else if (lastEntry.segementRule == firstEntry.segementRule) {
            if (firstEntry.segementRule.getCharge_type() == 0) {
                moneyx = moneyx.add(this.calSegmentIntervalMoney(firstEntry.segementRule, firstEntry.timeLenMins, firstEntry.periodLen, haveFirst, param));
                moneyx = moneyx.add(this.calSegmentIntervalMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, false, param));
            } else if (firstEntry.segementRule.getCharge_type() == 1) {
                moneyx = moneyx.add(this.calSegmentTimeLenRangeMoney(firstEntry.segementRule, firstEntry.timeLenMins, firstEntry.periodLen, 1, param));
                moneyx = moneyx.add(this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, 1, param));
            } else {
                if (firstEntry.segementRule.getCharge_type() != 2) throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u672a\u77e5\u7684\u8ba1\u8d39\u7c7b\u578b");
                if (firstEntry.segementRule.getTimes_money() == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u672a\u5b9a\u4e49!");
                }
                if (firstEntry.segementRule.getTimes_money().doubleValue() < 0.0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u5b9a\u4e49\u5c0f\u4e8e0! " + firstEntry.segementRule.getTimes_money());
                }
                if (lastEntry.segementRule.getTimes_money() == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u672a\u5b9a\u4e49!");
                }
                if (lastEntry.segementRule.getTimes_money().doubleValue() < 0.0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u5b9a\u4e49\u5c0f\u4e8e0! " + lastEntry.segementRule.getTimes_money());
                }
                moneyx = moneyx.add(firstEntry.segementRule.getTimes_money());
                if (firstEntry.timeLenMins > firstEntry.periodLen) {
                    moneyx = moneyx.add(firstEntry.segementRule.getTimes_money());
                }
                moneyx = moneyx.add(lastEntry.segementRule.getTimes_money());
                if (lastEntry.timeLenMins > lastEntry.periodLen) {
                    moneyx = moneyx.add(lastEntry.segementRule.getTimes_money());
                }
            }
        } else if (firstEntry.segementRule.getCharge_type() == 0) {
            if (param != null && param.lessTanAUnit == 0) {
                moneyx = moneyx.add(this.calSegmentIntervalMoney(firstEntry.segementRule, firstEntry.timeLenMins, firstEntry.periodLen, haveFirst, param));
                moneyx = moneyx.add(this.calSegmentIntervalMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, false, param));
            } else {
                int len;
                int co;
                BigDecimal xvmoney = ZERO;
                int remainTimeLen = firstEntry.timeLenMins;
                boolean calFirstS = false;
                KeyValueEntry<Integer, BigDecimal> firstTimeLenAndMoney = this.getFirstTimeLenAndMoney(firstEntry.segementRule, haveFirst);
                KeyValueEntry<Integer, BigDecimal> unitTimeLenAndMoney = this.getUnitTimeLenAndMoney(firstEntry.segementRule);
                BigDecimal maxMoney = null;
                if (firstEntry.segementRule.getMax_change() != null && firstEntry.segementRule.getMax_change() == 1 && firstEntry.segementRule.getMax_money() != null && firstEntry.segementRule.getMax_money().doubleValue() >= 0.0) {
                    maxMoney = firstEntry.segementRule.getMax_money();
                }
                if ((Integer)firstTimeLenAndMoney.getKey() > 0) {
                    if (remainTimeLen >= (Integer)firstTimeLenAndMoney.getKey()) {
                        xvmoney = (BigDecimal)firstTimeLenAndMoney.getValue();
                        calFirstS = true;
                        if ((remainTimeLen -= ((Integer)firstTimeLenAndMoney.getKey()).intValue()) > 0 && (co = remainTimeLen / (Integer)unitTimeLenAndMoney.getKey()) > 0) {
                            xvmoney = xvmoney.add(((BigDecimal)unitTimeLenAndMoney.getValue()).multiply(new BigDecimal(co)));
                            remainTimeLen -= co * (Integer)unitTimeLenAndMoney.getKey();
                        }
                    }
                } else {
                    calFirstS = true;
                    if (remainTimeLen > 0 && (co = remainTimeLen / (Integer)unitTimeLenAndMoney.getKey()) > 0) {
                        xvmoney = xvmoney.add(((BigDecimal)unitTimeLenAndMoney.getValue()).multiply(new BigDecimal(co)));
                        remainTimeLen -= co * (Integer)unitTimeLenAndMoney.getKey();
                    }
                }
                if (!calFirstS) {
                    BigDecimal firstMoney1 = (BigDecimal)firstTimeLenAndMoney.getValue();
                    if (maxMoney != null && firstMoney1.doubleValue() > maxMoney.doubleValue()) {
                        firstMoney1 = maxMoney;
                    }
                    if (lastEntry.segementRule.getCharge_type() == 2) {
                        if (remainTimeLen + lastEntry.timeLenMins > (Integer)firstTimeLenAndMoney.getKey()) {
                            moneyx = moneyx.add(firstMoney1);
                            if (lastEntry.segementRule.getTimes_money() != null && lastEntry.segementRule.getTimes_money().doubleValue() > 0.0) {
                                moneyx = moneyx.add(lastEntry.segementRule.getTimes_money());
                            }
                        } else {
                            moneyx = moneyx.add(firstMoney1);
                        }
                    } else if (lastEntry.segementRule.getCharge_type() == 1) {
                        int len2 = lastEntry.timeLenMins + remainTimeLen;
                        if (len2 > lastEntry.periodLen) {
                            BigDecimal v1 = this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, 1, param);
                            moneyx = moneyx.add(firstMoney1).add(v1);
                        } else if (len2 <= (Integer)firstTimeLenAndMoney.getKey()) {
                            BigDecimal m1 = this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, len2, lastEntry.periodLen, 1, param);
                            if (m1.doubleValue() < firstMoney1.doubleValue()) {
                                m1 = firstMoney1;
                            }
                            moneyx = moneyx.add(m1);
                        } else {
                            List<CarparkChargeTimeLenRange> rangeList = this.getChargeTimeLenRangeList(lastEntry.segementRule, lastEntry.periodLen);
                            CarparkChargeTimeLenRange r = rangeList.get(rangeList.size() - 1);
                            if (lastEntry.timeLenMins >= r.getTime_len()) {
                                moneyx = moneyx.add(r.getMoney()).add(firstMoney1);
                            } else if (len2 == r.getTime_len()) {
                                moneyx = moneyx.add(r.getMoney());
                            } else if (len2 > r.getTime_len()) {
                                BigDecimal v1 = this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, 1, param);
                                moneyx = moneyx.add(firstMoney1).add(v1);
                            } else {
                                BigDecimal m1 = this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, len2, lastEntry.periodLen, 1, param);
                                moneyx = moneyx.add(m1);
                            }
                        }
                    } else {
                        if (lastEntry.segementRule.getCharge_type() != 0) throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u672a\u77e5\u7684\u8ba1\u8d39\u7c7b\u578b");
                        KeyValueEntry<Integer, BigDecimal> firstTimeLenAndMoneyB = this.getFirstTimeLenAndMoney(lastEntry.segementRule, haveFirst);
                        KeyValueEntry<Integer, BigDecimal> unitTimeLenAndMoneyB = this.getUnitTimeLenAndMoney(lastEntry.segementRule);
                        BigDecimal maxMoneyB = null;
                        if (lastEntry.segementRule.getMax_change() != null && lastEntry.segementRule.getMax_change() == 1 && lastEntry.segementRule.getMax_money() != null && lastEntry.segementRule.getMax_money().doubleValue() >= 0.0) {
                            maxMoneyB = lastEntry.segementRule.getMax_money();
                        }
                        if (((BigDecimal)firstTimeLenAndMoney.getValue()).doubleValue() == 0.0 && ((BigDecimal)unitTimeLenAndMoney.getValue()).doubleValue() == 0.0 || maxMoney != null && maxMoney.doubleValue() == 0.0) {
                            moneyx = intSegementEntryList.isEmpty() && (Integer)firstTimeLenAndMoneyB.getKey() > 0 ? moneyx.add(this.calMoney((Integer)firstTimeLenAndMoneyB.getKey(), (BigDecimal)firstTimeLenAndMoneyB.getValue(), (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), lastEntry.timeLenMins, maxMoneyB, param)) : moneyx.add(this.calMoney(null, null, (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), lastEntry.timeLenMins, maxMoneyB, param));
                        } else {
                            BigDecimal firstMoneyB = (BigDecimal)firstTimeLenAndMoneyB.getValue();
                            if (maxMoneyB != null && firstMoneyB.doubleValue() > maxMoneyB.doubleValue()) {
                                firstMoneyB = maxMoneyB;
                            }
                            if ((Integer)firstTimeLenAndMoneyB.getKey() > 0) {
                                if (((Integer)firstTimeLenAndMoneyB.getKey()).intValue() == ((Integer)firstTimeLenAndMoney.getKey()).intValue()) {
                                    if (remainTimeLen + lastEntry.timeLenMins <= (Integer)firstTimeLenAndMoneyB.getKey()) {
                                        moneyx = crossStrategy == 0 ? (firstMoneyB.doubleValue() > firstMoney1.doubleValue() ? moneyx.add(firstMoneyB) : moneyx.add(firstMoney1)) : (crossStrategy == 1 ? (firstMoneyB.doubleValue() < firstMoney1.doubleValue() ? moneyx.add(firstMoneyB) : moneyx.add(firstMoney1)) : (crossStrategy == 2 ? moneyx.add(firstMoneyB) : moneyx.add(firstMoney1)));
                                    } else if (lastEntry.timeLenMins + remainTimeLen > lastEntry.periodLen) {
                                        BigDecimal vl;
                                        int co2 = lastEntry.timeLenMins / (Integer)unitTimeLenAndMoneyB.getKey();
                                        int raminV = lastEntry.timeLenMins;
                                        if (co2 > 0) {
                                            vl = ((BigDecimal)unitTimeLenAndMoneyB.getValue()).multiply(new BigDecimal(co2));
                                            raminV -= co2 * (Integer)unitTimeLenAndMoneyB.getKey();
                                        } else {
                                            vl = ZERO;
                                        }
                                        if (raminV + remainTimeLen > (Integer)firstTimeLenAndMoney.getKey()) {
                                            vl = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                        }
                                        if (maxMoneyB != null && vl.doubleValue() > maxMoneyB.doubleValue()) {
                                            vl = maxMoneyB;
                                        }
                                        vl = vl.add(firstMoney1);
                                        BigDecimal xb = this.calMoney(null, null, (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), lastEntry.timeLenMins + remainTimeLen - (Integer)firstTimeLenAndMoneyB.getKey(), maxMoneyB, param);
                                        xb = xb.add(firstMoney1);
                                        moneyx = crossStrategy == 0 ? (vl.doubleValue() > xb.doubleValue() ? moneyx.add(vl) : moneyx.add(xb)) : (crossStrategy == 1 ? (vl.doubleValue() < xb.doubleValue() ? moneyx.add(vl) : moneyx.add(xb)) : (crossStrategy == 2 ? moneyx.add(vl) : moneyx.add(xb)));
                                    } else {
                                        BigDecimal xb = this.calMoney(null, null, (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), lastEntry.timeLenMins + remainTimeLen - (Integer)firstTimeLenAndMoneyB.getKey(), null, param);
                                        if (maxMoneyB != null) {
                                            if (xb.doubleValue() >= maxMoneyB.doubleValue()) {
                                                moneyx = moneyx.add(maxMoneyB).add(firstMoney1);
                                            } else {
                                                BigDecimal xbb = xb.add(firstMoneyB);
                                                if (xbb.doubleValue() > maxMoneyB.doubleValue()) {
                                                    xbb = maxMoneyB;
                                                }
                                                BigDecimal xbA = xb.add(firstMoney1);
                                                moneyx = crossStrategy == 0 ? (xbA.doubleValue() > xbb.doubleValue() ? moneyx.add(xbA) : moneyx.add(xbb)) : (crossStrategy == 1 ? (xbA.doubleValue() < xbb.doubleValue() ? moneyx.add(xbA) : moneyx.add(xbb)) : (crossStrategy == 2 ? moneyx.add(xbb) : moneyx.add(xbA)));
                                            }
                                        } else {
                                            BigDecimal xbb = xb.add(firstMoneyB);
                                            BigDecimal xbA = xb.add(firstMoney1);
                                            moneyx = crossStrategy == 0 ? (xbA.doubleValue() > xbb.doubleValue() ? moneyx.add(xbA) : moneyx.add(xbb)) : (crossStrategy == 1 ? (xbA.doubleValue() < xbb.doubleValue() ? moneyx.add(xbA) : moneyx.add(xbb)) : (crossStrategy == 2 ? moneyx.add(xbb) : moneyx.add(xbA)));
                                        }
                                    }
                                } else if ((Integer)firstTimeLenAndMoney.getKey() < (Integer)firstTimeLenAndMoneyB.getKey()) {
                                    len = lastEntry.timeLenMins + remainTimeLen;
                                    if (len <= (Integer)firstTimeLenAndMoney.getKey()) {
                                        moneyx = crossStrategy == 0 ? (firstMoneyB.doubleValue() > firstMoney1.doubleValue() ? moneyx.add(firstMoneyB) : moneyx.add(firstMoney1)) : (crossStrategy == 1 ? (firstMoneyB.doubleValue() < firstMoney1.doubleValue() ? moneyx.add(firstMoneyB) : moneyx.add(firstMoney1)) : (crossStrategy == 2 ? moneyx.add(firstMoneyB) : moneyx.add(firstMoney1)));
                                    } else if (len <= (Integer)firstTimeLenAndMoneyB.getKey()) {
                                        BigDecimal xb = this.calMoney(null, null, (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), len - (Integer)firstTimeLenAndMoney.getKey(), maxMoneyB, param);
                                        BigDecimal xAB = firstMoney1.add(xb);
                                        if (crossStrategy == 0) {
                                            if (xAB.doubleValue() < firstMoneyB.doubleValue()) {
                                                xAB = firstMoneyB;
                                            }
                                        } else if (crossStrategy == 1) {
                                            if (xAB.doubleValue() > firstMoneyB.doubleValue()) {
                                                xAB = firstMoneyB;
                                            }
                                        } else if (crossStrategy == 2) {
                                            xAB = firstMoneyB;
                                        }
                                        moneyx = moneyx.add(xAB);
                                    } else if (len > lastEntry.periodLen) {
                                        BigDecimal vl;
                                        int co3 = lastEntry.timeLenMins / (Integer)unitTimeLenAndMoneyB.getKey();
                                        int raminV = lastEntry.timeLenMins;
                                        if (co3 > 0) {
                                            vl = ((BigDecimal)unitTimeLenAndMoneyB.getValue()).multiply(new BigDecimal(co3));
                                            raminV -= co3 * (Integer)unitTimeLenAndMoneyB.getKey();
                                        } else {
                                            vl = ZERO;
                                        }
                                        if (raminV + remainTimeLen > (Integer)firstTimeLenAndMoney.getKey()) {
                                            vl = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                        }
                                        if (maxMoneyB != null && vl.doubleValue() > maxMoneyB.doubleValue()) {
                                            vl = maxMoneyB;
                                        }
                                        vl = vl.add(firstMoney1);
                                        BigDecimal xb = this.calMoney(null, null, (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), len - (Integer)firstTimeLenAndMoney.getKey(), maxMoneyB, param);
                                        xb = xb.add(firstMoney1);
                                        moneyx = crossStrategy == 0 ? (vl.doubleValue() > xb.doubleValue() ? moneyx.add(vl) : moneyx.add(xb)) : (crossStrategy == 1 ? (vl.doubleValue() < xb.doubleValue() ? moneyx.add(vl) : moneyx.add(xb)) : (crossStrategy == 2 ? moneyx.add(vl) : moneyx.add(xb)));
                                    } else {
                                        BigDecimal xb1 = this.calMoney(null, null, (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), len - (Integer)firstTimeLenAndMoney.getKey(), maxMoneyB, param);
                                        xb1 = xb1.add(firstMoney1);
                                        BigDecimal xb2 = this.calMoney((Integer)firstTimeLenAndMoneyB.getKey(), (BigDecimal)firstTimeLenAndMoneyB.getValue(), (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), len, maxMoneyB, param);
                                        moneyx = crossStrategy == 0 ? (xb1.doubleValue() > xb2.doubleValue() ? moneyx.add(xb1) : moneyx.add(xb2)) : (crossStrategy == 1 ? (xb1.doubleValue() < xb2.doubleValue() ? moneyx.add(xb1) : moneyx.add(xb2)) : (crossStrategy == 2 ? moneyx.add(xb2) : moneyx.add(xb1)));
                                    }
                                } else {
                                    len = lastEntry.timeLenMins + remainTimeLen;
                                    if (len <= (Integer)firstTimeLenAndMoneyB.getKey()) {
                                        moneyx = crossStrategy == 0 ? (firstMoneyB.doubleValue() > firstMoney1.doubleValue() ? moneyx.add(firstMoneyB) : moneyx.add(firstMoney1)) : (crossStrategy == 1 ? (firstMoneyB.doubleValue() < firstMoney1.doubleValue() ? moneyx.add(firstMoneyB) : moneyx.add(firstMoney1)) : (crossStrategy == 2 ? moneyx.add(firstMoneyB) : moneyx.add(firstMoney1)));
                                    } else if ((Integer)firstTimeLenAndMoneyB.getKey() <= remainTimeLen) {
                                        BigDecimal vl;
                                        int co4 = lastEntry.timeLenMins / (Integer)unitTimeLenAndMoneyB.getKey();
                                        int raminV = lastEntry.timeLenMins;
                                        if (co4 > 0) {
                                            vl = ((BigDecimal)unitTimeLenAndMoneyB.getValue()).multiply(new BigDecimal(co4));
                                            raminV -= co4 * (Integer)unitTimeLenAndMoneyB.getKey();
                                        } else {
                                            vl = ZERO;
                                        }
                                        if (raminV + remainTimeLen > (Integer)firstTimeLenAndMoney.getKey()) {
                                            vl = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                        }
                                        if (maxMoneyB != null && vl.doubleValue() > maxMoneyB.doubleValue()) {
                                            vl = maxMoneyB;
                                        }
                                        moneyx = moneyx.add(vl).add(firstMoney1);
                                    } else if (len > lastEntry.periodLen) {
                                        BigDecimal vl;
                                        int co5 = lastEntry.timeLenMins / (Integer)unitTimeLenAndMoneyB.getKey();
                                        int raminV = lastEntry.timeLenMins;
                                        if (co5 > 0) {
                                            vl = ((BigDecimal)unitTimeLenAndMoneyB.getValue()).multiply(new BigDecimal(co5));
                                            raminV -= co5 * (Integer)unitTimeLenAndMoneyB.getKey();
                                        } else {
                                            vl = ZERO;
                                        }
                                        if (raminV + remainTimeLen > (Integer)firstTimeLenAndMoney.getKey()) {
                                            vl = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                        }
                                        if (maxMoneyB != null && vl.doubleValue() > maxMoneyB.doubleValue()) {
                                            vl = maxMoneyB;
                                        }
                                        vl = vl.add(firstMoney1);
                                        BigDecimal xb = this.calMoney(null, null, (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), len - (Integer)firstTimeLenAndMoney.getKey(), maxMoneyB, param);
                                        xb = xb.add(firstMoney1);
                                        moneyx = crossStrategy == 0 ? (vl.doubleValue() > xb.doubleValue() ? moneyx.add(vl) : moneyx.add(xb)) : (crossStrategy == 1 ? (vl.doubleValue() < xb.doubleValue() ? moneyx.add(vl) : moneyx.add(xb)) : (crossStrategy == 2 ? moneyx.add(vl) : moneyx.add(xb)));
                                    } else {
                                        BigDecimal xb1;
                                        if (len <= (Integer)firstTimeLenAndMoney.getKey()) {
                                            xb1 = firstMoney1;
                                        } else {
                                            xb1 = this.calMoney(null, null, (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), len - (Integer)firstTimeLenAndMoney.getKey(), maxMoneyB, param);
                                            xb1 = xb1.add(firstMoney1);
                                        }
                                        BigDecimal xb2 = this.calMoney((Integer)firstTimeLenAndMoneyB.getKey(), (BigDecimal)firstTimeLenAndMoneyB.getValue(), (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), len, maxMoneyB, param);
                                        moneyx = crossStrategy == 0 ? (xb1.doubleValue() > xb2.doubleValue() ? moneyx.add(xb1) : moneyx.add(xb2)) : (crossStrategy == 1 ? (xb1.doubleValue() < xb2.doubleValue() ? moneyx.add(xb1) : moneyx.add(xb2)) : (crossStrategy == 2 ? moneyx.add(xb2) : moneyx.add(xb1)));
                                    }
                                }
                            } else {
                                BigDecimal vl;
                                BigDecimal xb1;
                                len = lastEntry.timeLenMins + remainTimeLen;
                                if (len <= (Integer)firstTimeLenAndMoney.getKey()) {
                                    xb1 = firstMoney1;
                                } else {
                                    xb1 = this.calMoney(null, null, (Integer)unitTimeLenAndMoneyB.getKey(), (BigDecimal)unitTimeLenAndMoneyB.getValue(), len - (Integer)firstTimeLenAndMoney.getKey(), maxMoneyB, param);
                                    xb1 = xb1.add(firstMoney1);
                                }
                                int co6 = lastEntry.timeLenMins / (Integer)unitTimeLenAndMoneyB.getKey();
                                int raminV = lastEntry.timeLenMins;
                                if (co6 > 0) {
                                    vl = ((BigDecimal)unitTimeLenAndMoneyB.getValue()).multiply(new BigDecimal(co6));
                                    raminV -= co6 * (Integer)unitTimeLenAndMoneyB.getKey();
                                } else {
                                    vl = ZERO;
                                }
                                if (raminV + remainTimeLen > (Integer)firstTimeLenAndMoney.getKey()) {
                                    vl = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                }
                                if (maxMoneyB != null && vl.doubleValue() > maxMoneyB.doubleValue()) {
                                    vl = maxMoneyB;
                                }
                                vl = vl.add(firstMoney1);
                                moneyx = crossStrategy == 0 ? (xb1.doubleValue() > vl.doubleValue() ? moneyx.add(xb1) : moneyx.add(vl)) : (crossStrategy == 1 ? (xb1.doubleValue() < vl.doubleValue() ? moneyx.add(xb1) : moneyx.add(vl)) : (crossStrategy == 2 ? moneyx.add(vl) : moneyx.add(xb1)));
                            }
                        }
                    }
                } else {
                    int len3;
                    if (maxMoney != null && xvmoney.doubleValue() >= maxMoney.doubleValue()) {
                        xvmoney = maxMoney;
                        remainTimeLen = 0;
                    }
                    if (remainTimeLen <= 0) {
                        moneyx = moneyx.add(xvmoney);
                        if (lastEntry.segementRule.getCharge_type() == 0) {
                            moneyx = moneyx.add(this.calSegmentIntervalMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, false, param));
                        } else if (lastEntry.segementRule.getCharge_type() == 1) {
                            moneyx = moneyx.add(this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, 1, param));
                        } else {
                            if (lastEntry.segementRule.getCharge_type() != 2) throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u672a\u77e5\u7684\u8ba1\u8d39\u7c7b\u578b");
                            if (lastEntry.segementRule.getTimes_money() == null) {
                                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u672a\u5b9a\u4e49!");
                            }
                            if (lastEntry.segementRule.getTimes_money().doubleValue() < 0.0) {
                                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u5b9a\u4e49\u5c0f\u4e8e0! " + lastEntry.segementRule.getTimes_money());
                            }
                            moneyx = moneyx.add(lastEntry.segementRule.getTimes_money());
                        }
                    } else if (lastEntry.segementRule.getCharge_type() == 0) {
                        BigDecimal vl;
                        KeyValueEntry<Integer, BigDecimal> unitTimeLenAndMoneyB = this.getUnitTimeLenAndMoney(lastEntry.segementRule);
                        BigDecimal maxMoneyB = null;
                        if (lastEntry.segementRule.getMax_change() != null && lastEntry.segementRule.getMax_change() == 1 && lastEntry.segementRule.getMax_money() != null && lastEntry.segementRule.getMax_money().doubleValue() >= 0.0) {
                            maxMoneyB = lastEntry.segementRule.getMax_money();
                        }
                        int co7 = lastEntry.timeLenMins / (Integer)unitTimeLenAndMoneyB.getKey();
                        int raminV = lastEntry.timeLenMins;
                        if (co7 > 0) {
                            vl = ((BigDecimal)unitTimeLenAndMoneyB.getValue()).multiply(new BigDecimal(co7));
                            raminV -= co7 * (Integer)unitTimeLenAndMoneyB.getKey();
                        } else {
                            vl = ZERO;
                        }
                        if (maxMoneyB != null && vl.doubleValue() >= maxMoneyB.doubleValue()) {
                            vl = maxMoneyB;
                            raminV = 0;
                        }
                        if (raminV <= 0) {
                            xvmoney = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                            if (maxMoney != null && xvmoney.doubleValue() >= maxMoney.doubleValue()) {
                                xvmoney = maxMoney;
                            }
                            moneyx = moneyx.add(xvmoney).add(vl);
                        } else {
                            len = raminV + remainTimeLen;
                            if (((Integer)unitTimeLenAndMoney.getKey()).intValue() == ((Integer)unitTimeLenAndMoneyB.getKey()).intValue()) {
                                if (len <= (Integer)unitTimeLenAndMoney.getKey()) {
                                    BigDecimal m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                                    if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                        m1 = maxMoney;
                                    }
                                    m1 = m1.add(vl);
                                    BigDecimal m2 = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                    if (maxMoneyB != null && m2.doubleValue() > maxMoneyB.doubleValue()) {
                                        m2 = maxMoneyB;
                                    }
                                    m2 = m2.add(xvmoney);
                                    moneyx = crossStrategy == 0 ? (m1.doubleValue() > m2.doubleValue() ? moneyx.add(m1) : moneyx.add(m2)) : (crossStrategy == 1 ? (m1.doubleValue() < m2.doubleValue() ? moneyx.add(m1) : moneyx.add(m2)) : (crossStrategy == 2 ? moneyx.add(m2) : moneyx.add(m1)));
                                } else {
                                    BigDecimal m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                                    if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                        m1 = maxMoney;
                                    }
                                    BigDecimal m2 = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                    if (maxMoneyB != null && m2.doubleValue() > maxMoneyB.doubleValue()) {
                                        m2 = maxMoneyB;
                                    }
                                    moneyx = moneyx.add(m1).add(m2);
                                }
                            } else if ((Integer)unitTimeLenAndMoney.getKey() > (Integer)unitTimeLenAndMoneyB.getKey()) {
                                if (len <= (Integer)unitTimeLenAndMoneyB.getKey()) {
                                    BigDecimal m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                                    if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                        m1 = maxMoney;
                                    }
                                    m1 = m1.add(vl);
                                    BigDecimal m2 = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                    if (maxMoneyB != null && m2.doubleValue() > maxMoneyB.doubleValue()) {
                                        m2 = maxMoneyB;
                                    }
                                    m2 = m2.add(xvmoney);
                                    moneyx = crossStrategy == 0 ? (m1.doubleValue() > m2.doubleValue() ? moneyx.add(m1) : moneyx.add(m2)) : (crossStrategy == 1 ? (m1.doubleValue() < m2.doubleValue() ? moneyx.add(m1) : moneyx.add(m2)) : (crossStrategy == 2 ? moneyx.add(m2) : moneyx.add(m1)));
                                } else if (len <= (Integer)unitTimeLenAndMoney.getKey()) {
                                    BigDecimal m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                                    if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                        m1 = maxMoney;
                                    }
                                    m1 = m1.add(vl);
                                    moneyx = moneyx.add(m1);
                                } else {
                                    BigDecimal m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                                    if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                        m1 = maxMoney;
                                    }
                                    BigDecimal m2 = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                    if (maxMoneyB != null && m2.doubleValue() > maxMoneyB.doubleValue()) {
                                        m2 = maxMoneyB;
                                    }
                                    moneyx = moneyx.add(m1).add(m2);
                                }
                            } else if (len <= (Integer)unitTimeLenAndMoney.getKey()) {
                                BigDecimal m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                                if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                    m1 = maxMoney;
                                }
                                m1 = m1.add(vl);
                                BigDecimal m2 = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                if (maxMoneyB != null && m2.doubleValue() > maxMoneyB.doubleValue()) {
                                    m2 = maxMoneyB;
                                }
                                m2 = m2.add(xvmoney);
                                moneyx = crossStrategy == 0 ? (m1.doubleValue() > m2.doubleValue() ? moneyx.add(m1) : moneyx.add(m2)) : (crossStrategy == 1 ? (m1.doubleValue() < m2.doubleValue() ? moneyx.add(m1) : moneyx.add(m2)) : (crossStrategy == 2 ? moneyx.add(m2) : moneyx.add(m1)));
                            } else if (len <= (Integer)unitTimeLenAndMoneyB.getKey()) {
                                BigDecimal m2 = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                if (maxMoneyB != null && m2.doubleValue() > maxMoneyB.doubleValue()) {
                                    m2 = maxMoneyB;
                                }
                                m2 = m2.add(xvmoney);
                                moneyx = moneyx.add(m2);
                            } else {
                                BigDecimal m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                                if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                    m1 = maxMoney;
                                }
                                BigDecimal m2 = vl.add((BigDecimal)unitTimeLenAndMoneyB.getValue());
                                if (maxMoneyB != null && m2.doubleValue() > maxMoneyB.doubleValue()) {
                                    m2 = maxMoneyB;
                                }
                                moneyx = moneyx.add(m1).add(m2);
                            }
                        }
                    } else if (lastEntry.segementRule.getCharge_type() == 1) {
                        len3 = lastEntry.timeLenMins + remainTimeLen;
                        if (len3 > lastEntry.periodLen) {
                            BigDecimal v1 = this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, 1, param);
                            BigDecimal m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                            if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                m1 = maxMoney;
                            }
                            v1 = v1.add(m1);
                            moneyx = moneyx.add(v1);
                        } else if (len3 <= (Integer)unitTimeLenAndMoney.getKey()) {
                            BigDecimal m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                            if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                m1 = maxMoney;
                            }
                            BigDecimal m2 = this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, len3, lastEntry.periodLen, 1, param);
                            m2 = m2.add(xvmoney);
                            moneyx = crossStrategy == 0 ? (m1.doubleValue() > m2.doubleValue() ? moneyx.add(m1) : moneyx.add(m2)) : (crossStrategy == 1 ? (m1.doubleValue() < m2.doubleValue() ? moneyx.add(m1) : moneyx.add(m2)) : (crossStrategy == 2 ? moneyx.add(m2) : moneyx.add(m1)));
                        } else {
                            BigDecimal m1;
                            List<CarparkChargeTimeLenRange> rangeList = this.getChargeTimeLenRangeList(lastEntry.segementRule, lastEntry.periodLen);
                            CarparkChargeTimeLenRange r = rangeList.get(rangeList.size() - 1);
                            if (lastEntry.timeLenMins >= r.getTime_len()) {
                                m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                                if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                    m1 = maxMoney;
                                }
                                m1 = m1.add(r.getMoney());
                                moneyx = moneyx.add(m1);
                            } else if (len3 == r.getTime_len()) {
                                m1 = xvmoney.add(r.getMoney());
                                moneyx = moneyx.add(m1);
                            } else if (len3 > r.getTime_len()) {
                                m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                                if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                    m1 = maxMoney;
                                }
                                BigDecimal v1 = this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, 1, param);
                                m1 = m1.add(v1);
                                moneyx = moneyx.add(m1);
                            } else {
                                BigDecimal v1 = this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, len3, lastEntry.periodLen, 1, param);
                                v1 = v1.add(xvmoney);
                                moneyx = moneyx.add(v1);
                            }
                        }
                    } else {
                        if (lastEntry.segementRule.getCharge_type() != 2) throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u672a\u77e5\u7684\u8ba1\u8d39\u7c7b\u578b");
                        len3 = lastEntry.timeLenMins + remainTimeLen;
                        if (moneyx.doubleValue() == 0.0 && len3 <= (Integer)unitTimeLenAndMoney.getKey()) {
                            BigDecimal m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                            if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                m1 = maxMoney;
                            }
                            moneyx = moneyx.add(m1);
                        } else {
                            BigDecimal m1 = xvmoney.add((BigDecimal)unitTimeLenAndMoney.getValue());
                            if (maxMoney != null && m1.doubleValue() > maxMoney.doubleValue()) {
                                m1 = maxMoney;
                            }
                            if (lastEntry.segementRule.getTimes_money() != null && lastEntry.segementRule.getTimes_money().doubleValue() > 0.0) {
                                m1 = m1.add(lastEntry.segementRule.getTimes_money());
                            }
                            moneyx = moneyx.add(m1);
                        }
                    }
                }
            }
        } else if (firstEntry.segementRule.getCharge_type() == 1) {
            if (firstEntry.segementRule.getFirst_time_len() != null && firstEntry.segementRule.getFirst_time_len() > 0 && firstEntry.timeLenMins + lastEntry.timeLenMins <= firstEntry.segementRule.getFirst_time_len() && firstEntry.timeLenMins + lastEntry.timeLenMins <= firstEntry.periodLen) {
                moneyx = moneyx.add(this.calSegmentTimeLenRangeMoney(firstEntry.segementRule, firstEntry.timeLenMins + lastEntry.timeLenMins, firstEntry.periodLen, 1, param));
            } else {
                moneyx = moneyx.add(this.calSegmentTimeLenRangeMoney(firstEntry.segementRule, firstEntry.timeLenMins, firstEntry.periodLen, 1, param));
                if (lastEntry.segementRule.getCharge_type() == 0) {
                    boolean hasFirst = haveFirst;
                    if (hasFirst && moneyx.doubleValue() > 0.0) {
                        hasFirst = false;
                    }
                    moneyx = moneyx.add(this.calSegmentIntervalMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, hasFirst, param));
                } else if (lastEntry.segementRule.getCharge_type() == 1) {
                    moneyx = moneyx.add(this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, 1, param));
                } else {
                    if (lastEntry.segementRule.getCharge_type() != 2) throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u672a\u77e5\u7684\u8ba1\u8d39\u7c7b\u578b");
                    if (lastEntry.segementRule.getTimes_money() == null) {
                        throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u672a\u5b9a\u4e49!");
                    }
                    if (lastEntry.segementRule.getTimes_money().doubleValue() < 0.0) {
                        throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u5b9a\u4e49\u5c0f\u4e8e0! " + lastEntry.segementRule.getTimes_money());
                    }
                    moneyx = moneyx.add(lastEntry.segementRule.getTimes_money());
                }
            }
        } else {
            if (firstEntry.segementRule.getCharge_type() != 2) throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u672a\u77e5\u7684\u8ba1\u8d39\u7c7b\u578b");
            if (firstEntry.segementRule.getFirst_time_len() != null && firstEntry.segementRule.getFirst_time_len() > 0 && firstEntry.segementRule.getTimes_money() != null && firstEntry.segementRule.getTimes_money().doubleValue() > 0.0 && firstEntry.timeLenMins + lastEntry.timeLenMins <= firstEntry.segementRule.getFirst_time_len() && firstEntry.timeLenMins + lastEntry.timeLenMins <= firstEntry.periodLen) {
                moneyx = moneyx.add(firstEntry.segementRule.getTimes_money());
            } else {
                if (firstEntry.segementRule.getTimes_money() != null && firstEntry.segementRule.getTimes_money().doubleValue() > 0.0) {
                    moneyx = moneyx.add(firstEntry.segementRule.getTimes_money());
                }
                if (lastEntry.segementRule.getCharge_type() == 0) {
                    boolean hasFirst = haveFirst;
                    if (hasFirst && moneyx.doubleValue() > 0.0) {
                        hasFirst = false;
                    }
                    moneyx = moneyx.add(this.calSegmentIntervalMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, hasFirst, param));
                } else if (lastEntry.segementRule.getCharge_type() == 1) {
                    moneyx = moneyx.add(this.calSegmentTimeLenRangeMoney(lastEntry.segementRule, lastEntry.timeLenMins, lastEntry.periodLen, 1, param));
                } else {
                    if (lastEntry.segementRule.getCharge_type() != 2) throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u672a\u77e5\u7684\u8ba1\u8d39\u7c7b\u578b");
                    if (lastEntry.segementRule.getTimes_money() == null) {
                        throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u672a\u5b9a\u4e49!");
                    }
                    if (lastEntry.segementRule.getTimes_money().doubleValue() < 0.0) {
                        throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u5b9a\u4e49\u5c0f\u4e8e0! " + lastEntry.segementRule.getTimes_money());
                    }
                    moneyx = moneyx.add(lastEntry.segementRule.getTimes_money());
                }
            }
        }
        if (intSegementEntryList == null || intSegementEntryList.isEmpty()) return moneyx;
        for (SegementEntry entry : intSegementEntryList) {
            if (entry.segementRule.getCharge_type() == 0) {
                moneyx = moneyx.add(this.calSegmentIntervalMoney(entry.segementRule, entry.timeLenMins, entry.periodLen, false, param).multiply(new BigDecimal(entry.count)));
                continue;
            }
            if (entry.segementRule.getCharge_type() == 1) {
                moneyx = moneyx.add(this.calSegmentTimeLenRangeMoney(entry.segementRule, entry.timeLenMins, entry.periodLen, 1, param).multiply(new BigDecimal(entry.count)));
                continue;
            }
            if (entry.segementRule.getCharge_type() != 2) throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u672a\u77e5\u7684\u8ba1\u8d39\u7c7b\u578b");
            if (entry.segementRule.getTimes_money() == null) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u672a\u5b9a\u4e49!");
            }
            if (entry.segementRule.getTimes_money().doubleValue() < 0.0) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u6309\u6b21\u8ba1\u8d39\u7684\u8d39\u7528\u5b9a\u4e49\u5c0f\u4e8e0! " + entry.segementRule.getTimes_money());
            }
            moneyx = moneyx.add(entry.segementRule.getTimes_money().multiply(new BigDecimal(entry.count)));
        }
        return moneyx;
    }

    protected CarparkChargeSegmentRule findSegmentRule(List<CarparkChargeSegmentRule> segmentRuleList, int timeMinutes) {
        for (CarparkChargeSegmentRule r : segmentRuleList) {
            int beginTime = r.getStart_time();
            int endTime = r.getEnd_time();
            if (beginTime < 0) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5206\u6bb5\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e00\u65f600\u5206");
            }
            if (beginTime >= 1440) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5206\u6bb5\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e24\u65f600\u5206");
            }
            if (endTime < 0) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5206\u6bb5\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e00\u65f600\u5206");
            }
            if (endTime > 1440) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5206\u6bb5\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e24\u65f600\u5206");
            }
            if (beginTime == endTime) {
                if (endTime == 0) {
                    endTime = 1440;
                } else {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5206\u6bb5\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u76f8\u7b49");
                }
            }
            if (beginTime == 0 && endTime == 1440) {
                return r;
            }
            if (!(beginTime > endTime ? timeMinutes >= beginTime && timeMinutes < 1440 || timeMinutes < endTime : timeMinutes >= beginTime && timeMinutes < endTime)) continue;
            return r;
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u5408\u9002\u7684\u65f6\u6bb5\u89c4\u5219,\u8bf7\u68c0\u67e5\u8ba1\u8d39\u89c4\u5219\u8bbe\u7f6e\uff01\u6309\u65f6\u95f4\u5206\u6bb5\u89c4\u5219\u5fc5\u987b\u662f\u4e2a\u95ed\u73af, \u6bd4\u5982\u5b9a\u4e49\u4e8608:00-20:00\u7684\u89c4\u5219, \u90a3\u4e48\u5fc5\u987b\u5b9a20:00-08:00\u7684\u65f6\u6bb5\u89c4\u5219!");
    }

    protected List<CarparkChargeTimeLenRange> getChargeTimeLenRangeList(CarparkChargeSegmentRule segementRule, int periodMinuts) {
        if (segementRule.getTimeLenRangeList() == null || segementRule.getTimeLenRangeList().isEmpty()) {
            throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u65f6\u957f\u8303\u56f4\u89c4\u5219\u672a\u5b9a\u4e49!");
        }
        ArrayList<CarparkChargeTimeLenRange> rangeList = new ArrayList<CarparkChargeTimeLenRange>(segementRule.getTimeLenRangeList().size());
        for (CarparkChargeTimeLenRange r : segementRule.getTimeLenRangeList()) {
            if (r.getTime_len() == null) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u65f6\u957f\u8303\u56f4\u89c4\u5219\u6307\u5b9a\u65f6\u957f\u672a\u5b9a\u4e49!");
            }
            if (r.getTime_len() <= 0) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u65f6\u957f\u8303\u56f4\u89c4\u5219\u6307\u5b9a\u65f6\u957f\u5fc5\u987b\u5927\u4e8e0!");
            }
            if (r.getMoney() == null) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u65f6\u957f\u8303\u56f4\u89c4\u5219\u51fa\u73b0\u672a\u5b9a\u4e49\u7684\u8ba1\u8d39\u91d1\u989d!");
            }
            if (r.getMoney().doubleValue() < 0.0) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u65f6\u957f\u8303\u56f4\u89c4\u5219\u51fa\u73b0\u5c0f\u4e8e0\u7684\u8ba1\u8d39\u91d1\u989d!:" + r.getMoney());
            }
            if (r.getTime_len() > periodMinuts) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u65f6\u957f\u8303\u56f4\u89c4\u5219\u51fa\u73b0\u5927\u4e8e\u5468\u671f\u6700\u5927\u65f6\u6bb5\u5b9a\u4e49!:" + r.getMoney());
            }
            rangeList.add(r);
        }
        Collections.sort(rangeList, new Comparator<CarparkChargeTimeLenRange>(){

            @Override
            public int compare(CarparkChargeTimeLenRange o1, CarparkChargeTimeLenRange o2) {
                return o1.getTime_len().compareTo(o2.getTime_len());
            }
        });
        return rangeList;
    }

    protected BigDecimal calSegmentTimeLenRangeMoney(CarparkChargeSegmentRule segementRule, int timeLenMin, Integer period_LenMinus, Integer next_period_strategy, ChargeAlgorithm.ChageParam param) {
        int nextPeriodStrategy;
        int periodLen;
        if (period_LenMinus != null && period_LenMinus > 0) {
            periodLen = period_LenMinus;
        } else {
            if (segementRule.getPeriod_length() == null) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u65f6\u957f\u8303\u56f4\u8ba1\u8d39\u5468\u671f\u672a\u5b9a\u4e49!");
            }
            periodLen = segementRule.getPeriod_length() * 60;
            if (periodLen <= 0) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u65f6\u957f\u8303\u56f4\u8ba1\u8d39\u5468\u671f\u5fc5\u987b\u5927\u4e8e0!");
            }
        }
        if (next_period_strategy == null) {
            if (segementRule.getNext_period_strategy() == null) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u65f6\u957f\u8303\u56f4\u8ba1\u8d39\u7b56\u7565\u672a\u5b9a\u4e49!");
            }
            nextPeriodStrategy = segementRule.getNext_period_strategy();
        } else {
            nextPeriodStrategy = next_period_strategy;
        }
        List<CarparkChargeTimeLenRange> rangeList = this.getChargeTimeLenRangeList(segementRule, periodLen);
        if (timeLenMin <= periodLen) {
            if (segementRule.getRange_take_high() != null && segementRule.getRange_take_high() == 0) {
                CarparkChargeTimeLenRange r1 = null;
                for (CarparkChargeTimeLenRange r : rangeList) {
                    if (timeLenMin < r.getTime_len()) break;
                    if (timeLenMin == r.getTime_len()) {
                        r1 = r;
                        break;
                    }
                    r1 = r;
                }
                if (r1 == null) {
                    return ZERO;
                }
                return r1.getMoney();
            }
            BigDecimal money = null;
            for (CarparkChargeTimeLenRange r : rangeList) {
                if (timeLenMin > r.getTime_len()) continue;
                money = r.getMoney();
                break;
            }
            if (money == null) {
                money = rangeList.get(rangeList.size() - 1).getMoney();
            }
            return money;
        }
        if (nextPeriodStrategy == 2) {
            BigDecimal tmoney = rangeList.get(rangeList.size() - 1).getMoney();
            int remainLen = timeLenMin - periodLen;
            if (segementRule.getUnit_time_len() == null) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u8ba1\u8d39\u5355\u5143\u65f6\u957f\u672a\u5b9a\u4e49!");
            }
            int unitTimeLen = segementRule.getUnit_time_len();
            if (unitTimeLen <= 0) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u8ba1\u8d39\u5355\u5143\u65f6\u957f\u5b9a\u4e49\u5fc5\u987b\u5927\u4e8e0!");
            }
            BigDecimal unitMoney = segementRule.getUnit_time_money();
            if (unitMoney == null) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u8ba1\u8d39\u5355\u5143\u91d1\u989d\u672a\u5b9a\u4e49!");
            }
            if (unitMoney.doubleValue() < 0.0) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u8ba1\u8d39\u5355\u5143\u91d1\u989d\u5b9a\u4e49\u5c0f\u4e8e0! " + unitMoney);
            }
            if (segementRule.getMax_change() != null && segementRule.getMax_change() == 1) {
                if (segementRule.getMax_hours() == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u6700\u9ad8\u65f6\u957f\u672a\u5b9a\u4e49");
                }
                int max_mintes = segementRule.getMax_hours() * 60;
                if (max_mintes <= 0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u6700\u9ad8\u65f6\u957f\u5fc5\u987b\u5927\u4e8e0!");
                }
                BigDecimal defineMaxMoney = segementRule.getMax_money();
                if (defineMaxMoney == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u65f6\u957f\u5185\u6700\u9ad8\u91d1\u989d\u672a\u5b9a\u4e49!");
                }
                if (defineMaxMoney.doubleValue() < 0.0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u65f6\u957f\u5185\u6700\u9ad8\u91d1\u989d\u5b9a\u4e49\u5c0f\u4e8e0!");
                }
                if (remainLen <= max_mintes) {
                    BigDecimal money = this.calMoney(null, null, unitTimeLen, unitMoney, remainLen, defineMaxMoney, param);
                    tmoney = tmoney.add(money);
                } else {
                    int n = remainLen / max_mintes;
                    BigDecimal nmoney = this.calMoney(null, null, unitTimeLen, unitMoney, max_mintes, defineMaxMoney, param);
                    tmoney = tmoney.add(nmoney.multiply(new BigDecimal(n)));
                    int rmin = remainLen % max_mintes;
                    if (rmin > 0) {
                        BigDecimal rmoney = this.calMoney(null, null, unitTimeLen, unitMoney, rmin, defineMaxMoney, param);
                        tmoney = tmoney.add(rmoney);
                    }
                }
            } else {
                BigDecimal money = this.calMoney(null, null, unitTimeLen, unitMoney, remainLen, null, param);
                tmoney = tmoney.add(money);
            }
            return tmoney;
        }
        BigDecimal tmoney = rangeList.get(rangeList.size() - 1).getMoney();
        int n = timeLenMin / periodLen;
        tmoney = tmoney.multiply(new BigDecimal(n));
        int rmin = timeLenMin % periodLen;
        if (rmin > 0) {
            if (segementRule.getRange_take_high() != null && segementRule.getRange_take_high() == 0) {
                CarparkChargeTimeLenRange r1 = null;
                for (CarparkChargeTimeLenRange r : rangeList) {
                    if (rmin < r.getTime_len()) break;
                    if (rmin == r.getTime_len()) {
                        r1 = r;
                        break;
                    }
                    r1 = r;
                }
                if (r1 != null) {
                    tmoney = tmoney.add(r1.getMoney());
                }
            } else {
                BigDecimal money = null;
                for (CarparkChargeTimeLenRange r : rangeList) {
                    if (rmin > r.getTime_len()) continue;
                    money = r.getMoney();
                    break;
                }
                if (money == null) {
                    money = rangeList.get(rangeList.size() - 1).getMoney();
                }
                tmoney = tmoney.add(money);
            }
        }
        return tmoney;
    }

    protected CarparkChargeSegmentRule findSegmentRule(List<CarparkChargeSegmentRule> ruleList, Date startTime) {
        if (ruleList.size() == 1) {
            return ruleList.get(0);
        }
        Calendar cal = Calendar.getInstance();
        Date tempStartDate = this.clearSecond(startTime, cal);
        cal.setTime(tempStartDate);
        int timeMinutes = cal.get(11) * 60 + cal.get(12);
        return this.findSegmentRule(ruleList, timeMinutes);
    }

    protected int getFreeTimeLength(List<CarparkChargeSegmentRule> ruleList, Date startTime) {
        Integer freeTimeLen = this.findSegmentRule(ruleList, startTime).getFree_time_len();
        return freeTimeLen == null ? 0 : freeTimeLen;
    }

    protected KeyValueEntry<Integer, BigDecimal> getFirstTimeLenAndMoney(CarparkChargeSegmentRule segementRule, boolean haveFirst) {
        int firstTimeLen;
        if (!haveFirst) {
            return new KeyValueEntry((Object)0, (Object)ZERO);
        }
        int n = firstTimeLen = segementRule.getFirst_time_len() == null ? 0 : segementRule.getFirst_time_len();
        if (firstTimeLen < 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u9996\u6bb5\u65f6\u957f\u5b9a\u4e49\u5c0f\u4e8e0!");
        }
        BigDecimal firstMoney = segementRule.getFirst_time_money();
        if (firstMoney.doubleValue() < 0.0) {
            throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u9996\u6bb5\u91d1\u989d\u5b9a\u4e49\u5c0f\u4e8e0! " + firstMoney);
        }
        if (firstTimeLen == 0) {
            firstMoney = ZERO;
        }
        return new KeyValueEntry((Object)firstTimeLen, (Object)firstMoney);
    }

    protected KeyValueEntry<Integer, BigDecimal> getUnitTimeLenAndMoney(CarparkChargeSegmentRule segementRule) {
        if (segementRule.getUnit_time_len() == null) {
            throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u8ba1\u8d39\u5355\u5143\u65f6\u957f\u672a\u5b9a\u4e49!");
        }
        int unitTimeLen = segementRule.getUnit_time_len();
        if (unitTimeLen <= 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u8ba1\u8d39\u5355\u5143\u65f6\u957f\u5b9a\u4e49\u5fc5\u987b\u5927\u4e8e0!");
        }
        BigDecimal unitMoney = segementRule.getUnit_time_money();
        if (unitMoney == null) {
            throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u8ba1\u8d39\u5355\u5143\u91d1\u989d\u672a\u5b9a\u4e49!");
        }
        if (unitMoney.doubleValue() < 0.0) {
            throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u8ba1\u8d39\u5355\u5143\u91d1\u989d\u5b9a\u4e49\u5c0f\u4e8e0! " + unitMoney);
        }
        return new KeyValueEntry((Object)unitTimeLen, (Object)unitMoney);
    }

    protected BigDecimal calSegmentIntervalMoney(CarparkChargeSegmentRule segementRule, int timeLenMin, Integer periodMinuts, boolean haveFirst, ChargeAlgorithm.ChageParam param) {
        KeyValueEntry<Integer, BigDecimal> firstTimeLenAndMoney = this.getFirstTimeLenAndMoney(segementRule, haveFirst);
        int firstTimeLen = (Integer)firstTimeLenAndMoney.getKey();
        BigDecimal firstMoney = (BigDecimal)firstTimeLenAndMoney.getValue();
        KeyValueEntry<Integer, BigDecimal> unitTimeLenAndMoney = this.getUnitTimeLenAndMoney(segementRule);
        int unitTimeLen = (Integer)unitTimeLenAndMoney.getKey();
        BigDecimal unitMoney = (BigDecimal)unitTimeLenAndMoney.getValue();
        if (segementRule.getMax_change() != null && segementRule.getMax_change() == 1) {
            int rmin;
            BigDecimal firstMaxMoney;
            int max_mintes;
            if (periodMinuts != null && periodMinuts > 0) {
                max_mintes = periodMinuts;
            } else {
                if (segementRule.getMax_hours() == null) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u6700\u9ad8\u65f6\u957f\u672a\u5b9a\u4e49");
                }
                max_mintes = segementRule.getMax_hours() * 60;
                if (max_mintes <= 0) {
                    throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u6700\u9ad8\u65f6\u957f\u5fc5\u987b\u5927\u4e8e0!");
                }
            }
            BigDecimal defineMaxMoney = segementRule.getMax_money();
            if (defineMaxMoney == null) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u65f6\u957f\u5185\u6700\u9ad8\u91d1\u989d\u672a\u5b9a\u4e49!");
            }
            if (defineMaxMoney.doubleValue() < 0.0) {
                throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5468\u671f\u65f6\u957f\u5185\u6700\u9ad8\u91d1\u989d\u5b9a\u4e49\u5c0f\u4e8e0!");
            }
            if (timeLenMin <= max_mintes) {
                return this.calMoney(firstTimeLen, firstMoney, unitTimeLen, unitMoney, timeLenMin, defineMaxMoney, param);
            }
            int n = timeLenMin / max_mintes;
            BigDecimal money = firstMaxMoney = this.calMoney(firstTimeLen, firstMoney, unitTimeLen, unitMoney, max_mintes, defineMaxMoney, param);
            if (--n > 0) {
                BigDecimal nmoney = this.calMoney(null, null, unitTimeLen, unitMoney, max_mintes, defineMaxMoney, param);
                money = money.add(nmoney.multiply(new BigDecimal(n)));
            }
            if ((rmin = timeLenMin % max_mintes) > 0) {
                BigDecimal rmoney = this.calMoney(null, null, unitTimeLen, unitMoney, rmin, defineMaxMoney, param);
                money = money.add(rmoney);
            }
            return money;
        }
        return this.calMoney(firstTimeLen, firstMoney, unitTimeLen, unitMoney, timeLenMin, null, param);
    }

    protected BigDecimal calMoney(Integer firstTimeLen, BigDecimal firstMoney, int unitTimeLen, BigDecimal unitMoney, int calmintes, BigDecimal defineMaxMoney, ChargeAlgorithm.ChageParam param) {
        BigDecimal money;
        int remainTimeLen;
        if (calmintes <= 0) {
            return ZERO;
        }
        if (firstTimeLen != null) {
            remainTimeLen = calmintes - firstTimeLen;
            money = firstMoney;
        } else {
            remainTimeLen = calmintes;
            money = ZERO;
        }
        if (remainTimeLen > 0) {
            int x;
            if (unitTimeLen <= 0) {
                x = 0;
            } else {
                int lessTanAUnit;
                int n = lessTanAUnit = param == null ? 1 : param.lessTanAUnit;
                x = lessTanAUnit == 0 ? remainTimeLen / unitTimeLen : (remainTimeLen % unitTimeLen == 0 ? remainTimeLen / unitTimeLen : remainTimeLen / unitTimeLen + 1);
            }
            BigDecimal xMoney = unitMoney.multiply(new BigDecimal(x));
            money = money.add(xMoney);
        }
        if (defineMaxMoney == null) {
            return money;
        }
        if (money.doubleValue() > defineMaxMoney.doubleValue()) {
            return defineMaxMoney;
        }
        return money;
    }

    protected static class DayTypeSplitEntry {
        protected Date beginDate;
        protected Date endDate;
        protected int dateType;
        protected List<CarparkChargeSegmentRule> ruleList;
        protected BigDecimal maxMoney;

        public DayTypeSplitEntry(Date beginDate, Date endDate, int dateType, List<CarparkChargeSegmentRule> ruleList, BigDecimal maxMoney) {
            this.beginDate = beginDate;
            this.endDate = endDate;
            this.dateType = dateType;
            this.ruleList = ruleList;
            this.maxMoney = maxMoney;
        }
    }

    protected static class SegementEntry {
        public CarparkChargeSegmentRule segementRule;
        public int periodLen;
        public int timeLenMins;
        public int count;

        protected SegementEntry() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public SegementEntry(CarparkChargeSegmentRule segementRule, int timeMinutes) {
            this.segementRule = segementRule;
            int beginTime = segementRule.getStart_time();
            int endTime = segementRule.getEnd_time();
            if (beginTime == endTime) {
                if (endTime != 0) throw new IllegalArgumentException("\u9519\u8bef\u5b9a\u4e49,\u5206\u6bb5\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u76f8\u7b49");
                endTime = 1440;
            }
            this.periodLen = beginTime > endTime ? 1440 - beginTime + endTime : endTime - beginTime;
            if (this.periodLen <= 0) {
                throw new IllegalStateException();
            }
            this.count = 1;
            if (beginTime > endTime) {
                if (timeMinutes >= beginTime && timeMinutes < 1440) {
                    this.timeLenMins = 1440 - timeMinutes + endTime;
                    return;
                } else {
                    if (timeMinutes >= endTime) throw new IllegalStateException("\u6839\u636e\u65f6\u95f4\u67e5\u627e\u65f6\u6bb5\u89c4\u5219\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u7b97\u6cd5!");
                    this.timeLenMins = endTime - timeMinutes;
                }
                return;
            } else {
                if (timeMinutes < beginTime || timeMinutes >= endTime) throw new IllegalStateException("\u6839\u636e\u65f6\u95f4\u67e5\u627e\u65f6\u6bb5\u89c4\u5219\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u7b97\u6cd5!");
                this.timeLenMins = endTime - timeMinutes;
            }
        }
    }

    protected static class SegmentEntryData {
        SegementEntry firstEntry;
        SegementEntry lastEntry = null;
        LinkedList<SegementEntry> intSegementEntryList;

        protected SegmentEntryData() {
        }
    }
}

