/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.charge;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.charge.ChargeContext;
import com.wovoe.carpark.charge.PeriodMultiPassCost;
import com.wovoe.carpark.dto.CarparkChargeRule;
import com.wovoe.carpark.dto.CarparkChargeSegmentRule;
import com.wovoe.carpark.dto.CarparkChargeTimeLenRange;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DefaultChargeContext
implements ChargeContext {
    protected Map<String, Object> context = new HashMap<String, Object>();

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public int getDateType(java.util.Date date) {
        Map<Date, Integer> dmap = ServiceUtil.getServiceContext().getDBConfigCache().getSpecialDateTypeMap();
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        cl.set(11, 0);
        cl.set(12, 0);
        cl.set(13, 0);
        cl.set(14, 0);
        Integer h = null;
        if (dmap != null) {
            h = dmap.get(new Date(cl.getTimeInMillis()));
        }
        if (h != null) {
            if (h == 2) {
                return 2;
            }
            return 1;
        }
        int week = cl.get(7);
        if (week == 1 || week == 7) {
            return 2;
        }
        return 1;
    }

    @Override
    public PeriodMultiPassCost getPeriodMultiPassCost(int projectId, int carparkId, String plateNo, java.util.Date passBeginDate, java.util.Date passEndDate) {
        if (plateNo == null || plateNo.length() == 0 || passBeginDate == null || passEndDate == null) {
            return null;
        }
        StringBuilder sbr = new StringBuilder(128);
        sbr.append("getPeriodMultiPass_").append(plateNo).append('_').append(passBeginDate.getTime()).append('_').append(passEndDate.getTime());
        String key = sbr.toString();
        if (this.context.containsKey(key)) {
            PeriodMultiPassCost x = (PeriodMultiPassCost)this.context.get(key);
            if (x == null) {
                return null;
            }
            return x.clone();
        }
        PeriodMultiPassCost result = null;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam searchParam = new SearchParam();
        searchParam.setQueryFields(new String[]{"pass_plate", "enter_time", "exit_time", "pass_time", "exit_should_charge", "period_multi_start", "period_multi_received", "period_multi_free", "next_period_multi_start", "next_period_multi_cur"});
        searchParam.addNotEQ("enter_time", null);
        searchParam.addNotEQ("exit_time", null);
        searchParam.addEQ("pass_plate", (Object)plateNo);
        searchParam.addGT("pass_time", (Object)passBeginDate);
        searchParam.addLTE("pass_time", (Object)passEndDate);
        searchParam.addEQ("carpark_id", (Object)carparkId);
        searchParam.setOrder_by("pass_time ASC");
        int enjoyedFreeTimes1 = 0;
        int enjoyedFreeDuration1 = 0;
        CarparkPassRecord record = null;
        List list = commonDaoService.selectList(searchParam, CarparkPassRecord.class, null);
        if (list != null && !list.isEmpty()) {
            for (CarparkPassRecord r : list) {
                if (r.getEnter_time() == null || r.getExit_time() == null || !r.getExit_time().after(r.getEnter_time()) || !r.getExit_time().after(passBeginDate)) continue;
                if (r.getNext_period_multi_start() != null) {
                    record = r;
                }
                if (r.getExit_should_charge() != null && !(r.getExit_should_charge().doubleValue() <= 0.0)) continue;
                ++enjoyedFreeTimes1;
                if (r.getEnter_time().before(passBeginDate)) {
                    enjoyedFreeDuration1 += (int)TimeUnit.MILLISECONDS.toMinutes(r.getExit_time().getTime() - passBeginDate.getTime());
                    continue;
                }
                enjoyedFreeDuration1 += (int)TimeUnit.MILLISECONDS.toMinutes(r.getExit_time().getTime() - r.getEnter_time().getTime());
            }
        }
        if (record != null && record.getNext_period_multi_start() != null) {
            PeriodMultiPassCost co = new PeriodMultiPassCost();
            co.setPeriodStartDate(record.getNext_period_multi_start());
            BigDecimal d = record.getNext_period_multi_cur();
            if (d == null) {
                d = Constants.MONEY_ZERO;
            }
            if (record.getPeriod_multi_start() != null && record.getPeriod_multi_start().getTime() == record.getNext_period_multi_start().getTime() && record.getPeriod_multi_received() != null) {
                d = d.add(record.getPeriod_multi_received());
            }
            co.setAlreadyCost(d);
            result = co;
        }
        this.context.put(key, result);
        StringBuilder sbr1 = new StringBuilder(128);
        sbr1.append("enjoyedFreeTime_").append(plateNo).append(passBeginDate.getTime()).append('-').append(passEndDate.getTime());
        this.context.put(sbr1.toString(), new KeyValueEntry((Object)enjoyedFreeTimes1, (Object)enjoyedFreeDuration1));
        if (result == null) {
            return null;
        }
        return result.clone();
    }

    @Override
    public String getExpiredChargePassportTypeNo(int projectId, int carparkId, String passportTypeNo) {
        Map<String, CarparkPassportType> m;
        String v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportTypeNo, "PASSTYPE_EXPIRE_CHARGE_PASSTYPENO");
        if (!Constants.NO_STR.equals(v) && (m = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap()) != null && !m.isEmpty()) {
            CarparkPassportType t = null;
            if (v != null && v.length() > 0 && (t = m.get(v)) != null) {
                return t.getPassport_type_no();
            }
            for (CarparkPassportType t1 : m.values()) {
                if (t1.getPassport_type_number() != 0) continue;
                t = t1;
                break;
            }
            if (t != null) {
                return t.getPassport_type_no();
            }
        }
        return passportTypeNo;
    }

    private CarparkChargeRule queryChargeRule(int projectId, int carparkId, String passportTypeNo, String carTypeNo, String areaNo) {
        List segmentRuleList;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkChargeRule chargeRule = (CarparkChargeRule)commonDaoService.selectOne(new SearchParam().addEQ("passport_type_no", (Object)passportTypeNo).addEQ("car_type_no", (Object)carTypeNo).addEQ("area_no", (Object)areaNo).addEQ("carpark_id", (Object)carparkId).addEQ("project_id", (Object)projectId).setOrerbySql("id DESC"), CarparkChargeRule.class);
        if (chargeRule != null && (segmentRuleList = commonDaoService.selectList(new SearchParam().addEQ("charge_rule_no", (Object)chargeRule.getCharge_rule_no()).addEQ("carpark_id", (Object)carparkId).addEQ("project_id", (Object)projectId).setOrerbySql("id"), CarparkChargeSegmentRule.class, null)) != null && !segmentRuleList.isEmpty()) {
            chargeRule.setSegmentRuleList(segmentRuleList);
            LinkedHashMap<String, CarparkChargeSegmentRule> sementRuleMap = new LinkedHashMap<String, CarparkChargeSegmentRule>();
            for (CarparkChargeSegmentRule r : segmentRuleList) {
                sementRuleMap.put(r.getCharge_segment_rule_no(), r);
            }
            SearchParam tlPam = new SearchParam().addEQ("carpark_id", (Object)carparkId).addEQ("project_id", (Object)projectId).setOrerbySql("time_len");
            if (sementRuleMap.size() == 1) {
                tlPam.addEQ("charge_segment_rule_no", ServiceUtil.getFirstElement(sementRuleMap.keySet()));
            } else {
                tlPam.addINList("charge_segment_rule_no", sementRuleMap.keySet());
            }
            List timeLenRange = commonDaoService.selectList(tlPam, CarparkChargeTimeLenRange.class, null);
            if (timeLenRange != null && !timeLenRange.isEmpty()) {
                for (CarparkChargeTimeLenRange r : timeLenRange) {
                    CarparkChargeSegmentRule sr = (CarparkChargeSegmentRule)sementRuleMap.get(r.getCharge_segment_rule_no());
                    if (sr == null) continue;
                    List<CarparkChargeTimeLenRange> rlx = sr.getTimeLenRangeList();
                    if (rlx == null) {
                        rlx = new LinkedList<CarparkChargeTimeLenRange>();
                        sr.setTimeLenRangeList(rlx);
                    }
                    rlx.add(r);
                }
            }
        }
        return chargeRule;
    }

    @Override
    public CarparkChargeRule findChargeRule(int projectId, int carparkId, String passportTypeNo, String carTypeNo, String areaNo) {
        String key = new StringBuilder(100).append("chargeRule_").append(passportTypeNo).append('_').append(carTypeNo).append('_').append(areaNo).toString();
        if (!this.context.containsKey(key)) {
            CarparkChargeRule chargeRule = this.queryChargeRule(projectId, carparkId, passportTypeNo, carTypeNo, areaNo);
            if (chargeRule != null) {
                this.context.put(key, chargeRule);
                return chargeRule;
            }
            Map<String, CarparkPassportType> pmap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            if (pmap != null) {
                String v;
                CarparkPassportType t;
                CarparkPassportType temp = null;
                for (CarparkPassportType t1 : pmap.values()) {
                    if (t1.getPassport_type_number() != 0) continue;
                    temp = t1;
                    break;
                }
                if (!(temp == null || temp.getPassport_type_no().equals(passportTypeNo) || (t = pmap.get(passportTypeNo)) == null || t.getPass_type() != 0 && t.getPass_type() != 5 || Constants.NO_STR.equals(v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportTypeNo, "DEFALUT_CHARGE_PASSPORT_TYPE")) || (chargeRule = this.queryChargeRule(projectId, carparkId, temp.getPassport_type_no(), carTypeNo, areaNo)) == null)) {
                    this.context.put(key, chargeRule);
                    return chargeRule;
                }
            }
            this.context.put(key, null);
            return null;
        }
        return (CarparkChargeRule)this.context.get(key);
    }

    @Override
    public int getSegementCrossStrategy() {
        String v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CROSS_SEGMENT_CHARGE_STRATEGY");
        if (v == null || v.length() == 0) {
            return Integer.parseInt("0");
        }
        if (v.equals("0") || v.equals("1") || v.equals("2") || v.equals("3")) {
            return Integer.parseInt(v);
        }
        return Integer.parseInt("0");
    }

    @Override
    public int getSegementTimeLenStrategy() {
        String v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("SEGMENTED_CHARGE_PERIOD_STRATEGY");
        if (v == null || v.length() == 0) {
            return Integer.parseInt("0");
        }
        if (v.equals("0") || v.equals("1")) {
            return Integer.parseInt(v);
        }
        return Integer.parseInt("0");
    }

    @Override
    public boolean freeTimeLenDiscountHasFistTime() {
        String v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("FREE_TIME_LEN_DISCOUNT_FIRST_TIME");
        if (v == null || v.length() == 0) {
            return false;
        }
        return "1".equals(v);
    }

    @Override
    public boolean freeTimeLenDiscountHasFreeTime() {
        String v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("FREE_TIME_LEN_DISCOUNT_FREE_TIME");
        if (v == null || v.length() == 0) {
            return false;
        }
        return "1".equals(v);
    }

    @Override
    public int getFreeTimeLenDiscountChargeStrategy() {
        String v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("FREE_TIME_LEN_DISCOUNT_CHARGESTRATEGY");
        if (v == null || v.length() == 0) {
            return 0;
        }
        if ("1".equals(v)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getParkingLessLanOneMinsStrategy() {
        String v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("PARKING_LESS_THRAN_A_MINS");
        if (v == null || v.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int getLessLanAUnitChangeStrategy() {
        String v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("LESS_THAN_A_UNIT_CHARGE_STRATEGY");
        if (v != null && Constants.NO_STR.equals(v)) {
            return 0;
        }
        return 1;
    }

    @Override
    public List<PeriodMultiPassCost> getPeriodMultiPassCostList(int projectId, int carparkId, String plateNo, java.util.Date enterTime, int periodMins, BigDecimal periodMaxMoney, String areaNo) {
        if (plateNo == null || plateNo.length() == 0 || enterTime == null || enterTime == null || periodMins <= 0 || periodMaxMoney == null || periodMaxMoney.doubleValue() <= 0.0 || areaNo == null || areaNo.length() == 0) {
            return null;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(enterTime);
        cl.add(12, 0 - periodMins);
        java.util.Date beginTime = cl.getTime();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam searchParam = new SearchParam();
        searchParam.setQueryFields(new String[]{"id", "enter_record_no", "exit_record_no", "enter_time", "exit_time", "pass_plate", "exit_should_charge", "period_multi_start", "period_multi_received", "period_multi_free", "next_period_multi_start", "next_period_multi_cur"});
        searchParam.addGT("pass_time", (Object)beginTime);
        searchParam.addLT("pass_time", (Object)enterTime);
        searchParam.addNotEQ("enter_time", null);
        searchParam.addNotEQ("exit_time", null);
        searchParam.addEQ("area_no", (Object)areaNo);
        searchParam.addEQ("pass_plate", (Object)plateNo);
        searchParam.addEQ("carpark_id", (Object)carparkId);
        searchParam.setOrder_by("enter_time");
        List recordList = commonDaoService.selectList(searchParam, CarparkPassRecord.class, null);
        if (recordList == null || recordList.isEmpty()) {
            return null;
        }
        int enjoyedFreeTimes1 = 0;
        int enjoyedFreeDuration1 = 0;
        ArrayList<PeriodMultiPassCost> list = new ArrayList<PeriodMultiPassCost>(recordList.size());
        for (CarparkPassRecord record : recordList) {
            PeriodMultiPassCost t;
            BigDecimal re;
            BigDecimal v;
            double d;
            BigDecimal decimal;
            java.util.Date startTime;
            long parkingMins;
            if (record.getEnter_time() == null || record.getExit_time() == null || record.getExit_time().before(record.getEnter_time()) || record.getExit_time().getTime() >= enterTime.getTime()) continue;
            if (record.getExit_should_charge() == null) {
                record.setExit_should_charge(Constants.MONEY_ZERO);
            }
            if (record.getPeriod_multi_free() == null) {
                record.setPeriod_multi_free(Constants.MONEY_ZERO);
            }
            if (record.getExit_should_charge().doubleValue() == 0.0 && (parkingMins = TimeUnit.MILLISECONDS.toMinutes(record.getExit_time().getTime() - record.getEnter_time().getTime())) <= (long)periodMins) {
                startTime = record.getEnter_time();
                cl.setTime(startTime);
                cl.add(12, periodMins);
                if (cl.getTime().after(enterTime)) {
                    ++enjoyedFreeTimes1;
                    enjoyedFreeDuration1 = (int)((long)enjoyedFreeDuration1 + parkingMins);
                }
            }
            if ((decimal = record.getExit_should_charge().subtract(record.getPeriod_multi_free())).doubleValue() <= 0.0) continue;
            parkingMins = TimeUnit.MILLISECONDS.toMinutes(record.getExit_time().getTime() - record.getEnter_time().getTime());
            if (parkingMins <= (long)periodMins) {
                startTime = record.getEnter_time();
                cl.setTime(startTime);
                cl.add(12, periodMins);
                if (!cl.getTime().after(enterTime)) continue;
                PeriodMultiPassCost t2 = new PeriodMultiPassCost();
                t2.setAlreadyCost(decimal);
                t2.setPeriodStartDate(startTime);
                list.add(t2);
                continue;
            }
            int h = (int)(parkingMins / (long)periodMins);
            int h1 = (int)(parkingMins % (long)periodMins);
            if (h1 <= 0) continue;
            cl.setTime(record.getEnter_time());
            cl.add(12, h * periodMins);
            startTime = cl.getTime();
            cl.add(12, periodMins);
            if (cl.getTimeInMillis() <= enterTime.getTime()) continue;
            if (record.getNext_period_multi_start() != null && record.getNext_period_multi_cur() != null && record.getNext_period_multi_start().getTime() == startTime.getTime()) {
                if (record.getNext_period_multi_cur().doubleValue() <= 0.0) continue;
                if (record.getNext_period_multi_cur().doubleValue() > decimal.doubleValue()) {
                    d = periodMaxMoney.doubleValue() * (double)h;
                    v = new BigDecimal(d).setScale(2, 4);
                    re = decimal.subtract(v);
                    if (re.doubleValue() <= 0.0) continue;
                    t = new PeriodMultiPassCost();
                    t.setAlreadyCost(re);
                    t.setPeriodStartDate(startTime);
                    list.add(t);
                    continue;
                }
                PeriodMultiPassCost t3 = new PeriodMultiPassCost();
                t3.setAlreadyCost(record.getNext_period_multi_cur());
                t3.setPeriodStartDate(startTime);
                list.add(t3);
                continue;
            }
            d = periodMaxMoney.doubleValue() * (double)h;
            v = new BigDecimal(d).setScale(2, 4);
            re = decimal.subtract(v);
            if (re.doubleValue() <= 0.0) continue;
            t = new PeriodMultiPassCost();
            t.setAlreadyCost(re);
            t.setPeriodStartDate(startTime);
            list.add(t);
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list;
        }
        int i = 0;
        while (i < list.size()) {
            this.add(list, i);
            ++i;
        }
        this.context.put("enjoyedFreeTime" + plateNo + enterTime.getTime(), new KeyValueEntry((Object)enjoyedFreeTimes1, (Object)enjoyedFreeDuration1));
        return list;
    }

    private void add(List<PeriodMultiPassCost> list, int index) {
        if (index >= list.size()) {
            return;
        }
        PeriodMultiPassCost c = list.get(index);
        int i = index + 1;
        while (i < list.size()) {
            c.setAlreadyCost(c.getAlreadyCost().add(list.get(i).getAlreadyCost()));
            ++i;
        }
    }

    @Override
    public int getHoidayBeginMins(String passportTypeNo) {
        String v;
        if (passportTypeNo != null && passportTypeNo.length() > 0 && (v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportTypeNo, "PASSTYPE_HOLIDAY_BEGIN_DURATION")) != null && v.length() > 0) {
            try {
                int h = Integer.parseInt(v);
                if (h > -1440 && h < 1440) {
                    return h;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public int getHoidayEndMins(String passportTypeNo) {
        String v;
        if (passportTypeNo != null && passportTypeNo.length() > 0 && (v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportTypeNo, "PASSTYPE_HOLIDAY_END_DURATION")) != null && v.length() > 0) {
            try {
                int h = Integer.parseInt(v);
                if (h > -1440 && h < 1440) {
                    return h;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public List<KeyValueEntry<java.util.Date, java.util.Date>> getNoFreeTimeList(String passportTypeNo) {
        String v;
        block11: {
            block10: {
                if (passportTypeNo != null && passportTypeNo.length() != 0) break block10;
                return null;
            }
            v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportTypeNo, "NO_FREE_TIME_RANGE1");
            if (v != null && v.length() != 0 && !"0".equals(v)) break block11;
            return null;
        }
        try {
            String[] ax = v.split(",");
            LinkedList<KeyValueEntry<java.util.Date, java.util.Date>> entryList = new LinkedList<KeyValueEntry<java.util.Date, java.util.Date>>();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String date = "2000-01-01 ";
            String[] stringArray = ax;
            int n = ax.length;
            int n2 = 0;
            while (n2 < n) {
                int ind;
                String x = stringArray[n2];
                if ((x = x.trim()).length() != 0 && (ind = x.indexOf(45)) != -1) {
                    String begin = x.substring(0, ind).trim();
                    String end = x.substring(ind + 1).trim();
                    if (begin.length() == 8 && end.length() == 8) {
                        try {
                            java.util.Date d1 = df.parse(String.valueOf(date) + begin);
                            java.util.Date d2 = df.parse(String.valueOf(date) + end);
                            if (d2.after(d1)) {
                                entryList.add((KeyValueEntry<java.util.Date, java.util.Date>)new KeyValueEntry((Object)d1, (Object)d2));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++n2;
            }
            return entryList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getFreeTimeDiscountStrategy() {
        String value = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("FREE_PARKING_TIME_MUTI_STR");
        if (value != null && value.length() > 0 && "1".equals(value)) {
            return "1";
        }
        return "0";
    }

    @Override
    public boolean isFloorMins() {
        return ServiceUtil.isFloorMins();
    }

    @Override
    public long getMins(long secs) {
        return ServiceUtil.getMins(secs);
    }
}

