/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.wovoe.carpark.cloud.CarparkCloudConnection;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.http.HttpUtil;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class AhrcuPayTool {
    public static final String SIGN_KEY_NAME = "sign";
    public static final char AND = '&';
    public static final char EQ = '=';
    public static final String SUCCESS_CODE = "00";
    public static final String ORDER_STATE_WAIT_PAY = "1";
    public static final String ORDER_STATE_PAYING = "2";
    public static final String ORDER_STATE_PAY_SUCCESS = "3";
    public static final String ORDER_STATE_PAY_FAIL = "4";
    public static final String ORDER_STATE_PAY_CLOSED = "5";
    public static final String ORDER_STATE_PAY_REFUND = "6";
    public static final String ORDER_STATE_PAY_CANCEL = "7";
    public static final String ORDER_STATE_PAY_REC = "8";

    public static void doQueyTask(final String queyUrl, final String queryJson, final long startMills, final long timoutDMills, final String reponseUrl, final String outTradeNo, final String token) {
        long current = ServiceUtil.getServiceContext().currentTimeMillis();
        long x = current - startMills;
        if (x >= timoutDMills) {
            return;
        }
        long delayMills = x < 1000L ? 3000L : (x <= 20000L ? 1000L : (x <= 30000L ? 1500L : (x <= 40000L ? 2000L : (x <= 50000L ? 2500L : (x <= 60000L ? 3000L : (x <= 120000L ? 4000L : (x <= 180000L ? 5000L : (x <= 240000L ? 8000L : 10000L))))))));
        ServiceUtil.getServiceContext().delay(new JobTask(){

            protected void doRun() throws Exception {
                AhrcuNativePayQueryResult result = AhrcuPayTool.doNativePayQuery(queyUrl, queryJson);
                boolean needQuery = false;
                if ("REQ_ERROR".equals(result.getResultCode())) {
                    needQuery = true;
                } else if (AhrcuPayTool.SUCCESS_CODE.equals(result.getResultCode())) {
                    if (AhrcuPayTool.ORDER_STATE_WAIT_PAY.equals(result.getOrderStatus())) {
                        needQuery = true;
                    } else if (AhrcuPayTool.ORDER_STATE_PAYING.equals(result.getOrderStatus())) {
                        needQuery = true;
                    } else if (AhrcuPayTool.ORDER_STATE_PAY_SUCCESS.equals(result.getOrderStatus())) {
                        TreeMap<String, String> resultMap = new TreeMap<String, String>();
                        resultMap.put("parkId", ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getId());
                        resultMap.put("outTradeNo", outTradeNo);
                        resultMap.put("random", RandomStringGenerator.getDefaultInstance().getNewString(32));
                        resultMap.put("result", GsonBuilder.create().toJson((Object)result));
                        resultMap.put("token", token);
                        String signKey = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getSignKey();
                        String singValue = AhrcuPayTool.getSignValue(resultMap, signKey);
                        resultMap.put(AhrcuPayTool.SIGN_KEY_NAME, singValue);
                        String sendString = ServiceUtil.getServiceContext().getCloudContext().getCloudConnTransferCrypto().encrypt(GsonBuilder.create().toJson(resultMap));
                        boolean success = AhrcuPayTool.doPushPayResult(reponseUrl, sendString);
                        if (!success) {
                            AhrcuPayTool.doPushPayResultJob(reponseUrl, sendString, 1, 100);
                        }
                    } else {
                        ServiceLog.getLog().info((Object)("\u8c03\u7528\u5b89\u5fbd\u519c\u5546\u884cdoNativePayQuery\u67e5\u8be2\u652f\u4ed8\u72b6\u6001, \u8fd9\u5c06\u5173\u95ed\u5b9a\u65f6\u67e5\u8be2\u4efb\u52a1, \u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u6570\u636e: " + result));
                    }
                } else {
                    ServiceLog.getLog().warn((Object)("\u8c03\u7528\u5b89\u5fbd\u519c\u5546\u884cdoNativePayQuery\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5f02\u5e38:  \u539f\u56e0: " + result.getResultMessage()));
                }
                if (needQuery) {
                    AhrcuPayTool.doQueyTask(queyUrl, queryJson, startMills, timoutDMills, reponseUrl, outTradeNo, token);
                }
            }
        }, delayMills, TimeUnit.MILLISECONDS);
    }

    public static void doPushPayResultJob(final String reponseUrl, final String sendStr, final int count, final int maxCount) {
        if (count > maxCount) {
            return;
        }
        long delayMills = count == 1 ? 3000L : (count == 2 ? 4000L : (count == 3 ? 5000L : (count == 4 ? 6000L : (count == 5 ? 7000L : (count == 6 ? 8000L : (count == 7 ? 9000L : (count == 8 ? 10000L : 10000L)))))));
        ServiceUtil.getServiceContext().delay(new JobTask(){

            protected void doRun() throws Exception {
                boolean success = AhrcuPayTool.doPushPayResult(reponseUrl, sendStr);
                if (!success) {
                    AhrcuPayTool.doPushPayResultJob(reponseUrl, sendStr, count + 1, maxCount);
                }
            }
        }, delayMills, TimeUnit.MILLISECONDS);
    }

    public static String getSignValue(Map<String, String> paramMap, String signKey) {
        TreeMap<String, String> treeMap;
        if (paramMap instanceof TreeMap) {
            treeMap = (TreeMap<String, String>)paramMap;
        } else {
            treeMap = new TreeMap<String, String>();
            treeMap.putAll(paramMap);
        }
        StringBuilder sbr = new StringBuilder(128);
        for (Map.Entry entry : treeMap.entrySet()) {
            if (entry.getKey() == null || ((String)entry.getKey()).length() == 0 || entry.getValue() == null || ((String)entry.getValue()).length() == 0 || SIGN_KEY_NAME.equals(entry.getKey())) continue;
            if (sbr.length() > 0) {
                sbr.append('&');
            }
            sbr.append((String)entry.getKey()).append('=').append((String)entry.getValue());
        }
        sbr.append('&').append("key=").append(signKey);
        return CryptoUtil.MD5Encode((String)sbr.toString()).toUpperCase();
    }

    public static boolean doPushPayResult(String reponseUrl, String sendStr) {
        String url;
        if (reponseUrl.startsWith("/")) {
            String domain = null;
            CarparkCloudConnection connection = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection();
            if (connection.isConnected()) {
                domain = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getConnectCloudDomin();
            }
            if (domain == null || domain.length() == 0) {
                domain = connection.getObtainConnectDomain();
            }
            url = "http://" + domain + reponseUrl;
        } else {
            url = reponseUrl;
        }
        try {
            String resultV = HttpUtil.doJsonRquest((String)url, null, (String)sendStr);
            boolean success = "SUCCESS".equals(resultV);
            if (!success) {
                ServiceLog.getLog().warn((Object)("\u5411\u670d\u52a1\u5668\u63a8\u9001\u652f\u4ed8\u5b89\u5fbd\u519c\u91d1\u652f\u4ed8\u6210\u529f\u5931\u8d25\uff01\u539f\u56e0\uff1a" + resultV));
            }
            return success;
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u5411\u670d\u52a1\u5668\u63a8\u9001\u652f\u4ed8\u5b89\u5fbd\u519c\u91d1\u652f\u4ed8\u6210\u529f\u5f02\u5e38\uff01" + ex.getMessage()));
            return false;
        }
    }

    public static AhrcuNativePayQueryResult doNativePayQuery(String url, String sendJson) {
        AhrcuNativePayQueryResult result;
        String resultStr;
        try {
            resultStr = HttpUtil.doJsonRquest((String)url, null, (String)sendJson);
        }
        catch (Exception e) {
            AhrcuNativePayQueryResult result2 = new AhrcuNativePayQueryResult();
            result2.setResultCode("REQ_ERROR");
            result2.setResultCode("\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5931\u8d25,\u7f51\u7edc\u5f02\u5e38");
            ServiceLog.getLog().warn((Object)("\u8c03\u7528\u5b89\u5fbd\u519c\u5546\u884cdoNativePayQuery\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5f02\u5e38: " + e.getMessage()));
            return result2;
        }
        if (resultStr == null || resultStr.length() == 0) {
            AhrcuNativePayQueryResult result3 = new AhrcuNativePayQueryResult();
            result3.setResultCode("RESP_ERROR");
            result3.setResultCode("\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u7a7a\u6570\u636e");
            ServiceLog.getLog().warn((Object)"\u8c03\u7528\u5b89\u5fbd\u519c\u5546\u884cdoNativePayQuery\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5f02\u5e38: \u8fd4\u56de\u7a7a\u6570\u636e");
            return result3;
        }
        try {
            result = (AhrcuNativePayQueryResult)GsonBuilder.create().fromJson(resultStr, AhrcuNativePayQueryResult.class);
        }
        catch (Exception ex) {
            AhrcuNativePayQueryResult result4 = new AhrcuNativePayQueryResult();
            result4.setResultCode("RESP_ERROR");
            result4.setResultCode("\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            ServiceLog.getLog().warn((Object)("\u8c03\u7528\u5b89\u5fbd\u519c\u5546\u884cdoNativePayQuery\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5f02\u5e38: " + resultStr));
            return result4;
        }
        return result;
    }

    public static class AhrcuNativePayQueryResult {
        private String resultCode;
        private String resultMessage;
        private String terminalNo;
        private String traceNo;
        private String batchNo;
        private String transAmount;
        private String cposOrderId;
        private String itpOrderId;
        private String chnOrderId;
        private String orderStatus;
        private String tradeChannel;
        private String errorDesc;
        private String outletName;
        private String payUserInfo;
        private String paidTime;

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public String getResultMessage() {
            return this.resultMessage;
        }

        public void setResultMessage(String resultMessage) {
            this.resultMessage = resultMessage;
        }

        public String getTerminalNo() {
            return this.terminalNo;
        }

        public void setTerminalNo(String terminalNo) {
            this.terminalNo = terminalNo;
        }

        public String getTraceNo() {
            return this.traceNo;
        }

        public void setTraceNo(String traceNo) {
            this.traceNo = traceNo;
        }

        public String getBatchNo() {
            return this.batchNo;
        }

        public void setBatchNo(String batchNo) {
            this.batchNo = batchNo;
        }

        public String getTransAmount() {
            return this.transAmount;
        }

        public void setTransAmount(String transAmount) {
            this.transAmount = transAmount;
        }

        public String getCposOrderId() {
            return this.cposOrderId;
        }

        public void setCposOrderId(String cposOrderId) {
            this.cposOrderId = cposOrderId;
        }

        public String getItpOrderId() {
            return this.itpOrderId;
        }

        public void setItpOrderId(String itpOrderId) {
            this.itpOrderId = itpOrderId;
        }

        public String getChnOrderId() {
            return this.chnOrderId;
        }

        public void setChnOrderId(String chnOrderId) {
            this.chnOrderId = chnOrderId;
        }

        public String getOrderStatus() {
            return this.orderStatus;
        }

        public void setOrderStatus(String orderStatus) {
            this.orderStatus = orderStatus;
        }

        public String getTradeChannel() {
            return this.tradeChannel;
        }

        public void setTradeChannel(String tradeChannel) {
            this.tradeChannel = tradeChannel;
        }

        public String getErrorDesc() {
            return this.errorDesc;
        }

        public void setErrorDesc(String errorDesc) {
            this.errorDesc = errorDesc;
        }

        public String getOutletName() {
            return this.outletName;
        }

        public void setOutletName(String outletName) {
            this.outletName = outletName;
        }

        public String getPayUserInfo() {
            return this.payUserInfo;
        }

        public void setPayUserInfo(String payUserInfo) {
            this.payUserInfo = payUserInfo;
        }

        public String getPaidTime() {
            return this.paidTime;
        }

        public void setPaidTime(String paidTime) {
            this.paidTime = paidTime;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AhrcuNativePayQueryResult [resultCode=");
            builder.append(this.resultCode);
            builder.append(", resultMessage=");
            builder.append(this.resultMessage);
            builder.append(", terminalNo=");
            builder.append(this.terminalNo);
            builder.append(", traceNo=");
            builder.append(this.traceNo);
            builder.append(", batchNo=");
            builder.append(this.batchNo);
            builder.append(", transAmount=");
            builder.append(this.transAmount);
            builder.append(", cposOrderId=");
            builder.append(this.cposOrderId);
            builder.append(", itpOrderId=");
            builder.append(this.itpOrderId);
            builder.append(", chnOrderId=");
            builder.append(this.chnOrderId);
            builder.append(", orderStatus=");
            builder.append(this.orderStatus);
            builder.append(", tradeChannel=");
            builder.append(this.tradeChannel);
            builder.append(", errorDesc=");
            builder.append(this.errorDesc);
            builder.append(", outletName=");
            builder.append(this.outletName);
            builder.append(", payUserInfo=");
            builder.append(this.payUserInfo);
            builder.append(", paidTime=");
            builder.append(this.paidTime);
            builder.append("]");
            return builder.toString();
        }
    }
}

