/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.WanNetHostSelector;
import com.wovoe.carpark.cloud.CarparkCloudConnection;
import com.wovoe.carpark.cloud.CloudHttpRemoteServiceProxy;
import com.wovoe.carpark.cloud.CloudReceiveClassManager;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.transfer.TransferCrypto;
import java.net.Proxy;

public class CarparkCloudServiceFactory
implements RpcReomtecServiceFactory {
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    private int connectTimeoutMills;
    private int readTimeoutMills;
    private String requestProtocol;
    private String connectDomain;
    private TransferCrypto crypto;
    private String token;
    private String connId;
    private String connName;
    private String signKey;
    private CloudReceiveClassManager receiveClassManager;

    public CarparkCloudServiceFactory(int connectTimeoutMills, int readTimeoutMills, String requestProtocol, String connectDomain, TransferCrypto crypto, String token, String connId, String connName, String signKey, CloudReceiveClassManager receiveClassManager) {
        this.connectTimeoutMills = connectTimeoutMills;
        this.readTimeoutMills = readTimeoutMills;
        if (requestProtocol == null || requestProtocol.length() == 0) {
            requestProtocol = HTTP;
        } else if (!HTTP.equals(requestProtocol) && !HTTPS.equals(requestProtocol)) {
            requestProtocol = HTTP;
        }
        this.requestProtocol = requestProtocol;
        this.connectDomain = connectDomain;
        this.crypto = crypto;
        this.token = token;
        this.connId = connId;
        this.connName = connName;
        this.signKey = signKey;
        this.receiveClassManager = receiveClassManager;
    }

    public static CarparkCloudServiceFactory createIfConnected() {
        return CarparkCloudServiceFactory.createIfConnected(8000, 10000);
    }

    public static CarparkCloudServiceFactory createIfConnected(int connectTimeoutMills, int readTimeoutMills) {
        return CarparkCloudServiceFactory.createIfConnected(connectTimeoutMills, readTimeoutMills, null);
    }

    public static CarparkCloudServiceFactory createIfConnected(int connectTimeoutMills, int readTimeoutMills, String requestProtocol) {
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config == null) {
            return null;
        }
        CarparkCloudConnection connection = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection();
        if (connection == null || !connection.isConnected()) {
            return null;
        }
        TransferCrypto crypto = connection.getTransferCrypto();
        if (crypto == null) {
            return null;
        }
        String token = connection.getValidAccessToken();
        if (token == null || token.length() == 0) {
            return null;
        }
        String connectDomain = connection.getConnectCloudDomin();
        if (connectDomain == null || connectDomain.length() == 0) {
            return null;
        }
        String connName = connection.getName();
        if (connName == null || connName.length() == 0) {
            return null;
        }
        String connId = connection.getId();
        if (connId == null || connId.length() == 0) {
            return null;
        }
        String signKey = connection.getSignKey();
        if (signKey == null || signKey.length() == 0) {
            return null;
        }
        return new CarparkCloudServiceFactory(connectTimeoutMills, readTimeoutMills, requestProtocol, connectDomain, crypto, token, connId, connName, signKey, connection.getCloudReceiveClassManager());
    }

    @Override
    public <T> T crateRemoteService(Class<T> remoteServiceClass) {
        String className = remoteServiceClass.getSimpleName();
        String remoteServiceName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1);
        return this.crateRemoteService(remoteServiceClass, remoteServiceName);
    }

    @Override
    public <T> T crateRemoteService(Class<T> remoteServiceClass, String remoteServiceName) {
        if (remoteServiceName == null || remoteServiceName.length() == 0) {
            return null;
        }
        if (!remoteServiceClass.isInterface()) {
            return null;
        }
        StringBuilder urlBuilder = new StringBuilder(128);
        urlBuilder.append(this.getRequestProtocol()).append(this.connectDomain).append("/core/remote/gateway/rpc/transfer/invoke/").append(this.token);
        String requestUrl = urlBuilder.toString();
        Proxy proxyx = WanNetHostSelector.getWanProxyHost(this.connectDomain).getProxy();
        T t = CloudHttpRemoteServiceProxy.newProxy(remoteServiceClass, requestUrl, remoteServiceName, this.signKey, this.crypto, this.getConnectTimeoutMills(), this.getReadTimeoutMills(), this.receiveClassManager, this.connId, this.connName, proxyx);
        return t;
    }

    public String getRequestProtocol() {
        return this.requestProtocol;
    }

    public void setRequestProtocol(String requestProtocol) {
        this.requestProtocol = requestProtocol;
    }

    @Override
    public int getReadTimeoutMills() {
        return this.readTimeoutMills;
    }

    @Override
    public void setReadTimeoutMills(int readTimeoutMills) {
        this.readTimeoutMills = readTimeoutMills;
    }

    @Override
    public int getConnectTimeoutMills() {
        return this.connectTimeoutMills;
    }

    @Override
    public void setConnectTimeoutMills(int connectTimeoutMills) {
        this.connectTimeoutMills = connectTimeoutMills;
    }
}

