/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.wovoe.carpark.WanNetHostSelector;
import com.wovoe.carpark.cloud.CloudConnectionContext;
import com.wovoe.carpark.cloud.CloudDataConnection;
import com.wovoe.carpark.cloud.CloudDataProtocol;
import com.wovoe.carpark.cloud.CloudDataResponseCallback;
import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.cloud.CloudServiceAction;
import com.wovoe.carpark.cloud.ParseException;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.http.HttpResponse;
import com.wovoe.framework.http.HttpResponseCallback;
import com.wovoe.framework.http.HttpResponseLineStringCallback;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.transfer.IOResponse;
import com.wovoe.framework.transfer.ResultResponseMap;
import com.wovoe.framework.transfer.SendCallback;
import com.wovoe.framework.transfer.connection.WaitResultTimeout;
import java.io.IOException;
import java.net.Proxy;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CloudCometConnection
implements Runnable,
CloudDataConnection {
    private CloudConnectionContext context;
    private String id;
    private String signKey;
    private volatile boolean started;
    private volatile boolean destroyed;
    private AtomicBoolean running = new AtomicBoolean(false);
    private volatile boolean connected = false;
    private volatile int unconnectCount = 1;
    private volatile String cometRequestURL = null;
    private volatile boolean connecting = false;
    private volatile long activeTimeMills;
    private CountDownLatch waitConnectmessage;
    private Thread readThread;
    private long defaultResponseTimeout = 8000L;

    public CloudCometConnection(CloudConnectionContext context, String id, String signKey) {
        this.context = context;
        this.id = id;
        this.signKey = signKey;
        this.waitConnectmessage = new CountDownLatch(1);
    }

    @Override
    public void send(CloudDataProtocol dataRequest, CloudDataResponseCallback responseCallback, long waitResposeTimeout) {
        try {
            Object key;
            String sendString = dataRequest.toSendString(this.getSignKey(), this.context.getTransferCrypto());
            if (responseCallback != null) {
                if (waitResposeTimeout <= 0L) {
                    waitResposeTimeout = this.getDefaultResponseTimeout();
                }
                key = this.createWaitResponseKey(dataRequest);
                boolean a = ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject(key, (Object)responseCallback, new TimeoutObjectPool.TimeoutCallback(){

                    public void onTimeout(Object key, Object value) throws Exception {
                        CloudDataResponseCallback v = (CloudDataResponseCallback)value;
                        v.onWaitTimeout();
                    }
                }, waitResposeTimeout, TimeUnit.MILLISECONDS);
                if (!a) {
                    throw new IOException("\u65e0\u6cd5\u52a0\u5165\u7b49\u5f85\u8d85\u65f6\u961f\u5217\uff01");
                }
            } else {
                key = null;
            }
            this.directSend(sendString, new SendCallback(){

                public void onSendException(Throwable ex) {
                    if (key != null) {
                        CloudDataResponseCallback responseCallback1 = (CloudDataResponseCallback)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject(key);
                        if (responseCallback1 != null) {
                            responseCallback1.onException(ex);
                        } else {
                            CloudCometConnection.this.exceptionCaught(ex);
                        }
                    } else {
                        CloudCometConnection.this.exceptionCaught(ex);
                    }
                }

                public void onSendComplete() {
                }
            });
        }
        catch (Throwable e) {
            if (responseCallback != null) {
                responseCallback.onException(e);
            }
            this.exceptionCaught(e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSignKey() {
        return this.signKey;
    }

    @Override
    public synchronized void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.started = false;
            this.connected = false;
            this.connecting = false;
            this.running.set(false);
            if (this.readThread != null) {
                this.readThread.interrupt();
                this.readThread = null;
            }
        }
        if (this.waitConnectmessage.getCount() == 1L) {
            this.waitConnectmessage.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        CloudCometConnection cloudCometConnection = this;
        synchronized (cloudCometConnection) {
            if (this.destroyed) {
                return;
            }
            if (!this.started) {
                this.readThread = new Thread(this);
                this.readThread.setDaemon(true);
                this.readThread.start();
                this.started = true;
            }
        }
    }

    public void connect() {
        if (!this.isStarted()) {
            this.start();
        }
        try {
            this.waitConnectmessage.await(35L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.isConnected() && !this.isDestroy()) {
            this.destroy();
        }
    }

    @Override
    public boolean isDestroy() {
        return this.destroyed;
    }

    @Override
    public boolean isConnected() {
        if (this.destroyed) {
            return false;
        }
        return this.connected;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        if (this.destroyed) {
            return;
        }
        if (this.running.get()) {
            return;
        }
        if (this.running.compareAndSet(false, true)) ** GOTO lbl40
        return;
lbl-1000:
        // 1 sources

        {
            try {
                domain = this.context.getConnectCloudDomin();
                postParam = new HashMap<String, String>();
                postParam.put("name", this.context.getName());
                postParam.put("connParam", this.context.getConnetParm());
                url = "http://" + domain + "/core/webclient/comet/transferconn";
                ServiceLog.getLog().info((Object)"\u6b63\u5728\u4f7f\u7528comet\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668!");
                this.connecting = true;
                proxy = WanNetHostSelector.getWanProxyHost(domain).getProxy();
                HttpUtil.doRequest((String)url, null, postParam, null, null, (HttpResponseCallback)new HttpResponseLineStringCallback<String>(){
                    private boolean waitConnectInfo = true;

                    public boolean onHeaders(HttpResponse response) {
                        return true;
                    }

                    public String onComplete() {
                        return null;
                    }

                    public void onException(Throwable ex) {
                    }

                    public boolean callback(String message) {
                        if (this.waitConnectInfo) {
                            boolean success;
                            try {
                                success = CloudCometConnection.this.context.handleConnectMessage(message, CloudCometConnection.this);
                            }
                            catch (Exception ex) {
                                CloudCometConnection.this.exceptionCaught(ex);
                                success = false;
                            }
                            if (!success) {
                                if (CloudCometConnection.this.waitConnectmessage.getCount() == 1L) {
                                    CloudCometConnection.this.waitConnectmessage.countDown();
                                }
                                return false;
                            }
                            CloudCometConnection.this.updateActiveState();
                            CloudCometConnection.this.connecting = false;
                            CloudCometConnection.this.connected = true;
                            CloudCometConnection.this.unconnectCount = 0;
                            this.waitConnectInfo = false;
                            if (CloudCometConnection.this.waitConnectmessage.getCount() == 1L) {
                                CloudCometConnection.this.waitConnectmessage.countDown();
                            }
                            ServiceLog.getLog().info((Object)"\u6210\u529f\u4f7f\u7528comet\u4e0e\u670d\u52a1\u5668\u5efa\u7acb\u8fde\u63a5!");
                        } else {
                            try {
                                CloudCometConnection.this.hanldeMessage(message);
                            }
                            catch (Exception ex) {
                                if (ex instanceof ParseException) {
                                    ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e:" + ex.getMessage()));
                                }
                                ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                            }
                        }
                        return true;
                    }
                }, (int)8000, (int)30000, (Proxy)proxy);
                ServiceLog.getLog().warn((Object)"\u4e0e\u4e91\u7aef\u670d\u52a1\u5668\u5931\u53bb\u8fde\u63a5\uff01");
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)("\u4e0e\u4e91\u7aef\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5: " + ex.getMessage()));
            }
            var1_1 = this;
            synchronized (var1_1) {
                this.connecting = false;
                this.cometRequestURL = null;
            }
            if (this.waitConnectmessage.getCount() == 1L) {
                this.waitConnectmessage.countDown();
            }
            if (this.destroyed) continue;
            ++this.unconnectCount;
            if (this.unconnectCount > 1) {
                this.destroy();
                continue;
            }
            ServiceLog.getLog().info((Object)"\u4fdd\u6301\u4e91\u7aef\u670d\u52a1\u5668\u672c\u5730\u8fde\u63a5\u72b6\u6001,\u91cd\u65b0\u5c1d\u8bd5\u5efa\u7acb1\u6b21\u8fde\u63a5...");
lbl40:
            // 4 sources

            ** while (!this.destroyed)
        }
lbl41:
        // 1 sources

    }

    protected void exceptionCaught(Throwable ex) {
        ServiceLog.getLog().warn((Object)("\u9519\u8bef: " + ex.getMessage()));
    }

    public void directSend(String message, SendCallback sendCallback) throws IOException {
        String requestURL = this.cometRequestURL;
        if (!this.connected || requestURL == null || requestURL.length() == 0) {
            if (sendCallback != null) {
                sendCallback.onSendException((Throwable)new IOException("not conected yet!"));
            } else {
                throw new IOException("not conected yet!");
            }
        }
        this.asynSend(requestURL, message, sendCallback);
    }

    protected void setContext(CloudDataProtocol p) {
    }

    protected CloudDataProtocol parseReceiveData(String message) throws ParseException {
        CloudDataProtocol p = CloudDataProtocol.parse(message, this.getSignKey(), this.context.getTransferCrypto(), this.context.getCloudReceiveClassManager());
        return p;
    }

    protected void hanldeMessage(String message) throws Exception {
        CloudDataProtocol p = this.parseReceiveData(message);
        this.setContext(p);
        this.hanldeReceiveData(p);
    }

    protected void hanldeReceiveData(final CloudDataProtocol p) throws Exception {
        if (!p.getId().equals(this.getId())) {
            ServiceLog.getLog().warn((Object)"id\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662f\u4fee\u6539\u914d\u7f6e\u5bfc\u81f4\uff0c\u8fd9\u5c06\u65ad\u5f00\u8fde\u63a5");
            this.destroy();
            return;
        }
        if (!p.getName().equals(this.context.getName())) {
            ServiceLog.getLog().warn((Object)"name\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662f\u4fee\u6539\u914d\u7f6e\u5bfc\u81f4\uff0c\u8fd9\u5c06\u65ad\u5f00\u8fde\u63a5");
            this.destroy();
            return;
        }
        if (p.getCmd().endsWith(this.context.getResponseEndFlag())) {
            final CloudDataResponseCallback callbak = (CloudDataResponseCallback)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject(this.getWaitResponseKey(p));
            if (callbak != null && p != null) {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            callbak.onResponse(p);
                        }
                        catch (Exception e) {
                            CloudCometConnection.this.exceptionCaught(e);
                        }
                    }
                });
            }
        } else {
            final CloudServiceAction action = this.context.getCloudServiceAction(p.getCmd());
            if (action != null) {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IOResponse re = CloudCometConnection.this.createIOResponse(p);
                            action.execute(p, re);
                        }
                        catch (Exception e) {
                            CloudCometConnection.this.exceptionCaught(e);
                        }
                    }
                });
            } else {
                CloudResultResponse res = new CloudResultResponse();
                res.setResponseCode("404");
                res.setResponseMsg("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u547d\u4ee4: " + p.getCmd() + ", \u6b64\u670d\u52a1\u4e0d\u6388\u652f\u6301\uff01");
                IOResponse re = this.createErrorResponse(p);
                re.doResponse(String.valueOf(p.getCmd()) + this.context.getResponseEndFlag(), (Object)res);
            }
        }
    }

    protected IOResponse createIOResponse(CloudDataProtocol p) {
        return this.createIOResponse(p.getAttach(), p.getMsgId(), false);
    }

    protected IOResponse createErrorResponse(CloudDataProtocol p) {
        return this.createIOResponse(p.getAttach(), p.getMsgId(), true);
    }

    private void asynSend(final String url, final String message, final SendCallback sendCallback) {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CloudCometConnection.this.directSend1(url, message, sendCallback);
                }
                catch (Exception ex) {
                    if (sendCallback != null) {
                        sendCallback.onSendException((Throwable)ex);
                    }
                    ServiceLog.getLog().warn((Object)ex.getMessage());
                }
            }
        });
    }

    private void directSend1(String url, String message, SendCallback sendCallback) throws IOException {
        block7: {
            try {
                Proxy proxy = WanNetHostSelector.getWanProxyHost(url).getProxy();
                String result = HttpUtil.doJsonRquest((String)url, null, (String)message, (Proxy)proxy);
                if ("SUCCESS".equals(result)) {
                    if (sendCallback != null) {
                        sendCallback.onSendComplete();
                    }
                    break block7;
                }
                if (result == null || result.length() == 0) {
                    result = "\u672a\u8fd4\u56de\u53d1\u9001\u72b6\u6001";
                }
                throw new Exception(result);
            }
            catch (Exception ex) {
                if (sendCallback != null) {
                    sendCallback.onSendException((Throwable)ex);
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new IOException(ex.getMessage(), ex);
            }
        }
    }

    protected IOResponse createIOResponse(final String attach, final String msgId, boolean async) {
        return new IOResponse(){

            public void doResponse0(String cmd, Object data, boolean async) throws IOException {
                if (attach == null || attach.length() == 0) {
                    return;
                }
                if (msgId == null || msgId.length() == 0) {
                    return;
                }
                String responsePath = attach;
                if (!responsePath.startsWith("/")) {
                    responsePath = "/" + responsePath;
                }
                String domain = CloudCometConnection.this.context.getConnectCloudDomin();
                String url = "http://" + domain + responsePath;
                CloudDataProtocol res = CloudCometConnection.this.createDataRequest(cmd, msgId, data);
                String value = res.toSendString(CloudCometConnection.this.getSignKey(), CloudCometConnection.this.context.getTransferCrypto());
                SendCallback sendb = new SendCallback(){

                    public void onSendException(Throwable ex) {
                        ServiceLog.getLog().warn((Object)("\u53d1\u9001\u6570\u636e\u5f02\u5e38\uff1a" + ex.getMessage()));
                    }

                    public void onSendComplete() {
                    }
                };
                if (async) {
                    CloudCometConnection.this.asynSend(url, value, sendb);
                } else {
                    CloudCometConnection.this.directSend1(url, value, sendb);
                }
            }

            public void doResponse(final String cmd, Object data) throws IOException {
                if (data instanceof OperationFuture) {
                    long waiMills = WaitResultTimeout.getAndRemove((long)15000L);
                    if (waiMills <= 0L) {
                        waiMills = 15000L;
                    }
                    OperationFuture opf = (OperationFuture)data;
                    opf.addCompleteListener(new OperationFuture.CompleteListener(){

                        public void operationComplete(OperationFuture future) {
                            if (future.isCancelled()) {
                                this.doResponseX(new ResultResponseMap("501", "\u4e1a\u52a1\u8c03\u7528\u64cd\u4f5c\u88ab\u53d6\u6d88"));
                            } else if (future.getException() != null) {
                                ServiceLog.getLog().warn((Object)("\u4e1a\u52a1: " + cmd + " \u5f02\u6b65\u5904\u7406\u7ed3\u679c\u8fd4\u56de\u5f02\u5e38! "), future.getException());
                                this.doResponseX(new ResultResponseMap("500", "\u4e1a\u52a1\u5185\u90e8\u5904\u7406\u5f02\u5e38"));
                            } else if (future.getResult() == null) {
                                ServiceLog.getLog().warn((Object)("\u4e1a\u52a1: " + cmd + " \u5f02\u6b65\u5904\u7406\u7ed3\u679c\u8fd4\u56deNULL"));
                                this.doResponseX(new ResultResponseMap("502", "\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u4e1a\u52a1\u8fd4\u56de\u7a7a\u7ed3\u679c"));
                            } else {
                                this.doResponseX(future.getResult());
                            }
                        }

                        public void waitCompleteTimeout() {
                            ServiceLog.getLog().warn((Object)("\u4e1a\u52a1: " + cmd + " \u5f02\u6b65\u5904\u7406\u7ed3\u679c\u8d85\u65f6"));
                            this.doResponseX(new ResultResponseMap("501", "\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u4e1a\u52a1\u8d85\u65f6"));
                        }

                        private void doResponseX(Object obj) {
                            try {
                                boolean asyncRun = !ServiceUtil.getServiceContext().currentRunThreadIsWorkThread();
                                this.doResponse0(cmd, obj, asyncRun);
                            }
                            catch (Throwable ex) {
                                ServiceLog.getLog().warn((Object)("\u54cd\u5e94\u670d\u52a1\u5668: " + cmd + ", \u5f02\u5e38\uff01" + ex.getMessage()));
                            }
                        }
                    }, waiMills, TimeUnit.MILLISECONDS);
                }
            }
        };
    }

    public CloudDataProtocol createDataRequest(String cmd, Object data) {
        return this.createDataRequest(cmd, this.createMsgId(cmd, data), data);
    }

    public CloudDataProtocol createDataRequest(String cmd, String msgId, Object data) {
        CloudDataProtocol p = new CloudDataProtocol();
        p.setId(this.getId());
        p.setName(this.context.getName());
        p.setCmd(cmd);
        p.setMsgId(msgId);
        p.setData(data);
        p.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        return p;
    }

    protected String createMsgId(String cmd, Object data) {
        return "comet-client-" + ServiceUtil.getServiceContext().createLongSeq();
    }

    protected Object createWaitResponseKey(CloudDataProtocol request) {
        return new WaitResponseKey(request.getName(), request.getMsgId(), String.valueOf(request.getCmd()) + this.context.getResponseEndFlag(), request.getId());
    }

    protected Object getWaitResponseKey(CloudDataProtocol response) {
        return new WaitResponseKey(response.getName(), response.getMsgId(), response.getCmd(), response.getId());
    }

    public long getDefaultResponseTimeout() {
        return this.defaultResponseTimeout;
    }

    public void setDefaultResponseTimeout(long defaultResponseTimeout) {
        if (defaultResponseTimeout > 0L) {
            this.defaultResponseTimeout = defaultResponseTimeout;
        }
    }

    public void setCometRequestURL(String cometRequestURL) {
        this.cometRequestURL = cometRequestURL;
    }

    public void updateActiveState() {
        this.activeTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
    }

    public long getActivTimeMills() {
        return this.activeTimeMills;
    }

    private static class WaitResponseKey {
        private String name;
        private String msgId;
        private String cmd;
        private String id;

        public WaitResponseKey(String name, String msgId, String cmd, String id) {
            this.name = name;
            this.msgId = msgId;
            this.cmd = cmd;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cmd == null ? 0 : this.cmd.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.msgId == null ? 0 : this.msgId.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WaitResponseKey other = (WaitResponseKey)obj;
            if (this.cmd == null ? other.cmd != null : !this.cmd.equals(other.cmd)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.msgId == null ? other.msgId != null : !this.msgId.equals(other.msgId)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

