/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.RsaUtil;
import com.wovoe.framework.transfer.TransferCrypto;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;

public class CloudConnectTransferCrypto
implements TransferCrypto {
    private static PublicKey productCloudPublicKey;
    private static PublicKey developCloudPublicKey;
    private final PublicKey publicKey;

    public CloudConnectTransferCrypto() {
        this(ServiceUtil.getServiceContext().isDevEnvironment());
    }

    public static PublicKey getCloudPublicKey() {
        return CloudConnectTransferCrypto.getCloudPublicKey(ServiceUtil.getServiceContext().isDevEnvironment());
    }

    public static PublicKey getCloudPublicKey(boolean devMode) {
        if (devMode) {
            if (developCloudPublicKey != null) {
                return developCloudPublicKey;
            }
        } else if (productCloudPublicKey != null) {
            return productCloudPublicKey;
        }
        String keyStr = devMode ? "30819f300d06092a864886f70d010101050003818d00308189028181008baf9c57b6cda05458482e321d6834e3e841606768b005d0d1d72082e6a5713dfac8fe9149e2629a500062f693f14a02c0c62901f257afee5642f45241f58ab28e92968690594365c180e7e1231ed025832bb11e69b7025a32302a2767fa2bc9a6bc9277e6531f0d26d7b2793cebca71ae456c77494b4610e5541132fb3c291b0203010001" : "30819f300d06092a864886f70d010101050003818d0030818902818100b2e178cfaaeba84613f561c26442150e8101c3ded4a37e79b1875e5ddff3c448de7ec59336e8d239f3dfd8dc8cf17e93e32b8a6e51a08410e64d23c0c116fc59753f623d836ce267c80aa1bddae5f4eced33c29bd85839c0389430af2b964d8b4363d70ce13fc7bb3eea60e934417f5bebc030b865e3479b7a5ed4216da38bbf0203010001";
        try {
            byte[] bytes = BytesTool.hexStringToByteArray((String)keyStr);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PublicKey k = factory.generatePublic(keySpec);
            if (devMode) {
                developCloudPublicKey = k;
            } else {
                productCloudPublicKey = k;
            }
            return k;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public CloudConnectTransferCrypto(boolean devMode) {
        this.publicKey = CloudConnectTransferCrypto.getCloudPublicKey(devMode);
    }

    public String decrypt(String encryptString) {
        byte[] array;
        int length;
        int offset;
        if (encryptString == null) {
            return null;
        }
        if (encryptString.length() == 0) {
            return "";
        }
        ByteBuffer buf = RsaUtil.decrypt((byte[])BytesTool.unCompress((String)encryptString), (Key)this.publicKey);
        if (buf.hasArray()) {
            offset = buf.position() + buf.arrayOffset();
            length = buf.remaining();
            array = buf.array();
        } else {
            offset = 0;
            length = buf.remaining();
            array = new byte[length];
            buf.get(array);
        }
        try {
            return new String(array, offset, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String encrypt(String originalText) {
        byte[] sb;
        if (originalText == null) {
            return null;
        }
        if (originalText.length() == 0) {
            return "";
        }
        try {
            sb = originalText.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        byte[] bytes = RsaUtil.encrypt((byte[])sb, (Key)this.publicKey);
        return BytesTool.compressBytes((byte[])bytes);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

