/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.google.gson.Gson;
import com.wovoe.carpark.cloud.CloudReceiveClassManager;
import com.wovoe.carpark.cloud.ParseException;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.transfer.TransferCrypto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CloudDataProtocol {
    private String id;
    private String name;
    private String cmd;
    private String msgId;
    private String nonce;
    private String attach;
    private Object data;
    private String sign;
    private String recvMsg;
    private Map<String, Object> contextMap = null;

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toSendString(Gson gson, String signKey, TransferCrypto crypto) {
        String result;
        String dataValue = this.data != null ? (this.data instanceof String ? (String)this.data : gson.toJson(this.data)) : null;
        if (signKey != null) {
            ArrayList<String> list = new ArrayList<String>(7);
            int len = 0;
            if (this.id != null && this.id.length() > 0) {
                list.add(this.id);
                len += this.id.length();
            }
            if (this.name != null && this.name.length() > 0) {
                list.add(this.name);
                len += this.name.length();
            }
            if (this.cmd != null && this.cmd.length() > 0) {
                list.add(this.cmd);
                len += this.cmd.length();
            }
            if (this.msgId != null && this.msgId.length() > 0) {
                list.add(this.msgId);
                len += this.msgId.length();
            }
            if (this.nonce != null && this.nonce.length() > 0) {
                list.add(this.nonce);
                len += this.nonce.length();
            }
            if (this.attach != null && this.attach.length() > 0) {
                list.add(this.attach);
                len += this.attach.length();
            }
            if (dataValue != null && dataValue.length() > 0) {
                list.add(dataValue);
                len += dataValue.length();
            }
            Collections.sort(list);
            char d = ',';
            StringBuilder sbr = new StringBuilder(len + 64);
            for (String s : list) {
                sbr.append(s);
                sbr.append(d);
            }
            sbr.append(signKey);
            this.sign = CryptoUtil.MD5Encode((String)sbr.toString());
        }
        Object l = this.data;
        this.data = dataValue;
        try {
            result = gson.toJson((Object)this);
        }
        finally {
            this.data = l;
        }
        if (crypto != null) {
            result = crypto.encrypt(result);
        }
        return result;
    }

    public String toSendString(String signKey, TransferCrypto crypto) {
        return this.toSendString(GsonBuilder.create(), signKey, crypto);
    }

    public static CloudDataProtocol parse(Gson gson, String jsonString, String signKey, TransferCrypto crypto, CloudReceiveClassManager CloudReceiveClassManager2) throws ParseException {
        return CloudDataProtocol.parse(gson, jsonString, signKey, crypto, true, CloudReceiveClassManager2);
    }

    public static CloudDataProtocol parse(Gson gson, String jsonString, String signKey, TransferCrypto crypto, boolean pareseData, CloudReceiveClassManager CloudReceiveClassManager2) throws ParseException {
        CloudDataProtocol p;
        if (crypto != null) {
            try {
                jsonString = crypto.decrypt(jsonString);
            }
            catch (Exception ex) {
                throw new ParseException(null, null, null, null, "DECRYPT_ERROR", "\u6570\u636e\u89e3\u5bc6\u5931\u8d25", jsonString);
            }
        }
        try {
            p = (CloudDataProtocol)gson.fromJson(jsonString, CloudDataProtocol.class);
        }
        catch (Exception ex) {
            throw new ParseException(null, null, null, null, "FRAME_JSON_ERROR", "\u6570\u636e\u4e0d\u662fjson", jsonString);
        }
        if (p.id == null || p.id.length() == 0) {
            ParseException e = new ParseException(p.id, p.name, p.cmd, p.msgId, "CMD_EMPTY_ERROR", "\u7f3a\u5c11\u53c2\u6570 id", jsonString);
            throw e;
        }
        if (p.name == null || p.name.length() == 0) {
            throw new ParseException(p.id, p.name, p.cmd, p.msgId, "CMD_EMPTY_ERROR", "\u7f3a\u5c11\u53c2\u6570 name", jsonString);
        }
        if (p.cmd == null || p.cmd.length() == 0) {
            throw new ParseException(p.id, p.name, p.cmd, p.msgId, "CMD_EMPTY_ERROR", "\u7f3a\u5c11\u53c2\u6570 cmd", jsonString);
        }
        if (p.msgId == null || p.msgId.length() == 0) {
            throw new ParseException(p.id, p.name, p.cmd, p.msgId, "MSGID_EMPTY_ERROR", "\u7f3a\u5c11\u53c2\u6570 msgId", jsonString);
        }
        if (p.data != null && !(p.data instanceof String)) {
            throw new ParseException(p.id, p.name, p.cmd, p.msgId, "FIELD_ERROR", "\u6570\u636e\u57df\u5fc5\u987b\u662fJSON\u5b57\u7b26\u4e32\uff0c\u800c\u4e0d\u662fJSON\u5bf9\u8c61", jsonString);
        }
        if (signKey != null) {
            String dataValue;
            if (p.sign == null || p.sign.length() == 0) {
                throw new ParseException(p.id, p.name, p.cmd, p.msgId, "FIELD_ERROR", "\u7f3a\u5c11\u53c2\u6570 sign", jsonString);
            }
            ArrayList<String> list = new ArrayList<String>(7);
            int len = 0;
            if (p.id != null && p.id.length() > 0) {
                list.add(p.id);
                len += p.id.length();
            }
            if (p.name != null && p.name.length() > 0) {
                list.add(p.name);
                len += p.name.length();
            }
            if (p.cmd != null && p.cmd.length() > 0) {
                list.add(p.cmd);
                len += p.cmd.length();
            }
            if (p.msgId != null && p.msgId.length() > 0) {
                list.add(p.msgId);
                len += p.msgId.length();
            }
            if (p.nonce != null && p.nonce.length() > 0) {
                list.add(p.nonce);
                len += p.nonce.length();
            }
            if (p.attach != null && p.attach.length() > 0) {
                list.add(p.attach);
                len += p.attach.length();
            }
            if (p.data != null && (dataValue = (String)p.data) != null && dataValue.length() > 0) {
                list.add(dataValue);
                len += dataValue.length();
            }
            Collections.sort(list);
            char d = ',';
            StringBuilder sbr = new StringBuilder(len + 64);
            for (String s : list) {
                sbr.append(s);
                sbr.append(d);
            }
            sbr.append(signKey);
            String sign = CryptoUtil.MD5Encode((String)sbr.toString());
            if (!sign.toLowerCase().equals(p.sign.toLowerCase())) {
                throw new ParseException(p.id, p.name, p.cmd, p.msgId, "SIGN_ERROR", "\u7b7e\u540d\u9519\u8bef", jsonString);
            }
        }
        if (p.data != null && pareseData) {
            Object d;
            Class<Object> cl;
            String dataValue = (String)p.data;
            Class<?> clazz = cl = CloudReceiveClassManager2 == null ? null : CloudReceiveClassManager2.getDataClass(p.cmd);
            if (cl == null) {
                cl = LinkedHashMap.class;
            }
            try {
                d = gson.fromJson(dataValue, cl);
            }
            catch (Exception ex) {
                throw new ParseException(p.id, p.name, p.cmd, p.msgId, "FIELD_ERROR", "\u6570\u636e\u57df\u5b57\u7b26\u4e32\u4e0d\u662f\u6709\u6548\u7684json\u683c\u5f0f", jsonString);
            }
            p.setData(d);
        }
        p.recvMsg = jsonString;
        return p;
    }

    public static CloudDataProtocol parse(String jsonString, String signKey, TransferCrypto crypto, CloudReceiveClassManager CloudReceiveClassManager2) throws ParseException {
        return CloudDataProtocol.parse(GsonBuilder.create(), jsonString, signKey, crypto, CloudReceiveClassManager2);
    }

    public static CloudDataProtocol parse(String jsonString, String signKey, TransferCrypto crypto, boolean pareseData, CloudReceiveClassManager CloudReceiveClassManager2) throws ParseException {
        return CloudDataProtocol.parse(GsonBuilder.create(), jsonString, signKey, crypto, pareseData, CloudReceiveClassManager2);
    }

    public String getRecvMsg() {
        return this.recvMsg;
    }

    public void setRecvMsg(String recvMsg) {
        this.recvMsg = recvMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getContext() {
        if (this.contextMap == null) {
            CloudDataProtocol cloudDataProtocol = this;
            synchronized (cloudDataProtocol) {
                if (this.contextMap == null) {
                    this.contextMap = new HashMap<String, Object>();
                }
            }
        }
        return this.contextMap;
    }

    public String getAttach() {
        return this.attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }
}

