/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.wovoe.carpark.cloud.CloudDataProtocol;
import com.wovoe.carpark.cloud.CloudReceiveClassManager;
import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.JavaBeanUtil;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.http.HttpResponseCallback;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.rpc.RPCRemoteException;
import com.wovoe.framework.transfer.MessageResult;
import com.wovoe.framework.transfer.TransferCrypto;
import com.wovoe.framework.transfer.connection.TimeoutSetter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class CloudHttpRemoteServiceProxy
implements InvocationHandler {
    private static final String EQUALS_METHOD = "equals";
    private static final String HASHCODE_METHOD = "hashCode";
    private static final String TOSTRING_METHOD = "toString";
    private final String url;
    private final String serviceName;
    private final String signKey;
    private final TransferCrypto crypto;
    private static final AtomicLong msgIds = new AtomicLong(0L);
    private final int defalutConnectTimeMills;
    private final int defaultReadTimeMills;
    private final CloudReceiveClassManager receiveClassManager;
    private final String id;
    private final String name;
    private final java.net.Proxy connectProxy;

    private CloudHttpRemoteServiceProxy(String url, String serviceName, String signKey, TransferCrypto crypto, int defalutConnectTimeMills, int defaultReadTimeMills, CloudReceiveClassManager receiveClassManager, String id, String name, java.net.Proxy connectProxy) {
        this.url = url;
        this.serviceName = serviceName;
        this.signKey = signKey;
        this.crypto = crypto;
        this.defalutConnectTimeMills = defalutConnectTimeMills <= 0 ? 5000 : defalutConnectTimeMills;
        this.defaultReadTimeMills = defaultReadTimeMills <= 0 ? 10000 : defaultReadTimeMills;
        this.receiveClassManager = receiveClassManager;
        this.id = id;
        this.name = name;
        this.connectProxy = connectProxy;
    }

    private static String getMsgId() {
        byte[] array;
        int length;
        int offset;
        byte[] xv = ("C" + RandomStringGenerator.getDefaultInstance().getNewString(3)).getBytes();
        ByteBuffer buf = ByteBuffer.allocate(xv.length + 12);
        buf.put(xv);
        buf.putInt((int)(System.currentTimeMillis() / 1000L));
        buf.putLong(msgIds.incrementAndGet());
        buf.flip();
        if (buf.hasArray()) {
            offset = buf.position() + buf.arrayOffset();
            length = buf.remaining();
            array = buf.array();
        } else {
            offset = 0;
            length = buf.remaining();
            array = new byte[length];
            buf.get(array);
        }
        return BytesTool.compressBytes((byte[])array, (int)offset, (int)length);
    }

    public static <T> T newProxy(Class<T> iface, String url, String serviceName, String signKey, TransferCrypto crypto, int defalutConnectTimeMills, int defaultReadTimeMills, CloudReceiveClassManager receiveClassManager, String id, String name, java.net.Proxy connectProxy) {
        CloudHttpRemoteServiceProxy p = new CloudHttpRemoteServiceProxy(url, serviceName, signKey, crypto, defalutConnectTimeMills, defaultReadTimeMills, receiveClassManager, id, name, connectProxy);
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)p);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Boolean returnValue = null;
        String mehtodName = method.getName();
        if (EQUALS_METHOD.equals(mehtodName) && args != null && args.length == 1) {
            if (proxy == args[0]) {
                return true;
            }
            return false;
        }
        if (HASHCODE_METHOD.equals(mehtodName) && (args == null || args.length == 0)) {
            return this.hashCode();
        }
        if (TOSTRING_METHOD.equals(mehtodName) && (args == null || args.length == 0)) {
            return this.toString();
        }
        try {
            String resultString;
            Object beanValue;
            int conenctTimeMills = TimeoutSetter.getConnectTimeoutMills();
            int readTimeMills = TimeoutSetter.getReadTimeoutMills();
            Class<?>[] cls = method.getParameterTypes();
            if (cls == null || cls.length == 0) {
                throw new UnsupportedOperationException("method: " + mehtodName + " not supported yet!");
            }
            String cmd = String.valueOf(this.serviceName) + "." + mehtodName;
            String resultCmd = String.valueOf(cmd) + ServiceUtil.getServiceContext().getCloudContext().getResponseEndFlag();
            Class<Object> returnCls = method.getReturnType();
            boolean isVoid = Void.class.equals(returnCls);
            boolean isBoolean = !isVoid ? Boolean.TYPE.equals(returnCls) || Boolean.class.equals(returnCls) : false;
            if (!isVoid && !isBoolean) {
                if (MessageResult.class.equals(returnCls)) {
                    returnCls = CloudResultResponse.class;
                }
                if (!Map.class.equals(returnCls)) {
                    if (!Map.class.isAssignableFrom(returnCls)) {
                        Map map = JavaBeanUtil.getGetSetMethods(returnCls);
                        if (map.get("responseCode") == null) {
                            throw new IllegalArgumentException("request class must contains get and set method on filed responseCode");
                        }
                        if (map.get("responseMsg") == null) {
                            throw new IllegalArgumentException("request class must contains get and set method on filed responseMsg");
                        }
                    }
                    if (this.receiveClassManager.getDataClass(resultCmd) == null) {
                        this.receiveClassManager.addDataClass(resultCmd, returnCls);
                    }
                }
            }
            if ((beanValue = args[0]) == null) {
                throw new NullPointerException("request parameter is null!");
            }
            CloudDataProtocol f = new CloudDataProtocol();
            f.setId(this.id);
            f.setName(this.name);
            f.setCmd(cmd);
            f.setData(beanValue);
            f.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
            String msgId = CloudHttpRemoteServiceProxy.getMsgId();
            f.setMsgId(msgId);
            String json = f.toSendString(this.signKey, this.crypto);
            if (conenctTimeMills <= 0) {
                conenctTimeMills = this.defalutConnectTimeMills;
            }
            if (readTimeMills <= 0) {
                readTimeMills = this.defaultReadTimeMills;
            }
            try {
                resultString = (String)HttpUtil.doRequest((String)this.url, null, null, null, (String)json, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)conenctTimeMills, (int)readTimeMills, (java.net.Proxy)this.connectProxy);
            }
            catch (Exception ex) {
                throw new RPCRemoteException("request error! " + ex.getMessage(), (Throwable)ex);
            }
            CloudDataProtocol pol = CloudDataProtocol.parse(resultString, this.signKey, this.crypto, this.receiveClassManager);
            if (!msgId.equals(pol.getMsgId())) {
                throw new RPCRemoteException(" error msgId! request:" + msgId + ", response:" + pol.getMsgId());
            }
            if (!resultCmd.equals(pol.getCmd())) {
                throw new RPCRemoteException(" error cmd! request:" + cmd + ", response:" + pol.getCmd());
            }
            Object returnData = pol.getData();
            if (returnData == null) {
                throw new RPCRemoteException(" error response! cmd:" + pol.getCmd() + ", miss data!");
            }
            Map map = returnData instanceof Map ? (Map)returnData : new JavaBeanMap(returnData);
            Object responseCode = map.get("responseCode");
            if (responseCode == null) {
                throw new RPCRemoteException(" error response! cmd:" + pol.getCmd() + ", miss data field responseCode!");
            }
            if (isVoid || isBoolean) {
                boolean success = "0".equals(responseCode.toString());
                if (!success) {
                    String msg0 = (String)map.get("responseMsg");
                    if (msg0 == null) {
                        msg0 = "";
                    }
                    throw new RPCRemoteException(" error response! errcode:" + responseCode + ", cause:" + msg0);
                }
                returnValue = isBoolean ? Boolean.valueOf(success) : null;
            } else {
                returnValue = (Boolean)returnData;
            }
        }
        finally {
            TimeoutSetter.clear();
        }
        return returnValue;
    }
}

