/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.google.gson.Gson;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.WanNetHostSelector;
import com.wovoe.carpark.cloud.CarparkCloudConnection;
import com.wovoe.carpark.cloud.CarparkUploadPicOssConfig;
import com.wovoe.carpark.cloud.CloudContext;
import com.wovoe.carpark.cloud.CloudDataProtocol;
import com.wovoe.carpark.cloud.OssTool;
import com.wovoe.carpark.cloud.SyncRecord;
import com.wovoe.carpark.cloud.cos.COSConfig;
import com.wovoe.carpark.cloud.cos.COSTool;
import com.wovoe.carpark.dto.CarparkIllegalPassRecord;
import com.wovoe.carpark.dto.CarparkOperationLog;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.http.HttpResponse;
import com.wovoe.framework.http.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CloudSyncDataJob
extends JobTask {
    private static final long cloudInsertidBaisc = 0x4000000000000000L;
    private final String[] syncTables = new String[]{"ck_carpark_host_sync", "ck_carpark_user_sync", "ck_carpark_role_sync", "ck_carpark_role_permission_sync", "ck_carpark_area_sync", "ck_carpark_channel_sync", "ck_carpark_channel_area_sync", "ck_carpark_equipment_sync", "ck_carpark_equipment_config_sync", "ck_carpark_channel_equipment_sync", "ck_carpark_passport_type_sync", "ck_carpark_car_type_sync", "ck_carpark_attribute_sync", "ck_carpark_strategy_sync", "ck_carpark_special_date_sync", "ck_carpark_space_type_sync", "ck_carpark_space_type_define_sync", "ck_carpark_space_type_quantity_sync", "ck_carpark_pass_permission_sync", "ck_carpark_date_range_sync", "ck_carpark_pass_permission_channel_sync", "ck_carpark_recharge_rule_sync", "ck_carpark_charge_rule_sync", "ck_carpark_charge_segment_rule_sync", "ck_carpark_charge_time_len_range_sync", "ck_carpark_passport_sync", "ck_carpark_car_owner_sync", "ck_carpark_discount_project_sync", "ck_carpark_merchant", "ck_carpark_merchant_user", "ck_carpark_merchant_coupon_proj", "ck_carpark_merchant_coupon_rule", "ck_carpark_presence_record", "ck_carpark_duty_number", "ck_carpark_merchant_coupon_order", "ck_carpark_discount_record", "ck_carpark_illegal_pass_record", "ck_carpark_cancel_pass_record", "ck_carpark_transaction", "ck_carpark_merchant_coupon_use_record", "ck_carpark_pass_record", "ck_carpark_operation_log", "ck_carpark_visit_auth_sync"};
    private static final Map<String, String> needCheckDataMap = new HashMap<String, String>();
    private static final String CLOUD_NO_PREFIX = "SP";
    private static String[] picPathNames;
    private String cloudId;
    private static final String record_no_str = "record_no";
    private static final String ck_carpark_cancel_pass_record_str = "ck_carpark_cancel_pass_record";
    private static final String ck_carpark_pass_record_str = "ck_carpark_pass_record";
    private static final String ck_carpark_operation_log_str = "ck_carpark_operation_log";
    private static final String ck_carpark_illegal_pass_record_str = "ck_carpark_illegal_pass_record";

    static {
        needCheckDataMap.put("ck_carpark_transaction", "tansaction_no");
        needCheckDataMap.put("ck_carpark_discount_record", "discount_no");
        picPathNames = new String[]{"enter_car_pic", "enter_plate_pic", "enter_face_pic", "exit_car_pic", "exit_plate_pic", "exit_face_pic", "certificate_pic", "pic_path", "head_photo"};
    }

    protected void doRun() throws Exception {
        List logList;
        CloudContext context;
        CarparkCloudConnection conn;
        String cloud_carpark_id = ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id();
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        if (cloud_carpark_id == null || cloud_carpark_id.length() == 0) {
            daoService.delete(new SearchParam("ck_cloud_ddl_sync_log"));
            return;
        }
        if (!cloud_carpark_id.equals(this.cloudId)) {
            this.checkInitData(daoService, cloud_carpark_id);
            this.cloudId = cloud_carpark_id;
        }
        if ((conn = (context = ServiceUtil.getServiceContext().getCloudContext()).getCarparkCloudConnection()) == null) {
            return;
        }
        if (!conn.isConnected()) {
            return;
        }
        String accessToken = conn.getValidAccessToken();
        if (accessToken == null || accessToken.length() == 0) {
            return;
        }
        int fetchSize = 500;
        long id = 0L;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String INSERT = "I";
        String UPDATE = "U";
        String DELETE = "D";
        String ck_carpark_role_sync = "ck_carpark_role_sync";
        int maxRemainDays = 0;
        try {
            int x;
            String v = ServiceUtil.getServiceContext().getConfig().getProperty("record.upload.cloud.max.retention.days");
            if (v != null && (v = v.trim()).length() > 0 && (x = Integer.parseInt(v)) > 0) {
                if (x < 7) {
                    x = 7;
                }
                maxRemainDays = x;
            }
        }
        catch (Exception v) {
            // empty catch block
        }
        Gson gson = GsonBuilder.create();
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        do {
            Pagination p = new Pagination();
            p.setPageSize(fetchSize);
            p.setRecordsCount((long)fetchSize);
            p.setGotoPage(1);
            p.setNeedQueryCount(false);
            logList = daoService.selectList(new SearchParam("ck_cloud_ddl_sync_log").addGT("id", (Object)id).setOrerbySql("id"), p);
            if (logList == null || logList.isEmpty()) break;
            for (Map logMap : logList) {
                CloudDataProtocol response;
                String result;
                String record;
                long nowMills;
                if (!conn.isConnected()) {
                    return;
                }
                id = (Long)logMap.get("id");
                String table_name = (String)logMap.get("table_name");
                String op_type = (String)logMap.get("op_type");
                Long pk_value = (Long)logMap.get("pk_value");
                Date op_time = (Date)logMap.get("op_time");
                if (pk_value > 0x4000000000000000L && INSERT.equals(op_type) && op_time != null && (nowMills = System.currentTimeMillis() - op_time.getTime()) >= 0L && nowMills < 5000L) continue;
                if (INSERT.equals(op_type) || UPDATE.equals(op_type)) {
                    COSConfig cosConfig;
                    byte[] bf;
                    ByteArrayOutputStream out;
                    FileInputStream in;
                    byte[] data;
                    int width;
                    long uploadCount;
                    String baicPath;
                    String ext;
                    String path;
                    File f1;
                    String dbpath;
                    String s2;
                    String[] stringArray;
                    Object o;
                    String fieldName;
                    String ucode;
                    Class po = daoService.getPoClass(table_name);
                    SearchParam sp1 = new SearchParam();
                    sp1.setWhereString(" id = " + pk_value);
                    Object obj = daoService.selectOne(sp1, po);
                    if (obj == null) {
                        daoService.delete(new SearchParam("ck_cloud_ddl_sync_log").addEQ("id", (Object)id));
                        continue;
                    }
                    if (maxRemainDays > 0) {
                        Calendar cl;
                        Object r;
                        if (ck_carpark_pass_record_str.equals(table_name) || ck_carpark_cancel_pass_record_str.equals(table_name)) {
                            if (obj instanceof CarparkPassRecord && ((CarparkPassRecord)(r = (CarparkPassRecord)obj)).getPass_time() != null) {
                                cl = Calendar.getInstance();
                                cl.add(6, 0 - maxRemainDays);
                                if (((CarparkPassRecord)r).getPass_time().before(cl.getTime())) {
                                    ServiceLog.getLog().error((Object)("\u51fa\u5165\u8bb0\u5f55\u8868\u8d85\u8fc7" + maxRemainDays + "\u5929\u6570\u636e\u4e0d\u518d\u4e0a\u4f20\u5e73\u53f0\uff1aid: " + ((CarparkPassRecord)r).getId() + ", \u8f66\u724c\u53f7: " + ((CarparkPassRecord)r).getPass_plate() + ", \u901a\u884c\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((CarparkPassRecord)r).getPass_time()) + ", \u901a\u884c\u573a\u533a: " + ((CarparkPassRecord)r).getArea_name() + ", \u65b9\u5411:" + (((CarparkPassRecord)r).getExit_time() == null ? "\u8fdb\u573a" : "\u79bb\u573a")));
                                    daoService.delete(new SearchParam("ck_cloud_ddl_sync_log").addEQ("id", (Object)id));
                                    continue;
                                }
                            }
                        } else if (ck_carpark_operation_log_str.equals(table_name)) {
                            CarparkOperationLog oplog;
                            if (obj instanceof CarparkOperationLog && (oplog = (CarparkOperationLog)obj).getOp_time() != null) {
                                cl = Calendar.getInstance();
                                cl.add(6, 0 - maxRemainDays);
                                if (oplog.getOp_time().before(cl.getTime())) {
                                    ServiceLog.getLog().error((Object)("\u64cd\u4f5c\u65e5\u5fd7\u8868\u8d85\u8fc7" + maxRemainDays + "\u5929\u6570\u636e\u4e0d\u518d\u4e0a\u4f20\u5e73\u53f0\uff1aid: " + oplog.getId() + ", \u8bb0\u5f55\u65f6\u95f4\uff1a" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(oplog.getOp_time())));
                                    daoService.delete(new SearchParam("ck_cloud_ddl_sync_log").addEQ("id", (Object)id));
                                    continue;
                                }
                            }
                        } else if (ck_carpark_illegal_pass_record_str.equals(table_name) && obj instanceof CarparkIllegalPassRecord && ((CarparkIllegalPassRecord)(r = (CarparkIllegalPassRecord)obj)).getPass_time() != null) {
                            cl = Calendar.getInstance();
                            cl.add(6, 0 - maxRemainDays);
                            if (((CarparkIllegalPassRecord)r).getPass_time().before(cl.getTime())) {
                                ServiceLog.getLog().error((Object)("\u975e\u6cd5\u62ac\u6746\u8bb0\u5f55\u8868\u8d85\u8fc7" + maxRemainDays + "\u5929\u51fa\u5165\u6570\u636e\u4e0d\u518d\u4e0a\u4f20\u5e73\u53f0\uff1aid: " + ((CarparkIllegalPassRecord)r).getId() + ", \u8bb0\u5f55\u65f6\u95f4\uff1a" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((CarparkIllegalPassRecord)r).getPass_time())));
                                daoService.delete(new SearchParam("ck_cloud_ddl_sync_log").addEQ("id", (Object)id));
                                continue;
                            }
                        }
                    }
                    JavaBeanMap beanMap = new JavaBeanMap(obj);
                    if (INSERT.equals(op_type) && needCheckDataMap.containsKey(table_name) && (ucode = (String)beanMap.get((Object)(fieldName = needCheckDataMap.get(table_name)))) != null && ucode.startsWith(CLOUD_NO_PREFIX)) {
                        daoService.delete(new SearchParam("ck_cloud_ddl_sync_log").addEQ("id", (Object)id));
                        continue;
                    }
                    if (beanMap.containsKey((Object)record_no_str) && (o = beanMap.get((Object)record_no_str)) == null) {
                        beanMap.put(record_no_str, (Object)("C" + pk_value.toString()));
                    }
                    if (conn.getUploadPicMethod() == 1) {
                        CarparkUploadPicOssConfig ossConfig = conn.getCarparkUploadPicOssConfig();
                        if (ossConfig != null) {
                            stringArray = picPathNames;
                            int n = picPathNames.length;
                            int n2 = 0;
                            while (n2 < n) {
                                block109: {
                                    s2 = stringArray[n2];
                                    if (beanMap.containsKey((Object)s2) && (dbpath = (String)beanMap.get((Object)s2)) != null && dbpath.length() > 0 && (f1 = new File(path = recordSaveService.getLocalPicPath(dbpath))).exists() && f1.isFile()) {
                                        ext = this.getCanUploadExt(f1.getName());
                                        if (ext == null) {
                                            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u4e0a\u4f20\u7684\u56fe\u7247\uff0c\u540e\u7f00\u540d\u9519\u8bef\uff1a" + dbpath));
                                        } else if (f1.length() > 0x200000L) {
                                            ServiceLog.getLog().warn((Object)"\u65e0\u6cd5\u4e0a\u4f20\u7684\u56fe\u7247\uff0c\u56fe\u7247\u8fc7\u5927");
                                        } else {
                                            try {
                                                int height;
                                                String key;
                                                baicPath = ossConfig.getBasicPath();
                                                if (baicPath == null) {
                                                    baicPath = "";
                                                }
                                                if ((key = baicPath.length() > 0 && !baicPath.endsWith("/") ? String.valueOf(baicPath) + "/" + dbpath : String.valueOf(baicPath) + dbpath).startsWith("/")) {
                                                    key = key.substring(1);
                                                }
                                                String ossPicPath = "oss://" + ossConfig.getBucket() + "/" + key;
                                                uploadCount = daoService.selectCount(new SearchParam("ck_cloud_upload_pic").addEQ("pic_path", (Object)dbpath));
                                                if (uploadCount != 0L) break block109;
                                                if (dbpath.indexOf("plateSmall_") != -1) {
                                                    width = 105;
                                                    height = 35;
                                                } else {
                                                    width = 800;
                                                    height = 450;
                                                }
                                                data = ServiceUtil.compressPic(f1, width, height, 0.7f);
                                                if (data == null || data.length == 0) {
                                                    in = new FileInputStream(f1);
                                                    out = new ByteArrayOutputStream();
                                                    try {
                                                        int len;
                                                        bf = new byte[1024];
                                                        while ((len = in.read(bf)) != -1) {
                                                            out.write(bf, 0, len);
                                                        }
                                                    }
                                                    finally {
                                                        in.close();
                                                    }
                                                    data = out.toByteArray();
                                                }
                                                OssTool.put("http://" + ossConfig.getDomain(), ossConfig.getAccessKeyId(), ossConfig.getAccessKeySecret(), ossConfig.getBucket(), key, data);
                                                LinkedHashMap<String, Object> picMap = new LinkedHashMap<String, Object>();
                                                picMap.put("id", daoService.getSequece("ck_cloud_common_seq"));
                                                picMap.put("pic_path", dbpath);
                                                picMap.put("upload_time", ServiceUtil.getNow());
                                                picMap.put("remote_server_path", ossPicPath);
                                                daoService.insert(picMap, "ck_cloud_upload_pic");
                                            }
                                            catch (Exception ex) {
                                                ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38!" + ex.getMessage()));
                                            }
                                        }
                                    }
                                }
                                ++n2;
                            }
                        }
                    } else if (conn.getUploadPicMethod() == 2) {
                        String[] stringArray2 = picPathNames;
                        int n = picPathNames.length;
                        int s2 = 0;
                        while (s2 < n) {
                            String path2;
                            File f12;
                            String dbpath2;
                            String s3 = stringArray2[s2];
                            if (beanMap.containsKey((Object)s3) && (dbpath2 = (String)beanMap.get((Object)s3)) != null && dbpath2.length() > 0 && (f12 = new File(path2 = recordSaveService.getLocalPicPath(dbpath2))).exists() && f12.isFile()) {
                                String ext2 = this.getCanUploadExt(f12.getName());
                                if (ext2 == null) {
                                    ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u4e0a\u4f20\u7684\u56fe\u7247\uff0c\u540e\u7f00\u540d\u9519\u8bef\uff1a" + dbpath2));
                                } else if (f12.length() > 0x200000L) {
                                    ServiceLog.getLog().warn((Object)"\u65e0\u6cd5\u4e0a\u4f20\u7684\u56fe\u7247\uff0c\u56fe\u7247\u8fc7\u5927");
                                } else {
                                    try {
                                        Map map = daoService.selectOne(new SearchParam("ck_cloud_upload_pic").addEQ("pic_path", (Object)dbpath2));
                                        String remote_server_path = null;
                                        if (map != null) {
                                            remote_server_path = (String)map.get("remote_server_path");
                                        } else {
                                            KeyValueEntry<Integer, String> uploadEntry;
                                            File outputFile;
                                            boolean success;
                                            int height;
                                            int width2;
                                            if (dbpath2.indexOf("plateSmall_") != -1) {
                                                width2 = 105;
                                                height = 35;
                                            } else {
                                                width2 = 800;
                                                height = 450;
                                            }
                                            File outputDir = new File(PathFinder.findLocalDir(), "uploadPics");
                                            if (!outputDir.exists()) {
                                                outputDir.mkdirs();
                                            }
                                            if (success = ServiceUtil.compressPic(f12, outputFile = new File(outputDir, String.valueOf(ServiceUtil.getServiceContext().currentTimeMillis()) + ".jpg"), width2, height, 0.7f)) {
                                                try {
                                                    uploadEntry = conn.uploadPic(dbpath2, outputFile.getAbsolutePath());
                                                }
                                                finally {
                                                    outputFile.delete();
                                                }
                                            } else {
                                                uploadEntry = conn.uploadPic(dbpath2, f12.getAbsolutePath());
                                            }
                                            if ((Integer)uploadEntry.getKey() == 0) {
                                                remote_server_path = (String)uploadEntry.getValue();
                                                if (remote_server_path != null && remote_server_path.length() > 0) {
                                                    try {
                                                        LinkedHashMap<String, Object> picMap = new LinkedHashMap<String, Object>();
                                                        picMap.put("id", daoService.getSequece("ck_cloud_common_seq"));
                                                        picMap.put("pic_path", dbpath2);
                                                        picMap.put("upload_time", ServiceUtil.getNow());
                                                        picMap.put("remote_server_path", remote_server_path);
                                                        daoService.insert(picMap, "ck_cloud_upload_pic");
                                                    }
                                                    catch (Exception ex) {
                                                        ServiceLog.getLog().warn((Object)"\u4fdd\u5b58\u670d\u52a1\u5668\u56fe\u7247\u8def\u5f84\u5230\u6570\u636e\u5e93\u5931\u8d25! \u539f\u56e0: ", (Throwable)ex);
                                                    }
                                                } else {
                                                    ServiceLog.getLog().warn((Object)"\u4e0a\u4f20\u56fe\u7247\u81f3\u670d\u52a1\u5668\u8fd4\u56de\u6210\u529f\uff0c\u4f46\u662f\u6ca1\u6709\u8fd4\u56de\u670d\u52a1\u5668\u56fe\u7247\u8def\u5f84! ");
                                                }
                                            } else {
                                                ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u5931\u8d25! \u539f\u56e0: " + (String)uploadEntry.getValue()));
                                            }
                                        }
                                        if (remote_server_path != null) {
                                            remote_server_path.length();
                                        }
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38!" + ex.getMessage()));
                                    }
                                }
                            }
                            ++s2;
                        }
                    } else if (conn.getUploadPicMethod() == 3 && (cosConfig = conn.getCarparkUploadPicCosConfig()) != null && cosConfig.getSecretId() != null && cosConfig.getSecretId().length() > 0 && cosConfig.getSeretKey() != null && cosConfig.getSeretKey().length() > 0 && cosConfig.getBucket() != null && cosConfig.getBucket().length() > 0 && cosConfig.getRegion() != null && cosConfig.getRegion().length() > 0) {
                        stringArray = picPathNames;
                        int n = picPathNames.length;
                        int n3 = 0;
                        while (n3 < n) {
                            block111: {
                                s2 = stringArray[n3];
                                if (beanMap.containsKey((Object)s2) && (dbpath = (String)beanMap.get((Object)s2)) != null && dbpath.length() > 0 && (f1 = new File(path = recordSaveService.getLocalPicPath(dbpath))).exists() && f1.isFile()) {
                                    ext = this.getCanUploadExt(f1.getName());
                                    if (ext == null) {
                                        ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u4e0a\u4f20\u7684\u56fe\u7247\uff0c\u540e\u7f00\u540d\u9519\u8bef\uff1a" + dbpath));
                                    } else if (f1.length() > 0x200000L) {
                                        ServiceLog.getLog().warn((Object)"\u65e0\u6cd5\u4e0a\u4f20\u7684\u56fe\u7247\uff0c\u56fe\u7247\u8fc7\u5927");
                                    } else {
                                        try {
                                            String uploadPicDomain;
                                            int height;
                                            String key;
                                            baicPath = cosConfig.getBasicPath();
                                            if (baicPath == null) {
                                                baicPath = "";
                                            }
                                            if ((key = baicPath.length() > 0 && !baicPath.endsWith("/") ? String.valueOf(baicPath) + "/" + dbpath : String.valueOf(baicPath) + dbpath).startsWith("/")) {
                                                key = key.substring(1);
                                            }
                                            String cosPicPath = "cos://" + cosConfig.getBucket() + "/" + key;
                                            uploadCount = daoService.selectCount(new SearchParam("ck_cloud_upload_pic").addEQ("pic_path", (Object)baicPath));
                                            if (uploadCount != 0L) break block111;
                                            if (dbpath.indexOf("plateSmall_") != -1) {
                                                width = 105;
                                                height = 35;
                                            } else {
                                                width = 800;
                                                height = 450;
                                            }
                                            data = ServiceUtil.compressPic(f1, width, height, 0.7f);
                                            if (data == null || data.length == 0) {
                                                in = new FileInputStream(f1);
                                                out = new ByteArrayOutputStream();
                                                try {
                                                    int len;
                                                    bf = new byte[1024];
                                                    while ((len = in.read(bf)) != -1) {
                                                        out.write(bf, 0, len);
                                                    }
                                                }
                                                finally {
                                                    in.close();
                                                }
                                                data = out.toByteArray();
                                            }
                                            if ((uploadPicDomain = cosConfig.getDomain()) == null || uploadPicDomain.length() == 0) {
                                                uploadPicDomain = cosConfig.generateDomain();
                                            }
                                            Proxy proxy = WanNetHostSelector.getWanProxyHost(uploadPicDomain).getProxy();
                                            HttpUtil.InputStreamFileEntry entry = new HttpUtil.InputStreamFileEntry("file", f1.getName(), (InputStream)new ByteArrayInputStream(data));
                                            KeyValueEntry<HttpResponse, byte[]> kv = COSTool.postFile(cosConfig, false, key, (HttpUtil.FileEntry)entry, 10000, 20000, proxy);
                                            if (COSTool.isPostFileSuccess(kv)) {
                                                LinkedHashMap<String, Object> picMap = new LinkedHashMap<String, Object>();
                                                picMap.put("id", daoService.getSequece("ck_cloud_common_seq"));
                                                picMap.put("pic_path", dbpath);
                                                picMap.put("upload_time", ServiceUtil.getNow());
                                                picMap.put("remote_server_path", cosPicPath);
                                                daoService.insert(picMap, "ck_cloud_upload_pic");
                                            } else if (kv != null && kv.getKey() != null) {
                                                ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38! cos: path: " + cosPicPath + ", \u539f\u56e0: " + ((HttpResponse)kv.getKey()).getResponseCode() + ": " + ((HttpResponse)kv.getKey()).getResponseMessage()));
                                            } else {
                                                ServiceLog.getLog().warn((Object)"\u4e0a\u4f20\u56fe\u7247\u5931\u8d25! \u672a\u77e5\u54cd\u5e94\u7ed3\u679c null");
                                            }
                                        }
                                        catch (Exception ex) {
                                            ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38!" + ex));
                                        }
                                    }
                                }
                            }
                            ++n3;
                        }
                    }
                    record = gson.toJson(obj);
                } else if (DELETE.equals(op_type)) {
                    record = ck_carpark_role_sync.equals(table_name) ? pk_value.toString() : "C" + pk_value;
                } else {
                    daoService.delete(new SearchParam("ck_cloud_ddl_sync_log").addEQ("id", (Object)id));
                    continue;
                }
                SyncRecord syncRecord = new SyncRecord();
                syncRecord.setOpTime(df.format(op_time));
                syncRecord.setOpType(op_type);
                syncRecord.setTableName(table_name);
                syncRecord.setRecord(record);
                CloudDataProtocol sendRequest = new CloudDataProtocol();
                sendRequest.setId(conn.getId());
                sendRequest.setCmd("carparkSyncDataService.syncRecord");
                sendRequest.setData(syncRecord);
                sendRequest.setMsgId("synccloud_" + ServiceUtil.getServiceContext().createLongSeq());
                sendRequest.setName(conn.getName());
                sendRequest.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
                String sendStr = sendRequest.toSendString(conn.getSignKey(), conn.getTransferCrypto());
                if (!conn.isConnected()) {
                    return;
                }
                accessToken = conn.getValidAccessToken();
                if (accessToken == null || accessToken.length() == 0) {
                    conn.obtainAccessToken(conn.getLocalCloudDataConnection());
                    return;
                }
                String url = "http://" + conn.getUploadDataDomain() + "/core/remote/gateway/rpc/transfer/invoke/" + accessToken;
                try {
                    result = HttpUtil.doJsonRquest((String)url, null, (String)sendStr);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u8fde\u63a5\u4e91\u7aef\u7f51\u7edc\u5f02\u5e38\uff1a" + ex.getMessage()));
                    return;
                }
                try {
                    response = CloudDataProtocol.parse(gson, result, conn.getSignKey(), conn.getTransferCrypto(), null);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e: " + result + ex.getMessage()));
                    return;
                }
                Map dataMap = (Map)response.getData();
                String resultCode = (String)dataMap.get("responseCode");
                if ("0".equals(resultCode)) {
                    daoService.delete(new SearchParam("ck_cloud_ddl_sync_log").addEQ("id", (Object)id));
                    continue;
                }
                ServiceLog.getLog().warn((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u64cd\u4f5c\u5931\u8d25\uff1a" + resultCode + ",\u539f\u56e0: " + dataMap.get("responseMsg") + ", \u8868\uff1a" + table_name + ", id:" + pk_value + ", \u64cd\u4f5c\uff1a" + op_type));
                if ("1000".equals(resultCode)) {
                    if (conn.isConnected()) {
                        conn.obtainAccessToken(conn.getLocalCloudDataConnection());
                    }
                    return;
                }
                if (!"1001".equals(resultCode)) continue;
                return;
            }
        } while (logList.size() >= fetchSize);
    }

    private String getCanUploadExt(String fileName) {
        String ext = null;
        int i = fileName.lastIndexOf(46);
        if (i != -1) {
            ext = fileName.substring(i + 1);
        }
        if (ext == null) {
            return null;
        }
        if ((ext = ext.toLowerCase()).equals("jpg") || ext.equals("jpeg") || ext.equals("gif") || ext.equals("png") || ext.equals("bmp")) {
            return ext;
        }
        return null;
    }

    private void checkInitData(CommonDaoService daoService, String parkId) {
        Object state;
        List list = daoService.selectList(new SearchParam("ck_cloud_sync_table").addEQ("cloud_id", (Object)parkId), null);
        LinkedHashMap<String, Object> vmap = new LinkedHashMap<String, Object>();
        if (list != null && !list.isEmpty()) {
            for (Map m : list) {
                String table_name = (String)m.get("table_name");
                state = (Integer)m.get("state");
                vmap.put(table_name, state);
            }
        }
        state = this.syncTables;
        int table_name = this.syncTables.length;
        int n = 0;
        while (n < table_name) {
            String tableName = state[n];
            if (!vmap.containsKey(tableName)) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("id", daoService.getSequece("ck_cloud_common_seq"));
                m.put("table_name", tableName);
                m.put("cloud_id", parkId);
                m.put("state", 0);
                daoService.insert(m, "ck_cloud_sync_table");
                vmap.put(tableName, 0);
            }
            ++n;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cl = Calendar.getInstance();
        cl.set(14, 0);
        cl.set(13, 0);
        cl.set(12, 0);
        cl.set(11, 0);
        cl.add(6, -30);
        String minTime = df.format(cl.getTime());
        for (Map.Entry entry : vmap.entrySet()) {
            if ((Integer)entry.getValue() != 0) continue;
            String orderBy = " a.id";
            String dataWhere = "";
            if ("ck_carpark_pass_record_str".equals(entry.getKey()) || ck_carpark_cancel_pass_record_str.equals(entry.getKey())) {
                orderBy = " a.pass_time";
                dataWhere = "where a.pass_time>='" + minTime + "'";
            } else if ("ck_carpark_presence_record".equals(entry.getKey())) {
                orderBy = " a.enter_time";
            } else if (ck_carpark_operation_log_str.equals(entry.getKey())) {
                dataWhere = "where a.op_time>='" + minTime + "'";
            } else if (ck_carpark_illegal_pass_record_str.equals(entry.getKey())) {
                dataWhere = "where a.pass_time>='" + minTime + "'";
            }
            String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String sql = "insert into ck_cloud_ddl_sync_log (id,table_name,pk_value,op_type,op_time,op_service) ";
            sql = String.valueOf(sql) + " select nextval('ck_cloud_ddl_sync_log_seq') as id, '" + (String)entry.getKey() + "' as table_name, a.id as pk_value, 'I' as op_type, '" + now + "' AS op_time, 'cloudSyncDataService' AS op_service from " + (String)entry.getKey() + " a " + dataWhere + " order by " + orderBy;
            daoService.insertBySql(sql);
            CommonParam updateParm = new CommonParam("ck_cloud_sync_table");
            updateParm.addEQ("table_name", entry.getKey());
            updateParm.addEQ("cloud_id", (Object)parkId);
            updateParm.addUpdate("state", (Object)1);
            daoService.update(updateParm);
        }
    }
}

