/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.wovoe.carpark.cloud.CloudConnectionContext;
import com.wovoe.carpark.cloud.CloudDataConnection;
import com.wovoe.carpark.cloud.CloudDataProtocol;
import com.wovoe.carpark.cloud.CloudDataResponseCallback;
import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.cloud.CloudServiceAction;
import com.wovoe.carpark.cloud.ParseException;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.transfer.IOResponse;
import com.wovoe.framework.transfer.ResultResponseMap;
import com.wovoe.framework.transfer.SendCallback;
import com.wovoe.framework.transfer.connection.WaitResultTimeout;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@WebSocket(maxTextMessageSize=0x200000)
public class CloudWebsocketConnection
implements CloudDataConnection {
    private CloudConnectionContext context;
    private volatile Session websocketSession;
    private volatile boolean destroyed;
    private volatile boolean connected;
    private volatile boolean waitConnectInfo = true;
    private final Object connectLock = new Object();
    private long activeTimeMills;
    private long defaultResponseTimeout = 8000L;
    private String id;
    private String signKey;
    private volatile CountDownLatch waitConnectmessage;

    public CloudWebsocketConnection(CloudConnectionContext context, String id, String signKey) {
        this.context = context;
        this.id = id;
        this.signKey = signKey;
        this.waitConnectmessage = new CountDownLatch(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @OnWebSocketMessage
    public void onMessage(String msg) {
        if (this.waitConnectInfo) {
            try {
                boolean success;
                try {
                    success = this.context.handleConnectMessage(msg, this);
                }
                catch (Exception ex) {
                    this.exceptionCaught(ex);
                    success = false;
                }
                if (success) {
                    if (this.destroyed) return;
                    this.waitConnectInfo = false;
                    this.connected = true;
                    this.updateActiveState();
                    return;
                }
                this.destroy();
                return;
            }
            finally {
                this.waitConnectmessage.countDown();
            }
        }
        try {
            this.hanldeMessage(msg);
            return;
        }
        catch (Throwable ex) {
            this.exceptionCaught(ex);
        }
    }

    protected void exceptionCaught(Throwable ex) {
        ServiceLog.getLog().warn((Object)("\u9519\u8bef: " + ex.getMessage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        CloudWebsocketConnection cloudWebsocketConnection = this;
        synchronized (cloudWebsocketConnection) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        this.disconnect();
        CountDownLatch l = this.waitConnectmessage;
        if (l != null && l.getCount() == 1L) {
            l.countDown();
            if (this.waitConnectInfo) {
                ServiceLog.getLog().warn((Object)"\u670d\u52a1\u5668\u53ef\u80fd\u4e3b\u52a8\u5173\u95ed\u4e86\u8fde\u63a5\uff01");
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public boolean isDestroy() {
        return this.destroyed;
    }

    @Override
    public boolean isStarted() {
        return !this.isDestroy();
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.setSession(session);
        LogUtil.getLog().info((Object)"\u5df2\u6210\u529f\u4e0e\u4e91\u7aef\u670d\u52a1\u5668\u5efa\u7acb\u8fde\u63a5! \u6b63\u5728\u7b49\u5f85\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e...");
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        this.connected = false;
        CountDownLatch l = this.waitConnectmessage;
        if (l != null && l.getCount() == 1L) {
            l.countDown();
        }
        LogUtil.getLog().info((Object)(" \u8fde\u63a5\u88ab\u5173\u95ed: " + statusCode + " - " + reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String uri, WebSocketClient client) {
        if (this.destroyed) {
            return;
        }
        if (this.isConnected()) {
            return;
        }
        Object object = this.connectLock;
        synchronized (object) {
            if (this.websocketSession == null) {
                this.waitConnectInfo = true;
                try {
                    URI connUri = new URI(uri);
                    LogUtil.getLog().info((Object)"\u51c6\u5907\u4f7f\u7528websocket\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668...");
                    Future f = client.connect((Object)this, connUri);
                    Session sesson1 = (Session)f.get(15L, TimeUnit.SECONDS);
                    if (sesson1 == null) {
                        f.cancel(true);
                        throw new TimeoutException("\u8fde\u63a5\u5931\u8d25!\u65e0\u6cd5\u83b7\u53d6\u8fde\u63a5!\u539f\u56e0\uff1a\u8d85\u65f6!");
                    }
                    this.setSession(sesson1);
                }
                catch (Throwable ex) {
                    LogUtil.getLog().error((Object)("\u65e0\u6cd5\u4f7f\u7528websocket\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668! \u539f\u56e0:" + ex.getMessage()));
                    this.destroy();
                    return;
                }
            }
        }
        if (!this.destroyed && this.websocketSession != null && this.websocketSession.isOpen()) {
            try {
                boolean x1 = this.waitConnectmessage.await(10L, TimeUnit.SECONDS);
                if (!x1) {
                    LogUtil.getLog().warn((Object)"\u7b49\u5f85\u4e91\u7aef\u670d\u52a1\u5668\u54cd\u5e94\u8fde\u63a5\u6210\u529f\u6570\u636e\u8d85\u65f6\uff0c\u8fd9\u5c06\u5173\u95ed\u8fde\u63a5!");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.destroyed) {
            if (!this.connected) {
                this.destroy();
            } else {
                LogUtil.getLog().info((Object)"\u6210\u529f\u63a5\u6536\u5230\u4e91\u7aef\u670d\u52a1\u5668\u5e94\u7b54\uff0c\u6210\u529f\u4f7f\u7528websocket\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668!");
            }
        }
    }

    @Override
    public boolean isConnected() {
        if (this.destroyed) {
            return false;
        }
        Session websocketSession0 = this.websocketSession;
        if (websocketSession0 == null) {
            return false;
        }
        if (!websocketSession0.isOpen()) {
            return false;
        }
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSession(Session session) {
        this.websocketSession = session;
        boolean needClose = false;
        CloudWebsocketConnection cloudWebsocketConnection = this;
        synchronized (cloudWebsocketConnection) {
            if (this.destroyed) {
                needClose = true;
            }
        }
        if (needClose) {
            this.disconnect();
        } else {
            this.updateActiveState();
        }
    }

    private void disconnect() {
        Session websocketSession0 = this.websocketSession;
        if (websocketSession0 != null && websocketSession0.isOpen()) {
            websocketSession0.close();
        }
        this.connected = false;
    }

    public void updateActiveState() {
        this.activeTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
    }

    public long getActivTimeMills() {
        return this.activeTimeMills;
    }

    @Override
    public void send(CloudDataProtocol dataRequest, CloudDataResponseCallback responseCallback, long waitResposeTimeout) {
        try {
            Object key;
            String sendString = dataRequest.toSendString(this.getSignKey(), this.context.getTransferCrypto());
            if (responseCallback != null) {
                if (waitResposeTimeout <= 0L) {
                    waitResposeTimeout = this.getDefaultResponseTimeout();
                }
                key = this.createWaitResponseKey(dataRequest);
                boolean a = ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject(key, (Object)responseCallback, new TimeoutObjectPool.TimeoutCallback(){

                    public void onTimeout(Object key, Object value) throws Exception {
                        CloudDataResponseCallback v = (CloudDataResponseCallback)value;
                        v.onWaitTimeout();
                    }
                }, waitResposeTimeout, TimeUnit.MILLISECONDS);
                if (!a) {
                    throw new IOException("\u65e0\u6cd5\u52a0\u5165\u7b49\u5f85\u8d85\u65f6\u961f\u5217\uff01");
                }
            } else {
                key = null;
            }
            this.directSend(sendString, new SendCallback(){

                public void onSendException(Throwable ex) {
                    if (key != null) {
                        CloudDataResponseCallback responseCallback1 = (CloudDataResponseCallback)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject(key);
                        if (responseCallback1 != null) {
                            responseCallback1.onException(ex);
                        } else {
                            CloudWebsocketConnection.this.exceptionCaught(ex);
                        }
                    } else {
                        CloudWebsocketConnection.this.exceptionCaught(ex);
                    }
                }

                public void onSendComplete() {
                }
            });
        }
        catch (Throwable e) {
            if (responseCallback != null) {
                responseCallback.onException(e);
            }
            this.exceptionCaught(e);
        }
    }

    public void directSend(String message, SendCallback sendCallback) throws IOException {
        this.directSend0(message, sendCallback);
    }

    private void directSend0(String message, final SendCallback sendCallback) throws IOException {
        Session websocketSession0 = this.websocketSession;
        if (websocketSession0 == null || !websocketSession0.isOpen()) {
            if (sendCallback != null) {
                sendCallback.onSendException((Throwable)new IOException("\u672a\u8fde\u63a5"));
            } else {
                throw new IOException("\u672a\u8fde\u63a5\u6216\u8fde\u63a5\u5df2\u65ad\u5f00!");
            }
        }
        websocketSession0.getRemote().sendString(message, new WriteCallback(){

            public void writeSuccess() {
                if (sendCallback != null) {
                    try {
                        sendCallback.onSendComplete();
                    }
                    catch (Exception ex) {
                        LogUtil.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }

            public void writeFailed(Throwable ex) {
                try {
                    if (sendCallback != null) {
                        sendCallback.onSendException(ex);
                    } else {
                        ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5f02\u5e38! " + ex.getMessage()));
                    }
                }
                finally {
                    CloudWebsocketConnection.this.destroy();
                }
            }
        });
    }

    protected void setContext(CloudDataProtocol p) {
    }

    protected CloudDataProtocol parseReceiveData(String message) throws ParseException {
        CloudDataProtocol p = CloudDataProtocol.parse(message, this.getSignKey(), this.context.getTransferCrypto(), this.context.getCloudReceiveClassManager());
        return p;
    }

    protected void hanldeMessage(String message) throws Exception {
        CloudDataProtocol p;
        try {
            p = this.parseReceiveData(message);
        }
        catch (ParseException ex) {
            if (ex.getId() != null && ex.getId().length() > 0 && ex.getName() != null && ex.getName().length() > 0 && ex.getCmd() != null && ex.getCmd().length() > 0 && ex.getMsgId() != null && ex.getMsgId().length() > 0 && !ex.getCmd().endsWith(this.context.getResponseEndFlag())) {
                String errcode;
                if ("SIGN_ERROR".equals(ex.getErrCode())) {
                    errcode = "1001";
                } else if ("FIELD_ERROR".equals(ex.getErrCode())) {
                    errcode = "403";
                } else if ("INTERNAL_ERROR".equals(ex.getErrCode())) {
                    errcode = "500";
                } else {
                    errcode = ex.getErrCode();
                    if (errcode == null || errcode.length() == 0) {
                        errcode = "403";
                    }
                }
                CloudResultResponse responseData = CloudResultResponse.createResponse(errcode, ex.getErrMsg());
                IOResponse re = this.createErrorResponse(ex.getMsgId());
                re.doResponse(String.valueOf(ex.getCmd()) + this.context.getResponseEndFlag(), (Object)responseData);
                return;
            }
            throw ex;
        }
        this.updateActiveState();
        this.setContext(p);
        this.hanldeReceiveData(p);
    }

    protected IOResponse createErrorResponse(String msgId) {
        return this.createIOResponse(msgId);
    }

    protected IOResponse createIOResponse(final String msgId) {
        return new IOResponse(){

            private void doResponse0(String cmd, Object data) throws IOException {
                CloudDataProtocol p = CloudWebsocketConnection.this.createDataRequest(cmd, msgId, data);
                String value = p.toSendString(CloudWebsocketConnection.this.getSignKey(), CloudWebsocketConnection.this.context.getTransferCrypto());
                CloudWebsocketConnection.this.directSend(value, new SendCallback(){

                    public void onSendException(Throwable ex) {
                        ServiceLog.getLog().warn((Object)("\u53d1\u9001\u6570\u636e\u5f02\u5e38\uff1a" + ex.getMessage()));
                    }

                    public void onSendComplete() {
                    }
                });
            }

            public void doResponse(final String cmd, Object data) throws IOException {
                if (data instanceof OperationFuture) {
                    long waiMills = WaitResultTimeout.getAndRemove((long)15000L);
                    if (waiMills <= 0L) {
                        waiMills = 15000L;
                    }
                    OperationFuture opf = (OperationFuture)data;
                    opf.addCompleteListener(new OperationFuture.CompleteListener(){

                        public void operationComplete(OperationFuture future) {
                            if (future.isCancelled()) {
                                this.doResponseX(new ResultResponseMap("501", "operation canceled"));
                            } else if (future.getException() != null) {
                                LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result returns an exception"), future.getException());
                                this.doResponseX(new ResultResponseMap("500", "Internal business processing exception"));
                            } else if (future.getResult() == null) {
                                LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result returns NULL"));
                                this.doResponseX(new ResultResponseMap("502", "Asynchronous processing business return null"));
                            } else {
                                this.doResponseX(future.getResult());
                            }
                        }

                        public void waitCompleteTimeout() {
                            LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result timeout"));
                            this.doResponseX(new ResultResponseMap("501", "Asynchronous processing business timeout"));
                        }

                        private void doResponseX(Object obj) {
                            try {
                                this.doResponse0(cmd, obj);
                            }
                            catch (Throwable ex) {
                                LogUtil.getLog().warn((Object)("Response: " + cmd + ", Excption!" + ex.getMessage()));
                            }
                        }
                    }, waiMills, TimeUnit.MILLISECONDS);
                } else {
                    this.doResponse0(cmd, data);
                }
            }
        };
    }

    public CloudDataProtocol createDataRequest(String cmd, Object data) {
        return this.createDataRequest(cmd, this.createMsgId(cmd, data), data);
    }

    public CloudDataProtocol createDataRequest(String cmd, String msgId, Object data) {
        CloudDataProtocol p = new CloudDataProtocol();
        p.setId(this.getId());
        p.setName(this.context.getName());
        p.setCmd(cmd);
        p.setMsgId(msgId);
        p.setData(data);
        p.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        return p;
    }

    protected String createMsgId(String cmd, Object data) {
        return "websock-client-" + ServiceUtil.getServiceContext().createLongSeq();
    }

    protected void hanldeReceiveData(final CloudDataProtocol p) throws Exception {
        if (!p.getId().equals(this.getId())) {
            ServiceLog.getLog().warn((Object)"id\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662f\u4fee\u6539\u914d\u7f6e\u5bfc\u81f4\uff0c\u8fd9\u5c06\u65ad\u5f00\u8fde\u63a5");
            this.destroy();
            return;
        }
        if (!p.getName().equals(this.context.getName())) {
            ServiceLog.getLog().warn((Object)"name\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662f\u4fee\u6539\u914d\u7f6e\u5bfc\u81f4\uff0c\u8fd9\u5c06\u65ad\u5f00\u8fde\u63a5");
            this.destroy();
            return;
        }
        if (p.getCmd().endsWith(this.context.getResponseEndFlag())) {
            final CloudDataResponseCallback callbak = (CloudDataResponseCallback)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject(this.getWaitResponseKey(p));
            if (callbak != null && p != null) {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            callbak.onResponse(p);
                        }
                        catch (Exception e) {
                            CloudWebsocketConnection.this.exceptionCaught(e);
                        }
                    }
                });
            }
        } else {
            final CloudServiceAction action = this.context.getCloudServiceAction(p.getCmd());
            if (action != null) {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IOResponse re = CloudWebsocketConnection.this.createIOResponse(p.getMsgId());
                            action.execute(p, re);
                        }
                        catch (Exception e) {
                            CloudWebsocketConnection.this.exceptionCaught(e);
                        }
                    }
                });
            } else {
                CloudResultResponse res = new CloudResultResponse();
                res.setResponseCode("404");
                res.setResponseMsg("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u547d\u4ee4: " + p.getCmd() + ", \u6b64\u670d\u52a1\u4e0d\u6388\u652f\u6301\uff01");
                IOResponse re = this.createErrorResponse(p.getMsgId());
                re.doResponse(String.valueOf(p.getCmd()) + this.context.getResponseEndFlag(), (Object)res);
            }
        }
    }

    protected Object createWaitResponseKey(CloudDataProtocol request) {
        return new CloudWebsockWaitResponseKey(request.getMsgId(), String.valueOf(request.getCmd()) + this.context.getResponseEndFlag(), request.getId(), request.getName());
    }

    protected Object getWaitResponseKey(CloudDataProtocol response) {
        return new CloudWebsockWaitResponseKey(response.getMsgId(), response.getCmd(), response.getId(), response.getName());
    }

    public long getDefaultResponseTimeout() {
        return this.defaultResponseTimeout;
    }

    public void setDefaultResponseTimeout(long defaultResponseTimeout) {
        if (defaultResponseTimeout > 0L) {
            this.defaultResponseTimeout = defaultResponseTimeout;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSignKey() {
        return this.signKey;
    }

    private static class CloudWebsockWaitResponseKey {
        private String msgId;
        private String cmd;
        private String id;
        private String name;

        private CloudWebsockWaitResponseKey(String msgId, String cmd, String id, String name) {
            this.msgId = msgId;
            this.cmd = cmd;
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cmd == null ? 0 : this.cmd.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.msgId == null ? 0 : this.msgId.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CloudWebsockWaitResponseKey other = (CloudWebsockWaitResponseKey)obj;
            if (this.cmd == null ? other.cmd != null : !this.cmd.equals(other.cmd)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.msgId == null ? other.msgId != null : !this.msgId.equals(other.msgId)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

