/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.AuthInfo;
import com.wovoe.carpark.ParkingSpace;
import com.wovoe.carpark.WanNetHostSelector;
import com.wovoe.carpark.cloud.CarparkCloudConnection;
import com.wovoe.carpark.cloud.CarparkCloudTransferCrypto;
import com.wovoe.carpark.cloud.CarparkHeartBeat;
import com.wovoe.carpark.cloud.CarparkUploadPicOssConfig;
import com.wovoe.carpark.cloud.CloudCometConnection;
import com.wovoe.carpark.cloud.CloudContext;
import com.wovoe.carpark.cloud.CloudDataConnection;
import com.wovoe.carpark.cloud.CloudDataProtocol;
import com.wovoe.carpark.cloud.CloudDataResponseCallback;
import com.wovoe.carpark.cloud.CloudReceiveClassManager;
import com.wovoe.carpark.cloud.CloudServiceAction;
import com.wovoe.carpark.cloud.CloudWebsocketConnection;
import com.wovoe.carpark.cloud.ParseException;
import com.wovoe.carpark.cloud.WebsocketCloudTest;
import com.wovoe.carpark.cloud.cos.COSConfig;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.remote.CloudMsgService;
import com.wovoe.carpark.vo.HostEquipmentSate;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.HardWareInfo;
import com.wovoe.framework.HardWareUtils;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.transfer.TransferCrypto;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class DefaultCarparkCloudConnection
extends JobTask
implements CarparkCloudConnection {
    protected static final String CARPARK_CONN_NAME = "carpark";
    protected volatile CloudDataConnection cloudDataConnection = null;
    protected volatile boolean destoryed = false;
    protected WebSocketClient client = new WebSocketClient(new SslContextFactory(true));
    protected ScheduledFuture<?> job;
    protected CarparkCloudTransferCrypto carparkCloudTransferCrypto;
    protected CloudContext cloudContext;
    protected String accessToken;
    protected long validTokenTimeMills;
    protected CarparkUploadPicOssConfig ossConfig;
    protected COSConfig cosConfig;
    protected volatile String connectDomain;
    protected volatile String uploadDataDomains;
    protected volatile String uploadPicDomains;
    protected volatile int uploadPicMethod = 2;

    public DefaultCarparkCloudConnection(CloudContext cloudContext) {
        this.cloudContext = cloudContext;
    }

    protected boolean checkIsValidRun() {
        CarparkHost localhost = ServiceUtil.getServiceContext().getLocalHost();
        if (localhost == null) {
            return false;
        }
        boolean isServer = false;
        if (localhost.getHost_use() == 2 || localhost.getHost_use() == 3) {
            isServer = true;
        }
        return isServer;
    }

    protected void doRun() throws Exception {
        if (this.destoryed) {
            return;
        }
        if (!this.checkIsValidRun()) {
            return;
        }
        if (ServiceUtil.getServiceContext().getAuthInfo() == null) {
            return;
        }
        String connId = this.getId();
        String cloudSignKey = this.getSignKey();
        if (connId == null || connId.length() < 10 || cloudSignKey == null || cloudSignKey.length() < 10) {
            if (this.cloudDataConnection != null && this.cloudDataConnection.isConnected()) {
                this.cloudDataConnection.destroy();
                this.cloudDataConnection = null;
            }
            return;
        }
        if (!(this.cloudDataConnection == null || !this.cloudDataConnection.isConnected() || this.cloudDataConnection.getId().equals(connId) && this.cloudDataConnection.getSignKey().equals(cloudSignKey))) {
            this.cloudDataConnection.destroy();
            this.cloudDataConnection = null;
        }
        if (this.cloudDataConnection == null || !this.cloudDataConnection.isConnected()) {
            String connectDomian;
            boolean canUseHttpConnectCloud;
            if (this.cloudDataConnection != null && !this.cloudDataConnection.isDestroy()) {
                this.cloudDataConnection.destroy();
            }
            boolean checkDomain = true;
            String connectHost = this.obtianConnectHost();
            if (connectHost != null && connectHost.length() > 0) {
                this.connectDomain = connectHost;
            }
            if (this.connectDomain == null || this.connectDomain.length() == 0) {
                ServiceLog.getLog().warn((Object)"\u65e0\u6cd5\u627e\u5230\u5408\u9002\u7684\u4e91\u7aef\u8fde\u63a5\u5730\u5740\uff01\u8bf7\u68c0\u67e5\u7f51\u7edc");
                return;
            }
            boolean useSecureConnectHttp = false;
            if (checkDomain && !(canUseHttpConnectCloud = this.canHttpConnectCloud(connectDomian = this.getConnectCloudDomin(), useSecureConnectHttp))) {
                ServiceLog.getLog().warn((Object)"\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff01\u8bf7\u68c0\u67e5\u7f51\u7edc");
                return;
            }
            if (this.destoryed) {
                return;
            }
            this.makesureWebSocketCleintStarted();
            boolean canuseWebsocket = false;
            String connectDomian2 = this.getConnectCloudDomin();
            boolean mustUseSecureConnectWebsocket = false;
            if (this.client.isStarted()) {
                if (WebsocketCloudTest.testCanUseWebsockt(connectDomian2, this.getName(), this.client, mustUseSecureConnectWebsocket)) {
                    canuseWebsocket = true;
                } else if (!WanNetHostSelector.isIpV4(connectDomian2) && WebsocketCloudTest.testCanUseWebsockt(connectDomian2, this.getName(), this.client, true)) {
                    mustUseSecureConnectWebsocket = true;
                    canuseWebsocket = true;
                }
            }
            if (canuseWebsocket) {
                CloudWebsocketConnection websocketConn = new CloudWebsocketConnection(this, connId, cloudSignKey);
                this.cloudDataConnection = websocketConn;
                String connPath = String.valueOf(mustUseSecureConnectWebsocket ? "wss://" : "ws://") + connectDomian2 + "/core/webclient/websocket/transferconn/" + this.getName() + "?connParam=" + this.getConnetParm();
                websocketConn.connect(connPath, this.client);
                if (!websocketConn.isConnected() && !websocketConn.isDestroy()) {
                    websocketConn.destroy();
                }
                return;
            }
            CloudCometConnection connection = new CloudCometConnection(this, connId, cloudSignKey);
            this.cloudDataConnection = connection;
            connection.connect();
            if (!connection.isConnected() && !connection.isDestroy()) {
                connection.destroy();
            }
            return;
        }
        long activTimeMills = this.cloudDataConnection instanceof CloudCometConnection ? ((CloudCometConnection)this.cloudDataConnection).getActivTimeMills() : (this.cloudDataConnection instanceof CloudWebsocketConnection ? ((CloudWebsocketConnection)this.cloudDataConnection).getActivTimeMills() : 0L);
        if (ServiceUtil.getServiceContext().currentTimeMillis() - activTimeMills >= 30000L) {
            ServiceLog.getLog().warn((Object)"\u68c0\u6d4b\u5230\u8fde\u63a5\u6d3b\u52a8\u5f02\u5e38\uff01\u8fd9\u5c06\u5f3a\u5236\u65ad\u5f00\u8fde\u63a5!");
            this.cloudDataConnection.destroy();
            return;
        }
        long cmi = ServiceUtil.getServiceContext().currentTimeMillis();
        if (cmi >= this.validTokenTimeMills || this.validTokenTimeMills - cmi <= TimeUnit.MINUTES.toMillis(10L)) {
            this.obtainAccessToken(this.cloudDataConnection);
        } else {
            this.sendHeartBeat(this.cloudDataConnection);
        }
    }

    protected boolean canHttpConnectCloud(String host, boolean secureConnect) {
        try {
            String url = String.valueOf(secureConnect ? "https://" : "http://") + host + "/core/webclient/comet/transferconn?name=" + this.getName() + "&connParam=testConn";
            String result = HttpUtil.doRequest((String)url, null, null);
            return "SUCCESS".equals(result);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void send(CloudDataProtocol dataRequest, CloudDataResponseCallback responseCallback, long waitResposeTimeout) {
        CloudDataConnection cloudDataConnection0 = this.cloudDataConnection;
        if (cloudDataConnection0 != null && cloudDataConnection0.isConnected()) {
            cloudDataConnection0.send(dataRequest, responseCallback, waitResposeTimeout);
        } else if (responseCallback != null) {
            responseCallback.onException(new IOException("send error! not connect cloud server!"));
        } else {
            ServiceLog.getLog().warn((Object)"send error! not connect cloud server!");
        }
    }

    protected synchronized void closeCloudDataConnection() {
        try {
            CloudDataConnection cloudDataConnection0 = this.cloudDataConnection;
            if (cloudDataConnection0 != null) {
                cloudDataConnection0.destroy();
                this.cloudDataConnection = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void destroy() {
        if (!this.destoryed) {
            this.destoryed = true;
            if (this.job != null) {
                this.job.cancel(true);
                this.job = null;
            }
            this.closeCloudDataConnection();
            try {
                if (this.client.isStarted() || this.client.isStarting()) {
                    this.client.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.client.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void makesureWebSocketCleintStarted() {
        block7: {
            try {
                if (this.destoryed) {
                    return;
                }
                if (this.client.isStarted()) {
                    return;
                }
                if (!this.client.isStarting()) {
                    this.client.start();
                }
                if (!this.client.isStarting()) break block7;
                int i = 0;
                while (i < 10) {
                    Thread.sleep(500L);
                    if (this.client.isStarting() || !this.client.isStarted()) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u542f\u52a8websocketclient\u5f02\u5e38!" + ex.getMessage()));
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.destoryed) {
            return;
        }
        if (this.job != null) {
            return;
        }
        this.job = ServiceUtil.getServiceContext().schedule(this, 6000L, 10000L, TimeUnit.MILLISECONDS);
        if (!this.client.isStarted() && !this.client.isStarting()) {
            try {
                this.client.start();
            }
            catch (Exception e) {
                ServiceLog.getLog().error((Object)("\u542f\u52a8websocketclient\u5f02\u5e38!" + e.getMessage()));
            }
        }
    }

    @Override
    public boolean isDestroy() {
        return this.destoryed;
    }

    @Override
    public boolean isConnected() {
        CloudDataConnection c = this.cloudDataConnection;
        return c != null && c.isConnected();
    }

    @Override
    public boolean isStarted() {
        if (this.isDestroy()) {
            return false;
        }
        return this.job != null;
    }

    @Override
    public String getConnectCloudDomin() {
        return this.connectDomain;
    }

    @Override
    public String getObtainConnectDomain() {
        return ServiceUtil.getCloudConnectDomain();
    }

    @Override
    public String getName() {
        return CARPARK_CONN_NAME;
    }

    @Override
    public String getSignKey() {
        Carpark carpark = ServiceUtil.getServiceContext().getCarpark();
        if (carpark == null) {
            return null;
        }
        String signKey = carpark.getCloud_carpark_sign_key();
        if (signKey == null || signKey.length() == 0) {
            return signKey;
        }
        if (signKey.length() != 32) {
            try {
                Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                signKey = CryptoUtil.decrypt((String)signKey, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
                carpark.setCloud_carpark_sign_key(signKey);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u8f66\u573a\u4e91api\u79d8\u94a5\u914d\u7f6e\u9519\u8bef\uff01");
                return null;
            }
        }
        return signKey;
    }

    @Override
    public CloudReceiveClassManager getCloudReceiveClassManager() {
        return this.cloudContext.getCloudReceiveClassManager();
    }

    @Override
    public String getResponseEndFlag() {
        return this.cloudContext.getResponseEndFlag();
    }

    @Override
    public String getId() {
        Carpark carpark = ServiceUtil.getServiceContext().getCarpark();
        if (carpark == null) {
            return null;
        }
        return carpark.getCloud_carpark_id();
    }

    @Override
    public CloudServiceAction getCloudServiceAction(String requestCmd) {
        return this.cloudContext.getCloudServiceActionManager().getServiceAction(requestCmd);
    }

    @Override
    public CloudContext getCloudContext() {
        return this.cloudContext;
    }

    @Override
    public String getConnetParm() {
        try {
            AuthInfo authInfo = ServiceUtil.getServiceContext().getAuthInfo();
            HardWareInfo hardWarInfo = HardWareUtils.getHardWareInfo();
            LinkedHashMap<String, String> hostInfoMap = new LinkedHashMap<String, String>();
            hostInfoMap.put("motherboardSn", hardWarInfo.getMotherboardSn() == null ? "" : hardWarInfo.getMotherboardSn());
            hostInfoMap.put("hardDiskSn", hardWarInfo.getHardDiskSn() == null ? "" : hardWarInfo.getHardDiskSn());
            hostInfoMap.put("mac", hardWarInfo.getMac() == null ? "" : hardWarInfo.getMac());
            hostInfoMap.put("cpuSn", hardWarInfo.getCpuSn() == null ? "" : hardWarInfo.getCpuSn());
            hostInfoMap.put("osName", System.getProperty("os.name"));
            LinkedHashMap<String, Object> requestMap = new LinkedHashMap<String, Object>();
            requestMap.put("sn", authInfo.isOfficial() ? authInfo.getSn() : "trial");
            requestMap.put("hostNo", ServiceUtil.getServiceContext().getLocalHost().getHost_no());
            requestMap.put("authMode", String.valueOf(authInfo.getAuthMode()));
            requestMap.put("hostInfo", hostInfoMap);
            requestMap.put("ver", ServiceUtil.getServiceContext().getVersion());
            CloudDataProtocol p1 = new CloudDataProtocol();
            p1.setId(this.getId());
            p1.setName(this.getName());
            p1.setCmd("connect");
            p1.setMsgId("connect-" + ServiceUtil.getServiceContext().createLongSeq());
            p1.setData(requestMap);
            p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
            return p1.toSendString(this.getSignKey(), this.cloudContext.getCloudConnTransferCrypto());
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleConnectMessage(String message, CloudDataConnection conn) {
        try {
            CloudDataProtocol p;
            if (message.startsWith("ERROR:")) {
                ServiceLog.getLog().warn((Object)("\u8fde\u63a5\u4e91\u670d\u52a1\u5668\u5931\u8d25\uff01\u539f\u56e0:" + message));
                return false;
            }
            try {
                p = CloudDataProtocol.parse(message, this.getSignKey(), this.cloudContext.getCloudConnTransferCrypto(), null);
            }
            catch (ParseException e) {
                ServiceLog.getLog().warn((Object)("\u670d\u52a1\u5668\u53d1\u9001\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e\uff01" + e.getMessage()));
                return false;
            }
            if (!("connect" + this.getResponseEndFlag()).equals(p.getCmd())) {
                ServiceLog.getLog().warn((Object)("\u670d\u52a1\u5668\u5fc5\u987b\u5148\u53d1\u9001\u8fde\u63a5\u6210\u529f\u6570\u636e\uff01\u4f46\u662f\u6536\u5230\uff1a" + p.getCmd()));
                return false;
            }
            if (!this.getId().equals(p.getId())) {
                ServiceLog.getLog().warn((Object)("\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u7684id\u9519\u8bef\uff01\u670d\u52a1\u5668\u8fd4\u56deid\uff1a" + p.getId()));
                return false;
            }
            if (!this.getName().equals(p.getName())) {
                ServiceLog.getLog().warn((Object)("\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u7684name\u9519\u8bef\uff01\u670d\u52a1\u5668\u8fd4\u56dename\uff1a" + p.getName()));
                return false;
            }
            if (p.getData() == null) {
                ServiceLog.getLog().warn((Object)"\u8fde\u63a5\u7ed3\u679c\u6570\u636e\u672a\u8fd4\u56de");
                return false;
            }
            Map connectMap = (Map)p.getData();
            String responseCode = (String)connectMap.get("responseCode");
            if (responseCode == null || responseCode.length() == 0) {
                ServiceLog.getLog().warn((Object)"\u8fde\u63a5\u7ed3\u679c\u7f3a\u5c11\u6570\u636e");
                return false;
            }
            if (!"0".equals(responseCode)) {
                ServiceLog.getLog().warn((Object)("\u8fde\u63a5\u5931\u8d25\uff01\u9519\u8bef\uff1a" + responseCode + ", " + connectMap.get("responseMsg")));
                return false;
            }
            String token = (String)connectMap.get("token");
            String tokenTimeoutMins0 = (String)connectMap.get("tokenTimeoutMins");
            String connKey = (String)connectMap.get("connKey");
            if (token == null || token.length() == 0 || tokenTimeoutMins0 == null || tokenTimeoutMins0.length() == 0 || connKey == null || connKey.length() == 0) {
                ServiceLog.getLog().warn((Object)"\u8fde\u63a5\u7ed3\u679c\u7f3a\u5c11\u6570\u636e");
                return false;
            }
            if (conn instanceof CloudCometConnection) {
                String requestPath = (String)connectMap.get("requestPath");
                if (requestPath == null || requestPath.length() == 0) {
                    ServiceLog.getLog().warn((Object)"\u8fde\u63a5\u7ed3\u679c\u7f3a\u5c11\u6570\u636e");
                    return false;
                }
                if (!requestPath.startsWith("/")) {
                    requestPath = "/" + requestPath;
                }
                String cometRequestURL = "http://" + this.getConnectCloudDomin() + requestPath;
                ((CloudCometConnection)conn).setCometRequestURL(cometRequestURL);
            }
            this.carparkCloudTransferCrypto = new CarparkCloudTransferCrypto(BytesTool.unCompress((String)connKey));
            this.accessToken = token;
            this.validTokenTimeMills = ServiceUtil.getServiceContext().currentTimeMillis() + TimeUnit.MINUTES.toMillis(Long.parseLong(tokenTimeoutMins0));
            this.uploadDataDomains = (String)connectMap.get("uploadDataDomains");
            this.checkAndLoadUploadPicInfo(connectMap);
            return this.handleConnectMap(connectMap);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
            return false;
        }
    }

    protected void checkAndLoadUploadPicInfo(Map<?, ?> connectMap) {
        this.checkAndLoadOssConfig(connectMap);
        this.checkAndLoadCosConfig(connectMap);
        this.uploadPicDomains = (String)connectMap.get("uploadPicDomains");
        String _uploadPicMethod = (String)connectMap.get("uploadPicMethod");
        if (_uploadPicMethod != null && _uploadPicMethod.length() > 0) {
            this.uploadPicMethod = Integer.parseInt(_uploadPicMethod);
        }
    }

    protected void checkAndLoadOssConfig(Map<?, ?> connectMap) {
        Map uploadPicOssConfig = (Map)connectMap.get("uploadPicOssConfig");
        if (uploadPicOssConfig != null && !uploadPicOssConfig.isEmpty()) {
            String accessKeySecret;
            CarparkUploadPicOssConfig ossConfig1 = new CarparkUploadPicOssConfig();
            ossConfig1.setAccessKeyId((String)uploadPicOssConfig.get("accessKeyId"));
            String keysec = (String)uploadPicOssConfig.get("accessKeySecret");
            try {
                accessKeySecret = new String(BytesTool.unCompress((String)keysec), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                accessKeySecret = new String(BytesTool.unCompress((String)keysec));
            }
            ossConfig1.setAccessKeySecret(accessKeySecret);
            ossConfig1.setBasicPath((String)uploadPicOssConfig.get("basicPath"));
            ossConfig1.setBucket((String)uploadPicOssConfig.get("bucket"));
            ossConfig1.setDomain((String)uploadPicOssConfig.get("domain"));
            this.ossConfig = ossConfig1;
        } else {
            this.ossConfig = null;
        }
    }

    protected void checkAndLoadCosConfig(Map<?, ?> connectMap) {
        Map uploadPicCosConfig = (Map)connectMap.get("uploadPicCosConfig");
        if (uploadPicCosConfig != null && !uploadPicCosConfig.isEmpty()) {
            String accessKeySecret;
            COSConfig ossConfig1 = new COSConfig();
            ossConfig1.setSecretId((String)uploadPicCosConfig.get("secretId"));
            String keysec = (String)uploadPicCosConfig.get("seretKey");
            try {
                accessKeySecret = new String(BytesTool.unCompress((String)keysec), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                accessKeySecret = new String(BytesTool.unCompress((String)keysec));
            }
            ossConfig1.setSeretKey(accessKeySecret);
            ossConfig1.setRegion((String)uploadPicCosConfig.get("region"));
            ossConfig1.setBucket((String)uploadPicCosConfig.get("bucket"));
            ossConfig1.setBasicPath((String)uploadPicCosConfig.get("basicPath"));
            ossConfig1.setDomain((String)uploadPicCosConfig.get("domain"));
            ossConfig1.setStorageClass((String)uploadPicCosConfig.get("storageClass"));
            if (ossConfig1.getDomain() == null || ossConfig1.getDomain().length() == 0) {
                ossConfig1.setDomain(ossConfig1.generateDomain());
            }
            this.cosConfig = ossConfig1;
        } else {
            this.cosConfig = null;
        }
    }

    @Override
    public COSConfig getCarparkUploadPicCosConfig() {
        return this.cosConfig;
    }

    protected boolean handleConnectMap(Map<?, ?> connectMap) {
        return true;
    }

    @Override
    public CarparkUploadPicOssConfig getCarparkUploadPicOssConfig() {
        return this.ossConfig;
    }

    @Override
    public TransferCrypto getTransferCrypto() {
        return this.carparkCloudTransferCrypto;
    }

    @Override
    public String getValidAccessToken() {
        long cmi = ServiceUtil.getServiceContext().currentTimeMillis();
        if (cmi < this.validTokenTimeMills) {
            return this.accessToken;
        }
        return null;
    }

    protected String obtianConnectHost() {
        try {
            String vc = RandomStringGenerator.getDefaultInstance().getNewString(16);
            TransferCrypto crypto = this.cloudContext.getCloudConnTransferCrypto();
            String vb = crypto.encrypt(vc);
            String url = "http://" + this.getObtainConnectDomain() + "/core/gateway/carpark/obtianConnectAddress?vc=" + vc + "&vb=" + vb;
            String result = HttpUtil.doRequest((String)url, null, null);
            String vx = crypto.decrypt(result);
            String sx = "connectHost=";
            if (vx.startsWith(sx)) {
                return vx.substring(sx.length()).trim();
            }
            return null;
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u83b7\u53d6\u8fde\u63a5\u5730\u5740! " + ex.getMessage()));
            return null;
        }
    }

    protected void sendHeartBeat(final CloudDataConnection conn) {
        if (conn == null || !conn.isConnected()) {
            return;
        }
        CarparkHeartBeat d = new CarparkHeartBeat();
        d.setVer(ServiceUtil.getServiceContext().getVersion());
        Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
        int total = 0;
        int reamin = 0;
        ParkingSpace space = ParkingSpace.getInstance();
        if (areaMap != null && !areaMap.isEmpty()) {
            for (CarparkArea a : areaMap.values()) {
                if (a.getArea_level() != 1) continue;
                total += space.getToatalSpace(a.getArea_no());
                reamin += space.getRemainSpace(a.getArea_no());
            }
        }
        d.setTotal(total);
        d.setRemain(reamin);
        HashMap<String, List<String>> hnos = new HashMap<String, List<String>>();
        HashMap<String, String> eqs = new HashMap<String, String>();
        if (hostMap != null && !hostMap.isEmpty()) {
            for (CarparkHost host : hostMap.values()) {
                Map<String, String> m1;
                List<String> pl;
                HostEquipmentSate state = ServiceUtil.getServiceContext().getHostEquipmentSateManager().getHostEquipmentSate(host.getHost_no());
                if (state == null) continue;
                LinkedList<String> list = (LinkedList<String>)hnos.get(host.getHost_no());
                if (list == null) {
                    list = new LinkedList<String>();
                    hnos.put(host.getHost_no(), list);
                }
                if ((pl = state.getProxyChNos()) != null && !pl.isEmpty()) {
                    list.addAll(pl);
                }
                if ((m1 = state.getEqSates()) == null || m1.isEmpty()) continue;
                for (Map.Entry<String, String> e : m1.entrySet()) {
                    if (e.getKey() == null || e.getKey().length() <= 0 || e.getValue() == null || e.getValue().length() <= 0 || EquipmentState.DISCONNECTED.name().equals(e.getValue())) continue;
                    String v = null;
                    if (EquipmentState.CONNECTED.name().equals(e.getValue())) {
                        v = "1";
                    } else if (EquipmentState.BARRIER_RAISING.name().equals(e.getValue())) {
                        v = "2";
                    } else if (EquipmentState.BARRIER_DROPPING.name().equals(e.getValue())) {
                        v = "3";
                    } else if (EquipmentState.BARRIER_RAISED_IN_PLACE.name().equals(e.getValue())) {
                        v = "2";
                    } else if (EquipmentState.BARRIER_DROPPED_IN_PLACE.name().equals(e.getValue())) {
                        v = "3";
                    } else if (EquipmentState.BARRIER_STOPPED.name().equals(e.getValue())) {
                        v = "1";
                    }
                    eqs.put(e.getKey(), v);
                }
            }
        }
        d.setHnos(hnos);
        d.setEqs(eqs);
        d.setcMills(System.currentTimeMillis());
        CloudDataProtocol p1 = new CloudDataProtocol();
        p1.setId(this.getId());
        p1.setName(this.getName());
        p1.setCmd("carparkRemoteService.heartBeat");
        p1.setMsgId("heartbeat-" + ServiceUtil.getServiceContext().createLongSeq());
        p1.setData(d);
        p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        try {
            conn.send(p1, new CloudDataResponseCallback(){

                @Override
                public void onException(Throwable ex) {
                    ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5fc3\u8df3\u5f02\u5e38: " + ex.getMessage()));
                }

                @Override
                public void onWaitTimeout() {
                    ServiceLog.getLog().warn((Object)"\u53d1\u9001\u5fc3\u8df3\u54cd\u5e94\u8d85\u65f6: ");
                }

                @Override
                public void onResponse(CloudDataProtocol response) throws Exception {
                    if (response.getData() == null) {
                        ServiceLog.getLog().warn((Object)"\u5fc3\u8df3\u54cd\u5e94\u9519\u8bef\u7f3a\u5c11\u6570\u636e\uff01");
                    } else {
                        String uploadPicDomains1;
                        long now;
                        Map dataMap = (Map)response.getData();
                        String responseCode = (String)dataMap.get("responseCode");
                        if (responseCode == null || responseCode.length() == 0) {
                            ServiceLog.getLog().warn((Object)"\u53d1\u9001\u5fc3\u8df3\u54cd\u5e94\u9519\u8bef \u7f3a\u5c11\u54cd\u5e94\u7801");
                            return;
                        }
                        if (!"0".equals(responseCode)) {
                            ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5fc3\u8df3\u54cd\u5e94\u9519\u8bef\uff01\u9519\u8bef\uff1a" + responseCode + ", " + dataMap.get("responseMsg")));
                            return;
                        }
                        long serverSystemMills = Long.parseLong(dataMap.get("serverSystemMills").toString());
                        if (!conn.isDestroy()) {
                            if (conn instanceof CloudCometConnection) {
                                ((CloudCometConnection)conn).updateActiveState();
                            } else if (conn instanceof CloudWebsocketConnection) {
                                ((CloudWebsocketConnection)conn).updateActiveState();
                            }
                        }
                        if (Math.abs((now = System.currentTimeMillis()) - serverSystemMills) > 10000L) {
                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            ServiceLog.getLog().warn((Object)("\u53d1\u73b0\u4e91\u670d\u52a1\u5668\u65f6\u95f4\uff1a" + df.format(new Date(serverSystemMills)) + ",\u4e0e\u5f53\u524d\u8f66\u573a\u670d\u52a1\u5668\u7cfb\u7edf\u65f6\u95f4\uff1a" + df.format(new Date(now)) + "\u5b58\u5728\u8bef\u5dee\uff0c\u8fd9\u5c06\u540c\u6b65\u670d\u52a1\u5668\u65f6\u95f4"));
                            ServiceUtil.setSystemTime(new Date(serverSystemMills));
                        }
                        if ((uploadPicDomains1 = (String)dataMap.get("uploadPicDomains")) != null) {
                            DefaultCarparkCloudConnection.this.uploadPicDomains = uploadPicDomains1;
                        }
                    }
                }
            }, 8000L);
        }
        catch (Exception e) {
            ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5fc3\u8df3\u9519\u8bef\u3002\u3002\u3002" + e.getMessage()));
        }
    }

    @Override
    public int getUploadPicMethod() {
        return this.uploadPicMethod;
    }

    @Override
    public CloudDataConnection getLocalCloudDataConnection() {
        return this.cloudDataConnection;
    }

    @Override
    public void obtainAccessToken(final CloudDataConnection conn) {
        if (conn == null || !conn.isConnected()) {
            return;
        }
        HardWareInfo hardWarInfo = HardWareUtils.getHardWareInfo();
        LinkedHashMap<String, String> hostInfoMap = new LinkedHashMap<String, String>();
        hostInfoMap.put("motherboardSn", hardWarInfo.getMotherboardSn() == null ? "" : hardWarInfo.getMotherboardSn());
        hostInfoMap.put("hardDiskSn", hardWarInfo.getHardDiskSn() == null ? "" : hardWarInfo.getHardDiskSn());
        hostInfoMap.put("mac", hardWarInfo.getMac() == null ? "" : hardWarInfo.getMac());
        hostInfoMap.put("cpuSn", hardWarInfo.getCpuSn() == null ? "" : hardWarInfo.getCpuSn());
        hostInfoMap.put("osName", System.getProperty("os.name"));
        HashMap<String, LinkedHashMap<String, String>> d = new HashMap<String, LinkedHashMap<String, String>>();
        d.put("hostInfo", hostInfoMap);
        CloudDataProtocol p1 = new CloudDataProtocol();
        p1.setId(this.getId());
        p1.setName(this.getName());
        p1.setCmd("carparkRemoteService.obtainToken");
        p1.setMsgId("obtainToken-" + ServiceUtil.getServiceContext().createLongSeq());
        p1.setData(d);
        p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        try {
            conn.send(p1, new CloudDataResponseCallback(){

                @Override
                public void onException(Throwable ex) {
                    ServiceLog.getLog().warn((Object)("\u83b7\u53d6token\u5f02\u5e38: " + ex.getMessage()));
                }

                @Override
                public void onWaitTimeout() {
                    ServiceLog.getLog().warn((Object)"\u83b7\u53d6token\u54cd\u5e94\u8d85\u65f6!");
                }

                @Override
                public void onResponse(CloudDataProtocol response) throws Exception {
                    if (response.getData() == null) {
                        ServiceLog.getLog().warn((Object)"\u83b7\u53d6token\u54cd\u5e94\u9519\u8bef\u7f3a\u5c11\u6570\u636e\uff01");
                    } else {
                        String uploadPicDomains1;
                        Map dataMap = (Map)response.getData();
                        String responseCode = (String)dataMap.get("responseCode");
                        if (responseCode == null || responseCode.length() == 0) {
                            ServiceLog.getLog().warn((Object)"\u83b7\u53d6token\u54cd\u5e94\u9519\u8bef \u7f3a\u5c11\u54cd\u5e94\u7801");
                            return;
                        }
                        if (!"0".equals(responseCode)) {
                            ServiceLog.getLog().warn((Object)("\u83b7\u53d6token\u54cd\u5e94\u9519\u8bef\uff01\u9519\u8bef\uff1a" + responseCode + ", " + dataMap.get("responseMsg")));
                            return;
                        }
                        String token = (String)dataMap.get("token");
                        String tokenTimeoutMins0 = (String)dataMap.get("tokenTimeoutMins");
                        if (token == null || token.length() == 0 || tokenTimeoutMins0 == null || tokenTimeoutMins0.length() == 0) {
                            ServiceLog.getLog().warn((Object)"\u83b7\u53d6token\u54cd\u5e94\u9519\u8bef\u7f3a\u5c11\u6570\u636e");
                            return;
                        }
                        DefaultCarparkCloudConnection.this.accessToken = token;
                        DefaultCarparkCloudConnection.this.validTokenTimeMills = ServiceUtil.getServiceContext().currentTimeMillis() + TimeUnit.MINUTES.toMillis(Long.parseLong(tokenTimeoutMins0));
                        if (!conn.isDestroy()) {
                            if (conn instanceof CloudCometConnection) {
                                ((CloudCometConnection)conn).updateActiveState();
                            } else if (conn instanceof CloudWebsocketConnection) {
                                ((CloudWebsocketConnection)conn).updateActiveState();
                            }
                        }
                        if ((uploadPicDomains1 = (String)dataMap.get("uploadPicDomains")) != null) {
                            DefaultCarparkCloudConnection.this.uploadPicDomains = uploadPicDomains1;
                        }
                        ServiceLog.getLog().info((Object)"\u6210\u529f\u83b7\u53d6\u65b0token!");
                    }
                }
            }, 8000L);
        }
        catch (Exception e) {
            ServiceLog.getLog().warn((Object)("\u83b7\u53d6token\u9519\u8bef\u3002\u3002\u3002" + e.getMessage()));
        }
    }

    protected String getDomain(String domain) {
        int index;
        if (domain == null || domain.length() == 0) {
            return this.getConnectCloudDomin();
        }
        if (domain.indexOf(44) == -1) {
            return domain;
        }
        String[] a = domain.split(",");
        String host = a[index = Math.abs(new Random().nextInt()) % a.length];
        if (host.length() == 0) {
            return a[0];
        }
        return host;
    }

    @Override
    public String getUploadDataDomain() {
        return this.getDomain(this.uploadDataDomains);
    }

    @Override
    public String getUploadPicDomain() {
        return this.getDomain(this.uploadPicDomains);
    }

    @Override
    public String getCarparkConnId() {
        return this.getId();
    }

    protected String getCarparkConnName() {
        return this.getName();
    }

    protected String getCarparkToken() {
        return this.getValidAccessToken();
    }

    protected String getCarparkSignKey() {
        return this.getSignKey();
    }

    protected TransferCrypto getCarparkTransferCrypto() {
        return this.getTransferCrypto();
    }

    @Override
    public KeyValueEntry<Integer, String> uploadPic(String path, String fileAbsolutePath) {
        CloudDataProtocol response;
        String result;
        String uploadPicDomain = this.getUploadPicDomain();
        if (uploadPicDomain == null || uploadPicDomain.length() == 0) {
            return new KeyValueEntry((Object)1, (Object)"\u65e0\u6cd5\u83b7\u53d6\u4e0a\u4f20\u56fe\u7247\u57df\u540d");
        }
        StringBuilder urlsbr = new StringBuilder(1024);
        urlsbr.append("http://").append(uploadPicDomain).append("/core/common/carpark/uploadPic.do");
        String parkIdStr = this.getCarparkConnId();
        String tokenStr = this.getCarparkToken();
        String signKey = this.getCarparkSignKey();
        TransferCrypto transferCrypto = this.getCarparkTransferCrypto();
        if (parkIdStr == null || parkIdStr.length() == 0 || signKey == null || signKey.length() == 0 || tokenStr == null || tokenStr.length() == 0 || transferCrypto == null) {
            return new KeyValueEntry((Object)1, (Object)"\u672a\u8fde\u63a5\u670d\u52a1\u5668");
        }
        String ranStr = RandomStringGenerator.getDefaultInstance().getNewString(16);
        StringBuilder sbr1 = new StringBuilder(parkIdStr.length() + tokenStr.length() + ranStr.length() + signKey.length());
        sbr1.append(parkIdStr).append(tokenStr).append(ranStr).append(signKey);
        String signStr = CryptoUtil.MD5Encode((String)sbr1.toString());
        urlsbr.append("?p=").append(parkIdStr).append("&t=").append(tokenStr).append("&r=").append(ranStr).append("&s=").append(signStr).append("&z=1");
        HashMap<String, String> fileMap = new HashMap<String, String>();
        String fileName = transferCrypto.encrypt(path);
        fileMap.put(fileName, fileAbsolutePath);
        try {
            Proxy proxy = WanNetHostSelector.getWanProxyHost(uploadPicDomain).getProxy();
            result = HttpUtil.uploadFile((String)urlsbr.toString(), null, null, fileMap, (int)10000, (int)20000, (Proxy)proxy);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u7f51\u7edc\u5f02\u5e38\uff01 " + ex.getMessage()));
            return new KeyValueEntry((Object)1, (Object)"\u4e0a\u4f20\u56fe\u7247\u7f51\u7edc\u5f02\u5e38\uff01");
        }
        if (result == null || result.length() == 0) {
            return new KeyValueEntry((Object)1, (Object)"\u4e0a\u4f20\u56fe\u7247\u670d\u52a1\u5668\u8fd4\u56de\u4e86\u7a7a\u6570\u636e\uff01");
        }
        try {
            response = CloudDataProtocol.parse(GsonBuilder.create(), result, signKey, transferCrypto, null);
        }
        catch (Exception ex) {
            return new KeyValueEntry((Object)1, (Object)("\u670d\u52a1\u5668\u8fd4\u56de\u4e86\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e: " + result));
        }
        Map dataMap = (Map)response.getData();
        if (dataMap == null) {
            return new KeyValueEntry((Object)1, (Object)"\u670d\u52a1\u5668\u8fd4\u56de\u4e86\u4e1a\u52a1\u6570\u636e\u4e3anull\u7684\u6570\u636e");
        }
        String resultCode = (String)dataMap.get("responseCode");
        if ("0".equals(resultCode)) {
            String resultState = (String)dataMap.get(String.valueOf(fileName) + "Result");
            if (resultState == null || resultState.length() == 0) {
                return new KeyValueEntry((Object)1, (Object)("\u670d\u52a1\u5668\u8fd4\u56de\u4e86\u4e1a\u52a1\u6570\u636e\u4e2d\u672a\u5305\u542b\u54cd\u5e94\u7ed3\u679c! \u4e1a\u52a1\u6570\u636e: " + dataMap));
            }
            if ("SUCCESS".equals(resultState)) {
                String serverPath = (String)dataMap.get(String.valueOf(fileName) + "ServerPath");
                if (serverPath == null || serverPath.length() == 0) {
                    return new KeyValueEntry((Object)1, (Object)("\u670d\u52a1\u5668\u8fd4\u56de\u4e86\u4e0a\u4f20\u6210\u529f\u6807\u8bc6\uff0c\u4f46\u672a\u8fd4\u56de\u670d\u52a1\u5668\u6587\u4ef6\u8def\u5f84\uff0c\u4e1a\u52a1\u6570\u636e: " + dataMap));
                }
                return new KeyValueEntry((Object)0, (Object)serverPath);
            }
            return new KeyValueEntry((Object)1, (Object)resultState);
        }
        return new KeyValueEntry((Object)1, (Object)("\u4e0a\u4f20\u56fe\u7247\u670d\u52a1\u5668\u8fd4\u56de\u9519\u8bef\uff1a " + dataMap.get("responseMsg")));
    }

    protected void handleScanPaySuccessMsg(final String successJson) {
        if (successJson == null || successJson.length() == 0) {
            return;
        }
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                Map authInfoMap = null;
                try {
                    authInfoMap = (Map)GsonBuilder.create().fromJson(successJson, new TypeToken<Map<String, String>>(){}.getType());
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u652f\u4ed8\u7801\u652f\u4ed8\u6210\u529f\u8fd4\u56de\u7684\u4e0d\u662fjson\u6570\u636e: " + successJson));
                }
                if (authInfoMap != null && !authInfoMap.isEmpty()) {
                    try {
                        CloudMsgService cloudMsgService = (CloudMsgService)ServiceUtil.getServiceContext().getService("cloudMsgService");
                        cloudMsgService.scanCodePaySuccess(authInfoMap, new HashMap<String, Object>());
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u5904\u7406\u652f\u4ed8\u7801\u652f\u4ed8\u6210\u529f\u5f02\u5e38: " + successJson + ", "), (Throwable)ex);
                    }
                }
            }
        });
    }

    @Override
    public Map<String, Object> doScanCodePay(Map<String, Object> paramMap) {
        String msg;
        CloudDataProtocol response;
        String result;
        if (!this.isConnected()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RETURN_CODE", "FAIL");
            map.put("RETURN_VALUE", "\u672a\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668");
            return map;
        }
        Gson gson = GsonBuilder.create();
        CloudDataProtocol sendRequest = new CloudDataProtocol();
        sendRequest.setId(this.getCarparkConnId());
        sendRequest.setCmd("carparkSyncDataService.scanCodePay");
        sendRequest.setData(paramMap);
        sendRequest.setMsgId("scanpcloud_" + ServiceUtil.getServiceContext().createLongSeq());
        sendRequest.setName(this.getCarparkConnName());
        sendRequest.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        String sendStr = sendRequest.toSendString(this.getCarparkSignKey(), this.getCarparkTransferCrypto());
        String accessToken = this.getCarparkToken();
        if (accessToken == null || accessToken.length() == 0) {
            this.obtainAccessToken(this.getLocalCloudDataConnection());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RETURN_CODE", "FAIL");
            map.put("RETURN_VALUE", "\u4e91\u7aef\u670d\u52a1\u5668token\u5931\u6548\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            return map;
        }
        String domain = this.getUploadDataDomain();
        String url = "http://" + domain + "/core/remote/gateway/rpc/transfer/invoke/" + accessToken;
        try {
            Proxy proxy = WanNetHostSelector.getWanProxyHost(domain).getProxy();
            result = HttpUtil.doJsonRquest((String)url, null, (String)sendStr, (Proxy)proxy);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u8fde\u63a5\u4e91\u7aef\u7f51\u7edc\u5f02\u5e38\uff1a" + ex.getMessage()));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RETURN_CODE", "FAIL");
            map.put("RETURN_VALUE", "\u8bf7\u6c42\u4e91\u7aef\u7f51\u7edc\u5f02\u5e38");
            return map;
        }
        try {
            response = CloudDataProtocol.parse(gson, result, this.getCarparkSignKey(), this.getCarparkTransferCrypto(), null);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u4ed8\u6b3e\u7801\u652f\u4ed8\u8bf7\u6c42\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e: " + result + ex.getMessage()));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RETURN_CODE", "FAIL");
            map.put("RETURN_VALUE", "\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e");
            return map;
        }
        Map resultMap = (Map)response.getData();
        String resultCode = (String)resultMap.get("responseCode");
        if ("0".equals(resultCode)) {
            String orderNo = (String)resultMap.get("responseMsg");
            if (orderNo == null || orderNo.length() == 0) {
                ServiceLog.getLog().warn((Object)("\u8b66\u544a\u670d\u52a1\u5668\u8fd4\u56deresponseCode\u6210\u529f\uff0c\u4f46\u662f\u7f3a\u5c11RESPONSE_MSG\u8ba2\u5355\u53f7\u6570\u636e\uff0c\u8bf7\u68c0\u67e5" + resultMap));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "FAIL");
                map.put("RETURN_VALUE", "\u7f3a\u5c11\u8ba2\u5355\u53f7");
                map.put("orderNo", orderNo);
                return map;
            }
            String RETURN_CODE = (String)resultMap.get("RETURN_CODE");
            String RETURN_VALUE = (String)resultMap.get("RETURN_VALUE");
            if (RETURN_CODE == null || RETURN_CODE.length() == 0) {
                ServiceLog.getLog().warn((Object)("\u8b66\u544a\u670d\u52a1\u5668\u8fd4\u56deresponseCode\u6210\u529f\uff0c\u4f46\u662f\u7f3a\u5c11RETURN_CODE\u6570\u636e\uff0c\u8bf7\u68c0\u67e5" + resultMap));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "FAIL");
                map.put("RETURN_VALUE", "\u652f\u4ed8\u5931\u8d25");
                map.put("orderNo", orderNo);
                return map;
            }
            if (RETURN_VALUE == null) {
                RETURN_VALUE = "";
            }
            if ("SUCCESS".equals(RETURN_CODE)) {
                this.handleScanPaySuccessMsg(RETURN_VALUE);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RETURN_CODE", RETURN_CODE);
            map.put("RETURN_VALUE", RETURN_VALUE);
            map.put("orderNo", orderNo);
            return map;
        }
        if (resultCode == null || resultCode.length() == 0) {
            resultCode = "ERROR";
        }
        if ((msg = (String)resultMap.get("responseMsg")) == null || msg.length() == 0) {
            msg = "\u652f\u4ed8\u5931\u8d25";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RETURN_CODE", resultCode);
        map.put("RETURN_VALUE", msg);
        return map;
    }

    @Override
    public Map<String, Object> doSenselessPay(Map<String, Object> paramMap) {
        String msg;
        CloudDataProtocol response;
        String result;
        if (!this.isConnected()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RETURN_CODE", "FAIL");
            map.put("RETURN_VALUE", "\u672a\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668");
            return map;
        }
        Gson gson = GsonBuilder.create();
        CloudDataProtocol sendRequest = new CloudDataProtocol();
        sendRequest.setId(this.getCarparkConnId());
        sendRequest.setCmd("carparkSyncDataService.senselessPay");
        sendRequest.setData(paramMap);
        sendRequest.setMsgId("senselesscloud_" + ServiceUtil.getServiceContext().createLongSeq());
        sendRequest.setName(this.getCarparkConnName());
        sendRequest.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        String sendStr = sendRequest.toSendString(this.getCarparkSignKey(), this.getCarparkTransferCrypto());
        String accessToken = this.getCarparkToken();
        if (accessToken == null || accessToken.length() == 0) {
            this.obtainAccessToken(this.getLocalCloudDataConnection());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RETURN_CODE", "FAIL");
            map.put("RETURN_VALUE", "\u4e91\u7aef\u670d\u52a1\u5668token\u5931\u6548\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            return map;
        }
        String domain = this.getUploadDataDomain();
        String url = "http://" + domain + "/core/remote/gateway/rpc/transfer/invoke/" + accessToken;
        try {
            Proxy proxy = WanNetHostSelector.getWanProxyHost(domain).getProxy();
            result = HttpUtil.doJsonRquest((String)url, null, (String)sendStr, (Proxy)proxy);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u8fde\u63a5\u4e91\u7aef\u7f51\u7edc\u5f02\u5e38\uff1a" + ex.getMessage()));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RETURN_CODE", "FAIL");
            map.put("RETURN_VALUE", "\u8bf7\u6c42\u4e91\u7aef\u7f51\u7edc\u5f02\u5e38");
            return map;
        }
        try {
            response = CloudDataProtocol.parse(gson, result, this.getCarparkSignKey(), this.getCarparkTransferCrypto(), null);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u65e0\u611f\u652f\u4ed8\u8bf7\u6c42\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e: " + result + ex.getMessage()));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RETURN_CODE", "FAIL");
            map.put("RETURN_VALUE", "\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e");
            return map;
        }
        Map resultMap = (Map)response.getData();
        String resultCode = (String)resultMap.get("responseCode");
        if ("0".equals(resultCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RETURN_CODE", "WAIT_PAY_RESULT");
            map.put("RETURN_VALUE", "\u6263\u8d39\u6210\u529f,\u7b49\u5f85\u652f\u4ed8\u7ed3\u679c");
            return map;
        }
        if (resultCode == null || resultCode.length() == 0) {
            resultCode = "ERROR";
        }
        if ((msg = (String)resultMap.get("responseMsg")) == null || msg.length() == 0) {
            msg = "\u652f\u4ed8\u5931\u8d25";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RETURN_CODE", resultCode);
        map.put("RETURN_VALUE", msg);
        return map;
    }

    @Override
    public KeyValueEntry<String, String> doQueryScanPaySate(Map<String, Object> paramMap) {
        String msg;
        CloudDataProtocol response;
        String result;
        String parkId;
        String queryDomain;
        String token = (String)paramMap.get("token");
        String orderNo = (String)paramMap.get("orderNo");
        if (token == null || token.length() == 0) {
            return new KeyValueEntry((Object)"FAIL", (Object)"\u7f3a\u5c11\u53c2\u6570token");
        }
        if (orderNo == null || orderNo.length() == 0) {
            return new KeyValueEntry((Object)"FAIL", (Object)"\u7f3a\u5c11\u53c2\u6570orderNo");
        }
        if (this.isConnected()) {
            queryDomain = this.getUploadDataDomain();
            if (queryDomain == null || queryDomain.length() == 0) {
                queryDomain = this.getObtainConnectDomain();
            }
        } else {
            queryDomain = this.getObtainConnectDomain();
        }
        if ((parkId = this.getCarparkConnId()) == null || parkId.length() == 0) {
            return new KeyValueEntry((Object)"FAIL", (Object)"\u4e91\u505c\u8f66\u573aid\u672a\u914d\u7f6e");
        }
        String signKey = this.getCarparkSignKey();
        if (signKey == null || signKey.length() == 0) {
            return new KeyValueEntry((Object)"FAIL", (Object)"\u4e91\u505c\u8f66\u573a\u79d8\u94a5\u672a\u914d\u7f6e");
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("orderNo", orderNo);
        Gson gson = GsonBuilder.create();
        CloudDataProtocol sendRequest = new CloudDataProtocol();
        sendRequest.setId(parkId);
        sendRequest.setCmd("queryScanPayState");
        sendRequest.setData(requestMap);
        sendRequest.setMsgId("quapcloud_" + ServiceUtil.getServiceContext().createLongSeq());
        sendRequest.setName(this.getCarparkConnName());
        sendRequest.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        String sendStr = sendRequest.toSendString(this.getCarparkSignKey(), this.cloudContext.getCloudConnTransferCrypto());
        HashMap<String, String> postMap = new HashMap<String, String>();
        postMap.put("t", token);
        postMap.put("p", sendStr);
        String url = "http://" + queryDomain + "/core/common/carpark/queryScanPayState.do";
        try {
            Proxy proxy = WanNetHostSelector.getWanProxyHost(queryDomain).getProxy();
            result = HttpUtil.doRequest((String)url, null, postMap, (int)6000, (int)8000, (Proxy)proxy);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u8fde\u63a5\u4e91\u7aef" + queryDomain + "\u7f51\u7edc\u5f02\u5e38\uff1a" + ex.getMessage()));
            String sv = this.getObtainConnectDomain();
            if (!queryDomain.equals(sv)) {
                url = "http://" + sv + "/core/common/carpark/queryScanPayState.do";
                try {
                    Proxy proxy = WanNetHostSelector.getWanProxyHost(sv).getProxy();
                    result = HttpUtil.doRequest((String)url, null, postMap, (int)6000, (int)8000, (Proxy)proxy);
                }
                catch (Exception ex1) {
                    ServiceLog.getLog().warn((Object)("\u8fde\u63a5\u4e91\u7aef" + sv + "\u7f51\u7edc\u5f02\u5e38\uff1a" + ex1.getMessage()));
                    return new KeyValueEntry((Object)"NEEDQUERY", (Object)"\u8bf7\u6c42\u4e91\u7aef\u7f51\u7edc\u5f02\u5e38");
                }
            }
            return new KeyValueEntry((Object)"NEEDQUERY", (Object)"\u8bf7\u6c42\u4e91\u7aef\u7f51\u7edc\u5f02\u5e38");
        }
        try {
            response = CloudDataProtocol.parse(gson, result, signKey, this.cloudContext.getCloudConnTransferCrypto(), null);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e: " + result + ex.getMessage()));
            return new KeyValueEntry((Object)"NEEDQUERY", (Object)"\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e");
        }
        Map resultMap = (Map)response.getData();
        String resultCode = (String)resultMap.get("responseCode");
        if ("0".equals(resultCode)) {
            String RETURN_CODE = (String)resultMap.get("RETURN_CODE");
            String RETURN_VALUE = (String)resultMap.get("RETURN_VALUE");
            if (RETURN_CODE == null || RETURN_CODE.length() == 0) {
                ServiceLog.getLog().warn((Object)("\u8b66\u544a\u67e5\u8be2\u4ed8\u6b3e\u7801\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u670d\u52a1\u5668\u8fd4\u56deresponseCode\u6210\u529f\uff0c\u4f46\u662f\u7f3a\u5c11RETURN_CODE\u6570\u636e\uff0c\u8bf7\u68c0\u67e5" + resultMap));
                return new KeyValueEntry((Object)"FAIL", (Object)"\u652f\u4ed8\u5931\u8d25");
            }
            if (RETURN_VALUE == null) {
                RETURN_VALUE = "";
            }
            if ("SUCCESS".equals(RETURN_CODE)) {
                this.handleScanPaySuccessMsg(RETURN_VALUE);
            }
            return new KeyValueEntry((Object)RETURN_CODE, (Object)RETURN_VALUE);
        }
        if (resultCode == null || resultCode.length() == 0) {
            resultCode = "ERROR";
        }
        if ((msg = (String)resultMap.get("responseMsg")) == null || msg.length() == 0) {
            msg = "\u652f\u4ed8\u5931\u8d25";
        }
        return new KeyValueEntry((Object)"FAIL", (Object)msg);
    }

    @Override
    public KeyValueEntry<String, String> doCancelScanPayOrder(Map<String, Object> paramMap) {
        String msg;
        CloudDataProtocol response;
        String result;
        String parkId;
        String queryDomain;
        String token = (String)paramMap.get("token");
        String orderNo = (String)paramMap.get("orderNo");
        if (token == null || token.length() == 0) {
            return new KeyValueEntry((Object)"FAIL", (Object)"\u7f3a\u5c11\u53c2\u6570token");
        }
        if (orderNo == null || orderNo.length() == 0) {
            return new KeyValueEntry((Object)"FAIL", (Object)"\u7f3a\u5c11\u53c2\u6570orderNo");
        }
        if (this.isConnected()) {
            queryDomain = this.getUploadDataDomain();
            if (queryDomain == null || queryDomain.length() == 0) {
                queryDomain = this.getObtainConnectDomain();
            }
        } else {
            queryDomain = this.getObtainConnectDomain();
        }
        if ((parkId = this.getCarparkConnId()) == null || parkId.length() == 0) {
            return new KeyValueEntry((Object)"FAIL", (Object)"\u4e91\u505c\u8f66\u573aid\u672a\u914d\u7f6e");
        }
        String signKey = this.getCarparkSignKey();
        if (signKey == null || signKey.length() == 0) {
            return new KeyValueEntry((Object)"FAIL", (Object)"\u4e91\u505c\u8f66\u573a\u79d8\u94a5\u672a\u914d\u7f6e");
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("orderNo", orderNo);
        Gson gson = GsonBuilder.create();
        CloudDataProtocol sendRequest = new CloudDataProtocol();
        sendRequest.setId(parkId);
        sendRequest.setCmd("cancelScanPay");
        sendRequest.setData(requestMap);
        sendRequest.setMsgId("canelpcloud_" + ServiceUtil.getServiceContext().createLongSeq());
        sendRequest.setName(this.getCarparkConnName());
        sendRequest.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        String sendStr = sendRequest.toSendString(signKey, this.cloudContext.getCloudConnTransferCrypto());
        HashMap<String, String> postMap = new HashMap<String, String>();
        postMap.put("t", token);
        postMap.put("p", sendStr);
        String url = "http://" + queryDomain + "/core/common/carpark/cancelScanPay.do";
        try {
            Proxy proxy = WanNetHostSelector.getWanProxyHost(queryDomain).getProxy();
            result = HttpUtil.doRequest((String)url, null, postMap, (int)6000, (int)8000, (Proxy)proxy);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u8fde\u63a5\u4e91\u7aef" + queryDomain + "\u7f51\u7edc\u5f02\u5e38\uff1a" + ex.getMessage()));
            String sv = this.getObtainConnectDomain();
            if (!queryDomain.equals(sv)) {
                url = "http://" + sv + "/core/common/carpark/cancelScanPay.do";
                try {
                    Proxy proxy = WanNetHostSelector.getWanProxyHost(sv).getProxy();
                    result = HttpUtil.doRequest((String)url, null, postMap, (int)6000, (int)8000, (Proxy)proxy);
                }
                catch (Exception ex1) {
                    ServiceLog.getLog().warn((Object)("\u8fde\u63a5\u4e91\u7aef" + sv + "\u7f51\u7edc\u5f02\u5e38\uff1a" + ex1.getMessage()));
                    return new KeyValueEntry((Object)"FAIL", (Object)"\u8bf7\u6c42\u4e91\u7aef\u7f51\u7edc\u5f02\u5e38");
                }
            }
            return new KeyValueEntry((Object)"FAIL", (Object)"\u8bf7\u6c42\u4e91\u7aef\u7f51\u7edc\u5f02\u5e38");
        }
        try {
            response = CloudDataProtocol.parse(gson, result, signKey, this.cloudContext.getCloudConnTransferCrypto(), null);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e: " + result + ex.getMessage()));
            return new KeyValueEntry((Object)"FAIL", (Object)"\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e");
        }
        Map resultMap = (Map)response.getData();
        String resultCode = (String)resultMap.get("responseCode");
        if ("0".equals(resultCode)) {
            String RETURN_CODE = (String)resultMap.get("RETURN_CODE");
            String RETURN_VALUE = (String)resultMap.get("RETURN_VALUE");
            if (RETURN_CODE == null || RETURN_CODE.length() == 0) {
                ServiceLog.getLog().warn((Object)("\u8b66\u544a\u53d6\u6d88\u4ed8\u6b3e\u7801\u652f\u4ed8\u8ba2\u5355\u64cd\u4f5c\u670d\u52a1\u5668\u8fd4\u56deresponseCode\u6210\u529f\uff0c\u4f46\u662f\u7f3a\u5c11RETURN_CODE\u6570\u636e\uff0c\u8bf7\u68c0\u67e5" + resultMap));
                return new KeyValueEntry((Object)"FAIL", (Object)"\u64cd\u4f5c\u5931\u8d25");
            }
            if (RETURN_VALUE == null) {
                RETURN_VALUE = "";
            }
            return new KeyValueEntry((Object)RETURN_CODE, (Object)RETURN_VALUE);
        }
        if (resultCode == null || resultCode.length() == 0) {
            resultCode = "ERROR";
        }
        if ((msg = (String)resultMap.get("responseMsg")) == null || msg.length() == 0) {
            msg = "\u64cd\u4f5c\u5931\u8d25";
        }
        return new KeyValueEntry((Object)"FAIL", (Object)msg);
    }
}

