/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.wovoe.carpark.KeyLockManager;
import com.wovoe.carpark.cloud.CloudDataProtocol;
import com.wovoe.carpark.cloud.CloudMessageHandler;
import com.wovoe.carpark.cloud.CloudMessageHandlerFactory;
import com.wovoe.carpark.cloud.CloudMessageHandlerRegister;
import com.wovoe.carpark.cloud.CloudReceiveClassManager;
import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.cloud.CloudServiceAction;
import com.wovoe.carpark.cloud.CloudServiceActionManager;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.JavaBeanUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.transfer.IOResponse;
import com.wovoe.framework.transfer.MessageResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultCloudMessageHandlerRegister
implements CloudMessageHandlerRegister,
CloudServiceAction {
    private ConcurrentHashMap<String, Map<String, Method>> remoteServiceMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, CloudMessageHandlerFactory> facotryMap = new ConcurrentHashMap();
    private final char DOT = (char)46;
    private CloudServiceActionManager serviceActionManager;
    private CloudReceiveClassManager receiveClassManager;
    private String responseSuffix;

    public DefaultCloudMessageHandlerRegister(CloudServiceActionManager serviceActionManager, CloudReceiveClassManager receiveClassManager, String responseSuffix) {
        this.serviceActionManager = serviceActionManager;
        this.receiveClassManager = receiveClassManager;
        this.responseSuffix = responseSuffix;
    }

    public CloudServiceActionManager getServiceActionManager() {
        return this.serviceActionManager;
    }

    public CloudReceiveClassManager getReceiveClassManager() {
        return this.receiveClassManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CloudDataProtocol request, IOResponse ioresponse) throws Exception {
        Object data;
        Object response;
        Class<?> returnClass;
        try {
            request.getContext().put("serviceRequest", request);
            String cmd = request.getCmd();
            int h = cmd.lastIndexOf(46);
            String serviceName = cmd.substring(0, h);
            String methodName = cmd.substring(h + 1);
            CloudMessageHandlerFactory factory = this.facotryMap.get(serviceName);
            if (factory == null) {
                LinkedHashMap<String, String> data2 = new LinkedHashMap<String, String>();
                data2.put("responseCode", "404");
                data2.put("responseMsg", "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u547d\u4ee4: " + cmd + ", \u6b64\u670d\u52a1\u4e0d\u6388\u652f\u6301\uff01");
                try {
                    ioresponse.doResponse(String.valueOf(request.getCmd()) + this.responseSuffix, data2);
                }
                catch (Throwable ex1) {
                    ServiceLog.getLog().warn((Object)"\u54cd\u5e94\u5931\u8d25", ex1);
                }
                return;
            }
            Object service = factory.getCloudMessageHandler(serviceName);
            if (service == null) {
                LinkedHashMap<String, String> data3 = new LinkedHashMap<String, String>();
                data3.put("responseCode", "404");
                data3.put("responseMsg", "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u547d\u4ee4: " + cmd + ", \u6b64\u670d\u52a1\u4e0d\u6388\u652f\u6301\uff01");
                try {
                    ioresponse.doResponse(String.valueOf(request.getCmd()) + this.responseSuffix, data3);
                }
                catch (Throwable ex1) {
                    ServiceLog.getLog().warn((Object)"\u54cd\u5e94\u5931\u8d25", ex1);
                }
                return;
            }
            Map<String, Method> methodMap = this.remoteServiceMap.get(serviceName);
            if (methodMap == null) {
                LinkedHashMap<String, String> data4 = new LinkedHashMap<String, String>();
                data4.put("responseCode", "404");
                data4.put("responseMsg", "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u547d\u4ee4: " + cmd + ", \u6b64\u670d\u52a1\u4e0d\u6388\u652f\u6301\uff01");
                try {
                    ioresponse.doResponse(String.valueOf(request.getCmd()) + this.responseSuffix, data4);
                }
                catch (Throwable ex1) {
                    ServiceLog.getLog().warn((Object)"\u54cd\u5e94\u5931\u8d25", ex1);
                }
                return;
            }
            Method method = methodMap.get(methodName);
            if (method == null) {
                LinkedHashMap<String, String> data5 = new LinkedHashMap<String, String>();
                data5.put("responseCode", "404");
                data5.put("responseMsg", "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u547d\u4ee4: " + cmd + ", \u6b64\u670d\u52a1\u4e0d\u6388\u652f\u6301\uff01");
                try {
                    ioresponse.doResponse(String.valueOf(request.getCmd()) + this.responseSuffix, data5);
                }
                catch (Throwable ex1) {
                    ServiceLog.getLog().warn((Object)"\u54cd\u5e94\u5931\u8d25", ex1);
                }
                return;
            }
            returnClass = method.getReturnType();
            KeyLockManager keyLockManager = ServiceUtil.getServiceContext().getKeyLockManager();
            StringBuilder keyBuf = new StringBuilder(128);
            keyBuf.append(this.getClass().getName()).append('_').append(request.getMsgId()).append('_').append(request.getCmd());
            String key = keyBuf.toString();
            Object lock = keyLockManager.getLock(key);
            try {
                Object object = lock;
                synchronized (object) {
                    response = method.invoke(service, request.getData(), request.getContext());
                }
            }
            finally {
                keyLockManager.releaseLock(lock);
            }
        }
        catch (Throwable ex) {
            InvocationTargetException e;
            ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            LinkedHashMap<String, String> data6 = new LinkedHashMap<String, String>();
            data6.put("responseCode", "500");
            String msg = ex instanceof InvocationTargetException ? ((e = (InvocationTargetException)ex).getTargetException() != null ? "\u670d\u52a1\u5668\u5185\u90e8\u5904\u7406\u9519\u8bef\uff01" + e.getTargetException().getMessage() : "\u670d\u52a1\u5668\u5185\u90e8\u5904\u7406\u9519\u8bef\uff01" + ex.getMessage()) : "\u670d\u52a1\u5668\u5185\u90e8\u5904\u7406\u9519\u8bef\uff01" + ex.getMessage();
            data6.put("responseMsg", msg);
            try {
                ioresponse.doResponse(String.valueOf(request.getCmd()) + this.responseSuffix, data6);
            }
            catch (Throwable ex1) {
                ServiceLog.getLog().warn((Object)"\u54cd\u5e94\u5931\u8d25", ex1);
            }
            return;
        }
        if (!Void.TYPE.equals(returnClass)) {
            if (response != null) {
                String responseCode;
                if (response instanceof Map) {
                    Map responseDataMap = (Map)response;
                    responseCode = (String)responseDataMap.get("responseCode");
                    if (responseCode == null || responseCode.length() == 0) {
                        responseDataMap.put("responseCode", "0");
                        responseDataMap.put("responseMsg", "SUCCESS");
                    }
                    data = responseDataMap;
                } else if (response instanceof Boolean) {
                    CloudResultResponse data1 = CloudResultResponse.createSuccessResponse();
                    if (!((Boolean)response).booleanValue()) {
                        data1.put("responseCode", "501");
                        data1.put("responseMsg", "\u64cd\u4f5c\u5931\u8d25");
                    }
                    data = data1;
                } else if (response instanceof OperationFuture) {
                    data = response;
                } else if (response instanceof MessageResult) {
                    MessageResult r = (MessageResult)response;
                    if (r.getResponseCode() == null || r.getResponseCode().length() == 0) {
                        r.setResponseCode("0");
                        r.setResponseMsg("SUCCESS");
                    }
                    data = r;
                } else {
                    JavaBeanMap map = new JavaBeanMap(response);
                    responseCode = (String)map.get((Object)"responseCode");
                    if (responseCode == null || responseCode.length() == 0) {
                        map.put("responseCode", (Object)"0");
                        map.put("responseMsg", (Object)"SUCCESS");
                    }
                    data = response;
                }
            } else {
                LinkedHashMap<String, String> data1 = new LinkedHashMap<String, String>();
                data1.put("responseCode", "502");
                data1.put("responseMsg", "\u64cd\u4f5c\u5931\u8d25");
                data = data1;
            }
        } else {
            data = CloudResultResponse.createSuccessResponse();
        }
        try {
            ioresponse.doResponse(String.valueOf(request.getCmd()) + this.responseSuffix, data);
        }
        catch (Throwable ex1) {
            ServiceLog.getLog().warn((Object)"\u54cd\u5e94\u5931\u8d25", ex1);
        }
    }

    @Override
    public void registMessageHandler(Class<? extends CloudMessageHandler> romteServiceCl, String serviceName, CloudMessageHandlerFactory factory) {
        Method[] ms;
        if (!romteServiceCl.isInterface()) {
            throw new RuntimeException(romteServiceCl + " is not a interface!");
        }
        this.facotryMap.put(serviceName, factory);
        Method[] methodArray = ms = romteServiceCl.getMethods();
        int n = ms.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Class<?>[] cls = m.getParameterTypes();
            if (cls != null && cls.length == 2 && Map.class.equals(cls[1])) {
                Map map;
                boolean canLoad;
                Class<?> returnCl = m.getReturnType();
                boolean bl = canLoad = Void.TYPE.equals(returnCl) || Boolean.class.equals(returnCl) || Boolean.TYPE.equals(returnCl) || Map.class.isAssignableFrom(returnCl) || MessageResult.class.isAssignableFrom(returnCl) || OperationFuture.class.isAssignableFrom(returnCl);
                if (!canLoad && (map = JavaBeanUtil.getGetSetMethods(returnCl)).get("responseCode") != null && map.get("responseMsg") != null) {
                    canLoad = true;
                }
                if (canLoad) {
                    ConcurrentHashMap<String, Method> methodMap = this.remoteServiceMap.get(serviceName);
                    if (methodMap == null) {
                        ConcurrentHashMap<String, Method> newmehtodMap = new ConcurrentHashMap<String, Method>();
                        ConcurrentHashMap<String, Method> oldmehtodMap = this.remoteServiceMap.putIfAbsent(serviceName, newmehtodMap);
                        methodMap = oldmehtodMap != null ? oldmehtodMap : newmehtodMap;
                    }
                    String methodName = m.getName();
                    methodMap.put(methodName, m);
                    String cmd = String.valueOf(serviceName) + "." + methodName;
                    if (!Map.class.equals(cls[0])) {
                        this.receiveClassManager.addDataClass(cmd, cls[0]);
                    }
                    this.serviceActionManager.addAction(cmd, this);
                }
            }
            ++n2;
        }
    }
}

