/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class OssTool {
    public static void put(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, String key, byte[] data) throws Exception {
        HashMap<String, byte[]> dataMap = new HashMap<String, byte[]>();
        dataMap.put(key, data);
        OssTool.putAll(endpoint, accessKeyId, accessKeySecret, bucketName, dataMap);
    }

    public static void putAll(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, Map<String, byte[]> dataMap) throws Exception {
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            for (Map.Entry<String, byte[]> entry : dataMap.entrySet()) {
                ossClient.putObject(bucketName, entry.getKey(), (InputStream)new ByteArrayInputStream(entry.getValue()));
            }
        }
        finally {
            ossClient.shutdown();
        }
    }

    public static boolean isExist(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, String key) throws Exception {
        LinkedList<String> keys = new LinkedList<String>();
        keys.add(key);
        Map<String, Boolean> dataMap = OssTool.isExist(endpoint, accessKeyId, accessKeySecret, bucketName, keys);
        return dataMap.get(key);
    }

    public static Map<String, Boolean> isExist(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, Collection<String> keys) throws Exception {
        LinkedHashMap<String, Boolean> dataMap = new LinkedHashMap<String, Boolean>();
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            for (String key : keys) {
                if (ossClient.doesObjectExist(bucketName, key)) {
                    dataMap.put(key, Boolean.TRUE);
                    continue;
                }
                dataMap.put(key, Boolean.FALSE);
            }
        }
        finally {
            ossClient.shutdown();
        }
        return dataMap;
    }

    public static byte[] get(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, String key) throws Exception {
        LinkedList<String> keys = new LinkedList<String>();
        keys.add(key);
        Map<String, byte[]> dataMap = OssTool.getAll(endpoint, accessKeyId, accessKeySecret, bucketName, keys);
        return dataMap.get(key);
    }

    public static Map<String, byte[]> getAll(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, Collection<String> keys) throws Exception {
        LinkedHashMap<String, byte[]> dataMap = new LinkedHashMap<String, byte[]>();
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            for (String key : keys) {
                if (ossClient.doesObjectExist(bucketName, key)) {
                    OSSObject ossObject = ossClient.getObject(bucketName, key);
                    out.reset();
                    try (InputStream in = ossObject.getObjectContent();){
                        int b;
                        while ((b = in.read()) != -1) {
                            out.write(b);
                        }
                    }
                    dataMap.put(key, out.toByteArray());
                    continue;
                }
                dataMap.put(key, null);
            }
            out.close();
        }
        finally {
            ossClient.shutdown();
        }
        return dataMap;
    }

    public static void delete(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, String key) throws Exception {
        LinkedList<String> keys = new LinkedList<String>();
        keys.add(key);
        OssTool.deleteAll(endpoint, accessKeyId, accessKeySecret, bucketName, keys);
    }

    public static void deleteAll(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, Collection<String> keys) throws Exception {
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            for (String key : keys) {
                if (!ossClient.doesObjectExist(bucketName, key)) continue;
                ossClient.deleteObject(bucketName, key);
            }
        }
        finally {
            ossClient.shutdown();
        }
    }
}

