/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.wovoe.carpark.CarparkPassRecordListener;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.DispatchDataTaskUtil;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkSenselessPay;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.senseless.pay.CcbSenselessPayer;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.ibatis.session.SqlSession;

public class SenselessPayJob
extends JobTask
implements CarparkPassRecordListener {
    private ConcurrentLinkedDeque<ContractTask> constactDeque = new ConcurrentLinkedDeque();
    private ConcurrentHashMap<String, ContractTask> constactMap = new ConcurrentHashMap();

    private boolean isSenselessQueryConstactOk() {
        String v;
        if (!ServiceUtil.getServiceContext().isSupportSenselessPay()) {
            return false;
        }
        Map<String, String> ccbConfig = ServiceUtil.getServiceContext().getSenselessConfig(9);
        if (ccbConfig == null) {
            ccbConfig = ServiceUtil.getServiceContext().getSenselessConfig(1);
        }
        return ccbConfig != null && !ccbConfig.isEmpty() && ((v = ccbConfig.get("WL_SCA")) == null || !Constants.YES_STR.equals(v)) && (v = ccbConfig.get("WL_CCA")) != null && Constants.YES_STR.equals(v);
    }

    @Override
    public void onAdd(CarparkPassRecord passRecord, SqlSession session, boolean remotePass) {
        try {
            if (passRecord.getArea_level() == null) {
                return;
            }
            if (passRecord.getArea_level() != 1) {
                return;
            }
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            if (passRecord.getExit_time() != null) {
                if (passRecord.getExit_plate() != null && (passRecord.getExit_plate().length() == 7 || passRecord.getExit_plate().length() == 8)) {
                    commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkSenselessPay.class)).addEQ("plate_number", (Object)passRecord.getExit_plate()).addLTE("enter_time", (Object)passRecord.getExit_time()));
                    ContractTask contractTask = this.constactMap.get(passRecord.getExit_plate());
                    if (contractTask != null && contractTask.enterTime.before(passRecord.getExit_time())) {
                        contractTask.cancel = true;
                        contractTask = this.constactMap.remove(passRecord.getExit_plate());
                        if (contractTask != null) {
                            this.constactDeque.remove(contractTask);
                        }
                    }
                }
            } else {
                if (passRecord.getEnter_time() == null) {
                    return;
                }
                if (passRecord.getEnter_plate() != null && (passRecord.getEnter_plate().length() == 7 || passRecord.getEnter_plate().length() == 8)) {
                    commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkSenselessPay.class)).addEQ("plate_number", (Object)passRecord.getEnter_plate()).addLT("enter_time", (Object)passRecord.getEnter_time()));
                    this.addQueryContractIfNeed(passRecord.getEnter_plate(), passRecord.getEnter_time(), true, true);
                }
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void addQueryContractIfNeed(String plate, Date enterTime, boolean first, boolean tryRun) {
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig() == null || plate == null || enterTime == null) {
            return;
        }
        if (plate.length() != 7 && plate.length() != 8) {
            return;
        }
        int configType = ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use();
        if (configType == 2 || configType == 3) {
            int zmx;
            ContractTask t = this.constactMap.get(plate);
            if (t != null) {
                if (t.enterTime.before(enterTime)) {
                    t.cancel = true;
                    t = this.constactMap.remove(plate);
                    if (t != null) {
                        this.constactDeque.remove(t);
                    }
                } else {
                    return;
                }
            }
            if ((zmx = this.constactMap.size() - 2000) > 0) {
                ContractTask tas;
                while ((tas = this.constactDeque.pollLast()) != null) {
                    tas.cancel = true;
                    this.constactMap.remove(tas.plate);
                    if (--zmx <= 0) break;
                }
            }
            ContractTask task = new ContractTask(plate, enterTime, first);
            this.constactMap.put(plate, task);
            if (first) {
                this.constactDeque.addFirst(task);
            } else {
                this.constactDeque.addLast(task);
            }
            if (tryRun) {
                this.run();
            }
        }
    }

    protected void doRun() throws Exception {
        ContractTask task;
        int configType = ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use();
        boolean isServer = configType == 2 || configType == 3;
        block6: while ((task = this.constactDeque.pollFirst()) != null) {
            try {
                if (!isServer || !task.runTask()) continue;
                int i = 0;
                while (i < 4) {
                    try {
                        Thread.sleep(2000L);
                        ContractTask a = this.constactDeque.peekFirst();
                        if (a == null ? task.newPass : a.newPass) {
                            continue block6;
                        }
                    }
                    catch (InterruptedException ex) {
                        this.constactMap.remove(task.plate);
                        return;
                    }
                    ++i;
                }
            }
            finally {
                this.constactMap.remove(task.plate);
            }
        }
        if (isServer && this.isSenselessQueryConstactOk()) {
            String temPassportNo = null;
            Map<String, CarparkPassportType> tmap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            if (tmap != null && !tmap.isEmpty()) {
                for (CarparkPassportType t : tmap.values()) {
                    if (t.getPassport_type_number() != 0 || t.getPass_type() != 0) continue;
                    temPassportNo = t.getPassport_type_no();
                }
            }
            if (temPassportNo != null) {
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                Calendar cl = Calendar.getInstance();
                cl.set(14, 0);
                Date now = cl.getTime();
                cl.add(6, -2);
                Date minDate = cl.getTime();
                SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
                sp.setQueryFields(new String[]{"enter_plate", "enter_time"});
                sp.addGTE("enter_time", (Object)minDate);
                sp.addLTE("enter_time", (Object)now);
                sp.addEQ("area_level", (Object)1);
                sp.addEQ("passport_type_no", (Object)temPassportNo);
                sp.addNotEQ("enter_plate", null);
                sp.setOrder_by("enter_time DESC");
                int fetchSize = 500;
                Pagination p = new Pagination();
                p.setNeedQueryCount(false);
                p.setGotoPage(1);
                p.setPageSize(fetchSize);
                p.setRecordsCount((long)fetchSize);
                List plist = commonDaoService.selectList(sp, p);
                if (plist != null && !plist.isEmpty()) {
                    for (Map vmap : plist) {
                        Date enterTime;
                        String enter_plate = (String)vmap.get("enter_plate");
                        if (enter_plate == null || enter_plate.length() != 7 && enter_plate.length() != 8 || (enterTime = (Date)vmap.get("enter_time")) == null) continue;
                        this.addQueryContractIfNeed(enter_plate, enterTime, false, false);
                    }
                }
            }
        }
    }

    private static class ContractTask {
        private String plate;
        private Date enterTime;
        private boolean cancel;
        private boolean newPass;
        private boolean exeQuery;

        public ContractTask(String plate, Date enterTime, boolean newPass) {
            this.plate = plate;
            this.enterTime = enterTime;
            this.newPass = newPass;
            this.exeQuery = false;
        }

        public boolean runTask() {
            if (ServiceUtil.getServiceContext().getCloudContext() == null) {
                return false;
            }
            if (!ServiceUtil.getServiceContext().isSupportSenselessPay()) {
                return false;
            }
            if (this.cancel) {
                return false;
            }
            Map<String, String> ccbConfig = ServiceUtil.getServiceContext().getSenselessConfig(9);
            if (ccbConfig == null || ccbConfig.isEmpty()) {
                ccbConfig = ServiceUtil.getServiceContext().getSenselessConfig(1);
            }
            if (ccbConfig != null && !ccbConfig.isEmpty()) {
                this.doCcbQuery(ccbConfig);
            }
            return this.exeQuery;
        }

        private void handleContract(int contract_type) {
            String tableName;
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            long count = commonDaoService.selectCount(new SearchParam(tableName = commonDaoService.getTableName(CarparkSenselessPay.class)).addEQ("plate_number", (Object)this.plate).addEQ("contract_type", (Object)contract_type).addEQ("enter_time", (Object)this.enterTime));
            if (count == 0L) {
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                long payId = appService.createLocalRecordSeq("ck_carpark_senseless_pay_seq");
                CarparkSenselessPay pay = new CarparkSenselessPay();
                pay.setId(payId);
                pay.setPlate_number(this.plate);
                pay.setContract_type(contract_type);
                pay.setEnter_time(this.enterTime);
                pay.setCredit_support(0);
                pay.setCreated_time(ServiceUtil.getNow());
                pay.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                pay.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                List<CarparkDispatchTask> dispatchTaskList = DispatchDataTaskUtil.createDispatchRecordByIdTaskList(tableName, pay.getId().toString(), "ALL_HOSTS");
                try (SqlSession sqlsession = commonDaoService.openSqlSession();){
                    try {
                        commonDaoService.insert(sqlsession, (Object)pay, tableName);
                        if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                            for (CarparkDispatchTask t : dispatchTaskList) {
                                commonDaoService.insert(sqlsession, (Object)t);
                            }
                        }
                        sqlsession.commit();
                    }
                    catch (Throwable ex) {
                        sqlsession.rollback();
                        throw ex;
                    }
                }
                if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                    appService.asynTryRunDispatchTask(dispatchTaskList);
                }
            }
        }

        private void doCcbQuery(Map<String, String> ccbConfig) {
            if (this.cancel) {
                return;
            }
            try {
                KeyValueEntry<String, Object> centry = CcbSenselessPayer.queryContract(this.plate, ccbConfig);
                if (!"SUCCESS".equals(centry.getKey())) {
                    if ("REQUEST_ERROR".equals(centry.getKey()) || "RESPONSE_ERROR".equals(centry.getKey())) {
                        this.exeQuery = true;
                    }
                    return;
                }
                this.exeQuery = true;
                Map responseMap = (Map)centry.getValue();
                boolean isContract = false;
                if (responseMap.get("AUTHSTATUS") != null && responseMap.get("AUTHNO") != null) {
                    if (!this.plate.equals(responseMap.get("AUTHNO").toString())) {
                        ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5efa\u884c\u65e0\u611f\u652f\u4ed8\u67e5\u8be2\u8f66\u724c\u662f\u5426\u7b7e\u7ea6\u5f02\u5e38! \u8fd4\u56de\u8f66\u724c\u4e0d\u4e00\u81f4,\u671f\u5f85\u8f66\u724c: " + this.plate + ", \u8fd4\u56de\u6570\u636e: " + responseMap));
                        return;
                    }
                } else {
                    ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5efa\u884c\u65e0\u611f\u652f\u4ed8\u67e5\u8be2\u8f66\u724c\u662f\u5426\u7b7e\u7ea6\u5f02\u5e38! \u7f3a\u5c11\u6570\u636e\u5c5e\u6027,\u8fd4\u56de\u6570\u636e: " + responseMap));
                    return;
                }
                isContract = "1".equals(responseMap.get("AUTHSTATUS").toString());
                if (isContract) {
                    this.handleContract(9);
                }
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)("\u6267\u884c\u5efa\u884c\u65e0\u611f\u652f\u4ed8\u67e5\u8be2\u662f\u5426\u7b7e\u7ea6\u5f02\u5e38! " + ex.getMessage()));
            }
        }
    }
}

