/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud;

import com.wovoe.carpark.WanNetHostSelector;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import java.net.Proxy;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@WebSocket(maxTextMessageSize=0x100000)
public class WebsocketCloudTest {
    private volatile boolean connceted = false;
    private CountDownLatch countLatch = new CountDownLatch(1);
    private Session session;

    public static boolean testCanUseWebsockt(String domain, String name, WebSocketClient client, boolean secureConnect) {
        try {
            Proxy proxy;
            boolean direct = true;
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig() != null && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1 && (proxy = WanNetHostSelector.getWanProxyHost(domain).getProxy()).type() != Proxy.Type.DIRECT) {
                direct = false;
            }
            if (direct) {
                String testPath = String.valueOf(secureConnect ? "wss" : "ws") + "://" + domain + "/core/webclient/websocket/transferconn/" + name + "?connParam=testConn";
                ServiceLog.getLog().info((Object)("\u6b63\u5728\u6d4b\u8bd5websocket\u662f\u5426\u53ef\u7528: " + testPath));
                WebsocketCloudTest test = new WebsocketCloudTest();
                test.doConnect(testPath, client);
                try {
                    test.countLatch.await(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                test.close();
                boolean connected = test.connceted;
                if (!connected) {
                    ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u4f7f\u7528" + (secureConnect ? "wss" : "ws") + "\u8fde\u63a5\u4e91\u7aef\uff01"));
                } else {
                    ServiceLog.getLog().info((Object)("\u53ef\u4ee5\u4f7f\u7528 " + (secureConnect ? "wss" : "ws") + "\u8fde\u63a5\u4e91\u7aef\uff01"));
                }
                return connected;
            }
            return false;
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u5f53\u524d\u4e3b\u673a\u65e0\u6cd5\u4f7f\u7528" + (secureConnect ? "wss" : "ws") + "\u8fde\u63a5\u5e73\u53f0"));
            return false;
        }
    }

    private WebsocketCloudTest() {
    }

    private void doConnect(String uri, WebSocketClient client) {
        try {
            URI connUri = new URI(uri);
            Future f = client.connect((Object)this, connUri);
            this.session = (Session)f.get(8L, TimeUnit.SECONDS);
            if (this.session == null) {
                this.countLatch.countDown();
            }
        }
        catch (Throwable ex) {
            this.countLatch.countDown();
        }
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        if ("SUCCESS".equals(msg)) {
            this.connceted = true;
            this.countLatch.countDown();
        }
    }

    private void close() {
        try {
            Session session1 = this.session;
            if (session1 != null) {
                session1.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

