/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.client;

import com.wovoe.carpark.AuthInfo;
import com.wovoe.carpark.WanNetHostSelector;
import com.wovoe.carpark.cloud.CloudCometConnection;
import com.wovoe.carpark.cloud.CloudContext;
import com.wovoe.carpark.cloud.CloudDataConnection;
import com.wovoe.carpark.cloud.CloudDataProtocol;
import com.wovoe.carpark.cloud.CloudDataResponseCallback;
import com.wovoe.carpark.cloud.CloudWebsocketConnection;
import com.wovoe.carpark.cloud.DefaultCarparkCloudConnection;
import com.wovoe.carpark.cloud.client.CarparkHostHeartBeat;
import com.wovoe.carpark.cloud.client.OtherHostSateManager;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.AlwaysOpenAction;
import com.wovoe.carpark.equipment.driver.IceCameraTcpAction;
import com.wovoe.carpark.equipment.driver.ZSCameraAction;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.HostEquipmentSate;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.HardWareInfo;
import com.wovoe.framework.HardWareUtils;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.transfer.TransferCrypto;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Proxy;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class CarparkHostCloudConnection
extends DefaultCarparkCloudConnection {
    static final String CARPARKHOST_CONN_NAME = "caraprkhost";
    private String carparkToken;

    public CarparkHostCloudConnection(CloudContext cloudContext) {
        super(cloudContext);
    }

    @Override
    protected boolean checkIsValidRun() {
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config == null) {
            return false;
        }
        CarparkHost localhost = ServiceUtil.getServiceContext().getLocalHost();
        if (localhost == null) {
            return false;
        }
        return ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_type() == 1 && ServiceUtil.getServiceContext().getCarparkLocalConfig().getNet_mode() == 2 && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1;
    }

    @Override
    public String getName() {
        return CARPARKHOST_CONN_NAME;
    }

    @Override
    public String getId() {
        Carpark carpark = ServiceUtil.getServiceContext().getCarpark();
        if (carpark == null) {
            return null;
        }
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config == null) {
            return null;
        }
        return config.getCloud_host_id();
    }

    public static String getSignKey(CarparkLocalConfig config) {
        if (config == null) {
            return null;
        }
        String signKey = config.getCloud_carpark_sign_key();
        if (signKey == null || signKey.length() == 0) {
            return signKey;
        }
        if (signKey.length() != 32) {
            try {
                Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                signKey = CryptoUtil.decrypt((String)signKey, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
                config.setCloud_carpark_sign_key(signKey);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u8f66\u573a\u4e91api\u79d8\u94a5\u914d\u7f6e\u9519\u8bef\uff01");
                return null;
            }
        }
        return signKey;
    }

    @Override
    public String getSignKey() {
        return CarparkHostCloudConnection.getSignKey(ServiceUtil.getServiceContext().getCarparkLocalConfig());
    }

    @Override
    protected String obtianConnectHost() {
        try {
            String cn = this.getName();
            String cd = this.getId();
            String vc = RandomStringGenerator.getDefaultInstance().getNewString(16);
            TransferCrypto crypto = this.cloudContext.getCloudConnTransferCrypto();
            String vb = crypto.encrypt(String.valueOf(cn) + "," + cd + "," + vc);
            String host = this.getObtainConnectDomain();
            String url = "http://" + host + "/core/common/gateway/webclient/conn/obtainConnectAddress.do";
            LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
            paramMap.put("cn", cn);
            paramMap.put("cd", cd);
            paramMap.put("vc", vc);
            paramMap.put("vb", vb);
            Proxy proxy = WanNetHostSelector.getWanProxyHost(host).getProxy();
            String result = HttpUtil.doRequest((String)url, null, paramMap, (int)6000, (int)6000, (Proxy)proxy);
            String vx = crypto.decrypt(result);
            String sx = "connectHost=";
            if (vx.startsWith(sx)) {
                return vx.substring(sx.length()).trim();
            }
            return null;
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u83b7\u53d6\u8fde\u63a5\u5730\u5740! " + ex.getMessage()));
            return null;
        }
    }

    @Override
    protected boolean canHttpConnectCloud(String host, boolean secureConnect) {
        try {
            String url = String.valueOf(secureConnect ? "https://" : "http://") + host + "/core/webclient/comet/transferconn?name=" + this.getName() + "&connParam=testConn";
            Proxy proxy = WanNetHostSelector.getWanProxyHost(host).getProxy();
            String result = HttpUtil.doRequest((String)url, null, null, (int)6000, (int)6000, (Proxy)proxy);
            return "SUCCESS".equals(result);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public String getConnetParm() {
        try {
            AuthInfo authInfo = ServiceUtil.getServiceContext().getAuthInfo();
            HardWareInfo hardWarInfo = HardWareUtils.getHardWareInfo();
            LinkedHashMap<String, String> hostInfoMap = new LinkedHashMap<String, String>();
            hostInfoMap.put("motherboardSn", hardWarInfo.getMotherboardSn() == null ? "" : hardWarInfo.getMotherboardSn());
            hostInfoMap.put("hardDiskSn", hardWarInfo.getHardDiskSn() == null ? "" : hardWarInfo.getHardDiskSn());
            hostInfoMap.put("mac", hardWarInfo.getMac() == null ? "" : hardWarInfo.getMac());
            hostInfoMap.put("cpuSn", hardWarInfo.getCpuSn() == null ? "" : hardWarInfo.getCpuSn());
            hostInfoMap.put("osName", System.getProperty("os.name"));
            LinkedHashMap<String, Object> requestMap = new LinkedHashMap<String, Object>();
            requestMap.put("sn", authInfo.isOfficial() ? authInfo.getSn() : "trial");
            requestMap.put("hostNo", ServiceUtil.getServiceContext().getLocalHost().getHost_no());
            requestMap.put("authMode", String.valueOf(authInfo.getAuthMode()));
            requestMap.put("hostInfo", hostInfoMap);
            requestMap.put("ver", ServiceUtil.getServiceContext().getVersion());
            requestMap.put("localIps", this.getLocalEthIpV4Value());
            requestMap.put("eqStates", this.getEqStateMapString());
            CloudDataProtocol p1 = new CloudDataProtocol();
            p1.setId(this.getId());
            p1.setName(this.getName());
            p1.setCmd("connect");
            p1.setMsgId("connect-" + ServiceUtil.getServiceContext().createLongSeq());
            p1.setData(requestMap);
            p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
            return p1.toSendString(this.getSignKey(), this.cloudContext.getCloudConnTransferCrypto());
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
            return "";
        }
    }

    @Override
    protected boolean handleConnectMap(Map<?, ?> connectMap) {
        this.carparkToken = (String)connectMap.get("carparkToken");
        this.setHostServerOnline();
        return true;
    }

    @Override
    protected void sendHeartBeat(final CloudDataConnection conn) {
        if (conn == null || !conn.isConnected()) {
            return;
        }
        HashMap<String, String> seqNosMap = new HashMap<String, String>();
        HashSet<String> alwaysOpenList = new HashSet<String>();
        Map<String, String> cEqsMap = this.getEqStateMap(seqNosMap, alwaysOpenList);
        CarparkHostHeartBeat d = new CarparkHostHeartBeat();
        d.setVer(ServiceUtil.getServiceContext().getVersion());
        if (cEqsMap != null && !cEqsMap.isEmpty()) {
            d.setCeqs(cEqsMap);
        }
        if (seqNosMap != null && !seqNosMap.isEmpty()) {
            d.setSerials(seqNosMap);
        }
        if (alwaysOpenList != null && !alwaysOpenList.isEmpty()) {
            d.setOpenL(new ArrayList<String>(alwaysOpenList));
        }
        if (ServiceUtil.getServiceContext().getHttpServiceServer() != null) {
            d.setHttpPort(String.valueOf(ServiceUtil.getServiceContext().getHttpServiceServer().getPort()));
        }
        d.setcMills(System.currentTimeMillis());
        d.setEqLocalIps(this.getLocalEthIpV4Value());
        CloudDataProtocol p1 = new CloudDataProtocol();
        p1.setId(this.getId());
        p1.setName(this.getName());
        p1.setCmd("carparkHostRemoteService.heartBeat");
        p1.setMsgId("heartbeat-" + ServiceUtil.getServiceContext().createLongSeq());
        p1.setData(d);
        p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        try {
            conn.send(p1, new CloudDataResponseCallback(){

                @Override
                public void onException(Throwable ex) {
                    ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5fc3\u8df3\u5f02\u5e38: " + ex.getMessage()));
                }

                @Override
                public void onWaitTimeout() {
                    ServiceLog.getLog().warn((Object)"\u53d1\u9001\u5fc3\u8df3\u54cd\u5e94\u8d85\u65f6: ");
                }

                @Override
                public void onResponse(CloudDataProtocol response) throws Exception {
                    block25: {
                        if (response.getData() == null) {
                            ServiceLog.getLog().warn((Object)"\u5fc3\u8df3\u54cd\u5e94\u9519\u8bef\u7f3a\u5c11\u6570\u636e\uff01");
                        } else {
                            long now;
                            Map dataMap = (Map)response.getData();
                            String responseCode = (String)dataMap.get("responseCode");
                            if (responseCode == null || responseCode.length() == 0) {
                                ServiceLog.getLog().warn((Object)"\u53d1\u9001\u5fc3\u8df3\u54cd\u5e94\u9519\u8bef \u7f3a\u5c11\u54cd\u5e94\u7801");
                                return;
                            }
                            if (!"0".equals(responseCode)) {
                                if ("501".equals(responseCode) && dataMap.get("needReconnect") != null) {
                                    ServiceLog.getLog().info((Object)"\u670d\u52a1\u5668\u901a\u77e5\u9700\u8981\u91cd\u65b0\u8fde\u63a5\uff0c\u8fd9\u5c06\u91cd\u65b0\u8fdb\u884c\u8fde\u63a5...");
                                    conn.destroy();
                                    return;
                                }
                                ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5fc3\u8df3\u54cd\u5e94\u9519\u8bef\uff01\u9519\u8bef\uff1a" + responseCode + ", " + dataMap.get("responseMsg")));
                                return;
                            }
                            long serverSystemMills = Long.parseLong(dataMap.get("serverSystemMills").toString());
                            CarparkHostCloudConnection.this.uploadDataDomains = (String)dataMap.get("uploadDataDomains");
                            CarparkHostCloudConnection.this.uploadPicDomains = (String)dataMap.get("uploadPicDomains");
                            if (!conn.isDestroy()) {
                                if (conn instanceof CloudCometConnection) {
                                    ((CloudCometConnection)conn).updateActiveState();
                                } else if (conn instanceof CloudWebsocketConnection) {
                                    ((CloudWebsocketConnection)conn).updateActiveState();
                                }
                            }
                            if (Math.abs((now = System.currentTimeMillis()) - serverSystemMills) > 10000L) {
                                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                ServiceLog.getLog().warn((Object)("\u53d1\u73b0\u4e91\u670d\u52a1\u5668\u65f6\u95f4\uff1a" + df.format(new Date(serverSystemMills)) + ",\u4e0e\u5f53\u524d\u8f66\u573a\u670d\u52a1\u5668\u7cfb\u7edf\u65f6\u95f4\uff1a" + df.format(new Date(now)) + "\u5b58\u5728\u8bef\u5dee\uff0c\u8fd9\u5c06\u540c\u6b65\u670d\u52a1\u5668\u65f6\u95f4"));
                                ServiceUtil.setSystemTime(new Date(serverSystemMills));
                            }
                            CarparkHostCloudConnection.this.setHostServerOnline();
                            try {
                                Object otherConnectedHosts = dataMap.get("otherConnectedHosts");
                                if (otherConnectedHosts == null) break block25;
                                List list = (List)otherConnectedHosts;
                                for (Object o : list) {
                                    OtherHostSateManager otherHostSateManager;
                                    Map statesMap;
                                    CarparkHost otherHost;
                                    String localHostNo;
                                    Map rMap = (Map)o;
                                    String ver = (String)rMap.get("ver");
                                    String hostNo = (String)rMap.get("hostNo");
                                    String localIps = (String)rMap.get("localIps");
                                    String eqSates = (String)rMap.get("eqSates");
                                    if (hostNo == null || hostNo.length() == 0 || ServiceUtil.getServiceContext().getDBConfigCache() == null || (localHostNo = ServiceUtil.getServiceContext().getLocalHostNo()) == null || localHostNo.length() == 0 || localHostNo.equals(hostNo) || (otherHost = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(hostNo)) == null) continue;
                                    HashMap<String, Set<InetAddress>> localIpv4Map = new HashMap<String, Set<InetAddress>>();
                                    if (localIps != null && !localIps.isEmpty()) {
                                        String[] vs;
                                        String[] stringArray = vs = localIps.split(";");
                                        int n = vs.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String a = stringArray[n2];
                                            int x = a.indexOf(58);
                                            if (x != -1) {
                                                String[] ips;
                                                String eth = a.substring(0, x).trim();
                                                String[] stringArray2 = ips = a.substring(x + 1).split(",");
                                                int n3 = ips.length;
                                                int n4 = 0;
                                                while (n4 < n3) {
                                                    String ip = stringArray2[n4];
                                                    if ((ip = ip.trim()).length() != 0) {
                                                        try {
                                                            InetAddress address = InetAddress.getByName(ip);
                                                            if (!address.isLoopbackAddress() && address instanceof Inet4Address) {
                                                                HashSet<InetAddress> set = (HashSet<InetAddress>)localIpv4Map.get(eth);
                                                                if (set == null) {
                                                                    set = new HashSet<InetAddress>();
                                                                    localIpv4Map.put(eth, set);
                                                                }
                                                                set.add(address);
                                                            }
                                                        }
                                                        catch (Exception exception) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    ++n4;
                                                }
                                            }
                                            ++n2;
                                        }
                                    }
                                    HashMap<String, String> cloudConnectedEqSatesMap = new HashMap<String, String>();
                                    if (eqSates != null && eqSates.length() > 0 && (statesMap = (Map)GsonBuilder.create().fromJson(eqSates, HashMap.class)) != null && !statesMap.isEmpty()) {
                                        for (Map.Entry en : statesMap.entrySet()) {
                                            if (en.getKey() == null || en.getValue() == null) continue;
                                            String eqNo = en.getKey().toString();
                                            String eqSt = en.getValue().toString();
                                            String v = "2".equals(eqSt) ? EquipmentState.BARRIER_RAISED_IN_PLACE.name() : ("3".equals(eqSt) ? EquipmentState.BARRIER_DROPPED_IN_PLACE.name() : EquipmentState.CONNECTED.name());
                                            cloudConnectedEqSatesMap.put(eqNo, v);
                                        }
                                    }
                                    if ((otherHostSateManager = ServiceUtil.getServiceContext().getOtherHostSateManager()) != null) {
                                        otherHostSateManager.updateCloudInfo(hostNo, ver, cloudConnectedEqSatesMap, localIpv4Map);
                                    }
                                    HostEquipmentSate hostState = new HostEquipmentSate();
                                    hostState.setExistUpgradeFile(0);
                                    hostState.setVersion(ver);
                                    hostState.setHostNo(hostNo);
                                    hostState.setProxyChNos(null);
                                    hostState.setEqSates(cloudConnectedEqSatesMap);
                                    ServiceUtil.getServiceContext().getHostEquipmentSateManager().setHostOnline(hostState);
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().info((Object)("\u5904\u7406 otherConnectedHosts \u7ed3\u679c\u5f02\u5e38\uff01" + ex.getMessage()));
                            }
                        }
                    }
                }
            }, 8000L);
        }
        catch (Exception e) {
            ServiceLog.getLog().info((Object)("\u53d1\u9001\u5fc3\u8df3\u9519\u8bef\u3002\u3002\u3002" + e.getMessage()));
        }
    }

    private void setHostServerOnline() {
        CarparkHost serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost();
        if (serverHost != null) {
            HostEquipmentSate hostState = new HostEquipmentSate();
            hostState.setExistUpgradeFile(0);
            hostState.setVersion(ServiceUtil.getServiceContext().getVersion());
            Map eqMap = Collections.EMPTY_MAP;
            hostState.setEqSates(eqMap);
            hostState.setHostNo(serverHost.getHost_no());
            ServiceUtil.getServiceContext().getHostEquipmentSateManager().setHostOnline(hostState);
        }
    }

    @Override
    public void obtainAccessToken(final CloudDataConnection conn) {
        if (conn == null || !conn.isConnected()) {
            return;
        }
        HardWareInfo hardWarInfo = HardWareUtils.getHardWareInfo();
        LinkedHashMap<String, String> hostInfoMap = new LinkedHashMap<String, String>();
        hostInfoMap.put("motherboardSn", hardWarInfo.getMotherboardSn() == null ? "" : hardWarInfo.getMotherboardSn());
        hostInfoMap.put("hardDiskSn", hardWarInfo.getHardDiskSn() == null ? "" : hardWarInfo.getHardDiskSn());
        hostInfoMap.put("mac", hardWarInfo.getMac() == null ? "" : hardWarInfo.getMac());
        hostInfoMap.put("cpuSn", hardWarInfo.getCpuSn() == null ? "" : hardWarInfo.getCpuSn());
        hostInfoMap.put("osName", System.getProperty("os.name"));
        HashMap<String, LinkedHashMap<String, String>> d = new HashMap<String, LinkedHashMap<String, String>>();
        d.put("hostInfo", hostInfoMap);
        CloudDataProtocol p1 = new CloudDataProtocol();
        p1.setId(this.getId());
        p1.setName(this.getName());
        p1.setCmd("carparkHostRemoteService.obtainToken");
        p1.setMsgId("obtainToken-" + ServiceUtil.getServiceContext().createLongSeq());
        p1.setData(d);
        p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        try {
            conn.send(p1, new CloudDataResponseCallback(){

                @Override
                public void onException(Throwable ex) {
                    ServiceLog.getLog().warn((Object)("\u83b7\u53d6token\u5f02\u5e38: " + ex.getMessage()));
                }

                @Override
                public void onWaitTimeout() {
                    ServiceLog.getLog().warn((Object)"\u83b7\u53d6token\u54cd\u5e94\u8d85\u65f6!");
                }

                @Override
                public void onResponse(CloudDataProtocol response) throws Exception {
                    if (response.getData() == null) {
                        ServiceLog.getLog().warn((Object)"\u83b7\u53d6token\u54cd\u5e94\u9519\u8bef\u7f3a\u5c11\u6570\u636e\uff01");
                    } else {
                        String uploadPicDomains1;
                        Map dataMap = (Map)response.getData();
                        String responseCode = (String)dataMap.get("responseCode");
                        if (responseCode == null || responseCode.length() == 0) {
                            ServiceLog.getLog().warn((Object)"\u83b7\u53d6token\u54cd\u5e94\u9519\u8bef \u7f3a\u5c11\u54cd\u5e94\u7801");
                            return;
                        }
                        if (!"0".equals(responseCode)) {
                            if ("501".equals(responseCode) && dataMap.get("needReconnect") != null) {
                                ServiceLog.getLog().info((Object)"\u670d\u52a1\u5668\u901a\u77e5\u9700\u8981\u91cd\u65b0\u8fde\u63a5\uff0c\u8fd9\u5c06\u91cd\u65b0\u8fdb\u884c\u8fde\u63a5...");
                                conn.destroy();
                                return;
                            }
                            ServiceLog.getLog().warn((Object)("\u83b7\u53d6token\u54cd\u5e94\u9519\u8bef\uff01\u9519\u8bef\uff1a" + responseCode + ", " + dataMap.get("responseMsg")));
                            return;
                        }
                        String token = (String)dataMap.get("token");
                        String tokenTimeoutMins0 = (String)dataMap.get("tokenTimeoutMins");
                        if (token == null || token.length() == 0 || tokenTimeoutMins0 == null || tokenTimeoutMins0.length() == 0) {
                            ServiceLog.getLog().warn((Object)"\u83b7\u53d6token\u54cd\u5e94\u9519\u8bef\u7f3a\u5c11\u6570\u636e");
                            return;
                        }
                        CarparkHostCloudConnection.this.accessToken = token;
                        CarparkHostCloudConnection.this.carparkToken = (String)dataMap.get("carparkToken");
                        CarparkHostCloudConnection.this.validTokenTimeMills = ServiceUtil.getServiceContext().currentTimeMillis() + TimeUnit.MINUTES.toMillis(Long.parseLong(tokenTimeoutMins0));
                        if (!conn.isDestroy()) {
                            if (conn instanceof CloudCometConnection) {
                                ((CloudCometConnection)conn).updateActiveState();
                            } else if (conn instanceof CloudWebsocketConnection) {
                                ((CloudWebsocketConnection)conn).updateActiveState();
                            }
                        }
                        if ((uploadPicDomains1 = (String)dataMap.get("uploadPicDomains")) != null) {
                            CarparkHostCloudConnection.this.uploadPicDomains = uploadPicDomains1;
                        }
                    }
                }
            }, 8000L);
        }
        catch (Exception e) {
            ServiceLog.getLog().info((Object)("\u83b7\u53d6token\u9519\u8bef\u3002\u3002\u3002" + e.getMessage()));
        }
    }

    private String getEqStateMapString() {
        Map<String, String> map = this.getEqStateMap(null, null);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        return GsonBuilder.create().toJson(map);
    }

    private Map<String, String> getEqStateMap(Map<String, String> seqNosMap, Set<String> alwaysOpenList) {
        HashMap<String, String> cEqsMap = null;
        if (ServiceUtil.getServiceContext().getEquipmentManager() != null) {
            Enumeration<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getAllEquipments();
            while (eqs.hasMoreElements()) {
                Equipment eq = eqs.nextElement();
                EquipmentState state = eq.getEquipmentState();
                if (state != null && EquipmentState.DISCONNECTED != state) {
                    String v = null;
                    if (EquipmentState.CONNECTED == state) {
                        v = "1";
                    } else if (EquipmentState.BARRIER_RAISING == state) {
                        v = "2";
                    } else if (EquipmentState.BARRIER_DROPPING == state) {
                        v = "3";
                    } else if (EquipmentState.BARRIER_RAISED_IN_PLACE == state) {
                        v = "2";
                    } else if (EquipmentState.BARRIER_DROPPED_IN_PLACE == state) {
                        v = "3";
                    } else if (EquipmentState.BARRIER_STOPPED == state) {
                        v = "1";
                    }
                    if (v != null) {
                        if (cEqsMap == null) {
                            cEqsMap = new HashMap<String, String>();
                        }
                        cEqsMap.put(eq.getEquipmentNo(), v);
                    }
                }
                String eq_serial_no = null;
                if (eq.getEquipmentAction() != null) {
                    List<String> list;
                    Object action;
                    if (eq.getEquipmentAction() instanceof IceCameraTcpAction) {
                        action = (IceCameraTcpAction)eq.getEquipmentAction();
                        eq_serial_no = ((IceCameraTcpAction)action).getEq_serial_no();
                    } else if (eq.getEquipmentAction() instanceof ZSCameraAction) {
                        action = (ZSCameraAction)eq.getEquipmentAction();
                        eq_serial_no = ((ZSCameraAction)action).getEq_serial_no();
                    } else if (eq.getEquipmentAction() instanceof AlwaysOpenAction && alwaysOpenList != null && (action = (AlwaysOpenAction)eq.getEquipmentAction()).isAlwaysOpen() && (list = eq.getChannelNos()) != null && !list.isEmpty()) {
                        alwaysOpenList.addAll(list);
                    }
                }
                if (eq_serial_no == null || eq_serial_no.length() <= 0 || seqNosMap == null) continue;
                seqNosMap.put(eq.getEquipmentNo(), eq_serial_no);
            }
        }
        return cEqsMap;
    }

    public String getLocalEthIpV4Value() {
        Map<String, Set<String>> tMap = ServiceUtil.getServiceContext().obtainEthIpv4Map(true);
        StringBuilder sbr = new StringBuilder(128);
        if (tMap != null) {
            for (Map.Entry<String, Set<String>> en : tMap.entrySet()) {
                if (sbr.length() > 0) {
                    sbr.append(';');
                }
                sbr.append(en.getKey()).append(':');
                if (en.getValue() == null) continue;
                int i = 0;
                for (String v : en.getValue()) {
                    if (i > 0) {
                        sbr.append(',');
                    }
                    sbr.append(v);
                    ++i;
                }
            }
        }
        return sbr.toString();
    }

    @Override
    public String getCarparkConnId() {
        Carpark carpark = ServiceUtil.getServiceContext().getCarpark();
        if (carpark == null) {
            return null;
        }
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config == null) {
            return null;
        }
        return carpark.getCloud_carpark_id();
    }

    @Override
    protected String getCarparkConnName() {
        return "carpark";
    }

    @Override
    protected String getCarparkToken() {
        if (this.getValidAccessToken() != null) {
            return this.carparkToken;
        }
        return null;
    }

    @Override
    protected String getCarparkSignKey() {
        return this.getSignKey();
    }

    @Override
    protected TransferCrypto getCarparkTransferCrypto() {
        return this.getTransferCrypto();
    }
}

