/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.JsonListType;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.WanNetHostSelector;
import com.wovoe.carpark.cloud.CarparkCloudConnection;
import com.wovoe.carpark.cloud.CarparkCloudTransferCrypto;
import com.wovoe.carpark.cloud.CloudConnectTransferCrypto;
import com.wovoe.carpark.cloud.CloudDataProtocol;
import com.wovoe.carpark.cloud.CloudReceiveClassManager;
import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.cloud.CloudServiceAction;
import com.wovoe.carpark.cloud.ParseException;
import com.wovoe.carpark.cloud.client.CarparkHostCloudConnection;
import com.wovoe.carpark.cloud.client.CarparkHostMsgRequest;
import com.wovoe.carpark.cloud.client.CarparkHostMsgResponse;
import com.wovoe.carpark.cloud.client.CarparkSyncTableLogVo;
import com.wovoe.carpark.cloud.client.DataSyncHandleCallback;
import com.wovoe.carpark.cloud.client.DbDataSyncService;
import com.wovoe.carpark.cloud.client.SyncTable;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkDdlSyncTableLog;
import com.wovoe.carpark.dto.CarparkEscapeOrder;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassSelfPay;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkTranConfig;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.HardWareInfo;
import com.wovoe.framework.HardWareUtils;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.JavaBeanUtil;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.Service;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.http.HttpResponse;
import com.wovoe.framework.http.HttpResponseCallback;
import com.wovoe.framework.http.HttpResponseDataCallback;
import com.wovoe.framework.http.HttpResponseLineStringCallback;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.transfer.IOResponse;
import com.wovoe.framework.transfer.MessageResult;
import com.wovoe.framework.transfer.TransferCrypto;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;

@Service(value="cloudCarparkDataSyncService")
public class CloudCarparkDataSyncService
extends JobTask
implements DbDataSyncService,
DataSyncHandleCallback {
    private static final Object syncLock = new Object();
    protected DataSyncHandleCallback callbackProxy;
    private Properties syncRecordTables;
    private static final String cloudSyncProFile = "cloudSync.conf";
    private static final String cloudSyncPicFile = "cloudPicSync.conf";
    private AtomicBoolean synConfigPic = new AtomicBoolean(false);
    private Properties syncCloudPicConfig;

    private Properties getSyncCloudPicConfig() {
        if (this.syncCloudPicConfig == null) {
            this.syncCloudPicConfig = ServiceUtil.getServiceContext().readLocalRuntimeData("cloud", cloudSyncPicFile, cloudSyncPicFile);
        }
        return this.syncCloudPicConfig;
    }

    private void storeSyncCloudPicConfig(Properties conf) {
        if (conf != null) {
            ServiceUtil.getServiceContext().storeRuntimeDataToFile("cloud", cloudSyncPicFile, cloudSyncPicFile, conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSyncAndCheckDownloadData(DbDataSyncService.SyncServerHost syncServerHost, DataSyncHandleCallback callback) {
        Object object = syncLock;
        synchronized (object) {
            try {
                if (callback != null && callback == this) {
                    callback = null;
                }
                this.callbackProxy = callback;
                this.doSyncRemoteData0(syncServerHost);
            }
            finally {
                this.callbackProxy = null;
            }
        }
        this.checkAndDownloadCarparkPresenceRecord(syncServerHost, callback);
        this.checkAndDownloadCarparkPassSelfPay(syncServerHost, callback);
        this.checkAndDownloadPresenceDiscounts(syncServerHost, callback);
        this.checkAndDownloadCarparkEscapOrder(syncServerHost, callback);
        this.checkAndDownloadPassRecords(syncServerHost, callback);
        this.checkDownloadPic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSyncRemoteData(DbDataSyncService.SyncServerHost syncServerHost, DataSyncHandleCallback callback) {
        Object object = syncLock;
        synchronized (object) {
            try {
                if (callback != null && callback == this) {
                    callback = null;
                }
                this.callbackProxy = callback;
                this.doSyncRemoteData0(syncServerHost);
            }
            finally {
                this.callbackProxy = null;
            }
        }
    }

    public DbDataSyncService.SyncServerHost queryRemoteSyncDataHost(CarparkLocalConfig config) {
        return CloudCarparkDataSyncService.queryRemoteSyncDataHostX(config);
    }

    public static DbDataSyncService.SyncServerHost queryRemoteSyncDataHostX(CarparkLocalConfig config) {
        String connKey;
        String token;
        Map connectMap;
        String hostDomain;
        String signKey;
        String connId;
        String connName;
        block20: {
            block19: {
                String responseCode;
                block18: {
                    CloudDataProtocol p;
                    block17: {
                        block16: {
                            String result;
                            block15: {
                                try {
                                    connName = "caraprkhost";
                                    connId = config.getCloud_host_id();
                                    if (connId != null && connId.length() != 0) break block15;
                                    return null;
                                }
                                catch (Exception ex) {
                                    ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                                    return null;
                                }
                            }
                            HardWareInfo hardWarInfo = HardWareUtils.getHardWareInfo();
                            LinkedHashMap<String, String> hostInfoMap = new LinkedHashMap<String, String>();
                            hostInfoMap.put("motherboardSn", hardWarInfo.getMotherboardSn() == null ? "" : hardWarInfo.getMotherboardSn());
                            hostInfoMap.put("hardDiskSn", hardWarInfo.getHardDiskSn() == null ? "" : hardWarInfo.getHardDiskSn());
                            hostInfoMap.put("mac", hardWarInfo.getMac() == null ? "" : hardWarInfo.getMac());
                            hostInfoMap.put("cpuSn", hardWarInfo.getCpuSn() == null ? "" : hardWarInfo.getCpuSn());
                            hostInfoMap.put("osName", System.getProperty("os.name"));
                            LinkedHashMap<String, Object> requestMap = new LinkedHashMap<String, Object>();
                            requestMap.put("hostNo", config.getHost_no());
                            requestMap.put("hostInfo", hostInfoMap);
                            requestMap.put("ver", ServiceUtil.getServiceContext().getVersion());
                            CloudDataProtocol p1 = new CloudDataProtocol();
                            p1.setId(connId);
                            p1.setName(connName);
                            p1.setCmd("obtainSyncToken");
                            p1.setMsgId("syncToken-" + ServiceUtil.getServiceContext().createLongSeq());
                            p1.setData(requestMap);
                            p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
                            CloudConnectTransferCrypto crypto = new CloudConnectTransferCrypto();
                            signKey = CarparkHostCloudConnection.getSignKey(config);
                            String sendStr = p1.toSendString(signKey, crypto);
                            try {
                                hostDomain = ServiceUtil.getCloudConnectDomain();
                                String url = "http://" + hostDomain + "/core/common/carpark/obtainHostSyncDataToken.do";
                                HashMap<String, String> postMap = new HashMap<String, String>();
                                postMap.put("p", sendStr);
                                Proxy proxy = WanNetHostSelector.getWanProxyHost(hostDomain).getProxy();
                                result = HttpUtil.doRequest((String)url, null, postMap, (int)6000, (int)8000, (Proxy)proxy);
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)("\u83b7\u53d6\u670d\u52a1\u5668\u540c\u6b65\u4e3b\u673a\u5931\u8d25\uff01" + ex.getMessage()));
                                return null;
                            }
                            try {
                                p = CloudDataProtocol.parse(result, signKey, crypto, null);
                            }
                            catch (ParseException e) {
                                ServiceLog.getLog().warn((Object)("\u670d\u52a1\u5668\u53d1\u9001\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e\uff01" + e.getMessage()));
                                return null;
                            }
                            try {
                                if (connId.equals(p.getId())) break block16;
                                ServiceLog.getLog().warn((Object)("\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u7684id\u9519\u8bef\uff01\u670d\u52a1\u5668\u8fd4\u56deid\uff1a" + p.getId()));
                                return null;
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                                return null;
                            }
                        }
                        if (connName.equals(p.getName())) break block17;
                        ServiceLog.getLog().warn((Object)("\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u7684name\u9519\u8bef\uff01\u670d\u52a1\u5668\u8fd4\u56dename\uff1a" + p.getName()));
                        return null;
                    }
                    connectMap = (Map)p.getData();
                    responseCode = (String)connectMap.get("responseCode");
                    if (responseCode != null && responseCode.length() != 0) break block18;
                    ServiceLog.getLog().warn((Object)"\u8fde\u63a5\u7ed3\u679c\u7f3a\u5c11\u6570\u636e");
                    return null;
                }
                if ("0".equals(responseCode)) break block19;
                ServiceLog.getLog().warn((Object)("\u8fde\u63a5\u5931\u8d25\uff01\u9519\u8bef\uff1a" + responseCode + ", " + connectMap.get("responseMsg")));
                return null;
            }
            token = (String)connectMap.get("token");
            connKey = (String)connectMap.get("connKey");
            if (token != null && token.length() != 0 && connKey != null && connKey.length() != 0) break block20;
            ServiceLog.getLog().warn((Object)"\u8fde\u63a5\u7ed3\u679c\u7f3a\u5c11\u6570\u636e");
            return null;
        }
        String domain = (String)connectMap.get("syncHost");
        if (domain == null || domain.length() == 0) {
            domain = hostDomain;
        }
        String uploadPicDomains = (String)connectMap.get("uploadPicDomains");
        String picDomain = CloudCarparkDataSyncService.getDomain(uploadPicDomains, domain);
        CarparkCloudTransferCrypto syncp = new CarparkCloudTransferCrypto(BytesTool.unCompress((String)connKey));
        DbDataSyncService.CloudSyncServerHost host = new DbDataSyncService.CloudSyncServerHost(token, syncp, signKey, connName, connId, domain, config.getCarpark_id(), config.getProject_id(), picDomain);
        return host;
    }

    public static byte[] getRemotePic(String path, DbDataSyncService.SyncServerHost host) {
        if (host == null) {
            host = CloudCarparkDataSyncService.getDefaultSyncServerHost();
        }
        if (host == null) {
            return null;
        }
        if (path == null || path.length() == 0) {
            return null;
        }
        try {
            String hostDomain = host.getPicDomain();
            if (hostDomain == null || hostDomain.length() == 0) {
                hostDomain = host.getDomain();
            }
            String url = "http://" + hostDomain + "/core/common/carpark/obtainCarparkImage.do";
            HashMap<String, String> postMap = new HashMap<String, String>();
            postMap.put("t", host.getToken());
            postMap.put("p", BytesTool.compressBytes((byte[])path.getBytes()));
            Proxy proxy = WanNetHostSelector.getWanProxyHost(hostDomain).getProxy();
            return (byte[])HttpUtil.doRequest((String)url, null, postMap, null, null, (HttpResponseCallback)new HttpResponseDataCallback<byte[]>(){
                ByteArrayOutputStream out = null;

                public byte[] onComplete() {
                    if (this.out == null) {
                        return null;
                    }
                    byte[] b = this.out.toByteArray();
                    if (b.length == 0) {
                        return null;
                    }
                    return b;
                }

                public void onException(Throwable ex) {
                    this.out = null;
                }

                public boolean onHeaders(HttpResponse r) {
                    if (this.out == null) {
                        if (r.getContentType() == null || r.getContentType().indexOf("image/") == -1) {
                            throw new RuntimeException("\u54cd\u5e94\u8fd4\u56de\u9519\u8bef\u7684ContentType:" + r.getContentType());
                        }
                        int len = (int)r.getContentLength();
                        this.out = len <= 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(len);
                    }
                    return true;
                }

                public boolean callback(byte[] data, int offset, int length) {
                    this.out.write(data, offset, length);
                    return true;
                }
            }, (int)6000, (int)8000, (Proxy)proxy);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u4e91\u7aef\u56fe\u7247:" + path + "\u5931\u8d25\uff01" + ex));
            return null;
        }
    }

    public static DbDataSyncService.SyncServerHost getDefaultSyncServerHost() {
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config == null || ServiceUtil.getServiceContext().getCloudContext() == null) {
            return null;
        }
        CarparkCloudConnection connection = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection();
        if (connection == null) {
            return null;
        }
        if (!connection.isConnected()) {
            return null;
        }
        if (!(connection instanceof CarparkHostCloudConnection)) {
            return null;
        }
        String token = connection.getValidAccessToken();
        TransferCrypto crypto = connection.getTransferCrypto();
        String signKey = connection.getSignKey();
        String connName = connection.getName();
        String connId = connection.getId();
        String domain = connection.getConnectCloudDomin();
        Integer carparkId = config.getCarpark_id();
        Integer projectId = config.getProject_id();
        if (token == null || token.length() == 0 || crypto == null || signKey == null || signKey.length() == 0 || connName == null || connName.length() == 0 || connId == null || connId.length() == 0 || domain == null || domain.length() == 0 || carparkId == null || carparkId <= 0) {
            return null;
        }
        DbDataSyncService.CloudSyncServerHost host = new DbDataSyncService.CloudSyncServerHost(token, crypto, signKey, connName, connId, domain, carparkId, projectId, connection.getUploadPicDomain());
        return host;
    }

    protected static String getDomain(String domains, String defaultDomain) {
        int index;
        if (domains == null || domains.length() == 0) {
            return defaultDomain;
        }
        if (domains.indexOf(44) == -1) {
            return domains;
        }
        String[] a = domains.split(",");
        String host = a[index = Math.abs(new Random().nextInt()) % a.length];
        if (host.length() == 0) {
            return a[0];
        }
        return host;
    }

    public Set<String> getSyncTableSet() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        HashSet<String> tableSet = new HashSet<String>();
        this.setSyncTableSet(daoService, null, tableSet);
        return tableSet;
    }

    @Override
    public Collection<String> getAllNeedSyncTables() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        HashSet<String> tableSet = new HashSet<String>();
        this.setSyncTableSet(daoService, null, tableSet);
        tableSet.add(daoService.getTableName(CarparkPresenceRecord.class));
        tableSet.add(daoService.getTableName(CarparkPassSelfPay.class));
        tableSet.add(daoService.getTableName(CarparkPassDiscount.class));
        tableSet.add(daoService.getTableName(CarparkPassRecord.class));
        return tableSet;
    }

    private void setSyncTableSet(CommonDaoService daoService, Map<String, Long> tMap, Set<String> tableSet) {
        Enumeration enumeration = daoService.getAllTableNames();
        String _sync = "_sync";
        Long v = 0L;
        while (enumeration.hasMoreElements()) {
            Class poClass;
            String tableName = (String)enumeration.nextElement();
            if (!tableName.endsWith("_sync") || (poClass = daoService.getPoClass(tableName)) == null || poClass.equals(CarparkTranConfig.class) || poClass.equals(Carpark.class)) continue;
            if (tMap != null) {
                tMap.put(tableName, v);
            }
            if (tableSet == null) continue;
            tableSet.add(tableName);
        }
    }

    private void doSyncRemoteData0(DbDataSyncService.SyncServerHost syncServerHost) {
        try {
            KeyValueEntry<String, Object> kv;
            if (syncServerHost == null) {
                syncServerHost = CloudCarparkDataSyncService.getDefaultSyncServerHost();
            }
            if (syncServerHost == null) {
                if (this.callbackProxy != null) {
                    this.onSynException(null, new Exception("\u65e0\u6cd5\u8fde\u63a5\u5e73\u53f0\u670d\u52a1\u5668"));
                }
                return;
            }
            TransferCrypto crypto = syncServerHost.getCrypto();
            String token = syncServerHost.getToken();
            String connectDomain = syncServerHost.getDomain();
            String carparkSignKey = syncServerHost.getSignKey();
            String cloud_conn_id = syncServerHost.getConnectId();
            String cloud_conn_name = syncServerHost.getConnectName();
            Integer carpark_id = syncServerHost.getCarparkId();
            Integer project_id = syncServerHost.getProjectId();
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            HashMap<String, Long> tMap = new HashMap<String, Long>();
            HashSet<String> tableSet = new HashSet<String>();
            this.setSyncTableSet(daoService, tMap, tableSet);
            this.onCheckSyncTables(tableSet);
            List syncLogs = daoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkDdlSyncTableLog.class, null);
            if (syncLogs != null && !syncLogs.isEmpty()) {
                for (CarparkDdlSyncTableLog log : syncLogs) {
                    Long v1;
                    tableSet.remove(log.getTable_name());
                    if (!tMap.containsKey(log.getTable_name()) || (v1 = log.getLatest_sync_log_id()) == null) continue;
                    tMap.put(log.getTable_name(), v1);
                }
            }
            if (!tableSet.isEmpty()) {
                Calendar cl = Calendar.getInstance();
                cl.set(1, 2010);
                cl.set(2, 0);
                cl.set(5, 1);
                cl.set(14, 0);
                cl.set(11, 0);
                cl.set(12, 0);
                cl.set(13, 0);
                Date date = cl.getTime();
                for (String tableName : tableSet) {
                    CarparkDdlSyncTableLog log = new CarparkDdlSyncTableLog();
                    log.setId(daoService.getSequece("ck_common_seq"));
                    log.setCarpark_id(carpark_id);
                    log.setLatest_sync_log_id(0L);
                    log.setLatest_sync_log_time(date);
                    log.setProject_id(project_id);
                    log.setTable_name(tableName);
                    daoService.insert((Object)log);
                }
            }
            if (!"op".equals((kv = this.checkDataVersions(crypto, carparkSignKey, token, cloud_conn_id, cloud_conn_name, connectDomain, tMap)).getKey())) {
                this.onSynException(null, new Exception((String)kv.getValue()));
                return;
            }
            List tableOpList = (List)kv.getValue();
            if (tableOpList == null || tableOpList.isEmpty()) {
                this.onSynException(null, new Exception("\u67e5\u8be2\u540c\u6b65\u7248\u672c\u9519\u8bef\uff01\u8fd4\u56de\u7a7a\u96c6\u5408"));
                return;
            }
            LinkedList<SyncTable> syncTablesList = new LinkedList<SyncTable>();
            for (Map tableOp : tableOpList) {
                String opMethod = (String)tableOp.get("opMethod");
                String tableName = (String)tableOp.get("tableName");
                if (tableName == null || tableName.length() == 0) {
                    ServiceLog.getLog().warn((Object)"\u670d\u52a1\u5668\u8fd4\u56de\u7f3a\u5c11\u540c\u6b65\u64cd\u4f5c\u7684tableName");
                    continue;
                }
                try {
                    SyncTable t;
                    Class poClass = daoService.getPoClass(tableName);
                    if (poClass == null) {
                        ServiceLog.getLog().warn((Object)("\u670d\u52a1\u5668\u8fd4\u56de\u7f3a\u5c11\u540c\u6b65\u64cd\u4f5c\u7684\u8868: " + tableName + ", po\u65e0\u6cd5\u627e\u5230!"));
                        continue;
                    }
                    Long latest_sync_log_id = (Long)tMap.get(tableName);
                    if (latest_sync_log_id == null) {
                        ServiceLog.getLog().warn((Object)("\u670d\u52a1\u5668\u8fd4\u56de\u7f3a\u5c11\u540c\u6b65\u64cd\u4f5c\u7684\u8868: " + tableName + ", \u4e0d\u5728\u96c6\u5408\u8303\u56f4\u5185!"));
                        continue;
                    }
                    if ("syncAllData".equals(opMethod)) {
                        ServiceLog.getLog().info((Object)(String.valueOf(tableName) + " \u9700\u8981\u5168\u8868\u540c\u6b65"));
                        t = new SyncTable(tableName, poClass, 1, latest_sync_log_id);
                        syncTablesList.add(t);
                        continue;
                    }
                    if ("syncLogData".equals(opMethod)) {
                        ServiceLog.getLog().info((Object)(String.valueOf(tableName) + " \u9700\u8981\u589e\u91cf\u540c\u6b65"));
                        t = new SyncTable(tableName, poClass, 0, latest_sync_log_id);
                        syncTablesList.add(t);
                        continue;
                    }
                    if ("allSynchronized".equals(opMethod)) continue;
                    if ("NOT_SUPPORT".equals(opMethod)) {
                        ServiceLog.getLog().info((Object)("\u670d\u52a1\u4e0d\u652f\u6301\u8868: " + tableName + ", \u7684\u540c\u6b65\uff01\uff01\uff01\uff01\uff01\uff01\uff01"));
                        continue;
                    }
                    ServiceLog.getLog().info((Object)("\u670d\u52a1\u8fd4\u56de\u672a\u77e5\u7684\u540c\u6b65\u64cd\u4f5c\u65b9\u5f0f: " + opMethod + ", \u8868\uff1a" + tableName));
                }
                finally {
                    this.onSyncCheckResult(tableName, opMethod);
                }
            }
            if (syncTablesList == null || syncTablesList.isEmpty()) {
                return;
            }
            this.doSyncTables(syncTablesList, syncServerHost);
        }
        catch (Throwable ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            this.onSynException(null, ex);
        }
    }

    private void doSyncTables(LinkedList<SyncTable> syncTablesList, DbDataSyncService.SyncServerHost syncServerHost) {
        if (syncTablesList == null || syncTablesList.isEmpty() || syncServerHost == null) {
            return;
        }
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        String synlogTableName = daoService.getTableName(CarparkDdlSyncTableLog.class);
        for (SyncTable syncTable : syncTablesList) {
            try {
                try {
                    TransferCrypto crypto = syncServerHost.getCrypto();
                    String token = syncServerHost.getToken();
                    String connectDomain = syncServerHost.getDomain();
                    String carparkSignKey = syncServerHost.getSignKey();
                    String cloud_conn_id = syncServerHost.getConnectId();
                    String cloud_conn_name = syncServerHost.getConnectName();
                    Integer carpark_id = syncServerHost.getCarparkId();
                    Integer project_id = syncServerHost.getProjectId();
                    StringBuilder urlBuilder = new StringBuilder(128);
                    urlBuilder.append(this.getRequestProtocl()).append(connectDomain).append("/core/remote/gateway/rpc/transfer/invoke/").append(token);
                    String url = urlBuilder.toString();
                    Task task = new Task(url, 10000, syncTable, this, synlogTableName, daoService, cloud_conn_id, cloud_conn_name, carparkSignKey, crypto, carpark_id, project_id);
                    if (syncTable.getOp_type() == 1) {
                        task.syncAllData();
                    } else {
                        task.syncLogData();
                    }
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().warn((Object)("\u540c\u6b65\u8868" + syncTable.getTableName() + " \u51fa\u73b0\u5f02\u5e38! :" + ex.getMessage()));
                    this.onSynException(syncTable.getTableName(), ex);
                    this.onFinishATable(syncTable.getTableName());
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.onFinishATable(syncTable.getTableName());
                throw throwable;
            }
            this.onFinishATable(syncTable.getTableName());
        }
    }

    protected KeyValueEntry<String, Object> checkDataVersions(TransferCrypto crypto, String signKey, String token, String cloud_conn_id, String cloud_conn_name, String hostIpPort, Map<String, Long> requestMap) {
        String result;
        StringBuilder urlBuilder = new StringBuilder(128);
        urlBuilder.append(this.getRequestProtocl()).append(hostIpPort).append("/core/remote/gateway/rpc/transfer/invoke/").append(token);
        String requestUrl = urlBuilder.toString();
        CloudDataProtocol p1 = new CloudDataProtocol();
        p1.setId(cloud_conn_id);
        p1.setName(cloud_conn_name);
        p1.setCmd("carparkSyncDbDataService.checkDataVersions");
        p1.setMsgId("chV-" + ServiceUtil.getServiceContext().createLongSeq());
        p1.setData(requestMap);
        p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        String sendString = p1.toSendString(signKey, crypto);
        try {
            Proxy proxy = WanNetHostSelector.getWanProxyHost(hostIpPort).getProxy();
            result = HttpUtil.doJsonRquest((String)requestUrl, null, (String)sendString, (Proxy)proxy);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1" + p1.getCmd() + " \u9519\u8bef! ," + ex.getMessage()));
            return new KeyValueEntry((Object)"REQUEST_ERROR", (Object)"\u8bf7\u6c42\u9519\u8bef");
        }
        KeyValueEntry<String, Object> kv = CloudCarparkDataSyncService.parseLine(crypto, signKey, p1.getCmd(), result);
        if ("op".equals(kv.getKey())) {
            List plist;
            try {
                plist = (List)GsonBuilder.create().fromJson(kv.getValue().toString(), new TypeToken<List<Map<String, String>>>(){}.getType());
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1carparkSyncDbDataService.checkDataVersions \u9519\u8bef! \u8fd4\u56de\u4e0d\u662fList json\u5bf9\u8c61: " + kv.getValue()));
                return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u54cd\u5e94\u9519\u8bef\uff0c\u8fd4\u56de\u9519\u8bef\u7684\u6570\u636e\u5185\u5bb9");
            }
            return new KeyValueEntry((Object)((String)kv.getKey()), (Object)plist);
        }
        return kv;
    }

    protected static KeyValueEntry<String, Object> parseLine(TransferCrypto crypto, String signKey, String cmd, String result) {
        String sx;
        if (result == null || result.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1" + cmd + " \u9519\u8bef! \u8fd4\u56de\u7a7a\u6570\u636e"));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u54cd\u5e94\u9519\u8bef\uff0c\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u6570\u636e");
        }
        try {
            sx = crypto.decrypt(result);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1" + cmd + " \u9519\u8bef! \u8fd4\u56de\u65e0\u6cd5\u89e3\u5bc6\u7684\u6570\u636e: " + result));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u54cd\u5e94\u9519\u8bef\uff0c\u8fd4\u56de\u9519\u8bef\u7684\u6570\u636e\u5185\u5bb9");
        }
        if (sx.length() < 3) {
            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1" + cmd + " \u9519\u8bef! \u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e: " + sx));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u54cd\u5e94\u9519\u8bef\uff0c\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e");
        }
        if (sx.startsWith("{") && sx.endsWith("}")) {
            try {
                Map map = (Map)GsonBuilder.create().fromJson(sx, HashMap.class);
                Object data = map.get("data");
                if (data == null || !(data instanceof Map)) {
                    ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1" + cmd + " \u9519\u8bef! \u8fd4\u56de\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e: " + sx));
                    return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u54cd\u5e94\u9519\u8bef\uff0c\u8fd4\u56de\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e");
                }
                Map dataMap = (Map)data;
                String responseCode = (String)dataMap.get("responseCode");
                String responseMsg = (String)dataMap.get("responseMsg");
                if (responseCode == null || responseCode.length() == 0) {
                    ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1" + cmd + " \u9519\u8bef! \u8fd4\u56de\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u7f3a\u5c11responseCode: " + sx));
                    return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u54cd\u5e94\u9519\u8bef\uff0c\u8fd4\u56de\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e");
                }
                if (responseMsg == null) {
                    responseMsg = "\u9519\u8bef\u4ee3\u7801: " + responseCode;
                }
                ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1" + cmd + " \u9519\u8bef! \u8fd4\u56de\u9519\u8bef " + sx));
                return new KeyValueEntry((Object)("OP_ERROR_" + responseCode), (Object)("\u8bf7\u6c42\u5931\u8d25\uff01" + responseMsg));
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1" + cmd + " \u9519\u8bef! \u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e: " + sx));
                return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u54cd\u5e94\u9519\u8bef\uff0c\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e");
            }
        }
        if (sx.charAt(2) == ':') {
            String checkSign;
            int x = sx.lastIndexOf(44);
            if (x == -1) {
                ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1" + cmd + " \u9519\u8bef! \u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e: " + sx));
                return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u54cd\u5e94\u9519\u8bef\uff0c\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e");
            }
            String msg = sx.substring(0, x + 1);
            String sign = sx.substring(x + 1);
            if (!sign.equals(checkSign = CryptoUtil.MD5Encode((String)(String.valueOf(msg) + signKey)))) {
                ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1" + cmd + " \u9519\u8bef! \u670d\u52a1\u5668\u54cd\u5e94\u7684\u6570\u636e\u7b7e\u540d\u9519\u8bef: " + sx));
                return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u54cd\u5e94\u9519\u8bef\uff0c\u670d\u52a1\u5668\u54cd\u5e94\u7684\u6570\u636e\u7b7e\u540d\u9519\u8bef");
            }
            String head = msg.substring(0, 2);
            String value = msg.substring(3, x);
            return new KeyValueEntry((Object)head, (Object)value);
        }
        ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5e73\u53f0\u4e1a\u52a1" + cmd + " \u9519\u8bef! \u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e: " + sx));
        return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u54cd\u5e94\u9519\u8bef\uff0c\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e");
    }

    public String getRequestProtocl() {
        return "http://";
    }

    public void onFinishARecord(String tableName) {
        DataSyncHandleCallback callback = this.callbackProxy;
        if (callback != null) {
            try {
                callback.onFinishARecord(tableName);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void onCheckSyncTables(Collection<String> tableNames) {
        DataSyncHandleCallback callback = this.callbackProxy;
        if (callback != null) {
            try {
                callback.onCheckSyncTables(tableNames);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void onSyncCheckResult(String tableName, String opMethod) {
        DataSyncHandleCallback callback = this.callbackProxy;
        if (callback != null) {
            try {
                callback.onSyncCheckResult(tableName, opMethod);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void onFinishARecord(String tableName, String recordId, String op) {
        try {
            String v = "I".equals(op) ? "\u63d2\u5165" : ("U".equals(op) ? "\u66f4\u65b0" : ("D".equals(op) ? "\u5220\u9664" : "\u672a\u77e5\u64cd\u4f5c"));
            ServiceLog.getLog().info((Object)(String.valueOf(v) + "\u4e00\u7b14\u8bb0\u5f55\u5b8c\u6210\uff01\u8868\uff1a" + tableName + ", id:" + recordId));
            DataSyncHandleCallback callback = this.callbackProxy;
            if (callback != null) {
                try {
                    callback.onFinishARecord(tableName, recordId, op);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        finally {
            this.onFinishARecord(tableName);
        }
    }

    public void onFinishATable(String tableName) {
        ServiceLog.getLog().info((Object)("\u540c\u6b65\u5b8c\u6210\u8868\uff1a" + tableName));
        DataSyncHandleCallback callback = this.callbackProxy;
        if (callback != null) {
            try {
                callback.onFinishATable(tableName);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void onSynException(String tableName, Throwable exception) {
        DataSyncHandleCallback callback = this.callbackProxy;
        if (callback != null) {
            try {
                callback.onSynException(tableName, exception);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected void storeSyncRecordTablesConf(Properties conf) {
        if (conf != null) {
            ServiceUtil.getServiceContext().storeRuntimeDataToFile("cloud", cloudSyncProFile, cloudSyncProFile, conf);
        }
    }

    protected Properties getSyncRecordTablesConf() {
        if (this.syncRecordTables == null) {
            this.syncRecordTables = ServiceUtil.getServiceContext().readLocalRuntimeData("cloud", cloudSyncProFile, cloudSyncProFile);
        }
        return this.syncRecordTables;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void checkAndDownloadCarparkPresenceRecord(DbDataSyncService.SyncServerHost syncServerHost, DataSyncHandleCallback callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long createLocalRecordSeq(CommonDaoService commonDaoService, String seqName) {
        long id = commonDaoService.getSequece(seqName);
        long idHead = (long)ServiceUtil.getServiceContext().getCarparkLocalConfig().getSeq_prefix().intValue() << 32;
        return idHead | id;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkAndDownloadCarparkPassSelfPay(DbDataSyncService.SyncServerHost syncServerHost, DataSyncHandleCallback callback) {
        long cmills;
        int uv;
        Properties conf;
        String tableName;
        block21: {
            String carparkPresenceRecordTableName;
            String v;
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            tableName = daoService.getTableName(CarparkPassSelfPay.class);
            if (callback != null) {
                callback.onCheckSyncTables(Arrays.asList(tableName));
            }
            if (!"1".equals(v = (conf = this.getSyncRecordTablesConf()).getProperty(carparkPresenceRecordTableName = daoService.getTableName(CarparkPresenceRecord.class), ""))) {
                if (callback != null) {
                    callback.onSynException(tableName, new Exception("\u5728\u573a\u8bb0\u5f55\u672a\u80fd\u6210\u529f\u540c\u6b65\uff01\u8bf7\u5148\u5b8c\u6210"));
                }
                return;
            }
            v = conf.getProperty(tableName, "");
            if ("1".equals(v)) {
                if (callback != null) {
                    callback.onSyncCheckResult(tableName, "allSynchronized");
                }
                return;
            }
            if (callback != null) {
                callback.onSyncCheckResult(tableName, "syncAllData");
            }
            if (syncServerHost == null) {
                syncServerHost = CloudCarparkDataSyncService.getDefaultSyncServerHost();
            }
            if (syncServerHost == null) {
                if (callback != null) {
                    callback.onSynException(tableName, new Exception("\u672a\u80fd\u8fde\u63a5\u5e73\u53f0"));
                }
                return;
            }
            TransferCrypto crypto = syncServerHost.getCrypto();
            String token = syncServerHost.getToken();
            String connectDomain = syncServerHost.getDomain();
            String signKey = syncServerHost.getSignKey();
            String cloud_conn_id = syncServerHost.getConnectId();
            String cloud_conn_name = syncServerHost.getConnectName();
            ServiceLog.getLog().info((Object)"\u53d1\u73b0\u9700\u8981\u540c\u6b65\u5728\u573a\u5df2\u7f34\u8d39\u8bb0\u5f55\uff0c\u8fd9\u5c06\u8fdb\u884c\u540c\u6b65....");
            long nexId = 0L;
            int fetchSize = 50;
            String cmd = "carparkHostSyncRemoteService.fetchAllRecords";
            JsonListType<CarparkPassSelfPay> jsonListType = new JsonListType<CarparkPassSelfPay>(CarparkPassSelfPay.class);
            uv = 0;
            cmills = ServiceUtil.getServiceContext().currentTimeMillis();
            block2: while (true) {
                CloudDataProtocol p1 = new CloudDataProtocol();
                p1.setId(cloud_conn_id);
                p1.setName(cloud_conn_name);
                p1.setCmd("carparkHostSyncRemoteService.fetchAllRecords");
                p1.setMsgId("dataSyncCPX-" + ServiceUtil.getServiceContext().createLongSeq());
                p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                data.put("gtId", nexId);
                data.put("tableName", tableName);
                data.put("fetchSize", fetchSize);
                p1.setData(data);
                String sendString = p1.toSendString(signKey, crypto);
                StringBuilder urlBuilder = new StringBuilder(128);
                urlBuilder.append(this.getRequestProtocl()).append(connectDomain).append("/core/remote/gateway/rpc/transfer/invoke/").append(token);
                String requestUrl = urlBuilder.toString();
                Proxy proxy = WanNetHostSelector.getWanProxyHost(connectDomain).getProxy();
                String resltV = HttpUtil.doJsonRquest((String)requestUrl, null, (String)sendString, (Proxy)proxy);
                CloudDataProtocol resultP = CloudDataProtocol.parse(resltV, signKey, crypto, null);
                Map rmap = (Map)resultP.getData();
                if (!"0".equals(rmap.get("responseCode"))) {
                    ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u5728\u573a\u8f66\u8f86\u5df2\u7f34\u8d39\u8bb0\u5f55\u5931\u8d25! \u539f\u56e0:" + rmap));
                    if (callback != null) {
                        callback.onSynException(tableName, new Exception("\u4e0b\u8f7d\u5728\u573a\u8f66\u8f86\u5df2\u7f34\u8d39\u8bb0\u5f55\u5931\u8d25! \u539f\u56e0:" + rmap.get("responseMsg")));
                    }
                    return;
                }
                Object obj = rmap.get("fetchSize");
                if (obj == null) {
                    ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u5728\u573a\u8f66\u8f86\u5df2\u7f34\u8d39\u8bb0\u5f55\u5931\u8d25! \u539f\u56e0\u7f3a\u5c11\u6293\u53d6\u6570\u91cffetchSize:" + rmap));
                    if (callback != null) {
                        callback.onSynException(tableName, new Exception("\u4e0b\u8f7d\u5728\u573a\u8f66\u8f86\u5df2\u7f34\u8d39\u8bb0\u5f55\u5931\u8d25! \u539f\u56e0\u7f3a\u5c11\u6293\u53d6\u6570\u91cffetchSize"));
                    }
                    return;
                }
                int cSize = obj instanceof Number ? ((Number)obj).intValue() : Integer.parseInt(obj.toString());
                if (cSize == 0) break block21;
                String recordsJson = (String)rmap.get("recordsJson");
                if (recordsJson == null || recordsJson.length() == 0) {
                    ServiceLog.getLog().warn((Object)"\u4e0b\u8f7d\u5728\u573a\u8f66\u8f86\u5df2\u7f34\u8d39\u8bb0\u5f55\u5931\u8d25? \u539f\u56e0\u6293\u53d6\u6570\u91cf\u5927\u4e8e0,\u4f46\u662f recordsJson \u4e3a\u7a7a");
                    break block21;
                }
                List recordList = (List)GsonBuilder.create().fromJson(recordsJson, jsonListType);
                Iterator iterator = recordList.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (cSize >= fetchSize) continue block2;
                        break block21;
                    }
                    CarparkPassSelfPay record = (CarparkPassSelfPay)iterator.next();
                    nexId = record.getId();
                    daoService.synDataByPrimeryKey((Object)record);
                    ++uv;
                    if (callback == null) continue;
                    callback.onFinishARecord(tableName, record.getId().toString(), "I");
                    callback.onFinishARecord(tableName);
                }
                break;
            }
            catch (Exception e) {
                ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u8bb0\u5f55\u5728\u573a\u8f66\u8f86\u5df2\u7f34\u8d39\u8bb0\u5f55\u5f02\u5e38! \u539f\u56e0: " + e.getMessage()));
                if (callback != null) {
                    callback.onSynException(tableName, e);
                }
                return;
            }
        }
        conf.setProperty(tableName, "1");
        this.storeSyncRecordTablesConf(conf);
        long cx = ServiceUtil.getServiceContext().currentTimeMillis() - cmills;
        String ust = cx < 1000L ? String.valueOf(cx) + "\u6beb\u79d2" : String.valueOf(cx / 1000L) + "\u79d2 " + cx % 1000L + "\u6beb\u79d2";
        ServiceLog.getLog().info((Object)("\u5df2\u5168\u90e8\u4e0b\u8f7d\u5e73\u53f0\u5728\u573a\u8f66\u8f86\u5df2\u7f34\u8d39\u8bb0\u5f55! \u66f4\u65b0\u6761\u6570: " + uv + ",  \u7528\u65f6: " + ust));
        if (callback != null) {
            callback.onFinishATable(tableName);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkAndDownloadCarparkEscapOrder(DbDataSyncService.SyncServerHost syncServerHost, DataSyncHandleCallback callback) {
        long cmills;
        int uv;
        Properties downloadPicConf;
        Properties conf;
        String tableName;
        block24: {
            String v;
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            tableName = daoService.getTableName(CarparkEscapeOrder.class);
            if (callback != null) {
                callback.onCheckSyncTables(Arrays.asList(tableName));
            }
            if ("1".equals(v = (conf = this.getSyncRecordTablesConf()).getProperty(tableName, ""))) {
                if (callback != null) {
                    callback.onSyncCheckResult(tableName, "allSynchronized");
                }
                return;
            }
            if (callback != null) {
                callback.onSyncCheckResult(tableName, "syncAllData");
            }
            if (syncServerHost == null) {
                syncServerHost = CloudCarparkDataSyncService.getDefaultSyncServerHost();
            }
            if (syncServerHost == null) {
                if (callback != null) {
                    callback.onSynException(tableName, new Exception("\u672a\u80fd\u8fde\u63a5\u5e73\u53f0"));
                }
                return;
            }
            downloadPicConf = this.getSyncCloudPicConfig();
            TransferCrypto crypto = syncServerHost.getCrypto();
            String token = syncServerHost.getToken();
            String connectDomain = syncServerHost.getDomain();
            String signKey = syncServerHost.getSignKey();
            String cloud_conn_id = syncServerHost.getConnectId();
            String cloud_conn_name = syncServerHost.getConnectName();
            ServiceLog.getLog().info((Object)"\u53d1\u73b0\u9700\u8981\u540c\u6b65\u79bb\u573a\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355\uff0c\u8fd9\u5c06\u8fdb\u884c\u540c\u6b65....");
            long nexId = 0L;
            int fetchSize = 50;
            String cmd = "carparkHostSyncRemoteService.fetchAllRecords";
            JsonListType<CarparkEscapeOrder> jsonListType = new JsonListType<CarparkEscapeOrder>(CarparkEscapeOrder.class);
            uv = 0;
            cmills = ServiceUtil.getServiceContext().currentTimeMillis();
            block4: while (true) {
                CloudDataProtocol p1 = new CloudDataProtocol();
                p1.setId(cloud_conn_id);
                p1.setName(cloud_conn_name);
                p1.setCmd("carparkHostSyncRemoteService.fetchAllRecords");
                p1.setMsgId("dataSyncCPD-" + ServiceUtil.getServiceContext().createLongSeq());
                p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                data.put("gtId", nexId);
                data.put("tableName", tableName);
                data.put("fetchSize", fetchSize);
                p1.setData(data);
                String sendString = p1.toSendString(signKey, crypto);
                StringBuilder urlBuilder = new StringBuilder(128);
                urlBuilder.append(this.getRequestProtocl()).append(connectDomain).append("/core/remote/gateway/rpc/transfer/invoke/").append(token);
                String requestUrl = urlBuilder.toString();
                Proxy proxy = WanNetHostSelector.getWanProxyHost(connectDomain).getProxy();
                String resltV = HttpUtil.doJsonRquest((String)requestUrl, null, (String)sendString, (Proxy)proxy);
                CloudDataProtocol resultP = CloudDataProtocol.parse(resltV, signKey, crypto, null);
                Map rmap = (Map)resultP.getData();
                if (!"0".equals(rmap.get("responseCode"))) {
                    ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u79bb\u573a\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355\u5931\u8d25! \u539f\u56e0:" + rmap));
                    if (callback != null) {
                        callback.onSynException(tableName, new Exception("\u4e0b\u8f7d\u79bb\u573a\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355\u5931\u8d25! \u539f\u56e0:" + rmap.get("responseMsg")));
                    }
                    return;
                }
                Object obj = rmap.get("fetchSize");
                if (obj == null) {
                    ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u79bb\u573a\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355\u5931\u8d25! \u539f\u56e0\u7f3a\u5c11\u6293\u53d6\u6570\u91cffetchSize:" + rmap));
                    if (callback != null) {
                        callback.onSynException(tableName, new Exception("\u4e0b\u8f7d\u79bb\u573a\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355\u5931\u8d25! \u539f\u56e0\u7f3a\u5c11\u6293\u53d6\u6570\u91cf"));
                    }
                    return;
                }
                int cSize = obj instanceof Number ? ((Number)obj).intValue() : Integer.parseInt(obj.toString());
                if (cSize == 0) break block24;
                String recordsJson = (String)rmap.get("recordsJson");
                if (recordsJson == null || recordsJson.length() == 0) {
                    ServiceLog.getLog().warn((Object)"\u4e0b\u8f7d\u79bb\u573a\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355\u5931\u8d25? \u539f\u56e0\u6293\u53d6\u6570\u91cf\u5927\u4e8e0,\u4f46\u662f recordsJson \u4e3a\u7a7a");
                    break block24;
                }
                List recordList = (List)GsonBuilder.create().fromJson(recordsJson, jsonListType);
                Iterator iterator = recordList.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (cSize >= fetchSize) continue block4;
                        break block24;
                    }
                    CarparkEscapeOrder record = (CarparkEscapeOrder)iterator.next();
                    if (record.getCreated_time() == null) {
                        record.setCreated_time(record.getExit_time());
                    }
                    nexId = record.getId();
                    if (record.getExit_record_no() == null) continue;
                    long recordId = 0L;
                    try {
                        if (record.getExit_record_no().startsWith("S") || record.getExit_record_no().startsWith("C")) {
                            recordId = Long.parseLong(record.getExit_record_no().substring(1));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (recordId <= 0L) {
                        long count = daoService.selectCount(new SearchParam(tableName).addEQ("passport_number", (Object)record.getPassport_number()).addEQ("exit_time", (Object)record.getExit_time()).addEQ("exit_record_no", (Object)record.getExit_record_no()).addEQ("carpark_id", (Object)record.getCarpark_id()));
                        if (count != 0L) continue;
                        recordId = CloudCarparkDataSyncService.createLocalRecordSeq(daoService, "ck_carpark_pass_record_seq");
                    }
                    record.setId(recordId);
                    daoService.synDataByPrimeryKey((Object)record);
                    CloudCarparkDataSyncService.setDownloadPassRecordPic(downloadPicConf, record);
                    ++uv;
                    if (callback == null) continue;
                    callback.onFinishARecord(tableName, record.getId().toString(), "I");
                    callback.onFinishARecord(tableName);
                }
                break;
            }
            catch (Exception e) {
                ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u79bb\u573a\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355\u5f02\u5e38! \u539f\u56e0: " + e.getMessage()));
                if (callback != null) {
                    callback.onSynException(tableName, e);
                }
                return;
            }
        }
        conf.setProperty(tableName, "1");
        this.storeSyncRecordTablesConf(conf);
        this.storeSyncCloudPicConfig(downloadPicConf);
        long cx = ServiceUtil.getServiceContext().currentTimeMillis() - cmills;
        String ust = cx < 1000L ? String.valueOf(cx) + "\u6beb\u79d2" : String.valueOf(cx / 1000L) + "\u79d2 " + cx % 1000L + "\u6beb\u79d2";
        ServiceLog.getLog().info((Object)("\u5df2\u5168\u90e8\u4e0b\u8f7d\u79bb\u573a\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355\u8bb0\u5f55! \u66f4\u65b0\u6761\u6570: " + uv + ",  \u7528\u65f6: " + ust));
        if (callback != null) {
            callback.onFinishATable(tableName);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkAndDownloadPresenceDiscounts(DbDataSyncService.SyncServerHost syncServerHost, DataSyncHandleCallback callback) {
        long cmills;
        int uv;
        Properties conf;
        String tableName;
        block21: {
            String carparkPresenceRecordTableName;
            String v;
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            tableName = daoService.getTableName(CarparkPassDiscount.class);
            if (callback != null) {
                callback.onCheckSyncTables(Arrays.asList(tableName));
            }
            if (!"1".equals(v = (conf = this.getSyncRecordTablesConf()).getProperty(carparkPresenceRecordTableName = daoService.getTableName(CarparkPresenceRecord.class), ""))) {
                if (callback != null) {
                    callback.onSynException(tableName, new Exception("\u5728\u573a\u8bb0\u5f55\u672a\u80fd\u6210\u529f\u540c\u6b65\uff01\u8bf7\u5148\u5b8c\u6210"));
                }
                return;
            }
            v = conf.getProperty(tableName, "");
            if ("1".equals(v)) {
                if (callback != null) {
                    callback.onSyncCheckResult(tableName, "allSynchronized");
                }
                return;
            }
            if (callback != null) {
                callback.onSyncCheckResult(tableName, "syncAllData");
            }
            if (syncServerHost == null) {
                syncServerHost = CloudCarparkDataSyncService.getDefaultSyncServerHost();
            }
            if (syncServerHost == null) {
                if (callback != null) {
                    callback.onSynException(tableName, new Exception("\u672a\u80fd\u8fde\u63a5\u5e73\u53f0"));
                }
                return;
            }
            TransferCrypto crypto = syncServerHost.getCrypto();
            String token = syncServerHost.getToken();
            String connectDomain = syncServerHost.getDomain();
            String signKey = syncServerHost.getSignKey();
            String cloud_conn_id = syncServerHost.getConnectId();
            String cloud_conn_name = syncServerHost.getConnectName();
            ServiceLog.getLog().info((Object)"\u53d1\u73b0\u9700\u8981\u540c\u6b65\u5728\u573a\u5df2\u6253\u6298\u8bb0\u5f55\uff0c\u8fd9\u5c06\u8fdb\u884c\u540c\u6b65....");
            long nexId = 0L;
            int fetchSize = 50;
            String cmd = "carparkHostSyncRemoteService.fetchAllRecords";
            JsonListType<CarparkPassDiscount> jsonListType = new JsonListType<CarparkPassDiscount>(CarparkPassDiscount.class);
            uv = 0;
            cmills = ServiceUtil.getServiceContext().currentTimeMillis();
            block2: while (true) {
                CloudDataProtocol p1 = new CloudDataProtocol();
                p1.setId(cloud_conn_id);
                p1.setName(cloud_conn_name);
                p1.setCmd("carparkHostSyncRemoteService.fetchAllRecords");
                p1.setMsgId("dataSyncCPD-" + ServiceUtil.getServiceContext().createLongSeq());
                p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                data.put("gtId", nexId);
                data.put("tableName", tableName);
                data.put("fetchSize", fetchSize);
                p1.setData(data);
                String sendString = p1.toSendString(signKey, crypto);
                StringBuilder urlBuilder = new StringBuilder(128);
                urlBuilder.append(this.getRequestProtocl()).append(connectDomain).append("/core/remote/gateway/rpc/transfer/invoke/").append(token);
                String requestUrl = urlBuilder.toString();
                Proxy proxy = WanNetHostSelector.getWanProxyHost(connectDomain).getProxy();
                String resltV = HttpUtil.doJsonRquest((String)requestUrl, null, (String)sendString, (Proxy)proxy);
                CloudDataProtocol resultP = CloudDataProtocol.parse(resltV, signKey, crypto, null);
                Map rmap = (Map)resultP.getData();
                if (!"0".equals(rmap.get("responseCode"))) {
                    ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u5728\u573a\u8f66\u8f86\u5df2\u6253\u6298\u8bb0\u5f55\u5931\u8d25! \u539f\u56e0:" + rmap));
                    if (callback != null) {
                        callback.onSynException(tableName, new Exception("\u4e0b\u8f7d\u5728\u573a\u8f66\u8f86\u5df2\u6253\u6298\u8bb0\u5f55\u5931\u8d25! \u539f\u56e0:" + rmap.get("responseMsg")));
                    }
                    return;
                }
                Object obj = rmap.get("fetchSize");
                if (obj == null) {
                    ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u5728\u573a\u8f66\u8f86\u5df2\u6253\u6298\u8bb0\u5f55\u5931\u8d25! \u539f\u56e0\u7f3a\u5c11\u6293\u53d6\u6570\u91cffetchSize:" + rmap));
                    if (callback != null) {
                        callback.onSynException(tableName, new Exception("\u4e0b\u8f7d\u5728\u573a\u8f66\u8f86\u5df2\u6253\u6298\u8bb0\u5f55\u5931\u8d25! \u539f\u56e0\u7f3a\u5c11\u6293\u53d6\u6570\u91cf"));
                    }
                    return;
                }
                int cSize = obj instanceof Number ? ((Number)obj).intValue() : Integer.parseInt(obj.toString());
                if (cSize == 0) break block21;
                String recordsJson = (String)rmap.get("recordsJson");
                if (recordsJson == null || recordsJson.length() == 0) {
                    ServiceLog.getLog().warn((Object)"\u4e0b\u8f7d\u5728\u573a\u8f66\u8f86\u5df2\u6253\u6298\u8bb0\u5f55\u5931\u8d25? \u539f\u56e0\u6293\u53d6\u6570\u91cf\u5927\u4e8e0,\u4f46\u662f recordsJson \u4e3a\u7a7a");
                    break block21;
                }
                List recordList = (List)GsonBuilder.create().fromJson(recordsJson, jsonListType);
                Iterator iterator = recordList.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (cSize >= fetchSize) continue block2;
                        break block21;
                    }
                    CarparkPassDiscount record = (CarparkPassDiscount)iterator.next();
                    nexId = record.getId();
                    daoService.synDataByPrimeryKey((Object)record);
                    ++uv;
                    if (callback == null) continue;
                    callback.onFinishARecord(tableName, record.getId().toString(), "I");
                    callback.onFinishARecord(tableName);
                }
                break;
            }
            catch (Exception e) {
                ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u5728\u573a\u8f66\u8f86\u5df2\u6253\u6298\u8bb0\u5f55\u5f02\u5e38! \u539f\u56e0: " + e.getMessage()));
                if (callback != null) {
                    callback.onSynException(tableName, e);
                }
                return;
            }
        }
        conf.setProperty(tableName, "1");
        this.storeSyncRecordTablesConf(conf);
        long cx = ServiceUtil.getServiceContext().currentTimeMillis() - cmills;
        String ust = cx < 1000L ? String.valueOf(cx) + "\u6beb\u79d2" : String.valueOf(cx / 1000L) + "\u79d2 " + cx % 1000L + "\u6beb\u79d2";
        ServiceLog.getLog().info((Object)("\u5df2\u5168\u90e8\u4e0b\u8f7d\u5e73\u53f0\u5728\u573a\u8f66\u8f86\u5df2\u6253\u6298\u8bb0\u5f55! \u66f4\u65b0\u6761\u6570: " + uv + ",  \u7528\u65f6: " + ust));
        if (callback != null) {
            callback.onFinishATable(tableName);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkAndDownloadPassRecords(DbDataSyncService.SyncServerHost syncServerHost, DataSyncHandleCallback callback) {
        long cmills;
        int uv;
        Properties conf;
        String tableName;
        block25: {
            String carparkPresenceRecordTableName;
            String v;
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            tableName = daoService.getTableName(CarparkPassRecord.class);
            conf = this.getSyncRecordTablesConf();
            if (callback != null) {
                callback.onCheckSyncTables(Arrays.asList(tableName));
            }
            if (!"1".equals(v = conf.getProperty(carparkPresenceRecordTableName = daoService.getTableName(CarparkPresenceRecord.class), ""))) {
                if (callback != null) {
                    callback.onSynException(tableName, new Exception("\u5728\u573a\u8bb0\u5f55\u672a\u80fd\u6210\u529f\u540c\u6b65\uff01\u8bf7\u5148\u5b8c\u6210"));
                }
                return;
            }
            v = conf.getProperty(tableName, "");
            if ("1".equals(v)) {
                if (callback != null) {
                    callback.onSyncCheckResult(tableName, "allSynchronized");
                }
                return;
            }
            if (callback != null) {
                callback.onSyncCheckResult(tableName, "syncAllData");
            }
            if (syncServerHost == null) {
                syncServerHost = CloudCarparkDataSyncService.getDefaultSyncServerHost();
            }
            if (syncServerHost == null) {
                if (callback != null) {
                    callback.onSynException(tableName, new Exception("\u672a\u80fd\u8fde\u63a5\u5e73\u53f0"));
                }
                return;
            }
            TransferCrypto crypto = syncServerHost.getCrypto();
            String token = syncServerHost.getToken();
            String connectDomain = syncServerHost.getDomain();
            String signKey = syncServerHost.getSignKey();
            String cloud_conn_id = syncServerHost.getConnectId();
            String cloud_conn_name = syncServerHost.getConnectName();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyyMMddHHmmss");
            Date endDate = null;
            try {
                if (v.length() > 0) {
                    endDate = df1.parse(v);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            if (endDate == null) {
                endDate = cl.getTime();
                conf.setProperty(tableName, df1.format(endDate));
                this.storeSyncRecordTablesConf(conf);
            }
            cl.setTime(endDate);
            cl.add(6, -5);
            Date beginDate = cl.getTime();
            ServiceLog.getLog().info((Object)"\u53d1\u73b0\u9700\u8981\u4e0b\u8f7d\u5df2\u79bb\u573a\u8f66\u8f86\u8bb0\u5f55...!");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String beginTime = df.format(beginDate);
            String endTime = df.format(endDate);
            String nexId = "";
            String fetchSize = "20";
            String cmd = "carparkHostSyncRemoteService.fetchPassRecords";
            JsonListType<CarparkPassRecord> jsonListType = new JsonListType<CarparkPassRecord>(CarparkPassRecord.class);
            uv = 0;
            cmills = ServiceUtil.getServiceContext().currentTimeMillis();
            block6: while (true) {
                CloudDataProtocol p1 = new CloudDataProtocol();
                p1.setId(cloud_conn_id);
                p1.setName(cloud_conn_name);
                p1.setCmd("carparkHostSyncRemoteService.fetchPassRecords");
                p1.setMsgId("dataSyncPrc-" + ServiceUtil.getServiceContext().createLongSeq());
                p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
                LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                data.put("nextId", nexId);
                data.put("fetchSize", fetchSize);
                data.put("beginTime", beginTime);
                data.put("endTime", endTime);
                data.put("rType", "1");
                data.put("pass_types", "0,5,1");
                p1.setData(data);
                String sendString = p1.toSendString(signKey, crypto);
                StringBuilder urlBuilder = new StringBuilder(128);
                urlBuilder.append(this.getRequestProtocl()).append(connectDomain).append("/core/remote/gateway/rpc/transfer/invoke/").append(token);
                String requestUrl = urlBuilder.toString();
                Proxy proxy = WanNetHostSelector.getWanProxyHost(connectDomain).getProxy();
                String resltV = HttpUtil.doJsonRquest((String)requestUrl, null, (String)sendString, (Proxy)proxy);
                CloudDataProtocol resultP = CloudDataProtocol.parse(resltV, signKey, crypto, null);
                Map rmap = (Map)resultP.getData();
                if (!"0".equals(rmap.get("responseCode"))) {
                    ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u5df2\u79bb\u573a\u8f66\u8f86\u8bb0\u5f55\u5931\u8d25! \u539f\u56e0:" + rmap));
                    if (callback != null) {
                        callback.onSynException(tableName, new Exception("\u4e0b\u8f7d\u5df2\u79bb\u573a\u8f66\u8f86\u8bb0\u5f55\u5931\u8d25! \u539f\u56e0:" + rmap.get("responseMsg")));
                    }
                    return;
                }
                String recordsJson = (String)rmap.get("recordsJson");
                if (recordsJson == null || recordsJson.length() == 0) break block25;
                nexId = (String)rmap.get("nextRecordId");
                List recordList = (List)GsonBuilder.create().fromJson(recordsJson, jsonListType);
                Iterator iterator = recordList.iterator();
                while (true) {
                    long recordId;
                    CarparkPassRecord record;
                    block26: {
                        if (!iterator.hasNext()) {
                            if (nexId != null && nexId.length() != 0) continue block6;
                            break block25;
                        }
                        record = (CarparkPassRecord)iterator.next();
                        recordId = 0L;
                        try {
                            if (record.getExit_record_no().startsWith("S") || record.getExit_record_no().startsWith("C")) {
                                recordId = Long.parseLong(record.getExit_record_no().substring(1));
                                break block26;
                            }
                            ServiceLog.getLog().warn((Object)("\u4e91\u7aef\u7684\u79bb\u573a\u8bb0\u5f55\u7f16\u53f7: " + record.getExit_record_no() + "\u9519\u8bef\uff0c\u8fd9\u5c06\u4e22\u5f03\u8fd9\u7b14\u6570\u636e"));
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)("\u4e91\u7aef\u7684\u79bb\u573a\u8bb0\u5f55\u7f16\u53f7: " + record.getExit_record_no() + "\u9519\u8bef,\u8fd9\u5c06\u4e22\u5f03\u8fd9\u7b14\u6570\u636e"));
                        }
                        continue;
                    }
                    record.setId(recordId);
                    daoService.synDataByPrimeryKey((Object)record);
                    ++uv;
                    if (callback == null) continue;
                    callback.onFinishARecord(tableName, String.valueOf(recordId), "I");
                    callback.onFinishARecord(tableName);
                }
                break;
            }
            catch (Exception e) {
                ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u5df2\u79bb\u573a\u8f66\u8f86\u8bb0\u5f55\u5f02\u5e38! \u539f\u56e0: " + e.getMessage()));
                if (callback != null) {
                    callback.onSynException(tableName, e);
                }
                return;
            }
        }
        conf.setProperty(tableName, "1");
        this.storeSyncRecordTablesConf(conf);
        long cx = ServiceUtil.getServiceContext().currentTimeMillis() - cmills;
        String ust = cx < 1000L ? String.valueOf(cx) + "\u6beb\u79d2" : String.valueOf(cx / 1000L) + "\u79d2 " + cx % 1000L + "\u6beb\u79d2";
        ServiceLog.getLog().info((Object)("\u5df2\u5168\u90e8\u4e0b\u8f7d\u5e73\u53f0\u4e34\u505c\u79bb\u573a\u8f66\u8f86\u8bb0\u5f55! \u66f4\u65b0\u6761\u6570: " + uv + ",  \u7528\u65f6: " + ust));
        if (callback != null) {
            callback.onFinishATable(tableName);
        }
    }

    private static void setDownloadPassRecordPic(Properties downloadPicConf, Object recordx) {
        try {
            String dbPicPath;
            String picName;
            if (downloadPicConf == null) {
                return;
            }
            if (recordx == null) {
                return;
            }
            String[] picNames = new String[]{"enter_car_pic", "enter_plate_pic", "enter_face_pic", "certificate_pic", "exit_car_pic", "exit_plate_pic", "exit_face_pic"};
            JavaBeanMap map = new JavaBeanMap(recordx);
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String hx = "oss://";
            String[] stringArray = picNames;
            int n = picNames.length;
            int n2 = 0;
            while (n2 < n) {
                block29: {
                    picName = stringArray[n2];
                    dbPicPath = (String)map.get((Object)picName);
                    if (dbPicPath != null && dbPicPath.length() > 0) {
                        if (dbPicPath.startsWith(hx)) {
                            dbPicPath = dbPicPath.substring(hx.length());
                            boolean success = false;
                            int i = 0;
                            while (i < 10) {
                                int x = dbPicPath.indexOf(47);
                                if (x < 0) break;
                                if (x == 0) {
                                    dbPicPath = dbPicPath.substring(1);
                                } else {
                                    String dateStr = dbPicPath.substring(0, x);
                                    if (dateStr.length() == 8) {
                                        try {
                                            Date d = df.parse(dateStr);
                                            if (d != null) {
                                                success = true;
                                                break;
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    dbPicPath = dbPicPath.substring(x + 1);
                                }
                                ++i;
                            }
                            if (!success) {
                                map.put(picName, null);
                                ServiceLog.getLog().warn((Object)("\u56fe\u7247" + picName + ", \u8def\u5f84\u9519\u8bef: " + map.get((Object)picName)));
                            } else {
                                map.put(picName, (Object)dbPicPath);
                            }
                        } else {
                            int x;
                            if (dbPicPath.startsWith("/")) {
                                dbPicPath = dbPicPath.substring(1);
                            }
                            if ((x = dbPicPath.indexOf(47)) == -1) {
                                map.put(picName, null);
                                ServiceLog.getLog().warn((Object)("\u56fe\u7247" + picName + ", \u8def\u5f84\u9519\u8bef: " + map.get((Object)picName)));
                            } else {
                                String dateStr = dbPicPath.substring(0, x);
                                if (dateStr.length() != 8) {
                                    map.put(picName, null);
                                    ServiceLog.getLog().warn((Object)("\u56fe\u7247" + picName + ", \u8def\u5f84\u9519\u8bef: " + map.get((Object)picName)));
                                } else {
                                    try {
                                        df.parse(dateStr);
                                    }
                                    catch (Exception ex) {
                                        map.put(picName, null);
                                        ServiceLog.getLog().warn((Object)("\u56fe\u7247" + picName + ", \u8def\u5f84\u9519\u8bef: " + map.get((Object)picName)));
                                        break block29;
                                    }
                                    map.put(picName, (Object)dbPicPath);
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
            stringArray = picNames;
            n = picNames.length;
            n2 = 0;
            while (n2 < n) {
                picName = stringArray[n2];
                dbPicPath = (String)map.get((Object)picName);
                if (dbPicPath != null && dbPicPath.length() > 0) {
                    try {
                        File file = new File(PathFinder.findLocalPicDir(), dbPicPath);
                        if (!file.exists() || !file.isFile()) {
                            downloadPicConf.setProperty(BytesTool.compressBytes((byte[])picName.getBytes("UTF-8")), Constants.NO_STR);
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u4ece\u4e91\u7aef\u4e0b\u8f7d\u56fe\u7247:" + dbPicPath + " \u5f02\u5e38\uff01\u539f\u56e0\uff1a" + ex.getMessage()));
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u5ef6\u8fdf\u4e0b\u8f7d\u4e91\u7aef\u56fe\u7247\u5f02\u5e38! " + ex.getMessage()));
        }
    }

    public static void downloadPassRecordPic(DbDataSyncService.SyncServerHost syncServerHost, CarparkPassRecord record) {
        if (record == null) {
            return;
        }
        try {
            String dbPicPath;
            String picName;
            String[] picNames = new String[]{"enter_car_pic", "enter_plate_pic", "enter_face_pic", "certificate_pic", "exit_car_pic", "exit_plate_pic", "exit_face_pic"};
            JavaBeanMap map = new JavaBeanMap((Object)record);
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String hx = "oss://";
            String[] stringArray = picNames;
            int n = picNames.length;
            int n2 = 0;
            while (n2 < n) {
                block33: {
                    picName = stringArray[n2];
                    dbPicPath = (String)map.get((Object)picName);
                    if (dbPicPath != null && dbPicPath.length() > 0) {
                        if (dbPicPath.startsWith(hx)) {
                            dbPicPath = dbPicPath.substring(hx.length());
                            boolean success = false;
                            int i = 0;
                            while (i < 10) {
                                int x = dbPicPath.indexOf(47);
                                if (x < 0) break;
                                if (x == 0) {
                                    dbPicPath = dbPicPath.substring(1);
                                } else {
                                    String dateStr = dbPicPath.substring(0, x);
                                    if (dateStr.length() == 8) {
                                        try {
                                            Date d = df.parse(dateStr);
                                            if (d != null) {
                                                success = true;
                                                break;
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    dbPicPath = dbPicPath.substring(x + 1);
                                }
                                ++i;
                            }
                            if (!success) {
                                map.put(picName, null);
                                ServiceLog.getLog().warn((Object)("\u56fe\u7247" + picName + ", \u8def\u5f84\u9519\u8bef: " + map.get((Object)picName)));
                            } else {
                                map.put(picName, (Object)dbPicPath);
                            }
                        } else {
                            int x;
                            if (dbPicPath.startsWith("/")) {
                                dbPicPath = dbPicPath.substring(1);
                            }
                            if ((x = dbPicPath.indexOf(47)) == -1) {
                                map.put(picName, null);
                                ServiceLog.getLog().warn((Object)("\u56fe\u7247" + picName + ", \u8def\u5f84\u9519\u8bef: " + map.get((Object)picName)));
                            } else {
                                String dateStr = dbPicPath.substring(0, x);
                                if (dateStr.length() != 8) {
                                    map.put(picName, null);
                                    ServiceLog.getLog().warn((Object)("\u56fe\u7247" + picName + ", \u8def\u5f84\u9519\u8bef: " + map.get((Object)picName)));
                                } else {
                                    try {
                                        df.parse(dateStr);
                                    }
                                    catch (Exception ex) {
                                        map.put(picName, null);
                                        ServiceLog.getLog().warn((Object)("\u56fe\u7247" + picName + ", \u8def\u5f84\u9519\u8bef: " + map.get((Object)picName)));
                                        break block33;
                                    }
                                    map.put(picName, (Object)dbPicPath);
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
            if (syncServerHost == null) {
                syncServerHost = CloudCarparkDataSyncService.getDefaultSyncServerHost();
            }
            if (syncServerHost == null) {
                return;
            }
            stringArray = picNames;
            n = picNames.length;
            n2 = 0;
            while (n2 < n) {
                block34: {
                    picName = stringArray[n2];
                    dbPicPath = (String)map.get((Object)picName);
                    if (dbPicPath != null && dbPicPath.length() > 0) {
                        try {
                            byte[] data;
                            File file = new File(PathFinder.findLocalPicDir(), dbPicPath);
                            if (file.exists() && file.isFile() || (data = CloudCarparkDataSyncService.getRemotePic(dbPicPath, syncServerHost)) == null || data.length <= 0) break block34;
                            ByteArrayInputStream oui = new ByteArrayInputStream(data);
                            ImageIO.read(oui);
                            if (!file.getParentFile().exists()) {
                                file.getParentFile().mkdirs();
                            }
                            try (FileOutputStream fout = new FileOutputStream(file);){
                                fout.write(data);
                            }
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)("\u4ece\u4e91\u7aef\u4e0b\u8f7d\u56fe\u7247:" + dbPicPath + " \u5f02\u5e38\uff01\u539f\u56e0\uff1a" + ex.getMessage()));
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void pullAndHandleMsessage(DbDataSyncService.SyncServerHost syncServerHost) {
        block21: {
            if (syncServerHost == null) {
                syncServerHost = CloudCarparkDataSyncService.getDefaultSyncServerHost();
            }
            if (syncServerHost == null) {
                return;
            }
            TransferCrypto crypto = syncServerHost.getCrypto();
            String token = syncServerHost.getToken();
            String connectDomain = syncServerHost.getDomain();
            String signKey = syncServerHost.getSignKey();
            String cloud_conn_id = syncServerHost.getConnectId();
            String cloud_conn_name = syncServerHost.getConnectName();
            LinkedList<Long> deleteMessageId = new LinkedList<Long>();
            CarparkHostMsgRequest request = new CarparkHostMsgRequest();
            long nexId = 0L;
            int fetchSize = 20;
            String cmd = "carparkHostSyncRemoteService.fetchMessage";
            block8: while (true) {
                CloudDataProtocol resultP;
                CloudDataProtocol p1 = new CloudDataProtocol();
                p1.setId(cloud_conn_id);
                p1.setName(cloud_conn_name);
                p1.setCmd("carparkHostSyncRemoteService.fetchMessage");
                p1.setMsgId("dataSyncMsg-" + ServiceUtil.getServiceContext().createLongSeq());
                p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
                request.setDelMsgIds(deleteMessageId);
                request.setFetchSize(fetchSize);
                request.setGtId(nexId);
                p1.setData(request);
                String sendString = p1.toSendString(signKey, crypto);
                StringBuilder urlBuilder = new StringBuilder(128);
                urlBuilder.append(this.getRequestProtocl()).append(connectDomain).append("/core/remote/gateway/rpc/transfer/invoke/").append(token);
                String requestUrl = urlBuilder.toString();
                Proxy proxy = WanNetHostSelector.getWanProxyHost(connectDomain).getProxy();
                String resltV = HttpUtil.doJsonRquest((String)requestUrl, null, (String)sendString, (Proxy)proxy);
                deleteMessageId.clear();
                CloudReceiveClassManager classManager = ServiceUtil.getServiceContext().getCloudContext().getCloudReceiveClassManager();
                if (classManager.getDataClass("carparkHostSyncRemoteService.fetchMessage" + ServiceUtil.getServiceContext().getCloudContext().getResponseEndFlag()) == null) {
                    classManager.addDataClass("carparkHostSyncRemoteService.fetchMessage" + ServiceUtil.getServiceContext().getCloudContext().getResponseEndFlag(), CarparkHostMsgResponse.class);
                }
                try {
                    resultP = CloudDataProtocol.parse(resltV, signKey, crypto, classManager);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u89e3\u6790\u4e91\u7aef\u8fd4\u56de\u7684\u6d88\u606f\u5217\u8868\u5931\u8d25:" + ex.getMessage()));
                    return;
                }
                CarparkHostMsgResponse response = (CarparkHostMsgResponse)((Object)resultP.getData());
                if (!response.isSuccess()) {
                    ServiceLog.getLog().warn((Object)("\u83b7\u53d6\u4e91\u7aef\u6d88\u606f\u5931\u8d25! \u539f\u56e0:" + response.getResponseMsg()));
                    return;
                }
                if (response.getMessages() == null || response.getMessages().isEmpty()) break block21;
                Iterator<CarparkHostMsgResponse.Message> iterator = response.getMessages().iterator();
                while (true) {
                    Object obj;
                    CloudServiceAction action;
                    CarparkHostMsgResponse.Message message;
                    block22: {
                        if (!iterator.hasNext()) continue block8;
                        message = iterator.next();
                        nexId = message.getId();
                        action = ServiceUtil.getServiceContext().getCloudContext().getCloudServiceActionManager().getServiceAction(message.getHead());
                        if (action == null) {
                            deleteMessageId.add(message.getId());
                            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f! \u6d88\u606fid:" + message.getId() + ", cmd:" + message.getHead() + " \u539f\u56e0:\u672a\u6ce8\u518c\u6b64\u63a5\u53e3\u65b9\u6cd5, \u8fd9\u5c06\u4e22\u5f03\u6b64\u6d88\u606f"));
                            continue;
                        }
                        obj = null;
                        try {
                            if (message.getBody() == null || message.getBody().length() <= 0) break block22;
                            Class<Object> cl = classManager.getDataClass(message.getHead());
                            if (cl == null) {
                                cl = LinkedHashMap.class;
                            }
                            obj = GsonBuilder.create().fromJson(message.getBody(), cl);
                        }
                        catch (Exception ex) {
                            deleteMessageId.add(message.getId());
                            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f! \u6d88\u606fid:" + message.getId() + ", cmd:" + message.getHead() + ",\u8fd9\u5c06\u4e22\u5f03\u8fd9\u6761\u6d88\u606f! \u539f\u56e0:\u6d88\u606f\u4f53\u4e0d\u662fjson\uff01\u65e0\u6cd5\u5904\u7406: " + message.getBody()));
                            continue;
                        }
                    }
                    CloudDataProtocol protocol = new CloudDataProtocol();
                    protocol.setId(cloud_conn_id);
                    protocol.setName(cloud_conn_name);
                    protocol.setCmd(message.getHead());
                    protocol.setMsgId(message.getId().toString());
                    protocol.setNonce(protocol.getMsgId());
                    protocol.setData(obj);
                    try {
                        final Object[] resultObj = new Object[1];
                        IOResponse ioResponse = new IOResponse(){

                            public void doResponse(String cmd, Object data) throws IOException {
                                resultObj[0] = data;
                            }
                        };
                        action.execute(protocol, ioResponse);
                        if (resultObj[0] == null) {
                            deleteMessageId.add(message.getId());
                            ServiceLog.getLog().warn((Object)("\u5904\u7406\u6d88\u606fid:" + message.getId() + ", cmd:" + message.getHead() + ", \u672a\u8fd4\u56de\u7ed3\u679c\uff01\u53ef\u80fd\u662f\u5f02\u6b65\u5904\u7406\uff01\u8fd9\u5c06\u5f53\u6210\u529f\u5904\u7406\uff01\u4e0d\u5e94\u8be5\u7684\u60c5\u51b5"));
                            continue;
                        }
                        if (resultObj[0] instanceof Map && !(resultObj[0] instanceof MessageResult)) {
                            CloudResultResponse rsp = new CloudResultResponse();
                            rsp.putAll((Map)resultObj[0]);
                            resultObj[0] = rsp;
                        }
                        if (!(resultObj[0] instanceof MessageResult)) {
                            deleteMessageId.add(message.getId());
                            ServiceLog.getLog().warn((Object)("\u5904\u7406\u6d88\u606fid:" + message.getId() + ", cmd:" + message.getHead() + ", \u8fd4\u56de\u4e0d\u662fMessageResult \u6216Map\u5b9e\u4f8b\uff01\u8fd9\u5c06\u5f53\u6210\u529f\u5904\u7406\uff01\u4e0d\u5e94\u8be5\u7684\u60c5\u51b5"));
                            continue;
                        }
                        MessageResult resultResponse = (MessageResult)resultObj[0];
                        if (!resultResponse.isSuccess()) {
                            if ("403".equals(resultResponse.getResponseCode())) {
                                deleteMessageId.add(message.getId());
                                ServiceLog.getLog().warn((Object)("\u5904\u7406\u6d88\u606fid:" + message.getId() + ", cmd:" + message.getHead() + ", \u8fd4\u56de\u7f3a\u5c11\u53c2\u6570\u9519\u8bef\uff01" + resultResponse.getResponseMsg() + " \u8fd9\u5c06\u4e22\u5f03\u6b64\u6d88\u606f\uff01\u6d88\u606f\u4f53: " + message.getBody()));
                                continue;
                            }
                            ServiceLog.getLog().warn((Object)("\u5904\u7406\u6d88\u606fid:" + message.getId() + ", cmd:" + message.getHead() + "\u5931\u8d25, \u8fd4\u56de\u9519\u8bef\uff01" + resultResponse.getResponseMsg() + ", \u8bf7\u68c0\u67e5\u5904\u7406"));
                            continue;
                        }
                        deleteMessageId.add(message.getId());
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u5904\u7406\u6d88\u606f\u5f02\u5e38! \u6d88\u606fid:" + message.getId() + ", cmd:" + message.getHead() + ", \u8bf7\u68c0\u67e5!"), (Throwable)ex);
                    }
                }
                break;
            }
            catch (Exception e) {
                ServiceLog.getLog().warn((Object)("\u4e0b\u8f7d\u8bb0\u5f55\u5728\u573a\u8f66\u8f86\u5df2\u7f34\u8d39\u8bb0\u5f55\u5f02\u5e38! \u539f\u56e0: " + e.getMessage()));
                return;
            }
        }
    }

    protected void doRun() throws Exception {
        this.doSyncAndCheckDownloadData(null, null);
        this.pullAndHandleMsessage(null);
    }

    @Override
    public void trySyncDataAndMessage() {
        this.run();
    }

    protected void checkDownloadPic() {
        if (this.synConfigPic.get()) {
            return;
        }
        Properties conf = this.getSyncCloudPicConfig();
        if (conf != null && !conf.isEmpty() && this.synConfigPic.compareAndSet(false, true)) {
            try {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CloudCarparkDataSyncService.this.doDownloadConfigPic(CloudCarparkDataSyncService.this.getSyncCloudPicConfig());
                        }
                        finally {
                            CloudCarparkDataSyncService.this.synConfigPic.set(false);
                        }
                    }
                });
            }
            catch (Exception ex) {
                this.synConfigPic.set(false);
            }
        }
    }

    private void doDownloadConfigPic(Properties conf) {
        if (conf == null || conf.isEmpty()) {
            return;
        }
        DbDataSyncService.SyncServerHost host = CloudCarparkDataSyncService.getDefaultSyncServerHost();
        if (host == null) {
            return;
        }
        ArrayList<String> picKeys = new ArrayList<String>(conf.size());
        for (Object key : conf.keySet()) {
            picKeys.add(key.toString());
        }
        for (String picX : picKeys) {
            String dbPicPath = null;
            try {
                String v = conf.getProperty(picX);
                if (v != null && Constants.NO_STR.equals(v)) {
                    dbPicPath = new String(BytesTool.unCompress((String)picX), "UTF-8");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dbPicPath == null || dbPicPath.length() == 0) {
                conf.remove(picX);
            }
            try {
                File file = new File(PathFinder.findLocalPicDir(), dbPicPath);
                if (file.exists() && file.isFile()) {
                    conf.remove(picX);
                    continue;
                }
                host = CloudCarparkDataSyncService.getDefaultSyncServerHost();
                if (host == null) {
                    this.storeSyncCloudPicConfig(conf);
                    return;
                }
                byte[] data = CloudCarparkDataSyncService.getRemotePic(dbPicPath, host);
                if (data != null && data.length > 0) {
                    ByteArrayInputStream oui = new ByteArrayInputStream(data);
                    ImageIO.read(oui);
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    try (FileOutputStream fout = new FileOutputStream(file);){
                        fout.write(data);
                    }
                }
                conf.remove(picX);
            }
            catch (Exception ex) {
                conf.remove(picX);
                ServiceLog.getLog().warn((Object)("\u4ece\u4e91\u7aef\u4e0b\u8f7d\u56fe\u7247:" + dbPicPath + " \u5f02\u5e38\uff01\u539f\u56e0\uff1a" + ex.getMessage()));
            }
        }
        this.storeSyncCloudPicConfig(conf);
    }

    private static final class Task {
        private SyncTable table;
        private String url;
        private DataSyncHandleCallback callback;
        private int connectTimeoutMills;
        private String synlogTableName;
        private CommonDaoService commonDaoService;
        private String cloud_conn_id;
        private String cloud_conn_name;
        private String signKey;
        private TransferCrypto crypto;
        private Integer carpark_id;
        private Integer project_id;
        private Object[] emptyParam = new Object[0];

        public Task(String url, int connectTimeoutMills, SyncTable table, DataSyncHandleCallback callback, String synlogTableName, CommonDaoService commonDaoService, String cloud_conn_id, String cloud_conn_name, String signKey, TransferCrypto crypto, Integer carpark_id, Integer project_id) {
            this.table = table;
            this.url = url;
            this.callback = callback;
            this.connectTimeoutMills = connectTimeoutMills;
            this.synlogTableName = synlogTableName;
            this.commonDaoService = commonDaoService;
            this.cloud_conn_id = cloud_conn_id;
            this.cloud_conn_name = cloud_conn_name;
            this.signKey = signKey;
            this.crypto = crypto;
            this.carpark_id = carpark_id;
            this.project_id = project_id;
        }

        private void syncAllData() throws Exception {
            CloudDataProtocol p1 = new CloudDataProtocol();
            p1.setId(this.cloud_conn_id);
            p1.setName(this.cloud_conn_name);
            String cmd = "carparkSyncDbDataService.syncAllData";
            p1.setCmd("carparkSyncDbDataService.syncAllData");
            p1.setMsgId("dataSyncClient-" + ServiceUtil.getServiceContext().createLongSeq());
            p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            data.put("tableName", this.table.getTableName());
            p1.setData(data);
            String sendString = p1.toSendString(this.signKey, this.crypto);
            Proxy proxy = WanNetHostSelector.getWanProxyHost(this.url).getProxy();
            HttpUtil.doRequest((String)this.url, null, null, null, (String)sendString, (HttpResponseCallback)new HttpResponseLineStringCallback<String>(){
                private String BEGIN = "aa";
                private String END = "bb";
                private String DATA = "cc";
                private String ERROR = "dd";
                private String SYNC = "ee";
                private Gson gson = GsonBuilder.create();

                public String onComplete() {
                    return "finish";
                }

                public void onException(Throwable ex) {
                }

                public boolean callback(String line) {
                    if (line != null && (line = line.trim()).length() > 0) {
                        KeyValueEntry<String, Object> ke = CloudCarparkDataSyncService.parseLine(crypto, signKey, "carparkSyncDbDataService.syncAllData", line);
                        if (((String)ke.getKey()).length() != 2) {
                            if (callback != null) {
                                callback.onSynException(table.getTableName(), new Exception("\u64cd\u4f5c\u5f02\u5e38! \u539f\u56e0:" + ke.getValue()));
                            }
                            return false;
                        }
                        String head = (String)ke.getKey();
                        line = (String)ke.getValue();
                        if (this.BEGIN.equals(head)) {
                            commonDaoService.delete(new SearchParam(table.getTableName()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
                        } else if (this.END.equals(head)) {
                            CarparkSyncTableLogVo slog = (CarparkSyncTableLogVo)((Object)this.gson.fromJson(line, CarparkSyncTableLogVo.class));
                            CommonParam param = new CommonParam(synlogTableName);
                            param.addUpdate("latest_sync_log_id", (Object)slog.getLatest_sync_log_id());
                            param.addUpdate("latest_sync_log_time", (Object)slog.getLatest_sync_log_time());
                            param.addEQ("table_name", (Object)table.getTableName());
                            param.addEQ("carpark_id", (Object)carpark_id);
                            param.addEQ("project_id", (Object)project_id);
                            commonDaoService.update(param);
                        } else if (this.DATA.equals(head)) {
                            String recordId;
                            Object obj = this.gson.fromJson(line, table.getPoClass());
                            try {
                                recordId = ((JavaBeanUtil.GetSetMethod)JavaBeanUtil.getGetSetMethods((Class)table.getPoClass()).get("id")).getGetMethod().invoke(obj, emptyParam).toString();
                            }
                            catch (Exception ex) {
                                recordId = "";
                            }
                            try {
                                int count = commonDaoService.insert(obj, table.getTableName());
                                if (count <= 0) {
                                    throw new RuntimeException("\u63d2\u5165\u6570\u636e\u8fd4\u56de0\u6761\u54cd\u5e94\uff01\u63d2\u5165\u5931\u8d25");
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u63d2\u5165\u6570\u636e\uff01" + ex.getMessage()));
                                try {
                                    Object id = ((JavaBeanUtil.GetSetMethod)JavaBeanUtil.getGetSetMethods((Class)table.getPoClass()).get("id")).getGetMethod().invoke(obj, emptyParam);
                                    commonDaoService.delete(new SearchParam(table.getTableName()).addEQ("id", id));
                                    int count = commonDaoService.insert(obj, table.getTableName());
                                    if (count <= 0) {
                                        throw new RuntimeException("\u63d2\u5165\u6570\u636e\u8fd4\u56de0\u6761\u54cd\u5e94\uff01\u63d2\u5165\u5931\u8d25");
                                    }
                                }
                                catch (Exception ex1) {
                                    ServiceLog.getLog().warn((Object)("\u5c1d\u8bd5\u5220\u9664\u518d\u63d2\u5165\u64cd\u4f5c\u9519\u8bef \u8868\uff1a" + table.getTableName()), (Throwable)ex1);
                                    if (ex instanceof RuntimeException) {
                                        throw (RuntimeException)ex;
                                    }
                                    throw new RuntimeException(ex.getMessage(), ex);
                                }
                            }
                            if (callback != null) {
                                callback.onFinishARecord(table.getTableName(), recordId, "I");
                            }
                        } else if (this.SYNC.equals(head)) {
                            this.syncData(line, this.gson);
                        } else {
                            if (this.ERROR.equals(head)) {
                                ServiceLog.getLog().warn((Object)("\u540c\u6b65\u8868\uff1a" + table.getTableName() + " \u51fa\u73b0\u8fdc\u7a0b\u5f02\u5e38! \u539f\u56e0:" + line));
                                if (callback != null) {
                                    callback.onSynException(table.getTableName(), new Exception("\u8fdc\u7a0b\u5f02\u5e38! \u539f\u56e0:" + line));
                                }
                                return false;
                            }
                            ServiceLog.getLog().warn((Object)("syncAllData\u8fdc\u7a0b\u5f02\u5e38! \u8fd4\u56de\u672a\u77e5\u7684\u64cd\u4f5c\u6807\u8bc6:" + head + ", data:" + ke.getValue()));
                            if (callback != null) {
                                callback.onSynException(table.getTableName(), new Exception("\u8fdc\u7a0b\u5f02\u5e38! \u8fd4\u56de\u672a\u77e5\u7684\u64cd\u4f5c\u6807\u8bc6: " + head));
                            }
                            return false;
                        }
                    }
                    return true;
                }

                public boolean onHeaders(HttpResponse response) {
                    return true;
                }
            }, (int)this.connectTimeoutMills, (int)60000, (Proxy)proxy);
        }

        private void syncLogData() throws Exception {
            CloudDataProtocol p1 = new CloudDataProtocol();
            p1.setId(this.cloud_conn_id);
            p1.setName(this.cloud_conn_name);
            String cmd = "carparkSyncDbDataService.syncLogData";
            p1.setCmd("carparkSyncDbDataService.syncLogData");
            p1.setMsgId("dataSyncClient-" + ServiceUtil.getServiceContext().createLongSeq());
            p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            data.put("tableName", this.table.getTableName());
            data.put("latest_sync_log_id", String.valueOf(this.table.getLatest_sync_log_id()));
            p1.setData(data);
            String sendString = p1.toSendString(this.signKey, this.crypto);
            Proxy proxy = WanNetHostSelector.getWanProxyHost(this.url).getProxy();
            String returnV = (String)HttpUtil.doRequest((String)this.url, null, null, null, (String)sendString, (HttpResponseCallback)new HttpResponseLineStringCallback<String>(){
                private String SYNC = "ee";
                private String ERROR = "dd";
                private String SYNCALL = "ff";
                private Gson gson = GsonBuilder.create();
                private String returnValue = "finish";

                public String onComplete() {
                    return this.returnValue;
                }

                public void onException(Throwable ex) {
                }

                public boolean callback(String line) {
                    if (line != null && (line = line.trim()).length() > 0) {
                        KeyValueEntry<String, Object> ke = CloudCarparkDataSyncService.parseLine(crypto, signKey, "carparkSyncDbDataService.syncLogData", line);
                        if (((String)ke.getKey()).length() != 2) {
                            if (callback != null) {
                                callback.onSynException(table.getTableName(), new Exception("\u64cd\u4f5c\u5f02\u5e38! \u539f\u56e0:" + ke.getValue()));
                            }
                            return false;
                        }
                        String head = (String)ke.getKey();
                        line = (String)ke.getValue();
                        if (this.SYNCALL.equals(head)) {
                            this.returnValue = "syncAllData";
                        } else if (this.SYNC.equals(head)) {
                            this.syncData(line, this.gson);
                        } else {
                            if (this.ERROR.equals(head)) {
                                ServiceLog.getLog().warn((Object)("\u8fdc\u7a0b\u5f02\u5e38! \u539f\u56e0:" + line));
                                if (callback != null) {
                                    callback.onSynException(table.getTableName(), new Exception("\u8fdc\u7a0b\u5f02\u5e38! \u539f\u56e0\uff1a" + line));
                                }
                                return false;
                            }
                            ServiceLog.getLog().warn((Object)("syncLogData\u8fdc\u7a0b\u5f02\u5e38! \u8fd4\u56de\u672a\u77e5\u7684\u64cd\u4f5c\u6807\u8bc6:" + head + ", data:" + ke.getValue()));
                            if (callback != null) {
                                callback.onSynException(table.getTableName(), new Exception("\u8fdc\u7a0b\u5f02\u5e38! \u8fd4\u56de\u672a\u77e5\u7684\u64cd\u4f5c\u6807\u8bc6: " + head));
                            }
                            return false;
                        }
                    }
                    return true;
                }

                public boolean onHeaders(HttpResponse response) {
                    return true;
                }
            }, (int)this.connectTimeoutMills, (int)60000, (Proxy)proxy);
            if ("syncAllData".equals(returnV)) {
                this.syncAllData();
            }
        }

        private void syncData(String line, Gson gson) {
            String recordId;
            CarparkSyncTableLogVo slog = (CarparkSyncTableLogVo)((Object)gson.fromJson(line, CarparkSyncTableLogVo.class));
            if ("D".equals(slog.getOp_type())) {
                Map objMap = (Map)gson.fromJson(slog.getRecordJson(), HashMap.class);
                Object idValue0 = objMap.get("pk_value");
                Long idValue = idValue0 instanceof Number ? Long.valueOf(((Number)idValue0).longValue()) : Long.valueOf(idValue0.toString());
                recordId = idValue.toString();
                SearchParam delParam = new SearchParam(this.table.getTableName()).addEQ("id", (Object)idValue);
                this.commonDaoService.delete(delParam);
            } else {
                Object obj = gson.fromJson(slog.getRecordJson(), this.table.getPoClass());
                try {
                    recordId = ((JavaBeanUtil.GetSetMethod)JavaBeanUtil.getGetSetMethods((Class)this.table.getPoClass()).get("id")).getGetMethod().invoke(obj, this.emptyParam).toString();
                }
                catch (Exception ex) {
                    recordId = "";
                }
                this.commonDaoService.synDataByPrimeryKey(obj);
            }
            CommonParam param = new CommonParam(this.synlogTableName);
            param.addUpdate("latest_sync_log_id", (Object)slog.getLatest_sync_log_id());
            param.addUpdate("latest_sync_log_time", (Object)slog.getLatest_sync_log_time());
            param.addEQ("table_name", (Object)this.table.getTableName());
            param.addEQ("carpark_id", (Object)this.carpark_id);
            param.addEQ("project_id", (Object)this.project_id);
            this.commonDaoService.update(param);
            if (this.callback != null) {
                this.callback.onFinishARecord(this.table.getTableName(), recordId, slog.getOp_type());
            }
        }
    }
}

