/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.client;

import com.wovoe.carpark.cloud.client.DataSyncHandleCallback;
import com.wovoe.framework.transfer.TransferCrypto;
import java.util.Collection;

public interface DbDataSyncService {
    public Collection<String> getAllNeedSyncTables();

    public void doSyncAndCheckDownloadData(SyncServerHost var1, DataSyncHandleCallback var2);

    public void doSyncRemoteData(SyncServerHost var1, DataSyncHandleCallback var2);

    public void checkAndDownloadCarparkPresenceRecord(SyncServerHost var1, DataSyncHandleCallback var2);

    public void checkAndDownloadCarparkPassSelfPay(SyncServerHost var1, DataSyncHandleCallback var2);

    public void checkAndDownloadPresenceDiscounts(SyncServerHost var1, DataSyncHandleCallback var2);

    public void checkAndDownloadPassRecords(SyncServerHost var1, DataSyncHandleCallback var2);

    public void pullAndHandleMsessage(SyncServerHost var1);

    public void trySyncDataAndMessage();

    public static class CloudSyncServerHost
    implements SyncServerHost {
        private String token;
        private TransferCrypto crypto;
        private String signKey;
        private String connectName;
        private String connectId;
        private String domain;
        private Integer carparkId;
        private Integer projectId;
        private String picDomain;

        public CloudSyncServerHost() {
        }

        public CloudSyncServerHost(String token, TransferCrypto crypto, String signKey, String connectName, String connectId, String domain, Integer carparkId, Integer projectId, String picDomain) {
            this();
            this.token = token;
            this.crypto = crypto;
            this.signKey = signKey;
            this.connectName = connectName;
            this.connectId = connectId;
            this.domain = domain;
            this.carparkId = carparkId;
            this.projectId = projectId;
            this.picDomain = picDomain;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setCrypto(TransferCrypto crypto) {
            this.crypto = crypto;
        }

        public void setSignKey(String signKey) {
            this.signKey = signKey;
        }

        public void setConnectName(String connectName) {
            this.connectName = connectName;
        }

        public void setConnectId(String connectId) {
            this.connectId = connectId;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public String getToken() {
            return this.token;
        }

        @Override
        public TransferCrypto getCrypto() {
            return this.crypto;
        }

        @Override
        public String getSignKey() {
            return this.signKey;
        }

        @Override
        public String getConnectName() {
            return this.connectName;
        }

        @Override
        public String getConnectId() {
            return this.connectId;
        }

        @Override
        public String getDomain() {
            return this.domain;
        }

        @Override
        public Integer getCarparkId() {
            return this.carparkId;
        }

        @Override
        public Integer getProjectId() {
            return this.projectId;
        }

        @Override
        public String getPicDomain() {
            if (this.picDomain == null || this.picDomain.length() == 0) {
                return this.getDomain();
            }
            return this.picDomain;
        }
    }

    public static interface SyncServerHost {
        public String getToken();

        public TransferCrypto getCrypto();

        public String getSignKey();

        public String getConnectName();

        public String getConnectId();

        public String getDomain();

        public Integer getCarparkId();

        public Integer getProjectId();

        public String getPicDomain();
    }
}

