/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.client;

import com.wovoe.carpark.cloud.client.HostSate;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.internel.ServiceUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OtherHostSateManager {
    private ConcurrentHashMap<String, HostSate> hostSateMap = new ConcurrentHashMap();

    public void check(Map<String, CarparkHost> hostMap) {
        if (hostMap == null || hostMap.isEmpty()) {
            this.hostSateMap.clear();
        } else {
            Iterator<Map.Entry<String, HostSate>> it = this.hostSateMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, HostSate> en = it.next();
                if (hostMap.containsKey(en.getKey())) continue;
                it.remove();
            }
        }
    }

    public void updateCloudInfo(String hostNo, String version, Map<String, String> cloudConnectedEqSatesMap, Map<String, Set<InetAddress>> cloudLocalIpv4Map) {
        if (hostNo == null || hostNo.length() == 0) {
            return;
        }
        HostSate state = this.hostSateMap.get(hostNo);
        if (state == null) {
            HostSate newSate = new HostSate();
            newSate.setHostNo(hostNo);
            HostSate oldState = this.hostSateMap.putIfAbsent(hostNo, newSate);
            state = oldState != null ? oldState : newSate;
        }
        state.setCversion(version);
        state.setCconnectedEqSatesMap(cloudConnectedEqSatesMap);
        state.setChostLocalIps(cloudLocalIpv4Map);
        state.setLastCloudMills(ServiceUtil.getServiceContext().currentTimeMillis());
    }

    public void updateLanBroadcastNetAddress(String hostNo, InetAddress lanBroadcastNetAddress, int lanConnPort) {
        if (hostNo == null || hostNo.length() == 0) {
            return;
        }
        HostSate state = this.hostSateMap.get(hostNo);
        if (state == null) {
            HostSate newSate = new HostSate();
            newSate.setHostNo(hostNo);
            HostSate oldState = this.hostSateMap.putIfAbsent(hostNo, newSate);
            state = oldState != null ? oldState : newSate;
        }
        state.setLanConnPort(lanConnPort);
        state.setLanBroadcastNetAddress(lanBroadcastNetAddress);
        state.setLanBroadcastMills(ServiceUtil.getServiceContext().currentTimeMillis());
    }

    public void updateLanHeartbeat(String hostNo, String lanVersion, InetSocketAddress lanSocketAddress, Map<String, String> lanConnectedEqSatesMap) {
        if (hostNo == null || hostNo.length() == 0) {
            return;
        }
        HostSate state = this.hostSateMap.get(hostNo);
        if (state == null) {
            HostSate newSate = new HostSate();
            newSate.setHostNo(hostNo);
            HostSate oldState = this.hostSateMap.putIfAbsent(hostNo, newSate);
            state = oldState != null ? oldState : newSate;
        }
        state.setLanVersion(lanVersion);
        state.setLanConnectedEqSatesMap(lanConnectedEqSatesMap);
        state.setLanSocketAddress(lanSocketAddress);
        long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
        state.setLanHostHeartBeatMills(currentMills);
        state.setLanHostMills(currentMills);
    }

    public boolean isConnectCloud(String hostNo) {
        HostSate state = this.hostSateMap.get(hostNo);
        if (state == null) {
            return false;
        }
        return ServiceUtil.getServiceContext().currentTimeMillis() - state.getLastCloudMills() <= 30000L;
    }

    public boolean isConnectedLan(String hostNo) {
        return this.getConnectedLanSocektAddress(hostNo) != null;
    }

    public InetSocketAddress getConnectedLanSocektAddress(String hostNo) {
        HostSate state = this.hostSateMap.get(hostNo);
        if (state == null) {
            return null;
        }
        InetSocketAddress lanSocketAddress = state.getLanSocketAddress();
        long lanHostMills = state.getLanHostMills();
        if (lanSocketAddress == null) {
            return null;
        }
        if (ServiceUtil.getServiceContext().currentTimeMillis() - lanHostMills > 6000L) {
            return null;
        }
        return lanSocketAddress;
    }

    public InetSocketAddress getBroadcastReportLanSocketAddress(String hostNo) {
        HostSate state = this.hostSateMap.get(hostNo);
        if (state == null) {
            return null;
        }
        InetAddress lanHostNetAddress = state.getLanBroadcastNetAddress();
        int port = state.getLanConnPort();
        long lanHostMills = state.getLanBroadcastMills();
        if (ServiceUtil.getServiceContext().currentTimeMillis() - lanHostMills > 30000L) {
            return null;
        }
        if (port == 0) {
            return null;
        }
        if (lanHostNetAddress == null) {
            return null;
        }
        try {
            return new InetSocketAddress(lanHostNetAddress, port);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public HostSate getHostSate(String hostNo) {
        return this.hostSateMap.get(hostNo);
    }

    public HostSate getConnectedLanHostSate(String hostNo) {
        HostSate state = this.hostSateMap.get(hostNo);
        if (state == null) {
            return null;
        }
        InetSocketAddress lanSocketAddress = state.getLanSocketAddress();
        long lanHostMills = state.getLanHostMills();
        if (lanSocketAddress == null) {
            return null;
        }
        if (ServiceUtil.getServiceContext().currentTimeMillis() - lanHostMills > 6000L) {
            return null;
        }
        return state;
    }
}

